/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RemoteViews;

@RemoteViews.RemoteView
public class MediaNotificationView
extends FrameLayout {
    private final int mMaxImageSize;
    private final int mImageMinTopMargin;
    private final int mNotificationContentMarginEnd;
    private final int mNotificationContentImageMarginEnd;
    private ImageView mRightIcon;
    private View mActions;
    private View mHeader;
    private View mMainColumn;

    public MediaNotificationView(Context context) {
        this(context, null);
    }

    public MediaNotificationView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MediaNotificationView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        boolean hasIcon;
        int mode = View.MeasureSpec.getMode(widthMeasureSpec);
        boolean bl = hasIcon = this.mRightIcon.getVisibility() != 8;
        if (hasIcon && mode != 0) {
            this.measureChild(this.mActions, widthMeasureSpec, heightMeasureSpec);
            int size = View.MeasureSpec.getSize(widthMeasureSpec);
            size -= this.mActions.getMeasuredWidth();
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.mRightIcon.getLayoutParams();
            int imageEndMargin = layoutParams.getMarginEnd();
            size -= imageEndMargin;
            size = Math.min(size, this.mMaxImageSize);
            layoutParams.width = size = Math.max(size, this.mRightIcon.getMinimumWidth());
            layoutParams.height = size;
            this.mRightIcon.setLayoutParams(layoutParams);
            ViewGroup.MarginLayoutParams mainParams = (ViewGroup.MarginLayoutParams)this.mMainColumn.getLayoutParams();
            int marginEnd = size + imageEndMargin + this.mNotificationContentMarginEnd;
            if (marginEnd != mainParams.getMarginEnd()) {
                mainParams.setMarginEnd(marginEnd);
                this.mMainColumn.setLayoutParams(mainParams);
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        ViewGroup.MarginLayoutParams iconParams = (ViewGroup.MarginLayoutParams)this.mRightIcon.getLayoutParams();
        int topMargin = this.getMeasuredHeight() - this.mRightIcon.getMeasuredHeight() - iconParams.bottomMargin;
        boolean reMeasure = false;
        if (!hasIcon || topMargin >= this.mImageMinTopMargin) {
            reMeasure = this.resetHeaderIndention();
        } else {
            int paddingEnd = this.mNotificationContentImageMarginEnd;
            ViewGroup.MarginLayoutParams headerParams = (ViewGroup.MarginLayoutParams)this.mHeader.getLayoutParams();
            int newMarginEnd = this.mRightIcon.getMeasuredWidth() + iconParams.getMarginEnd();
            if (headerParams.getMarginEnd() != newMarginEnd) {
                headerParams.setMarginEnd(newMarginEnd);
                this.mHeader.setLayoutParams(headerParams);
                reMeasure = true;
            }
            if (this.mHeader.getPaddingEnd() != paddingEnd) {
                this.mHeader.setPaddingRelative(this.mHeader.getPaddingStart(), this.mHeader.getPaddingTop(), paddingEnd, this.mHeader.getPaddingBottom());
                reMeasure = true;
            }
        }
        if (reMeasure) {
            this.measureChildWithMargins(this.mHeader, widthMeasureSpec, 0, heightMeasureSpec, 0);
        }
    }

    private boolean resetHeaderIndention() {
        boolean remeasure = false;
        if (this.mHeader.getPaddingEnd() != this.mNotificationContentMarginEnd) {
            this.mHeader.setPaddingRelative(this.mHeader.getPaddingStart(), this.mHeader.getPaddingTop(), this.mNotificationContentMarginEnd, this.mHeader.getPaddingBottom());
            remeasure = true;
        }
        ViewGroup.MarginLayoutParams headerParams = (ViewGroup.MarginLayoutParams)this.mHeader.getLayoutParams();
        headerParams.setMarginEnd(0);
        if (headerParams.getMarginEnd() != 0) {
            headerParams.setMarginEnd(0);
            this.mHeader.setLayoutParams(headerParams);
            remeasure = true;
        }
        return remeasure;
    }

    public MediaNotificationView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mMaxImageSize = context.getResources().getDimensionPixelSize(17104970);
        this.mImageMinTopMargin = (int)((float)context.getResources().getDimensionPixelSize(17104964) + this.getResources().getDisplayMetrics().density * 2.0f);
        this.mNotificationContentMarginEnd = context.getResources().getDimensionPixelSize(17104960);
        this.mNotificationContentImageMarginEnd = context.getResources().getDimensionPixelSize(17104972);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mRightIcon = (ImageView)this.findViewById(16908356);
        this.mActions = this.findViewById(16909242);
        this.mHeader = this.findViewById(16909231);
        this.mMainColumn = this.findViewById(16909240);
    }
}

