/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HeaderViewListAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.android.internal.util.Predicate;
import java.util.ArrayList;

public class WatchHeaderListView
extends ListView {
    private View mTopPanel;

    public WatchHeaderListView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public WatchHeaderListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public WatchHeaderListView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected HeaderViewListAdapter wrapHeaderListAdapterInternal(ArrayList<ListView.FixedViewInfo> headerViewInfos, ArrayList<ListView.FixedViewInfo> footerViewInfos, ListAdapter adapter) {
        return new WatchHeaderListAdapter(headerViewInfos, footerViewInfos, adapter);
    }

    @Override
    public void addView(View child, ViewGroup.LayoutParams params) {
        if (this.mTopPanel != null) {
            throw new IllegalStateException("WatchHeaderListView can host only one header");
        }
        this.setTopPanel(child);
    }

    public void setTopPanel(View v) {
        this.mTopPanel = v;
        this.wrapAdapterIfNecessary();
    }

    @Override
    public void setAdapter(ListAdapter adapter) {
        super.setAdapter(adapter);
        this.wrapAdapterIfNecessary();
    }

    @Override
    protected View findViewTraversal(int id2) {
        View v = super.findViewTraversal(id2);
        if (v == null && this.mTopPanel != null && !this.mTopPanel.isRootNamespace()) {
            return this.mTopPanel.findViewById(id2);
        }
        return v;
    }

    @Override
    protected View findViewWithTagTraversal(Object tag) {
        View v = super.findViewWithTagTraversal(tag);
        if (v == null && this.mTopPanel != null && !this.mTopPanel.isRootNamespace()) {
            return this.mTopPanel.findViewWithTag(tag);
        }
        return v;
    }

    @Override
    protected View findViewByPredicateTraversal(Predicate<View> predicate, View childToSkip) {
        View v = super.findViewByPredicateTraversal(predicate, childToSkip);
        if (v == null && this.mTopPanel != null && this.mTopPanel != childToSkip && !this.mTopPanel.isRootNamespace()) {
            return this.mTopPanel.findViewByPredicate(predicate);
        }
        return v;
    }

    @Override
    public int getHeaderViewsCount() {
        return this.mTopPanel == null ? super.getHeaderViewsCount() : super.getHeaderViewsCount() + 1;
    }

    private void wrapAdapterIfNecessary() {
        ListAdapter adapter = this.getAdapter();
        if (adapter != null && this.mTopPanel != null) {
            if (!(adapter instanceof WatchHeaderListAdapter)) {
                this.wrapHeaderListAdapterInternal();
            }
            ((WatchHeaderListAdapter)this.getAdapter()).setTopPanel(this.mTopPanel);
            this.dispatchDataSetObserverOnChangedInternal();
        }
    }

    private static class WatchHeaderListAdapter
    extends HeaderViewListAdapter {
        private View mTopPanel;

        public WatchHeaderListAdapter(ArrayList<ListView.FixedViewInfo> headerViewInfos, ArrayList<ListView.FixedViewInfo> footerViewInfos, ListAdapter adapter) {
            super(headerViewInfos, footerViewInfos, adapter);
        }

        public void setTopPanel(View v) {
            this.mTopPanel = v;
        }

        private int getTopPanelCount() {
            return this.mTopPanel == null ? 0 : 1;
        }

        @Override
        public int getCount() {
            return super.getCount() + this.getTopPanelCount();
        }

        @Override
        public boolean areAllItemsEnabled() {
            return this.mTopPanel == null && super.areAllItemsEnabled();
        }

        @Override
        public boolean isEnabled(int position) {
            if (this.mTopPanel != null) {
                if (position == 0) {
                    return false;
                }
                return super.isEnabled(position - 1);
            }
            return super.isEnabled(position);
        }

        @Override
        public Object getItem(int position) {
            if (this.mTopPanel != null) {
                if (position == 0) {
                    return null;
                }
                return super.getItem(position - 1);
            }
            return super.getItem(position);
        }

        @Override
        public long getItemId(int position) {
            int adapterCount;
            int adjPosition;
            int numHeaders = this.getHeadersCount() + this.getTopPanelCount();
            if (this.getWrappedAdapter() != null && position >= numHeaders && (adjPosition = position - numHeaders) < (adapterCount = this.getWrappedAdapter().getCount())) {
                return this.getWrappedAdapter().getItemId(adjPosition);
            }
            return -1L;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            if (this.mTopPanel != null) {
                if (position == 0) {
                    return this.mTopPanel;
                }
                return super.getView(position - 1, convertView, parent);
            }
            return super.getView(position, convertView, parent);
        }

        @Override
        public int getItemViewType(int position) {
            int adapterCount;
            int adjPosition;
            int numHeaders = this.getHeadersCount() + this.getTopPanelCount();
            if (this.getWrappedAdapter() != null && position >= numHeaders && (adjPosition = position - numHeaders) < (adapterCount = this.getWrappedAdapter().getCount())) {
                return this.getWrappedAdapter().getItemViewType(adjPosition);
            }
            return -2;
        }
    }
}

