/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.ByteArray;
import com.android.org.conscrypt.NativeCrypto;
import com.android.org.conscrypt.OpenSSLSessionImpl;
import com.android.org.conscrypt.OpenSSLX509Certificate;
import com.android.org.conscrypt.Platform;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;

abstract class AbstractSessionContext
implements SSLSessionContext {
    private static final int DEFAULT_SESSION_TIMEOUT_SECONDS = 28800;
    volatile int maximumSize;
    volatile int timeout = 28800;
    final long sslCtxNativePointer = NativeCrypto.SSL_CTX_new();
    static final int OPEN_SSL = 1;
    private final Map<ByteArray, SSLSession> sessions = new LinkedHashMap<ByteArray, SSLSession>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<ByteArray, SSLSession> eldest) {
            boolean remove;
            boolean bl = remove = AbstractSessionContext.this.maximumSize > 0 && this.size() > AbstractSessionContext.this.maximumSize;
            if (remove) {
                this.remove(eldest.getKey());
                AbstractSessionContext.this.sessionRemoved(eldest.getValue());
            }
            return false;
        }
    };

    AbstractSessionContext(int maximumSize) {
        this.maximumSize = maximumSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<SSLSession> sessionIterator() {
        Map<ByteArray, SSLSession> map = this.sessions;
        synchronized (map) {
            SSLSession[] array2 = this.sessions.values().toArray(new SSLSession[this.sessions.size()]);
            return Arrays.asList(array2).iterator();
        }
    }

    @Override
    public final Enumeration<byte[]> getIds() {
        final Iterator<SSLSession> i = this.sessionIterator();
        return new Enumeration<byte[]>(){
            private SSLSession next;

            @Override
            public boolean hasMoreElements() {
                if (this.next != null) {
                    return true;
                }
                while (i.hasNext()) {
                    SSLSession session = (SSLSession)i.next();
                    if (!session.isValid()) continue;
                    this.next = session;
                    return true;
                }
                this.next = null;
                return false;
            }

            @Override
            public byte[] nextElement() {
                if (this.hasMoreElements()) {
                    byte[] id2 = this.next.getId();
                    this.next = null;
                    return id2;
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public final int getSessionCacheSize() {
        return this.maximumSize;
    }

    @Override
    public final int getSessionTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trimToSize() {
        Map<ByteArray, SSLSession> map = this.sessions;
        synchronized (map) {
            int size = this.sessions.size();
            if (size > this.maximumSize) {
                int removals = size - this.maximumSize;
                Iterator<SSLSession> i = this.sessions.values().iterator();
                do {
                    SSLSession session = i.next();
                    i.remove();
                    this.sessionRemoved(session);
                } while (--removals > 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSessionTimeout(int seconds) throws IllegalArgumentException {
        if (seconds < 0) {
            throw new IllegalArgumentException("seconds < 0");
        }
        this.timeout = seconds;
        Map<ByteArray, SSLSession> map = this.sessions;
        synchronized (map) {
            Iterator<SSLSession> i = this.sessions.values().iterator();
            while (i.hasNext()) {
                SSLSession session = i.next();
                if (session.isValid()) continue;
                i.remove();
                this.sessionRemoved(session);
            }
        }
    }

    protected abstract void sessionRemoved(SSLSession var1);

    @Override
    public final void setSessionCacheSize(int size) throws IllegalArgumentException {
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        int oldMaximum = this.maximumSize;
        this.maximumSize = size;
        if (size < oldMaximum) {
            this.trimToSize();
        }
    }

    byte[] toBytes(SSLSession session) {
        if (!(session instanceof OpenSSLSessionImpl)) {
            return null;
        }
        OpenSSLSessionImpl sslSession = (OpenSSLSessionImpl)session;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream daos = new DataOutputStream(baos);
            daos.writeInt(1);
            byte[] data = sslSession.getEncoded();
            daos.writeInt(data.length);
            daos.write(data);
            Certificate[] certs = session.getPeerCertificates();
            daos.writeInt(certs.length);
            for (Certificate cert : certs) {
                data = cert.getEncoded();
                daos.writeInt(data.length);
                daos.write(data);
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            System.err.println("Failed to convert saved SSL Session: " + e.getMessage());
            return null;
        }
        catch (CertificateEncodingException e) {
            AbstractSessionContext.log(e);
            return null;
        }
    }

    OpenSSLSessionImpl toSession(byte[] data, String host, int port) {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        DataInputStream dais = new DataInputStream(bais);
        try {
            int type = dais.readInt();
            if (type != 1) {
                AbstractSessionContext.log((Throwable)((Object)new AssertionError((Object)("Unexpected type ID: " + type))));
                return null;
            }
            int length = dais.readInt();
            byte[] sessionData = new byte[length];
            dais.readFully(sessionData);
            int count = dais.readInt();
            X509Certificate[] certs = new X509Certificate[count];
            for (int i = 0; i < count; ++i) {
                length = dais.readInt();
                byte[] certData = new byte[length];
                dais.readFully(certData);
                certs[i] = OpenSSLX509Certificate.fromX509Der(certData);
            }
            return new OpenSSLSessionImpl(sessionData, host, port, certs, this);
        }
        catch (IOException e) {
            AbstractSessionContext.log(e);
            return null;
        }
    }

    protected SSLSession wrapSSLSessionIfNeeded(SSLSession session) {
        if (session instanceof OpenSSLSessionImpl) {
            return Platform.wrapSSLSession((OpenSSLSessionImpl)session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSLSession getSession(byte[] sessionId) {
        SSLSession session;
        if (sessionId == null) {
            throw new NullPointerException("sessionId == null");
        }
        ByteArray key = new ByteArray(sessionId);
        Map<ByteArray, SSLSession> map = this.sessions;
        synchronized (map) {
            session = this.sessions.get(key);
        }
        if (session != null && session.isValid()) {
            if (session instanceof OpenSSLSessionImpl) {
                return Platform.wrapSSLSession((OpenSSLSessionImpl)session);
            }
            return session;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putSession(SSLSession session) {
        byte[] id2 = session.getId();
        if (id2.length == 0) {
            return;
        }
        ByteArray key = new ByteArray(id2);
        Map<ByteArray, SSLSession> map = this.sessions;
        synchronized (map) {
            this.sessions.put(key, session);
        }
    }

    static void log(Throwable t) {
        new Exception("Error converting session", t).printStackTrace();
    }

    protected void finalize() throws Throwable {
        try {
            NativeCrypto.SSL_CTX_free(this.sslCtxNativePointer);
        }
        finally {
            super.finalize();
        }
    }
}

