/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.NativeCrypto;
import com.android.org.conscrypt.OpenSSLKey;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;

public class OpenSSLEngine {
    private static final Object mLoadingLock;
    private final long ctx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenSSLEngine getInstance(String engine) throws IllegalArgumentException {
        long engineCtx;
        if (NativeCrypto.isBoringSSL) {
            return BoringSSL.INSTANCE;
        }
        if (engine == null) {
            throw new NullPointerException("engine == null");
        }
        Object object = mLoadingLock;
        synchronized (object) {
            engineCtx = NativeCrypto.ENGINE_by_id(engine);
            if (engineCtx == 0L) {
                throw new IllegalArgumentException("Unknown ENGINE id: " + engine);
            }
            NativeCrypto.ENGINE_add(engineCtx);
        }
        return new OpenSSLEngine(engineCtx);
    }

    private OpenSSLEngine() {
        this.ctx = 0L;
    }

    private OpenSSLEngine(long engineCtx) {
        this.ctx = engineCtx;
        if (NativeCrypto.ENGINE_init(engineCtx) == 0) {
            NativeCrypto.ENGINE_free(engineCtx);
            throw new IllegalArgumentException("Could not initialize engine");
        }
    }

    public PrivateKey getPrivateKeyById(String id2) throws InvalidKeyException {
        if (id2 == null) {
            throw new NullPointerException("id == null");
        }
        long keyRef = NativeCrypto.ENGINE_load_private_key(this.ctx, id2);
        if (keyRef == 0L) {
            return null;
        }
        OpenSSLKey pkey = new OpenSSLKey(keyRef, this, id2);
        try {
            return pkey.getPrivateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidKeyException(e);
        }
    }

    long getEngineContext() {
        return this.ctx;
    }

    protected void finalize() throws Throwable {
        try {
            if (!NativeCrypto.isBoringSSL) {
                NativeCrypto.ENGINE_finish(this.ctx);
                NativeCrypto.ENGINE_free(this.ctx);
            }
        }
        finally {
            super.finalize();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenSSLEngine)) {
            return false;
        }
        OpenSSLEngine other = (OpenSSLEngine)o;
        if (other.getEngineContext() == this.ctx) {
            return true;
        }
        String id2 = NativeCrypto.ENGINE_get_id(this.ctx);
        if (id2 == null) {
            return false;
        }
        return id2.equals(NativeCrypto.ENGINE_get_id(other.getEngineContext()));
    }

    public int hashCode() {
        return (int)this.ctx;
    }

    static {
        if (!NativeCrypto.isBoringSSL) {
            NativeCrypto.ENGINE_load_dynamic();
        }
        mLoadingLock = new Object();
    }

    private static class BoringSSL {
        public static final OpenSSLEngine INSTANCE = new OpenSSLEngine();

        private BoringSSL() {
        }
    }
}

