/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.os.SystemClock;
import android.util.Slog;

public class AnyMotionDetector {
    private static final String TAG = "AnyMotionDetector";
    private static final boolean DEBUG = false;
    public static final int RESULT_UNKNOWN = -1;
    public static final int RESULT_STATIONARY = 0;
    public static final int RESULT_MOVED = 1;
    private static final int STATE_INACTIVE = 0;
    private static final int STATE_ACTIVE = 1;
    private int mState;
    private final float THRESHOLD_ENERGY = 5.0f;
    private static final long ORIENTATION_MEASUREMENT_DURATION_MILLIS = 2500L;
    private static final long ACCELEROMETER_DATA_TIMEOUT_MILLIS = 3000L;
    private static final long ORIENTATION_MEASUREMENT_INTERVAL_MILLIS = 5000L;
    private static final long WAKELOCK_TIMEOUT_MILLIS = 30000L;
    private static final int STALE_MEASUREMENT_TIMEOUT_MILLIS = 120000;
    private static final int SAMPLING_INTERVAL_MILLIS = 40;
    private final Handler mHandler;
    private final Object mLock = new Object();
    private Sensor mAccelSensor;
    private SensorManager mSensorManager;
    private PowerManager.WakeLock mWakeLock;
    private final float mThresholdAngle;
    private int mNumSufficientSamples;
    private boolean mMeasurementInProgress;
    private Vector3 mCurrentGravityVector = null;
    private Vector3 mPreviousGravityVector = null;
    private RunningSignalStats mRunningStats;
    private DeviceIdleCallback mCallback = null;
    private final SensorEventListener mListener = new SensorEventListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSensorChanged(SensorEvent event) {
            int status = -1;
            Object object = AnyMotionDetector.this.mLock;
            synchronized (object) {
                Vector3 accelDatum = new Vector3(SystemClock.elapsedRealtime(), event.values[0], event.values[1], event.values[2]);
                AnyMotionDetector.this.mRunningStats.accumulate(accelDatum);
                if (AnyMotionDetector.this.mRunningStats.getSampleCount() >= AnyMotionDetector.this.mNumSufficientSamples) {
                    status = AnyMotionDetector.this.stopOrientationMeasurementLocked();
                }
            }
            if (status != -1) {
                AnyMotionDetector.this.mHandler.removeCallbacks(AnyMotionDetector.this.mWakelockTimeout);
                AnyMotionDetector.this.mCallback.onAnyMotionResult(status);
            }
        }

        @Override
        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    };
    private final Runnable mSensorRestart = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = AnyMotionDetector.this.mLock;
            synchronized (object) {
                AnyMotionDetector.this.startOrientationMeasurementLocked();
            }
        }
    };
    private final Runnable mMeasurementTimeout = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int status = -1;
            Object object = AnyMotionDetector.this.mLock;
            synchronized (object) {
                status = AnyMotionDetector.this.stopOrientationMeasurementLocked();
            }
            if (status != -1) {
                AnyMotionDetector.this.mHandler.removeCallbacks(AnyMotionDetector.this.mWakelockTimeout);
                AnyMotionDetector.this.mCallback.onAnyMotionResult(status);
            }
        }
    };
    private final Runnable mWakelockTimeout = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = AnyMotionDetector.this.mLock;
            synchronized (object) {
                AnyMotionDetector.this.stop();
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnyMotionDetector(PowerManager pm, Handler handler, SensorManager sm, DeviceIdleCallback callback, float thresholdAngle) {
        Object object = this.mLock;
        synchronized (object) {
            this.mWakeLock = pm.newWakeLock(1, TAG);
            this.mWakeLock.setReferenceCounted(false);
            this.mHandler = handler;
            this.mSensorManager = sm;
            this.mAccelSensor = this.mSensorManager.getDefaultSensor(1);
            this.mMeasurementInProgress = false;
            this.mState = 0;
            this.mCallback = callback;
            this.mThresholdAngle = thresholdAngle;
            this.mRunningStats = new RunningSignalStats();
            this.mNumSufficientSamples = (int)Math.ceil(62.5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForAnyMotion() {
        if (this.mState != 1) {
            Object object = this.mLock;
            synchronized (object) {
                this.mState = 1;
                this.mCurrentGravityVector = null;
                this.mPreviousGravityVector = null;
                this.mWakeLock.acquire();
                Message wakelockTimeoutMsg = Message.obtain(this.mHandler, this.mWakelockTimeout);
                this.mHandler.sendMessageDelayed(wakelockTimeoutMsg, 30000L);
                this.startOrientationMeasurementLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mState == 1) {
                this.mState = 0;
            }
            if (this.mMeasurementInProgress) {
                this.mMeasurementInProgress = false;
                this.mSensorManager.unregisterListener(this.mListener);
            }
            this.mHandler.removeCallbacks(this.mMeasurementTimeout);
            this.mHandler.removeCallbacks(this.mSensorRestart);
            this.mCurrentGravityVector = null;
            this.mPreviousGravityVector = null;
            if (this.mWakeLock.isHeld()) {
                this.mWakeLock.release();
                this.mHandler.removeCallbacks(this.mWakelockTimeout);
            }
        }
    }

    private void startOrientationMeasurementLocked() {
        if (!this.mMeasurementInProgress && this.mAccelSensor != null) {
            if (this.mSensorManager.registerListener(this.mListener, this.mAccelSensor, 40000)) {
                this.mMeasurementInProgress = true;
                this.mRunningStats.reset();
            }
            Message measurementTimeoutMsg = Message.obtain(this.mHandler, this.mMeasurementTimeout);
            this.mHandler.sendMessageDelayed(measurementTimeoutMsg, 3000L);
        }
    }

    private int stopOrientationMeasurementLocked() {
        int status = -1;
        if (this.mMeasurementInProgress) {
            this.mSensorManager.unregisterListener(this.mListener);
            this.mHandler.removeCallbacks(this.mMeasurementTimeout);
            this.mMeasurementInProgress = false;
            this.mPreviousGravityVector = this.mCurrentGravityVector;
            this.mCurrentGravityVector = this.mRunningStats.getRunningAverage();
            if (this.mRunningStats.getSampleCount() == 0) {
                Slog.w(TAG, "No accelerometer data acquired for orientation measurement.");
            }
            this.mRunningStats.reset();
            status = this.getStationaryStatus();
            if (status != -1) {
                if (this.mWakeLock.isHeld()) {
                    this.mWakeLock.release();
                    this.mHandler.removeCallbacks(this.mWakelockTimeout);
                }
                this.mState = 0;
            } else {
                Message msg = Message.obtain(this.mHandler, this.mSensorRestart);
                this.mHandler.sendMessageDelayed(msg, 5000L);
            }
        }
        return status;
    }

    public int getStationaryStatus() {
        Vector3 currentGravityVectorNormalized;
        if (this.mPreviousGravityVector == null || this.mCurrentGravityVector == null) {
            return -1;
        }
        Vector3 previousGravityVectorNormalized = this.mPreviousGravityVector.normalized();
        float angle = previousGravityVectorNormalized.angleBetween(currentGravityVectorNormalized = this.mCurrentGravityVector.normalized());
        if (angle < this.mThresholdAngle && this.mRunningStats.getEnergy() < 5.0f) {
            return 0;
        }
        if (Float.isNaN(angle)) {
            return 1;
        }
        long diffTime = this.mCurrentGravityVector.timeMillisSinceBoot - this.mPreviousGravityVector.timeMillisSinceBoot;
        if (diffTime > 120000L) {
            return -1;
        }
        return 1;
    }

    private static class RunningSignalStats {
        Vector3 previousVector;
        Vector3 currentVector;
        Vector3 runningSum;
        float energy;
        int sampleCount;

        public RunningSignalStats() {
            this.reset();
        }

        public void reset() {
            this.previousVector = null;
            this.currentVector = null;
            this.runningSum = new Vector3(0L, 0.0f, 0.0f, 0.0f);
            this.energy = 0.0f;
            this.sampleCount = 0;
        }

        public void accumulate(Vector3 v) {
            if (v == null) {
                return;
            }
            ++this.sampleCount;
            this.runningSum = this.runningSum.plus(v);
            this.previousVector = this.currentVector;
            this.currentVector = v;
            if (this.previousVector != null) {
                Vector3 dv = this.currentVector.minus(this.previousVector);
                float incrementalEnergy = dv.x * dv.x + dv.y * dv.y + dv.z * dv.z;
                this.energy += incrementalEnergy;
            }
        }

        public Vector3 getRunningAverage() {
            if (this.sampleCount > 0) {
                return this.runningSum.times(1.0f / (float)this.sampleCount);
            }
            return null;
        }

        public float getEnergy() {
            return this.energy;
        }

        public int getSampleCount() {
            return this.sampleCount;
        }

        public String toString() {
            String msg = "";
            String currentVectorString = this.currentVector == null ? "null" : this.currentVector.toString();
            String previousVectorString = this.previousVector == null ? "null" : this.previousVector.toString();
            msg = msg + "previousVector = " + previousVectorString;
            msg = msg + ", currentVector = " + currentVectorString;
            msg = msg + ", sampleCount = " + this.sampleCount;
            msg = msg + ", energy = " + this.energy;
            return msg;
        }
    }

    public static final class Vector3 {
        public long timeMillisSinceBoot;
        public float x;
        public float y;
        public float z;

        public Vector3(long timeMillisSinceBoot, float x, float y, float z) {
            this.timeMillisSinceBoot = timeMillisSinceBoot;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public float norm() {
            return (float)Math.sqrt(this.dotProduct(this));
        }

        public Vector3 normalized() {
            float mag = this.norm();
            return new Vector3(this.timeMillisSinceBoot, this.x / mag, this.y / mag, this.z / mag);
        }

        public float angleBetween(Vector3 other) {
            Vector3 crossVector = this.cross(other);
            float degrees = Math.abs((float)Math.toDegrees(Math.atan2(crossVector.norm(), this.dotProduct(other))));
            Slog.d(AnyMotionDetector.TAG, "angleBetween: this = " + this.toString() + ", other = " + other.toString() + ", degrees = " + degrees);
            return degrees;
        }

        public Vector3 cross(Vector3 v) {
            return new Vector3(v.timeMillisSinceBoot, this.y * v.z - this.z * v.y, this.z * v.x - this.x * v.z, this.x * v.y - this.y * v.x);
        }

        public String toString() {
            String msg = "";
            msg = msg + "timeMillisSinceBoot=" + this.timeMillisSinceBoot;
            msg = msg + " | x=" + this.x;
            msg = msg + ", y=" + this.y;
            msg = msg + ", z=" + this.z;
            return msg;
        }

        public float dotProduct(Vector3 v) {
            return this.x * v.x + this.y * v.y + this.z * v.z;
        }

        public Vector3 times(float val) {
            return new Vector3(this.timeMillisSinceBoot, this.x * val, this.y * val, this.z * val);
        }

        public Vector3 plus(Vector3 v) {
            return new Vector3(v.timeMillisSinceBoot, this.x + v.x, this.y + v.y, this.z + v.z);
        }

        public Vector3 minus(Vector3 v) {
            return new Vector3(v.timeMillisSinceBoot, this.x - v.x, this.y - v.y, this.z - v.z);
        }
    }

    static interface DeviceIdleCallback {
        public void onAnyMotionResult(int var1);
    }
}

