/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Atlas;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.drawable.Drawable;
import android.os.Environment;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.util.Log;
import android.util.LongSparseArray;
import android.view.GraphicBuffer;
import android.view.IAssetAtlas;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class AssetAtlasService
extends IAssetAtlas.Stub {
    public static final String ASSET_ATLAS_SERVICE = "assetatlas";
    private static final String LOG_TAG = "AssetAtlas";
    private static final boolean DEBUG_ATLAS = true;
    private static final boolean DEBUG_ATLAS_TEXTURE = false;
    private static final int MIN_SIZE = 512;
    private static final int MAX_SIZE = 2048;
    private static final int STEP = 64;
    private static final float PACKING_THRESHOLD = 0.8f;
    private static final int ATLAS_MAP_ENTRY_FIELD_COUNT = 3;
    private static final int GRAPHIC_BUFFER_USAGE = 256;
    private final AtomicBoolean mAtlasReady = new AtomicBoolean(false);
    private final Context mContext;
    private final String mVersionName;
    private GraphicBuffer mBuffer;
    private long[] mAtlasMap;

    public AssetAtlasService(Context context) {
        this.mContext = context;
        this.mVersionName = AssetAtlasService.queryVersionName(context);
        HashSet<Bitmap> bitmaps = new HashSet<Bitmap>(300);
        int totalPixelCount = 0;
        Resources resources = context.getResources();
        LongSparseArray<Drawable.ConstantState> drawables = resources.getPreloadedDrawables();
        int count = drawables.size();
        for (int i = 0; i < count; ++i) {
            try {
                totalPixelCount += drawables.valueAt(i).addAtlasableBitmaps(bitmaps);
                continue;
            }
            catch (Throwable t) {
                Log.e(LOG_TAG, "Failed to fetch preloaded drawable state", t);
                throw t;
            }
        }
        ArrayList<Bitmap> sortedBitmaps = new ArrayList<Bitmap>(bitmaps);
        Collections.sort(sortedBitmaps, new Comparator<Bitmap>(){

            @Override
            public int compare(Bitmap b1, Bitmap b2) {
                if (b1.getWidth() == b2.getWidth()) {
                    return b2.getHeight() - b1.getHeight();
                }
                return b2.getWidth() - b1.getWidth();
            }
        });
        new Thread(new Renderer(sortedBitmaps, totalPixelCount)).start();
    }

    private static String queryVersionName(Context context) {
        try {
            String packageName = context.getPackageName();
            PackageInfo info = context.getPackageManager().getPackageInfo(packageName, 0x10000000);
            return info.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w(LOG_TAG, "Could not get package info", e);
            return null;
        }
    }

    public void systemRunning() {
    }

    private static native boolean nUploadAtlas(GraphicBuffer var0, Bitmap var1);

    @Override
    public boolean isCompatible(int ppid) {
        return ppid == Process.myPpid();
    }

    @Override
    public GraphicBuffer getBuffer() throws RemoteException {
        return this.mAtlasReady.get() ? this.mBuffer : null;
    }

    @Override
    public long[] getMap() throws RemoteException {
        return this.mAtlasReady.get() ? this.mAtlasMap : null;
    }

    private static Configuration computeBestConfiguration(ArrayList<Bitmap> bitmaps, int pixelCount) {
        Log.d(LOG_TAG, "Computing best atlas configuration...");
        long begin = System.nanoTime();
        List<WorkerResult> results = Collections.synchronizedList(new ArrayList());
        int cpuCount = Runtime.getRuntime().availableProcessors();
        if (cpuCount == 1) {
            new ComputeWorker(512, 2048, 64, bitmaps, pixelCount, results, null).run();
        } else {
            boolean isAllWorkerFinished;
            int start = 512 + (cpuCount - 1) * 64;
            int end = 2048;
            int step = 64 * cpuCount;
            CountDownLatch signal = new CountDownLatch(cpuCount);
            int i = 0;
            while (i < cpuCount) {
                ComputeWorker worker = new ComputeWorker(start, end, step, bitmaps, pixelCount, results, signal);
                new Thread((Runnable)worker, "Atlas Worker #" + (i + 1)).start();
                ++i;
                start -= 64;
                end -= 64;
            }
            try {
                isAllWorkerFinished = signal.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Log.w(LOG_TAG, "Could not complete configuration computation");
                return null;
            }
            if (!isAllWorkerFinished) {
                Log.w(LOG_TAG, "Could not complete configuration computation before timeout.");
                return null;
            }
        }
        Collections.sort(results, new Comparator<WorkerResult>(){

            @Override
            public int compare(WorkerResult r1, WorkerResult r2) {
                int delta = r2.count - r1.count;
                if (delta != 0) {
                    return delta;
                }
                return r1.width * r1.height - r2.width * r2.height;
            }
        });
        float delay = (float)(System.nanoTime() - begin) / 1000.0f / 1000.0f / 1000.0f;
        Log.d(LOG_TAG, String.format("Found best atlas configuration (out of %d) in %.2fs", results.size(), Float.valueOf(delay)));
        WorkerResult result = results.get(0);
        return new Configuration(result.type, result.width, result.height, result.count);
    }

    private static File getDataFile() {
        File systemDirectory = new File(Environment.getDataDirectory(), "system");
        return new File(systemDirectory, "framework_atlas.config");
    }

    private static void deleteDataFile() {
        Log.w(LOG_TAG, "Current configuration inconsistent with assets list");
        if (!AssetAtlasService.getDataFile().delete()) {
            Log.w(LOG_TAG, "Could not delete the current configuration");
        }
    }

    private File getFrameworkResourcesFile() {
        return new File(this.mContext.getApplicationInfo().sourceDir);
    }

    private Configuration chooseConfiguration(ArrayList<Bitmap> bitmaps, int pixelCount, String versionName) {
        Configuration config = null;
        File dataFile = AssetAtlasService.getDataFile();
        if (dataFile.exists()) {
            config = this.readConfiguration(dataFile, versionName);
        }
        if (config == null && (config = AssetAtlasService.computeBestConfiguration(bitmaps, pixelCount)) != null) {
            this.writeConfiguration(config, dataFile, versionName);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeConfiguration(Configuration config, File file, String versionName) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            writer.write(this.getBuildIdentifier(versionName));
            writer.newLine();
            writer.write(config.type.toString());
            writer.newLine();
            writer.write(String.valueOf(config.width));
            writer.newLine();
            writer.write(String.valueOf(config.height));
            writer.newLine();
            writer.write(String.valueOf(config.count));
            writer.newLine();
            writer.write(String.valueOf(config.flags));
            writer.newLine();
        }
        catch (FileNotFoundException e) {
            Log.w(LOG_TAG, "Could not write " + file, e);
        }
        catch (IOException e) {
            Log.w(LOG_TAG, "Could not write " + file, e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Configuration readConfiguration(File file, String versionName) {
        BufferedReader reader = null;
        Configuration config = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            if (this.checkBuildIdentifier(reader, versionName)) {
                Atlas.Type type = Atlas.Type.valueOf(reader.readLine());
                int width = AssetAtlasService.readInt(reader, 512, 2048);
                int height = AssetAtlasService.readInt(reader, 512, 2048);
                int count = AssetAtlasService.readInt(reader, 0, Integer.MAX_VALUE);
                int flags = AssetAtlasService.readInt(reader, Integer.MIN_VALUE, Integer.MAX_VALUE);
                config = new Configuration(type, width, height, count, flags);
            }
        }
        catch (IllegalArgumentException e) {
            Log.w(LOG_TAG, "Invalid parameter value in " + file, e);
        }
        catch (FileNotFoundException e) {
            Log.w(LOG_TAG, "Could not read " + file, e);
        }
        catch (IOException e) {
            Log.w(LOG_TAG, "Could not read " + file, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return config;
    }

    private static int readInt(BufferedReader reader, int min, int max) throws IOException {
        return Math.max(min, Math.min(max, Integer.parseInt(reader.readLine())));
    }

    private boolean checkBuildIdentifier(BufferedReader reader, String versionName) throws IOException {
        String deviceBuildId = this.getBuildIdentifier(versionName);
        String buildId = reader.readLine();
        return deviceBuildId.equals(buildId);
    }

    private String getBuildIdentifier(String versionName) {
        return SystemProperties.get("ro.build.fingerprint", "") + '/' + versionName + '/' + String.valueOf(this.getFrameworkResourcesFile().length());
    }

    static /* synthetic */ long[] access$402(AssetAtlasService x0, long[] x1) {
        x0.mAtlasMap = x1;
        return x1;
    }

    private static class ComputeWorker
    implements Runnable {
        private final int mStart;
        private final int mEnd;
        private final int mStep;
        private final List<Bitmap> mBitmaps;
        private final List<WorkerResult> mResults;
        private final CountDownLatch mSignal;
        private final int mThreshold;

        ComputeWorker(int start, int end, int step, List<Bitmap> bitmaps, int pixelCount, List<WorkerResult> results, CountDownLatch signal) {
            int threshold;
            this.mStart = start;
            this.mEnd = end;
            this.mStep = step;
            this.mBitmaps = bitmaps;
            this.mResults = results;
            this.mSignal = signal;
            for (threshold = (int)((float)pixelCount * 0.8f); threshold > 0x400000; threshold >>= 1) {
            }
            this.mThreshold = threshold;
        }

        @Override
        public void run() {
            Log.d(AssetAtlasService.LOG_TAG, "Running " + Thread.currentThread().getName());
            Atlas.Entry entry = new Atlas.Entry();
            block0: for (int width = this.mEnd; width > this.mStart; width -= this.mStep) {
                for (int height = 2048; height > 512; height -= 64) {
                    if (width * height <= this.mThreshold) continue;
                    boolean packSuccess = false;
                    for (Atlas.Type type : Atlas.Type.values()) {
                        int count = this.packBitmaps(type, width, height, entry);
                        if (count <= 0) continue;
                        this.mResults.add(new WorkerResult(type, width, height, count));
                        if (count != this.mBitmaps.size()) continue;
                        packSuccess = true;
                        break;
                    }
                    if (!packSuccess) continue block0;
                }
            }
            if (this.mSignal != null) {
                this.mSignal.countDown();
            }
        }

        private int packBitmaps(Atlas.Type type, int width, int height, Atlas.Entry entry) {
            int total = 0;
            Atlas atlas = new Atlas(type, width, height);
            int count = this.mBitmaps.size();
            for (int i = 0; i < count; ++i) {
                Bitmap bitmap = this.mBitmaps.get(i);
                if (atlas.pack(bitmap.getWidth(), bitmap.getHeight(), entry) == null) continue;
                ++total;
            }
            return total;
        }
    }

    private static class WorkerResult {
        Atlas.Type type;
        int width;
        int height;
        int count;

        WorkerResult(Atlas.Type type, int width, int height, int count) {
            this.type = type;
            this.width = width;
            this.height = height;
            this.count = count;
        }

        public String toString() {
            return String.format("%s %dx%d", this.type.toString(), this.width, this.height);
        }
    }

    private static class Configuration {
        final Atlas.Type type;
        final int width;
        final int height;
        final int count;
        final int flags;

        Configuration(Atlas.Type type, int width, int height, int count) {
            this(type, width, height, count, 2);
        }

        Configuration(Atlas.Type type, int width, int height, int count, int flags) {
            this.type = type;
            this.width = width;
            this.height = height;
            this.count = count;
            this.flags = flags;
        }

        public String toString() {
            return this.type.toString() + " (" + this.width + "x" + this.height + ") flags=0x" + Integer.toHexString(this.flags) + " count=" + this.count;
        }
    }

    private class Renderer
    implements Runnable {
        private final ArrayList<Bitmap> mBitmaps;
        private final int mPixelCount;

        Renderer(ArrayList<Bitmap> bitmaps, int pixelCount) {
            this.mBitmaps = bitmaps;
            this.mPixelCount = pixelCount;
        }

        @Override
        public void run() {
            Configuration config = AssetAtlasService.this.chooseConfiguration(this.mBitmaps, this.mPixelCount, AssetAtlasService.this.mVersionName);
            Log.d(AssetAtlasService.LOG_TAG, "Loaded configuration: " + config);
            if (config != null) {
                AssetAtlasService.this.mBuffer = GraphicBuffer.create(config.width, config.height, 1, 256);
                if (AssetAtlasService.this.mBuffer != null) {
                    Atlas atlas = new Atlas(config.type, config.width, config.height, config.flags);
                    if (this.renderAtlas(AssetAtlasService.this.mBuffer, atlas, config.count)) {
                        AssetAtlasService.this.mAtlasReady.set(true);
                    }
                }
            }
        }

        private boolean renderAtlas(GraphicBuffer buffer, Atlas atlas, int packCount) {
            Paint paint = new Paint();
            paint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.SRC));
            Bitmap atlasBitmap = Bitmap.createBitmap(buffer.getWidth(), buffer.getHeight(), Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(atlasBitmap);
            Atlas.Entry entry = new Atlas.Entry();
            AssetAtlasService.access$402(AssetAtlasService.this, new long[packCount * 3]);
            long[] atlasMap = AssetAtlasService.this.mAtlasMap;
            int mapIndex = 0;
            boolean result = false;
            long startRender = System.nanoTime();
            int count = this.mBitmaps.size();
            for (int i = 0; i < count; ++i) {
                Bitmap bitmap = this.mBitmaps.get(i);
                if (atlas.pack(bitmap.getWidth(), bitmap.getHeight(), entry) == null) continue;
                if (mapIndex >= AssetAtlasService.this.mAtlasMap.length) {
                    AssetAtlasService.deleteDataFile();
                    break;
                }
                canvas.save();
                canvas.translate(entry.x, entry.y);
                canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
                canvas.restore();
                atlasMap[mapIndex++] = bitmap.refSkPixelRef();
                atlasMap[mapIndex++] = entry.x;
                atlasMap[mapIndex++] = entry.y;
            }
            long endRender = System.nanoTime();
            this.releaseCanvas(canvas, atlasBitmap);
            result = AssetAtlasService.nUploadAtlas(buffer, atlasBitmap);
            atlasBitmap.recycle();
            long endUpload = System.nanoTime();
            float renderDuration = (float)(endRender - startRender) / 1000.0f / 1000.0f;
            float uploadDuration = (float)(endUpload - endRender) / 1000.0f / 1000.0f;
            Log.d(AssetAtlasService.LOG_TAG, String.format("Rendered atlas in %.2fms (%.2f+%.2fms)", Float.valueOf(renderDuration + uploadDuration), Float.valueOf(renderDuration), Float.valueOf(uploadDuration)));
            return result;
        }

        private void releaseCanvas(Canvas canvas, Bitmap atlasBitmap) {
            canvas.setBitmap(null);
        }
    }
}

