/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManager;
import android.bluetooth.IBluetooth;
import android.bluetooth.IBluetoothCallback;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothHeadset;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothManagerCallback;
import android.bluetooth.IBluetoothProfileServiceConnection;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.database.ContentObserver;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.util.Slog;
import com.android.server.IoThread;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class BluetoothManagerService
extends IBluetoothManager.Stub {
    private static final String TAG = "BluetoothManagerService";
    private static final boolean DBG = true;
    private static final String BLUETOOTH_ADMIN_PERM = "android.permission.BLUETOOTH_ADMIN";
    private static final String BLUETOOTH_PERM = "android.permission.BLUETOOTH";
    private static final String ACTION_SERVICE_STATE_CHANGED = "com.android.bluetooth.btservice.action.STATE_CHANGED";
    private static final String EXTRA_ACTION = "action";
    private static final String SECURE_SETTINGS_BLUETOOTH_ADDR_VALID = "bluetooth_addr_valid";
    private static final String SECURE_SETTINGS_BLUETOOTH_ADDRESS = "bluetooth_address";
    private static final String SECURE_SETTINGS_BLUETOOTH_NAME = "bluetooth_name";
    private static final int TIMEOUT_BIND_MS = 3000;
    private static final int TIMEOUT_SAVE_MS = 500;
    private static final int SERVICE_RESTART_TIME_MS = 200;
    private static final int ERROR_RESTART_TIME_MS = 3000;
    private static final int USER_SWITCHED_TIME_MS = 200;
    private static final int ADD_PROXY_DELAY_MS = 100;
    private static final int MESSAGE_ENABLE = 1;
    private static final int MESSAGE_DISABLE = 2;
    private static final int MESSAGE_REGISTER_ADAPTER = 20;
    private static final int MESSAGE_UNREGISTER_ADAPTER = 21;
    private static final int MESSAGE_REGISTER_STATE_CHANGE_CALLBACK = 30;
    private static final int MESSAGE_UNREGISTER_STATE_CHANGE_CALLBACK = 31;
    private static final int MESSAGE_BLUETOOTH_SERVICE_CONNECTED = 40;
    private static final int MESSAGE_BLUETOOTH_SERVICE_DISCONNECTED = 41;
    private static final int MESSAGE_RESTART_BLUETOOTH_SERVICE = 42;
    private static final int MESSAGE_BLUETOOTH_STATE_CHANGE = 60;
    private static final int MESSAGE_TIMEOUT_BIND = 100;
    private static final int MESSAGE_TIMEOUT_UNBIND = 101;
    private static final int MESSAGE_GET_NAME_AND_ADDRESS = 200;
    private static final int MESSAGE_USER_SWITCHED = 300;
    private static final int MESSAGE_USER_UNLOCKED = 301;
    private static final int MESSAGE_ADD_PROXY_DELAYED = 400;
    private static final int MESSAGE_BIND_PROFILE_SERVICE = 401;
    private static final int MAX_SAVE_RETRIES = 3;
    private static final int MAX_ERROR_RESTART_RETRIES = 6;
    private static final int BLUETOOTH_OFF = 0;
    private static final int BLUETOOTH_ON_BLUETOOTH = 1;
    private static final int BLUETOOTH_ON_AIRPLANE = 2;
    private static final int SERVICE_IBLUETOOTH = 1;
    private static final int SERVICE_IBLUETOOTHGATT = 2;
    private final Context mContext;
    private static int mBleAppCount = 0;
    private String mAddress;
    private String mName;
    private final ContentResolver mContentResolver;
    private final RemoteCallbackList<IBluetoothManagerCallback> mCallbacks;
    private final RemoteCallbackList<IBluetoothStateChangeCallback> mStateChangeCallbacks;
    private IBinder mBluetoothBinder;
    private IBluetooth mBluetooth;
    private IBluetoothGatt mBluetoothGatt;
    private final ReentrantReadWriteLock mBluetoothLock = new ReentrantReadWriteLock();
    private boolean mBinding;
    private boolean mUnbinding;
    private boolean mQuietEnable = false;
    private boolean mQuietEnableExternal;
    private boolean mEnableExternal;
    private boolean mEnable;
    private int mState;
    private final BluetoothHandler mHandler;
    private int mErrorRecoveryRetryCounter;
    private final int mSystemUiUid;
    private final Map<Integer, ProfileServiceConnections> mProfileServices = new HashMap<Integer, ProfileServiceConnections>();
    private final IBluetoothCallback mBluetoothCallback = new IBluetoothCallback.Stub(){

        @Override
        public void onBluetoothStateChange(int prevState, int newState) throws RemoteException {
            Message msg = BluetoothManagerService.this.mHandler.obtainMessage(60, prevState, newState);
            BluetoothManagerService.this.mHandler.sendMessage(msg);
        }
    };
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.bluetooth.adapter.action.LOCAL_NAME_CHANGED".equals(action)) {
                String newName = intent.getStringExtra("android.bluetooth.adapter.extra.LOCAL_NAME");
                Slog.d(BluetoothManagerService.TAG, "Bluetooth Adapter name changed to " + newName);
                if (newName == null) return;
                BluetoothManagerService.this.storeNameAndAddress(newName, null);
                return;
            }
            if (!"android.intent.action.AIRPLANE_MODE".equals(action)) return;
            BroadcastReceiver broadcastReceiver = BluetoothManagerService.this.mReceiver;
            synchronized (broadcastReceiver) {
                if (BluetoothManagerService.this.isBluetoothPersistedStateOn()) {
                    if (BluetoothManagerService.this.isAirplaneModeOn()) {
                        BluetoothManagerService.this.persistBluetoothSetting(2);
                    } else {
                        BluetoothManagerService.this.persistBluetoothSetting(1);
                    }
                }
                int st = 10;
                try {
                    BluetoothManagerService.this.mBluetoothLock.readLock().lock();
                    if (BluetoothManagerService.this.mBluetooth != null) {
                        st = BluetoothManagerService.this.mBluetooth.getState();
                    }
                }
                catch (RemoteException e) {
                    Slog.e(BluetoothManagerService.TAG, "Unable to call getState", e);
                }
                finally {
                    BluetoothManagerService.this.mBluetoothLock.readLock().unlock();
                }
                Slog.d(BluetoothManagerService.TAG, "state" + st);
                if (BluetoothManagerService.this.isAirplaneModeOn()) {
                    2 e = this;
                    synchronized (e) {
                        mBleAppCount = 0;
                        BluetoothManagerService.this.mBleApps.clear();
                    }
                    if (st == 15) {
                        try {
                            BluetoothManagerService.this.mBluetoothLock.readLock().lock();
                            if (BluetoothManagerService.this.mBluetooth == null) return;
                            BluetoothManagerService.this.mBluetooth.onBrEdrDown();
                            BluetoothManagerService.this.mEnableExternal = false;
                        }
                        catch (RemoteException e2) {
                            Slog.e(BluetoothManagerService.TAG, "Unable to call onBrEdrDown", e2);
                        }
                        finally {
                            BluetoothManagerService.this.mBluetoothLock.readLock().unlock();
                        }
                    } else {
                        if (st != 12) return;
                        Slog.d(BluetoothManagerService.TAG, "Calling disable");
                        BluetoothManagerService.this.sendDisableMsg();
                    }
                } else {
                    if (!BluetoothManagerService.this.mEnableExternal) return;
                    Slog.d(BluetoothManagerService.TAG, "Calling enable");
                    BluetoothManagerService.this.sendEnableMsg(BluetoothManagerService.this.mQuietEnableExternal);
                }
                return;
            }
        }
    };
    Map<IBinder, ClientDeathRecipient> mBleApps = new HashMap<IBinder, ClientDeathRecipient>();
    private BluetoothServiceConnection mConnection = new BluetoothServiceConnection();

    private void registerForAirplaneMode(IntentFilter filter) {
        boolean mIsAirplaneSensitive;
        ContentResolver resolver = this.mContext.getContentResolver();
        String airplaneModeRadios = Settings.Global.getString(resolver, "airplane_mode_radios");
        String toggleableRadios = Settings.Global.getString(resolver, "airplane_mode_toggleable_radios");
        boolean bl = mIsAirplaneSensitive = airplaneModeRadios == null ? true : airplaneModeRadios.contains("bluetooth");
        if (mIsAirplaneSensitive) {
            filter.addAction("android.intent.action.AIRPLANE_MODE");
        }
    }

    BluetoothManagerService(Context context) {
        this.mHandler = new BluetoothHandler(IoThread.get().getLooper());
        this.mContext = context;
        this.mBluetooth = null;
        this.mBluetoothBinder = null;
        this.mBluetoothGatt = null;
        this.mBinding = false;
        this.mUnbinding = false;
        this.mEnable = false;
        this.mState = 10;
        this.mQuietEnableExternal = false;
        this.mEnableExternal = false;
        this.mAddress = null;
        this.mName = null;
        this.mErrorRecoveryRetryCounter = 0;
        this.mContentResolver = context.getContentResolver();
        this.registerForBleScanModeChange();
        this.mCallbacks = new RemoteCallbackList();
        this.mStateChangeCallbacks = new RemoteCallbackList();
        IntentFilter filter = new IntentFilter("android.bluetooth.adapter.action.LOCAL_NAME_CHANGED");
        this.registerForAirplaneMode(filter);
        filter.setPriority(1000);
        this.mContext.registerReceiver(this.mReceiver, filter);
        this.loadStoredNameAndAddress();
        if (this.isBluetoothPersistedStateOn()) {
            this.mEnableExternal = true;
        }
        int sysUiUid = -1;
        try {
            sysUiUid = this.mContext.getPackageManager().getPackageUidAsUser("com.android.systemui", 0x100000, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.w(TAG, "Unable to resolve SystemUI's UID.", e);
        }
        this.mSystemUiUid = sysUiUid;
    }

    private final boolean isAirplaneModeOn() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "airplane_mode_on", 0) == 1;
    }

    private final boolean isBluetoothPersistedStateOn() {
        return Settings.Global.getInt(this.mContentResolver, "bluetooth_on", 0) != 0;
    }

    private final boolean isBluetoothPersistedStateOnBluetooth() {
        return Settings.Global.getInt(this.mContentResolver, "bluetooth_on", 0) == 1;
    }

    private void persistBluetoothSetting(int value) {
        Settings.Global.putInt(this.mContext.getContentResolver(), "bluetooth_on", value);
    }

    private boolean isNameAndAddressSet() {
        return this.mName != null && this.mAddress != null && this.mName.length() > 0 && this.mAddress.length() > 0;
    }

    private void loadStoredNameAndAddress() {
        Slog.d(TAG, "Loading stored name and address");
        if (this.mContext.getResources().getBoolean(17956951) && Settings.Secure.getInt(this.mContentResolver, SECURE_SETTINGS_BLUETOOTH_ADDR_VALID, 0) == 0) {
            Slog.d(TAG, "invalid bluetooth name and address stored");
            return;
        }
        this.mName = Settings.Secure.getString(this.mContentResolver, SECURE_SETTINGS_BLUETOOTH_NAME);
        this.mAddress = Settings.Secure.getString(this.mContentResolver, SECURE_SETTINGS_BLUETOOTH_ADDRESS);
        Slog.d(TAG, "Stored bluetooth Name=" + this.mName + ",Address=" + this.mAddress);
    }

    private void storeNameAndAddress(String name, String address) {
        if (name != null) {
            Settings.Secure.putString(this.mContentResolver, SECURE_SETTINGS_BLUETOOTH_NAME, name);
            this.mName = name;
            Slog.d(TAG, "Stored Bluetooth name: " + Settings.Secure.getString(this.mContentResolver, SECURE_SETTINGS_BLUETOOTH_NAME));
        }
        if (address != null) {
            Settings.Secure.putString(this.mContentResolver, SECURE_SETTINGS_BLUETOOTH_ADDRESS, address);
            this.mAddress = address;
            Slog.d(TAG, "Stored Bluetoothaddress: " + Settings.Secure.getString(this.mContentResolver, SECURE_SETTINGS_BLUETOOTH_ADDRESS));
        }
        if (name != null && address != null) {
            Settings.Secure.putInt(this.mContentResolver, SECURE_SETTINGS_BLUETOOTH_ADDR_VALID, 1);
        }
    }

    @Override
    public IBluetooth registerAdapter(IBluetoothManagerCallback callback) {
        if (callback == null) {
            Slog.w(TAG, "Callback is null in registerAdapter");
            return null;
        }
        Message msg = this.mHandler.obtainMessage(20);
        msg.obj = callback;
        this.mHandler.sendMessage(msg);
        return this.mBluetooth;
    }

    @Override
    public void unregisterAdapter(IBluetoothManagerCallback callback) {
        if (callback == null) {
            Slog.w(TAG, "Callback is null in unregisterAdapter");
            return;
        }
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        Message msg = this.mHandler.obtainMessage(21);
        msg.obj = callback;
        this.mHandler.sendMessage(msg);
    }

    @Override
    public void registerStateChangeCallback(IBluetoothStateChangeCallback callback) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        Message msg = this.mHandler.obtainMessage(30);
        msg.obj = callback;
        this.mHandler.sendMessage(msg);
    }

    @Override
    public void unregisterStateChangeCallback(IBluetoothStateChangeCallback callback) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        Message msg = this.mHandler.obtainMessage(31);
        msg.obj = callback;
        this.mHandler.sendMessage(msg);
    }

    @Override
    public boolean isEnabled() {
        if (Binder.getCallingUid() != 1000 && !this.checkIfCallerIsForegroundUser()) {
            Slog.w(TAG, "isEnabled(): not allowed for non-active and non system user");
            return false;
        }
        try {
            this.mBluetoothLock.readLock().lock();
            if (this.mBluetooth != null) {
                boolean bl = this.mBluetooth.isEnabled();
                return bl;
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "isEnabled()", e);
        }
        finally {
            this.mBluetoothLock.readLock().unlock();
        }
        return false;
    }

    @Override
    public int getState() {
        if (Binder.getCallingUid() != 1000 && !this.checkIfCallerIsForegroundUser()) {
            Slog.w(TAG, "getState(): not allowed for non-active and non system user");
            return 10;
        }
        try {
            this.mBluetoothLock.readLock().lock();
            if (this.mBluetooth != null) {
                int n = this.mBluetooth.getState();
                return n;
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "getState()", e);
        }
        finally {
            this.mBluetoothLock.readLock().unlock();
        }
        return 10;
    }

    @Override
    public boolean isBleScanAlwaysAvailable() {
        try {
            return Settings.Global.getInt(this.mContentResolver, "ble_scan_always_enabled") != 0;
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            return false;
        }
    }

    private void registerForBleScanModeChange() {
        ContentObserver contentObserver = new ContentObserver(null){

            @Override
            public void onChange(boolean selfChange) {
                if (!BluetoothManagerService.this.isBleScanAlwaysAvailable()) {
                    BluetoothManagerService.this.disableBleScanMode();
                    BluetoothManagerService.this.clearBleApps();
                    try {
                        BluetoothManagerService.this.mBluetoothLock.readLock().lock();
                        if (BluetoothManagerService.this.mBluetooth != null) {
                            BluetoothManagerService.this.mBluetooth.onBrEdrDown();
                        }
                    }
                    catch (RemoteException e) {
                        Slog.e(BluetoothManagerService.TAG, "error when disabling bluetooth", e);
                    }
                    finally {
                        BluetoothManagerService.this.mBluetoothLock.readLock().unlock();
                    }
                }
            }
        };
        this.mContentResolver.registerContentObserver(Settings.Global.getUriFor("ble_scan_always_enabled"), false, contentObserver);
    }

    private void disableBleScanMode() {
        try {
            this.mBluetoothLock.writeLock().lock();
            if (this.mBluetooth != null && this.mBluetooth.getState() != 12) {
                Slog.d(TAG, "Reseting the mEnable flag for clean disable");
                this.mEnable = false;
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "getState()", e);
        }
        finally {
            this.mBluetoothLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateBleAppCount(IBinder token, boolean enable) {
        if (enable) {
            ClientDeathRecipient r = this.mBleApps.get(token);
            if (r == null) {
                ClientDeathRecipient deathRec = new ClientDeathRecipient();
                try {
                    token.linkToDeath(deathRec, 0);
                }
                catch (RemoteException ex) {
                    throw new IllegalArgumentException("Wake lock is already dead.");
                }
                this.mBleApps.put(token, deathRec);
                BluetoothManagerService bluetoothManagerService = this;
                synchronized (bluetoothManagerService) {
                    ++mBleAppCount;
                }
                Slog.d(TAG, "Registered for death Notification");
            }
        } else {
            ClientDeathRecipient r = this.mBleApps.get(token);
            if (r != null) {
                token.unlinkToDeath(r, 0);
                this.mBleApps.remove(token);
                BluetoothManagerService bluetoothManagerService = this;
                synchronized (bluetoothManagerService) {
                    if (mBleAppCount > 0) {
                        --mBleAppCount;
                    }
                }
                Slog.d(TAG, "Unregistered for death Notification");
            }
        }
        Slog.d(TAG, "Updated BleAppCount" + mBleAppCount);
        if (mBleAppCount == 0 && this.mEnable) {
            this.disableBleScanMode();
        }
        return mBleAppCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearBleApps() {
        BluetoothManagerService bluetoothManagerService = this;
        synchronized (bluetoothManagerService) {
            this.mBleApps.clear();
            mBleAppCount = 0;
        }
    }

    @Override
    public boolean isBleAppPresent() {
        Slog.d(TAG, "isBleAppPresent() count: " + mBleAppCount);
        return mBleAppCount > 0;
    }

    private void onBluetoothGattServiceUp() {
        Slog.d(TAG, "BluetoothGatt Service is Up");
        try {
            this.mBluetoothLock.readLock().lock();
            if (!this.isBleAppPresent() && this.mBluetooth != null && this.mBluetooth.getState() == 15) {
                this.mBluetooth.onLeServiceUp();
                long callingIdentity = Binder.clearCallingIdentity();
                this.persistBluetoothSetting(1);
                Binder.restoreCallingIdentity(callingIdentity);
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Unable to call onServiceUp", e);
        }
        finally {
            this.mBluetoothLock.readLock().unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendBrEdrDownCallback() {
        Slog.d(TAG, "Calling sendBrEdrDownCallback callbacks");
        if (this.mBluetooth == null) {
            Slog.w(TAG, "Bluetooth handle is null");
            return;
        }
        if (!this.isBleAppPresent()) {
            try {
                this.mBluetoothLock.readLock().lock();
                if (this.mBluetooth == null) return;
                this.mBluetooth.onBrEdrDown();
                return;
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Call to onBrEdrDown() failed.", e);
                return;
            }
            finally {
                this.mBluetoothLock.readLock().unlock();
            }
        }
        try {
            this.mBluetoothGatt.unregAll();
            return;
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Unable to disconnect all apps.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean enableNoAutoConnect() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH ADMIN permission");
        Slog.d(TAG, "enableNoAutoConnect():  mBluetooth =" + this.mBluetooth + " mBinding = " + this.mBinding);
        int callingAppId = UserHandle.getAppId(Binder.getCallingUid());
        if (callingAppId != 1027) {
            throw new SecurityException("no permission to enable Bluetooth quietly");
        }
        BroadcastReceiver broadcastReceiver = this.mReceiver;
        synchronized (broadcastReceiver) {
            this.mQuietEnableExternal = true;
            this.mEnableExternal = true;
            this.sendEnableMsg(true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean enable() {
        if (Binder.getCallingUid() != 1000 && !this.checkIfCallerIsForegroundUser()) {
            Slog.w(TAG, "enable(): not allowed for non-active and non system user");
            return false;
        }
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH ADMIN permission");
        Slog.d(TAG, "enable():  mBluetooth =" + this.mBluetooth + " mBinding = " + this.mBinding + " mState = " + this.mState);
        BroadcastReceiver broadcastReceiver = this.mReceiver;
        synchronized (broadcastReceiver) {
            this.mQuietEnableExternal = false;
            this.mEnableExternal = true;
            this.sendEnableMsg(false);
        }
        Slog.d(TAG, "enable returning");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean disable(boolean persist) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH ADMIN permissicacheNameAndAddresson");
        if (Binder.getCallingUid() != 1000 && !this.checkIfCallerIsForegroundUser()) {
            Slog.w(TAG, "disable(): not allowed for non-active and non system user");
            return false;
        }
        Slog.d(TAG, "disable(): mBluetooth = " + this.mBluetooth + " mBinding = " + this.mBinding);
        BroadcastReceiver broadcastReceiver = this.mReceiver;
        synchronized (broadcastReceiver) {
            if (persist) {
                long callingIdentity = Binder.clearCallingIdentity();
                this.persistBluetoothSetting(0);
                Binder.restoreCallingIdentity(callingIdentity);
            }
            this.mEnableExternal = false;
            this.sendDisableMsg();
        }
        return true;
    }

    public void unbindAndFinish() {
        Slog.d(TAG, "unbindAndFinish(): " + this.mBluetooth + " mBinding = " + this.mBinding);
        try {
            this.mBluetoothLock.writeLock().lock();
            if (this.mUnbinding) {
                return;
            }
            this.mUnbinding = true;
            this.mHandler.removeMessages(60);
            if (this.mBluetooth != null) {
                try {
                    this.mBluetooth.unregisterCallback(this.mBluetoothCallback);
                }
                catch (RemoteException re) {
                    Slog.e(TAG, "Unable to unregister BluetoothCallback", re);
                }
                Slog.d(TAG, "Sending unbind request.");
                this.mBluetoothBinder = null;
                this.mBluetooth = null;
                this.mContext.unbindService(this.mConnection);
                this.mUnbinding = false;
                this.mBinding = false;
            } else {
                this.mUnbinding = false;
            }
            this.mBluetoothGatt = null;
        }
        finally {
            this.mBluetoothLock.writeLock().unlock();
        }
    }

    @Override
    public IBluetoothGatt getBluetoothGatt() {
        return this.mBluetoothGatt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean bindBluetoothProfileService(int bluetoothProfile, IBluetoothProfileServiceConnection proxy) {
        if (!this.mEnable) {
            Slog.d(TAG, "Trying to bind to profile: " + bluetoothProfile + ", while Bluetooth was disabled");
            return false;
        }
        Map<Integer, ProfileServiceConnections> map = this.mProfileServices;
        synchronized (map) {
            ProfileServiceConnections psc = this.mProfileServices.get(new Integer(bluetoothProfile));
            if (psc == null) {
                Slog.d(TAG, "Creating new ProfileServiceConnections object for profile: " + bluetoothProfile);
                if (bluetoothProfile != 1) {
                    return false;
                }
                Intent intent = new Intent(IBluetoothHeadset.class.getName());
                psc = new ProfileServiceConnections(intent);
                if (!psc.bindService()) {
                    return false;
                }
                this.mProfileServices.put(new Integer(bluetoothProfile), psc);
            }
        }
        Message addProxyMsg = this.mHandler.obtainMessage(400);
        addProxyMsg.arg1 = bluetoothProfile;
        addProxyMsg.obj = proxy;
        this.mHandler.sendMessageDelayed(addProxyMsg, 100L);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindBluetoothProfileService(int bluetoothProfile, IBluetoothProfileServiceConnection proxy) {
        Map<Integer, ProfileServiceConnections> map = this.mProfileServices;
        synchronized (map) {
            ProfileServiceConnections psc = this.mProfileServices.get(new Integer(bluetoothProfile));
            if (psc == null) {
                return;
            }
            psc.removeProxy(proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbindAllBluetoothProfileServices() {
        Map<Integer, ProfileServiceConnections> map = this.mProfileServices;
        synchronized (map) {
            for (Integer i : this.mProfileServices.keySet()) {
                ProfileServiceConnections psc = this.mProfileServices.get(i);
                try {
                    this.mContext.unbindService(psc);
                }
                catch (IllegalArgumentException e) {
                    Slog.e(TAG, "Unable to unbind service with intent: " + psc.mIntent, e);
                }
                psc.removeAllProxies();
            }
            this.mProfileServices.clear();
        }
    }

    public void handleOnBootPhase() {
        Slog.d(TAG, "Bluetooth boot completed");
        if (this.mEnableExternal && this.isBluetoothPersistedStateOnBluetooth()) {
            Slog.d(TAG, "Auto-enabling Bluetooth.");
            this.sendEnableMsg(this.mQuietEnableExternal);
        } else if (!this.isNameAndAddressSet()) {
            Slog.d(TAG, "Getting adapter name and address");
            Message getMsg = this.mHandler.obtainMessage(200);
            this.mHandler.sendMessage(getMsg);
        }
    }

    public void handleOnSwitchUser(int userHandle) {
        Slog.d(TAG, "User " + userHandle + " switched");
        this.mHandler.obtainMessage(300, userHandle, 0).sendToTarget();
    }

    public void handleOnUnlockUser(int userHandle) {
        Slog.d(TAG, "User " + userHandle + " unlocked");
        this.mHandler.obtainMessage(301, userHandle, 0).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBluetoothStateCallback(boolean isUp) {
        try {
            int n = this.mStateChangeCallbacks.beginBroadcast();
            Slog.d(TAG, "Broadcasting onBluetoothStateChange(" + isUp + ") to " + n + " receivers.");
            for (int i = 0; i < n; ++i) {
                try {
                    this.mStateChangeCallbacks.getBroadcastItem(i).onBluetoothStateChange(isUp);
                    continue;
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "Unable to call onBluetoothStateChange() on callback #" + i, e);
                }
            }
        }
        finally {
            this.mStateChangeCallbacks.finishBroadcast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBluetoothServiceUpCallback() {
        Slog.d(TAG, "Calling onBluetoothServiceUp callbacks");
        try {
            int n = this.mCallbacks.beginBroadcast();
            Slog.d(TAG, "Broadcasting onBluetoothServiceUp() to " + n + " receivers.");
            for (int i = 0; i < n; ++i) {
                try {
                    this.mCallbacks.getBroadcastItem(i).onBluetoothServiceUp(this.mBluetooth);
                    continue;
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "Unable to call onBluetoothServiceUp() on callback #" + i, e);
                }
            }
        }
        finally {
            this.mCallbacks.finishBroadcast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBluetoothServiceDownCallback() {
        Slog.d(TAG, "Calling onBluetoothServiceDown callbacks");
        try {
            int n = this.mCallbacks.beginBroadcast();
            Slog.d(TAG, "Broadcasting onBluetoothServiceDown() to " + n + " receivers.");
            for (int i = 0; i < n; ++i) {
                try {
                    this.mCallbacks.getBroadcastItem(i).onBluetoothServiceDown();
                    continue;
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "Unable to call onBluetoothServiceDown() on callback #" + i, e);
                }
            }
        }
        finally {
            this.mCallbacks.finishBroadcast();
        }
    }

    @Override
    public String getAddress() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (Binder.getCallingUid() != 1000 && !this.checkIfCallerIsForegroundUser()) {
            Slog.w(TAG, "getAddress(): not allowed for non-active and non system user");
            return null;
        }
        if (this.mContext.checkCallingOrSelfPermission("android.permission.LOCAL_MAC_ADDRESS") != 0) {
            return "02:00:00:00:00:00";
        }
        try {
            this.mBluetoothLock.readLock().lock();
            if (this.mBluetooth != null) {
                String string2 = this.mBluetooth.getAddress();
                return string2;
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "getAddress(): Unable to retrieve address remotely. Returning cached address", e);
        }
        finally {
            this.mBluetoothLock.readLock().unlock();
        }
        return this.mAddress;
    }

    @Override
    public String getName() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (Binder.getCallingUid() != 1000 && !this.checkIfCallerIsForegroundUser()) {
            Slog.w(TAG, "getName(): not allowed for non-active and non system user");
            return null;
        }
        try {
            this.mBluetoothLock.readLock().lock();
            if (this.mBluetooth != null) {
                String string2 = this.mBluetooth.getName();
                return string2;
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "getName(): Unable to retrieve name remotely. Returning cached name", e);
        }
        finally {
            this.mBluetoothLock.readLock().unlock();
        }
        return this.mName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEnable(boolean quietMode) {
        block12: {
            this.mQuietEnable = quietMode;
            try {
                this.mBluetoothLock.writeLock().lock();
                if (this.mBluetooth == null && !this.mBinding) {
                    Message timeoutMsg = this.mHandler.obtainMessage(100);
                    this.mHandler.sendMessageDelayed(timeoutMsg, 3000L);
                    Intent i = new Intent(IBluetooth.class.getName());
                    if (!this.doBind(i, this.mConnection, 65, UserHandle.CURRENT)) {
                        this.mHandler.removeMessages(100);
                    } else {
                        this.mBinding = true;
                    }
                    break block12;
                }
                if (this.mBluetooth == null) break block12;
                try {
                    if (!this.mQuietEnable) {
                        if (!this.mBluetooth.enable()) {
                            Slog.e(TAG, "IBluetooth.enable() returned false");
                        }
                    } else if (!this.mBluetooth.enableNoAutoConnect()) {
                        Slog.e(TAG, "IBluetooth.enableNoAutoConnect() returned false");
                    }
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "Unable to call enable()", e);
                }
            }
            finally {
                this.mBluetoothLock.writeLock().unlock();
            }
        }
    }

    boolean doBind(Intent intent, ServiceConnection conn, int flags, UserHandle user) {
        ComponentName comp = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(comp);
        if (comp == null || !this.mContext.bindServiceAsUser(intent, conn, flags, user)) {
            Slog.e(TAG, "Fail to bind to: " + intent);
            return false;
        }
        return true;
    }

    private void handleDisable() {
        try {
            this.mBluetoothLock.readLock().lock();
            if (this.mBluetooth != null) {
                Slog.d(TAG, "Sending off request.");
                if (!this.mBluetooth.disable()) {
                    Slog.e(TAG, "IBluetooth.disable() returned false");
                }
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Unable to call disable()", e);
        }
        finally {
            this.mBluetoothLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkIfCallerIsForegroundUser() {
        int callingUser = UserHandle.getCallingUserId();
        int callingUid = Binder.getCallingUid();
        long callingIdentity = Binder.clearCallingIdentity();
        UserManager um = (UserManager)this.mContext.getSystemService("user");
        UserInfo ui = um.getProfileParent(callingUser);
        int parentUser = ui != null ? ui.id : -10000;
        int callingAppId = UserHandle.getAppId(callingUid);
        boolean valid = false;
        try {
            int foregroundUser = ActivityManager.getCurrentUser();
            valid = callingUser == foregroundUser || parentUser == foregroundUser || callingAppId == 1027 || callingAppId == this.mSystemUiUid;
            Slog.d(TAG, "checkIfCallerIsForegroundUser: valid=" + valid + " callingUser=" + callingUser + " parentUser=" + parentUser + " foregroundUser=" + foregroundUser);
        }
        finally {
            Binder.restoreCallingIdentity(callingIdentity);
        }
        return valid;
    }

    private void sendBleStateChanged(int prevState, int newState) {
        Slog.d(TAG, "BLE State Change Intent: " + prevState + " -> " + newState);
        Intent intent = new Intent("android.bluetooth.adapter.action.BLE_STATE_CHANGED");
        intent.putExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", prevState);
        intent.putExtra("android.bluetooth.adapter.extra.STATE", newState);
        intent.addFlags(0x4000000);
        this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL, BLUETOOTH_PERM);
    }

    private void bluetoothStateChangeHandler(int prevState, int newState) {
        boolean isStandardBroadcast = true;
        if (prevState != newState) {
            if (newState == 15 || newState == 10) {
                boolean intermediate_off;
                boolean bl = intermediate_off = prevState == 13 && newState == 15;
                if (newState == 10) {
                    Slog.d(TAG, "Bluetooth is complete turn off");
                    this.sendBluetoothServiceDownCallback();
                    this.unbindAndFinish();
                    this.sendBleStateChanged(prevState, newState);
                    isStandardBroadcast = false;
                } else if (!intermediate_off) {
                    Slog.d(TAG, "Bluetooth is in LE only mode");
                    if (this.mBluetoothGatt != null) {
                        Slog.d(TAG, "Calling BluetoothGattServiceUp");
                        this.onBluetoothGattServiceUp();
                    } else {
                        Slog.d(TAG, "Binding Bluetooth GATT service");
                        if (this.mContext.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
                            Intent i = new Intent(IBluetoothGatt.class.getName());
                            this.doBind(i, this.mConnection, 65, UserHandle.CURRENT);
                        }
                    }
                    this.sendBleStateChanged(prevState, newState);
                    isStandardBroadcast = false;
                } else if (intermediate_off) {
                    Slog.d(TAG, "Intermediate off, back to LE only mode");
                    this.sendBleStateChanged(prevState, newState);
                    this.sendBluetoothStateCallback(false);
                    newState = 10;
                    this.sendBrEdrDownCallback();
                }
            } else if (newState == 12) {
                boolean isUp = newState == 12;
                this.sendBluetoothStateCallback(isUp);
                this.sendBleStateChanged(prevState, newState);
            } else if (newState == 14 || newState == 16) {
                this.sendBleStateChanged(prevState, newState);
                isStandardBroadcast = false;
            } else if (newState == 11 || newState == 13) {
                this.sendBleStateChanged(prevState, newState);
            }
            if (isStandardBroadcast) {
                if (prevState == 15) {
                    prevState = 10;
                }
                Intent intent = new Intent("android.bluetooth.adapter.action.STATE_CHANGED");
                intent.putExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", prevState);
                intent.putExtra("android.bluetooth.adapter.extra.STATE", newState);
                intent.addFlags(0x4000000);
                this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL, BLUETOOTH_PERM);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForOnOff(boolean on, boolean off) {
        for (int i = 0; i < 10; ++i) {
            try {
                this.mBluetoothLock.readLock().lock();
                if (this.mBluetooth == null) break;
                if (on) {
                    if (this.mBluetooth.getState() == 12) {
                        boolean bl = true;
                        return bl;
                    }
                } else if (off) {
                    if (this.mBluetooth.getState() == 10) {
                        boolean bl = true;
                        return bl;
                    }
                } else if (this.mBluetooth.getState() != 12) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (RemoteException e) {
                Slog.e(TAG, "getState()", e);
                break;
            }
            finally {
                this.mBluetoothLock.readLock().unlock();
            }
            if (on || off) {
                SystemClock.sleep(300L);
                continue;
            }
            SystemClock.sleep(50L);
        }
        Slog.e(TAG, "waitForOnOff time out");
        return false;
    }

    private void sendDisableMsg() {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2));
    }

    private void sendEnableMsg(boolean quietMode) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, quietMode ? 1 : 0, 0));
    }

    private void recoverBluetoothServiceFromError() {
        Slog.e(TAG, "recoverBluetoothServiceFromError");
        try {
            this.mBluetoothLock.readLock().lock();
            if (this.mBluetooth != null) {
                this.mBluetooth.unregisterCallback(this.mBluetoothCallback);
            }
        }
        catch (RemoteException re) {
            Slog.e(TAG, "Unable to unregister", re);
        }
        finally {
            this.mBluetoothLock.readLock().unlock();
        }
        SystemClock.sleep(500L);
        this.handleDisable();
        this.waitForOnOff(false, true);
        this.sendBluetoothServiceDownCallback();
        try {
            this.mBluetoothLock.writeLock().lock();
            if (this.mBluetooth != null) {
                this.mBluetooth = null;
                this.mContext.unbindService(this.mConnection);
            }
            this.mBluetoothGatt = null;
        }
        finally {
            this.mBluetoothLock.writeLock().unlock();
        }
        this.mHandler.removeMessages(60);
        this.mState = 10;
        this.mEnable = false;
        if (this.mErrorRecoveryRetryCounter++ < 6) {
            Message restartMsg = this.mHandler.obtainMessage(42);
            this.mHandler.sendMessageDelayed(restartMsg, 3000L);
        }
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        String errorMsg = null;
        if (this.mBluetoothBinder == null) {
            errorMsg = "Bluetooth Service not connected";
        } else {
            try {
                this.mBluetoothBinder.dump(fd, args);
            }
            catch (RemoteException re) {
                errorMsg = "RemoteException while calling Bluetooth Service";
            }
        }
        if (errorMsg != null) {
            if (args.length > 0 && args[0].startsWith("--proto")) {
                return;
            }
            writer.println(errorMsg);
        }
    }

    static /* synthetic */ boolean access$1900(BluetoothManagerService x0) {
        return x0.mBinding;
    }

    static /* synthetic */ BluetoothServiceConnection access$2000(BluetoothManagerService x0) {
        return x0.mConnection;
    }

    static /* synthetic */ boolean access$1902(BluetoothManagerService x0, boolean x1) {
        x0.mBinding = x1;
        return x0.mBinding;
    }

    static /* synthetic */ boolean access$2100(BluetoothManagerService x0) {
        return x0.mEnable;
    }

    static /* synthetic */ boolean access$2102(BluetoothManagerService x0, boolean x1) {
        x0.mEnable = x1;
        return x0.mEnable;
    }

    static /* synthetic */ boolean access$2202(BluetoothManagerService x0, boolean x1) {
        x0.mQuietEnable = x1;
        return x0.mQuietEnable;
    }

    static /* synthetic */ boolean access$2200(BluetoothManagerService x0) {
        return x0.mQuietEnable;
    }

    static /* synthetic */ void access$2300(BluetoothManagerService x0, boolean x1) {
        x0.handleEnable(x1);
    }

    static /* synthetic */ boolean access$2400(BluetoothManagerService x0, boolean x1, boolean x2) {
        return x0.waitForOnOff(x1, x2);
    }

    static /* synthetic */ void access$2500(BluetoothManagerService x0) {
        x0.handleDisable();
    }

    static /* synthetic */ RemoteCallbackList access$2600(BluetoothManagerService x0) {
        return x0.mCallbacks;
    }

    static /* synthetic */ RemoteCallbackList access$2700(BluetoothManagerService x0) {
        return x0.mStateChangeCallbacks;
    }

    static /* synthetic */ Map access$2800(BluetoothManagerService x0) {
        return x0.mProfileServices;
    }

    static /* synthetic */ IBluetoothGatt access$3002(BluetoothManagerService x0, IBluetoothGatt x1) {
        x0.mBluetoothGatt = x1;
        return x0.mBluetoothGatt;
    }

    static /* synthetic */ void access$3100(BluetoothManagerService x0) {
        x0.onBluetoothGattServiceUp();
    }

    static /* synthetic */ IBinder access$3202(BluetoothManagerService x0, IBinder x1) {
        x0.mBluetoothBinder = x1;
        return x0.mBluetoothBinder;
    }

    static /* synthetic */ IBluetooth access$702(BluetoothManagerService x0, IBluetooth x1) {
        x0.mBluetooth = x1;
        return x0.mBluetooth;
    }

    static /* synthetic */ boolean access$3300(BluetoothManagerService x0) {
        return x0.isNameAndAddressSet();
    }

    static /* synthetic */ ContentResolver access$3400(BluetoothManagerService x0) {
        return x0.mContentResolver;
    }

    static /* synthetic */ IBluetoothCallback access$3500(BluetoothManagerService x0) {
        return x0.mBluetoothCallback;
    }

    static /* synthetic */ void access$3600(BluetoothManagerService x0) {
        x0.sendBluetoothServiceUpCallback();
    }

    static /* synthetic */ int access$3702(BluetoothManagerService x0, int x1) {
        x0.mState = x1;
        return x0.mState;
    }

    static /* synthetic */ void access$3800(BluetoothManagerService x0, int x1, int x2) {
        x0.bluetoothStateChangeHandler(x1, x2);
    }

    static /* synthetic */ void access$3900(BluetoothManagerService x0) {
        x0.recoverBluetoothServiceFromError();
    }

    static /* synthetic */ int access$4000(BluetoothManagerService x0) {
        return x0.mErrorRecoveryRetryCounter;
    }

    static /* synthetic */ int access$4002(BluetoothManagerService x0, int x1) {
        x0.mErrorRecoveryRetryCounter = x1;
        return x0.mErrorRecoveryRetryCounter;
    }

    static /* synthetic */ void access$4100(BluetoothManagerService x0) {
        x0.sendBluetoothServiceDownCallback();
    }

    static /* synthetic */ int access$3700(BluetoothManagerService x0) {
        return x0.mState;
    }

    static /* synthetic */ boolean access$4202(BluetoothManagerService x0, boolean x1) {
        x0.mUnbinding = x1;
        return x0.mUnbinding;
    }

    static /* synthetic */ void access$4300(BluetoothManagerService x0) {
        x0.unbindAllBluetoothProfileServices();
    }

    static /* synthetic */ Context access$4400(BluetoothManagerService x0) {
        return x0.mContext;
    }

    private class BluetoothHandler
    extends Handler {
        boolean mGetNameAddressOnly;

        public BluetoothHandler(Looper looper) {
            super(looper);
            this.mGetNameAddressOnly = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void handleMessage(Message msg) {
            Slog.d("BluetoothManagerService", "Message: " + msg.what);
            switch (msg.what) {
                case 200: {
                    Slog.d("BluetoothManagerService", "MESSAGE_GET_NAME_AND_ADDRESS");
                    try {
                        BluetoothManagerService.access$600(BluetoothManagerService.this).writeLock().lock();
                        if (BluetoothManagerService.access$700(BluetoothManagerService.this) == null && !BluetoothManagerService.access$1900(BluetoothManagerService.this)) {
                            Slog.d("BluetoothManagerService", "Binding to service to get name and address");
                            this.mGetNameAddressOnly = true;
                            timeoutMsg = BluetoothManagerService.access$000(BluetoothManagerService.this).obtainMessage(100);
                            BluetoothManagerService.access$000(BluetoothManagerService.this).sendMessageDelayed(timeoutMsg, 3000L);
                            i = new Intent(IBluetooth.class.getName());
                            if (!BluetoothManagerService.this.doBind(i, BluetoothManagerService.access$2000(BluetoothManagerService.this), 65, UserHandle.CURRENT)) {
                                BluetoothManagerService.access$000(BluetoothManagerService.this).removeMessages(100);
                                break;
                            }
                            BluetoothManagerService.access$1902(BluetoothManagerService.this, true);
                            break;
                        }
                        if (BluetoothManagerService.access$700(BluetoothManagerService.this) == null) break;
                        try {
                            BluetoothManagerService.access$100(BluetoothManagerService.this, BluetoothManagerService.access$700(BluetoothManagerService.this).getName(), BluetoothManagerService.access$700(BluetoothManagerService.this).getAddress());
                        }
                        catch (RemoteException re) {
                            Slog.e("BluetoothManagerService", "Unable to grab names", re);
                        }
                        if (this.mGetNameAddressOnly && !BluetoothManagerService.access$2100(BluetoothManagerService.this)) {
                            BluetoothManagerService.this.unbindAndFinish();
                        }
                        this.mGetNameAddressOnly = false;
                        break;
                    }
                    finally {
                        BluetoothManagerService.access$600(BluetoothManagerService.this).writeLock().unlock();
                    }
                }
                case 1: {
                    Slog.d("BluetoothManagerService", "MESSAGE_ENABLE: mBluetooth = " + BluetoothManagerService.access$700(BluetoothManagerService.this));
                    BluetoothManagerService.access$000(BluetoothManagerService.this).removeMessages(42);
                    BluetoothManagerService.access$2102(BluetoothManagerService.this, true);
                    try {
                        BluetoothManagerService.access$600(BluetoothManagerService.this).readLock().lock();
                        if (BluetoothManagerService.access$700(BluetoothManagerService.this) != null && (state = BluetoothManagerService.access$700(BluetoothManagerService.this).getState()) == 15) {
                            Slog.w("BluetoothManagerService", "BT is in BLE_ON State");
                            BluetoothManagerService.access$700(BluetoothManagerService.this).onLeServiceUp();
                            break;
                        }
                    }
                    catch (RemoteException e) {
                        Slog.e("BluetoothManagerService", "", e);
                    }
                    finally {
                        BluetoothManagerService.access$600(BluetoothManagerService.this).readLock().unlock();
                    }
                    BluetoothManagerService.access$2202(BluetoothManagerService.this, msg.arg1 == 1);
                    if (BluetoothManagerService.access$700(BluetoothManagerService.this) == null) {
                        BluetoothManagerService.access$2300(BluetoothManagerService.this, BluetoothManagerService.access$2200(BluetoothManagerService.this));
                        break;
                    }
                    BluetoothManagerService.access$2400(BluetoothManagerService.this, false, true);
                    restartMsg = BluetoothManagerService.access$000(BluetoothManagerService.this).obtainMessage(42);
                    BluetoothManagerService.access$000(BluetoothManagerService.this).sendMessageDelayed(restartMsg, 400L);
                    break;
                }
                case 2: {
                    BluetoothManagerService.access$000(BluetoothManagerService.this).removeMessages(42);
                    if (BluetoothManagerService.access$2100(BluetoothManagerService.this) && BluetoothManagerService.access$700(BluetoothManagerService.this) != null) {
                        BluetoothManagerService.access$2400(BluetoothManagerService.this, true, false);
                        BluetoothManagerService.access$2102(BluetoothManagerService.this, false);
                        BluetoothManagerService.access$2500(BluetoothManagerService.this);
                        BluetoothManagerService.access$2400(BluetoothManagerService.this, false, false);
                        break;
                    }
                    BluetoothManagerService.access$2102(BluetoothManagerService.this, false);
                    BluetoothManagerService.access$2500(BluetoothManagerService.this);
                    break;
                }
                case 20: {
                    callback = (IBluetoothManagerCallback)msg.obj;
                    added = BluetoothManagerService.access$2600(BluetoothManagerService.this).register(callback);
                    Slog.d("BluetoothManagerService", "Added callback: " + (callback == null ? "null" : callback) + ":" + added);
                    break;
                }
                case 21: {
                    callback = (IBluetoothManagerCallback)msg.obj;
                    removed = BluetoothManagerService.access$2600(BluetoothManagerService.this).unregister(callback);
                    Slog.d("BluetoothManagerService", "Removed callback: " + (callback == null ? "null" : callback) + ":" + removed);
                    break;
                }
                case 30: {
                    callback = (IBluetoothStateChangeCallback)msg.obj;
                    if (callback == null) break;
                    BluetoothManagerService.access$2700(BluetoothManagerService.this).register(callback);
                    break;
                }
                case 31: {
                    callback = (IBluetoothStateChangeCallback)msg.obj;
                    if (callback == null) break;
                    BluetoothManagerService.access$2700(BluetoothManagerService.this).unregister(callback);
                    break;
                }
                case 400: {
                    psc = (ProfileServiceConnections)BluetoothManagerService.access$2800(BluetoothManagerService.this).get(new Integer(msg.arg1));
                    if (psc == null) break;
                    proxy = (IBluetoothProfileServiceConnection)msg.obj;
                    ProfileServiceConnections.access$2900(psc, proxy);
                    break;
                }
                case 401: {
                    psc = (ProfileServiceConnections)msg.obj;
                    this.removeMessages(401, msg.obj);
                    if (psc == null) break;
                    ProfileServiceConnections.access$1500(psc);
                    break;
                }
                case 40: {
                    Slog.d("BluetoothManagerService", "MESSAGE_BLUETOOTH_SERVICE_CONNECTED: " + msg.arg1);
                    service = (IBinder)msg.obj;
                    try {
                        BluetoothManagerService.access$600(BluetoothManagerService.this).writeLock().lock();
                        if (msg.arg1 == 2) {
                            BluetoothManagerService.access$3002(BluetoothManagerService.this, IBluetoothGatt.Stub.asInterface(service));
                            BluetoothManagerService.access$3100(BluetoothManagerService.this);
                            break;
                        }
                        BluetoothManagerService.access$000(BluetoothManagerService.this).removeMessages(100);
                        BluetoothManagerService.access$1902(BluetoothManagerService.this, false);
                        BluetoothManagerService.access$3202(BluetoothManagerService.this, service);
                        BluetoothManagerService.access$702(BluetoothManagerService.this, IBluetooth.Stub.asInterface(service));
                        if (!BluetoothManagerService.access$3300(BluetoothManagerService.this)) {
                            getMsg = BluetoothManagerService.access$000(BluetoothManagerService.this).obtainMessage(200);
                            BluetoothManagerService.access$000(BluetoothManagerService.this).sendMessage(getMsg);
                            if (this.mGetNameAddressOnly) {
                                return;
                            }
                        }
                        try {
                            v0 = enableHciSnoopLog = Settings.Secure.getInt(BluetoothManagerService.access$3400(BluetoothManagerService.this), "bluetooth_hci_log", 0) == 1;
                            if (!BluetoothManagerService.access$700(BluetoothManagerService.this).configHciSnoopLog(enableHciSnoopLog)) {
                                Slog.e("BluetoothManagerService", "IBluetooth.configHciSnoopLog return false");
                            }
                        }
                        catch (RemoteException e) {
                            Slog.e("BluetoothManagerService", "Unable to call configHciSnoopLog", e);
                        }
                        try {
                            BluetoothManagerService.access$700(BluetoothManagerService.this).registerCallback(BluetoothManagerService.access$3500(BluetoothManagerService.this));
                        }
                        catch (RemoteException re) {
                            Slog.e("BluetoothManagerService", "Unable to register BluetoothCallback", re);
                        }
                        BluetoothManagerService.access$3600(BluetoothManagerService.this);
                        try {
                            if (!BluetoothManagerService.access$2200(BluetoothManagerService.this)) {
                                if (!BluetoothManagerService.access$700(BluetoothManagerService.this).enable()) {
                                    Slog.e("BluetoothManagerService", "IBluetooth.enable() returned false");
                                }
                            } else if (!BluetoothManagerService.access$700(BluetoothManagerService.this).enableNoAutoConnect()) {
                                Slog.e("BluetoothManagerService", "IBluetooth.enableNoAutoConnect() returned false");
                            }
                        }
                        catch (RemoteException e) {
                            Slog.e("BluetoothManagerService", "Unable to call enable()", e);
                        }
                    }
                    finally {
                        BluetoothManagerService.access$600(BluetoothManagerService.this).writeLock().unlock();
                    }
                    if (BluetoothManagerService.access$2100(BluetoothManagerService.this)) break;
                    BluetoothManagerService.access$2400(BluetoothManagerService.this, true, false);
                    BluetoothManagerService.access$2500(BluetoothManagerService.this);
                    BluetoothManagerService.access$2400(BluetoothManagerService.this, false, false);
                    break;
                }
                case 100: {
                    Slog.e("BluetoothManagerService", "MESSAGE_TIMEOUT_BIND");
                    BluetoothManagerService.access$600(BluetoothManagerService.this).writeLock().lock();
                    BluetoothManagerService.access$1902(BluetoothManagerService.this, false);
                    BluetoothManagerService.access$600(BluetoothManagerService.this).writeLock().unlock();
                    break;
                }
                case 60: {
                    prevState = msg.arg1;
                    newState = msg.arg2;
                    Slog.d("BluetoothManagerService", "MESSAGE_BLUETOOTH_STATE_CHANGE: prevState = " + prevState + ", newState=" + newState);
                    BluetoothManagerService.access$3702(BluetoothManagerService.this, newState);
                    BluetoothManagerService.access$3800(BluetoothManagerService.this, prevState, newState);
                    if (prevState == 14 && newState == 10 && BluetoothManagerService.access$700(BluetoothManagerService.this) != null && BluetoothManagerService.access$2100(BluetoothManagerService.this)) {
                        BluetoothManagerService.access$3900(BluetoothManagerService.this);
                    }
                    if (prevState == 11 && newState == 15 && BluetoothManagerService.access$700(BluetoothManagerService.this) != null && BluetoothManagerService.access$2100(BluetoothManagerService.this)) {
                        BluetoothManagerService.access$3900(BluetoothManagerService.this);
                    }
                    if (prevState == 16 && newState == 10 && BluetoothManagerService.access$2100(BluetoothManagerService.this)) {
                        Slog.d("BluetoothManagerService", "Entering STATE_OFF but mEnabled is true; restarting.");
                        BluetoothManagerService.access$2400(BluetoothManagerService.this, false, true);
                        restartMsg = BluetoothManagerService.access$000(BluetoothManagerService.this).obtainMessage(42);
                        BluetoothManagerService.access$000(BluetoothManagerService.this).sendMessageDelayed(restartMsg, 400L);
                    }
                    if (newState != 12 && newState != 15 || BluetoothManagerService.access$4000(BluetoothManagerService.this) == 0) break;
                    Slog.w("BluetoothManagerService", "bluetooth is recovered from error");
                    BluetoothManagerService.access$4002(BluetoothManagerService.this, 0);
                    break;
                }
                case 41: {
                    Slog.e("BluetoothManagerService", "MESSAGE_BLUETOOTH_SERVICE_DISCONNECTED: " + msg.arg1);
                    try {
                        BluetoothManagerService.access$600(BluetoothManagerService.this).writeLock().lock();
                        if (msg.arg1 != 1) ** GOTO lbl230
                        if (BluetoothManagerService.access$700(BluetoothManagerService.this) == null) break;
                        BluetoothManagerService.access$702(BluetoothManagerService.this, null);
                        ** GOTO lbl240
lbl230:
                        // 1 sources

                        if (msg.arg1 == 2) {
                            BluetoothManagerService.access$3002(BluetoothManagerService.this, null);
                            break;
                        }
                        Slog.e("BluetoothManagerService", "Bad msg.arg1: " + msg.arg1);
                        break;
                    }
                    finally {
                        BluetoothManagerService.access$600(BluetoothManagerService.this).writeLock().unlock();
                    }
lbl240:
                    // 1 sources

                    if (BluetoothManagerService.access$2100(BluetoothManagerService.this)) {
                        BluetoothManagerService.access$2102(BluetoothManagerService.this, false);
                        restartMsg = BluetoothManagerService.access$000(BluetoothManagerService.this).obtainMessage(42);
                        BluetoothManagerService.access$000(BluetoothManagerService.this).sendMessageDelayed(restartMsg, 200L);
                    }
                    BluetoothManagerService.access$4100(BluetoothManagerService.this);
                    if (BluetoothManagerService.access$3700(BluetoothManagerService.this) == 11 || BluetoothManagerService.access$3700(BluetoothManagerService.this) == 12) {
                        BluetoothManagerService.access$3800(BluetoothManagerService.this, 12, 13);
                        BluetoothManagerService.access$3702(BluetoothManagerService.this, 13);
                    }
                    if (BluetoothManagerService.access$3700(BluetoothManagerService.this) == 13) {
                        BluetoothManagerService.access$3800(BluetoothManagerService.this, 13, 10);
                    }
                    BluetoothManagerService.access$000(BluetoothManagerService.this).removeMessages(60);
                    BluetoothManagerService.access$3702(BluetoothManagerService.this, 10);
                    break;
                }
                case 42: {
                    Slog.d("BluetoothManagerService", "MESSAGE_RESTART_BLUETOOTH_SERVICE: Restart IBluetooth service");
                    BluetoothManagerService.access$2102(BluetoothManagerService.this, true);
                    BluetoothManagerService.access$2300(BluetoothManagerService.this, BluetoothManagerService.access$2200(BluetoothManagerService.this));
                    break;
                }
                case 101: {
                    Slog.e("BluetoothManagerService", "MESSAGE_TIMEOUT_UNBIND");
                    BluetoothManagerService.access$600(BluetoothManagerService.this).writeLock().lock();
                    BluetoothManagerService.access$4202(BluetoothManagerService.this, false);
                    BluetoothManagerService.access$600(BluetoothManagerService.this).writeLock().unlock();
                    break;
                }
                case 300: {
                    Slog.d("BluetoothManagerService", "MESSAGE_USER_SWITCHED");
                    BluetoothManagerService.access$000(BluetoothManagerService.this).removeMessages(300);
                    if (!BluetoothManagerService.access$2100(BluetoothManagerService.this) || BluetoothManagerService.access$700(BluetoothManagerService.this) == null) ** GOTO lbl328
                    try {
                        BluetoothManagerService.access$600(BluetoothManagerService.this).readLock().lock();
                        if (BluetoothManagerService.access$700(BluetoothManagerService.this) != null) {
                            BluetoothManagerService.access$700(BluetoothManagerService.this).unregisterCallback(BluetoothManagerService.access$3500(BluetoothManagerService.this));
                        }
                    }
                    catch (RemoteException re) {
                        Slog.e("BluetoothManagerService", "Unable to unregister", re);
                    }
                    finally {
                        BluetoothManagerService.access$600(BluetoothManagerService.this).readLock().unlock();
                    }
                    if (BluetoothManagerService.access$3700(BluetoothManagerService.this) == 13) {
                        BluetoothManagerService.access$3800(BluetoothManagerService.this, BluetoothManagerService.access$3700(BluetoothManagerService.this), 10);
                        BluetoothManagerService.access$3702(BluetoothManagerService.this, 10);
                    }
                    if (BluetoothManagerService.access$3700(BluetoothManagerService.this) == 10) {
                        BluetoothManagerService.access$3800(BluetoothManagerService.this, BluetoothManagerService.access$3700(BluetoothManagerService.this), 11);
                        BluetoothManagerService.access$3702(BluetoothManagerService.this, 11);
                    }
                    BluetoothManagerService.access$2400(BluetoothManagerService.this, true, false);
                    if (BluetoothManagerService.access$3700(BluetoothManagerService.this) == 11) {
                        BluetoothManagerService.access$3800(BluetoothManagerService.this, BluetoothManagerService.access$3700(BluetoothManagerService.this), 12);
                    }
                    BluetoothManagerService.access$4300(BluetoothManagerService.this);
                    BluetoothManagerService.access$2500(BluetoothManagerService.this);
                    BluetoothManagerService.access$3800(BluetoothManagerService.this, 12, 13);
                    didDisableTimeout = BluetoothManagerService.access$2400(BluetoothManagerService.this, false, true) == false;
                    BluetoothManagerService.access$3800(BluetoothManagerService.this, 13, 10);
                    BluetoothManagerService.access$4100(BluetoothManagerService.this);
                    try {
                        BluetoothManagerService.access$600(BluetoothManagerService.this).writeLock().lock();
                        if (BluetoothManagerService.access$700(BluetoothManagerService.this) != null) {
                            BluetoothManagerService.access$702(BluetoothManagerService.this, null);
                            BluetoothManagerService.access$4400(BluetoothManagerService.this).unbindService(BluetoothManagerService.access$2000(BluetoothManagerService.this));
                        }
                        BluetoothManagerService.access$3002(BluetoothManagerService.this, null);
                    }
                    finally {
                        BluetoothManagerService.access$600(BluetoothManagerService.this).writeLock().unlock();
                    }
                    if (didDisableTimeout) {
                        SystemClock.sleep(3000L);
                    } else {
                        SystemClock.sleep(100L);
                    }
                    BluetoothManagerService.access$000(BluetoothManagerService.this).removeMessages(60);
                    BluetoothManagerService.access$3702(BluetoothManagerService.this, 10);
                    BluetoothManagerService.access$2300(BluetoothManagerService.this, BluetoothManagerService.access$2200(BluetoothManagerService.this));
                    break;
lbl328:
                    // 1 sources

                    if (!BluetoothManagerService.access$1900(BluetoothManagerService.this) && BluetoothManagerService.access$700(BluetoothManagerService.this) == null) break;
                    userMsg = BluetoothManagerService.access$000(BluetoothManagerService.this).obtainMessage(300);
                    userMsg.arg2 = 1 + msg.arg2;
                    BluetoothManagerService.access$000(BluetoothManagerService.this).sendMessageDelayed(userMsg, 200L);
                    Slog.d("BluetoothManagerService", "delay MESSAGE_USER_SWITCHED " + userMsg.arg2);
                    break;
                }
                case 301: {
                    Slog.d("BluetoothManagerService", "MESSAGE_USER_UNLOCKED");
                    BluetoothManagerService.access$000(BluetoothManagerService.this).removeMessages(300);
                    if (!BluetoothManagerService.access$2100(BluetoothManagerService.this) || BluetoothManagerService.access$1900(BluetoothManagerService.this) || BluetoothManagerService.access$700(BluetoothManagerService.this) != null) break;
                    Slog.d("BluetoothManagerService", "Enabled but not bound; retrying after unlock");
                    BluetoothManagerService.access$2300(BluetoothManagerService.this, BluetoothManagerService.access$2200(BluetoothManagerService.this));
                }
            }
        }
    }

    private class BluetoothServiceConnection
    implements ServiceConnection {
        private BluetoothServiceConnection() {
        }

        @Override
        public void onServiceConnected(ComponentName className, IBinder service) {
            Slog.d(BluetoothManagerService.TAG, "BluetoothServiceConnection: " + className.getClassName());
            Message msg = BluetoothManagerService.this.mHandler.obtainMessage(40);
            if (className.getClassName().equals("com.android.bluetooth.btservice.AdapterService")) {
                msg.arg1 = 1;
            } else if (className.getClassName().equals("com.android.bluetooth.gatt.GattService")) {
                msg.arg1 = 2;
            } else {
                Slog.e(BluetoothManagerService.TAG, "Unknown service connected: " + className.getClassName());
                return;
            }
            msg.obj = service;
            BluetoothManagerService.this.mHandler.sendMessage(msg);
        }

        @Override
        public void onServiceDisconnected(ComponentName className) {
            Slog.d(BluetoothManagerService.TAG, "BluetoothServiceConnection, disconnected: " + className.getClassName());
            Message msg = BluetoothManagerService.this.mHandler.obtainMessage(41);
            if (className.getClassName().equals("com.android.bluetooth.btservice.AdapterService")) {
                msg.arg1 = 1;
            } else if (className.getClassName().equals("com.android.bluetooth.gatt.GattService")) {
                msg.arg1 = 2;
            } else {
                Slog.e(BluetoothManagerService.TAG, "Unknown service disconnected: " + className.getClassName());
                return;
            }
            BluetoothManagerService.this.mHandler.sendMessage(msg);
        }
    }

    private final class ProfileServiceConnections
    implements ServiceConnection,
    IBinder.DeathRecipient {
        final RemoteCallbackList<IBluetoothProfileServiceConnection> mProxies = new RemoteCallbackList();
        IBinder mService = null;
        ComponentName mClassName = null;
        Intent mIntent;
        boolean mInvokingProxyCallbacks = false;

        ProfileServiceConnections(Intent intent) {
            this.mIntent = intent;
        }

        private boolean bindService() {
            if (this.mIntent != null && this.mService == null && BluetoothManagerService.this.doBind(this.mIntent, this, 0, UserHandle.CURRENT_OR_SELF)) {
                Message msg = BluetoothManagerService.this.mHandler.obtainMessage(401);
                msg.obj = this;
                BluetoothManagerService.this.mHandler.sendMessageDelayed(msg, 3000L);
                return true;
            }
            Slog.w(BluetoothManagerService.TAG, "Unable to bind with intent: " + this.mIntent);
            return false;
        }

        private void addProxy(IBluetoothProfileServiceConnection proxy) {
            this.mProxies.register(proxy);
            if (this.mService != null) {
                try {
                    proxy.onServiceConnected(this.mClassName, this.mService);
                }
                catch (RemoteException e) {
                    Slog.e(BluetoothManagerService.TAG, "Unable to connect to proxy", e);
                }
            } else if (!BluetoothManagerService.this.mHandler.hasMessages(401, this)) {
                Message msg = BluetoothManagerService.this.mHandler.obtainMessage(401);
                msg.obj = this;
                BluetoothManagerService.this.mHandler.sendMessage(msg);
            }
        }

        private void removeProxy(IBluetoothProfileServiceConnection proxy) {
            if (proxy != null) {
                if (this.mProxies.unregister(proxy)) {
                    try {
                        proxy.onServiceDisconnected(this.mClassName);
                    }
                    catch (RemoteException e) {
                        Slog.e(BluetoothManagerService.TAG, "Unable to disconnect proxy", e);
                    }
                }
            } else {
                Slog.w(BluetoothManagerService.TAG, "Trying to remove a null proxy");
            }
        }

        private void removeAllProxies() {
            this.onServiceDisconnected(this.mClassName);
            this.mProxies.kill();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName className, IBinder service) {
            BluetoothManagerService.this.mHandler.removeMessages(401, this);
            this.mService = service;
            this.mClassName = className;
            try {
                this.mService.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                Slog.e(BluetoothManagerService.TAG, "Unable to linkToDeath", e);
            }
            if (this.mInvokingProxyCallbacks) {
                Slog.e(BluetoothManagerService.TAG, "Proxy callbacks already in progress.");
                return;
            }
            this.mInvokingProxyCallbacks = true;
            int n = this.mProxies.beginBroadcast();
            try {
                for (int i = 0; i < n; ++i) {
                    try {
                        this.mProxies.getBroadcastItem(i).onServiceConnected(className, service);
                        continue;
                    }
                    catch (RemoteException e) {
                        Slog.e(BluetoothManagerService.TAG, "Unable to connect to proxy", e);
                    }
                }
            }
            finally {
                this.mProxies.finishBroadcast();
                this.mInvokingProxyCallbacks = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceDisconnected(ComponentName className) {
            if (this.mService == null) {
                return;
            }
            this.mService.unlinkToDeath(this, 0);
            this.mService = null;
            this.mClassName = null;
            if (this.mInvokingProxyCallbacks) {
                Slog.e(BluetoothManagerService.TAG, "Proxy callbacks already in progress.");
                return;
            }
            this.mInvokingProxyCallbacks = true;
            int n = this.mProxies.beginBroadcast();
            try {
                for (int i = 0; i < n; ++i) {
                    try {
                        this.mProxies.getBroadcastItem(i).onServiceDisconnected(className);
                        continue;
                    }
                    catch (RemoteException e) {
                        Slog.e(BluetoothManagerService.TAG, "Unable to disconnect from proxy", e);
                    }
                }
            }
            finally {
                this.mProxies.finishBroadcast();
                this.mInvokingProxyCallbacks = false;
            }
        }

        @Override
        public void binderDied() {
            Slog.w(BluetoothManagerService.TAG, "Profile service for profile: " + this.mClassName + " died.");
            this.onServiceDisconnected(this.mClassName);
            Message msg = BluetoothManagerService.this.mHandler.obtainMessage(401);
            msg.obj = this;
            BluetoothManagerService.this.mHandler.sendMessageDelayed(msg, 3000L);
        }

        static /* synthetic */ void access$2900(ProfileServiceConnections x0, IBluetoothProfileServiceConnection x1) {
            x0.addProxy(x1);
        }
    }

    class ClientDeathRecipient
    implements IBinder.DeathRecipient {
        ClientDeathRecipient() {
        }

        @Override
        public void binderDied() {
            Slog.d(BluetoothManagerService.TAG, "Binder is dead -  unregister Ble App");
            if (mBleAppCount > 0) {
                --mBleAppCount;
            }
            if (mBleAppCount == 0) {
                Slog.d(BluetoothManagerService.TAG, "Disabling LE only mode after application crash");
                try {
                    BluetoothManagerService.this.mBluetoothLock.readLock().lock();
                    if (BluetoothManagerService.this.mBluetooth != null) {
                        BluetoothManagerService.this.mBluetooth.onBrEdrDown();
                    }
                }
                catch (RemoteException e) {
                    Slog.e(BluetoothManagerService.TAG, "Unable to call onBrEdrDown", e);
                }
                finally {
                    BluetoothManagerService.this.mBluetoothLock.readLock().unlock();
                }
            }
        }
    }
}

