/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Context;
import android.os.Binder;
import android.os.Environment;
import android.os.StatFs;
import android.os.SystemClock;
import android.os.storage.StorageManager;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class DiskStatsService
extends Binder {
    private static final String TAG = "DiskStatsService";
    private final Context mContext;

    public DiskStatsService(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        byte[] junk = new byte[512];
        for (int i = 0; i < junk.length; ++i) {
            junk[i] = (byte)i;
        }
        File tmp = new File(Environment.getDataDirectory(), "system/perftest.tmp");
        FileOutputStream fos = null;
        IOException error = null;
        long before = SystemClock.uptimeMillis();
        try {
            fos = new FileOutputStream(tmp);
            fos.write(junk);
        }
        catch (IOException e) {
            error = e;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {}
        }
        long after = SystemClock.uptimeMillis();
        if (tmp.exists()) {
            tmp.delete();
        }
        if (error != null) {
            pw.print("Test-Error: ");
            pw.println(error.toString());
        } else {
            pw.print("Latency: ");
            pw.print(after - before);
            pw.println("ms [512B Data Write]");
        }
        this.reportFreeSpace(Environment.getDataDirectory(), "Data", pw);
        this.reportFreeSpace(Environment.getDownloadCacheDirectory(), "Cache", pw);
        this.reportFreeSpace(new File("/system"), "System", pw);
        if (StorageManager.isFileEncryptedNativeOnly()) {
            pw.println("File-based Encryption: true");
        }
    }

    private void reportFreeSpace(File path, String name, PrintWriter pw) {
        try {
            StatFs statfs = new StatFs(path.getPath());
            long bsize = statfs.getBlockSize();
            long avail = statfs.getAvailableBlocks();
            long total = statfs.getBlockCount();
            if (bsize <= 0L || total <= 0L) {
                throw new IllegalArgumentException("Invalid stat: bsize=" + bsize + " avail=" + avail + " total=" + total);
            }
            pw.print(name);
            pw.print("-Free: ");
            pw.print(avail * bsize / 1024L);
            pw.print("K / ");
            pw.print(total * bsize / 1024L);
            pw.print("K total = ");
            pw.print(avail * 100L / total);
            pw.println("% free");
        }
        catch (IllegalArgumentException e) {
            pw.print(name);
            pw.print("-Error: ");
            pw.println(e.toString());
            return;
        }
    }
}

