/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.util.EventLog;

public class EventLogTags {
    public static final int BATTERY_LEVEL = 2722;
    public static final int BATTERY_STATUS = 2723;
    public static final int BATTERY_DISCHARGE = 2730;
    public static final int POWER_SLEEP_REQUESTED = 2724;
    public static final int POWER_SCREEN_BROADCAST_SEND = 2725;
    public static final int POWER_SCREEN_BROADCAST_DONE = 2726;
    public static final int POWER_SCREEN_BROADCAST_STOP = 2727;
    public static final int POWER_SCREEN_STATE = 2728;
    public static final int POWER_PARTIAL_WAKE_STATE = 2729;
    public static final int POWER_SOFT_SLEEP_REQUESTED = 2731;
    public static final int FREE_STORAGE_CHANGED = 2744;
    public static final int LOW_STORAGE = 2745;
    public static final int FREE_STORAGE_LEFT = 2746;
    public static final int CACHE_FILE_DELETED = 2748;
    public static final int NOTIFICATION_ENQUEUE = 2750;
    public static final int NOTIFICATION_CANCEL = 2751;
    public static final int NOTIFICATION_CANCEL_ALL = 2752;
    public static final int NOTIFICATION_PANEL_REVEALED = 27500;
    public static final int NOTIFICATION_PANEL_HIDDEN = 27501;
    public static final int NOTIFICATION_VISIBILITY_CHANGED = 27510;
    public static final int NOTIFICATION_EXPANSION = 27511;
    public static final int NOTIFICATION_CLICKED = 27520;
    public static final int NOTIFICATION_ACTION_CLICKED = 27521;
    public static final int NOTIFICATION_CANCELED = 27530;
    public static final int NOTIFICATION_VISIBILITY = 27531;
    public static final int NOTIFICATION_ALERT = 27532;
    public static final int NOTIFICATION_AUTOGROUPED = 27533;
    public static final int NOTIFICATION_UNAUTOGROUPED = 275534;
    public static final int WATCHDOG = 2802;
    public static final int WATCHDOG_PROC_PSS = 2803;
    public static final int WATCHDOG_SOFT_RESET = 2804;
    public static final int WATCHDOG_HARD_RESET = 2805;
    public static final int WATCHDOG_PSS_STATS = 2806;
    public static final int WATCHDOG_PROC_STATS = 2807;
    public static final int WATCHDOG_SCHEDULED_REBOOT = 2808;
    public static final int WATCHDOG_MEMINFO = 2809;
    public static final int WATCHDOG_VMSTAT = 2810;
    public static final int WATCHDOG_REQUESTED_REBOOT = 2811;
    public static final int BACKUP_DATA_CHANGED = 2820;
    public static final int BACKUP_START = 2821;
    public static final int BACKUP_TRANSPORT_FAILURE = 2822;
    public static final int BACKUP_AGENT_FAILURE = 2823;
    public static final int BACKUP_PACKAGE = 2824;
    public static final int BACKUP_SUCCESS = 2825;
    public static final int BACKUP_RESET = 2826;
    public static final int BACKUP_INITIALIZE = 2827;
    public static final int BACKUP_REQUESTED = 2828;
    public static final int BACKUP_QUOTA_EXCEEDED = 2829;
    public static final int RESTORE_START = 2830;
    public static final int RESTORE_TRANSPORT_FAILURE = 2831;
    public static final int RESTORE_AGENT_FAILURE = 2832;
    public static final int RESTORE_PACKAGE = 2833;
    public static final int RESTORE_SUCCESS = 2834;
    public static final int FULL_BACKUP_PACKAGE = 2840;
    public static final int FULL_BACKUP_AGENT_FAILURE = 2841;
    public static final int FULL_BACKUP_TRANSPORT_FAILURE = 2842;
    public static final int FULL_BACKUP_SUCCESS = 2843;
    public static final int FULL_RESTORE_PACKAGE = 2844;
    public static final int FULL_BACKUP_QUOTA_EXCEEDED = 2845;
    public static final int BACKUP_TRANSPORT_LIFECYCLE = 2850;
    public static final int BOOT_PROGRESS_SYSTEM_RUN = 3010;
    public static final int BOOT_PROGRESS_PMS_START = 3060;
    public static final int BOOT_PROGRESS_PMS_SYSTEM_SCAN_START = 3070;
    public static final int BOOT_PROGRESS_PMS_DATA_SCAN_START = 3080;
    public static final int BOOT_PROGRESS_PMS_SCAN_END = 3090;
    public static final int BOOT_PROGRESS_PMS_READY = 3100;
    public static final int UNKNOWN_SOURCES_ENABLED = 3110;
    public static final int PM_CRITICAL_INFO = 3120;
    public static final int WM_NO_SURFACE_MEMORY = 31000;
    public static final int WM_TASK_CREATED = 31001;
    public static final int WM_TASK_MOVED = 31002;
    public static final int WM_TASK_REMOVED = 31003;
    public static final int WM_STACK_CREATED = 31004;
    public static final int WM_HOME_STACK_MOVED = 31005;
    public static final int WM_STACK_REMOVED = 31006;
    public static final int WM_BOOT_ANIMATION_DONE = 31007;
    public static final int IMF_FORCE_RECONNECT_IME = 32000;
    public static final int WP_WALLPAPER_CRASHED = 33000;
    public static final int DEVICE_IDLE = 34000;
    public static final int DEVICE_IDLE_STEP = 34001;
    public static final int DEVICE_IDLE_WAKE_FROM_IDLE = 34002;
    public static final int DEVICE_IDLE_ON_START = 34003;
    public static final int DEVICE_IDLE_ON_PHASE = 34004;
    public static final int DEVICE_IDLE_ON_COMPLETE = 34005;
    public static final int DEVICE_IDLE_OFF_START = 34006;
    public static final int DEVICE_IDLE_OFF_PHASE = 34007;
    public static final int DEVICE_IDLE_OFF_COMPLETE = 34008;
    public static final int DEVICE_IDLE_LIGHT = 34009;
    public static final int DEVICE_IDLE_LIGHT_STEP = 34010;
    public static final int AUTO_BRIGHTNESS_ADJ = 35000;
    public static final int CONNECTIVITY_STATE_CHANGED = 50020;
    public static final int NETSTATS_MOBILE_SAMPLE = 51100;
    public static final int NETSTATS_WIFI_SAMPLE = 51101;
    public static final int LOCKDOWN_VPN_CONNECTING = 51200;
    public static final int LOCKDOWN_VPN_CONNECTED = 51201;
    public static final int LOCKDOWN_VPN_ERROR = 51202;
    public static final int CONFIG_INSTALL_FAILED = 51300;
    public static final int IFW_INTENT_MATCHED = 51400;
    public static final int IDLE_MAINTENANCE_WINDOW_START = 51500;
    public static final int IDLE_MAINTENANCE_WINDOW_FINISH = 51501;
    public static final int FSTRIM_START = 2755;
    public static final int FSTRIM_FINISH = 2756;
    public static final int VOLUME_CHANGED = 40000;
    public static final int STREAM_DEVICES_CHANGED = 40001;
    public static final int CAMERA_GESTURE_TRIGGERED = 40100;

    private EventLogTags() {
    }

    public static void writeBatteryLevel(int level, int voltage, int temperature) {
        EventLog.writeEvent(2722, level, voltage, temperature);
    }

    public static void writeBatteryStatus(int status, int health, int present, int plugged, String technology) {
        EventLog.writeEvent(2723, status, health, present, plugged, technology);
    }

    public static void writeBatteryDischarge(long duration, int minlevel, int maxlevel) {
        EventLog.writeEvent(2730, duration, minlevel, maxlevel);
    }

    public static void writePowerSleepRequested(int wakelockscleared) {
        EventLog.writeEvent(2724, wakelockscleared);
    }

    public static void writePowerScreenBroadcastSend(int wakelockcount) {
        EventLog.writeEvent(2725, wakelockcount);
    }

    public static void writePowerScreenBroadcastDone(int on, long broadcastduration, int wakelockcount) {
        EventLog.writeEvent(2726, on, broadcastduration, wakelockcount);
    }

    public static void writePowerScreenBroadcastStop(int which, int wakelockcount) {
        EventLog.writeEvent(2727, which, wakelockcount);
    }

    public static void writePowerScreenState(int offoron, int becauseofuser, long totaltouchdowntime, int touchcycles) {
        EventLog.writeEvent(2728, offoron, becauseofuser, totaltouchdowntime, touchcycles);
    }

    public static void writePowerPartialWakeState(int releasedoracquired, String tag) {
        EventLog.writeEvent(2729, releasedoracquired, tag);
    }

    public static void writePowerSoftSleepRequested(long savedwaketimems) {
        EventLog.writeEvent(2731, savedwaketimems);
    }

    public static void writeFreeStorageChanged(long data) {
        EventLog.writeEvent(2744, data);
    }

    public static void writeLowStorage(long data) {
        EventLog.writeEvent(2745, data);
    }

    public static void writeFreeStorageLeft(long data, long system, long cache) {
        EventLog.writeEvent(2746, data, system, cache);
    }

    public static void writeCacheFileDeleted(String path) {
        EventLog.writeEvent(2748, path);
    }

    public static void writeNotificationEnqueue(int uid, int pid, String pkg, int id2, String tag, int userid, String notification, int status) {
        EventLog.writeEvent(2750, uid, pid, pkg, id2, tag, userid, notification, status);
    }

    public static void writeNotificationCancel(int uid, int pid, String pkg, int id2, String tag, int userid, int requiredFlags, int forbiddenFlags, int reason, String listener) {
        EventLog.writeEvent(2751, uid, pid, pkg, id2, tag, userid, requiredFlags, forbiddenFlags, reason, listener);
    }

    public static void writeNotificationCancelAll(int uid, int pid, String pkg, int userid, int requiredFlags, int forbiddenFlags, int reason, String listener) {
        EventLog.writeEvent(2752, uid, pid, pkg, userid, requiredFlags, forbiddenFlags, reason, listener);
    }

    public static void writeNotificationPanelRevealed(int items) {
        EventLog.writeEvent(27500, items);
    }

    public static void writeNotificationPanelHidden() {
        EventLog.writeEvent(27501, new Object[0]);
    }

    public static void writeNotificationVisibilityChanged(String newlyvisiblekeys, String nolongervisiblekeys) {
        EventLog.writeEvent(27510, newlyvisiblekeys, nolongervisiblekeys);
    }

    public static void writeNotificationExpansion(String key, int userAction, int expanded, int lifespan, int freshness, int exposure) {
        EventLog.writeEvent(27511, key, userAction, expanded, lifespan, freshness, exposure);
    }

    public static void writeNotificationClicked(String key, int lifespan, int freshness, int exposure) {
        EventLog.writeEvent(27520, key, lifespan, freshness, exposure);
    }

    public static void writeNotificationActionClicked(String key, int actionIndex, int lifespan, int freshness, int exposure) {
        EventLog.writeEvent(27521, key, actionIndex, lifespan, freshness, exposure);
    }

    public static void writeNotificationCanceled(String key, int reason, int lifespan, int freshness, int exposure) {
        EventLog.writeEvent(27530, key, reason, lifespan, freshness, exposure);
    }

    public static void writeNotificationVisibility(String key, int visibile, int lifespan, int freshness, int exposure, int rank) {
        EventLog.writeEvent(27531, key, visibile, lifespan, freshness, exposure, rank);
    }

    public static void writeNotificationAlert(String key, int buzz, int beep, int blink) {
        EventLog.writeEvent(27532, key, buzz, beep, blink);
    }

    public static void writeNotificationAutogrouped(String key) {
        EventLog.writeEvent(27533, key);
    }

    public static void writeNotificationUnautogrouped(String key) {
        EventLog.writeEvent(275534, key);
    }

    public static void writeWatchdog(String service) {
        EventLog.writeEvent(2802, service);
    }

    public static void writeWatchdogProcPss(String process, int pid, int pss) {
        EventLog.writeEvent(2803, process, pid, pss);
    }

    public static void writeWatchdogSoftReset(String process, int pid, int maxpss, int pss, String skip) {
        EventLog.writeEvent(2804, process, pid, maxpss, pss, skip);
    }

    public static void writeWatchdogHardReset(String process, int pid, int maxpss, int pss) {
        EventLog.writeEvent(2805, process, pid, maxpss, pss);
    }

    public static void writeWatchdogPssStats(int emptypss, int emptycount, int backgroundpss, int backgroundcount, int servicepss, int servicecount, int visiblepss, int visiblecount, int foregroundpss, int foregroundcount, int nopsscount) {
        EventLog.writeEvent(2806, emptypss, emptycount, backgroundpss, backgroundcount, servicepss, servicecount, visiblepss, visiblecount, foregroundpss, foregroundcount, nopsscount);
    }

    public static void writeWatchdogProcStats(int deathsinone, int deathsintwo, int deathsinthree, int deathsinfour, int deathsinfive) {
        EventLog.writeEvent(2807, deathsinone, deathsintwo, deathsinthree, deathsinfour, deathsinfive);
    }

    public static void writeWatchdogScheduledReboot(long now, int interval, int starttime, int window, String skip) {
        EventLog.writeEvent(2808, now, interval, starttime, window, skip);
    }

    public static void writeWatchdogMeminfo(int memfree, int buffers, int cached, int active, int inactive, int anonpages, int mapped, int slab, int sreclaimable, int sunreclaim, int pagetables) {
        EventLog.writeEvent(2809, memfree, buffers, cached, active, inactive, anonpages, mapped, slab, sreclaimable, sunreclaim, pagetables);
    }

    public static void writeWatchdogVmstat(long runtime, int pgfree, int pgactivate, int pgdeactivate, int pgfault, int pgmajfault) {
        EventLog.writeEvent(2810, runtime, pgfree, pgactivate, pgdeactivate, pgfault, pgmajfault);
    }

    public static void writeWatchdogRequestedReboot(int nowait, int scheduleinterval, int recheckinterval, int starttime, int window, int minscreenoff, int minnextalarm) {
        EventLog.writeEvent(2811, nowait, scheduleinterval, recheckinterval, starttime, window, minscreenoff, minnextalarm);
    }

    public static void writeBackupDataChanged(String package_) {
        EventLog.writeEvent(2820, package_);
    }

    public static void writeBackupStart(String transport) {
        EventLog.writeEvent(2821, transport);
    }

    public static void writeBackupTransportFailure(String package_) {
        EventLog.writeEvent(2822, package_);
    }

    public static void writeBackupAgentFailure(String package_, String message) {
        EventLog.writeEvent(2823, package_, message);
    }

    public static void writeBackupPackage(String package_, int size) {
        EventLog.writeEvent(2824, package_, size);
    }

    public static void writeBackupSuccess(int packages, int time) {
        EventLog.writeEvent(2825, packages, time);
    }

    public static void writeBackupReset(String transport) {
        EventLog.writeEvent(2826, transport);
    }

    public static void writeBackupInitialize() {
        EventLog.writeEvent(2827, new Object[0]);
    }

    public static void writeBackupRequested(int total, int keyValue, int full) {
        EventLog.writeEvent(2828, total, keyValue, full);
    }

    public static void writeBackupQuotaExceeded(String package_) {
        EventLog.writeEvent(2829, package_);
    }

    public static void writeRestoreStart(String transport, long source) {
        EventLog.writeEvent(2830, transport, source);
    }

    public static void writeRestoreTransportFailure() {
        EventLog.writeEvent(2831, new Object[0]);
    }

    public static void writeRestoreAgentFailure(String package_, String message) {
        EventLog.writeEvent(2832, package_, message);
    }

    public static void writeRestorePackage(String package_, int size) {
        EventLog.writeEvent(2833, package_, size);
    }

    public static void writeRestoreSuccess(int packages, int time) {
        EventLog.writeEvent(2834, packages, time);
    }

    public static void writeFullBackupPackage(String package_) {
        EventLog.writeEvent(2840, package_);
    }

    public static void writeFullBackupAgentFailure(String package_, String message) {
        EventLog.writeEvent(2841, package_, message);
    }

    public static void writeFullBackupTransportFailure() {
        EventLog.writeEvent(2842, new Object[0]);
    }

    public static void writeFullBackupSuccess(String package_) {
        EventLog.writeEvent(2843, package_);
    }

    public static void writeFullRestorePackage(String package_) {
        EventLog.writeEvent(2844, package_);
    }

    public static void writeFullBackupQuotaExceeded(String package_) {
        EventLog.writeEvent(2845, package_);
    }

    public static void writeBackupTransportLifecycle(String transport, int bound) {
        EventLog.writeEvent(2850, transport, bound);
    }

    public static void writeBootProgressSystemRun(long time) {
        EventLog.writeEvent(3010, time);
    }

    public static void writeBootProgressPmsStart(long time) {
        EventLog.writeEvent(3060, time);
    }

    public static void writeBootProgressPmsSystemScanStart(long time) {
        EventLog.writeEvent(3070, time);
    }

    public static void writeBootProgressPmsDataScanStart(long time) {
        EventLog.writeEvent(3080, time);
    }

    public static void writeBootProgressPmsScanEnd(long time) {
        EventLog.writeEvent(3090, time);
    }

    public static void writeBootProgressPmsReady(long time) {
        EventLog.writeEvent(3100, time);
    }

    public static void writeUnknownSourcesEnabled(int value) {
        EventLog.writeEvent(3110, value);
    }

    public static void writePmCriticalInfo(String msg) {
        EventLog.writeEvent(3120, msg);
    }

    public static void writeWmNoSurfaceMemory(String window, int pid, String operation) {
        EventLog.writeEvent(31000, window, pid, operation);
    }

    public static void writeWmTaskCreated(int taskid, int stackid) {
        EventLog.writeEvent(31001, taskid, stackid);
    }

    public static void writeWmTaskMoved(int taskid, int totop, int index) {
        EventLog.writeEvent(31002, taskid, totop, index);
    }

    public static void writeWmTaskRemoved(int taskid, String reason) {
        EventLog.writeEvent(31003, taskid, reason);
    }

    public static void writeWmStackCreated(int stackid) {
        EventLog.writeEvent(31004, stackid);
    }

    public static void writeWmHomeStackMoved(int totop) {
        EventLog.writeEvent(31005, totop);
    }

    public static void writeWmStackRemoved(int stackid) {
        EventLog.writeEvent(31006, stackid);
    }

    public static void writeWmBootAnimationDone(long time) {
        EventLog.writeEvent(31007, time);
    }

    public static void writeImfForceReconnectIme(Object[] ime, long timeSinceConnect, int showing) {
        EventLog.writeEvent(32000, ime, timeSinceConnect, showing);
    }

    public static void writeWpWallpaperCrashed(String component) {
        EventLog.writeEvent(33000, component);
    }

    public static void writeDeviceIdle(int state, String reason) {
        EventLog.writeEvent(34000, state, reason);
    }

    public static void writeDeviceIdleStep() {
        EventLog.writeEvent(34001, new Object[0]);
    }

    public static void writeDeviceIdleWakeFromIdle(int isIdle, String reason) {
        EventLog.writeEvent(34002, isIdle, reason);
    }

    public static void writeDeviceIdleOnStart() {
        EventLog.writeEvent(34003, new Object[0]);
    }

    public static void writeDeviceIdleOnPhase(String what) {
        EventLog.writeEvent(34004, what);
    }

    public static void writeDeviceIdleOnComplete() {
        EventLog.writeEvent(34005, new Object[0]);
    }

    public static void writeDeviceIdleOffStart(String reason) {
        EventLog.writeEvent(34006, reason);
    }

    public static void writeDeviceIdleOffPhase(String what) {
        EventLog.writeEvent(34007, what);
    }

    public static void writeDeviceIdleOffComplete() {
        EventLog.writeEvent(34008, new Object[0]);
    }

    public static void writeDeviceIdleLight(int state, String reason) {
        EventLog.writeEvent(34009, state, reason);
    }

    public static void writeDeviceIdleLightStep() {
        EventLog.writeEvent(34010, new Object[0]);
    }

    public static void writeAutoBrightnessAdj(float oldAdj, float oldLux, float oldBrightness, float oldGamma, float newAdj, float newLux, float newBrightness, float newGamma) {
        EventLog.writeEvent(35000, Float.valueOf(oldAdj), Float.valueOf(oldLux), Float.valueOf(oldBrightness), Float.valueOf(oldGamma), Float.valueOf(newAdj), Float.valueOf(newLux), Float.valueOf(newBrightness), Float.valueOf(newGamma));
    }

    public static void writeConnectivityStateChanged(int type, int subtype, int state) {
        EventLog.writeEvent(50020, type, subtype, state);
    }

    public static void writeNetstatsMobileSample(long devRxBytes, long devTxBytes, long devRxPkts, long devTxPkts, long xtRxBytes, long xtTxBytes, long xtRxPkts, long xtTxPkts, long uidRxBytes, long uidTxBytes, long uidRxPkts, long uidTxPkts, long trustedTime) {
        EventLog.writeEvent(51100, devRxBytes, devTxBytes, devRxPkts, devTxPkts, xtRxBytes, xtTxBytes, xtRxPkts, xtTxPkts, uidRxBytes, uidTxBytes, uidRxPkts, uidTxPkts, trustedTime);
    }

    public static void writeNetstatsWifiSample(long devRxBytes, long devTxBytes, long devRxPkts, long devTxPkts, long xtRxBytes, long xtTxBytes, long xtRxPkts, long xtTxPkts, long uidRxBytes, long uidTxBytes, long uidRxPkts, long uidTxPkts, long trustedTime) {
        EventLog.writeEvent(51101, devRxBytes, devTxBytes, devRxPkts, devTxPkts, xtRxBytes, xtTxBytes, xtRxPkts, xtTxPkts, uidRxBytes, uidTxBytes, uidRxPkts, uidTxPkts, trustedTime);
    }

    public static void writeLockdownVpnConnecting(int egressNet) {
        EventLog.writeEvent(51200, egressNet);
    }

    public static void writeLockdownVpnConnected(int egressNet) {
        EventLog.writeEvent(51201, egressNet);
    }

    public static void writeLockdownVpnError(int egressNet) {
        EventLog.writeEvent(51202, egressNet);
    }

    public static void writeConfigInstallFailed(String dir) {
        EventLog.writeEvent(51300, dir);
    }

    public static void writeIfwIntentMatched(int intentType, String componentName, int callerUid, int callerPkgCount, String callerPkgs, String action, String mimeType, String uri, int flags) {
        EventLog.writeEvent(51400, intentType, componentName, callerUid, callerPkgCount, callerPkgs, action, mimeType, uri, flags);
    }

    public static void writeIdleMaintenanceWindowStart(long time, long lastuseractivity, int batterylevel, int batterycharging) {
        EventLog.writeEvent(51500, time, lastuseractivity, batterylevel, batterycharging);
    }

    public static void writeIdleMaintenanceWindowFinish(long time, long lastuseractivity, int batterylevel, int batterycharging) {
        EventLog.writeEvent(51501, time, lastuseractivity, batterylevel, batterycharging);
    }

    public static void writeFstrimStart(long time) {
        EventLog.writeEvent(2755, time);
    }

    public static void writeFstrimFinish(long time) {
        EventLog.writeEvent(2756, time);
    }

    public static void writeVolumeChanged(int stream, int prevLevel, int level, int maxLevel, String caller) {
        EventLog.writeEvent(40000, stream, prevLevel, level, maxLevel, caller);
    }

    public static void writeStreamDevicesChanged(int stream, int prevDevices, int devices) {
        EventLog.writeEvent(40001, stream, prevDevices, devices);
    }

    public static void writeCameraGestureTriggered(long gestureOnTime, long sensor1OnTime, long sensor2OnTime, int eventExtra) {
        EventLog.writeEvent(40100, gestureOnTime, sensor1OnTime, sensor2OnTime, eventExtra);
    }
}

