/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.annotation.IntDef;
import android.app.ActivityManagerNative;
import android.app.AlertDialog;
import android.app.AppGlobals;
import android.app.AppOpsManager;
import android.app.KeyguardManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.ContentObserver;
import android.graphics.drawable.Drawable;
import android.hardware.input.InputManagerInternal;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Debug;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.LocaleList;
import android.os.Message;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.text.style.SuggestionSpan;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.EventLog;
import android.util.LruCache;
import android.util.Pair;
import android.util.PrintWriterPrinter;
import android.util.Slog;
import android.util.Xml;
import android.view.ContextThemeWrapper;
import android.view.IWindowManager;
import android.view.InputChannel;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.WindowManagerInternal;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputBinding;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodManagerInternal;
import android.view.inputmethod.InputMethodSubtype;
import android.widget.ArrayAdapter;
import android.widget.CompoundButton;
import android.widget.RadioButton;
import android.widget.Switch;
import android.widget.TextView;
import android.widget.Toast;
import com.android.internal.R;
import com.android.internal.content.PackageMonitor;
import com.android.internal.inputmethod.IInputContentUriToken;
import com.android.internal.inputmethod.InputMethodSubtypeSwitchingController;
import com.android.internal.inputmethod.InputMethodUtils;
import com.android.internal.os.HandlerCaller;
import com.android.internal.os.SomeArgs;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethod;
import com.android.internal.view.IInputMethodClient;
import com.android.internal.view.IInputMethodManager;
import com.android.internal.view.IInputMethodSession;
import com.android.internal.view.IInputSessionCallback;
import com.android.internal.view.InputBindResult;
import com.android.server.InputContentUriTokenHandler;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.statusbar.StatusBarManagerService;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class InputMethodManagerService
extends IInputMethodManager.Stub
implements ServiceConnection,
Handler.Callback {
    static final boolean DEBUG = false;
    static final boolean DEBUG_RESTORE = false;
    static final String TAG = "InputMethodManagerService";
    static final int MSG_SHOW_IM_SUBTYPE_PICKER = 1;
    static final int MSG_SHOW_IM_SUBTYPE_ENABLER = 2;
    static final int MSG_SHOW_IM_CONFIG = 3;
    static final int MSG_UNBIND_INPUT = 1000;
    static final int MSG_BIND_INPUT = 1010;
    static final int MSG_SHOW_SOFT_INPUT = 1020;
    static final int MSG_HIDE_SOFT_INPUT = 1030;
    static final int MSG_HIDE_CURRENT_INPUT_METHOD = 1035;
    static final int MSG_ATTACH_TOKEN = 1040;
    static final int MSG_CREATE_SESSION = 1050;
    static final int MSG_START_INPUT = 2000;
    static final int MSG_RESTART_INPUT = 2010;
    static final int MSG_UNBIND_CLIENT = 3000;
    static final int MSG_BIND_CLIENT = 3010;
    static final int MSG_SET_ACTIVE = 3020;
    static final int MSG_SET_INTERACTIVE = 3030;
    static final int MSG_SET_USER_ACTION_NOTIFICATION_SEQUENCE_NUMBER = 3040;
    static final int MSG_SWITCH_IME = 3050;
    static final int MSG_HARD_KEYBOARD_SWITCH_CHANGED = 4000;
    static final int MSG_SYSTEM_UNLOCK_USER = 5000;
    static final long TIME_TO_RECONNECT = 3000L;
    static final int SECURE_SUGGESTION_SPANS_MAX_SIZE = 20;
    private static final int NOT_A_SUBTYPE_ID = -1;
    private static final String TAG_TRY_SUPPRESSING_IME_SWITCHER = "TrySuppressingImeSwitcher";
    final Context mContext;
    final Resources mRes;
    final Handler mHandler;
    final InputMethodUtils.InputMethodSettings mSettings;
    final SettingsObserver mSettingsObserver;
    final IWindowManager mIWindowManager;
    final WindowManagerInternal mWindowManagerInternal;
    final HandlerCaller mCaller;
    final boolean mHasFeature;
    private InputMethodFileManager mFileManager;
    private final HardKeyboardListener mHardKeyboardListener;
    private final AppOpsManager mAppOpsManager;
    private final UserManager mUserManager;
    final InputBindResult mNoBinding = new InputBindResult(null, null, null, -1, -1);
    final ArrayList<InputMethodInfo> mMethodList = new ArrayList();
    final HashMap<String, InputMethodInfo> mMethodMap = new HashMap();
    private final LruCache<SuggestionSpan, InputMethodInfo> mSecureSuggestionSpans = new LruCache(20);
    private final InputMethodSubtypeSwitchingController mSwitchingController;
    final ServiceConnection mVisibleConnection = new ServiceConnection(){

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
        }
    };
    boolean mVisibleBound = false;
    private NotificationManager mNotificationManager;
    private KeyguardManager mKeyguardManager;
    private StatusBarManagerService mStatusBar;
    private Notification.Builder mImeSwitcherNotification;
    private PendingIntent mImeSwitchPendingIntent;
    private boolean mShowOngoingImeSwitcherForPhones;
    private boolean mNotificationShown;
    private final boolean mImeSelectedOnBoot;
    final HashMap<IBinder, ClientState> mClients = new HashMap();
    boolean mSystemReady;
    String mCurMethodId;
    int mCurSeq;
    ClientState mCurClient;
    IBinder mCurFocusedWindow;
    ClientState mCurFocusedWindowClient;
    IInputContext mCurInputContext;
    int mCurInputContextMissingMethods;
    EditorInfo mCurAttribute;
    String mCurId;
    private InputMethodSubtype mCurrentSubtype;
    private final HashMap<InputMethodInfo, ArrayList<InputMethodSubtype>> mShortcutInputMethodsAndSubtypes = new HashMap();
    private boolean mCurClientInKeyguard;
    boolean mHaveConnection;
    boolean mShowRequested;
    boolean mShowExplicitlyRequested;
    boolean mShowForced;
    boolean mInputShown;
    Intent mCurIntent;
    IBinder mCurToken;
    IInputMethod mCurMethod;
    long mLastBindTime;
    boolean mBoundToMethod;
    SessionState mEnabledSession;
    boolean mIsInteractive = true;
    int mCurUserActionNotificationSequenceNumber = 0;
    int mBackDisposition = 0;
    int mImeWindowVis;
    private AlertDialog.Builder mDialogBuilder;
    private AlertDialog mSwitchingDialog;
    private View mSwitchingDialogTitleView;
    private Toast mSubtypeSwitchedByShortCutToast;
    private InputMethodInfo[] mIms;
    private int[] mSubtypeIds;
    private LocaleList mLastSystemLocales;
    private boolean mShowImeWithHardKeyboard;
    private boolean mAccessibilityRequestingNoSoftKeyboard;
    private final MyPackageMonitor mMyPackageMonitor = new MyPackageMonitor();
    private final IPackageManager mIPackageManager = AppGlobals.getPackageManager();
    private final String mSlotIme;
    private final int mHardKeyboardBehavior;

    static void restoreEnabledInputMethods(Context context, String prevValue, String newValue) {
        ArrayMap<String, ArraySet<String>> prevMap = InputMethodUtils.parseInputMethodsAndSubtypesString(prevValue);
        ArrayMap<String, ArraySet<String>> newMap = InputMethodUtils.parseInputMethodsAndSubtypesString(newValue);
        for (Map.Entry<String, ArraySet<String>> entry : newMap.entrySet()) {
            String imeId = entry.getKey();
            ArraySet<String> prevSubtypes = prevMap.get(imeId);
            if (prevSubtypes == null) {
                prevSubtypes = new ArraySet(2);
                prevMap.put(imeId, prevSubtypes);
            }
            prevSubtypes.addAll(entry.getValue());
        }
        String mergedImesAndSubtypesString = InputMethodUtils.buildInputMethodsAndSubtypesString(prevMap);
        Settings.Secure.putString(context.getContentResolver(), "enabled_input_methods", mergedImesAndSubtypesString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onUnlockUser(int userId) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            int currentUserId = this.mSettings.getCurrentUserId();
            if (userId != currentUserId) {
                return;
            }
            this.mSettings.switchCurrentUser(currentUserId, !this.mSystemReady);
            this.buildInputMethodListLocked(false);
            this.updateInputMethodsFromSettingsLocked(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSwitchUser(int userId) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            this.switchUserLocked(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputMethodManagerService(Context context) {
        this.mContext = context;
        this.mRes = context.getResources();
        this.mHandler = new Handler(this);
        this.mSettingsObserver = new SettingsObserver(this.mHandler);
        this.mIWindowManager = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
        this.mWindowManagerInternal = LocalServices.getService(WindowManagerInternal.class);
        this.mCaller = new HandlerCaller(context, null, new HandlerCaller.Callback(){

            @Override
            public void executeMessage(Message msg) {
                InputMethodManagerService.this.handleMessage(msg);
            }
        }, true);
        this.mAppOpsManager = this.mContext.getSystemService(AppOpsManager.class);
        this.mUserManager = this.mContext.getSystemService(UserManager.class);
        this.mHardKeyboardListener = new HardKeyboardListener();
        this.mHasFeature = context.getPackageManager().hasSystemFeature("android.software.input_methods");
        this.mSlotIme = this.mContext.getString(17039389);
        this.mHardKeyboardBehavior = this.mContext.getResources().getInteger(17694887);
        Bundle extras = new Bundle();
        extras.putBoolean("android.allowDuringSetup", true);
        this.mImeSwitcherNotification = new Notification.Builder(this.mContext).setSmallIcon(17302538).setWhen(0L).setOngoing(true).addExtras(extras).setCategory("sys").setColor(17170523);
        Intent intent = new Intent("android.settings.SHOW_INPUT_METHOD_PICKER");
        this.mImeSwitchPendingIntent = PendingIntent.getBroadcast(this.mContext, 0, intent, 0);
        this.mShowOngoingImeSwitcherForPhones = false;
        IntentFilter broadcastFilter = new IntentFilter();
        broadcastFilter.addAction("android.intent.action.CLOSE_SYSTEM_DIALOGS");
        broadcastFilter.addAction("android.intent.action.USER_ADDED");
        broadcastFilter.addAction("android.intent.action.USER_REMOVED");
        broadcastFilter.addAction("android.os.action.SETTING_RESTORED");
        this.mContext.registerReceiver(new ImmsBroadcastReceiver(), broadcastFilter);
        this.mNotificationShown = false;
        int userId = 0;
        try {
            userId = ActivityManagerNative.getDefault().getCurrentUser().id;
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Couldn't get current user ID; guessing it's 0", e);
        }
        this.mMyPackageMonitor.register(this.mContext, null, UserHandle.ALL, true);
        this.mSettings = new InputMethodUtils.InputMethodSettings(this.mRes, context.getContentResolver(), this.mMethodMap, this.mMethodList, userId, !this.mSystemReady);
        this.updateCurrentProfileIds();
        this.mFileManager = new InputMethodFileManager(this.mMethodMap, userId);
        HashMap<String, InputMethodInfo> e = this.mMethodMap;
        synchronized (e) {
            this.mSwitchingController = InputMethodSubtypeSwitchingController.createInstanceLocked(this.mSettings, context);
        }
        String defaultImiId = this.mSettings.getSelectedInputMethod();
        this.mImeSelectedOnBoot = !TextUtils.isEmpty(defaultImiId);
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            this.buildInputMethodListLocked(!this.mImeSelectedOnBoot);
        }
        this.mSettings.enableAllIMEsIfThereIsNoEnabledIME();
        if (!this.mImeSelectedOnBoot) {
            Slog.w(TAG, "No IME selected. Choose the most applicable IME.");
            hashMap = this.mMethodMap;
            synchronized (hashMap) {
                this.resetDefaultImeLocked(context);
            }
        }
        hashMap = this.mMethodMap;
        synchronized (hashMap) {
            this.mSettingsObserver.registerContentObserverLocked(userId);
            this.updateFromSettingsLocked(true);
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.LOCALE_CHANGED");
        this.mContext.registerReceiver(new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                HashMap<String, InputMethodInfo> hashMap = InputMethodManagerService.this.mMethodMap;
                synchronized (hashMap) {
                    InputMethodManagerService.this.resetStateIfCurrentLocaleChangedLocked();
                }
            }
        }, filter);
    }

    private void resetDefaultImeLocked(Context context) {
        if (this.mCurMethodId != null && !InputMethodUtils.isSystemIme(this.mMethodMap.get(this.mCurMethodId))) {
            return;
        }
        ArrayList<InputMethodInfo> suitableImes = InputMethodUtils.getDefaultEnabledImes(context, this.mSystemReady, this.mSettings.getEnabledInputMethodListLocked());
        if (suitableImes.isEmpty()) {
            Slog.i(TAG, "No default found");
            return;
        }
        InputMethodInfo defIm = (InputMethodInfo)suitableImes.get(0);
        Slog.i(TAG, "Default found, using " + defIm.getId());
        this.setSelectedInputMethodAndSubtypeLocked(defIm, -1, false);
    }

    private void resetAllInternalStateLocked(boolean updateOnlyWhenLocaleChanged, boolean resetDefaultEnabledIme) {
        if (!this.mSystemReady) {
            return;
        }
        LocaleList newLocales = this.mRes.getConfiguration().getLocales();
        if (!updateOnlyWhenLocaleChanged || newLocales != null && !newLocales.equals(this.mLastSystemLocales)) {
            if (!updateOnlyWhenLocaleChanged) {
                this.hideCurrentInputLocked(0, null);
                this.resetCurrentMethodAndClient(6);
            }
            this.buildInputMethodListLocked(resetDefaultEnabledIme);
            if (!updateOnlyWhenLocaleChanged) {
                String selectedImiId = this.mSettings.getSelectedInputMethod();
                if (TextUtils.isEmpty(selectedImiId)) {
                    this.resetDefaultImeLocked(this.mContext);
                }
            } else {
                this.resetDefaultImeLocked(this.mContext);
            }
            this.updateFromSettingsLocked(true);
            this.mLastSystemLocales = newLocales;
            if (!updateOnlyWhenLocaleChanged) {
                try {
                    this.startInputInnerLocked();
                }
                catch (RuntimeException e) {
                    Slog.w(TAG, "Unexpected exception", e);
                }
            }
        }
    }

    private void resetStateIfCurrentLocaleChangedLocked() {
        this.resetAllInternalStateLocked(true, true);
    }

    private void switchUserLocked(int newUserId) {
        this.mSettingsObserver.registerContentObserverLocked(newUserId);
        boolean useCopyOnWriteSettings = !this.mSystemReady || !this.mUserManager.isUserUnlockingOrUnlocked(newUserId);
        this.mSettings.switchCurrentUser(newUserId, useCopyOnWriteSettings);
        this.updateCurrentProfileIds();
        this.mFileManager = new InputMethodFileManager(this.mMethodMap, newUserId);
        String defaultImiId = this.mSettings.getSelectedInputMethod();
        boolean initialUserSwitch = TextUtils.isEmpty(defaultImiId);
        this.resetAllInternalStateLocked(false, initialUserSwitch);
        if (initialUserSwitch) {
            InputMethodUtils.setNonSelectedSystemImesDisabledUntilUsed(this.mIPackageManager, this.mSettings.getEnabledInputMethodListLocked(), newUserId, this.mContext.getBasePackageName());
        }
    }

    void updateCurrentProfileIds() {
        this.mSettings.setCurrentProfileIds(this.mUserManager.getProfileIdsWithDisabled(this.mSettings.getCurrentUserId()));
    }

    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        try {
            return super.onTransact(code, data, reply, flags);
        }
        catch (RuntimeException e) {
            if (!(e instanceof SecurityException)) {
                Slog.wtf(TAG, "Input Method Manager Crash", e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemRunning(StatusBarManagerService statusBar) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (!this.mSystemReady) {
                int currentUserId;
                this.mSystemReady = true;
                this.mSettings.switchCurrentUser(currentUserId, !this.mUserManager.isUserUnlockingOrUnlocked(currentUserId = this.mSettings.getCurrentUserId()));
                this.mKeyguardManager = this.mContext.getSystemService(KeyguardManager.class);
                this.mNotificationManager = this.mContext.getSystemService(NotificationManager.class);
                this.mStatusBar = statusBar;
                if (this.mStatusBar != null) {
                    this.mStatusBar.setIconVisibility(this.mSlotIme, false);
                }
                this.updateSystemUiLocked(this.mCurToken, this.mImeWindowVis, this.mBackDisposition);
                this.mShowOngoingImeSwitcherForPhones = this.mRes.getBoolean(17956870);
                if (this.mShowOngoingImeSwitcherForPhones) {
                    this.mWindowManagerInternal.setOnHardKeyboardStatusChangeListener(this.mHardKeyboardListener);
                }
                this.buildInputMethodListLocked(!this.mImeSelectedOnBoot);
                if (!this.mImeSelectedOnBoot) {
                    Slog.w(TAG, "Reset the default IME as \"Resource\" is ready here.");
                    this.resetStateIfCurrentLocaleChangedLocked();
                    InputMethodUtils.setNonSelectedSystemImesDisabledUntilUsed(this.mIPackageManager, this.mSettings.getEnabledInputMethodListLocked(), this.mSettings.getCurrentUserId(), this.mContext.getBasePackageName());
                }
                this.mLastSystemLocales = this.mRes.getConfiguration().getLocales();
                try {
                    this.startInputInnerLocked();
                }
                catch (RuntimeException e) {
                    Slog.w(TAG, "Unexpected exception", e);
                }
            }
        }
    }

    private boolean calledFromValidUser() {
        int uid = Binder.getCallingUid();
        int userId = UserHandle.getUserId(uid);
        if (uid == 1000 || this.mSettings.isCurrentProfile(userId)) {
            return true;
        }
        if (this.mContext.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL") == 0) {
            return true;
        }
        Slog.w(TAG, "--- IPC called from background users. Ignore. callers=" + Debug.getCallers(10));
        return false;
    }

    private boolean calledWithValidToken(IBinder token) {
        return token != null && this.mCurToken == token;
    }

    private boolean bindCurrentInputMethodService(Intent service, ServiceConnection conn, int flags) {
        if (service == null || conn == null) {
            Slog.e(TAG, "--- bind failed: service = " + service + ", conn = " + conn);
            return false;
        }
        return this.mContext.bindServiceAsUser(service, conn, flags, new UserHandle(this.mSettings.getCurrentUserId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InputMethodInfo> getInputMethodList() {
        if (!this.calledFromValidUser()) {
            return Collections.emptyList();
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            return new ArrayList<InputMethodInfo>(this.mMethodList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InputMethodInfo> getEnabledInputMethodList() {
        if (!this.calledFromValidUser()) {
            return Collections.emptyList();
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            return this.mSettings.getEnabledInputMethodListLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InputMethodSubtype> getEnabledInputMethodSubtypeList(String imiId, boolean allowsImplicitlySelectedSubtypes) {
        if (!this.calledFromValidUser()) {
            return Collections.emptyList();
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            InputMethodInfo imi = imiId == null && this.mCurMethodId != null ? this.mMethodMap.get(this.mCurMethodId) : this.mMethodMap.get(imiId);
            if (imi == null) {
                return Collections.emptyList();
            }
            return this.mSettings.getEnabledInputMethodSubtypeListLocked(this.mContext, imi, allowsImplicitlySelectedSubtypes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClient(IInputMethodClient client, IInputContext inputContext, int uid, int pid) {
        if (!this.calledFromValidUser()) {
            return;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            this.mClients.put(client.asBinder(), new ClientState(client, inputContext, uid, pid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeClient(IInputMethodClient client) {
        if (!this.calledFromValidUser()) {
            return;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            ClientState cs = this.mClients.remove(client.asBinder());
            if (cs != null) {
                this.clearClientSessionLocked(cs);
                if (this.mCurClient == cs) {
                    this.mCurClient = null;
                }
                if (this.mCurFocusedWindowClient == cs) {
                    this.mCurFocusedWindowClient = null;
                }
            }
        }
    }

    void executeOrSendMessage(IInterface target, Message msg) {
        if (target.asBinder() instanceof Binder) {
            this.mCaller.sendMessage(msg);
        } else {
            this.handleMessage(msg);
            msg.recycle();
        }
    }

    void unbindCurrentClientLocked(int unbindClientReason) {
        if (this.mCurClient != null) {
            if (this.mBoundToMethod) {
                this.mBoundToMethod = false;
                if (this.mCurMethod != null) {
                    this.executeOrSendMessage(this.mCurMethod, this.mCaller.obtainMessageO(1000, this.mCurMethod));
                }
            }
            this.executeOrSendMessage(this.mCurClient.client, this.mCaller.obtainMessageIO(3020, 0, this.mCurClient));
            this.executeOrSendMessage(this.mCurClient.client, this.mCaller.obtainMessageIIO(3000, this.mCurSeq, unbindClientReason, this.mCurClient.client));
            this.mCurClient.sessionRequested = false;
            this.mCurClient = null;
            this.hideInputMethodMenuLocked();
        }
    }

    private int getImeShowFlags() {
        int flags = 0;
        if (this.mShowForced) {
            flags |= 3;
        } else if (this.mShowExplicitlyRequested) {
            flags |= 1;
        }
        return flags;
    }

    private int getAppShowFlags() {
        int flags = 0;
        if (this.mShowForced) {
            flags |= 2;
        } else if (!this.mShowExplicitlyRequested) {
            flags |= 1;
        }
        return flags;
    }

    InputBindResult attachNewInputLocked(boolean initial) {
        if (!this.mBoundToMethod) {
            this.executeOrSendMessage(this.mCurMethod, this.mCaller.obtainMessageOO(1010, this.mCurMethod, this.mCurClient.binding));
            this.mBoundToMethod = true;
        }
        SessionState session = this.mCurClient.curSession;
        if (initial) {
            this.executeOrSendMessage(session.method, this.mCaller.obtainMessageIOOO(2000, this.mCurInputContextMissingMethods, session, this.mCurInputContext, this.mCurAttribute));
        } else {
            this.executeOrSendMessage(session.method, this.mCaller.obtainMessageIOOO(2010, this.mCurInputContextMissingMethods, session, this.mCurInputContext, this.mCurAttribute));
        }
        if (this.mShowRequested) {
            this.showCurrentInputLocked(this.getAppShowFlags(), null);
        }
        return new InputBindResult(session.session, session.channel != null ? session.channel.dup() : null, this.mCurId, this.mCurSeq, this.mCurUserActionNotificationSequenceNumber);
    }

    InputBindResult startInputLocked(int startInputReason, IInputMethodClient client, IInputContext inputContext, int missingMethods, EditorInfo attribute, int controlFlags) {
        if (this.mCurMethodId == null) {
            return this.mNoBinding;
        }
        ClientState cs = this.mClients.get(client.asBinder());
        if (cs == null) {
            throw new IllegalArgumentException("unknown client " + client.asBinder());
        }
        if (attribute == null) {
            Slog.w(TAG, "Ignoring startInput with null EditorInfo. uid=" + cs.uid + " pid=" + cs.pid);
            return null;
        }
        try {
            if (!this.mIWindowManager.inputMethodClientHasFocus(cs.client)) {
                Slog.w(TAG, "Starting input on non-focused client " + cs.client + " (uid=" + cs.uid + " pid=" + cs.pid + ")");
                return null;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return this.startInputUncheckedLocked(cs, inputContext, missingMethods, attribute, controlFlags);
    }

    InputBindResult startInputUncheckedLocked(ClientState cs, IInputContext inputContext, int missingMethods, EditorInfo attribute, int controlFlags) {
        if (this.mCurMethodId == null) {
            return this.mNoBinding;
        }
        if (!InputMethodUtils.checkIfPackageBelongsToUid(this.mAppOpsManager, cs.uid, attribute.packageName)) {
            Slog.e(TAG, "Rejecting this client as it reported an invalid package name. uid=" + cs.uid + " package=" + attribute.packageName);
            return this.mNoBinding;
        }
        if (this.mCurClient != cs) {
            this.mCurClientInKeyguard = this.isKeyguardLocked();
            this.unbindCurrentClientLocked(1);
            if (this.mIsInteractive) {
                this.executeOrSendMessage(cs.client, this.mCaller.obtainMessageIO(3020, this.mIsInteractive ? 1 : 0, cs));
            }
        }
        ++this.mCurSeq;
        if (this.mCurSeq <= 0) {
            this.mCurSeq = 1;
        }
        this.mCurClient = cs;
        this.mCurInputContext = inputContext;
        this.mCurInputContextMissingMethods = missingMethods;
        this.mCurAttribute = attribute;
        if (this.mCurId != null && this.mCurId.equals(this.mCurMethodId)) {
            if (cs.curSession != null) {
                return this.attachNewInputLocked((controlFlags & 0x100) != 0);
            }
            if (this.mHaveConnection) {
                if (this.mCurMethod != null) {
                    this.requestClientSessionLocked(cs);
                    return new InputBindResult(null, null, this.mCurId, this.mCurSeq, this.mCurUserActionNotificationSequenceNumber);
                }
                if (SystemClock.uptimeMillis() < this.mLastBindTime + 3000L) {
                    return new InputBindResult(null, null, this.mCurId, this.mCurSeq, this.mCurUserActionNotificationSequenceNumber);
                }
                EventLog.writeEvent(32000, this.mCurMethodId, SystemClock.uptimeMillis() - this.mLastBindTime, 0);
            }
        }
        return this.startInputInnerLocked();
    }

    InputBindResult startInputInnerLocked() {
        if (this.mCurMethodId == null) {
            return this.mNoBinding;
        }
        if (!this.mSystemReady) {
            return new InputBindResult(null, null, this.mCurMethodId, this.mCurSeq, this.mCurUserActionNotificationSequenceNumber);
        }
        InputMethodInfo info = this.mMethodMap.get(this.mCurMethodId);
        if (info == null) {
            throw new IllegalArgumentException("Unknown id: " + this.mCurMethodId);
        }
        this.unbindCurrentMethodLocked(true);
        this.mCurIntent = new Intent("android.view.InputMethod");
        this.mCurIntent.setComponent(info.getComponent());
        this.mCurIntent.putExtra("android.intent.extra.client_label", 17040493);
        this.mCurIntent.putExtra("android.intent.extra.client_intent", PendingIntent.getActivity(this.mContext, 0, new Intent("android.settings.INPUT_METHOD_SETTINGS"), 0));
        if (this.bindCurrentInputMethodService(this.mCurIntent, this, 0x60000005)) {
            this.mLastBindTime = SystemClock.uptimeMillis();
            this.mHaveConnection = true;
            this.mCurId = info.getId();
            this.mCurToken = new Binder();
            try {
                Slog.v(TAG, "Adding window token: " + this.mCurToken);
                this.mIWindowManager.addWindowToken(this.mCurToken, 2011);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return new InputBindResult(null, null, this.mCurId, this.mCurSeq, this.mCurUserActionNotificationSequenceNumber);
        }
        this.mCurIntent = null;
        Slog.w(TAG, "Failure connecting to input method service: " + this.mCurIntent);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputBindResult startInput(int startInputReason, IInputMethodClient client, IInputContext inputContext, int missingMethods, EditorInfo attribute, int controlFlags) {
        if (!this.calledFromValidUser()) {
            return null;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            InputBindResult inputBindResult;
            long ident = Binder.clearCallingIdentity();
            try {
                inputBindResult = this.startInputLocked(startInputReason, client, inputContext, missingMethods, attribute, controlFlags);
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
            return inputBindResult;
        }
    }

    @Override
    public void finishInput(IInputMethodClient client) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceConnected(ComponentName name, IBinder service) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (this.mCurIntent != null && name.equals(this.mCurIntent.getComponent())) {
                this.mCurMethod = IInputMethod.Stub.asInterface(service);
                if (this.mCurToken == null) {
                    Slog.w(TAG, "Service connected without a token!");
                    this.unbindCurrentMethodLocked(false);
                    return;
                }
                this.executeOrSendMessage(this.mCurMethod, this.mCaller.obtainMessageOO(1040, this.mCurMethod, this.mCurToken));
                if (this.mCurClient != null) {
                    this.clearClientSessionLocked(this.mCurClient);
                    this.requestClientSessionLocked(this.mCurClient);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSessionCreated(IInputMethod method, IInputMethodSession session, InputChannel channel) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (this.mCurMethod != null && method != null && this.mCurMethod.asBinder() == method.asBinder() && this.mCurClient != null) {
                this.clearClientSessionLocked(this.mCurClient);
                this.mCurClient.curSession = new SessionState(this.mCurClient, method, session, channel);
                InputBindResult res = this.attachNewInputLocked(true);
                if (res.method != null) {
                    this.executeOrSendMessage(this.mCurClient.client, this.mCaller.obtainMessageOO(3010, this.mCurClient.client, res));
                }
                return;
            }
        }
        channel.dispose();
    }

    void unbindCurrentMethodLocked(boolean savePosition) {
        if (this.mVisibleBound) {
            this.mContext.unbindService(this.mVisibleConnection);
            this.mVisibleBound = false;
        }
        if (this.mHaveConnection) {
            this.mContext.unbindService(this);
            this.mHaveConnection = false;
        }
        if (this.mCurToken != null) {
            try {
                if ((this.mImeWindowVis & 1) != 0 && savePosition) {
                    this.mWindowManagerInternal.saveLastInputMethodWindowForTransition();
                }
                this.mIWindowManager.removeWindowToken(this.mCurToken);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.mCurToken = null;
        }
        this.mCurId = null;
        this.clearCurMethodLocked();
    }

    void resetCurrentMethodAndClient(int unbindClientReason) {
        this.mCurMethodId = null;
        this.unbindCurrentMethodLocked(false);
        this.unbindCurrentClientLocked(unbindClientReason);
    }

    void requestClientSessionLocked(ClientState cs) {
        if (!cs.sessionRequested) {
            InputChannel[] channels = InputChannel.openInputChannelPair(cs.toString());
            cs.sessionRequested = true;
            this.executeOrSendMessage(this.mCurMethod, this.mCaller.obtainMessageOOO(1050, this.mCurMethod, channels[1], new MethodCallback(this, this.mCurMethod, channels[0])));
        }
    }

    void clearClientSessionLocked(ClientState cs) {
        this.finishSessionLocked(cs.curSession);
        cs.curSession = null;
        cs.sessionRequested = false;
    }

    private void finishSessionLocked(SessionState sessionState) {
        if (sessionState != null) {
            if (sessionState.session != null) {
                try {
                    sessionState.session.finishSession();
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Session failed to close due to remote exception", e);
                    this.updateSystemUiLocked(this.mCurToken, 0, this.mBackDisposition);
                }
                sessionState.session = null;
            }
            if (sessionState.channel != null) {
                sessionState.channel.dispose();
                sessionState.channel = null;
            }
        }
    }

    void clearCurMethodLocked() {
        if (this.mCurMethod != null) {
            for (ClientState cs : this.mClients.values()) {
                this.clearClientSessionLocked(cs);
            }
            this.finishSessionLocked(this.mEnabledSession);
            this.mEnabledSession = null;
            this.mCurMethod = null;
        }
        if (this.mStatusBar != null) {
            this.mStatusBar.setIconVisibility(this.mSlotIme, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceDisconnected(ComponentName name) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (this.mCurMethod != null && this.mCurIntent != null && name.equals(this.mCurIntent.getComponent())) {
                this.clearCurMethodLocked();
                this.mLastBindTime = SystemClock.uptimeMillis();
                this.mShowRequested = this.mInputShown;
                this.mInputShown = false;
                if (this.mCurClient != null) {
                    this.executeOrSendMessage(this.mCurClient.client, this.mCaller.obtainMessageIIO(3000, 3, this.mCurSeq, this.mCurClient.client));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateStatusIcon(IBinder token, String packageName, int iconId) {
        long ident = Binder.clearCallingIdentity();
        try {
            HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
            synchronized (hashMap) {
                block15: {
                    if (this.calledWithValidToken(token)) break block15;
                    int uid = Binder.getCallingUid();
                    Slog.e(TAG, "Ignoring updateStatusIcon due to an invalid token. uid:" + uid + " token:" + token);
                    return;
                }
                if (iconId == 0) {
                    if (this.mStatusBar != null) {
                        this.mStatusBar.setIconVisibility(this.mSlotIme, false);
                    }
                } else if (packageName != null) {
                    CharSequence contentDescription = null;
                    try {
                        PackageManager packageManager = this.mContext.getPackageManager();
                        contentDescription = packageManager.getApplicationLabel(this.mIPackageManager.getApplicationInfo(packageName, 0, this.mSettings.getCurrentUserId()));
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    if (this.mStatusBar != null) {
                        this.mStatusBar.setIcon(this.mSlotIme, packageName, iconId, 0, contentDescription != null ? contentDescription.toString() : null);
                        this.mStatusBar.setIconVisibility(this.mSlotIme, true);
                    }
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private boolean shouldShowImeSwitcherLocked(int visibility) {
        ArrayList<InputMethodInfo> imis;
        int N;
        if (!this.mShowOngoingImeSwitcherForPhones) {
            return false;
        }
        if (this.mSwitchingDialog != null) {
            return false;
        }
        if (this.isScreenLocked()) {
            return false;
        }
        if ((visibility & 1) == 0) {
            return false;
        }
        if (this.mWindowManagerInternal.isHardKeyboardAvailable()) {
            if (this.mHardKeyboardBehavior == 0) {
                return true;
            }
        } else if ((visibility & 2) == 0) {
            return false;
        }
        if ((N = (imis = this.mSettings.getEnabledInputMethodListLocked()).size()) > 2) {
            return true;
        }
        if (N < 1) {
            return false;
        }
        int nonAuxCount = 0;
        int auxCount = 0;
        InputMethodSubtype nonAuxSubtype = null;
        InputMethodSubtype auxSubtype = null;
        for (int i = 0; i < N; ++i) {
            InputMethodInfo imi = (InputMethodInfo)imis.get(i);
            List<InputMethodSubtype> subtypes = this.mSettings.getEnabledInputMethodSubtypeListLocked(this.mContext, imi, true);
            int subtypeCount = subtypes.size();
            if (subtypeCount == 0) {
                ++nonAuxCount;
                continue;
            }
            for (int j = 0; j < subtypeCount; ++j) {
                InputMethodSubtype subtype = subtypes.get(j);
                if (!subtype.isAuxiliary()) {
                    ++nonAuxCount;
                    nonAuxSubtype = subtype;
                    continue;
                }
                ++auxCount;
                auxSubtype = subtype;
            }
        }
        if (nonAuxCount > 1 || auxCount > 1) {
            return true;
        }
        if (nonAuxCount == 1 && auxCount == 1) {
            return nonAuxSubtype == null || auxSubtype == null || !nonAuxSubtype.getLocale().equals(auxSubtype.getLocale()) && !auxSubtype.overridesImplicitlyEnabledSubtype() && !nonAuxSubtype.overridesImplicitlyEnabledSubtype() || !nonAuxSubtype.containsExtraValueKey(TAG_TRY_SUPPRESSING_IME_SWITCHER);
        }
        return false;
    }

    private boolean isKeyguardLocked() {
        return this.mKeyguardManager != null && this.mKeyguardManager.isKeyguardLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setImeWindowStatus(IBinder token, int vis, int backDisposition) {
        if (!this.calledWithValidToken(token)) {
            int uid = Binder.getCallingUid();
            Slog.e(TAG, "Ignoring setImeWindowStatus due to an invalid token. uid:" + uid + " token:" + token);
            return;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            this.mImeWindowVis = vis;
            this.mBackDisposition = backDisposition;
            this.updateSystemUiLocked(token, vis, backDisposition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSystemUi(IBinder token, int vis, int backDisposition) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            this.updateSystemUiLocked(token, vis, backDisposition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSystemUiLocked(IBinder token, int vis, int backDisposition) {
        block11: {
            if (!this.calledWithValidToken(token)) {
                int uid = Binder.getCallingUid();
                Slog.e(TAG, "Ignoring updateSystemUiLocked due to an invalid token. uid:" + uid + " token:" + token);
                return;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                InputMethodInfo imi;
                if (vis != 0 && this.isKeyguardLocked() && !this.mCurClientInKeyguard) {
                    vis = 0;
                }
                boolean needsToShowImeSwitcher = this.shouldShowImeSwitcherLocked(vis);
                if (this.mStatusBar != null) {
                    this.mStatusBar.setImeWindowStatus(token, vis, backDisposition, needsToShowImeSwitcher);
                }
                if ((imi = this.mMethodMap.get(this.mCurMethodId)) != null && needsToShowImeSwitcher) {
                    CharSequence title = this.mRes.getText(17040422);
                    CharSequence summary = InputMethodUtils.getImeAndSubtypeDisplayName(this.mContext, imi, this.mCurrentSubtype);
                    this.mImeSwitcherNotification.setContentTitle(title).setContentText(summary).setContentIntent(this.mImeSwitchPendingIntent);
                    try {
                        if (this.mNotificationManager != null && !this.mIWindowManager.hasNavigationBar()) {
                            this.mNotificationManager.notifyAsUser(null, 17040422, this.mImeSwitcherNotification.build(), UserHandle.ALL);
                            this.mNotificationShown = true;
                        }
                        break block11;
                    }
                    catch (RemoteException remoteException) {}
                    break block11;
                }
                if (this.mNotificationShown && this.mNotificationManager != null) {
                    this.mNotificationManager.cancelAsUser(null, 17040422, UserHandle.ALL);
                    this.mNotificationShown = false;
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSuggestionSpansForNotification(SuggestionSpan[] spans) {
        if (!this.calledFromValidUser()) {
            return;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            InputMethodInfo currentImi = this.mMethodMap.get(this.mCurMethodId);
            for (int i = 0; i < spans.length; ++i) {
                SuggestionSpan ss = spans[i];
                if (TextUtils.isEmpty(ss.getNotificationTargetClassName())) continue;
                this.mSecureSuggestionSpans.put(ss, currentImi);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean notifySuggestionPicked(SuggestionSpan span, String originalString, int index) {
        if (!this.calledFromValidUser()) {
            return false;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            InputMethodInfo targetImi = this.mSecureSuggestionSpans.get(span);
            if (targetImi != null) {
                String[] suggestions = span.getSuggestions();
                if (index < 0 || index >= suggestions.length) {
                    return false;
                }
                String className = span.getNotificationTargetClassName();
                Intent intent = new Intent();
                intent.setClassName(targetImi.getPackageName(), className);
                intent.setAction("android.text.style.SUGGESTION_PICKED");
                intent.putExtra("before", originalString);
                intent.putExtra("after", suggestions[index]);
                intent.putExtra("hashcode", span.hashCode());
                long ident = Binder.clearCallingIdentity();
                try {
                    this.mContext.sendBroadcastAsUser(intent, UserHandle.CURRENT);
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
                return true;
            }
        }
        return false;
    }

    void updateFromSettingsLocked(boolean enabledMayChange) {
        this.updateInputMethodsFromSettingsLocked(enabledMayChange);
        this.updateKeyboardFromSettingsLocked();
    }

    void updateInputMethodsFromSettingsLocked(boolean enabledMayChange) {
        String id2;
        if (enabledMayChange) {
            ArrayList<InputMethodInfo> enabled = this.mSettings.getEnabledInputMethodListLocked();
            for (int i = 0; i < enabled.size(); ++i) {
                InputMethodInfo imm = (InputMethodInfo)enabled.get(i);
                try {
                    ApplicationInfo ai = this.mIPackageManager.getApplicationInfo(imm.getPackageName(), 32768, this.mSettings.getCurrentUserId());
                    if (ai == null || ai.enabledSetting != 4) continue;
                    this.mIPackageManager.setApplicationEnabledSetting(imm.getPackageName(), 0, 1, this.mSettings.getCurrentUserId(), this.mContext.getBasePackageName());
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        if (TextUtils.isEmpty(id2 = this.mSettings.getSelectedInputMethod()) && this.chooseNewDefaultIMELocked()) {
            id2 = this.mSettings.getSelectedInputMethod();
        }
        if (!TextUtils.isEmpty(id2)) {
            try {
                this.setInputMethodLocked(id2, this.mSettings.getSelectedInputMethodSubtypeId(id2));
            }
            catch (IllegalArgumentException e) {
                Slog.w(TAG, "Unknown input method from prefs: " + id2, e);
                this.resetCurrentMethodAndClient(5);
            }
            this.mShortcutInputMethodsAndSubtypes.clear();
        } else {
            this.resetCurrentMethodAndClient(4);
        }
        this.mSwitchingController.resetCircularListLocked(this.mContext);
    }

    public void updateKeyboardFromSettingsLocked() {
        this.mShowImeWithHardKeyboard = this.mSettings.isShowImeWithHardKeyboardEnabled();
        if (this.mSwitchingDialog != null && this.mSwitchingDialogTitleView != null && this.mSwitchingDialog.isShowing()) {
            Switch hardKeySwitch = (Switch)this.mSwitchingDialogTitleView.findViewById(16909195);
            hardKeySwitch.setChecked(this.mShowImeWithHardKeyboard);
        }
    }

    private void notifyInputMethodSubtypeChanged(int userId, InputMethodInfo inputMethodInfo, InputMethodSubtype subtype) {
        InputManagerInternal inputManagerInternal = LocalServices.getService(InputManagerInternal.class);
        if (inputManagerInternal != null) {
            inputManagerInternal.onInputMethodSubtypeChanged(userId, inputMethodInfo, subtype);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInputMethodLocked(String id2, int subtypeId) {
        InputMethodInfo info = this.mMethodMap.get(id2);
        if (info == null) {
            throw new IllegalArgumentException("Unknown id: " + id2);
        }
        if (id2.equals(this.mCurMethodId)) {
            int subtypeCount = info.getSubtypeCount();
            if (subtypeCount <= 0) {
                return;
            }
            InputMethodSubtype oldSubtype = this.mCurrentSubtype;
            InputMethodSubtype newSubtype = subtypeId >= 0 && subtypeId < subtypeCount ? info.getSubtypeAt(subtypeId) : this.getCurrentInputMethodSubtypeLocked();
            if (newSubtype == null || oldSubtype == null) {
                Slog.w(TAG, "Illegal subtype state: old subtype = " + oldSubtype + ", new subtype = " + newSubtype);
                return;
            }
            if (newSubtype != oldSubtype) {
                this.setSelectedInputMethodAndSubtypeLocked(info, subtypeId, true);
                if (this.mCurMethod != null) {
                    try {
                        this.updateSystemUiLocked(this.mCurToken, this.mImeWindowVis, this.mBackDisposition);
                        this.mCurMethod.changeInputMethodSubtype(newSubtype);
                    }
                    catch (RemoteException e) {
                        Slog.w(TAG, "Failed to call changeInputMethodSubtype");
                        return;
                    }
                }
                this.notifyInputMethodSubtypeChanged(this.mSettings.getCurrentUserId(), info, newSubtype);
            }
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.setSelectedInputMethodAndSubtypeLocked(info, subtypeId, false);
            this.mCurMethodId = id2;
            if (ActivityManagerNative.isSystemReady()) {
                Intent intent = new Intent("android.intent.action.INPUT_METHOD_CHANGED");
                intent.addFlags(0x20000000);
                intent.putExtra("input_method_id", id2);
                this.mContext.sendBroadcastAsUser(intent, UserHandle.CURRENT);
            }
            this.unbindCurrentClientLocked(2);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        this.notifyInputMethodSubtypeChanged(this.mSettings.getCurrentUserId(), info, this.getCurrentInputMethodSubtypeLocked());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean showSoftInput(IInputMethodClient client, int flags, ResultReceiver resultReceiver) {
        boolean bl;
        if (!this.calledFromValidUser()) {
            return false;
        }
        int uid = Binder.getCallingUid();
        long ident = Binder.clearCallingIdentity();
        try {
            HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
            synchronized (hashMap) {
                block11: {
                    if (this.mCurClient == null || client == null || this.mCurClient.client.asBinder() != client.asBinder()) {
                        boolean bl2;
                        try {
                            if (this.mIWindowManager.inputMethodClientHasFocus(client)) break block11;
                            Slog.w(TAG, "Ignoring showSoftInput of uid " + uid + ": " + client);
                            bl2 = false;
                            // MONITOREXIT @DISABLED, blocks:[0, 2, 6, 10] lbl14 : MonitorExitStatement: MONITOREXIT : var7_6
                        }
                        catch (RemoteException e) {
                            boolean bl3 = false;
                            // MONITOREXIT @DISABLED, blocks:[0, 6, 7, 10] lbl19 : MonitorExitStatement: MONITOREXIT : var7_6
                            Binder.restoreCallingIdentity(ident);
                            return bl3;
                        }
                        Binder.restoreCallingIdentity(ident);
                        return bl2;
                    }
                }
                bl = this.showCurrentInputLocked(flags, resultReceiver);
            }
        }
        catch (Throwable throwable) {
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
        return bl;
    }

    boolean showCurrentInputLocked(int flags, ResultReceiver resultReceiver) {
        this.mShowRequested = true;
        if (this.mAccessibilityRequestingNoSoftKeyboard) {
            return false;
        }
        if ((flags & 2) != 0) {
            this.mShowExplicitlyRequested = true;
            this.mShowForced = true;
        } else if ((flags & 1) == 0) {
            this.mShowExplicitlyRequested = true;
        }
        if (!this.mSystemReady) {
            return false;
        }
        boolean res = false;
        if (this.mCurMethod != null) {
            this.executeOrSendMessage(this.mCurMethod, this.mCaller.obtainMessageIOO(1020, this.getImeShowFlags(), this.mCurMethod, resultReceiver));
            this.mInputShown = true;
            if (this.mHaveConnection && !this.mVisibleBound) {
                this.bindCurrentInputMethodService(this.mCurIntent, this.mVisibleConnection, 0xC000001);
                this.mVisibleBound = true;
            }
            res = true;
        } else if (this.mHaveConnection && SystemClock.uptimeMillis() >= this.mLastBindTime + 3000L) {
            EventLog.writeEvent(32000, this.mCurMethodId, SystemClock.uptimeMillis() - this.mLastBindTime, 1);
            Slog.w(TAG, "Force disconnect/connect to the IME in showCurrentInputLocked()");
            this.mContext.unbindService(this);
            this.bindCurrentInputMethodService(this.mCurIntent, this, 0x40000001);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hideSoftInput(IInputMethodClient client, int flags, ResultReceiver resultReceiver) {
        boolean bl;
        if (!this.calledFromValidUser()) {
            return false;
        }
        int uid = Binder.getCallingUid();
        long ident = Binder.clearCallingIdentity();
        try {
            HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
            synchronized (hashMap) {
                block11: {
                    if (this.mCurClient == null || client == null || this.mCurClient.client.asBinder() != client.asBinder()) {
                        boolean bl2;
                        try {
                            if (this.mIWindowManager.inputMethodClientHasFocus(client)) break block11;
                            bl2 = false;
                            // MONITOREXIT @DISABLED, blocks:[0, 2, 6, 10] lbl12 : MonitorExitStatement: MONITOREXIT : var7_6
                        }
                        catch (RemoteException e) {
                            boolean bl3 = false;
                            // MONITOREXIT @DISABLED, blocks:[0, 6, 7, 10] lbl17 : MonitorExitStatement: MONITOREXIT : var7_6
                            Binder.restoreCallingIdentity(ident);
                            return bl3;
                        }
                        Binder.restoreCallingIdentity(ident);
                        return bl2;
                    }
                }
                bl = this.hideCurrentInputLocked(flags, resultReceiver);
            }
        }
        catch (Throwable throwable) {
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
        return bl;
    }

    boolean hideCurrentInputLocked(int flags, ResultReceiver resultReceiver) {
        boolean res;
        boolean shouldHideSoftInput;
        if ((flags & 1) != 0 && (this.mShowExplicitlyRequested || this.mShowForced)) {
            return false;
        }
        if (this.mShowForced && (flags & 2) != 0) {
            return false;
        }
        boolean bl = shouldHideSoftInput = this.mCurMethod != null && (this.mInputShown || (this.mImeWindowVis & 1) != 0);
        if (shouldHideSoftInput) {
            this.executeOrSendMessage(this.mCurMethod, this.mCaller.obtainMessageOO(1030, this.mCurMethod, resultReceiver));
            res = true;
        } else {
            res = false;
        }
        if (this.mHaveConnection && this.mVisibleBound) {
            this.mContext.unbindService(this.mVisibleConnection);
            this.mVisibleBound = false;
        }
        this.mInputShown = false;
        this.mShowRequested = false;
        this.mShowExplicitlyRequested = false;
        this.mShowForced = false;
        return res;
    }

    @Override
    public InputBindResult startInputOrWindowGainedFocus(int startInputReason, IInputMethodClient client, IBinder windowToken, int controlFlags, int softInputMode, int windowFlags, EditorInfo attribute, IInputContext inputContext, int missingMethods) {
        if (windowToken != null) {
            return this.windowGainedFocus(startInputReason, client, windowToken, controlFlags, softInputMode, windowFlags, attribute, inputContext, missingMethods);
        }
        return this.startInput(startInputReason, client, inputContext, missingMethods, attribute, controlFlags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private InputBindResult windowGainedFocus(int startInputReason, IInputMethodClient client, IBinder windowToken, int controlFlags, int softInputMode, int windowFlags, EditorInfo attribute, IInputContext inputContext, int missingMethods) {
        ClientState cs;
        long ident;
        InputBindResult res;
        block29: {
            boolean calledFromValidUser;
            block28: {
                InputBindResult inputBindResult;
                calledFromValidUser = this.calledFromValidUser();
                res = null;
                ident = Binder.clearCallingIdentity();
                HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
                // MONITORENTER : hashMap
                cs = this.mClients.get(client.asBinder());
                if (cs == null) {
                    throw new IllegalArgumentException("unknown client " + client.asBinder());
                }
                try {
                    if (this.mIWindowManager.inputMethodClientHasFocus(cs.client)) break block28;
                    Slog.w(TAG, "Focus gain on non-focused client " + cs.client + " (uid=" + cs.uid + " pid=" + cs.pid + ")");
                    inputBindResult = null;
                    // MONITOREXIT : hashMap
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                Binder.restoreCallingIdentity(ident);
                return inputBindResult;
            }
            if (calledFromValidUser) break block29;
            Slog.w(TAG, "A background user is requesting window. Hiding IME.");
            Slog.w(TAG, "If you want to interect with IME, you need android.permission.INTERACT_ACROSS_USERS_FULL");
            this.hideCurrentInputLocked(0, null);
            InputBindResult inputBindResult = null;
            // MONITOREXIT : hashMap
            Binder.restoreCallingIdentity(ident);
            return inputBindResult;
        }
        if (this.mCurFocusedWindow == windowToken) {
            Slog.w(TAG, "Window already focused, ignoring focus gain of: " + client + " attribute=" + attribute + ", token = " + windowToken);
            if (attribute != null) {
                InputBindResult inputBindResult = this.startInputUncheckedLocked(cs, inputContext, missingMethods, attribute, controlFlags);
                // MONITOREXIT : hashMap
                Binder.restoreCallingIdentity(ident);
                return inputBindResult;
            }
            InputBindResult inputBindResult = null;
            // MONITOREXIT : hashMap
            Binder.restoreCallingIdentity(ident);
            return inputBindResult;
        }
        try {
            this.mCurFocusedWindow = windowToken;
            this.mCurFocusedWindowClient = cs;
            boolean doAutoShow = (softInputMode & 0xF0) == 16 || this.mRes.getConfiguration().isLayoutSizeAtLeast(3);
            boolean isTextEditor = (controlFlags & 2) != 0;
            boolean didStart = false;
            switch (softInputMode & 0xF) {
                case 0: {
                    if (!isTextEditor || !doAutoShow) {
                        if (!WindowManager.LayoutParams.mayUseInputMethod(windowFlags)) break;
                        this.hideCurrentInputLocked(2, null);
                        break;
                    }
                    if (!isTextEditor || !doAutoShow || (softInputMode & 0x100) == 0) break;
                    if (attribute != null) {
                        res = this.startInputUncheckedLocked(cs, inputContext, missingMethods, attribute, controlFlags);
                        didStart = true;
                    }
                    this.showCurrentInputLocked(1, null);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    if ((softInputMode & 0x100) == 0) break;
                    this.hideCurrentInputLocked(0, null);
                    break;
                }
                case 3: {
                    this.hideCurrentInputLocked(0, null);
                    break;
                }
                case 4: {
                    if ((softInputMode & 0x100) == 0) break;
                    if (attribute != null) {
                        res = this.startInputUncheckedLocked(cs, inputContext, missingMethods, attribute, controlFlags);
                        didStart = true;
                    }
                    this.showCurrentInputLocked(1, null);
                    break;
                }
                case 5: {
                    if (attribute != null) {
                        res = this.startInputUncheckedLocked(cs, inputContext, missingMethods, attribute, controlFlags);
                        didStart = true;
                    }
                    this.showCurrentInputLocked(1, null);
                    break;
                }
            }
            if (!didStart && attribute != null) {
                res = this.startInputUncheckedLocked(cs, inputContext, missingMethods, attribute, controlFlags);
            }
            // MONITOREXIT : hashMap
            return res;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showInputMethodPickerFromClient(IInputMethodClient client, int auxiliarySubtypeMode) {
        if (!this.calledFromValidUser()) {
            return;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (this.mCurClient == null || client == null || this.mCurClient.client.asBinder() != client.asBinder()) {
                Slog.w(TAG, "Ignoring showInputMethodPickerFromClient of uid " + Binder.getCallingUid() + ": " + client);
            }
            this.mHandler.sendMessage(this.mCaller.obtainMessageI(1, auxiliarySubtypeMode));
        }
    }

    @Override
    public void setInputMethod(IBinder token, String id2) {
        if (!this.calledFromValidUser()) {
            return;
        }
        this.setInputMethodWithSubtypeId(token, id2, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInputMethodAndSubtype(IBinder token, String id2, InputMethodSubtype subtype) {
        if (!this.calledFromValidUser()) {
            return;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (subtype != null) {
                this.setInputMethodWithSubtypeIdLocked(token, id2, InputMethodUtils.getSubtypeIdFromHashCode(this.mMethodMap.get(id2), subtype.hashCode()));
            } else {
                this.setInputMethod(token, id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showInputMethodAndSubtypeEnablerFromClient(IInputMethodClient client, String inputMethodId) {
        if (!this.calledFromValidUser()) {
            return;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            this.executeOrSendMessage(this.mCurMethod, this.mCaller.obtainMessageO(2, inputMethodId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean switchToLastInputMethod(IBinder token) {
        if (!this.calledFromValidUser()) {
            return false;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            ArrayList<InputMethodInfo> enabled;
            Pair<String, String> lastIme = this.mSettings.getLastInputMethodAndSubtypeLocked();
            InputMethodInfo lastImi = lastIme != null ? this.mMethodMap.get(lastIme.first) : null;
            String targetLastImiId = null;
            int subtypeId = -1;
            if (lastIme != null && lastImi != null) {
                int currentSubtypeHash;
                boolean imiIdIsSame = lastImi.getId().equals(this.mCurMethodId);
                int lastSubtypeHash = Integer.parseInt((String)lastIme.second);
                int n = currentSubtypeHash = this.mCurrentSubtype == null ? -1 : this.mCurrentSubtype.hashCode();
                if (!imiIdIsSame || lastSubtypeHash != currentSubtypeHash) {
                    targetLastImiId = (String)lastIme.first;
                    subtypeId = InputMethodUtils.getSubtypeIdFromHashCode(lastImi, lastSubtypeHash);
                }
            }
            if (TextUtils.isEmpty(targetLastImiId) && !InputMethodUtils.canAddToLastInputMethod(this.mCurrentSubtype) && (enabled = this.mSettings.getEnabledInputMethodListLocked()) != null) {
                int N = enabled.size();
                String locale = this.mCurrentSubtype == null ? this.mRes.getConfiguration().locale.toString() : this.mCurrentSubtype.getLocale();
                for (int i = 0; i < N; ++i) {
                    InputMethodSubtype keyboardSubtype;
                    InputMethodInfo imi = (InputMethodInfo)enabled.get(i);
                    if (imi.getSubtypeCount() <= 0 || !InputMethodUtils.isSystemIme(imi) || (keyboardSubtype = InputMethodUtils.findLastResortApplicableSubtypeLocked(this.mRes, InputMethodUtils.getSubtypes(imi), "keyboard", locale, true)) == null) continue;
                    targetLastImiId = imi.getId();
                    subtypeId = InputMethodUtils.getSubtypeIdFromHashCode(imi, keyboardSubtype.hashCode());
                    if (keyboardSubtype.getLocale().equals(locale)) break;
                }
            }
            if (!TextUtils.isEmpty(targetLastImiId)) {
                this.setInputMethodWithSubtypeIdLocked(token, targetLastImiId, subtypeId);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean switchToNextInputMethod(IBinder token, boolean onlyCurrentIme) {
        if (!this.calledFromValidUser()) {
            return false;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (!this.calledWithValidToken(token)) {
                int uid = Binder.getCallingUid();
                Slog.e(TAG, "Ignoring switchToNextInputMethod due to an invalid token. uid:" + uid + " token:" + token);
                return false;
            }
            InputMethodSubtypeSwitchingController.ImeSubtypeListItem nextSubtype = this.mSwitchingController.getNextInputMethodLocked(onlyCurrentIme, this.mMethodMap.get(this.mCurMethodId), this.mCurrentSubtype, true);
            if (nextSubtype == null) {
                return false;
            }
            this.setInputMethodWithSubtypeIdLocked(token, nextSubtype.mImi.getId(), nextSubtype.mSubtypeId);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldOfferSwitchingToNextInputMethod(IBinder token) {
        if (!this.calledFromValidUser()) {
            return false;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (!this.calledWithValidToken(token)) {
                int uid = Binder.getCallingUid();
                Slog.e(TAG, "Ignoring shouldOfferSwitchingToNextInputMethod due to an invalid token. uid:" + uid + " token:" + token);
                return false;
            }
            InputMethodSubtypeSwitchingController.ImeSubtypeListItem nextSubtype = this.mSwitchingController.getNextInputMethodLocked(false, this.mMethodMap.get(this.mCurMethodId), this.mCurrentSubtype, true);
            return nextSubtype != null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputMethodSubtype getLastInputMethodSubtype() {
        if (!this.calledFromValidUser()) {
            return null;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            Pair<String, String> lastIme = this.mSettings.getLastInputMethodAndSubtypeLocked();
            if (lastIme == null || TextUtils.isEmpty((CharSequence)lastIme.first) || TextUtils.isEmpty((CharSequence)lastIme.second)) {
                return null;
            }
            InputMethodInfo lastImi = this.mMethodMap.get(lastIme.first);
            if (lastImi == null) {
                return null;
            }
            try {
                int lastSubtypeHash = Integer.parseInt((String)lastIme.second);
                int lastSubtypeId = InputMethodUtils.getSubtypeIdFromHashCode(lastImi, lastSubtypeHash);
                if (lastSubtypeId < 0 || lastSubtypeId >= lastImi.getSubtypeCount()) {
                    return null;
                }
                return lastImi.getSubtypeAt(lastSubtypeId);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAdditionalInputMethodSubtypes(String imiId, InputMethodSubtype[] subtypes) {
        if (!this.calledFromValidUser()) {
            return;
        }
        if (TextUtils.isEmpty(imiId) || subtypes == null) {
            return;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            String[] packageInfos;
            InputMethodInfo imi = this.mMethodMap.get(imiId);
            if (imi == null) {
                return;
            }
            try {
                packageInfos = this.mIPackageManager.getPackagesForUid(Binder.getCallingUid());
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to get package infos");
                return;
            }
            if (packageInfos != null) {
                int packageNum = packageInfos.length;
                for (int i = 0; i < packageNum; ++i) {
                    if (!packageInfos[i].equals(imi.getPackageName())) continue;
                    this.mFileManager.addInputMethodSubtypes(imi, subtypes);
                    long ident = Binder.clearCallingIdentity();
                    try {
                        this.buildInputMethodListLocked(false);
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                    return;
                }
            }
        }
    }

    @Override
    public int getInputMethodWindowVisibleHeight() {
        return this.mWindowManagerInternal.getInputMethodWindowVisibleHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void clearLastInputMethodWindowForTransition(IBinder token) {
        if (!this.calledFromValidUser()) {
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
            synchronized (hashMap) {
                if (!this.calledWithValidToken(token)) {
                    int uid = Binder.getCallingUid();
                    Slog.e(TAG, "Ignoring clearLastInputMethodWindowForTransition due to an invalid token. uid:" + uid + " token:" + token);
                    return;
                }
            }
            this.mWindowManagerInternal.clearLastInputMethodWindowForTransition();
            return;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyUserAction(int sequenceNumber) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (this.mCurUserActionNotificationSequenceNumber != sequenceNumber) {
                return;
            }
            InputMethodInfo imi = this.mMethodMap.get(this.mCurMethodId);
            if (imi != null) {
                this.mSwitchingController.onUserActionLocked(imi, this.mCurrentSubtype);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInputMethodWithSubtypeId(IBinder token, String id2, int subtypeId) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            this.setInputMethodWithSubtypeIdLocked(token, id2, subtypeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInputMethodWithSubtypeIdLocked(IBinder token, String id2, int subtypeId) {
        if (token == null) {
            if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
                throw new SecurityException("Using null token requires permission android.permission.WRITE_SECURE_SETTINGS");
            }
        } else if (this.mCurToken != token) {
            Slog.w(TAG, "Ignoring setInputMethod of uid " + Binder.getCallingUid() + " token: " + token);
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.setInputMethodLocked(id2, subtypeId);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hideMySoftInput(IBinder token, int flags) {
        if (!this.calledFromValidUser()) {
            return;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (!this.calledWithValidToken(token)) {
                int uid = Binder.getCallingUid();
                Slog.e(TAG, "Ignoring hideInputMethod due to an invalid token. uid:" + uid + " token:" + token);
                return;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                this.hideCurrentInputLocked(flags, null);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showMySoftInput(IBinder token, int flags) {
        if (!this.calledFromValidUser()) {
            return;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (!this.calledWithValidToken(token)) {
                int uid = Binder.getCallingUid();
                Slog.e(TAG, "Ignoring showMySoftInput due to an invalid token. uid:" + uid + " token:" + token);
                return;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                this.showCurrentInputLocked(flags, null);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    void setEnabledSessionInMainThread(SessionState session) {
        if (this.mEnabledSession != session) {
            if (this.mEnabledSession != null && this.mEnabledSession.session != null) {
                try {
                    this.mEnabledSession.method.setSessionEnabled(this.mEnabledSession.session, false);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mEnabledSession = session;
            if (this.mEnabledSession != null && this.mEnabledSession.session != null) {
                try {
                    this.mEnabledSession.method.setSessionEnabled(this.mEnabledSession.session, true);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                boolean showAuxSubtypes;
                switch (msg.arg1) {
                    case 0: {
                        showAuxSubtypes = this.mInputShown;
                        break;
                    }
                    case 1: {
                        showAuxSubtypes = true;
                        break;
                    }
                    case 2: {
                        showAuxSubtypes = false;
                        break;
                    }
                    default: {
                        Slog.e(TAG, "Unknown subtype picker mode = " + msg.arg1);
                        return false;
                    }
                }
                this.showInputMethodMenu(showAuxSubtypes);
                return true;
            }
            case 2: {
                this.showInputMethodAndSubtypeEnabler((String)msg.obj);
                return true;
            }
            case 3: {
                this.showConfigureInputMethods();
                return true;
            }
            case 1000: {
                try {
                    ((IInputMethod)msg.obj).unbindInput();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                return true;
            }
            case 1010: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    ((IInputMethod)args.arg1).bindInput((InputBinding)args.arg2);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                args.recycle();
                return true;
            }
            case 1020: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    ((IInputMethod)args.arg1).showSoftInput(msg.arg1, (ResultReceiver)args.arg2);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                args.recycle();
                return true;
            }
            case 1030: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    ((IInputMethod)args.arg1).hideSoftInput(0, (ResultReceiver)args.arg2);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                args.recycle();
                return true;
            }
            case 1035: {
                HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
                synchronized (hashMap) {
                    this.hideCurrentInputLocked(0, null);
                }
                return true;
            }
            case 1040: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    ((IInputMethod)args.arg1).attachToken((IBinder)args.arg2);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                args.recycle();
                return true;
            }
            case 1050: {
                SomeArgs args = (SomeArgs)msg.obj;
                IInputMethod method = (IInputMethod)args.arg1;
                InputChannel channel = (InputChannel)args.arg2;
                try {
                    method.createSession(channel, (IInputSessionCallback)args.arg3);
                }
                catch (RemoteException remoteException) {
                }
                finally {
                    if (channel != null && Binder.isProxy(method)) {
                        channel.dispose();
                    }
                }
                args.recycle();
                return true;
            }
            case 2000: {
                int missingMethods = msg.arg1;
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    SessionState session = (SessionState)args.arg1;
                    this.setEnabledSessionInMainThread(session);
                    session.method.startInput((IInputContext)args.arg2, missingMethods, (EditorInfo)args.arg3);
                }
                catch (RemoteException session) {
                    // empty catch block
                }
                args.recycle();
                return true;
            }
            case 2010: {
                int missingMethods = msg.arg1;
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    SessionState session = (SessionState)args.arg1;
                    this.setEnabledSessionInMainThread(session);
                    session.method.restartInput((IInputContext)args.arg2, missingMethods, (EditorInfo)args.arg3);
                }
                catch (RemoteException session) {
                    // empty catch block
                }
                args.recycle();
                return true;
            }
            case 3000: {
                try {
                    ((IInputMethodClient)msg.obj).onUnbindMethod(msg.arg1, msg.arg2);
                }
                catch (RemoteException missingMethods) {
                    // empty catch block
                }
                return true;
            }
            case 3010: {
                SomeArgs args = (SomeArgs)msg.obj;
                IInputMethodClient client = (IInputMethodClient)args.arg1;
                InputBindResult res = (InputBindResult)args.arg2;
                try {
                    client.onBindMethod(res);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Client died receiving input method " + args.arg2);
                }
                finally {
                    if (res.channel != null && Binder.isProxy(client)) {
                        res.channel.dispose();
                    }
                }
                args.recycle();
                return true;
            }
            case 3020: {
                try {
                    ((ClientState)msg.obj).client.setActive(msg.arg1 != 0);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Got RemoteException sending setActive(false) notification to pid " + ((ClientState)msg.obj).pid + " uid " + ((ClientState)msg.obj).uid);
                }
                return true;
            }
            case 3030: {
                this.handleSetInteractive(msg.arg1 != 0);
                return true;
            }
            case 3050: {
                this.handleSwitchInputMethod(msg.arg1 != 0);
                return true;
            }
            case 3040: {
                int sequenceNumber = msg.arg1;
                ClientState clientState = (ClientState)msg.obj;
                try {
                    clientState.client.setUserActionNotificationSequenceNumber(sequenceNumber);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Got RemoteException sending setUserActionNotificationSequenceNumber(" + sequenceNumber + ") notification to pid " + clientState.pid + " uid " + clientState.uid);
                }
                return true;
            }
            case 4000: {
                this.mHardKeyboardListener.handleHardKeyboardStatusChange(msg.arg1 == 1);
                return true;
            }
            case 5000: {
                int userId = msg.arg1;
                this.onUnlockUser(userId);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSetInteractive(boolean interactive) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            this.mIsInteractive = interactive;
            this.updateSystemUiLocked(this.mCurToken, interactive ? this.mImeWindowVis : 0, this.mBackDisposition);
            if (this.mCurClient != null && this.mCurClient.client != null) {
                this.executeOrSendMessage(this.mCurClient.client, this.mCaller.obtainMessageIO(3020, this.mIsInteractive ? 1 : 0, this.mCurClient));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSwitchInputMethod(boolean forwardDirection) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            InputMethodSubtypeSwitchingController.ImeSubtypeListItem nextSubtype = this.mSwitchingController.getNextInputMethodLocked(false, this.mMethodMap.get(this.mCurMethodId), this.mCurrentSubtype, forwardDirection);
            if (nextSubtype == null) {
                return;
            }
            this.setInputMethodLocked(nextSubtype.mImi.getId(), nextSubtype.mSubtypeId);
            InputMethodInfo newInputMethodInfo = this.mMethodMap.get(this.mCurMethodId);
            if (newInputMethodInfo == null) {
                return;
            }
            CharSequence toastText = InputMethodUtils.getImeAndSubtypeDisplayName(this.mContext, newInputMethodInfo, this.mCurrentSubtype);
            if (!TextUtils.isEmpty(toastText)) {
                if (this.mSubtypeSwitchedByShortCutToast == null) {
                    this.mSubtypeSwitchedByShortCutToast = Toast.makeText(this.mContext, toastText, 0);
                } else {
                    this.mSubtypeSwitchedByShortCutToast.setText(toastText);
                }
                this.mSubtypeSwitchedByShortCutToast.show();
            }
        }
    }

    private boolean chooseNewDefaultIMELocked() {
        InputMethodInfo imi = InputMethodUtils.getMostApplicableDefaultIME(this.mSettings.getEnabledInputMethodListLocked());
        if (imi != null) {
            this.resetSelectedInputMethodAndSubtypeLocked(imi.getId());
            return true;
        }
        return false;
    }

    void buildInputMethodListLocked(boolean resetDefaultEnabledIme) {
        String defaultImiId;
        this.mMethodList.clear();
        this.mMethodMap.clear();
        PackageManager pm = this.mContext.getPackageManager();
        List<ResolveInfo> services = pm.queryIntentServicesAsUser(new Intent("android.view.InputMethod"), 32896, this.mSettings.getCurrentUserId());
        HashMap<String, List<InputMethodSubtype>> additionalSubtypes = this.mFileManager.getAllAdditionalInputMethodSubtypes();
        for (int i = 0; i < services.size(); ++i) {
            ResolveInfo ri = services.get(i);
            ServiceInfo si = ri.serviceInfo;
            ComponentName compName = new ComponentName(si.packageName, si.name);
            if (!"android.permission.BIND_INPUT_METHOD".equals(si.permission)) {
                Slog.w(TAG, "Skipping input method " + compName + ": it does not require the permission " + "android.permission.BIND_INPUT_METHOD");
                continue;
            }
            try {
                InputMethodInfo p = new InputMethodInfo(this.mContext, ri, additionalSubtypes);
                this.mMethodList.add(p);
                String id2 = p.getId();
                this.mMethodMap.put(id2, p);
                continue;
            }
            catch (Exception e) {
                Slog.wtf(TAG, "Unable to load input method " + compName, e);
            }
        }
        if (!resetDefaultEnabledIme) {
            boolean enabledImeFound = false;
            ArrayList<InputMethodInfo> enabledImes = this.mSettings.getEnabledInputMethodListLocked();
            int N = enabledImes.size();
            for (int i = 0; i < N; ++i) {
                InputMethodInfo imi = (InputMethodInfo)enabledImes.get(i);
                if (!this.mMethodList.contains(imi)) continue;
                enabledImeFound = true;
                break;
            }
            if (!enabledImeFound) {
                Slog.i(TAG, "All the enabled IMEs are gone. Reset default enabled IMEs.");
                resetDefaultEnabledIme = true;
                this.resetSelectedInputMethodAndSubtypeLocked("");
            }
        }
        if (resetDefaultEnabledIme) {
            ArrayList<InputMethodInfo> defaultEnabledIme = InputMethodUtils.getDefaultEnabledImes(this.mContext, this.mSystemReady, this.mMethodList);
            int N = defaultEnabledIme.size();
            for (int i = 0; i < N; ++i) {
                InputMethodInfo imi = defaultEnabledIme.get(i);
                this.setInputMethodEnabledLocked(imi.getId(), true);
            }
        }
        if (!TextUtils.isEmpty(defaultImiId = this.mSettings.getSelectedInputMethod())) {
            if (!this.mMethodMap.containsKey(defaultImiId)) {
                Slog.w(TAG, "Default IME is uninstalled. Choose new default IME.");
                if (this.chooseNewDefaultIMELocked()) {
                    this.updateInputMethodsFromSettingsLocked(true);
                }
            } else {
                this.setInputMethodEnabledLocked(defaultImiId, true);
            }
        }
        this.mSwitchingController.resetCircularListLocked(this.mContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showInputMethodAndSubtypeEnabler(String inputMethodId) {
        int userId;
        Intent intent = new Intent("android.settings.INPUT_METHOD_SUBTYPE_SETTINGS");
        intent.setFlags(337641472);
        if (!TextUtils.isEmpty(inputMethodId)) {
            intent.putExtra("input_method_id", inputMethodId);
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            userId = this.mSettings.getCurrentUserId();
        }
        this.mContext.startActivityAsUser(intent, null, UserHandle.of(userId));
    }

    private void showConfigureInputMethods() {
        Intent intent = new Intent("android.settings.INPUT_METHOD_SETTINGS");
        intent.setFlags(337641472);
        this.mContext.startActivityAsUser(intent, null, UserHandle.CURRENT);
    }

    private boolean isScreenLocked() {
        return this.mKeyguardManager != null && this.mKeyguardManager.isKeyguardLocked() && this.mKeyguardManager.isKeyguardSecure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showInputMethodMenu(boolean showAuxSubtypes) {
        Context context = this.mContext;
        boolean isScreenLocked = this.isScreenLocked();
        String lastInputMethodId = this.mSettings.getSelectedInputMethod();
        int lastInputMethodSubtypeId = this.mSettings.getSelectedInputMethodSubtypeId(lastInputMethodId);
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            InputMethodSubtype currentSubtype;
            HashMap<InputMethodInfo, List<InputMethodSubtype>> immis = this.mSettings.getExplicitlyOrImplicitlyEnabledInputMethodsAndSubtypeListLocked(this.mContext);
            if (immis == null || immis.size() == 0) {
                return;
            }
            this.hideInputMethodMenuLocked();
            List<InputMethodSubtypeSwitchingController.ImeSubtypeListItem> imList = this.mSwitchingController.getSortedInputMethodAndSubtypeListLocked(showAuxSubtypes, isScreenLocked);
            if (lastInputMethodSubtypeId == -1 && (currentSubtype = this.getCurrentInputMethodSubtypeLocked()) != null) {
                InputMethodInfo currentImi = this.mMethodMap.get(this.mCurMethodId);
                lastInputMethodSubtypeId = InputMethodUtils.getSubtypeIdFromHashCode(currentImi, currentSubtype.hashCode());
            }
            int N = imList.size();
            this.mIms = new InputMethodInfo[N];
            this.mSubtypeIds = new int[N];
            int checkedItem = 0;
            for (int i = 0; i < N; ++i) {
                int subtypeId;
                InputMethodSubtypeSwitchingController.ImeSubtypeListItem item = imList.get(i);
                this.mIms[i] = item.mImi;
                this.mSubtypeIds[i] = item.mSubtypeId;
                if (!this.mIms[i].getId().equals(lastInputMethodId) || (subtypeId = this.mSubtypeIds[i]) != -1 && (lastInputMethodSubtypeId != -1 || subtypeId != 0) && subtypeId != lastInputMethodSubtypeId) continue;
                checkedItem = i;
            }
            ContextThemeWrapper settingsContext = new ContextThemeWrapper(context, 16974371);
            this.mDialogBuilder = new AlertDialog.Builder(settingsContext);
            this.mDialogBuilder.setOnCancelListener(new DialogInterface.OnCancelListener(){

                @Override
                public void onCancel(DialogInterface dialog) {
                    InputMethodManagerService.this.hideInputMethodMenu();
                }
            });
            Context dialogContext = this.mDialogBuilder.getContext();
            TypedArray a = dialogContext.obtainStyledAttributes(null, R.styleable.DialogPreference, 16842845, 0);
            Drawable dialogIcon = a.getDrawable(2);
            a.recycle();
            this.mDialogBuilder.setIcon(dialogIcon);
            LayoutInflater inflater = dialogContext.getSystemService(LayoutInflater.class);
            View tv = inflater.inflate(17367151, null);
            this.mDialogBuilder.setCustomTitle(tv);
            this.mSwitchingDialogTitleView = tv;
            this.mSwitchingDialogTitleView.findViewById(16909194).setVisibility(this.mWindowManagerInternal.isHardKeyboardAvailable() ? 0 : 8);
            Switch hardKeySwitch = (Switch)this.mSwitchingDialogTitleView.findViewById(16909195);
            hardKeySwitch.setChecked(this.mShowImeWithHardKeyboard);
            hardKeySwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                @Override
                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    InputMethodManagerService.this.mSettings.setShowImeWithHardKeyboard(isChecked);
                    InputMethodManagerService.this.hideInputMethodMenu();
                }
            });
            final ImeSubtypeListAdapter adapter = new ImeSubtypeListAdapter(dialogContext, 17367152, imList, checkedItem);
            DialogInterface.OnClickListener choiceListener = new DialogInterface.OnClickListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    HashMap<String, InputMethodInfo> hashMap = InputMethodManagerService.this.mMethodMap;
                    synchronized (hashMap) {
                        if (InputMethodManagerService.this.mIms == null || InputMethodManagerService.this.mIms.length <= which || InputMethodManagerService.this.mSubtypeIds == null || InputMethodManagerService.this.mSubtypeIds.length <= which) {
                            return;
                        }
                        InputMethodInfo im = InputMethodManagerService.this.mIms[which];
                        int subtypeId = InputMethodManagerService.this.mSubtypeIds[which];
                        adapter.mCheckedItem = which;
                        adapter.notifyDataSetChanged();
                        InputMethodManagerService.this.hideInputMethodMenu();
                        if (im != null) {
                            if (subtypeId < 0 || subtypeId >= im.getSubtypeCount()) {
                                subtypeId = -1;
                            }
                            InputMethodManagerService.this.setInputMethodLocked(im.getId(), subtypeId);
                        }
                    }
                }
            };
            this.mDialogBuilder.setSingleChoiceItems(adapter, checkedItem, choiceListener);
            this.mSwitchingDialog = this.mDialogBuilder.create();
            this.mSwitchingDialog.setCanceledOnTouchOutside(true);
            this.mSwitchingDialog.getWindow().setType(2012);
            this.mSwitchingDialog.getWindow().getAttributes().privateFlags |= 0x10;
            this.mSwitchingDialog.getWindow().getAttributes().setTitle("Select input method");
            this.updateSystemUi(this.mCurToken, this.mImeWindowVis, this.mBackDisposition);
            this.mSwitchingDialog.show();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void hideInputMethodMenu() {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            this.hideInputMethodMenuLocked();
        }
    }

    void hideInputMethodMenuLocked() {
        if (this.mSwitchingDialog != null) {
            this.mSwitchingDialog.dismiss();
            this.mSwitchingDialog = null;
        }
        this.updateSystemUiLocked(this.mCurToken, this.mImeWindowVis, this.mBackDisposition);
        this.mDialogBuilder = null;
        this.mIms = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setInputMethodEnabled(String id2, boolean enabled) {
        if (!this.calledFromValidUser()) {
            return false;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            boolean bl;
            if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
                throw new SecurityException("Requires permission android.permission.WRITE_SECURE_SETTINGS");
            }
            long ident = Binder.clearCallingIdentity();
            try {
                bl = this.setInputMethodEnabledLocked(id2, enabled);
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
            return bl;
        }
    }

    boolean setInputMethodEnabledLocked(String id2, boolean enabled) {
        InputMethodInfo imm = this.mMethodMap.get(id2);
        if (imm == null) {
            throw new IllegalArgumentException("Unknown id: " + this.mCurMethodId);
        }
        List<Pair<String, ArrayList<String>>> enabledInputMethodsList = this.mSettings.getEnabledInputMethodsAndSubtypeListLocked();
        if (enabled) {
            for (Pair<String, ArrayList<String>> pair : enabledInputMethodsList) {
                if (!((String)pair.first).equals(id2)) continue;
                return true;
            }
            this.mSettings.appendAndPutEnabledInputMethodLocked(id2, false);
            return false;
        }
        StringBuilder builder = new StringBuilder();
        if (this.mSettings.buildAndPutEnabledInputMethodsStrRemovingIdLocked(builder, enabledInputMethodsList, id2)) {
            String selId = this.mSettings.getSelectedInputMethod();
            if (id2.equals(selId) && !this.chooseNewDefaultIMELocked()) {
                Slog.i(TAG, "Can't find new IME, unsetting the current input method.");
                this.resetSelectedInputMethodAndSubtypeLocked("");
            }
            return true;
        }
        return false;
    }

    private void setSelectedInputMethodAndSubtypeLocked(InputMethodInfo imi, int subtypeId, boolean setSubtypeOnly) {
        this.mSettings.saveCurrentInputMethodAndSubtypeToHistory(this.mCurMethodId, this.mCurrentSubtype);
        this.mCurUserActionNotificationSequenceNumber = Math.max(this.mCurUserActionNotificationSequenceNumber + 1, 1);
        if (this.mCurClient != null && this.mCurClient.client != null) {
            this.executeOrSendMessage(this.mCurClient.client, this.mCaller.obtainMessageIO(3040, this.mCurUserActionNotificationSequenceNumber, this.mCurClient));
        }
        if (imi == null || subtypeId < 0) {
            this.mSettings.putSelectedSubtype(-1);
            this.mCurrentSubtype = null;
        } else if (subtypeId < imi.getSubtypeCount()) {
            InputMethodSubtype subtype = imi.getSubtypeAt(subtypeId);
            this.mSettings.putSelectedSubtype(subtype.hashCode());
            this.mCurrentSubtype = subtype;
        } else {
            this.mSettings.putSelectedSubtype(-1);
            this.mCurrentSubtype = this.getCurrentInputMethodSubtypeLocked();
        }
        if (!setSubtypeOnly) {
            this.mSettings.putSelectedInputMethod(imi != null ? imi.getId() : "");
        }
    }

    private void resetSelectedInputMethodAndSubtypeLocked(String newDefaultIme) {
        String subtypeHashCode;
        InputMethodInfo imi = this.mMethodMap.get(newDefaultIme);
        int lastSubtypeId = -1;
        if (imi != null && !TextUtils.isEmpty(newDefaultIme) && (subtypeHashCode = this.mSettings.getLastSubtypeForInputMethodLocked(newDefaultIme)) != null) {
            try {
                lastSubtypeId = InputMethodUtils.getSubtypeIdFromHashCode(imi, Integer.parseInt(subtypeHashCode));
            }
            catch (NumberFormatException e) {
                Slog.w(TAG, "HashCode for subtype looks broken: " + subtypeHashCode, e);
            }
        }
        this.setSelectedInputMethodAndSubtypeLocked(imi, lastSubtypeId, false);
    }

    private Pair<InputMethodInfo, InputMethodSubtype> findLastResortApplicableShortcutInputMethodAndSubtypeLocked(String mode) {
        ArrayList<InputMethodInfo> imis = this.mSettings.getEnabledInputMethodListLocked();
        InputMethodInfo mostApplicableIMI = null;
        InputMethodSubtype mostApplicableSubtype = null;
        boolean foundInSystemIME = false;
        for (InputMethodInfo imi : imis) {
            ArrayList<InputMethodSubtype> overridingImplicitlyEnabledSubtypes;
            ArrayList<InputMethodSubtype> subtypesForSearch;
            String imiId = imi.getId();
            if (foundInSystemIME && !imiId.equals(this.mCurMethodId)) continue;
            InputMethodSubtype subtype = null;
            List<InputMethodSubtype> enabledSubtypes = this.mSettings.getEnabledInputMethodSubtypeListLocked(this.mContext, imi, true);
            if (this.mCurrentSubtype != null) {
                subtype = InputMethodUtils.findLastResortApplicableSubtypeLocked(this.mRes, enabledSubtypes, mode, this.mCurrentSubtype.getLocale(), false);
            }
            if (subtype == null) {
                subtype = InputMethodUtils.findLastResortApplicableSubtypeLocked(this.mRes, enabledSubtypes, mode, null, true);
            }
            ArrayList<InputMethodSubtype> arrayList = subtypesForSearch = (overridingImplicitlyEnabledSubtypes = InputMethodUtils.getOverridingImplicitlyEnabledSubtypes(imi, mode)).isEmpty() ? InputMethodUtils.getSubtypes(imi) : overridingImplicitlyEnabledSubtypes;
            if (subtype == null && this.mCurrentSubtype != null) {
                subtype = InputMethodUtils.findLastResortApplicableSubtypeLocked(this.mRes, subtypesForSearch, mode, this.mCurrentSubtype.getLocale(), false);
            }
            if (subtype == null) {
                subtype = InputMethodUtils.findLastResortApplicableSubtypeLocked(this.mRes, subtypesForSearch, mode, null, true);
            }
            if (subtype == null) continue;
            if (imiId.equals(this.mCurMethodId)) {
                mostApplicableIMI = imi;
                mostApplicableSubtype = subtype;
                break;
            }
            if (foundInSystemIME) continue;
            mostApplicableIMI = imi;
            mostApplicableSubtype = subtype;
            if ((imi.getServiceInfo().applicationInfo.flags & 1) == 0) continue;
            foundInSystemIME = true;
        }
        if (mostApplicableIMI != null) {
            return new Pair<Object, Object>(mostApplicableIMI, mostApplicableSubtype);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputMethodSubtype getCurrentInputMethodSubtype() {
        if (!this.calledFromValidUser()) {
            return null;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            return this.getCurrentInputMethodSubtypeLocked();
        }
    }

    private InputMethodSubtype getCurrentInputMethodSubtypeLocked() {
        if (this.mCurMethodId == null) {
            return null;
        }
        boolean subtypeIsSelected = this.mSettings.isSubtypeSelected();
        InputMethodInfo imi = this.mMethodMap.get(this.mCurMethodId);
        if (imi == null || imi.getSubtypeCount() == 0) {
            return null;
        }
        if (!subtypeIsSelected || this.mCurrentSubtype == null || !InputMethodUtils.isValidSubtypeId(imi, this.mCurrentSubtype.hashCode())) {
            int subtypeId = this.mSettings.getSelectedInputMethodSubtypeId(this.mCurMethodId);
            if (subtypeId == -1) {
                List<InputMethodSubtype> explicitlyOrImplicitlyEnabledSubtypes = this.mSettings.getEnabledInputMethodSubtypeListLocked(this.mContext, imi, true);
                if (explicitlyOrImplicitlyEnabledSubtypes.size() == 1) {
                    this.mCurrentSubtype = explicitlyOrImplicitlyEnabledSubtypes.get(0);
                } else if (explicitlyOrImplicitlyEnabledSubtypes.size() > 1) {
                    this.mCurrentSubtype = InputMethodUtils.findLastResortApplicableSubtypeLocked(this.mRes, explicitlyOrImplicitlyEnabledSubtypes, "keyboard", null, true);
                    if (this.mCurrentSubtype == null) {
                        this.mCurrentSubtype = InputMethodUtils.findLastResortApplicableSubtypeLocked(this.mRes, explicitlyOrImplicitlyEnabledSubtypes, null, null, true);
                    }
                }
            } else {
                this.mCurrentSubtype = InputMethodUtils.getSubtypes(imi).get(subtypeId);
            }
        }
        return this.mCurrentSubtype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getShortcutInputMethodsAndSubtypes() {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            ArrayList<Object> ret = new ArrayList<Object>();
            if (this.mShortcutInputMethodsAndSubtypes.size() == 0) {
                Pair<InputMethodInfo, InputMethodSubtype> info = this.findLastResortApplicableShortcutInputMethodAndSubtypeLocked("voice");
                if (info != null) {
                    ret.add(info.first);
                    ret.add(info.second);
                }
                return ret;
            }
            for (InputMethodInfo imi : this.mShortcutInputMethodsAndSubtypes.keySet()) {
                ret.add(imi);
                for (InputMethodSubtype subtype : this.mShortcutInputMethodsAndSubtypes.get(imi)) {
                    ret.add(subtype);
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setCurrentInputMethodSubtype(InputMethodSubtype subtype) {
        if (!this.calledFromValidUser()) {
            return false;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            InputMethodInfo imi;
            int subtypeId;
            if (subtype != null && this.mCurMethodId != null && (subtypeId = InputMethodUtils.getSubtypeIdFromHashCode(imi = this.mMethodMap.get(this.mCurMethodId), subtype.hashCode())) != -1) {
                this.setInputMethodLocked(this.mCurMethodId, subtypeId);
                return true;
            }
            return false;
        }
    }

    private static String imeWindowStatusToString(int imeWindowVis) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if ((imeWindowVis & 1) != 0) {
            sb.append("Active");
            first = false;
        }
        if ((imeWindowVis & 2) != 0) {
            if (!first) {
                sb.append("|");
            }
            sb.append("Visible");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IInputContentUriToken createInputContentUriToken(IBinder token, Uri contentUri, String packageName) {
        if (!this.calledFromValidUser()) {
            return null;
        }
        if (token == null) {
            throw new NullPointerException("token");
        }
        if (packageName == null) {
            throw new NullPointerException("packageName");
        }
        if (contentUri == null) {
            throw new NullPointerException("contentUri");
        }
        String contentUriScheme = contentUri.getScheme();
        if (!"content".equals(contentUriScheme)) {
            throw new InvalidParameterException("contentUri must have content scheme");
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            int uid = Binder.getCallingUid();
            if (this.mCurMethodId == null) {
                return null;
            }
            if (this.mCurToken != token) {
                Slog.e(TAG, "Ignoring createInputContentUriToken mCurToken=" + this.mCurToken + " token=" + token);
                return null;
            }
            if (!TextUtils.equals(this.mCurAttribute.packageName, packageName)) {
                Slog.e(TAG, "Ignoring createInputContentUriToken mCurAttribute.packageName=" + this.mCurAttribute.packageName + " packageName=" + packageName);
                return null;
            }
            int imeUserId = UserHandle.getUserId(uid);
            int appUserId = UserHandle.getUserId(this.mCurClient.uid);
            return new InputContentUriTokenHandler(contentUri, uid, packageName, imeUserId, appUserId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        IInputMethod method;
        ClientState focusedWindowClient;
        ClientState client;
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump InputMethodManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        PrintWriterPrinter p = new PrintWriterPrinter(pw);
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            p.println("Current Input Method Manager state:");
            int N = this.mMethodList.size();
            p.println("  Input Methods:");
            for (int i = 0; i < N; ++i) {
                InputMethodInfo info = this.mMethodList.get(i);
                p.println("  InputMethod #" + i + ":");
                info.dump(p, "    ");
            }
            p.println("  Clients:");
            for (ClientState ci : this.mClients.values()) {
                p.println("  Client " + ci + ":");
                p.println("    client=" + ci.client);
                p.println("    inputContext=" + ci.inputContext);
                p.println("    sessionRequested=" + ci.sessionRequested);
                p.println("    curSession=" + ci.curSession);
            }
            p.println("  mCurMethodId=" + this.mCurMethodId);
            client = this.mCurClient;
            p.println("  mCurClient=" + client + " mCurSeq=" + this.mCurSeq);
            p.println("  mCurFocusedWindow=" + this.mCurFocusedWindow);
            focusedWindowClient = this.mCurFocusedWindowClient;
            p.println("  mCurFocusedWindowClient=" + focusedWindowClient);
            p.println("  mCurId=" + this.mCurId + " mHaveConnect=" + this.mHaveConnection + " mBoundToMethod=" + this.mBoundToMethod);
            p.println("  mCurToken=" + this.mCurToken);
            p.println("  mCurIntent=" + this.mCurIntent);
            method = this.mCurMethod;
            p.println("  mCurMethod=" + this.mCurMethod);
            p.println("  mEnabledSession=" + this.mEnabledSession);
            p.println("  mImeWindowVis=" + InputMethodManagerService.imeWindowStatusToString(this.mImeWindowVis));
            p.println("  mShowRequested=" + this.mShowRequested + " mShowExplicitlyRequested=" + this.mShowExplicitlyRequested + " mShowForced=" + this.mShowForced + " mInputShown=" + this.mInputShown);
            p.println("  mCurUserActionNotificationSequenceNumber=" + this.mCurUserActionNotificationSequenceNumber);
            p.println("  mSystemReady=" + this.mSystemReady + " mInteractive=" + this.mIsInteractive);
            p.println("  mSettingsObserver=" + this.mSettingsObserver);
            p.println("  mSwitchingController:");
            this.mSwitchingController.dump(p);
            p.println("  mSettings:");
            this.mSettings.dumpLocked(p, "    ");
        }
        p.println(" ");
        if (client != null) {
            pw.flush();
            try {
                client.client.asBinder().dump(fd, args);
            }
            catch (RemoteException e) {
                p.println("Input method client dead: " + e);
            }
        } else {
            p.println("No input method client.");
        }
        if (focusedWindowClient != null && client != focusedWindowClient) {
            p.println(" ");
            p.println("Warning: Current input method client doesn't match the last focused. window.");
            p.println("Dumping input method client in the last focused window just in case.");
            p.println(" ");
            pw.flush();
            try {
                focusedWindowClient.client.asBinder().dump(fd, args);
            }
            catch (RemoteException e) {
                p.println("Input method client in focused window dead: " + e);
            }
        }
        p.println(" ");
        if (method != null) {
            pw.flush();
            try {
                method.asBinder().dump(fd, args);
            }
            catch (RemoteException e) {
                p.println("Input method service dead: " + e);
            }
        } else {
            p.println("No input method service.");
        }
    }

    private static final class LocalServiceImpl
    implements InputMethodManagerInternal {
        private final Handler mHandler;

        LocalServiceImpl(Handler handler) {
            this.mHandler = handler;
        }

        @Override
        public void setInteractive(boolean interactive) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3030, interactive ? 1 : 0, 0));
        }

        @Override
        public void switchInputMethod(boolean forwardDirection) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3050, forwardDirection ? 1 : 0, 0));
        }

        @Override
        public void hideCurrentInputMethod() {
            this.mHandler.removeMessages(1035);
            this.mHandler.sendEmptyMessage(1035);
        }
    }

    private static class InputMethodFileManager {
        private static final String SYSTEM_PATH = "system";
        private static final String INPUT_METHOD_PATH = "inputmethod";
        private static final String ADDITIONAL_SUBTYPES_FILE_NAME = "subtypes.xml";
        private static final String NODE_SUBTYPES = "subtypes";
        private static final String NODE_SUBTYPE = "subtype";
        private static final String NODE_IMI = "imi";
        private static final String ATTR_ID = "id";
        private static final String ATTR_LABEL = "label";
        private static final String ATTR_ICON = "icon";
        private static final String ATTR_IME_SUBTYPE_ID = "subtypeId";
        private static final String ATTR_IME_SUBTYPE_LOCALE = "imeSubtypeLocale";
        private static final String ATTR_IME_SUBTYPE_LANGUAGE_TAG = "languageTag";
        private static final String ATTR_IME_SUBTYPE_MODE = "imeSubtypeMode";
        private static final String ATTR_IME_SUBTYPE_EXTRA_VALUE = "imeSubtypeExtraValue";
        private static final String ATTR_IS_AUXILIARY = "isAuxiliary";
        private static final String ATTR_IS_ASCII_CAPABLE = "isAsciiCapable";
        private final AtomicFile mAdditionalInputMethodSubtypeFile;
        private final HashMap<String, InputMethodInfo> mMethodMap;
        private final HashMap<String, List<InputMethodSubtype>> mAdditionalSubtypesMap = new HashMap();

        public InputMethodFileManager(HashMap<String, InputMethodInfo> methodMap, int userId) {
            if (methodMap == null) {
                throw new NullPointerException("methodMap is null");
            }
            this.mMethodMap = methodMap;
            File systemDir = userId == 0 ? new File(Environment.getDataDirectory(), SYSTEM_PATH) : Environment.getUserSystemDirectory(userId);
            File inputMethodDir = new File(systemDir, INPUT_METHOD_PATH);
            if (!inputMethodDir.exists() && !inputMethodDir.mkdirs()) {
                Slog.w(InputMethodManagerService.TAG, "Couldn't create dir.: " + inputMethodDir.getAbsolutePath());
            }
            File subtypeFile = new File(inputMethodDir, ADDITIONAL_SUBTYPES_FILE_NAME);
            this.mAdditionalInputMethodSubtypeFile = new AtomicFile(subtypeFile);
            if (!subtypeFile.exists()) {
                InputMethodFileManager.writeAdditionalInputMethodSubtypes(this.mAdditionalSubtypesMap, this.mAdditionalInputMethodSubtypeFile, methodMap);
            } else {
                InputMethodFileManager.readAdditionalInputMethodSubtypes(this.mAdditionalSubtypesMap, this.mAdditionalInputMethodSubtypeFile);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deleteAllInputMethodSubtypes(String imiId) {
            HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
            synchronized (hashMap) {
                this.mAdditionalSubtypesMap.remove(imiId);
                InputMethodFileManager.writeAdditionalInputMethodSubtypes(this.mAdditionalSubtypesMap, this.mAdditionalInputMethodSubtypeFile, this.mMethodMap);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addInputMethodSubtypes(InputMethodInfo imi, InputMethodSubtype[] additionalSubtypes) {
            HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
            synchronized (hashMap) {
                ArrayList<InputMethodSubtype> subtypes = new ArrayList<InputMethodSubtype>();
                for (InputMethodSubtype subtype : additionalSubtypes) {
                    if (!subtypes.contains(subtype)) {
                        subtypes.add(subtype);
                        continue;
                    }
                    Slog.w(InputMethodManagerService.TAG, "Duplicated subtype definition found: " + subtype.getLocale() + ", " + subtype.getMode());
                }
                this.mAdditionalSubtypesMap.put(imi.getId(), subtypes);
                InputMethodFileManager.writeAdditionalInputMethodSubtypes(this.mAdditionalSubtypesMap, this.mAdditionalInputMethodSubtypeFile, this.mMethodMap);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HashMap<String, List<InputMethodSubtype>> getAllAdditionalInputMethodSubtypes() {
            HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
            synchronized (hashMap) {
                return this.mAdditionalSubtypesMap;
            }
        }

        private static void writeAdditionalInputMethodSubtypes(HashMap<String, List<InputMethodSubtype>> allSubtypes, AtomicFile subtypesFile, HashMap<String, InputMethodInfo> methodMap) {
            block6: {
                boolean isSetMethodMap = methodMap != null && methodMap.size() > 0;
                FileOutputStream fos = null;
                try {
                    fos = subtypesFile.startWrite();
                    FastXmlSerializer out = new FastXmlSerializer();
                    out.setOutput(fos, StandardCharsets.UTF_8.name());
                    out.startDocument(null, true);
                    out.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
                    out.startTag(null, NODE_SUBTYPES);
                    for (String imiId : allSubtypes.keySet()) {
                        if (isSetMethodMap && !methodMap.containsKey(imiId)) {
                            Slog.w(InputMethodManagerService.TAG, "IME uninstalled or not valid.: " + imiId);
                            continue;
                        }
                        out.startTag(null, NODE_IMI);
                        out.attribute(null, ATTR_ID, imiId);
                        List<InputMethodSubtype> subtypesList = allSubtypes.get(imiId);
                        int N = subtypesList.size();
                        for (int i = 0; i < N; ++i) {
                            InputMethodSubtype subtype = subtypesList.get(i);
                            out.startTag(null, NODE_SUBTYPE);
                            if (subtype.hasSubtypeId()) {
                                out.attribute(null, ATTR_IME_SUBTYPE_ID, String.valueOf(subtype.getSubtypeId()));
                            }
                            out.attribute(null, ATTR_ICON, String.valueOf(subtype.getIconResId()));
                            out.attribute(null, ATTR_LABEL, String.valueOf(subtype.getNameResId()));
                            out.attribute(null, ATTR_IME_SUBTYPE_LOCALE, subtype.getLocale());
                            out.attribute(null, ATTR_IME_SUBTYPE_LANGUAGE_TAG, subtype.getLanguageTag());
                            out.attribute(null, ATTR_IME_SUBTYPE_MODE, subtype.getMode());
                            out.attribute(null, ATTR_IME_SUBTYPE_EXTRA_VALUE, subtype.getExtraValue());
                            out.attribute(null, ATTR_IS_AUXILIARY, String.valueOf(subtype.isAuxiliary() ? 1 : 0));
                            out.attribute(null, ATTR_IS_ASCII_CAPABLE, String.valueOf(subtype.isAsciiCapable() ? 1 : 0));
                            out.endTag(null, NODE_SUBTYPE);
                        }
                        out.endTag(null, NODE_IMI);
                    }
                    out.endTag(null, NODE_SUBTYPES);
                    out.endDocument();
                    subtypesFile.finishWrite(fos);
                }
                catch (IOException e) {
                    Slog.w(InputMethodManagerService.TAG, "Error writing subtypes", e);
                    if (fos == null) break block6;
                    subtypesFile.failWrite(fos);
                }
            }
        }

        private static void readAdditionalInputMethodSubtypes(HashMap<String, List<InputMethodSubtype>> allSubtypes, AtomicFile subtypesFile) {
            if (allSubtypes == null || subtypesFile == null) {
                return;
            }
            allSubtypes.clear();
            try (FileInputStream fis = subtypesFile.openRead();){
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput(fis, StandardCharsets.UTF_8.name());
                int type = parser.getEventType();
                while ((type = parser.next()) != 2 && type != 1) {
                }
                String firstNodeName = parser.getName();
                if (!NODE_SUBTYPES.equals(firstNodeName)) {
                    throw new XmlPullParserException("Xml doesn't start with subtypes");
                }
                int depth = parser.getDepth();
                String currentImiId = null;
                ArrayList<InputMethodSubtype> tempSubtypesArray = null;
                while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
                    if (type != 2) continue;
                    String nodeName = parser.getName();
                    if (NODE_IMI.equals(nodeName)) {
                        currentImiId = parser.getAttributeValue(null, ATTR_ID);
                        if (TextUtils.isEmpty(currentImiId)) {
                            Slog.w(InputMethodManagerService.TAG, "Invalid imi id found in subtypes.xml");
                            continue;
                        }
                        tempSubtypesArray = new ArrayList<InputMethodSubtype>();
                        allSubtypes.put(currentImiId, tempSubtypesArray);
                        continue;
                    }
                    if (!NODE_SUBTYPE.equals(nodeName)) continue;
                    if (TextUtils.isEmpty(currentImiId) || tempSubtypesArray == null) {
                        Slog.w(InputMethodManagerService.TAG, "IME uninstalled or not valid.: " + currentImiId);
                        continue;
                    }
                    int icon = Integer.parseInt(parser.getAttributeValue(null, ATTR_ICON));
                    int label = Integer.parseInt(parser.getAttributeValue(null, ATTR_LABEL));
                    String imeSubtypeLocale = parser.getAttributeValue(null, ATTR_IME_SUBTYPE_LOCALE);
                    String languageTag = parser.getAttributeValue(null, ATTR_IME_SUBTYPE_LANGUAGE_TAG);
                    String imeSubtypeMode = parser.getAttributeValue(null, ATTR_IME_SUBTYPE_MODE);
                    String imeSubtypeExtraValue = parser.getAttributeValue(null, ATTR_IME_SUBTYPE_EXTRA_VALUE);
                    boolean isAuxiliary = "1".equals(String.valueOf(parser.getAttributeValue(null, ATTR_IS_AUXILIARY)));
                    boolean isAsciiCapable = "1".equals(String.valueOf(parser.getAttributeValue(null, ATTR_IS_ASCII_CAPABLE)));
                    InputMethodSubtype.InputMethodSubtypeBuilder builder = new InputMethodSubtype.InputMethodSubtypeBuilder().setSubtypeNameResId(label).setSubtypeIconResId(icon).setSubtypeLocale(imeSubtypeLocale).setLanguageTag(languageTag).setSubtypeMode(imeSubtypeMode).setSubtypeExtraValue(imeSubtypeExtraValue).setIsAuxiliary(isAuxiliary).setIsAsciiCapable(isAsciiCapable);
                    String subtypeIdString = parser.getAttributeValue(null, ATTR_IME_SUBTYPE_ID);
                    if (subtypeIdString != null) {
                        builder.setSubtypeId(Integer.parseInt(subtypeIdString));
                    }
                    tempSubtypesArray.add(builder.build());
                }
            }
            catch (IOException | NumberFormatException | XmlPullParserException e) {
                Slog.w(InputMethodManagerService.TAG, "Error reading subtypes", e);
                return;
            }
        }
    }

    private static class ImeSubtypeListAdapter
    extends ArrayAdapter<InputMethodSubtypeSwitchingController.ImeSubtypeListItem> {
        private final LayoutInflater mInflater;
        private final int mTextViewResourceId;
        private final List<InputMethodSubtypeSwitchingController.ImeSubtypeListItem> mItemsList;
        public int mCheckedItem;

        public ImeSubtypeListAdapter(Context context, int textViewResourceId, List<InputMethodSubtypeSwitchingController.ImeSubtypeListItem> itemsList, int checkedItem) {
            super(context, textViewResourceId, itemsList);
            this.mTextViewResourceId = textViewResourceId;
            this.mItemsList = itemsList;
            this.mCheckedItem = checkedItem;
            this.mInflater = context.getSystemService(LayoutInflater.class);
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            View view;
            View view2 = view = convertView != null ? convertView : this.mInflater.inflate(this.mTextViewResourceId, null);
            if (position < 0 || position >= this.mItemsList.size()) {
                return view;
            }
            InputMethodSubtypeSwitchingController.ImeSubtypeListItem item = this.mItemsList.get(position);
            CharSequence imeName = item.mImeName;
            CharSequence subtypeName = item.mSubtypeName;
            TextView firstTextView = (TextView)view.findViewById(16908308);
            TextView secondTextView = (TextView)view.findViewById(16908309);
            if (TextUtils.isEmpty(subtypeName)) {
                firstTextView.setText(imeName);
                secondTextView.setVisibility(8);
            } else {
                firstTextView.setText(subtypeName);
                secondTextView.setText(imeName);
                secondTextView.setVisibility(0);
            }
            RadioButton radioButton = (RadioButton)view.findViewById(16909196);
            radioButton.setChecked(position == this.mCheckedItem);
            return view;
        }
    }

    public static final class Lifecycle
    extends SystemService {
        private InputMethodManagerService mService;

        public Lifecycle(Context context) {
            super(context);
            this.mService = new InputMethodManagerService(context);
        }

        @Override
        public void onStart() {
            LocalServices.addService(InputMethodManagerInternal.class, new LocalServiceImpl(this.mService.mHandler));
            this.publishBinderService("input_method", this.mService);
        }

        @Override
        public void onSwitchUser(int userHandle) {
            this.mService.onSwitchUser(userHandle);
        }

        @Override
        public void onBootPhase(int phase) {
            if (phase == 550) {
                StatusBarManagerService statusBarService = (StatusBarManagerService)ServiceManager.getService("statusbar");
                this.mService.systemRunning(statusBarService);
            }
        }

        @Override
        public void onUnlockUser(int userHandle) {
            this.mService.mHandler.sendMessage(this.mService.mHandler.obtainMessage(5000, userHandle, 0));
        }
    }

    private class HardKeyboardListener
    implements WindowManagerInternal.OnHardKeyboardStatusChangeListener {
        private HardKeyboardListener() {
        }

        @Override
        public void onHardKeyboardStatusChange(boolean available) {
            InputMethodManagerService.this.mHandler.sendMessage(InputMethodManagerService.this.mHandler.obtainMessage(4000, available ? 1 : 0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleHardKeyboardStatusChange(boolean available) {
            HashMap<String, InputMethodInfo> hashMap = InputMethodManagerService.this.mMethodMap;
            synchronized (hashMap) {
                if (InputMethodManagerService.this.mSwitchingDialog != null && InputMethodManagerService.this.mSwitchingDialogTitleView != null && InputMethodManagerService.this.mSwitchingDialog.isShowing()) {
                    InputMethodManagerService.this.mSwitchingDialogTitleView.findViewById(16909194).setVisibility(available ? 0 : 8);
                }
            }
        }
    }

    private static final class MethodCallback
    extends IInputSessionCallback.Stub {
        private final InputMethodManagerService mParentIMMS;
        private final IInputMethod mMethod;
        private final InputChannel mChannel;

        MethodCallback(InputMethodManagerService imms, IInputMethod method, InputChannel channel) {
            this.mParentIMMS = imms;
            this.mMethod = method;
            this.mChannel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sessionCreated(IInputMethodSession session) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mParentIMMS.onSessionCreated(this.mMethod, session, this.mChannel);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    class MyPackageMonitor
    extends PackageMonitor {
        MyPackageMonitor() {
        }

        private boolean isChangingPackagesOfCurrentUser() {
            int userId = this.getChangingUserId();
            boolean retval = userId == InputMethodManagerService.this.mSettings.getCurrentUserId();
            return retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean onHandleForceStop(Intent intent, String[] packages, int uid, boolean doit) {
            if (!this.isChangingPackagesOfCurrentUser()) {
                return false;
            }
            HashMap<String, InputMethodInfo> hashMap = InputMethodManagerService.this.mMethodMap;
            synchronized (hashMap) {
                String curInputMethodId = InputMethodManagerService.this.mSettings.getSelectedInputMethod();
                int N = InputMethodManagerService.this.mMethodList.size();
                if (curInputMethodId != null) {
                    for (int i = 0; i < N; ++i) {
                        InputMethodInfo imi = InputMethodManagerService.this.mMethodList.get(i);
                        if (!imi.getId().equals(curInputMethodId)) continue;
                        for (String pkg : packages) {
                            if (!imi.getPackageName().equals(pkg)) continue;
                            if (!doit) {
                                return true;
                            }
                            InputMethodManagerService.this.resetSelectedInputMethodAndSubtypeLocked("");
                            InputMethodManagerService.this.chooseNewDefaultIMELocked();
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSomePackagesChanged() {
            if (!this.isChangingPackagesOfCurrentUser()) {
                return;
            }
            HashMap<String, InputMethodInfo> hashMap = InputMethodManagerService.this.mMethodMap;
            synchronized (hashMap) {
                int change;
                InputMethodInfo curIm = null;
                String curInputMethodId = InputMethodManagerService.this.mSettings.getSelectedInputMethod();
                int N = InputMethodManagerService.this.mMethodList.size();
                if (curInputMethodId != null) {
                    for (int i = 0; i < N; ++i) {
                        InputMethodInfo imi = InputMethodManagerService.this.mMethodList.get(i);
                        String imiId = imi.getId();
                        if (imiId.equals(curInputMethodId)) {
                            curIm = imi;
                        }
                        int change2 = this.isPackageDisappearing(imi.getPackageName());
                        if (this.isPackageModified(imi.getPackageName())) {
                            InputMethodManagerService.this.mFileManager.deleteAllInputMethodSubtypes(imiId);
                        }
                        if (change2 != 2 && change2 != 3) continue;
                        Slog.i(InputMethodManagerService.TAG, "Input method uninstalled, disabling: " + imi.getComponent());
                        InputMethodManagerService.this.setInputMethodEnabledLocked(imi.getId(), false);
                    }
                }
                InputMethodManagerService.this.buildInputMethodListLocked(false);
                boolean changed = false;
                if (curIm != null && ((change = this.isPackageDisappearing(curIm.getPackageName())) == 2 || change == 3)) {
                    ServiceInfo si = null;
                    try {
                        si = InputMethodManagerService.this.mIPackageManager.getServiceInfo(curIm.getComponent(), 0, InputMethodManagerService.this.mSettings.getCurrentUserId());
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    if (si == null) {
                        Slog.i(InputMethodManagerService.TAG, "Current input method removed: " + curInputMethodId);
                        InputMethodManagerService.this.updateSystemUiLocked(InputMethodManagerService.this.mCurToken, 0, InputMethodManagerService.this.mBackDisposition);
                        if (!InputMethodManagerService.this.chooseNewDefaultIMELocked()) {
                            changed = true;
                            curIm = null;
                            Slog.i(InputMethodManagerService.TAG, "Unsetting current input method");
                            InputMethodManagerService.this.resetSelectedInputMethodAndSubtypeLocked("");
                        }
                    }
                }
                if (curIm == null) {
                    changed = InputMethodManagerService.this.chooseNewDefaultIMELocked();
                } else if (!changed && this.isPackageModified(curIm.getPackageName())) {
                    changed = true;
                }
                if (changed) {
                    InputMethodManagerService.this.updateFromSettingsLocked(false);
                }
            }
        }
    }

    class ImmsBroadcastReceiver
    extends BroadcastReceiver {
        ImmsBroadcastReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.CLOSE_SYSTEM_DIALOGS".equals(action)) {
                InputMethodManagerService.this.hideInputMethodMenu();
                return;
            }
            if ("android.intent.action.USER_ADDED".equals(action) || "android.intent.action.USER_REMOVED".equals(action)) {
                InputMethodManagerService.this.updateCurrentProfileIds();
                return;
            }
            if ("android.os.action.SETTING_RESTORED".equals(action)) {
                String name = intent.getStringExtra("setting_name");
                if ("enabled_input_methods".equals(name)) {
                    String prevValue = intent.getStringExtra("previous_value");
                    String newValue = intent.getStringExtra("new_value");
                    InputMethodManagerService.restoreEnabledInputMethods(InputMethodManagerService.this.mContext, prevValue, newValue);
                }
            } else {
                Slog.w(InputMethodManagerService.TAG, "Unexpected intent " + intent);
            }
        }
    }

    class SettingsObserver
    extends ContentObserver {
        int mUserId;
        boolean mRegistered;
        String mLastEnabled;

        SettingsObserver(Handler handler) {
            super(handler);
            this.mRegistered = false;
            this.mLastEnabled = "";
        }

        public void registerContentObserverLocked(int userId) {
            if (this.mRegistered && this.mUserId == userId) {
                return;
            }
            ContentResolver resolver = InputMethodManagerService.this.mContext.getContentResolver();
            if (this.mRegistered) {
                InputMethodManagerService.this.mContext.getContentResolver().unregisterContentObserver(this);
                this.mRegistered = false;
            }
            if (this.mUserId != userId) {
                this.mLastEnabled = "";
                this.mUserId = userId;
            }
            resolver.registerContentObserver(Settings.Secure.getUriFor("default_input_method"), false, this, userId);
            resolver.registerContentObserver(Settings.Secure.getUriFor("enabled_input_methods"), false, this, userId);
            resolver.registerContentObserver(Settings.Secure.getUriFor("selected_input_method_subtype"), false, this, userId);
            resolver.registerContentObserver(Settings.Secure.getUriFor("show_ime_with_hard_keyboard"), false, this, userId);
            resolver.registerContentObserver(Settings.Secure.getUriFor("accessibility_soft_keyboard_mode"), false, this, userId);
            this.mRegistered = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChange(boolean selfChange, Uri uri) {
            Uri showImeUri = Settings.Secure.getUriFor("show_ime_with_hard_keyboard");
            Uri accessibilityRequestingNoImeUri = Settings.Secure.getUriFor("accessibility_soft_keyboard_mode");
            HashMap<String, InputMethodInfo> hashMap = InputMethodManagerService.this.mMethodMap;
            synchronized (hashMap) {
                if (showImeUri.equals(uri)) {
                    InputMethodManagerService.this.updateKeyboardFromSettingsLocked();
                } else if (accessibilityRequestingNoImeUri.equals(uri)) {
                    InputMethodManagerService.this.mAccessibilityRequestingNoSoftKeyboard = Settings.Secure.getIntForUser(InputMethodManagerService.this.mContext.getContentResolver(), "accessibility_soft_keyboard_mode", 0, this.mUserId) == 1;
                    if (InputMethodManagerService.this.mAccessibilityRequestingNoSoftKeyboard) {
                        boolean showRequested = InputMethodManagerService.this.mShowRequested;
                        InputMethodManagerService.this.hideCurrentInputLocked(0, null);
                        InputMethodManagerService.this.mShowRequested = showRequested;
                    } else if (InputMethodManagerService.this.mShowRequested) {
                        InputMethodManagerService.this.showCurrentInputLocked(1, null);
                    }
                } else {
                    boolean enabledChanged = false;
                    String newEnabled = InputMethodManagerService.this.mSettings.getEnabledInputMethodsStr();
                    if (!this.mLastEnabled.equals(newEnabled)) {
                        this.mLastEnabled = newEnabled;
                        enabledChanged = true;
                    }
                    InputMethodManagerService.this.updateInputMethodsFromSettingsLocked(enabledChanged);
                }
            }
        }

        public String toString() {
            return "SettingsObserver{mUserId=" + this.mUserId + " mRegistered=" + this.mRegistered + " mLastEnabled=" + this.mLastEnabled + "}";
        }
    }

    static final class ClientState {
        final IInputMethodClient client;
        final IInputContext inputContext;
        final int uid;
        final int pid;
        final InputBinding binding;
        boolean sessionRequested;
        SessionState curSession;

        public String toString() {
            return "ClientState{" + Integer.toHexString(System.identityHashCode(this)) + " uid " + this.uid + " pid " + this.pid + "}";
        }

        ClientState(IInputMethodClient _client, IInputContext _inputContext, int _uid, int _pid) {
            this.client = _client;
            this.inputContext = _inputContext;
            this.uid = _uid;
            this.pid = _pid;
            this.binding = new InputBinding(null, this.inputContext.asBinder(), this.uid, this.pid);
        }
    }

    static class SessionState {
        final ClientState client;
        final IInputMethod method;
        IInputMethodSession session;
        InputChannel channel;

        public String toString() {
            return "SessionState{uid " + this.client.uid + " pid " + this.client.pid + " method " + Integer.toHexString(System.identityHashCode(this.method)) + " session " + Integer.toHexString(System.identityHashCode(this.session)) + " channel " + this.channel + "}";
        }

        SessionState(ClientState _client, IInputMethod _method, IInputMethodSession _session, InputChannel _channel) {
            this.client = _client;
            this.method = _method;
            this.session = _session;
            this.channel = _channel;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L})
    private static @interface HardKeyboardBehavior {
        public static final int WIRELESS_AFFORDANCE = 0;
        public static final int WIRED_AFFORDANCE = 1;
    }
}

