/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.trust.IStrongAuthTracker;
import android.content.Context;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Message;
import android.os.RemoteException;
import android.util.Slog;
import android.util.SparseIntArray;
import com.android.internal.widget.LockPatternUtils;
import java.util.ArrayList;

public class LockSettingsStrongAuth {
    private static final String TAG = "LockSettings";
    private static final int MSG_REQUIRE_STRONG_AUTH = 1;
    private static final int MSG_REGISTER_TRACKER = 2;
    private static final int MSG_UNREGISTER_TRACKER = 3;
    private static final int MSG_REMOVE_USER = 4;
    private final ArrayList<IStrongAuthTracker> mStrongAuthTrackers = new ArrayList();
    private final SparseIntArray mStrongAuthForUser = new SparseIntArray();
    private final int mDefaultStrongAuthFlags;
    private final Handler mHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    LockSettingsStrongAuth.this.handleAddStrongAuthTracker((IStrongAuthTracker)msg.obj);
                    break;
                }
                case 3: {
                    LockSettingsStrongAuth.this.handleRemoveStrongAuthTracker((IStrongAuthTracker)msg.obj);
                    break;
                }
                case 1: {
                    LockSettingsStrongAuth.this.handleRequireStrongAuth(msg.arg1, msg.arg2);
                    break;
                }
                case 4: {
                    LockSettingsStrongAuth.this.handleRemoveUser(msg.arg1);
                }
            }
        }
    };

    public LockSettingsStrongAuth(Context context) {
        this.mDefaultStrongAuthFlags = LockPatternUtils.StrongAuthTracker.getDefaultFlags(context);
    }

    private void handleAddStrongAuthTracker(IStrongAuthTracker tracker) {
        int i;
        for (i = 0; i < this.mStrongAuthTrackers.size(); ++i) {
            if (this.mStrongAuthTrackers.get(i).asBinder() != tracker.asBinder()) continue;
            return;
        }
        this.mStrongAuthTrackers.add(tracker);
        for (i = 0; i < this.mStrongAuthForUser.size(); ++i) {
            int key = this.mStrongAuthForUser.keyAt(i);
            int value = this.mStrongAuthForUser.valueAt(i);
            try {
                tracker.onStrongAuthRequiredChanged(value, key);
                continue;
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Exception while adding StrongAuthTracker.", e);
            }
        }
    }

    private void handleRemoveStrongAuthTracker(IStrongAuthTracker tracker) {
        for (int i = 0; i < this.mStrongAuthTrackers.size(); ++i) {
            if (this.mStrongAuthTrackers.get(i).asBinder() != tracker.asBinder()) continue;
            this.mStrongAuthTrackers.remove(i);
            return;
        }
    }

    private void handleRequireStrongAuth(int strongAuthReason, int userId) {
        if (userId == -1) {
            for (int i = 0; i < this.mStrongAuthForUser.size(); ++i) {
                int key = this.mStrongAuthForUser.keyAt(i);
                this.handleRequireStrongAuthOneUser(strongAuthReason, key);
            }
        } else {
            this.handleRequireStrongAuthOneUser(strongAuthReason, userId);
        }
    }

    private void handleRequireStrongAuthOneUser(int strongAuthReason, int userId) {
        int newValue;
        int oldValue = this.mStrongAuthForUser.get(userId, this.mDefaultStrongAuthFlags);
        int n = newValue = strongAuthReason == 0 ? 0 : oldValue | strongAuthReason;
        if (oldValue != newValue) {
            this.mStrongAuthForUser.put(userId, newValue);
            this.notifyStrongAuthTrackers(newValue, userId);
        }
    }

    private void handleRemoveUser(int userId) {
        int index = this.mStrongAuthForUser.indexOfKey(userId);
        if (index >= 0) {
            this.mStrongAuthForUser.removeAt(index);
            this.notifyStrongAuthTrackers(this.mDefaultStrongAuthFlags, userId);
        }
    }

    private void notifyStrongAuthTrackers(int strongAuthReason, int userId) {
        for (int i = 0; i < this.mStrongAuthTrackers.size(); ++i) {
            try {
                this.mStrongAuthTrackers.get(i).onStrongAuthRequiredChanged(strongAuthReason, userId);
                continue;
            }
            catch (DeadObjectException e) {
                Slog.d(TAG, "Removing dead StrongAuthTracker.");
                this.mStrongAuthTrackers.remove(i);
                --i;
                continue;
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Exception while notifying StrongAuthTracker.", e);
            }
        }
    }

    public void registerStrongAuthTracker(IStrongAuthTracker tracker) {
        this.mHandler.obtainMessage(2, tracker).sendToTarget();
    }

    public void unregisterStrongAuthTracker(IStrongAuthTracker tracker) {
        this.mHandler.obtainMessage(3, tracker).sendToTarget();
    }

    public void removeUser(int userId) {
        this.mHandler.obtainMessage(4, userId, 0).sendToTarget();
    }

    public void requireStrongAuth(int strongAuthReason, int userId) {
        if (userId != -1 && userId < 0) {
            throw new IllegalArgumentException("userId must be an explicit user id or USER_ALL");
        }
        this.mHandler.obtainMessage(1, strongAuthReason, userId).sendToTarget();
    }

    public void reportUnlock(int userId) {
        this.requireStrongAuth(0, userId);
    }
}

