/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.net.INetworkScoreCache;
import android.net.INetworkScoreService;
import android.net.NetworkScorerAppManager;
import android.net.ScoredNetwork;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.content.PackageMonitor;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NetworkScoreService
extends INetworkScoreService.Stub {
    private static final String TAG = "NetworkScoreService";
    private static final boolean DBG = false;
    private final Context mContext;
    private final Map<Integer, INetworkScoreCache> mScoreCaches;
    private final Object mPackageMonitorLock = new Object[0];
    @GuardedBy(value="mPackageMonitorLock")
    private NetworkScorerPackageMonitor mPackageMonitor;
    private ScoringServiceConnection mServiceConnection;
    private BroadcastReceiver mUserIntentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            int userId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
            if (userId == -10000) {
                return;
            }
            if ("android.intent.action.USER_UNLOCKED".equals(action)) {
                NetworkScoreService.this.onUserUnlocked(userId);
            }
        }
    };

    public NetworkScoreService(Context context) {
        this.mContext = context;
        this.mScoreCaches = new HashMap<Integer, INetworkScoreCache>();
        IntentFilter filter = new IntentFilter("android.intent.action.USER_UNLOCKED");
        this.mContext.registerReceiverAsUser(this.mUserIntentReceiver, UserHandle.SYSTEM, filter, null, null);
    }

    void systemReady() {
        ContentResolver cr = this.mContext.getContentResolver();
        if (Settings.Global.getInt(cr, "network_scoring_provisioned", 0) == 0) {
            String defaultPackage = this.mContext.getResources().getString(17039460);
            if (!TextUtils.isEmpty(defaultPackage)) {
                NetworkScorerAppManager.setActiveScorer(this.mContext, defaultPackage);
            }
            Settings.Global.putInt(cr, "network_scoring_provisioned", 1);
        }
        this.registerPackageMonitorIfNeeded();
    }

    void systemRunning() {
        this.bindToScoringServiceIfNeeded();
    }

    private void onUserUnlocked(int userId) {
        this.registerPackageMonitorIfNeeded();
        this.bindToScoringServiceIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerPackageMonitorIfNeeded() {
        NetworkScorerAppManager.NetworkScorerAppData scorer = NetworkScorerAppManager.getActiveScorer(this.mContext);
        Object object = this.mPackageMonitorLock;
        synchronized (object) {
            if (this.mPackageMonitor != null) {
                this.mPackageMonitor.unregister();
                this.mPackageMonitor = null;
            }
            if (scorer != null) {
                this.mPackageMonitor = new NetworkScorerPackageMonitor(scorer.mPackageName);
                this.mPackageMonitor.register(this.mContext, null, UserHandle.SYSTEM, false);
            }
        }
    }

    private void bindToScoringServiceIfNeeded() {
        NetworkScorerAppManager.NetworkScorerAppData scorerData = NetworkScorerAppManager.getActiveScorer(this.mContext);
        this.bindToScoringServiceIfNeeded(scorerData);
    }

    private void bindToScoringServiceIfNeeded(NetworkScorerAppManager.NetworkScorerAppData scorerData) {
        if (scorerData != null && scorerData.mScoringServiceClassName != null) {
            ComponentName componentName = new ComponentName(scorerData.mPackageName, scorerData.mScoringServiceClassName);
            if (this.mServiceConnection != null && !this.mServiceConnection.mComponentName.equals(componentName)) {
                this.unbindFromScoringServiceIfNeeded();
            }
            if (this.mServiceConnection == null) {
                this.mServiceConnection = new ScoringServiceConnection(componentName);
            }
            this.mServiceConnection.connect(this.mContext);
        } else {
            this.unbindFromScoringServiceIfNeeded();
        }
    }

    private void unbindFromScoringServiceIfNeeded() {
        if (this.mServiceConnection != null) {
            this.mServiceConnection.disconnect(this.mContext);
        }
        this.mServiceConnection = null;
    }

    @Override
    public boolean updateScores(ScoredNetwork[] networks) {
        if (!NetworkScorerAppManager.isCallerActiveScorer(this.mContext, NetworkScoreService.getCallingUid())) {
            throw new SecurityException("Caller with UID " + NetworkScoreService.getCallingUid() + " is not the active scorer.");
        }
        HashMap<Integer, ArrayList<ScoredNetwork>> networksByType = new HashMap<Integer, ArrayList<ScoredNetwork>>();
        for (ScoredNetwork network : networks) {
            ArrayList<ScoredNetwork> networkList = (ArrayList<ScoredNetwork>)networksByType.get(network.networkKey.type);
            if (networkList == null) {
                networkList = new ArrayList<ScoredNetwork>();
                networksByType.put(network.networkKey.type, networkList);
            }
            networkList.add(network);
        }
        for (Map.Entry entry : networksByType.entrySet()) {
            INetworkScoreCache scoreCache = this.mScoreCaches.get(entry.getKey());
            if (scoreCache != null) {
                try {
                    scoreCache.updateScores((List)entry.getValue());
                }
                catch (RemoteException e) {
                    if (!Log.isLoggable(TAG, 2)) continue;
                    Log.v(TAG, "Unable to update scores of type " + entry.getKey(), e);
                }
                continue;
            }
            if (!Log.isLoggable(TAG, 2)) continue;
            Log.v(TAG, "No scorer registered for type " + entry.getKey() + ", discarding");
        }
        return true;
    }

    @Override
    public boolean clearScores() {
        if (NetworkScorerAppManager.isCallerActiveScorer(this.mContext, NetworkScoreService.getCallingUid()) || this.mContext.checkCallingOrSelfPermission("android.permission.BROADCAST_NETWORK_PRIVILEGED") == 0) {
            this.clearInternal();
            return true;
        }
        throw new SecurityException("Caller is neither the active scorer nor the scorer manager.");
    }

    @Override
    public boolean setActiveScorer(String packageName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.SCORE_NETWORKS", TAG);
        return this.setScorerInternal(packageName);
    }

    @Override
    public void disableScoring() {
        if (!NetworkScorerAppManager.isCallerActiveScorer(this.mContext, NetworkScoreService.getCallingUid()) && this.mContext.checkCallingOrSelfPermission("android.permission.BROADCAST_NETWORK_PRIVILEGED") != 0) {
            throw new SecurityException("Caller is neither the active scorer nor the scorer manager.");
        }
        this.setScorerInternal(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setScorerInternal(String packageName) {
        long token = Binder.clearCallingIdentity();
        try {
            this.unbindFromScoringServiceIfNeeded();
            this.clearInternal();
            NetworkScorerAppManager.NetworkScorerAppData prevScorer = NetworkScorerAppManager.getActiveScorer(this.mContext);
            boolean result = NetworkScorerAppManager.setActiveScorer(this.mContext, packageName);
            this.bindToScoringServiceIfNeeded();
            if (result) {
                this.registerPackageMonitorIfNeeded();
                Intent intent = new Intent("android.net.scoring.SCORER_CHANGED");
                if (prevScorer != null) {
                    intent.setPackage(prevScorer.mPackageName);
                    this.mContext.sendBroadcastAsUser(intent, UserHandle.SYSTEM);
                }
                if (packageName != null) {
                    intent.putExtra("newScorer", packageName);
                    intent.setPackage(packageName);
                    this.mContext.sendBroadcastAsUser(intent, UserHandle.SYSTEM);
                }
            }
            boolean bl = result;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private void clearInternal() {
        Set<INetworkScoreCache> cachesToClear = this.getScoreCaches();
        for (INetworkScoreCache scoreCache : cachesToClear) {
            try {
                scoreCache.clearScores();
            }
            catch (RemoteException e) {
                if (!Log.isLoggable(TAG, 2)) continue;
                Log.v(TAG, "Unable to clear scores", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerNetworkScoreCache(int networkType, INetworkScoreCache scoreCache) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BROADCAST_NETWORK_PRIVILEGED", TAG);
        Map<Integer, INetworkScoreCache> map = this.mScoreCaches;
        synchronized (map) {
            if (this.mScoreCaches.containsKey(networkType)) {
                throw new IllegalArgumentException("Score cache already registered for type " + networkType);
            }
            this.mScoreCaches.put(networkType, scoreCache);
        }
    }

    @Override
    protected void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        NetworkScorerAppManager.NetworkScorerAppData currentScorer = NetworkScorerAppManager.getActiveScorer(this.mContext);
        if (currentScorer == null) {
            writer.println("Scoring is disabled.");
            return;
        }
        writer.println("Current scorer: " + currentScorer.mPackageName);
        for (INetworkScoreCache scoreCache : this.getScoreCaches()) {
            try {
                scoreCache.asBinder().dump(fd, args);
            }
            catch (RemoteException e) {
                writer.println("Unable to dump score cache");
                if (!Log.isLoggable(TAG, 2)) continue;
                Log.v(TAG, "Unable to dump score cache", e);
            }
        }
        if (this.mServiceConnection != null) {
            this.mServiceConnection.dump(fd, writer, args);
        } else {
            writer.println("ScoringServiceConnection: null");
        }
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<INetworkScoreCache> getScoreCaches() {
        Map<Integer, INetworkScoreCache> map = this.mScoreCaches;
        synchronized (map) {
            return new HashSet<INetworkScoreCache>(this.mScoreCaches.values());
        }
    }

    private static class ScoringServiceConnection
    implements ServiceConnection {
        private final ComponentName mComponentName;
        private boolean mBound = false;
        private boolean mConnected = false;

        ScoringServiceConnection(ComponentName componentName) {
            this.mComponentName = componentName;
        }

        void connect(Context context) {
            if (!this.mBound) {
                Intent service = new Intent();
                service.setComponent(this.mComponentName);
                this.mBound = context.bindServiceAsUser(service, this, 0x4000001, UserHandle.SYSTEM);
                if (!this.mBound) {
                    Log.w(NetworkScoreService.TAG, "Bind call failed for " + service);
                }
            }
        }

        void disconnect(Context context) {
            try {
                if (this.mBound) {
                    this.mBound = false;
                    context.unbindService(this);
                }
            }
            catch (RuntimeException e) {
                Log.e(NetworkScoreService.TAG, "Unbind failed.", e);
            }
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            this.mConnected = true;
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            this.mConnected = false;
        }

        public void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
            writer.println("ScoringServiceConnection: " + this.mComponentName + ", bound: " + this.mBound + ", connected: " + this.mConnected);
        }
    }

    private class NetworkScorerPackageMonitor
    extends PackageMonitor {
        final String mRegisteredPackage;

        private NetworkScorerPackageMonitor(String mRegisteredPackage) {
            this.mRegisteredPackage = mRegisteredPackage;
        }

        @Override
        public void onPackageAdded(String packageName, int uid) {
            this.evaluateBinding(packageName, true);
        }

        @Override
        public void onPackageRemoved(String packageName, int uid) {
            this.evaluateBinding(packageName, true);
        }

        @Override
        public void onPackageModified(String packageName) {
            this.evaluateBinding(packageName, false);
        }

        @Override
        public boolean onHandleForceStop(Intent intent, String[] packages, int uid, boolean doit) {
            if (doit) {
                for (String packageName : packages) {
                    this.evaluateBinding(packageName, true);
                }
            }
            return super.onHandleForceStop(intent, packages, uid, doit);
        }

        @Override
        public void onPackageUpdateFinished(String packageName, int uid) {
            this.evaluateBinding(packageName, true);
        }

        private void evaluateBinding(String scorerPackageName, boolean forceUnbind) {
            if (this.mRegisteredPackage.equals(scorerPackageName)) {
                NetworkScorerAppManager.NetworkScorerAppData activeScorer = NetworkScorerAppManager.getActiveScorer(NetworkScoreService.this.mContext);
                if (activeScorer == null) {
                    Log.i(NetworkScoreService.TAG, "Package " + this.mRegisteredPackage + " is no longer valid, disabling scoring.");
                    NetworkScoreService.this.setScorerInternal(null);
                } else if (activeScorer.mScoringServiceClassName == null) {
                    NetworkScoreService.this.unbindFromScoringServiceIfNeeded();
                } else {
                    if (forceUnbind) {
                        NetworkScoreService.this.unbindFromScoringServiceIfNeeded();
                    }
                    NetworkScoreService.this.bindToScoringServiceIfNeeded(activeScorer);
                }
            }
        }
    }
}

