/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.util.Slog;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

class RandomBlock {
    private static final String TAG = "RandomBlock";
    private static final boolean DEBUG = false;
    private static final int BLOCK_SIZE = 512;
    private byte[] block = new byte[512];

    private RandomBlock() {
    }

    static RandomBlock fromFile(String filename) throws IOException {
        RandomBlock randomBlock;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(filename);
            randomBlock = RandomBlock.fromStream(stream);
        }
        catch (Throwable throwable) {
            RandomBlock.close(stream);
            throw throwable;
        }
        RandomBlock.close(stream);
        return randomBlock;
    }

    private static RandomBlock fromStream(InputStream in) throws IOException {
        int result;
        RandomBlock retval = new RandomBlock();
        for (int total = 0; total < 512; total += result) {
            result = in.read(retval.block, total, 512 - total);
            if (result != -1) continue;
            throw new EOFException();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void toFile(String filename, boolean sync) throws IOException {
        RandomAccessFile out = null;
        try {
            out = new RandomAccessFile(filename, sync ? "rws" : "rw");
            this.toDataOut(out);
            RandomBlock.truncateIfPossible(out);
        }
        catch (Throwable throwable) {
            RandomBlock.close(out);
            throw throwable;
        }
        RandomBlock.close(out);
    }

    private static void truncateIfPossible(RandomAccessFile f) {
        try {
            f.setLength(512L);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void toDataOut(DataOutput out) throws IOException {
        out.write(this.block);
    }

    private static void close(Closeable c) {
        try {
            if (c == null) {
                return;
            }
            c.close();
        }
        catch (IOException e) {
            Slog.w(TAG, "IOException thrown while closing Closeable", e);
        }
    }
}

