/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accessibility;

import android.content.Context;
import android.os.PowerManager;
import android.util.Pools;
import android.util.SparseBooleanArray;
import android.view.Choreographer;
import android.view.InputEvent;
import android.view.InputFilter;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.accessibility.AccessibilityEvent;
import com.android.server.accessibility.AccessibilityManagerService;
import com.android.server.accessibility.AutoclickController;
import com.android.server.accessibility.EventStreamTransformation;
import com.android.server.accessibility.KeyboardInterceptor;
import com.android.server.accessibility.MagnificationGestureHandler;
import com.android.server.accessibility.MotionEventInjector;
import com.android.server.accessibility.TouchExplorer;

class AccessibilityInputFilter
extends InputFilter
implements EventStreamTransformation {
    private static final String TAG = AccessibilityInputFilter.class.getSimpleName();
    private static final boolean DEBUG = false;
    static final int FLAG_FEATURE_SCREEN_MAGNIFIER = 1;
    static final int FLAG_FEATURE_TOUCH_EXPLORATION = 2;
    static final int FLAG_FEATURE_FILTER_KEY_EVENTS = 4;
    static final int FLAG_FEATURE_AUTOCLICK = 8;
    static final int FLAG_FEATURE_INJECT_MOTION_EVENTS = 16;
    static final int FEATURES_AFFECTING_MOTION_EVENTS = 27;
    static final int FLAG_FEATURE_CONTROL_SCREEN_MAGNIFIER = 32;
    private final Runnable mProcessBatchedEventsRunnable = new Runnable(){

        @Override
        public void run() {
            long frameTimeNanos = AccessibilityInputFilter.this.mChoreographer.getFrameTimeNanos();
            AccessibilityInputFilter.this.processBatchedEvents(frameTimeNanos);
            if (AccessibilityInputFilter.this.mEventQueue != null) {
                AccessibilityInputFilter.this.scheduleProcessBatchedEvents();
            }
        }
    };
    private final Context mContext;
    private final PowerManager mPm;
    private final AccessibilityManagerService mAms;
    private final Choreographer mChoreographer;
    private boolean mInstalled;
    private int mUserId;
    private int mEnabledFeatures;
    private TouchExplorer mTouchExplorer;
    private MagnificationGestureHandler mMagnificationGestureHandler;
    private MotionEventInjector mMotionEventInjector;
    private AutoclickController mAutoclickController;
    private KeyboardInterceptor mKeyboardInterceptor;
    private EventStreamTransformation mEventHandler;
    private MotionEventHolder mEventQueue;
    private EventStreamState mMouseStreamState;
    private EventStreamState mTouchScreenStreamState;
    private EventStreamState mKeyboardStreamState;

    AccessibilityInputFilter(Context context, AccessibilityManagerService service) {
        super(context.getMainLooper());
        this.mContext = context;
        this.mAms = service;
        this.mPm = (PowerManager)context.getSystemService("power");
        this.mChoreographer = Choreographer.getInstance();
    }

    @Override
    public void onInstalled() {
        this.mInstalled = true;
        this.disableFeatures();
        this.enableFeatures();
        super.onInstalled();
    }

    @Override
    public void onUninstalled() {
        this.mInstalled = false;
        this.disableFeatures();
        super.onUninstalled();
    }

    @Override
    public void onInputEvent(InputEvent event, int policyFlags) {
        if (this.mEventHandler == null) {
            super.onInputEvent(event, policyFlags);
            return;
        }
        EventStreamState state = this.getEventStreamState(event);
        if (state == null) {
            super.onInputEvent(event, policyFlags);
            return;
        }
        int eventSource = event.getSource();
        if ((policyFlags & 0x40000000) == 0) {
            state.reset();
            this.mEventHandler.clearEvents(eventSource);
            super.onInputEvent(event, policyFlags);
            return;
        }
        if (state.updateDeviceId(event.getDeviceId())) {
            this.mEventHandler.clearEvents(eventSource);
        }
        if (!state.deviceIdValid()) {
            super.onInputEvent(event, policyFlags);
            return;
        }
        if (event instanceof MotionEvent) {
            if ((this.mEnabledFeatures & 0x1B) != 0) {
                MotionEvent motionEvent = (MotionEvent)event;
                this.processMotionEvent(state, motionEvent, policyFlags);
                return;
            }
            super.onInputEvent(event, policyFlags);
        } else if (event instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)event;
            this.processKeyEvent(state, keyEvent, policyFlags);
        }
    }

    private EventStreamState getEventStreamState(InputEvent event) {
        if (event instanceof MotionEvent) {
            if (event.isFromSource(4098)) {
                if (this.mTouchScreenStreamState == null) {
                    this.mTouchScreenStreamState = new TouchScreenEventStreamState();
                }
                return this.mTouchScreenStreamState;
            }
            if (event.isFromSource(8194)) {
                if (this.mMouseStreamState == null) {
                    this.mMouseStreamState = new MouseEventStreamState();
                }
                return this.mMouseStreamState;
            }
        } else if (event instanceof KeyEvent && event.isFromSource(257)) {
            if (this.mKeyboardStreamState == null) {
                this.mKeyboardStreamState = new KeyboardEventStreamState();
            }
            return this.mKeyboardStreamState;
        }
        return null;
    }

    private void processMotionEvent(EventStreamState state, MotionEvent event, int policyFlags) {
        if (!state.shouldProcessScroll() && event.getActionMasked() == 8) {
            super.onInputEvent(event, policyFlags);
            return;
        }
        if (!state.shouldProcessMotionEvent(event)) {
            return;
        }
        this.batchMotionEvent(event, policyFlags);
    }

    private void processKeyEvent(EventStreamState state, KeyEvent event, int policyFlags) {
        if (!state.shouldProcessKeyEvent(event)) {
            return;
        }
        this.mEventHandler.onKeyEvent(event, policyFlags);
    }

    private void scheduleProcessBatchedEvents() {
        this.mChoreographer.postCallback(0, this.mProcessBatchedEventsRunnable, null);
    }

    private void batchMotionEvent(MotionEvent event, int policyFlags) {
        if (this.mEventQueue == null) {
            this.mEventQueue = MotionEventHolder.obtain(event, policyFlags);
            this.scheduleProcessBatchedEvents();
            return;
        }
        if (this.mEventQueue.event.addBatch(event)) {
            return;
        }
        MotionEventHolder holder = MotionEventHolder.obtain(event, policyFlags);
        holder.next = this.mEventQueue;
        this.mEventQueue.previous = holder;
        this.mEventQueue = holder;
    }

    private void processBatchedEvents(long frameNanos) {
        MotionEventHolder current = this.mEventQueue;
        if (current == null) {
            return;
        }
        while (current.next != null) {
            current = current.next;
        }
        while (true) {
            if (current == null) {
                this.mEventQueue = null;
                break;
            }
            if (current.event.getEventTimeNano() >= frameNanos) {
                current.next = null;
                break;
            }
            this.handleMotionEvent(current.event, current.policyFlags);
            MotionEventHolder prior = current;
            current = current.previous;
            prior.recycle();
        }
    }

    private void handleMotionEvent(MotionEvent event, int policyFlags) {
        if (this.mEventHandler != null) {
            this.mPm.userActivity(event.getEventTime(), false);
            MotionEvent transformedEvent = MotionEvent.obtain(event);
            this.mEventHandler.onMotionEvent(transformedEvent, event, policyFlags);
            transformedEvent.recycle();
        }
    }

    @Override
    public void onMotionEvent(MotionEvent transformedEvent, MotionEvent rawEvent, int policyFlags) {
        this.sendInputEvent(transformedEvent, policyFlags);
    }

    @Override
    public void onKeyEvent(KeyEvent event, int policyFlags) {
        this.sendInputEvent(event, policyFlags);
    }

    @Override
    public void onAccessibilityEvent(AccessibilityEvent event) {
    }

    @Override
    public void setNext(EventStreamTransformation sink) {
    }

    @Override
    public void clearEvents(int inputSource) {
    }

    void setUserAndEnabledFeatures(int userId, int enabledFeatures) {
        if (this.mEnabledFeatures == enabledFeatures && this.mUserId == userId) {
            return;
        }
        if (this.mInstalled) {
            this.disableFeatures();
        }
        this.mUserId = userId;
        this.mEnabledFeatures = enabledFeatures;
        if (this.mInstalled) {
            this.enableFeatures();
        }
    }

    void notifyAccessibilityEvent(AccessibilityEvent event) {
        if (this.mEventHandler != null) {
            this.mEventHandler.onAccessibilityEvent(event);
        }
    }

    private void enableFeatures() {
        this.resetStreamState();
        if ((this.mEnabledFeatures & 8) != 0) {
            this.mAutoclickController = new AutoclickController(this.mContext, this.mUserId);
            this.addFirstEventHandler(this.mAutoclickController);
        }
        if ((this.mEnabledFeatures & 2) != 0) {
            this.mTouchExplorer = new TouchExplorer(this.mContext, this.mAms);
            this.addFirstEventHandler(this.mTouchExplorer);
        }
        if ((this.mEnabledFeatures & 0x20) != 0 || (this.mEnabledFeatures & 1) != 0) {
            boolean detectControlGestures = (this.mEnabledFeatures & 1) != 0;
            this.mMagnificationGestureHandler = new MagnificationGestureHandler(this.mContext, this.mAms, detectControlGestures);
            this.addFirstEventHandler(this.mMagnificationGestureHandler);
        }
        if ((this.mEnabledFeatures & 0x10) != 0) {
            this.mMotionEventInjector = new MotionEventInjector(this.mContext.getMainLooper());
            this.addFirstEventHandler(this.mMotionEventInjector);
            this.mAms.setMotionEventInjector(this.mMotionEventInjector);
        }
        if ((this.mEnabledFeatures & 4) != 0) {
            this.mKeyboardInterceptor = new KeyboardInterceptor(this.mAms);
            this.addFirstEventHandler(this.mKeyboardInterceptor);
        }
    }

    private void addFirstEventHandler(EventStreamTransformation handler) {
        if (this.mEventHandler != null) {
            handler.setNext(this.mEventHandler);
        } else {
            handler.setNext(this);
        }
        this.mEventHandler = handler;
    }

    private void disableFeatures() {
        this.processBatchedEvents(Long.MAX_VALUE);
        if (this.mMotionEventInjector != null) {
            this.mAms.setMotionEventInjector(null);
            this.mMotionEventInjector.onDestroy();
            this.mMotionEventInjector = null;
        }
        if (this.mAutoclickController != null) {
            this.mAutoclickController.onDestroy();
            this.mAutoclickController = null;
        }
        if (this.mTouchExplorer != null) {
            this.mTouchExplorer.onDestroy();
            this.mTouchExplorer = null;
        }
        if (this.mMagnificationGestureHandler != null) {
            this.mMagnificationGestureHandler.onDestroy();
            this.mMagnificationGestureHandler = null;
        }
        if (this.mKeyboardInterceptor != null) {
            this.mKeyboardInterceptor.onDestroy();
            this.mKeyboardInterceptor = null;
        }
        this.mEventHandler = null;
        this.resetStreamState();
    }

    void resetStreamState() {
        if (this.mTouchScreenStreamState != null) {
            this.mTouchScreenStreamState.reset();
        }
        if (this.mMouseStreamState != null) {
            this.mMouseStreamState.reset();
        }
        if (this.mKeyboardStreamState != null) {
            this.mKeyboardStreamState.reset();
        }
    }

    @Override
    public void onDestroy() {
    }

    private static class KeyboardEventStreamState
    extends EventStreamState {
        private SparseBooleanArray mEventSequenceStartedMap = new SparseBooleanArray();

        public KeyboardEventStreamState() {
            this.reset();
        }

        @Override
        public final void reset() {
            super.reset();
            this.mEventSequenceStartedMap.clear();
        }

        @Override
        public boolean updateDeviceId(int deviceId) {
            return false;
        }

        @Override
        public boolean deviceIdValid() {
            return true;
        }

        @Override
        public final boolean shouldProcessKeyEvent(KeyEvent event) {
            int deviceId = event.getDeviceId();
            if (this.mEventSequenceStartedMap.get(deviceId, false)) {
                return true;
            }
            boolean shouldProcess = event.getAction() == 0;
            this.mEventSequenceStartedMap.put(deviceId, shouldProcess);
            return shouldProcess;
        }
    }

    private static class TouchScreenEventStreamState
    extends EventStreamState {
        private boolean mTouchSequenceStarted;
        private boolean mHoverSequenceStarted;

        public TouchScreenEventStreamState() {
            this.reset();
        }

        @Override
        public final void reset() {
            super.reset();
            this.mTouchSequenceStarted = false;
            this.mHoverSequenceStarted = false;
        }

        @Override
        public final boolean shouldProcessMotionEvent(MotionEvent event) {
            if (event.isTouchEvent()) {
                if (this.mTouchSequenceStarted) {
                    return true;
                }
                this.mTouchSequenceStarted = event.getActionMasked() == 0;
                return this.mTouchSequenceStarted;
            }
            if (this.mHoverSequenceStarted) {
                return true;
            }
            this.mHoverSequenceStarted = event.getActionMasked() == 9;
            return this.mHoverSequenceStarted;
        }
    }

    private static class MouseEventStreamState
    extends EventStreamState {
        private boolean mMotionSequenceStarted;

        public MouseEventStreamState() {
            this.reset();
        }

        @Override
        public final void reset() {
            super.reset();
            this.mMotionSequenceStarted = false;
        }

        @Override
        public final boolean shouldProcessScroll() {
            return true;
        }

        @Override
        public final boolean shouldProcessMotionEvent(MotionEvent event) {
            if (this.mMotionSequenceStarted) {
                return true;
            }
            int action = event.getActionMasked();
            this.mMotionSequenceStarted = action == 0 || action == 7;
            return this.mMotionSequenceStarted;
        }
    }

    private static class EventStreamState {
        private int mDeviceId = -1;

        EventStreamState() {
        }

        public boolean updateDeviceId(int deviceId) {
            if (this.mDeviceId == deviceId) {
                return false;
            }
            this.reset();
            this.mDeviceId = deviceId;
            return true;
        }

        public boolean deviceIdValid() {
            return this.mDeviceId >= 0;
        }

        public void reset() {
            this.mDeviceId = -1;
        }

        public boolean shouldProcessScroll() {
            return false;
        }

        public boolean shouldProcessMotionEvent(MotionEvent event) {
            return false;
        }

        public boolean shouldProcessKeyEvent(KeyEvent event) {
            return false;
        }
    }

    private static class MotionEventHolder {
        private static final int MAX_POOL_SIZE = 32;
        private static final Pools.SimplePool<MotionEventHolder> sPool = new Pools.SimplePool(32);
        public int policyFlags;
        public MotionEvent event;
        public MotionEventHolder next;
        public MotionEventHolder previous;

        private MotionEventHolder() {
        }

        public static MotionEventHolder obtain(MotionEvent event, int policyFlags) {
            MotionEventHolder holder = sPool.acquire();
            if (holder == null) {
                holder = new MotionEventHolder();
            }
            holder.event = MotionEvent.obtain(event);
            holder.policyFlags = policyFlags;
            return holder;
        }

        public void recycle() {
            this.event.recycle();
            this.event = null;
            this.policyFlags = 0;
            this.next = null;
            this.previous = null;
            sPool.release(this);
        }
    }
}

