/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accessibility;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.os.SystemClock;
import android.provider.Settings;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.accessibility.AccessibilityEvent;
import com.android.server.accessibility.EventStreamTransformation;

public class AutoclickController
implements EventStreamTransformation {
    private static final String LOG_TAG = AutoclickController.class.getSimpleName();
    private EventStreamTransformation mNext;
    private final Context mContext;
    private final int mUserId;
    private ClickScheduler mClickScheduler;
    private ClickDelayObserver mClickDelayObserver;

    public AutoclickController(Context context, int userId) {
        this.mContext = context;
        this.mUserId = userId;
    }

    @Override
    public void onMotionEvent(MotionEvent event, MotionEvent rawEvent, int policyFlags) {
        if (event.isFromSource(8194)) {
            if (this.mClickScheduler == null) {
                Handler handler = new Handler(this.mContext.getMainLooper());
                this.mClickScheduler = new ClickScheduler(handler, 600);
                this.mClickDelayObserver = new ClickDelayObserver(this.mUserId, handler);
                this.mClickDelayObserver.start(this.mContext.getContentResolver(), this.mClickScheduler);
            }
            this.handleMouseMotion(event, policyFlags);
        } else if (this.mClickScheduler != null) {
            this.mClickScheduler.cancel();
        }
        if (this.mNext != null) {
            this.mNext.onMotionEvent(event, rawEvent, policyFlags);
        }
    }

    @Override
    public void onKeyEvent(KeyEvent event, int policyFlags) {
        if (this.mClickScheduler != null) {
            if (KeyEvent.isModifierKey(event.getKeyCode())) {
                this.mClickScheduler.updateMetaState(event.getMetaState());
            } else {
                this.mClickScheduler.cancel();
            }
        }
        if (this.mNext != null) {
            this.mNext.onKeyEvent(event, policyFlags);
        }
    }

    @Override
    public void onAccessibilityEvent(AccessibilityEvent event) {
        if (this.mNext != null) {
            this.mNext.onAccessibilityEvent(event);
        }
    }

    @Override
    public void setNext(EventStreamTransformation next) {
        this.mNext = next;
    }

    @Override
    public void clearEvents(int inputSource) {
        if (inputSource == 8194 && this.mClickScheduler != null) {
            this.mClickScheduler.cancel();
        }
        if (this.mNext != null) {
            this.mNext.clearEvents(inputSource);
        }
    }

    @Override
    public void onDestroy() {
        if (this.mClickDelayObserver != null) {
            this.mClickDelayObserver.stop();
            this.mClickDelayObserver = null;
        }
        if (this.mClickScheduler != null) {
            this.mClickScheduler.cancel();
            this.mClickScheduler = null;
        }
    }

    private void handleMouseMotion(MotionEvent event, int policyFlags) {
        switch (event.getActionMasked()) {
            case 7: {
                if (event.getPointerCount() == 1) {
                    this.mClickScheduler.update(event, policyFlags);
                    break;
                }
                this.mClickScheduler.cancel();
                break;
            }
            case 9: 
            case 10: {
                break;
            }
            default: {
                this.mClickScheduler.cancel();
            }
        }
    }

    private final class ClickScheduler
    implements Runnable {
        private static final double MOVEMENT_SLOPE = 20.0;
        private boolean mActive;
        private long mScheduledClickTime;
        private MotionEvent mLastMotionEvent;
        private int mEventPolicyFlags;
        private int mMetaState;
        private MotionEvent.PointerCoords mAnchorCoords;
        private int mDelay;
        private Handler mHandler;
        private MotionEvent.PointerProperties[] mTempPointerProperties;
        private MotionEvent.PointerCoords[] mTempPointerCoords;

        public ClickScheduler(Handler handler, int delay) {
            this.mHandler = handler;
            this.mLastMotionEvent = null;
            this.resetInternalState();
            this.mDelay = delay;
            this.mAnchorCoords = new MotionEvent.PointerCoords();
        }

        @Override
        public void run() {
            long now = SystemClock.uptimeMillis();
            if (now < this.mScheduledClickTime) {
                this.mHandler.postDelayed(this, this.mScheduledClickTime - now);
                return;
            }
            this.sendClick();
            this.resetInternalState();
        }

        public void update(MotionEvent event, int policyFlags) {
            this.mMetaState = event.getMetaState();
            boolean moved = this.detectMovement(event);
            this.cacheLastEvent(event, policyFlags, this.mLastMotionEvent == null || moved);
            if (moved) {
                this.rescheduleClick(this.mDelay);
            }
        }

        public void cancel() {
            if (!this.mActive) {
                return;
            }
            this.resetInternalState();
            this.mHandler.removeCallbacks(this);
        }

        public void updateMetaState(int state) {
            this.mMetaState = state;
        }

        public void updateDelay(int delay) {
            this.mDelay = delay;
        }

        private void rescheduleClick(int delay) {
            long clickTime = SystemClock.uptimeMillis() + (long)delay;
            if (this.mActive && clickTime > this.mScheduledClickTime) {
                this.mScheduledClickTime = clickTime;
                return;
            }
            if (this.mActive) {
                this.mHandler.removeCallbacks(this);
            }
            this.mActive = true;
            this.mScheduledClickTime = clickTime;
            this.mHandler.postDelayed(this, delay);
        }

        private void cacheLastEvent(MotionEvent event, int policyFlags, boolean useAsAnchor) {
            if (this.mLastMotionEvent != null) {
                this.mLastMotionEvent.recycle();
            }
            this.mLastMotionEvent = MotionEvent.obtain(event);
            this.mEventPolicyFlags = policyFlags;
            if (useAsAnchor) {
                int pointerIndex = this.mLastMotionEvent.getActionIndex();
                this.mLastMotionEvent.getPointerCoords(pointerIndex, this.mAnchorCoords);
            }
        }

        private void resetInternalState() {
            this.mActive = false;
            if (this.mLastMotionEvent != null) {
                this.mLastMotionEvent.recycle();
                this.mLastMotionEvent = null;
            }
            this.mScheduledClickTime = -1L;
        }

        private boolean detectMovement(MotionEvent event) {
            float deltaY;
            if (this.mLastMotionEvent == null) {
                return false;
            }
            int pointerIndex = event.getActionIndex();
            float deltaX = this.mAnchorCoords.x - event.getX(pointerIndex);
            double delta = Math.hypot(deltaX, deltaY = this.mAnchorCoords.y - event.getY(pointerIndex));
            return delta > 20.0;
        }

        private void sendClick() {
            if (this.mLastMotionEvent == null || AutoclickController.this.mNext == null) {
                return;
            }
            int pointerIndex = this.mLastMotionEvent.getActionIndex();
            if (this.mTempPointerProperties == null) {
                this.mTempPointerProperties = new MotionEvent.PointerProperties[1];
                this.mTempPointerProperties[0] = new MotionEvent.PointerProperties();
            }
            this.mLastMotionEvent.getPointerProperties(pointerIndex, this.mTempPointerProperties[0]);
            if (this.mTempPointerCoords == null) {
                this.mTempPointerCoords = new MotionEvent.PointerCoords[1];
                this.mTempPointerCoords[0] = new MotionEvent.PointerCoords();
            }
            this.mLastMotionEvent.getPointerCoords(pointerIndex, this.mTempPointerCoords[0]);
            long now = SystemClock.uptimeMillis();
            MotionEvent downEvent = MotionEvent.obtain(now, now, 0, 1, this.mTempPointerProperties, this.mTempPointerCoords, this.mMetaState, 1, 1.0f, 1.0f, this.mLastMotionEvent.getDeviceId(), 0, this.mLastMotionEvent.getSource(), this.mLastMotionEvent.getFlags());
            MotionEvent upEvent = MotionEvent.obtain(downEvent);
            upEvent.setAction(1);
            AutoclickController.this.mNext.onMotionEvent(downEvent, downEvent, this.mEventPolicyFlags);
            downEvent.recycle();
            AutoclickController.this.mNext.onMotionEvent(upEvent, upEvent, this.mEventPolicyFlags);
            upEvent.recycle();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ClickScheduler: { active=").append(this.mActive);
            builder.append(", delay=").append(this.mDelay);
            builder.append(", scheduledClickTime=").append(this.mScheduledClickTime);
            builder.append(", anchor={x:").append(this.mAnchorCoords.x);
            builder.append(", y:").append(this.mAnchorCoords.y).append("}");
            builder.append(", metastate=").append(this.mMetaState);
            builder.append(", policyFlags=").append(this.mEventPolicyFlags);
            builder.append(", lastMotionEvent=").append(this.mLastMotionEvent);
            builder.append(" }");
            return builder.toString();
        }
    }

    private static final class ClickDelayObserver
    extends ContentObserver {
        private final Uri mAutoclickDelaySettingUri = Settings.Secure.getUriFor("accessibility_autoclick_delay");
        private ContentResolver mContentResolver;
        private ClickScheduler mClickScheduler;
        private final int mUserId;

        public ClickDelayObserver(int userId, Handler handler) {
            super(handler);
            this.mUserId = userId;
        }

        public void start(ContentResolver contentResolver, ClickScheduler clickScheduler) {
            if (this.mContentResolver != null || this.mClickScheduler != null) {
                throw new IllegalStateException("Observer already started.");
            }
            if (contentResolver == null) {
                throw new NullPointerException("contentResolver not set.");
            }
            if (clickScheduler == null) {
                throw new NullPointerException("clickScheduler not set.");
            }
            this.mContentResolver = contentResolver;
            this.mClickScheduler = clickScheduler;
            this.mContentResolver.registerContentObserver(this.mAutoclickDelaySettingUri, false, this, this.mUserId);
            this.onChange(true, this.mAutoclickDelaySettingUri);
        }

        public void stop() {
            if (this.mContentResolver == null || this.mClickScheduler == null) {
                throw new IllegalStateException("ClickDelayObserver not started.");
            }
            this.mContentResolver.unregisterContentObserver(this);
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            if (this.mAutoclickDelaySettingUri.equals(uri)) {
                int delay = Settings.Secure.getIntForUser(this.mContentResolver, "accessibility_autoclick_delay", 600, this.mUserId);
                this.mClickScheduler.updateDelay(delay);
            }
        }
    }
}

