/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.AppGlobals;
import android.app.IActivityController;
import android.app.ResultInfo;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.Trace;
import android.os.UserHandle;
import android.service.voice.IVoiceInteractionSession;
import android.util.ArraySet;
import android.util.EventLog;
import android.util.Log;
import android.util.Slog;
import com.android.internal.app.IVoiceInteractor;
import com.android.internal.content.ReferrerIntent;
import com.android.internal.os.BatteryStatsImpl;
import com.android.server.Watchdog;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ActivityStackSupervisor;
import com.android.server.am.AppTimeTracker;
import com.android.server.am.ConnectionRecord;
import com.android.server.am.EventLogTags;
import com.android.server.am.LaunchingTaskPositioner;
import com.android.server.am.PendingIntentRecord;
import com.android.server.am.ProcessRecord;
import com.android.server.am.RecentTasks;
import com.android.server.am.TaskRecord;
import com.android.server.wm.TaskGroup;
import com.android.server.wm.WindowManagerService;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

final class ActivityStack {
    private static final String TAG = "ActivityManager";
    private static final String TAG_ADD_REMOVE = "ActivityManager";
    private static final String TAG_APP = "ActivityManager";
    private static final String TAG_CLEANUP = "ActivityManager";
    private static final String TAG_CONFIGURATION = "ActivityManager";
    private static final String TAG_CONTAINERS = "ActivityManager";
    private static final String TAG_PAUSE = "ActivityManager";
    private static final String TAG_RELEASE = "ActivityManager";
    private static final String TAG_RESULTS = "ActivityManager";
    private static final String TAG_SAVED_STATE = "ActivityManager";
    private static final String TAG_SCREENSHOTS = "ActivityManager";
    private static final String TAG_STACK = "ActivityManager";
    private static final String TAG_STATES = "ActivityManager";
    private static final String TAG_SWITCH = "ActivityManager";
    private static final String TAG_TASKS = "ActivityManager";
    private static final String TAG_TRANSITION = "ActivityManager";
    private static final String TAG_USER_LEAVING = "ActivityManager";
    private static final String TAG_VISIBILITY = "ActivityManager";
    private static final boolean VALIDATE_TOKENS = false;
    static final int LAUNCH_TICK = 500;
    static final int PAUSE_TIMEOUT = 500;
    static final int STOP_TIMEOUT = 10000;
    static final int DESTROY_TIMEOUT = 10000;
    static final long ACTIVITY_INACTIVE_RESET_TIME = 0L;
    static final long START_WARN_TIME = 5000L;
    static final boolean SHOW_APP_STARTING_PREVIEW = true;
    static final long TRANSLUCENT_CONVERSION_TIMEOUT = 2000L;
    private static final int MAX_STOPPING_TO_FORCE = 3;
    static final int STACK_INVISIBLE = 0;
    static final int STACK_VISIBLE = 1;
    static final int STACK_VISIBLE_ACTIVITY_BEHIND = 2;
    static final int REMOVE_TASK_MODE_DESTROYING = 0;
    static final int REMOVE_TASK_MODE_MOVING = 1;
    static final int REMOVE_TASK_MODE_MOVING_TO_TOP = 2;
    final ActivityManagerService mService;
    final WindowManagerService mWindowManager;
    private final RecentTasks mRecentTasks;
    private final ArrayList<TaskRecord> mTaskHistory = new ArrayList();
    final ArrayList<TaskGroup> mValidateAppTokens = new ArrayList();
    final ArrayList<ActivityRecord> mLRUActivities = new ArrayList();
    final ArrayList<ActivityRecord> mNoAnimActivities = new ArrayList();
    ActivityRecord mPausingActivity = null;
    ActivityRecord mLastPausedActivity = null;
    ActivityRecord mLastNoHistoryActivity = null;
    ActivityRecord mResumedActivity = null;
    ActivityRecord mLastStartedActivity = null;
    ActivityRecord mTranslucentActivityWaiting = null;
    private ArrayList<ActivityRecord> mUndrawnActivitiesBelowTopTranslucent = new ArrayList();
    boolean mConfigWillChange;
    boolean mFullscreen = true;
    Rect mBounds = null;
    boolean mUpdateBoundsDeferred;
    boolean mUpdateBoundsDeferredCalled;
    final Rect mDeferredBounds = new Rect();
    final Rect mDeferredTaskBounds = new Rect();
    final Rect mDeferredTaskInsetBounds = new Rect();
    long mLaunchStartTime = 0L;
    long mFullyDrawnStartTime = 0L;
    int mCurrentUser;
    final int mStackId;
    final ActivityStackSupervisor.ActivityContainer mActivityContainer;
    ArrayList<ActivityStack> mStacks;
    int mDisplayId;
    final ActivityStackSupervisor mStackSupervisor;
    private final LaunchingTaskPositioner mTaskPositioner;
    static final int PAUSE_TIMEOUT_MSG = 101;
    static final int DESTROY_TIMEOUT_MSG = 102;
    static final int LAUNCH_TICK_MSG = 103;
    static final int STOP_TIMEOUT_MSG = 104;
    static final int DESTROY_ACTIVITIES_MSG = 105;
    static final int TRANSLUCENT_TIMEOUT_MSG = 106;
    static final int RELEASE_BACKGROUND_RESOURCES_TIMEOUT_MSG = 107;
    final Handler mHandler;
    static final int FINISH_IMMEDIATELY = 0;
    static final int FINISH_AFTER_PAUSE = 1;
    static final int FINISH_AFTER_VISIBLE = 2;

    int numActivities() {
        int count = 0;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            count += this.mTaskHistory.get((int)taskNdx).mActivities.size();
        }
        return count;
    }

    ActivityStack(ActivityStackSupervisor.ActivityContainer activityContainer, RecentTasks recentTasks) {
        this.mActivityContainer = activityContainer;
        this.mStackSupervisor = activityContainer.getOuter();
        this.mService = this.mStackSupervisor.mService;
        this.mHandler = new ActivityStackHandler(this.mService.mHandler.getLooper());
        this.mWindowManager = this.mService.mWindowManager;
        this.mStackId = activityContainer.mStackId;
        this.mCurrentUser = this.mService.mUserController.getCurrentUserIdLocked();
        this.mRecentTasks = recentTasks;
        this.mTaskPositioner = this.mStackId == 2 ? new LaunchingTaskPositioner() : null;
    }

    void attachDisplay(ActivityStackSupervisor.ActivityDisplay activityDisplay, boolean onTop) {
        this.mDisplayId = activityDisplay.mDisplayId;
        this.mStacks = activityDisplay.mStacks;
        this.mBounds = this.mWindowManager.attachStack(this.mStackId, activityDisplay.mDisplayId, onTop);
        boolean bl = this.mFullscreen = this.mBounds == null;
        if (this.mTaskPositioner != null) {
            this.mTaskPositioner.setDisplay(activityDisplay.mDisplay);
            this.mTaskPositioner.configure(this.mBounds);
        }
        if (this.mStackId == 3) {
            this.mStackSupervisor.resizeDockedStackLocked(this.mBounds, null, null, null, null, true);
        }
    }

    void detachDisplay() {
        this.mDisplayId = -1;
        this.mStacks = null;
        if (this.mTaskPositioner != null) {
            this.mTaskPositioner.reset();
        }
        this.mWindowManager.detachStack(this.mStackId);
        if (this.mStackId == 3) {
            this.mStackSupervisor.resizeDockedStackLocked(null, null, null, null, null, true);
        }
    }

    public void getDisplaySize(Point out) {
        this.mActivityContainer.mActivityDisplay.mDisplay.getSize(out);
    }

    void deferUpdateBounds() {
        if (!this.mUpdateBoundsDeferred) {
            this.mUpdateBoundsDeferred = true;
            this.mUpdateBoundsDeferredCalled = false;
        }
    }

    void continueUpdateBounds() {
        boolean wasDeferred = this.mUpdateBoundsDeferred;
        this.mUpdateBoundsDeferred = false;
        if (wasDeferred && this.mUpdateBoundsDeferredCalled) {
            this.mStackSupervisor.resizeStackUncheckedLocked(this, this.mDeferredBounds.isEmpty() ? null : this.mDeferredBounds, this.mDeferredTaskBounds.isEmpty() ? null : this.mDeferredTaskBounds, this.mDeferredTaskInsetBounds.isEmpty() ? null : this.mDeferredTaskInsetBounds);
        }
    }

    boolean updateBoundsAllowed(Rect bounds, Rect tempTaskBounds, Rect tempTaskInsetBounds) {
        if (!this.mUpdateBoundsDeferred) {
            return true;
        }
        if (bounds != null) {
            this.mDeferredBounds.set(bounds);
        } else {
            this.mDeferredBounds.setEmpty();
        }
        if (tempTaskBounds != null) {
            this.mDeferredTaskBounds.set(tempTaskBounds);
        } else {
            this.mDeferredTaskBounds.setEmpty();
        }
        if (tempTaskInsetBounds != null) {
            this.mDeferredTaskInsetBounds.set(tempTaskInsetBounds);
        } else {
            this.mDeferredTaskInsetBounds.setEmpty();
        }
        this.mUpdateBoundsDeferredCalled = true;
        return false;
    }

    void setBounds(Rect bounds) {
        Rect rect = this.mBounds = this.mFullscreen ? null : new Rect(bounds);
        if (this.mTaskPositioner != null) {
            this.mTaskPositioner.configure(bounds);
        }
    }

    boolean okToShowLocked(ActivityRecord r) {
        return this.mStackSupervisor.okToShowLocked(r);
    }

    final ActivityRecord topRunningActivityLocked() {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ActivityRecord r = this.mTaskHistory.get(taskNdx).topRunningActivityLocked();
            if (r == null) continue;
            return r;
        }
        return null;
    }

    final ActivityRecord topRunningNonDelayedActivityLocked(ActivityRecord notTop) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            ArrayList<ActivityRecord> activities = task.mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.finishing || r.delayedResume || r == notTop || !this.okToShowLocked(r)) continue;
                return r;
            }
        }
        return null;
    }

    final ActivityRecord topRunningActivityLocked(IBinder token, int taskId) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            if (task.taskId == taskId) continue;
            ArrayList<ActivityRecord> activities = task.mActivities;
            for (int i = activities.size() - 1; i >= 0; --i) {
                ActivityRecord r = activities.get(i);
                if (r.finishing || token == r.appToken || !this.okToShowLocked(r)) continue;
                return r;
            }
        }
        return null;
    }

    final ActivityRecord topActivity() {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.finishing) continue;
                return r;
            }
        }
        return null;
    }

    final TaskRecord topTask() {
        int size = this.mTaskHistory.size();
        if (size > 0) {
            return this.mTaskHistory.get(size - 1);
        }
        return null;
    }

    TaskRecord taskForIdLocked(int id2) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            if (task.taskId != id2) continue;
            return task;
        }
        return null;
    }

    ActivityRecord isInStackLocked(IBinder token) {
        ActivityRecord r = ActivityRecord.forTokenLocked(token);
        return this.isInStackLocked(r);
    }

    ActivityRecord isInStackLocked(ActivityRecord r) {
        if (r == null) {
            return null;
        }
        TaskRecord task = r.task;
        if (task != null && task.stack != null && task.mActivities.contains(r) && this.mTaskHistory.contains(task)) {
            if (task.stack != this) {
                Slog.w("ActivityManager", "Illegal state! task does not point to stack it is in.");
            }
            return r;
        }
        return null;
    }

    final boolean updateLRUListLocked(ActivityRecord r) {
        boolean hadit = this.mLRUActivities.remove(r);
        this.mLRUActivities.add(r);
        return hadit;
    }

    final boolean isHomeStack() {
        return this.mStackId == 0;
    }

    final boolean isDockedStack() {
        return this.mStackId == 3;
    }

    final boolean isPinnedStack() {
        return this.mStackId == 4;
    }

    final boolean isOnHomeDisplay() {
        return this.isAttached() && this.mActivityContainer.mActivityDisplay.mDisplayId == 0;
    }

    void moveToFront(String reason) {
        this.moveToFront(reason, null);
    }

    void moveToFront(String reason, TaskRecord task) {
        if (!this.isAttached()) {
            return;
        }
        this.mStacks.remove(this);
        int addIndex = this.mStacks.size();
        if (addIndex > 0) {
            ActivityStack topStack = this.mStacks.get(addIndex - 1);
            if (ActivityManager.StackId.isAlwaysOnTop(topStack.mStackId) && topStack != this) {
                --addIndex;
            }
        }
        this.mStacks.add(addIndex, this);
        if (this.isOnHomeDisplay()) {
            this.mStackSupervisor.setFocusStackUnchecked(reason, this);
        }
        if (task != null) {
            this.insertTaskAtTop(task, null);
        } else {
            task = this.topTask();
        }
        if (task != null) {
            this.mWindowManager.moveTaskToTop(task.taskId);
        }
    }

    boolean isFocusable() {
        if (ActivityManager.StackId.canReceiveKeys(this.mStackId)) {
            return true;
        }
        ActivityRecord r = this.topRunningActivityLocked();
        return r != null && r.isFocusable();
    }

    final boolean isAttached() {
        return this.mStacks != null;
    }

    void findTaskLocked(ActivityRecord target, ActivityStackSupervisor.FindTaskResult result) {
        Intent intent = target.intent;
        ActivityInfo info = target.info;
        ComponentName cls = intent.getComponent();
        if (info.targetActivity != null) {
            cls = new ComponentName(info.packageName, info.targetActivity);
        }
        int userId = UserHandle.getUserId(info.applicationInfo.uid);
        boolean isDocument = intent != null & intent.isDocument();
        Uri documentData = isDocument ? intent.getData() : null;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            Uri taskDocumentData;
            boolean taskIsDocument;
            ActivityRecord r;
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            if (task.voiceSession != null || task.userId != userId || (r = task.getTopActivity()) == null || r.finishing || r.userId != userId || r.launchMode == 3 || r.mActivityType != target.mActivityType) continue;
            Intent taskIntent = task.intent;
            Intent affinityIntent = task.affinityIntent;
            if (taskIntent != null && taskIntent.isDocument()) {
                taskIsDocument = true;
                taskDocumentData = taskIntent.getData();
            } else if (affinityIntent != null && affinityIntent.isDocument()) {
                taskIsDocument = true;
                taskDocumentData = affinityIntent.getData();
            } else {
                taskIsDocument = false;
                taskDocumentData = null;
            }
            if (taskIntent != null && taskIntent.getComponent() != null && taskIntent.getComponent().compareTo(cls) == 0 && Objects.equals(documentData, taskDocumentData)) {
                result.r = r;
                result.matchedByRootAffinity = false;
                break;
            }
            if (affinityIntent != null && affinityIntent.getComponent() != null && affinityIntent.getComponent().compareTo(cls) == 0 && Objects.equals(documentData, taskDocumentData)) {
                result.r = r;
                result.matchedByRootAffinity = false;
                break;
            }
            if (isDocument || taskIsDocument || result.r != null || !task.canMatchRootAffinity() || !task.rootAffinity.equals(target.taskAffinity)) continue;
            result.r = r;
            result.matchedByRootAffinity = true;
        }
    }

    ActivityRecord findActivityLocked(Intent intent, ActivityInfo info, boolean compareIntentFilters) {
        ComponentName cls = intent.getComponent();
        if (info.targetActivity != null) {
            cls = new ComponentName(info.packageName, info.targetActivity);
        }
        int userId = UserHandle.getUserId(info.applicationInfo.uid);
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            boolean notCurrentUserTask = !this.mStackSupervisor.isCurrentProfileLocked(task.userId);
            ArrayList<ActivityRecord> activities = task.mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (notCurrentUserTask && (r.info.flags & 0x400) == 0 || r.finishing || r.userId != userId || !(compareIntentFilters ? r.intent.filterEquals(intent) : r.intent.getComponent().equals(cls))) continue;
                return r;
            }
        }
        return null;
    }

    final void switchUserLocked(int userId) {
        if (this.mCurrentUser == userId) {
            return;
        }
        this.mCurrentUser = userId;
        int index = this.mTaskHistory.size();
        int i = 0;
        while (i < index) {
            TaskRecord task = this.mTaskHistory.get(i);
            if (this.mStackSupervisor.isCurrentProfileLocked(task.userId) || task.topRunningActivityLocked() != null) {
                this.mTaskHistory.remove(i);
                this.mTaskHistory.add(task);
                --index;
                continue;
            }
            ++i;
        }
    }

    void minimalResumeActivityLocked(ActivityRecord r) {
        r.state = ActivityState.RESUMED;
        this.mResumedActivity = r;
        r.task.touchActiveTime();
        this.mRecentTasks.addLocked(r.task);
        this.completeResumeLocked(r);
        this.mStackSupervisor.checkReadyForSleepLocked();
        this.setLaunchTime(r);
    }

    void addRecentActivityLocked(ActivityRecord r) {
        if (r != null) {
            this.mRecentTasks.addLocked(r.task);
            r.task.touchActiveTime();
        }
    }

    private void startLaunchTraces(String packageName) {
        if (this.mFullyDrawnStartTime != 0L) {
            Trace.asyncTraceEnd(64L, "drawing", 0);
        }
        Trace.asyncTraceBegin(64L, "launching: " + packageName, 0);
        Trace.asyncTraceBegin(64L, "drawing", 0);
    }

    private void stopFullyDrawnTraceIfNeeded() {
        if (this.mFullyDrawnStartTime != 0L && this.mLaunchStartTime == 0L) {
            Trace.asyncTraceEnd(64L, "drawing", 0);
            this.mFullyDrawnStartTime = 0L;
        }
    }

    void setLaunchTime(ActivityRecord r) {
        if (r.displayStartTime == 0L) {
            r.fullyDrawnStartTime = r.displayStartTime = SystemClock.uptimeMillis();
            if (this.mLaunchStartTime == 0L) {
                this.startLaunchTraces(r.packageName);
                this.mLaunchStartTime = this.mFullyDrawnStartTime = r.displayStartTime;
            }
        } else if (this.mLaunchStartTime == 0L) {
            this.startLaunchTraces(r.packageName);
            this.mLaunchStartTime = this.mFullyDrawnStartTime = SystemClock.uptimeMillis();
        }
    }

    void clearLaunchTime(ActivityRecord r) {
        if (this.mStackSupervisor.mWaitingActivityLaunched.isEmpty()) {
            r.fullyDrawnStartTime = 0L;
            r.displayStartTime = 0L;
        } else {
            this.mStackSupervisor.removeTimeoutsForActivityLocked(r);
            this.mStackSupervisor.scheduleIdleTimeoutLocked(r);
        }
    }

    void awakeFromSleepingLocked() {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                activities.get(activityNdx).setSleeping(false);
            }
        }
        if (this.mPausingActivity != null) {
            Slog.d("ActivityManager", "awakeFromSleepingLocked: previously pausing activity didn't pause");
            this.activityPausedLocked(this.mPausingActivity.appToken, true);
        }
    }

    void updateActivityApplicationInfoLocked(ApplicationInfo aInfo) {
        String packageName = aInfo.packageName;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                if (!packageName.equals(((ActivityRecord)activities.get((int)activityNdx)).packageName)) continue;
                ((ActivityRecord)activities.get((int)activityNdx)).info.applicationInfo = aInfo;
            }
        }
    }

    boolean checkReadyForSleepLocked() {
        if (this.mResumedActivity != null) {
            this.startPausingLocked(false, true, null, false);
            return true;
        }
        if (this.mPausingActivity != null) {
            return true;
        }
        if (this.hasVisibleBehindActivity()) {
            ActivityRecord r = this.getVisibleBehindActivity();
            this.mStackSupervisor.mStoppingActivities.add(r);
            return true;
        }
        return false;
    }

    void goToSleep() {
        this.ensureActivitiesVisibleLocked(null, 0, false);
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.state != ActivityState.STOPPING && r.state != ActivityState.STOPPED && r.state != ActivityState.PAUSED && r.state != ActivityState.PAUSING) continue;
                r.setSleeping(true);
            }
        }
    }

    public final Bitmap screenshotActivitiesLocked(ActivityRecord who) {
        if (who.noDisplay) {
            return null;
        }
        if (this.isHomeStack()) {
            return null;
        }
        int w = this.mService.mThumbnailWidth;
        int h = this.mService.mThumbnailHeight;
        float scale = 1.0f;
        if (w > 0) {
            h = -1;
            w = -1;
            scale = this.mService.mFullscreenThumbnailScale;
            return this.mWindowManager.screenshotApplications(who.appToken, 0, w, h, scale);
        }
        Slog.e("ActivityManager", "Invalid thumbnail dimensions: " + w + "x" + h);
        return null;
    }

    final boolean startPausingLocked(boolean userLeaving, boolean uiSleeping, ActivityRecord resuming, boolean dontWait) {
        ActivityRecord prev;
        if (this.mPausingActivity != null) {
            Slog.wtf("ActivityManager", "Going to pause when pause is already pending for " + this.mPausingActivity + " state=" + (Object)((Object)this.mPausingActivity.state));
            if (!this.mService.isSleepingLocked()) {
                this.completePauseLocked(false, resuming);
            }
        }
        if ((prev = this.mResumedActivity) == null) {
            if (resuming == null) {
                Slog.wtf("ActivityManager", "Trying to pause when nothing is resumed");
                this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
            }
            return false;
        }
        if (this.mActivityContainer.mParentActivity == null) {
            this.mStackSupervisor.pauseChildStacks(prev, userLeaving, uiSleeping, resuming, dontWait);
        }
        this.mResumedActivity = null;
        this.mPausingActivity = prev;
        this.mLastPausedActivity = prev;
        this.mLastNoHistoryActivity = (prev.intent.getFlags() & 0x40000000) != 0 || (prev.info.flags & 0x80) != 0 ? prev : null;
        prev.state = ActivityState.PAUSING;
        prev.task.touchActiveTime();
        this.clearLaunchTime(prev);
        ActivityRecord next = this.mStackSupervisor.topRunningActivityLocked();
        if (this.mService.mHasRecents && (next == null || next.noDisplay || next.task != prev.task || uiSleeping)) {
            prev.mUpdateTaskThumbnailWhenHidden = true;
        }
        this.stopFullyDrawnTraceIfNeeded();
        this.mService.updateCpuStats();
        if (prev.app != null && prev.app.thread != null) {
            try {
                EventLog.writeEvent(30013, prev.userId, System.identityHashCode(prev), prev.shortComponentName);
                this.mService.updateUsageStats(prev, false);
                prev.app.thread.schedulePauseActivity(prev.appToken, prev.finishing, userLeaving, prev.configChangeFlags, dontWait);
            }
            catch (Exception e) {
                Slog.w("ActivityManager", "Exception thrown during pause", e);
                this.mPausingActivity = null;
                this.mLastPausedActivity = null;
                this.mLastNoHistoryActivity = null;
            }
        } else {
            this.mPausingActivity = null;
            this.mLastPausedActivity = null;
            this.mLastNoHistoryActivity = null;
        }
        if (!uiSleeping && !this.mService.isSleepingOrShuttingDownLocked()) {
            this.mStackSupervisor.acquireLaunchWakelock();
        }
        if (this.mPausingActivity != null) {
            if (!uiSleeping) {
                prev.pauseKeyDispatchingLocked();
            }
            if (dontWait) {
                this.completePauseLocked(false, resuming);
                return false;
            }
            Message msg = this.mHandler.obtainMessage(101);
            msg.obj = prev;
            prev.pauseTime = SystemClock.uptimeMillis();
            this.mHandler.sendMessageDelayed(msg, 500L);
            return true;
        }
        if (resuming == null) {
            this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
        }
        return false;
    }

    final void activityPausedLocked(IBinder token, boolean timeout) {
        ActivityRecord r = this.isInStackLocked(token);
        if (r != null) {
            this.mHandler.removeMessages(101, r);
            if (this.mPausingActivity == r) {
                this.completePauseLocked(true, null);
                return;
            }
            EventLog.writeEvent(30012, r.userId, System.identityHashCode(r), r.shortComponentName, this.mPausingActivity != null ? this.mPausingActivity.shortComponentName : "(none)");
            if (r.state == ActivityState.PAUSING) {
                r.state = ActivityState.PAUSED;
                if (r.finishing) {
                    this.finishCurrentActivityLocked(r, 2, false);
                }
            }
        }
        this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0, false);
    }

    final void activityResumedLocked(IBinder token) {
        ActivityRecord r = ActivityRecord.forTokenLocked(token);
        r.icicle = null;
        r.haveState = false;
    }

    final void activityStoppedLocked(ActivityRecord r, Bundle icicle, PersistableBundle persistentState, CharSequence description) {
        if (r.state != ActivityState.STOPPING) {
            Slog.i("ActivityManager", "Activity reported stop, but no longer stopping: " + r);
            this.mHandler.removeMessages(104, r);
            return;
        }
        if (persistentState != null) {
            r.persistentState = persistentState;
            this.mService.notifyTaskPersisterLocked(r.task, false);
        }
        if (icicle != null) {
            r.icicle = icicle;
            r.haveState = true;
            r.launchCount = 0;
            r.updateThumbnailLocked(null, description);
        }
        if (!r.stopped) {
            this.mHandler.removeMessages(104, r);
            r.stopped = true;
            r.state = ActivityState.STOPPED;
            this.mWindowManager.notifyAppStopped(r.appToken);
            if (this.getVisibleBehindActivity() == r) {
                this.mStackSupervisor.requestVisibleBehindLocked(r, false);
            }
            if (r.finishing) {
                r.clearOptionsLocked();
            } else if (r.deferRelaunchUntilPaused) {
                this.destroyActivityLocked(r, true, "stop-config");
                this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
            } else {
                this.mStackSupervisor.updatePreviousProcessLocked(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completePauseLocked(boolean resumeNext, ActivityRecord resuming) {
        ActivityRecord prev = this.mPausingActivity;
        if (prev != null) {
            boolean wasStopping = prev.state == ActivityState.STOPPING;
            prev.state = ActivityState.PAUSED;
            if (prev.finishing) {
                prev = this.finishCurrentActivityLocked(prev, 2, false);
            } else if (prev.app != null) {
                if (this.mStackSupervisor.mWaitingVisibleActivities.remove(prev)) {
                    // empty if block
                }
                if (prev.deferRelaunchUntilPaused) {
                    this.relaunchActivityLocked(prev, prev.configChangeFlags, false, prev.preserveWindowOnDeferredRelaunch);
                } else if (wasStopping) {
                    prev.state = ActivityState.STOPPING;
                } else if (!prev.visible && !this.hasVisibleBehindActivity() || this.mService.isSleepingOrShuttingDownLocked()) {
                    this.addToStopping(prev, true);
                }
            } else {
                prev = null;
            }
            prev.stopFreezingScreenLocked(true);
            this.mPausingActivity = null;
        }
        if (resumeNext) {
            ActivityStack topStack = this.mStackSupervisor.getFocusedStack();
            if (!this.mService.isSleepingOrShuttingDownLocked()) {
                this.mStackSupervisor.resumeFocusedStackTopActivityLocked(topStack, prev, null);
            } else {
                this.mStackSupervisor.checkReadyForSleepLocked();
                ActivityRecord top = topStack.topRunningActivityLocked();
                if (top == null || prev != null && top != prev) {
                    this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
                }
            }
        }
        if (prev != null) {
            long diff;
            prev.resumeKeyDispatchingLocked();
            if (prev.app != null && prev.cpuTimeAtResume > 0L && this.mService.mBatteryStatsService.isOnBattery() && (diff = this.mService.mProcessCpuTracker.getCpuTimeForPid(prev.app.pid) - prev.cpuTimeAtResume) > 0L) {
                BatteryStatsImpl bsi;
                BatteryStatsImpl batteryStatsImpl = bsi = this.mService.mBatteryStatsService.getActiveStatistics();
                synchronized (batteryStatsImpl) {
                    BatteryStatsImpl.Uid.Proc ps = bsi.getProcessStatsLocked(prev.info.applicationInfo.uid, prev.info.packageName);
                    if (ps != null) {
                        ps.addForegroundTimeLocked(diff);
                    }
                }
            }
            prev.cpuTimeAtResume = 0L;
        }
        if (this.mStackSupervisor.mAppVisibilitiesChangedSinceLastPause || this.mService.mStackSupervisor.getStack(4) != null) {
            this.mService.notifyTaskStackChangedLocked();
            this.mStackSupervisor.mAppVisibilitiesChangedSinceLastPause = false;
        }
        this.mStackSupervisor.ensureActivitiesVisibleLocked(resuming, 0, false);
    }

    private void addToStopping(ActivityRecord r, boolean immediate) {
        boolean forceIdle;
        if (!this.mStackSupervisor.mStoppingActivities.contains(r)) {
            this.mStackSupervisor.mStoppingActivities.add(r);
        }
        boolean bl = forceIdle = this.mStackSupervisor.mStoppingActivities.size() > 3 || r.frontOfTask && this.mTaskHistory.size() <= 1;
        if (immediate || forceIdle) {
            this.mStackSupervisor.scheduleIdleLocked();
        } else {
            this.mStackSupervisor.checkReadyForSleepLocked();
        }
    }

    private void completeResumeLocked(ActivityRecord next) {
        ProcessRecord app;
        next.visible = true;
        next.idle = false;
        next.results = null;
        next.newIntents = null;
        next.stopped = false;
        if (next.isHomeActivity() && (app = next.task.mActivities.get((int)0).app) != null && app != this.mService.mHomeProcess) {
            this.mService.mHomeProcess = app;
        }
        if (next.nowVisible) {
            this.mStackSupervisor.reportActivityVisibleLocked(next);
            this.mStackSupervisor.notifyActivityDrawnForKeyguard();
        }
        this.mStackSupervisor.scheduleIdleTimeoutLocked(next);
        this.mStackSupervisor.reportResumedActivityLocked(next);
        next.resumeKeyDispatchingLocked();
        this.mNoAnimActivities.clear();
        next.cpuTimeAtResume = next.app != null ? this.mService.mProcessCpuTracker.getCpuTimeForPid(next.app.pid) : 0L;
        next.returningOptions = null;
        if (this.getVisibleBehindActivity() == next) {
            this.setVisibleBehindActivity(null);
        }
    }

    private void setVisible(ActivityRecord r, boolean visible) {
        r.visible = visible;
        if (!visible && r.mUpdateTaskThumbnailWhenHidden) {
            r.updateThumbnailLocked(r.task.stack.screenshotActivitiesLocked(r), null);
            r.mUpdateTaskThumbnailWhenHidden = false;
        }
        this.mWindowManager.setAppVisibility(r.appToken, visible);
        ArrayList<ActivityStackSupervisor.ActivityContainer> containers = r.mChildContainers;
        for (int containerNdx = containers.size() - 1; containerNdx >= 0; --containerNdx) {
            ActivityStackSupervisor.ActivityContainer container = containers.get(containerNdx);
            container.setVisible(visible);
        }
        this.mStackSupervisor.mAppVisibilitiesChangedSinceLastPause = true;
    }

    ActivityRecord findNextTranslucentActivity(ActivityRecord r) {
        TaskRecord task = r.task;
        if (task == null) {
            return null;
        }
        ActivityStack stack = task.stack;
        if (stack == null) {
            return null;
        }
        ArrayList<TaskRecord> tasks = stack.mTaskHistory;
        int taskNdx = tasks.indexOf(task);
        ArrayList<ActivityRecord> activities = task.mActivities;
        int activityNdx = activities.indexOf(r) + 1;
        int numStacks = this.mStacks.size();
        for (int stackNdx = this.mStacks.indexOf(stack); stackNdx < numStacks; ++stackNdx) {
            ActivityStack historyStack = this.mStacks.get(stackNdx);
            tasks = historyStack.mTaskHistory;
            int numTasks = tasks.size();
            while (taskNdx < numTasks) {
                TaskRecord currentTask = tasks.get(taskNdx);
                activities = currentTask.mActivities;
                int numActivities = activities.size();
                while (activityNdx < numActivities) {
                    ActivityRecord activity = activities.get(activityNdx);
                    if (!activity.finishing) {
                        return historyStack.mFullscreen && currentTask.mFullscreen && activity.fullscreen ? null : activity;
                    }
                    ++activityNdx;
                }
                activityNdx = 0;
                ++taskNdx;
            }
            taskNdx = 0;
        }
        return null;
    }

    ActivityStack getNextFocusableStackLocked() {
        ArrayList<ActivityStack> stacks = this.mStacks;
        ActivityRecord parent = this.mActivityContainer.mParentActivity;
        if (parent != null) {
            stacks = parent.task.stack.mStacks;
        }
        if (stacks != null) {
            for (int i = stacks.size() - 1; i >= 0; --i) {
                ActivityStack stack = stacks.get(i);
                if (stack == this || !stack.isFocusable() || stack.getStackVisibilityLocked(null) == 0) continue;
                return stack;
            }
        }
        return null;
    }

    private boolean hasFullscreenTask() {
        for (int i = this.mTaskHistory.size() - 1; i >= 0; --i) {
            TaskRecord task = this.mTaskHistory.get(i);
            if (!task.mFullscreen) continue;
            return true;
        }
        return false;
    }

    private boolean isStackTranslucent(ActivityRecord starting, int stackBehindId) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            ArrayList<ActivityRecord> activities = task.mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.finishing || !r.visible && r != starting) continue;
                if (r.fullscreen) {
                    return false;
                }
                if (this.isHomeStack() || !r.frontOfTask || !task.isOverHomeStack() || stackBehindId == 0) continue;
                return false;
            }
        }
        return true;
    }

    int getStackVisibilityLocked(ActivityRecord starting) {
        int stackBehindFocusedId;
        int stackBehindFocusedIndex;
        boolean isLockscreenShown;
        if (!this.isAttached()) {
            return 0;
        }
        if (this.mStackSupervisor.isFrontStack(this) || this.mStackSupervisor.isFocusedStack(this)) {
            return 1;
        }
        int stackIndex = this.mStacks.indexOf(this);
        if (stackIndex == this.mStacks.size() - 1) {
            Slog.wtf("ActivityManager", "Stack=" + this + " isn't front stack but is at the top of the stack list");
            return 0;
        }
        boolean bl = isLockscreenShown = this.mService.mLockScreenShown == 2;
        if (isLockscreenShown && !ActivityManager.StackId.isAllowedOverLockscreen(this.mStackId)) {
            return 0;
        }
        ActivityStack focusedStack = this.mStackSupervisor.getFocusedStack();
        int focusedStackId = focusedStack.mStackId;
        if (this.mStackId == 1 && this.hasVisibleBehindActivity() && focusedStackId == 0 && !focusedStack.topActivity().fullscreen) {
            return 2;
        }
        if (this.mStackId == 3) {
            ActivityRecord r = focusedStack.topRunningActivityLocked();
            TaskRecord task = r != null ? r.task : null;
            return task == null || task.canGoInDockedStack() || task.isHomeTask() ? 1 : 0;
        }
        for (stackBehindFocusedIndex = this.mStacks.indexOf(focusedStack) - 1; stackBehindFocusedIndex >= 0 && this.mStacks.get(stackBehindFocusedIndex).topRunningActivityLocked() == null; --stackBehindFocusedIndex) {
        }
        if ((focusedStackId == 3 || focusedStackId == 4) && stackIndex == stackBehindFocusedIndex) {
            return 1;
        }
        int n = stackBehindFocusedId = stackBehindFocusedIndex >= 0 ? this.mStacks.get((int)stackBehindFocusedIndex).mStackId : -1;
        if (focusedStackId == 1 && focusedStack.isStackTranslucent(starting, stackBehindFocusedId)) {
            if (stackIndex == stackBehindFocusedIndex) {
                return 1;
            }
            if (stackBehindFocusedIndex >= 0 && (stackBehindFocusedId == 3 || stackBehindFocusedId == 4) && stackIndex == stackBehindFocusedIndex - 1) {
                return 1;
            }
        }
        if (ActivityManager.StackId.isStaticStack(this.mStackId)) {
            return 0;
        }
        for (int i = stackIndex + 1; i < this.mStacks.size(); ++i) {
            ActivityStack stack = this.mStacks.get(i);
            if (!stack.mFullscreen && !stack.hasFullscreenTask()) continue;
            if (!ActivityManager.StackId.isDynamicStacksVisibleBehindAllowed(stack.mStackId)) {
                return 0;
            }
            if (stack.isStackTranslucent(starting, -1)) continue;
            return 0;
        }
        return 1;
    }

    final int rankTaskLayers(int baseLayer) {
        int layer = 0;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            ActivityRecord r = task.topRunningActivityLocked();
            task.mLayerRank = r == null || r.finishing || !r.visible ? -1 : baseLayer + layer++;
        }
        return layer;
    }

    final void ensureActivitiesVisibleLocked(ActivityRecord starting, int configChanges, boolean preserveWindows) {
        ActivityRecord top = this.topRunningActivityLocked();
        if (top != null) {
            this.checkTranslucentActivityWaiting(top);
        }
        boolean aboveTop = top != null;
        int stackVisibility = this.getStackVisibilityLocked(starting);
        boolean stackInvisible = stackVisibility != 1;
        boolean stackVisibleBehind = stackVisibility == 2;
        boolean behindFullscreenActivity = stackInvisible;
        boolean resumeNextActivity = this.mStackSupervisor.isFocusedStack(this) && this.isInStackLocked(starting) == null;
        boolean behindTranslucentActivity = false;
        ActivityRecord visibleBehind = this.getVisibleBehindActivity();
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            ArrayList<ActivityRecord> activities = task.mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                boolean isTop;
                ActivityRecord r = activities.get(activityNdx);
                if (r.finishing) {
                    if (!r.mUpdateTaskThumbnailWhenHidden) continue;
                    r.updateThumbnailLocked(this.screenshotActivitiesLocked(r), null);
                    r.mUpdateTaskThumbnailWhenHidden = false;
                    continue;
                }
                boolean bl = isTop = r == top;
                if (aboveTop && !isTop) continue;
                aboveTop = false;
                if (this.shouldBeVisible(r, behindTranslucentActivity, stackVisibleBehind, visibleBehind, behindFullscreenActivity)) {
                    if (r != starting) {
                        this.ensureActivityConfigurationLocked(r, 0, preserveWindows);
                    }
                    if (r.app == null || r.app.thread == null) {
                        if (this.makeVisibleAndRestartIfNeeded(starting, configChanges, isTop, resumeNextActivity, r)) {
                            if (activityNdx >= activities.size()) {
                                activityNdx = activities.size() - 1;
                            } else {
                                resumeNextActivity = false;
                            }
                        }
                    } else if (r.visible) {
                        if (this.handleAlreadyVisible(r)) {
                            resumeNextActivity = false;
                        }
                    } else {
                        this.makeVisibleIfNeeded(starting, r);
                    }
                    configChanges |= r.configChangeFlags;
                    if (!(behindFullscreenActivity = this.updateBehindFullscreen(stackInvisible, behindFullscreenActivity, task, r)) || r.fullscreen) continue;
                    behindTranslucentActivity = true;
                    continue;
                }
                this.makeInvisible(r, visibleBehind);
            }
            if (this.mStackId == 2) {
                behindFullscreenActivity = stackVisibility == 0;
                continue;
            }
            if (this.mStackId != 0) continue;
            if (task.isHomeTask()) {
                behindFullscreenActivity = true;
                continue;
            }
            if (!task.isRecentsTask() || task.getTaskToReturnTo() != 0) continue;
            behindFullscreenActivity = true;
        }
        if (this.mTranslucentActivityWaiting != null && this.mUndrawnActivitiesBelowTopTranslucent.isEmpty()) {
            this.notifyActivityDrawnLocked(null);
        }
    }

    private boolean shouldBeVisible(ActivityRecord r, boolean behindTranslucentActivity, boolean stackVisibleBehind, ActivityRecord visibleBehind, boolean behindFullscreenActivity) {
        boolean isVisible;
        if (!this.okToShowLocked(r)) {
            return false;
        }
        boolean activityVisibleBehind = (behindTranslucentActivity || stackVisibleBehind) && visibleBehind == r;
        boolean bl = isVisible = !behindFullscreenActivity || r.mLaunchTaskBehind || activityVisibleBehind;
        if (this.mService.mSupportsLeanbackOnly && isVisible && r.isRecentsActivity()) {
            isVisible = this.mStackSupervisor.getStack(3) != null || this.mStackSupervisor.isFocusedStack(this);
        }
        return isVisible;
    }

    private void checkTranslucentActivityWaiting(ActivityRecord top) {
        if (this.mTranslucentActivityWaiting != top) {
            this.mUndrawnActivitiesBelowTopTranslucent.clear();
            if (this.mTranslucentActivityWaiting != null) {
                this.notifyActivityDrawnLocked(null);
                this.mTranslucentActivityWaiting = null;
            }
            this.mHandler.removeMessages(106);
        }
    }

    private boolean makeVisibleAndRestartIfNeeded(ActivityRecord starting, int configChanges, boolean isTop, boolean andResume, ActivityRecord r) {
        if (isTop || !r.visible) {
            if (r != starting) {
                r.startFreezingScreenLocked(r.app, configChanges);
            }
            if (!r.visible || r.mLaunchTaskBehind) {
                this.setVisible(r, true);
            }
            if (r != starting) {
                this.mStackSupervisor.startSpecificActivityLocked(r, andResume, false);
                return true;
            }
        }
        return false;
    }

    private void makeInvisible(ActivityRecord r, ActivityRecord visibleBehind) {
        if (!r.visible) {
            return;
        }
        try {
            this.setVisible(r, false);
            switch (r.state) {
                case STOPPING: 
                case STOPPED: {
                    if (r.app == null || r.app.thread == null) break;
                    r.app.thread.scheduleWindowVisibility(r.appToken, false);
                    break;
                }
                case INITIALIZING: 
                case RESUMED: 
                case PAUSING: 
                case PAUSED: {
                    if (visibleBehind == r) {
                        this.releaseBackgroundResources(r);
                        break;
                    }
                    this.addToStopping(r, true);
                    break;
                }
            }
        }
        catch (Exception e) {
            Slog.w("ActivityManager", "Exception thrown making hidden: " + r.intent.getComponent(), e);
        }
    }

    private boolean updateBehindFullscreen(boolean stackInvisible, boolean behindFullscreenActivity, TaskRecord task, ActivityRecord r) {
        if (r.fullscreen) {
            behindFullscreenActivity = true;
        } else if (!this.isHomeStack() && r.frontOfTask && task.isOverHomeStack()) {
            behindFullscreenActivity = true;
        }
        return behindFullscreenActivity;
    }

    private void makeVisibleIfNeeded(ActivityRecord starting, ActivityRecord r) {
        if (r.state == ActivityState.RESUMED || r == starting) {
            return;
        }
        try {
            if (this.mTranslucentActivityWaiting != null) {
                r.updateOptionsLocked(r.returningOptions);
                this.mUndrawnActivitiesBelowTopTranslucent.add(r);
            }
            this.setVisible(r, true);
            r.sleeping = false;
            r.app.pendingUiClean = true;
            r.app.thread.scheduleWindowVisibility(r.appToken, true);
            this.mStackSupervisor.mStoppingActivities.remove(r);
            this.mStackSupervisor.mGoingToSleepActivities.remove(r);
        }
        catch (Exception e) {
            Slog.w("ActivityManager", "Exception thrown making visibile: " + r.intent.getComponent(), e);
        }
        this.handleAlreadyVisible(r);
    }

    private boolean handleAlreadyVisible(ActivityRecord r) {
        r.stopFreezingScreenLocked(false);
        try {
            if (r.returningOptions != null) {
                r.app.thread.scheduleOnNewActivityOptions(r.appToken, r.returningOptions);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return r.state == ActivityState.RESUMED;
    }

    void convertActivityToTranslucent(ActivityRecord r) {
        this.mTranslucentActivityWaiting = r;
        this.mUndrawnActivitiesBelowTopTranslucent.clear();
        this.mHandler.sendEmptyMessageDelayed(106, 2000L);
    }

    void clearOtherAppTimeTrackers(AppTimeTracker except) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            ArrayList<ActivityRecord> activities = task.mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.appTimeTracker == except) continue;
                r.appTimeTracker = null;
            }
        }
    }

    void notifyActivityDrawnLocked(ActivityRecord r) {
        this.mActivityContainer.setDrawn();
        if (r == null || this.mUndrawnActivitiesBelowTopTranslucent.remove(r) && this.mUndrawnActivitiesBelowTopTranslucent.isEmpty()) {
            ActivityRecord waitingActivity = this.mTranslucentActivityWaiting;
            this.mTranslucentActivityWaiting = null;
            this.mUndrawnActivitiesBelowTopTranslucent.clear();
            this.mHandler.removeMessages(106);
            if (waitingActivity != null) {
                this.mWindowManager.setWindowOpaque(waitingActivity.appToken, false);
                if (waitingActivity.app != null && waitingActivity.app.thread != null) {
                    try {
                        waitingActivity.app.thread.scheduleTranslucentConversionComplete(waitingActivity.appToken, r != null);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    void cancelInitializingActivities() {
        ActivityRecord topActivity = this.topRunningActivityLocked();
        boolean aboveTop = true;
        boolean behindFullscreenActivity = false;
        if (this.getStackVisibilityLocked(null) == 0) {
            aboveTop = false;
            behindFullscreenActivity = true;
        }
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (aboveTop) {
                    if (r == topActivity) {
                        aboveTop = false;
                    }
                    behindFullscreenActivity |= r.fullscreen;
                    continue;
                }
                if (r.state == ActivityState.INITIALIZING && r.mStartingWindowState == 1 && behindFullscreenActivity) {
                    r.mStartingWindowState = 2;
                    this.mWindowManager.removeAppStartingWindow(r.appToken);
                }
                behindFullscreenActivity |= r.fullscreen;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean resumeTopActivityUncheckedLocked(ActivityRecord prev, ActivityOptions options) {
        if (this.mStackSupervisor.inResumeTopActivity) {
            return false;
        }
        boolean result = false;
        try {
            this.mStackSupervisor.inResumeTopActivity = true;
            if (this.mService.mLockScreenShown == 1) {
                this.mService.mLockScreenShown = 0;
                this.mService.updateSleepIfNeededLocked();
            }
            result = this.resumeTopActivityInnerLocked(prev, options);
        }
        finally {
            this.mStackSupervisor.inResumeTopActivity = false;
        }
        return result;
    }

    private boolean resumeTopActivityInnerLocked(ActivityRecord prev, ActivityOptions options) {
        TaskRecord prevTask;
        if (!this.mService.mBooting && !this.mService.mBooted) {
            return false;
        }
        ActivityRecord parent = this.mActivityContainer.mParentActivity;
        if (parent != null && parent.state != ActivityState.RESUMED || !this.mActivityContainer.isAttachedLocked()) {
            return false;
        }
        this.mStackSupervisor.cancelInitializingActivities();
        ActivityRecord next = this.topRunningActivityLocked();
        boolean userLeaving = this.mStackSupervisor.mUserLeaving;
        this.mStackSupervisor.mUserLeaving = false;
        TaskRecord taskRecord = prevTask = prev != null ? prev.task : null;
        if (next == null) {
            int returnTaskType;
            String reason = "noMoreActivities";
            int n = returnTaskType = prevTask == null || !prevTask.isOverHomeStack() ? 1 : prevTask.getTaskToReturnTo();
            if (!this.mFullscreen && this.adjustFocusToNextFocusableStackLocked(returnTaskType, "noMoreActivities")) {
                return this.mStackSupervisor.resumeFocusedStackTopActivityLocked(this.mStackSupervisor.getFocusedStack(), prev, null);
            }
            ActivityOptions.abort(options);
            return this.isOnHomeDisplay() && this.mStackSupervisor.resumeHomeStackTask(returnTaskType, prev, "noMoreActivities");
        }
        next.delayedResume = false;
        if (this.mResumedActivity == next && next.state == ActivityState.RESUMED && this.mStackSupervisor.allResumedActivitiesComplete()) {
            this.mWindowManager.executeAppTransition();
            this.mNoAnimActivities.clear();
            ActivityOptions.abort(options);
            return false;
        }
        TaskRecord nextTask = next.task;
        if (prevTask != null && prevTask.stack == this && prevTask.isOverHomeStack() && prev.finishing && prev.frontOfTask) {
            if (prevTask == nextTask) {
                prevTask.setFrontOfTask();
            } else if (prevTask != this.topTask()) {
                int taskNdx = this.mTaskHistory.indexOf(prevTask) + 1;
                this.mTaskHistory.get(taskNdx).setTaskToReturnTo(1);
            } else {
                if (!this.isOnHomeDisplay()) {
                    return false;
                }
                if (!this.isHomeStack()) {
                    int returnTaskType = prevTask == null || !prevTask.isOverHomeStack() ? 1 : prevTask.getTaskToReturnTo();
                    return this.isOnHomeDisplay() && this.mStackSupervisor.resumeHomeStackTask(returnTaskType, prev, "prevFinished");
                }
            }
        }
        if (this.mService.isSleepingOrShuttingDownLocked() && this.mLastPausedActivity == next && this.mStackSupervisor.allPausedActivitiesComplete()) {
            this.mWindowManager.executeAppTransition();
            this.mNoAnimActivities.clear();
            ActivityOptions.abort(options);
            return false;
        }
        if (!this.mService.mUserController.hasStartedUserState(next.userId)) {
            Slog.w("ActivityManager", "Skipping resume of top activity " + next + ": user " + next.userId + " is stopped");
            return false;
        }
        this.mStackSupervisor.mStoppingActivities.remove(next);
        this.mStackSupervisor.mGoingToSleepActivities.remove(next);
        next.sleeping = false;
        this.mStackSupervisor.mWaitingVisibleActivities.remove(next);
        if (!this.mStackSupervisor.allPausedActivitiesComplete()) {
            return false;
        }
        this.mStackSupervisor.setLaunchSource(next.info.applicationInfo.uid);
        boolean dontWaitForPause = (next.info.flags & 0x4000) != 0;
        boolean pausing = this.mStackSupervisor.pauseBackStacks(userLeaving, next, dontWaitForPause);
        if (this.mResumedActivity != null) {
            pausing |= this.startPausingLocked(userLeaving, false, next, dontWaitForPause);
        }
        if (pausing) {
            if (next.app != null && next.app.thread != null) {
                this.mService.updateLruProcessLocked(next.app, true, null);
            }
            return true;
        }
        if (this.mResumedActivity == next && next.state == ActivityState.RESUMED && this.mStackSupervisor.allResumedActivitiesComplete()) {
            this.mWindowManager.executeAppTransition();
            this.mNoAnimActivities.clear();
            ActivityOptions.abort(options);
            return true;
        }
        if (this.mService.isSleepingLocked() && this.mLastNoHistoryActivity != null && !this.mLastNoHistoryActivity.finishing) {
            this.requestFinishActivityLocked(this.mLastNoHistoryActivity.appToken, 0, null, "resume-no-history", false);
            this.mLastNoHistoryActivity = null;
        }
        if (prev != null && prev != next) {
            if (!this.mStackSupervisor.mWaitingVisibleActivities.contains(prev) && next != null && !next.nowVisible) {
                this.mStackSupervisor.mWaitingVisibleActivities.add(prev);
            } else if (prev.finishing) {
                this.mWindowManager.setAppVisibility(prev.appToken, false);
            }
        }
        try {
            AppGlobals.getPackageManager().setPackageStoppedState(next.packageName, false, next.userId);
        }
        catch (RemoteException remoteException) {
        }
        catch (IllegalArgumentException e) {
            Slog.w("ActivityManager", "Failed trying to unstop package " + next.packageName + ": " + e);
        }
        boolean anim2 = true;
        if (prev != null) {
            if (prev.finishing) {
                if (this.mNoAnimActivities.contains(prev)) {
                    anim2 = false;
                    this.mWindowManager.prepareAppTransition(0, false);
                } else {
                    this.mWindowManager.prepareAppTransition(prev.task == next.task ? 7 : 9, false);
                }
                this.mWindowManager.setAppVisibility(prev.appToken, false);
            } else if (this.mNoAnimActivities.contains(next)) {
                anim2 = false;
                this.mWindowManager.prepareAppTransition(0, false);
            } else {
                this.mWindowManager.prepareAppTransition(prev.task == next.task ? 6 : (next.mLaunchTaskBehind ? 16 : 8), false);
            }
        } else if (this.mNoAnimActivities.contains(next)) {
            anim2 = false;
            this.mWindowManager.prepareAppTransition(0, false);
        } else {
            this.mWindowManager.prepareAppTransition(6, false);
        }
        Bundle resumeAnimOptions = null;
        if (anim2) {
            ActivityOptions opts = next.getOptionsForTargetActivityLocked();
            if (opts != null) {
                resumeAnimOptions = opts.toBundle();
            }
            next.applyOptionsLocked();
        } else {
            next.clearOptionsLocked();
        }
        ActivityStack lastStack = this.mStackSupervisor.getLastStack();
        if (next.app != null && next.app.thread != null) {
            boolean lastActivityTranslucent;
            boolean bl = lastActivityTranslucent = lastStack != null && (!lastStack.mFullscreen || lastStack.mLastPausedActivity != null && !lastStack.mLastPausedActivity.fullscreen);
            if (!next.visible || next.stopped || lastActivityTranslucent) {
                this.mWindowManager.setAppVisibility(next.appToken, true);
            }
            next.startLaunchTickingLocked();
            ActivityRecord lastResumedActivity = lastStack == null ? null : lastStack.mResumedActivity;
            ActivityState lastState = next.state;
            this.mService.updateCpuStats();
            next.state = ActivityState.RESUMED;
            this.mResumedActivity = next;
            next.task.touchActiveTime();
            this.mRecentTasks.addLocked(next.task);
            this.mService.updateLruProcessLocked(next.app, true, null);
            this.updateLRUListLocked(next);
            this.mService.updateOomAdjLocked();
            boolean notUpdated = true;
            if (this.mStackSupervisor.isFocusedStack(this)) {
                Configuration config = this.mWindowManager.updateOrientationFromAppTokens(this.mService.mConfiguration, next.mayFreezeScreenLocked(next.app) ? next.appToken : null);
                if (config != null) {
                    next.frozenBeforeDestroy = true;
                }
                boolean bl2 = notUpdated = !this.mService.updateConfigurationLocked(config, next, false);
            }
            if (notUpdated) {
                ActivityRecord nextNext = this.topRunningActivityLocked();
                if (nextNext != next) {
                    this.mStackSupervisor.scheduleResumeTopActivities();
                }
                if (this.mStackSupervisor.reportResumedActivityLocked(next)) {
                    this.mNoAnimActivities.clear();
                    return true;
                }
                return false;
            }
            try {
                ArrayList<ResultInfo> a = next.results;
                if (a != null) {
                    int N = a.size();
                    if (!next.finishing && N > 0) {
                        next.app.thread.scheduleSendResult(next.appToken, a);
                    }
                }
                boolean allowSavedSurface = true;
                if (next.newIntents != null) {
                    for (int i = next.newIntents.size() - 1; i >= 0; --i) {
                        Intent intent = next.newIntents.get(i);
                        if (intent == null || ActivityRecord.isMainIntent(intent)) continue;
                        allowSavedSurface = false;
                        break;
                    }
                    next.app.thread.scheduleNewIntent(next.newIntents, next.appToken);
                }
                this.mWindowManager.notifyAppResumed(next.appToken, next.stopped, allowSavedSurface);
                EventLog.writeEvent(30007, next.userId, System.identityHashCode(next), next.task.taskId, next.shortComponentName);
                next.sleeping = false;
                this.mService.showUnsupportedZoomDialogIfNeededLocked(next);
                this.mService.showAskCompatModeDialogLocked(next);
                next.app.pendingUiClean = true;
                next.app.forceProcessStateUpTo(this.mService.mTopProcessState);
                next.clearOptionsLocked();
                next.app.thread.scheduleResumeActivity(next.appToken, next.app.repProcState, this.mService.isNextTransitionForward(), resumeAnimOptions);
                this.mStackSupervisor.checkReadyForSleepLocked();
            }
            catch (Exception e) {
                next.state = lastState;
                if (lastStack != null) {
                    lastStack.mResumedActivity = lastResumedActivity;
                }
                Slog.i("ActivityManager", "Restarting because process died: " + next);
                if (!next.hasBeenLaunched) {
                    next.hasBeenLaunched = true;
                } else if (lastStack != null && this.mStackSupervisor.isFrontStack(lastStack)) {
                    next.showStartingWindow(null, true);
                }
                this.mStackSupervisor.startSpecificActivityLocked(next, true, false);
                return true;
            }
            try {
                this.completeResumeLocked(next);
            }
            catch (Exception e) {
                Slog.w("ActivityManager", "Exception thrown during resume of " + next, e);
                this.requestFinishActivityLocked(next.appToken, 0, null, "resume-exception", true);
                return true;
            }
        }
        if (!next.hasBeenLaunched) {
            next.hasBeenLaunched = true;
        } else {
            next.showStartingWindow(null, true);
        }
        this.mStackSupervisor.startSpecificActivityLocked(next, true, true);
        return true;
    }

    private TaskRecord getNextTask(TaskRecord targetTask) {
        int index = this.mTaskHistory.indexOf(targetTask);
        if (index >= 0) {
            int numTasks = this.mTaskHistory.size();
            for (int i = index + 1; i < numTasks; ++i) {
                TaskRecord task = this.mTaskHistory.get(i);
                if (task.userId != targetTask.userId) continue;
                return task;
            }
        }
        return null;
    }

    private void insertTaskAtPosition(TaskRecord task, int position) {
        int maxPosition;
        if (position >= this.mTaskHistory.size()) {
            this.insertTaskAtTop(task, null);
            return;
        }
        if (!this.mStackSupervisor.isCurrentProfileLocked(task.userId) && task.topRunningActivityLocked() == null) {
            for (maxPosition = this.mTaskHistory.size(); maxPosition > 0; --maxPosition) {
                TaskRecord tmpTask = this.mTaskHistory.get(maxPosition - 1);
                if (!this.mStackSupervisor.isCurrentProfileLocked(tmpTask.userId) || tmpTask.topRunningActivityLocked() == null) break;
            }
        }
        position = Math.min(position, maxPosition);
        this.mTaskHistory.remove(task);
        this.mTaskHistory.add(position, task);
        this.updateTaskMovement(task, true);
    }

    private void insertTaskAtTop(TaskRecord task, ActivityRecord newActivity) {
        boolean notShownWhenLocked;
        boolean isLastTaskOverHome = false;
        if (task.isOverHomeStack()) {
            TaskRecord nextTask = this.getNextTask(task);
            if (nextTask != null) {
                nextTask.setTaskToReturnTo(task.getTaskToReturnTo());
            } else {
                isLastTaskOverHome = true;
            }
        }
        if (this.isOnHomeDisplay()) {
            ActivityStack lastStack = this.mStackSupervisor.getLastStack();
            boolean fromHome = lastStack.isHomeStack();
            if (!this.isHomeStack() && (fromHome || this.topTask() != task)) {
                int returnToType;
                int n = returnToType = isLastTaskOverHome ? task.getTaskToReturnTo() : 0;
                if (fromHome && ActivityManager.StackId.allowTopTaskToReturnHome(this.mStackId)) {
                    returnToType = lastStack.topTask() == null ? 1 : lastStack.topTask().taskType;
                }
                task.setTaskToReturnTo(returnToType);
            }
        } else {
            task.setTaskToReturnTo(0);
        }
        this.mTaskHistory.remove(task);
        int taskNdx = this.mTaskHistory.size();
        boolean bl = notShownWhenLocked = newActivity != null && (newActivity.info.flags & 0x400) == 0 || newActivity == null && task.topRunningActivityLocked() == null;
        if (!this.mStackSupervisor.isCurrentProfileLocked(task.userId) && notShownWhenLocked) {
            while (--taskNdx >= 0) {
                TaskRecord tmpTask = this.mTaskHistory.get(taskNdx);
                if (this.mStackSupervisor.isCurrentProfileLocked(tmpTask.userId) && tmpTask.topRunningActivityLocked() != null) continue;
                break;
            }
            ++taskNdx;
        }
        this.mTaskHistory.add(taskNdx, task);
        this.updateTaskMovement(task, true);
    }

    final void startActivityLocked(ActivityRecord r, boolean newTask, boolean keepCurTransition, ActivityOptions options) {
        TaskRecord rTask = r.task;
        int taskId = rTask.taskId;
        if (!r.mLaunchTaskBehind && (this.taskForIdLocked(taskId) == null || newTask)) {
            this.insertTaskAtTop(rTask, r);
            this.mWindowManager.moveTaskToTop(taskId);
        }
        TaskRecord task = null;
        if (!newTask) {
            boolean startIt = true;
            for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
                task = this.mTaskHistory.get(taskNdx);
                if (task.getTopActivity() == null) continue;
                if (task == r.task) {
                    if (startIt) break;
                    task.addActivityToTop(r);
                    r.putInHistory();
                    this.addConfigOverride(r, task);
                    ActivityOptions.abort(options);
                    return;
                }
                if (task.numFullscreen <= 0) continue;
                startIt = false;
            }
        }
        if (task == r.task && this.mTaskHistory.indexOf(task) != this.mTaskHistory.size() - 1) {
            this.mStackSupervisor.mUserLeaving = false;
        }
        task = r.task;
        task.addActivityToTop(r);
        task.setFrontOfTask();
        r.putInHistory();
        if (!this.isHomeStack() || this.numActivities() > 0) {
            boolean showStartingIcon = newTask;
            ProcessRecord proc = r.app;
            if (proc == null) {
                proc = this.mService.mProcessNames.get(r.processName, r.info.applicationInfo.uid);
            }
            if (proc == null || proc.thread == null) {
                showStartingIcon = true;
            }
            if ((r.intent.getFlags() & 0x10000) != 0) {
                this.mWindowManager.prepareAppTransition(0, keepCurTransition);
                this.mNoAnimActivities.add(r);
            } else {
                this.mWindowManager.prepareAppTransition(newTask ? (r.mLaunchTaskBehind ? 16 : 8) : 6, keepCurTransition);
                this.mNoAnimActivities.remove(r);
            }
            this.addConfigOverride(r, task);
            boolean doShow = true;
            if (newTask) {
                if ((r.intent.getFlags() & 0x200000) != 0) {
                    this.resetTaskIfNeededLocked(r, r);
                    doShow = this.topRunningNonDelayedActivityLocked(null) == r;
                }
            } else if (options != null && options.getAnimationType() == 5) {
                doShow = false;
            }
            if (r.mLaunchTaskBehind) {
                this.mWindowManager.setAppVisibility(r.appToken, true);
                this.ensureActivitiesVisibleLocked(null, 0, false);
            } else if (doShow) {
                ActivityRecord prev = r.task.topRunningActivityWithStartingWindowLocked();
                if (prev != null) {
                    if (prev.task != r.task) {
                        prev = null;
                    } else if (prev.nowVisible) {
                        prev = null;
                    }
                }
                r.showStartingWindow(prev, showStartingIcon);
            }
        } else {
            this.addConfigOverride(r, task);
            ActivityOptions.abort(options);
            options = null;
        }
    }

    final void validateAppTokensLocked() {
        this.mValidateAppTokens.clear();
        this.mValidateAppTokens.ensureCapacity(this.numActivities());
        int numTasks = this.mTaskHistory.size();
        for (int taskNdx = 0; taskNdx < numTasks; ++taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            ArrayList<ActivityRecord> activities = task.mActivities;
            if (activities.isEmpty()) continue;
            TaskGroup group = new TaskGroup();
            group.taskId = task.taskId;
            this.mValidateAppTokens.add(group);
            int numActivities = activities.size();
            for (int activityNdx = 0; activityNdx < numActivities; ++activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                group.tokens.add(r.appToken);
            }
        }
        this.mWindowManager.validateAppTokens(this.mStackId, this.mValidateAppTokens);
    }

    final ActivityOptions resetTargetTaskIfNeededLocked(TaskRecord task, boolean forceReset) {
        ActivityOptions topOptions = null;
        int replyChainEnd = -1;
        boolean canMoveOptions = true;
        ArrayList<ActivityRecord> activities = task.mActivities;
        int numActivities = activities.size();
        int rootActivityNdx = task.findEffectiveRootIndex();
        for (int i = numActivities - 1; i > rootActivityNdx; --i) {
            boolean clearWhenTaskReset;
            ActivityRecord target = activities.get(i);
            if (target.frontOfTask) break;
            int flags = target.info.flags;
            boolean finishOnTaskLaunch = (flags & 2) != 0;
            boolean allowTaskReparenting = (flags & 0x40) != 0;
            boolean bl = clearWhenTaskReset = (target.intent.getFlags() & 0x80000) != 0;
            if (!finishOnTaskLaunch && !clearWhenTaskReset && target.resultTo != null) {
                if (replyChainEnd >= 0) continue;
                replyChainEnd = i;
                continue;
            }
            if (!finishOnTaskLaunch && !clearWhenTaskReset && allowTaskReparenting && target.taskAffinity != null && !target.taskAffinity.equals(task.affinity)) {
                int start;
                TaskRecord targetTask;
                ActivityRecord bottom;
                ActivityRecord activityRecord = bottom = !this.mTaskHistory.isEmpty() && !this.mTaskHistory.get((int)0).mActivities.isEmpty() ? this.mTaskHistory.get((int)0).mActivities.get(0) : null;
                if (bottom != null && target.taskAffinity != null && target.taskAffinity.equals(bottom.task.affinity)) {
                    targetTask = bottom.task;
                } else {
                    targetTask = this.createTaskRecord(this.mStackSupervisor.getNextTaskIdForUserLocked(target.userId), target.info, null, null, null, false);
                    targetTask.affinityIntent = target.intent;
                }
                this.setAppTask(target, targetTask);
                boolean noOptions = canMoveOptions;
                for (int srcPos = start = replyChainEnd < 0 ? i : replyChainEnd; srcPos >= i; --srcPos) {
                    ActivityRecord p = activities.get(srcPos);
                    if (p.finishing) continue;
                    canMoveOptions = false;
                    if (noOptions && topOptions == null && (topOptions = p.takeOptionsLocked()) != null) {
                        noOptions = false;
                    }
                    p.setTask(targetTask, null);
                    targetTask.addActivityAtBottom(p);
                    this.setAppTask(p, targetTask);
                }
                this.mWindowManager.moveTaskToBottom(targetTask.taskId);
                replyChainEnd = -1;
                continue;
            }
            if (forceReset || finishOnTaskLaunch || clearWhenTaskReset) {
                int end = clearWhenTaskReset ? activities.size() - 1 : (replyChainEnd < 0 ? i : replyChainEnd);
                boolean noOptions = canMoveOptions;
                for (int srcPos = i; srcPos <= end; ++srcPos) {
                    ActivityRecord p = activities.get(srcPos);
                    if (p.finishing) continue;
                    canMoveOptions = false;
                    if (noOptions && topOptions == null && (topOptions = p.takeOptionsLocked()) != null) {
                        noOptions = false;
                    }
                    if (!this.finishActivityLocked(p, 0, null, "reset-task", false)) continue;
                    --end;
                    --srcPos;
                }
                replyChainEnd = -1;
                continue;
            }
            replyChainEnd = -1;
        }
        return topOptions;
    }

    private int resetAffinityTaskIfNeededLocked(TaskRecord affinityTask, TaskRecord task, boolean topTaskIsHigher, boolean forceReset, int taskInsertionPoint) {
        int replyChainEnd = -1;
        int taskId = task.taskId;
        String taskAffinity = task.affinity;
        ArrayList<ActivityRecord> activities = affinityTask.mActivities;
        int numActivities = activities.size();
        int rootActivityNdx = affinityTask.findEffectiveRootIndex();
        for (int i = numActivities - 1; i > rootActivityNdx; --i) {
            int start;
            boolean allowTaskReparenting;
            ActivityRecord target = activities.get(i);
            if (target.frontOfTask) break;
            int flags = target.info.flags;
            boolean finishOnTaskLaunch = (flags & 2) != 0;
            boolean bl = allowTaskReparenting = (flags & 0x40) != 0;
            if (target.resultTo != null) {
                if (replyChainEnd >= 0) continue;
                replyChainEnd = i;
                continue;
            }
            if (!topTaskIsHigher || !allowTaskReparenting || taskAffinity == null || !taskAffinity.equals(target.taskAffinity)) continue;
            if (forceReset || finishOnTaskLaunch) {
                for (int srcPos = start = replyChainEnd >= 0 ? replyChainEnd : i; srcPos >= i; --srcPos) {
                    ActivityRecord p = activities.get(srcPos);
                    if (p.finishing) continue;
                    this.finishActivityLocked(p, 0, null, "move-affinity", false);
                }
            } else {
                ArrayList<ActivityRecord> taskActivities;
                int targetNdx;
                if (taskInsertionPoint < 0) {
                    taskInsertionPoint = task.mActivities.size();
                }
                for (int srcPos = start = replyChainEnd >= 0 ? replyChainEnd : i; srcPos >= i; --srcPos) {
                    ActivityRecord p = activities.get(srcPos);
                    p.setTask(task, null);
                    task.addActivityAtIndex(taskInsertionPoint, p);
                    this.setAppTask(p, task);
                }
                this.mWindowManager.moveTaskToTop(taskId);
                if (target.info.launchMode == 1 && (targetNdx = (taskActivities = task.mActivities).indexOf(target)) > 0) {
                    ActivityRecord p = taskActivities.get(targetNdx - 1);
                    if (p.intent.getComponent().equals(target.intent.getComponent())) {
                        this.finishActivityLocked(p, 0, null, "replace", false);
                    }
                }
            }
            replyChainEnd = -1;
        }
        return taskInsertionPoint;
    }

    final ActivityRecord resetTaskIfNeededLocked(ActivityRecord taskTop, ActivityRecord newActivity) {
        boolean forceReset = (newActivity.info.flags & 4) != 0;
        TaskRecord task = taskTop.task;
        boolean taskFound = false;
        ActivityOptions topOptions = null;
        int reparentInsertionPoint = -1;
        for (int i = this.mTaskHistory.size() - 1; i >= 0; --i) {
            TaskRecord targetTask = this.mTaskHistory.get(i);
            if (targetTask == task) {
                topOptions = this.resetTargetTaskIfNeededLocked(task, forceReset);
                taskFound = true;
                continue;
            }
            reparentInsertionPoint = this.resetAffinityTaskIfNeededLocked(targetTask, task, taskFound, forceReset, reparentInsertionPoint);
        }
        int taskNdx = this.mTaskHistory.indexOf(task);
        if (taskNdx >= 0) {
            while ((taskTop = this.mTaskHistory.get(taskNdx--).getTopActivity()) == null && taskNdx >= 0) {
            }
        }
        if (topOptions != null) {
            if (taskTop != null) {
                taskTop.updateOptionsLocked(topOptions);
            } else {
                topOptions.abort();
            }
        }
        return taskTop;
    }

    void sendActivityResultLocked(int callingUid, ActivityRecord r, String resultWho, int requestCode, int resultCode, Intent data) {
        if (callingUid > 0) {
            this.mService.grantUriPermissionFromIntentLocked(callingUid, r.packageName, data, r.getUriPermissionsLocked(), r.userId);
        }
        if (this.mResumedActivity == r && r.app != null && r.app.thread != null) {
            try {
                ArrayList<ResultInfo> list = new ArrayList<ResultInfo>();
                list.add(new ResultInfo(resultWho, requestCode, resultCode, data));
                r.app.thread.scheduleSendResult(r.appToken, list);
                return;
            }
            catch (Exception e) {
                Slog.w("ActivityManager", "Exception thrown sending result to " + r, e);
            }
        }
        r.addResultLocked(null, resultWho, requestCode, resultCode, data);
    }

    private void adjustFocusedActivityLocked(ActivityRecord r, String reason) {
        if (!this.mStackSupervisor.isFocusedStack(this) || this.mService.mFocusedActivity != r) {
            return;
        }
        ActivityRecord next = this.topRunningActivityLocked();
        String myReason = reason + " adjustFocus";
        if (next != r) {
            if (next != null && ActivityManager.StackId.keepFocusInStackIfPossible(this.mStackId) && this.isFocusable()) {
                this.mService.setFocusedActivityLocked(next, myReason);
                return;
            }
            TaskRecord task = r.task;
            if (r.frontOfTask && task == this.topTask() && task.isOverHomeStack()) {
                int taskToReturnTo = task.getTaskToReturnTo();
                if (!this.mFullscreen && this.adjustFocusToNextFocusableStackLocked(taskToReturnTo, myReason)) {
                    return;
                }
                if (this.mStackSupervisor.moveHomeStackTaskToTop(taskToReturnTo, myReason)) {
                    return;
                }
            }
        }
        this.mService.setFocusedActivityLocked(this.mStackSupervisor.topRunningActivityLocked(), myReason);
    }

    private boolean adjustFocusToNextFocusableStackLocked(int taskToReturnTo, String reason) {
        ActivityStack stack = this.getNextFocusableStackLocked();
        String myReason = reason + " adjustFocusToNextFocusableStack";
        if (stack == null) {
            return false;
        }
        ActivityRecord top = stack.topRunningActivityLocked();
        if (stack.isHomeStack() && (top == null || !top.visible)) {
            return this.mStackSupervisor.moveHomeStackTaskToTop(taskToReturnTo, reason);
        }
        return this.mService.setFocusedActivityLocked(top, myReason);
    }

    final void stopActivityLocked(ActivityRecord r) {
        block6: {
            if (!((r.intent.getFlags() & 0x40000000) == 0 && (r.info.flags & 0x80) == 0 || r.finishing || this.mService.isSleepingLocked() || !this.requestFinishActivityLocked(r.appToken, 0, null, "stop-no-history", false))) {
                this.adjustFocusedActivityLocked(r, "stopActivityFinished");
                r.resumeKeyDispatchingLocked();
                return;
            }
            if (r.app != null && r.app.thread != null) {
                this.adjustFocusedActivityLocked(r, "stopActivity");
                r.resumeKeyDispatchingLocked();
                try {
                    r.stopped = false;
                    r.state = ActivityState.STOPPING;
                    if (!r.visible) {
                        this.mWindowManager.setAppVisibility(r.appToken, false);
                    }
                    EventLogTags.writeAmStopActivity(r.userId, System.identityHashCode(r), r.shortComponentName);
                    r.app.thread.scheduleStopActivity(r.appToken, r.visible, r.configChangeFlags);
                    if (this.mService.isSleepingOrShuttingDownLocked()) {
                        r.setSleeping(true);
                    }
                    Message msg = this.mHandler.obtainMessage(104, r);
                    this.mHandler.sendMessageDelayed(msg, 10000L);
                }
                catch (Exception e) {
                    Slog.w("ActivityManager", "Exception thrown during pause", e);
                    r.stopped = true;
                    r.state = ActivityState.STOPPED;
                    if (!r.deferRelaunchUntilPaused) break block6;
                    this.destroyActivityLocked(r, true, "stop-except");
                }
            }
        }
    }

    final boolean requestFinishActivityLocked(IBinder token, int resultCode, Intent resultData, String reason, boolean oomAdj) {
        ActivityRecord r = this.isInStackLocked(token);
        if (r == null) {
            return false;
        }
        this.finishActivityLocked(r, resultCode, resultData, reason, oomAdj);
        return true;
    }

    final void finishSubActivityLocked(ActivityRecord self, String resultWho, int requestCode) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.resultTo != self || r.requestCode != requestCode || (r.resultWho != null || resultWho != null) && (r.resultWho == null || !r.resultWho.equals(resultWho))) continue;
                this.finishActivityLocked(r, 0, null, "request-sub", false);
            }
        }
        this.mService.updateOomAdjLocked();
    }

    final TaskRecord finishTopRunningActivityLocked(ProcessRecord app, String reason) {
        ActivityRecord r = this.topRunningActivityLocked();
        TaskRecord finishedTask = null;
        if (r == null || r.app != app) {
            return null;
        }
        Slog.w("ActivityManager", "  Force finishing activity " + r.intent.getComponent().flattenToShortString());
        int taskNdx = this.mTaskHistory.indexOf(r.task);
        int activityNdx = r.task.mActivities.indexOf(r);
        this.finishActivityLocked(r, 0, null, reason, false);
        finishedTask = r.task;
        if (--activityNdx < 0) {
            while (--taskNdx >= 0 && (activityNdx = this.mTaskHistory.get((int)taskNdx).mActivities.size() - 1) < 0) {
            }
        }
        if (activityNdx >= 0) {
            r = this.mTaskHistory.get((int)taskNdx).mActivities.get(activityNdx);
            if (!(r.state != ActivityState.RESUMED && r.state != ActivityState.PAUSING && r.state != ActivityState.PAUSED || r.isHomeActivity() && this.mService.mHomeProcess == r.app)) {
                Slog.w("ActivityManager", "  Force finishing activity " + r.intent.getComponent().flattenToShortString());
                this.finishActivityLocked(r, 0, null, reason, false);
            }
        }
        return finishedTask;
    }

    final void finishVoiceTask(IVoiceInteractionSession session) {
        IBinder sessionBinder = session.asBinder();
        boolean didOne = false;
        block2: for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ActivityRecord r;
            int activityNdx;
            TaskRecord tr = this.mTaskHistory.get(taskNdx);
            if (tr.voiceSession != null && tr.voiceSession.asBinder() == sessionBinder) {
                for (activityNdx = tr.mActivities.size() - 1; activityNdx >= 0; --activityNdx) {
                    r = tr.mActivities.get(activityNdx);
                    if (r.finishing) continue;
                    this.finishActivityLocked(r, 0, null, "finish-voice", false);
                    didOne = true;
                }
                continue;
            }
            for (activityNdx = tr.mActivities.size() - 1; activityNdx >= 0; --activityNdx) {
                r = tr.mActivities.get(activityNdx);
                if (r.voiceSession == null || r.voiceSession.asBinder() != sessionBinder) continue;
                r.clearVoiceSessionLocked();
                try {
                    r.app.thread.scheduleLocalVoiceInteractionStarted(r.appToken, null);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                this.mService.finishRunningVoiceLocked();
                continue block2;
            }
        }
        if (didOne) {
            this.mService.updateOomAdjLocked();
        }
    }

    final boolean finishActivityAffinityLocked(ActivityRecord r) {
        ArrayList<ActivityRecord> activities = r.task.mActivities;
        for (int index = activities.indexOf(r); index >= 0; --index) {
            ActivityRecord cur = activities.get(index);
            if (!Objects.equals(cur.taskAffinity, r.taskAffinity)) break;
            this.finishActivityLocked(cur, 0, null, "request-affinity", true);
        }
        return true;
    }

    final void finishActivityResultsLocked(ActivityRecord r, int resultCode, Intent resultData) {
        ActivityRecord resultTo = r.resultTo;
        if (resultTo != null) {
            if (resultTo.userId != r.userId && resultData != null) {
                resultData.prepareToLeaveUser(r.userId);
            }
            if (r.info.applicationInfo.uid > 0) {
                this.mService.grantUriPermissionFromIntentLocked(r.info.applicationInfo.uid, resultTo.packageName, resultData, resultTo.getUriPermissionsLocked(), resultTo.userId);
            }
            resultTo.addResultLocked(r, r.resultWho, r.requestCode, resultCode, resultData);
            r.resultTo = null;
        }
        r.results = null;
        r.pendingResults = null;
        r.newIntents = null;
        r.icicle = null;
    }

    final boolean finishActivityLocked(ActivityRecord r, int resultCode, Intent resultData, String reason, boolean oomAdj) {
        int transit;
        if (r.finishing) {
            Slog.w("ActivityManager", "Duplicate finish request for " + r);
            return false;
        }
        r.makeFinishingLocked();
        TaskRecord task = r.task;
        EventLog.writeEvent(30001, r.userId, System.identityHashCode(r), task.taskId, r.shortComponentName, reason);
        ArrayList<ActivityRecord> activities = task.mActivities;
        int index = activities.indexOf(r);
        if (index < activities.size() - 1) {
            task.setFrontOfTask();
            if ((r.intent.getFlags() & 0x80000) != 0) {
                ActivityRecord next = activities.get(index + 1);
                next.intent.addFlags(524288);
            }
        }
        r.pauseKeyDispatchingLocked();
        this.adjustFocusedActivityLocked(r, "finishActivity");
        this.finishActivityResultsLocked(r, resultCode, resultData);
        boolean endTask = index <= 0;
        int n = transit = endTask ? 9 : 7;
        if (this.mResumedActivity == r) {
            this.mWindowManager.prepareAppTransition(transit, false);
            this.mWindowManager.setAppVisibility(r.appToken, false);
            if (this.mPausingActivity == null) {
                this.startPausingLocked(false, false, null, false);
            }
            if (endTask) {
                this.mStackSupervisor.removeLockedTaskLocked(task);
            }
        } else if (r.state != ActivityState.PAUSING) {
            if (r.visible) {
                this.mWindowManager.prepareAppTransition(transit, false);
                this.mWindowManager.setAppVisibility(r.appToken, false);
                this.mWindowManager.executeAppTransition();
                if (!this.mStackSupervisor.mWaitingVisibleActivities.contains(r)) {
                    this.mStackSupervisor.mWaitingVisibleActivities.add(r);
                }
            }
            return this.finishCurrentActivityLocked(r, r.visible || r.nowVisible ? 2 : 1, oomAdj) == null;
        }
        return false;
    }

    final ActivityRecord finishCurrentActivityLocked(ActivityRecord r, int mode, boolean oomAdj) {
        boolean finishingActivityInNonFocusedStack;
        ActivityRecord next = this.mStackSupervisor.topRunningActivityLocked();
        if (mode == 2 && (r.visible || r.nowVisible) && next != null && !next.nowVisible) {
            if (!this.mStackSupervisor.mStoppingActivities.contains(r)) {
                this.addToStopping(r, false);
            }
            r.state = ActivityState.STOPPING;
            if (oomAdj) {
                this.mService.updateOomAdjLocked();
            }
            return r;
        }
        this.mStackSupervisor.mStoppingActivities.remove(r);
        this.mStackSupervisor.mGoingToSleepActivities.remove(r);
        this.mStackSupervisor.mWaitingVisibleActivities.remove(r);
        if (this.mResumedActivity == r) {
            this.mResumedActivity = null;
        }
        ActivityState prevState = r.state;
        r.state = ActivityState.FINISHING;
        boolean bl = finishingActivityInNonFocusedStack = r.task.stack != this.mStackSupervisor.getFocusedStack() && prevState == ActivityState.PAUSED && mode == 2;
        if (mode == 0 || prevState == ActivityState.PAUSED && (mode == 1 || this.mStackId == 4) || finishingActivityInNonFocusedStack || prevState == ActivityState.STOPPED || prevState == ActivityState.INITIALIZING) {
            r.makeFinishingLocked();
            boolean activityRemoved = this.destroyActivityLocked(r, true, "finish-imm");
            if (finishingActivityInNonFocusedStack) {
                this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0, false);
            }
            if (activityRemoved) {
                this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
            }
            return activityRemoved ? null : r;
        }
        this.mStackSupervisor.mFinishingActivities.add(r);
        r.resumeKeyDispatchingLocked();
        this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
        return r;
    }

    void finishAllActivitiesLocked(boolean immediately) {
        boolean noActivitiesInStack = true;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                noActivitiesInStack = false;
                if (r.finishing && !immediately) continue;
                Slog.d("ActivityManager", "finishAllActivitiesLocked: finishing " + r + " immediately");
                this.finishCurrentActivityLocked(r, 0, false);
            }
        }
        if (noActivitiesInStack) {
            this.mActivityContainer.onTaskListEmptyLocked();
        }
    }

    final boolean shouldUpRecreateTaskLocked(ActivityRecord srec, String destAffinity) {
        if (srec == null || srec.task.affinity == null || !srec.task.affinity.equals(destAffinity)) {
            return true;
        }
        if (srec.frontOfTask && srec.task != null && srec.task.getBaseIntent() != null && srec.task.getBaseIntent().isDocument()) {
            if (srec.task.getTaskToReturnTo() != 0) {
                return true;
            }
            int taskIdx = this.mTaskHistory.indexOf(srec.task);
            if (taskIdx <= 0) {
                Slog.w("ActivityManager", "shouldUpRecreateTask: task not in history for " + srec);
                return false;
            }
            if (taskIdx == 0) {
                return true;
            }
            TaskRecord prevTask = this.mTaskHistory.get(taskIdx);
            if (!srec.task.affinity.equals(prevTask.affinity)) {
                return true;
            }
        }
        return false;
    }

    final boolean navigateUpToLocked(ActivityRecord srec, Intent destIntent, int resultCode, Intent resultData) {
        ActivityRecord next;
        IActivityController controller;
        TaskRecord task = srec.task;
        ArrayList<ActivityRecord> activities = task.mActivities;
        int start = activities.indexOf(srec);
        if (!this.mTaskHistory.contains(task) || start < 0) {
            return false;
        }
        int finishTo = start - 1;
        ActivityRecord parent = finishTo < 0 ? null : activities.get(finishTo);
        boolean foundParentInTask = false;
        ComponentName dest = destIntent.getComponent();
        if (start > 0 && dest != null) {
            for (int i = finishTo; i >= 0; --i) {
                ActivityRecord r = activities.get(i);
                if (!r.info.packageName.equals(dest.getPackageName()) || !r.info.name.equals(dest.getClassName())) continue;
                finishTo = i;
                parent = r;
                foundParentInTask = true;
                break;
            }
        }
        if ((controller = this.mService.mController) != null && (next = this.topRunningActivityLocked(srec.appToken, 0)) != null) {
            boolean resumeOK = true;
            try {
                resumeOK = controller.activityResuming(next.packageName);
            }
            catch (RemoteException e) {
                this.mService.mController = null;
                Watchdog.getInstance().setActivityController(null);
            }
            if (!resumeOK) {
                return false;
            }
        }
        long origId = Binder.clearCallingIdentity();
        for (int i = start; i > finishTo; --i) {
            ActivityRecord r = activities.get(i);
            this.requestFinishActivityLocked(r.appToken, resultCode, resultData, "navigate-up", true);
            resultCode = 0;
            resultData = null;
        }
        if (parent != null && foundParentInTask) {
            int parentLaunchMode = parent.info.launchMode;
            int destIntentFlags = destIntent.getFlags();
            if (parentLaunchMode == 3 || parentLaunchMode == 2 || parentLaunchMode == 1 || (destIntentFlags & 0x4000000) != 0) {
                parent.deliverNewIntentLocked(srec.info.applicationInfo.uid, destIntent, srec.packageName);
            } else {
                try {
                    ActivityInfo aInfo = AppGlobals.getPackageManager().getActivityInfo(destIntent.getComponent(), 0, srec.userId);
                    int res = this.mService.mActivityStarter.startActivityLocked(srec.app.thread, destIntent, null, null, aInfo, null, null, null, parent.appToken, null, 0, -1, parent.launchedFromUid, parent.launchedFromPackage, -1, parent.launchedFromUid, 0, null, false, true, null, null, null);
                    foundParentInTask = res == 0;
                }
                catch (RemoteException e) {
                    foundParentInTask = false;
                }
                this.requestFinishActivityLocked(parent.appToken, resultCode, resultData, "navigate-top", true);
            }
        }
        Binder.restoreCallingIdentity(origId);
        return foundParentInTask;
    }

    final void cleanUpActivityLocked(ActivityRecord r, boolean cleanServices, boolean setState) {
        if (this.mResumedActivity == r) {
            this.mResumedActivity = null;
        }
        if (this.mPausingActivity == r) {
            this.mPausingActivity = null;
        }
        this.mService.resetFocusedActivityIfNeededLocked(r);
        r.deferRelaunchUntilPaused = false;
        r.frozenBeforeDestroy = false;
        if (setState) {
            r.state = ActivityState.DESTROYED;
            r.app = null;
        }
        this.mStackSupervisor.mFinishingActivities.remove(r);
        this.mStackSupervisor.mWaitingVisibleActivities.remove(r);
        if (r.finishing && r.pendingResults != null) {
            for (WeakReference<PendingIntentRecord> apr : r.pendingResults) {
                PendingIntentRecord rec = (PendingIntentRecord)apr.get();
                if (rec == null) continue;
                this.mService.cancelIntentSenderLocked(rec, false);
            }
            r.pendingResults = null;
        }
        if (cleanServices) {
            this.cleanUpActivityServicesLocked(r);
        }
        this.removeTimeoutsForActivityLocked(r);
        if (this.getVisibleBehindActivity() == r) {
            this.mStackSupervisor.requestVisibleBehindLocked(r, false);
        }
        this.mWindowManager.notifyAppRelaunchesCleared(r.appToken);
    }

    private void removeTimeoutsForActivityLocked(ActivityRecord r) {
        this.mStackSupervisor.removeTimeoutsForActivityLocked(r);
        this.mHandler.removeMessages(101, r);
        this.mHandler.removeMessages(104, r);
        this.mHandler.removeMessages(102, r);
        r.finishLaunchTickingLocked();
    }

    private void removeActivityFromHistoryLocked(ActivityRecord r, TaskRecord oldTop, String reason) {
        TaskRecord topTask;
        this.mStackSupervisor.removeChildActivityContainers(r);
        this.finishActivityResultsLocked(r, 0, null);
        r.makeFinishingLocked();
        r.takeFromHistory();
        this.removeTimeoutsForActivityLocked(r);
        r.state = ActivityState.DESTROYED;
        r.app = null;
        this.mWindowManager.removeAppToken(r.appToken);
        TaskRecord task = r.task;
        TaskRecord taskRecord = topTask = oldTop != null ? oldTop : this.topTask();
        if (task != null && task.removeActivity(r)) {
            if (this.mStackSupervisor.isFocusedStack(this) && task == topTask && task.isOverHomeStack()) {
                this.mStackSupervisor.moveHomeStackTaskToTop(task.getTaskToReturnTo(), reason);
            }
            this.removeTask(task, reason);
        }
        this.cleanUpActivityServicesLocked(r);
        r.removeUriPermissionsLocked();
    }

    final void cleanUpActivityServicesLocked(ActivityRecord r) {
        if (r.connections != null) {
            for (ConnectionRecord c : r.connections) {
                this.mService.mServices.removeConnectionLocked(c, null, r);
            }
            r.connections = null;
        }
    }

    final void scheduleDestroyActivities(ProcessRecord owner, String reason) {
        Message msg = this.mHandler.obtainMessage(105);
        msg.obj = new ScheduleDestroyArgs(owner, reason);
        this.mHandler.sendMessage(msg);
    }

    final void destroyActivitiesLocked(ProcessRecord owner, String reason) {
        boolean lastIsOpaque = false;
        boolean activityRemoved = false;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.finishing) continue;
                if (r.fullscreen) {
                    lastIsOpaque = true;
                }
                if (owner != null && r.app != owner || !lastIsOpaque || !r.isDestroyable() || !this.destroyActivityLocked(r, true, reason)) continue;
                activityRemoved = true;
            }
        }
        if (activityRemoved) {
            this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
        }
    }

    final boolean safelyDestroyActivityLocked(ActivityRecord r, String reason) {
        if (r.isDestroyable()) {
            return this.destroyActivityLocked(r, true, reason);
        }
        return false;
    }

    final int releaseSomeActivitiesLocked(ProcessRecord app, ArraySet<TaskRecord> tasks, String reason) {
        int maxTasks = tasks.size() / 4;
        if (maxTasks < 1) {
            maxTasks = 1;
        }
        int numReleased = 0;
        for (int taskNdx = 0; taskNdx < this.mTaskHistory.size() && maxTasks > 0; ++taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            if (!tasks.contains(task)) continue;
            int curNum = 0;
            ArrayList<ActivityRecord> activities = task.mActivities;
            for (int actNdx = 0; actNdx < activities.size(); ++actNdx) {
                ActivityRecord activity = activities.get(actNdx);
                if (activity.app != app || !activity.isDestroyable()) continue;
                this.destroyActivityLocked(activity, true, reason);
                if (activities.get(actNdx) != activity) {
                    --actNdx;
                }
                ++curNum;
            }
            if (curNum <= 0) continue;
            numReleased += curNum;
            --maxTasks;
            if (this.mTaskHistory.get(taskNdx) == task) continue;
            --taskNdx;
        }
        return numReleased;
    }

    final boolean destroyActivityLocked(ActivityRecord r, boolean removeFromApp, String reason) {
        boolean hadApp;
        EventLog.writeEvent(30018, r.userId, System.identityHashCode(r), r.task.taskId, r.shortComponentName, reason);
        boolean removedFromHistory = false;
        TaskRecord topTask = this.topTask();
        this.cleanUpActivityLocked(r, false, false);
        boolean bl = hadApp = r.app != null;
        if (hadApp) {
            boolean skipDestroy;
            block12: {
                if (removeFromApp) {
                    r.app.activities.remove(r);
                    if (this.mService.mHeavyWeightProcess == r.app && r.app.activities.size() <= 0) {
                        this.mService.mHeavyWeightProcess = null;
                        this.mService.mHandler.sendEmptyMessage(25);
                    }
                    if (r.app.activities.isEmpty()) {
                        this.mService.mServices.updateServiceConnectionActivitiesLocked(r.app);
                        this.mService.updateLruProcessLocked(r.app, false, null);
                        this.mService.updateOomAdjLocked();
                    }
                }
                skipDestroy = false;
                try {
                    r.app.thread.scheduleDestroyActivity(r.appToken, r.finishing, r.configChangeFlags);
                }
                catch (Exception e) {
                    if (!r.finishing) break block12;
                    this.removeActivityFromHistoryLocked(r, topTask, reason + " exceptionInScheduleDestroy");
                    removedFromHistory = true;
                    skipDestroy = true;
                }
            }
            r.nowVisible = false;
            if (r.finishing && !skipDestroy) {
                r.state = ActivityState.DESTROYING;
                Message msg = this.mHandler.obtainMessage(102, r);
                this.mHandler.sendMessageDelayed(msg, 10000L);
            } else {
                r.state = ActivityState.DESTROYED;
                r.app = null;
            }
        } else if (r.finishing) {
            this.removeActivityFromHistoryLocked(r, topTask, reason + " hadNoApp");
            removedFromHistory = true;
        } else {
            r.state = ActivityState.DESTROYED;
            r.app = null;
        }
        r.configChangeFlags = 0;
        if (!this.mLRUActivities.remove(r) && hadApp) {
            Slog.w("ActivityManager", "Activity " + r + " being finished, but not in LRU list");
        }
        return removedFromHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void activityDestroyedLocked(IBinder token, String reason) {
        long origId = Binder.clearCallingIdentity();
        try {
            ActivityRecord r = ActivityRecord.forTokenLocked(token);
            if (r != null) {
                this.mHandler.removeMessages(102, r);
            }
            if (this.isInStackLocked(r) != null && r.state == ActivityState.DESTROYING) {
                this.cleanUpActivityLocked(r, true, false);
                this.removeActivityFromHistoryLocked(r, null, reason);
            }
            this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    void releaseBackgroundResources(ActivityRecord r) {
        if (this.hasVisibleBehindActivity() && !this.mHandler.hasMessages(107)) {
            if (r == this.topRunningActivityLocked() && this.getStackVisibilityLocked(null) == 1) {
                return;
            }
            if (r != null && r.app != null && r.app.thread != null) {
                try {
                    r.app.thread.scheduleCancelVisibleBehind(r.appToken);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                this.mHandler.sendEmptyMessageDelayed(107, 500L);
            } else {
                Slog.e("ActivityManager", "releaseBackgroundResources: activity " + r + " no longer running");
                this.backgroundResourcesReleased();
            }
        }
    }

    final void backgroundResourcesReleased() {
        this.mHandler.removeMessages(107);
        ActivityRecord r = this.getVisibleBehindActivity();
        if (r != null) {
            this.mStackSupervisor.mStoppingActivities.add(r);
            this.setVisibleBehindActivity(null);
            this.mStackSupervisor.scheduleIdleTimeoutLocked(null);
        }
        this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
    }

    boolean hasVisibleBehindActivity() {
        return this.isAttached() && this.mActivityContainer.mActivityDisplay.hasVisibleBehindActivity();
    }

    void setVisibleBehindActivity(ActivityRecord r) {
        if (this.isAttached()) {
            this.mActivityContainer.mActivityDisplay.setVisibleBehindActivity(r);
        }
    }

    ActivityRecord getVisibleBehindActivity() {
        return this.isAttached() ? this.mActivityContainer.mActivityDisplay.mVisibleBehindActivity : null;
    }

    private void removeHistoryRecordsForAppLocked(ArrayList<ActivityRecord> list, ProcessRecord app, String listName) {
        int i = list.size();
        while (i > 0) {
            ActivityRecord r = list.get(--i);
            if (r.app != app) continue;
            list.remove(i);
            this.removeTimeoutsForActivityLocked(r);
        }
    }

    boolean removeHistoryRecordsForAppLocked(ProcessRecord app) {
        this.removeHistoryRecordsForAppLocked(this.mLRUActivities, app, "mLRUActivities");
        this.removeHistoryRecordsForAppLocked(this.mStackSupervisor.mStoppingActivities, app, "mStoppingActivities");
        this.removeHistoryRecordsForAppLocked(this.mStackSupervisor.mGoingToSleepActivities, app, "mGoingToSleepActivities");
        this.removeHistoryRecordsForAppLocked(this.mStackSupervisor.mWaitingVisibleActivities, app, "mWaitingVisibleActivities");
        this.removeHistoryRecordsForAppLocked(this.mStackSupervisor.mFinishingActivities, app, "mFinishingActivities");
        boolean hasVisibleActivities = false;
        int i = this.numActivities();
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                boolean remove;
                ActivityRecord r = activities.get(activityNdx);
                --i;
                if (r.app != app) continue;
                if (r.visible) {
                    hasVisibleActivities = true;
                }
                if (remove = !r.haveState && !r.stateNotNeeded || r.finishing ? true : !r.visible && r.launchCount > 2 && r.lastLaunchTime > SystemClock.uptimeMillis() - 60000L) {
                    if (!r.finishing) {
                        Slog.w("ActivityManager", "Force removing " + r + ": app died, no saved state");
                        EventLog.writeEvent(30001, r.userId, System.identityHashCode(r), r.task.taskId, r.shortComponentName, "proc died without state saved");
                        if (r.state == ActivityState.RESUMED) {
                            this.mService.updateUsageStats(r, false);
                        }
                    }
                } else {
                    r.app = null;
                    r.nowVisible = r.visible;
                    if (!r.haveState) {
                        r.icicle = null;
                    }
                }
                this.cleanUpActivityLocked(r, true, true);
                if (!remove) continue;
                this.removeActivityFromHistoryLocked(r, null, "appDied");
            }
        }
        return hasVisibleActivities;
    }

    final void updateTransitLocked(int transit, ActivityOptions options) {
        if (options != null) {
            ActivityRecord r = this.topRunningActivityLocked();
            if (r != null && r.state != ActivityState.RESUMED) {
                r.updateOptionsLocked(options);
            } else {
                ActivityOptions.abort(options);
            }
        }
        this.mWindowManager.prepareAppTransition(transit, false);
    }

    void updateTaskMovement(TaskRecord task, boolean toFront) {
        if (task.isPersistable) {
            task.mLastTimeMoved = System.currentTimeMillis();
            if (!toFront) {
                task.mLastTimeMoved *= -1L;
            }
        }
        this.mStackSupervisor.invalidateTaskLayers();
    }

    void moveHomeStackTaskToTop(int homeStackTaskType) {
        int top;
        for (int taskNdx = top = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            if (task.taskType != homeStackTaskType) continue;
            this.mTaskHistory.remove(taskNdx);
            this.mTaskHistory.add(top, task);
            this.updateTaskMovement(task, true);
            return;
        }
    }

    final void moveTaskToFrontLocked(TaskRecord tr, boolean noAnimation, ActivityOptions options, AppTimeTracker timeTracker, String reason) {
        int numTasks = this.mTaskHistory.size();
        int index = this.mTaskHistory.indexOf(tr);
        if (numTasks == 0 || index < 0) {
            if (noAnimation) {
                ActivityOptions.abort(options);
            } else {
                this.updateTransitLocked(10, options);
            }
            return;
        }
        if (timeTracker != null) {
            for (int i = tr.mActivities.size() - 1; i >= 0; --i) {
                tr.mActivities.get((int)i).appTimeTracker = timeTracker;
            }
        }
        this.insertTaskAtTop(tr, null);
        ActivityRecord top = tr.getTopActivity();
        if (!this.okToShowLocked(top)) {
            this.addRecentActivityLocked(top);
            ActivityOptions.abort(options);
            return;
        }
        ActivityRecord r = this.topRunningActivityLocked();
        this.mService.setFocusedActivityLocked(r, reason);
        if (noAnimation) {
            this.mWindowManager.prepareAppTransition(0, false);
            if (r != null) {
                this.mNoAnimActivities.add(r);
            }
            ActivityOptions.abort(options);
        } else {
            this.updateTransitLocked(10, options);
        }
        this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
        EventLog.writeEvent(30002, tr.userId, tr.taskId);
    }

    final boolean moveTaskToBackLocked(int taskId) {
        TaskRecord task;
        TaskRecord task2;
        boolean canGoHome;
        ActivityStack fullscreenStack;
        TaskRecord tr = this.taskForIdLocked(taskId);
        if (tr == null) {
            Slog.i("ActivityManager", "moveTaskToBack: bad taskId=" + taskId);
            return false;
        }
        Slog.i("ActivityManager", "moveTaskToBack: " + tr);
        this.mStackSupervisor.removeLockedTaskLocked(tr);
        if (this.mStackSupervisor.isFrontStack(this) && this.mService.mController != null) {
            ActivityRecord next = this.topRunningActivityLocked(null, taskId);
            if (next == null) {
                next = this.topRunningActivityLocked(null, 0);
            }
            if (next != null) {
                boolean moveOK = true;
                try {
                    moveOK = this.mService.mController.activityResuming(next.packageName);
                }
                catch (RemoteException e) {
                    this.mService.mController = null;
                    Watchdog.getInstance().setActivityController(null);
                }
                if (!moveOK) {
                    return false;
                }
            }
        }
        if (this.mStackId == 0 && this.topTask().isHomeTask() && (fullscreenStack = this.mStackSupervisor.getStack(1)) != null && fullscreenStack.hasVisibleBehindActivity()) {
            ActivityRecord visibleBehind = fullscreenStack.getVisibleBehindActivity();
            this.mService.setFocusedActivityLocked(visibleBehind, "moveTaskToBack");
            this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
            return true;
        }
        boolean prevIsHome = false;
        boolean bl = canGoHome = !tr.isHomeTask() && tr.isOverHomeStack();
        if (canGoHome) {
            TaskRecord nextTask = this.getNextTask(tr);
            if (nextTask != null) {
                nextTask.setTaskToReturnTo(tr.getTaskToReturnTo());
            } else {
                prevIsHome = true;
            }
        }
        this.mTaskHistory.remove(tr);
        this.mTaskHistory.add(0, tr);
        this.updateTaskMovement(tr, false);
        int numTasks = this.mTaskHistory.size();
        for (int taskNdx = numTasks - 1; taskNdx >= 1 && !(task2 = this.mTaskHistory.get(taskNdx)).isOverHomeStack(); --taskNdx) {
            if (taskNdx != 1) continue;
            task2.setTaskToReturnTo(1);
        }
        this.mWindowManager.prepareAppTransition(11, false);
        this.mWindowManager.moveTaskToBottom(taskId);
        TaskRecord taskRecord = task = this.mResumedActivity != null ? this.mResumedActivity.task : null;
        if (prevIsHome || task == tr && canGoHome || numTasks <= 1 && this.isOnHomeDisplay()) {
            if (!this.mService.mBooting && !this.mService.mBooted) {
                return false;
            }
            int taskToReturnTo = tr.getTaskToReturnTo();
            tr.setTaskToReturnTo(0);
            return this.mStackSupervisor.resumeHomeStackTask(taskToReturnTo, null, "moveTaskToBack");
        }
        this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
        return true;
    }

    static final void logStartActivity(int tag, ActivityRecord r, TaskRecord task) {
        Uri data = r.intent.getData();
        String strData = data != null ? data.toSafeString() : null;
        EventLog.writeEvent(tag, r.userId, System.identityHashCode(r), task.taskId, r.shortComponentName, r.intent.getAction(), r.intent.getType(), strData, r.intent.getFlags());
    }

    void ensureVisibleActivitiesConfigurationLocked(ActivityRecord start, boolean preserveWindow) {
        if (start == null || !start.visible) {
            return;
        }
        TaskRecord startTask = start.task;
        boolean behindFullscreen = false;
        boolean updatedConfig = false;
        for (int taskIndex = this.mTaskHistory.indexOf(startTask); taskIndex >= 0; --taskIndex) {
            int activityIndex;
            TaskRecord task = this.mTaskHistory.get(taskIndex);
            ArrayList<ActivityRecord> activities = task.mActivities;
            int n = activityIndex = start.task == task ? activities.indexOf(start) : activities.size() - 1;
            while (activityIndex >= 0) {
                ActivityRecord r = activities.get(activityIndex);
                updatedConfig |= this.ensureActivityConfigurationLocked(r, 0, preserveWindow);
                if (r.fullscreen) {
                    behindFullscreen = true;
                    break;
                }
                --activityIndex;
            }
            if (behindFullscreen) break;
        }
        if (updatedConfig) {
            this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
        }
    }

    boolean ensureActivityConfigurationLocked(ActivityRecord r, int globalChanges, boolean preserveWindow) {
        if (this.mConfigWillChange) {
            return true;
        }
        if (this.mService.isSleepingOrShuttingDownLocked() && r.state == ActivityState.STOPPED) {
            return true;
        }
        Configuration newConfig = this.mService.mConfiguration;
        r.task.sanitizeOverrideConfiguration(newConfig);
        Configuration taskConfig = r.task.mOverrideConfig;
        if (r.configuration.equals(newConfig) && r.taskConfigOverride.equals(taskConfig) && !r.forceNewConfig) {
            return true;
        }
        if (r.finishing) {
            r.stopFreezingScreenLocked(false);
            return true;
        }
        Configuration oldConfig = r.configuration;
        Configuration oldTaskOverride = r.taskConfigOverride;
        r.configuration = newConfig;
        r.taskConfigOverride = taskConfig;
        int taskChanges = this.getTaskConfigurationChanges(r, taskConfig, oldTaskOverride);
        int changes = oldConfig.diff(newConfig) | taskChanges;
        if (changes == 0 && !r.forceNewConfig) {
            r.scheduleConfigurationChanged(taskConfig, true);
            return true;
        }
        if (r.app == null || r.app.thread == null) {
            r.stopFreezingScreenLocked(false);
            r.forceNewConfig = false;
            return true;
        }
        if ((changes & ~r.info.getRealConfigChanged()) != 0 || r.forceNewConfig) {
            r.configChangeFlags |= changes;
            r.startFreezingScreenLocked(r.app, globalChanges);
            r.forceNewConfig = false;
            preserveWindow &= ActivityStack.isResizeOnlyChange(changes);
            if (r.app == null || r.app.thread == null) {
                this.destroyActivityLocked(r, true, "config");
            } else {
                if (r.state == ActivityState.PAUSING) {
                    r.deferRelaunchUntilPaused = true;
                    r.preserveWindowOnDeferredRelaunch = preserveWindow;
                    return true;
                }
                if (r.state == ActivityState.RESUMED) {
                    this.relaunchActivityLocked(r, r.configChangeFlags, true, preserveWindow);
                } else {
                    this.relaunchActivityLocked(r, r.configChangeFlags, false, preserveWindow);
                }
            }
            return false;
        }
        r.scheduleConfigurationChanged(taskConfig, true);
        r.stopFreezingScreenLocked(false);
        return true;
    }

    private int getTaskConfigurationChanges(ActivityRecord record, Configuration taskConfig, Configuration oldTaskOverride) {
        int newSmallest;
        int oldSmallest;
        int taskChanges;
        if (Configuration.EMPTY.equals(oldTaskOverride) && !Configuration.EMPTY.equals(taskConfig)) {
            oldTaskOverride = record.task.extractOverrideConfig(record.configuration);
        }
        if (Configuration.EMPTY.equals(taskConfig) && !Configuration.EMPTY.equals(oldTaskOverride)) {
            taskConfig = record.task.extractOverrideConfig(record.configuration);
        }
        if (((taskChanges = oldTaskOverride.diff(taskConfig)) & 0x400) != 0) {
            boolean crosses;
            boolean bl = crosses = record.crossesHorizontalSizeThreshold(oldTaskOverride.screenWidthDp, taskConfig.screenWidthDp) || record.crossesVerticalSizeThreshold(oldTaskOverride.screenHeightDp, taskConfig.screenHeightDp);
            if (!crosses) {
                taskChanges &= 0xFFFFFBFF;
            }
        }
        if ((taskChanges & 0x800) != 0 && !record.crossesSmallestSizeThreshold(oldSmallest = oldTaskOverride.smallestScreenWidthDp, newSmallest = taskConfig.smallestScreenWidthDp)) {
            taskChanges &= 0xFFFFF7FF;
        }
        return ActivityStack.catchConfigChangesFromUnset(taskConfig, oldTaskOverride, taskChanges);
    }

    private static int catchConfigChangesFromUnset(Configuration taskConfig, Configuration oldTaskOverride, int taskChanges) {
        if (taskChanges == 0) {
            if (oldTaskOverride.orientation != taskConfig.orientation) {
                taskChanges |= 0x80;
            }
            int oldHeight = oldTaskOverride.screenHeightDp;
            int newHeight = taskConfig.screenHeightDp;
            boolean undefinedHeight = false;
            if (oldHeight == 0 && newHeight != 0 || oldHeight != 0 && newHeight == 0) {
                taskChanges |= 0x400;
            }
            int oldWidth = oldTaskOverride.screenWidthDp;
            int newWidth = taskConfig.screenWidthDp;
            boolean undefinedWidth = false;
            if (oldWidth == 0 && newWidth != 0 || oldWidth != 0 && newWidth == 0) {
                taskChanges |= 0x400;
            }
            int oldSmallest = oldTaskOverride.smallestScreenWidthDp;
            int newSmallest = taskConfig.smallestScreenWidthDp;
            boolean undefinedSmallest = false;
            if (oldSmallest == 0 && newSmallest != 0 || oldSmallest != 0 && newSmallest == 0) {
                taskChanges |= 0x800;
            }
            int oldLayout = oldTaskOverride.screenLayout;
            int newLayout = taskConfig.screenLayout;
            if (oldLayout == 0 && newLayout != 0 || oldLayout != 0 && newLayout == 0) {
                taskChanges |= 0x100;
            }
        }
        return taskChanges;
    }

    private static boolean isResizeOnlyChange(int change) {
        return (change & 0xFFFFF27F) == 0;
    }

    private void relaunchActivityLocked(ActivityRecord r, int changes, boolean andResume, boolean preserveWindow) {
        if (this.mService.mSuppressResizeConfigChanges && preserveWindow) {
            r.configChangeFlags = 0;
            return;
        }
        ArrayList<ResultInfo> results = null;
        ArrayList<ReferrerIntent> newIntents = null;
        if (andResume) {
            results = r.results;
            newIntents = r.newIntents;
        }
        EventLog.writeEvent(andResume ? 30019 : 30020, r.userId, System.identityHashCode(r), r.task.taskId, r.shortComponentName);
        r.startFreezingScreenLocked(r.app, 0);
        this.mStackSupervisor.removeChildActivityContainers(r);
        try {
            r.forceNewConfig = false;
            this.mStackSupervisor.activityRelaunchingLocked(r);
            r.app.thread.scheduleRelaunchActivity(r.appToken, results, newIntents, changes, !andResume, new Configuration(this.mService.mConfiguration), new Configuration(r.task.mOverrideConfig), preserveWindow);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (andResume) {
            r.state = ActivityState.RESUMED;
            if (!r.visible || r.stopped) {
                this.mWindowManager.setAppVisibility(r.appToken, true);
                this.completeResumeLocked(r);
            } else {
                r.results = null;
                r.newIntents = null;
            }
            this.mService.showUnsupportedZoomDialogIfNeededLocked(r);
            this.mService.showAskCompatModeDialogLocked(r);
        } else {
            this.mHandler.removeMessages(101, r);
            r.state = ActivityState.PAUSED;
        }
        r.configChangeFlags = 0;
        r.deferRelaunchUntilPaused = false;
        r.preserveWindowOnDeferredRelaunch = false;
    }

    boolean willActivityBeVisibleLocked(IBinder token) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.appToken == token) {
                    return true;
                }
                if (!r.fullscreen || r.finishing) continue;
                return false;
            }
        }
        ActivityRecord r = ActivityRecord.forTokenLocked(token);
        if (r == null) {
            return false;
        }
        if (r.finishing) {
            Slog.e("ActivityManager", "willActivityBeVisibleLocked: Returning false, would have returned true for r=" + r);
        }
        return !r.finishing;
    }

    void closeSystemDialogsLocked() {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if ((r.info.flags & 0x100) == 0) continue;
                this.finishActivityLocked(r, 0, null, "close-sys", true);
            }
        }
    }

    boolean finishDisabledPackageActivitiesLocked(String packageName, Set<String> filterByClasses, boolean doit, boolean evenPersistent, int userId) {
        boolean didSomething = false;
        TaskRecord lastTask = null;
        ComponentName homeActivity = null;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            int numActivities = activities.size();
            for (int activityNdx = 0; activityNdx < numActivities; ++activityNdx) {
                boolean sameComponent;
                ActivityRecord r = activities.get(activityNdx);
                boolean bl = sameComponent = r.packageName.equals(packageName) && (filterByClasses == null || filterByClasses.contains(r.realActivity.getClassName())) || packageName == null && r.userId == userId;
                if (userId != -1 && r.userId != userId || !sameComponent && r.task != lastTask || r.app != null && !evenPersistent && r.app.persistent) continue;
                if (!doit) {
                    if (r.finishing) continue;
                    return true;
                }
                if (r.isHomeActivity()) {
                    if (homeActivity != null && homeActivity.equals(r.realActivity)) {
                        Slog.i("ActivityManager", "Skip force-stop again " + r);
                        continue;
                    }
                    homeActivity = r.realActivity;
                }
                didSomething = true;
                Slog.i("ActivityManager", "  Force finishing activity " + r);
                if (sameComponent) {
                    if (r.app != null) {
                        r.app.removed = true;
                    }
                    r.app = null;
                }
                lastTask = r.task;
                if (!this.finishActivityLocked(r, 0, null, "force-stop", true)) continue;
                --numActivities;
                --activityNdx;
            }
        }
        return didSomething;
    }

    void getTasksLocked(List<ActivityManager.RunningTaskInfo> list, int callingUid, boolean allowed) {
        boolean focusedStack = this.mStackSupervisor.getFocusedStack() == this;
        boolean topTask = true;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            if (task.getTopActivity() == null) continue;
            ActivityRecord r = null;
            ActivityRecord top = null;
            int numActivities = 0;
            int numRunning = 0;
            ArrayList<ActivityRecord> activities = task.mActivities;
            if (!allowed && !task.isHomeTask() && task.effectiveUid != callingUid) continue;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord tmp = activities.get(activityNdx);
                if (tmp.finishing) continue;
                r = tmp;
                if (top == null || top.state == ActivityState.INITIALIZING) {
                    top = r;
                    numRunning = 0;
                    numActivities = 0;
                }
                ++numActivities;
                if (r.app == null || r.app.thread == null) continue;
                ++numRunning;
            }
            ActivityManager.RunningTaskInfo ci = new ActivityManager.RunningTaskInfo();
            ci.id = task.taskId;
            ci.stackId = this.mStackId;
            ci.baseActivity = r.intent.getComponent();
            ci.topActivity = top.intent.getComponent();
            ci.lastActiveTime = task.lastActiveTime;
            if (focusedStack && topTask) {
                ci.lastActiveTime = System.currentTimeMillis();
                topTask = false;
            }
            if (top.task != null) {
                ci.description = top.task.lastDescription;
            }
            ci.numActivities = numActivities;
            ci.numRunning = numRunning;
            ci.isDockable = task.canGoInDockedStack();
            ci.resizeMode = task.mResizeMode;
            list.add(ci);
        }
    }

    public void unhandledBackLocked() {
        ArrayList<ActivityRecord> activities;
        int activityTop;
        int top = this.mTaskHistory.size() - 1;
        if (top >= 0 && (activityTop = (activities = this.mTaskHistory.get((int)top).mActivities).size() - 1) > 0) {
            this.finishActivityLocked(activities.get(activityTop), 0, null, "unhandled-back", true);
        }
    }

    boolean handleAppDiedLocked(ProcessRecord app) {
        if (this.mPausingActivity != null && this.mPausingActivity.app == app) {
            this.mPausingActivity = null;
        }
        if (this.mLastPausedActivity != null && this.mLastPausedActivity.app == app) {
            this.mLastPausedActivity = null;
            this.mLastNoHistoryActivity = null;
        }
        return this.removeHistoryRecordsForAppLocked(app);
    }

    void handleAppCrashLocked(ProcessRecord app) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.app != app) continue;
                Slog.w("ActivityManager", "  Force finishing activity " + r.intent.getComponent().flattenToShortString());
                r.app = null;
                this.finishCurrentActivityLocked(r, 0, false);
            }
        }
    }

    boolean dumpActivitiesLocked(FileDescriptor fd, PrintWriter pw, boolean dumpAll, boolean dumpClient, String dumpPackage, boolean needSep, String header) {
        boolean printed = false;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            if (!(printed |= ActivityStackSupervisor.dumpHistoryList(fd, pw, this.mTaskHistory.get((int)taskNdx).mActivities, "    ", "Hist", true, !dumpAll, dumpClient, dumpPackage, needSep, header, "    Task id #" + task.taskId + "\n" + "    mFullscreen=" + task.mFullscreen + "\n" + "    mBounds=" + task.mBounds + "\n" + "    mMinWidth=" + task.mMinWidth + "\n" + "    mMinHeight=" + task.mMinHeight + "\n" + "    mLastNonFullscreenBounds=" + task.mLastNonFullscreenBounds))) continue;
            header = null;
        }
        return printed;
    }

    ArrayList<ActivityRecord> getDumpActivitiesLocked(String name) {
        ArrayList<ActivityRecord> activities;
        block4: {
            block5: {
                ArrayList<ActivityRecord> list;
                int listTop;
                block3: {
                    activities = new ArrayList<ActivityRecord>();
                    if (!"all".equals(name)) break block3;
                    for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
                        activities.addAll(this.mTaskHistory.get((int)taskNdx).mActivities);
                    }
                    break block4;
                }
                if (!"top".equals(name)) break block5;
                int top = this.mTaskHistory.size() - 1;
                if (top < 0 || (listTop = (list = this.mTaskHistory.get((int)top).mActivities).size() - 1) < 0) break block4;
                activities.add(list.get(listTop));
                break block4;
            }
            ActivityManagerService.ItemMatcher matcher = new ActivityManagerService.ItemMatcher();
            matcher.build(name);
            for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
                for (ActivityRecord r1 : this.mTaskHistory.get((int)taskNdx).mActivities) {
                    if (!matcher.match(r1, r1.intent.getComponent())) continue;
                    activities.add(r1);
                }
            }
        }
        return activities;
    }

    ActivityRecord restartPackage(String packageName) {
        ActivityRecord starting = this.topRunningActivityLocked();
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord a = activities.get(activityNdx);
                if (!a.info.packageName.equals(packageName)) continue;
                a.forceNewConfig = true;
                if (starting == null || a != starting || !a.visible) continue;
                a.startFreezingScreenLocked(starting.app, 256);
            }
        }
        return starting;
    }

    void removeTask(TaskRecord task, String reason) {
        this.removeTask(task, reason, 0);
    }

    void removeTask(TaskRecord task, String reason, int mode) {
        TaskRecord nextTask;
        ActivityRecord r;
        if (mode == 0) {
            this.mStackSupervisor.removeLockedTaskLocked(task);
            this.mWindowManager.removeTask(task.taskId);
            if (!ActivityManager.StackId.persistTaskBounds(this.mStackId)) {
                task.updateOverrideConfiguration(null);
            }
        }
        if ((r = this.mResumedActivity) != null && r.task == task) {
            this.mResumedActivity = null;
        }
        int taskNdx = this.mTaskHistory.indexOf(task);
        int topTaskNdx = this.mTaskHistory.size() - 1;
        if (task.isOverHomeStack() && taskNdx < topTaskNdx && !(nextTask = this.mTaskHistory.get(taskNdx + 1)).isOverHomeStack()) {
            nextTask.setTaskToReturnTo(1);
        }
        this.mTaskHistory.remove(task);
        this.updateTaskMovement(task, true);
        if (mode == 0 && task.mActivities.isEmpty()) {
            boolean isVoiceSession;
            boolean bl = isVoiceSession = task.voiceSession != null;
            if (isVoiceSession) {
                try {
                    task.voiceSession.taskFinished(task.intent, task.taskId);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            if (task.autoRemoveFromRecents() || isVoiceSession) {
                this.mRecentTasks.remove(task);
                task.removedFromRecents();
            }
        }
        if (this.mTaskHistory.isEmpty()) {
            if (this.isOnHomeDisplay() && mode != 2 && this.mStackSupervisor.isFocusedStack(this)) {
                String myReason = reason + " leftTaskHistoryEmpty";
                if (this.mFullscreen || !this.adjustFocusToNextFocusableStackLocked(task.getTaskToReturnTo(), myReason)) {
                    this.mStackSupervisor.moveHomeStackToFront(myReason);
                }
            }
            if (this.mStacks != null) {
                this.mStacks.remove(this);
                this.mStacks.add(0, this);
            }
            if (!this.isHomeStack()) {
                this.mActivityContainer.onTaskListEmptyLocked();
            }
        }
        task.stack = null;
    }

    TaskRecord createTaskRecord(int taskId, ActivityInfo info, Intent intent, IVoiceInteractionSession voiceSession, IVoiceInteractor voiceInteractor, boolean toTop) {
        boolean isLockscreenShown;
        TaskRecord task = new TaskRecord(this.mService, taskId, info, intent, voiceSession, voiceInteractor);
        this.addTask(task, toTop, "createTaskRecord");
        boolean bl = isLockscreenShown = this.mService.mLockScreenShown == 2;
        if (!this.layoutTaskInStack(task, info.windowLayout) && this.mBounds != null && task.isResizeable() && !isLockscreenShown) {
            task.updateOverrideConfiguration(this.mBounds);
        }
        return task;
    }

    boolean layoutTaskInStack(TaskRecord task, ActivityInfo.WindowLayout windowLayout) {
        if (this.mTaskPositioner == null) {
            return false;
        }
        this.mTaskPositioner.updateDefaultBounds(task, this.mTaskHistory, windowLayout);
        return true;
    }

    ArrayList<TaskRecord> getAllTasks() {
        return new ArrayList<TaskRecord>(this.mTaskHistory);
    }

    void addTask(TaskRecord task, boolean toTop, String reason) {
        ActivityStack prevStack = this.preAddTask(task, reason, toTop);
        task.stack = this;
        if (toTop) {
            this.insertTaskAtTop(task, null);
        } else {
            this.mTaskHistory.add(0, task);
            this.updateTaskMovement(task, false);
        }
        this.postAddTask(task, prevStack);
    }

    void positionTask(TaskRecord task, int position) {
        ActivityRecord topRunningActivity = task.topRunningActivityLocked();
        boolean wasResumed = topRunningActivity == task.stack.mResumedActivity;
        ActivityStack prevStack = this.preAddTask(task, "positionTask", false);
        task.stack = this;
        this.insertTaskAtPosition(task, position);
        this.postAddTask(task, prevStack);
        if (wasResumed) {
            if (this.mResumedActivity != null) {
                Log.wtf("ActivityManager", "mResumedActivity was already set when moving mResumedActivity from other stack to this stack mResumedActivity=" + this.mResumedActivity + " other mResumedActivity=" + topRunningActivity);
            }
            this.mResumedActivity = topRunningActivity;
        }
    }

    private ActivityStack preAddTask(TaskRecord task, String reason, boolean toTop) {
        ActivityStack prevStack = task.stack;
        if (prevStack != null && prevStack != this) {
            prevStack.removeTask(task, reason, toTop ? 2 : 1);
        }
        return prevStack;
    }

    private void postAddTask(TaskRecord task, ActivityStack prevStack) {
        if (prevStack != null) {
            this.mStackSupervisor.scheduleReportPictureInPictureModeChangedIfNeeded(task, prevStack);
        } else if (task.voiceSession != null) {
            try {
                task.voiceSession.taskStarted(task.intent, task.taskId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    void addConfigOverride(ActivityRecord r, TaskRecord task) {
        Rect bounds = task.updateOverrideConfigurationFromLaunchBounds();
        this.mWindowManager.addAppToken(task.mActivities.indexOf(r), r.appToken, r.task.taskId, this.mStackId, r.info.screenOrientation, r.fullscreen, (r.info.flags & 0x400) != 0, r.userId, r.info.configChanges, task.voiceSession != null, r.mLaunchTaskBehind, bounds, task.mOverrideConfig, task.mResizeMode, r.isAlwaysFocusable(), task.isHomeTask(), r.appInfo.targetSdkVersion, r.mRotationAnimationHint);
        r.taskConfigOverride = task.mOverrideConfig;
    }

    void moveToFrontAndResumeStateIfNeeded(ActivityRecord r, boolean moveToFront, boolean setResume, String reason) {
        if (!moveToFront) {
            return;
        }
        if (setResume) {
            this.mResumedActivity = r;
        }
        this.moveToFront(reason);
    }

    void moveActivityToStack(ActivityRecord r) {
        ActivityStack prevStack = r.task.stack;
        if (prevStack.mStackId == this.mStackId) {
            return;
        }
        boolean wasFocused = this.mStackSupervisor.isFocusedStack(prevStack) && this.mStackSupervisor.topRunningActivityLocked() == r;
        boolean wasResumed = wasFocused && prevStack.mResumedActivity == r;
        TaskRecord task = this.createTaskRecord(this.mStackSupervisor.getNextTaskIdForUserLocked(r.userId), r.info, r.intent, null, null, true);
        r.setTask(task, null);
        task.addActivityToTop(r);
        this.setAppTask(r, task);
        this.mStackSupervisor.scheduleReportPictureInPictureModeChangedIfNeeded(task, prevStack);
        this.moveToFrontAndResumeStateIfNeeded(r, wasFocused, wasResumed, "moveActivityToStack");
        if (wasResumed) {
            prevStack.mResumedActivity = null;
        }
    }

    private void setAppTask(ActivityRecord r, TaskRecord task) {
        Rect bounds = task.updateOverrideConfigurationFromLaunchBounds();
        this.mWindowManager.setAppTask(r.appToken, task.taskId, this.mStackId, bounds, task.mOverrideConfig, task.mResizeMode, task.isHomeTask());
        r.taskConfigOverride = task.mOverrideConfig;
    }

    public int getStackId() {
        return this.mStackId;
    }

    public String toString() {
        return "ActivityStack{" + Integer.toHexString(System.identityHashCode(this)) + " stackId=" + this.mStackId + ", " + this.mTaskHistory.size() + " tasks}";
    }

    void onLockTaskPackagesUpdatedLocked() {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            this.mTaskHistory.get(taskNdx).setLockTaskAuth();
        }
    }

    final class ActivityStackHandler
    extends Handler {
        ActivityStackHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 101: {
                    ActivityRecord r = (ActivityRecord)msg.obj;
                    Slog.w("ActivityManager", "Activity pause timeout for " + r);
                    ActivityManagerService activityManagerService = ActivityStack.this.mService;
                    synchronized (activityManagerService) {
                        if (r.app != null) {
                            ActivityStack.this.mService.logAppTooSlow(r.app, r.pauseTime, "pausing " + r);
                        }
                        ActivityStack.this.activityPausedLocked(r.appToken, true);
                        break;
                    }
                }
                case 103: {
                    ActivityRecord r = (ActivityRecord)msg.obj;
                    ActivityManagerService activityManagerService = ActivityStack.this.mService;
                    synchronized (activityManagerService) {
                        if (r.continueLaunchTickingLocked()) {
                            ActivityStack.this.mService.logAppTooSlow(r.app, r.launchTickTime, "launching " + r);
                        }
                        break;
                    }
                }
                case 102: {
                    ActivityRecord r = (ActivityRecord)msg.obj;
                    Slog.w("ActivityManager", "Activity destroy timeout for " + r);
                    ActivityManagerService activityManagerService = ActivityStack.this.mService;
                    synchronized (activityManagerService) {
                        ActivityStack.this.activityDestroyedLocked(r != null ? r.appToken : null, "destroyTimeout");
                        break;
                    }
                }
                case 104: {
                    ActivityRecord r = (ActivityRecord)msg.obj;
                    Slog.w("ActivityManager", "Activity stop timeout for " + r);
                    ActivityManagerService activityManagerService = ActivityStack.this.mService;
                    synchronized (activityManagerService) {
                        if (r.isInHistory()) {
                            ActivityStack.this.activityStoppedLocked(r, null, null, null);
                        }
                        break;
                    }
                }
                case 105: {
                    ScheduleDestroyArgs args = (ScheduleDestroyArgs)msg.obj;
                    ActivityManagerService activityManagerService = ActivityStack.this.mService;
                    synchronized (activityManagerService) {
                        ActivityStack.this.destroyActivitiesLocked(args.mOwner, args.mReason);
                        break;
                    }
                }
                case 106: {
                    ActivityManagerService activityManagerService = ActivityStack.this.mService;
                    synchronized (activityManagerService) {
                        ActivityStack.this.notifyActivityDrawnLocked(null);
                        break;
                    }
                }
                case 107: {
                    ActivityManagerService activityManagerService = ActivityStack.this.mService;
                    synchronized (activityManagerService) {
                        ActivityRecord r = ActivityStack.this.getVisibleBehindActivity();
                        Slog.e("ActivityManager", "Timeout waiting for cancelVisibleBehind player=" + r);
                        if (r != null) {
                            ActivityStack.this.mService.killAppAtUsersRequest(r.app, null);
                        }
                        break;
                    }
                }
            }
        }
    }

    static class ScheduleDestroyArgs {
        final ProcessRecord mOwner;
        final String mReason;

        ScheduleDestroyArgs(ProcessRecord owner, String reason) {
            this.mOwner = owner;
            this.mReason = reason;
        }
    }

    static enum ActivityState {
        INITIALIZING,
        RESUMED,
        PAUSING,
        PAUSED,
        STOPPING,
        STOPPED,
        FINISHING,
        DESTROYING,
        DESTROYED;

    }
}

