/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.AppGlobals;
import android.app.IActivityContainer;
import android.app.IActivityManager;
import android.app.IApplicationThread;
import android.app.KeyguardManager;
import android.app.ProfilerInfo;
import android.content.ComponentName;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.service.voice.IVoiceInteractionSession;
import android.util.EventLog;
import android.util.Slog;
import com.android.internal.app.HeavyWeightSwitcherActivity;
import com.android.internal.app.IVoiceInteractor;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ActivityStack;
import com.android.server.am.ActivityStackSupervisor;
import com.android.server.am.ActivityStartInterceptor;
import com.android.server.am.ProcessRecord;
import com.android.server.am.TaskRecord;
import com.android.server.wm.WindowManagerService;
import java.util.ArrayList;

class ActivityStarter {
    private static final String TAG = "ActivityManager";
    private static final String TAG_RESULTS = "ActivityManager";
    private static final String TAG_FOCUS = "ActivityManager";
    private static final String TAG_CONFIGURATION = "ActivityManager";
    private static final String TAG_USER_LEAVING = "ActivityManager";
    private final ActivityManagerService mService;
    private final ActivityStackSupervisor mSupervisor;
    private ActivityStartInterceptor mInterceptor;
    private WindowManagerService mWindowManager;
    final ArrayList<ActivityStackSupervisor.PendingActivityLaunch> mPendingActivityLaunches = new ArrayList();
    private ActivityRecord mStartActivity;
    private ActivityRecord mReusedActivity;
    private Intent mIntent;
    private int mCallingUid;
    private ActivityOptions mOptions;
    private boolean mLaunchSingleTop;
    private boolean mLaunchSingleInstance;
    private boolean mLaunchSingleTask;
    private boolean mLaunchTaskBehind;
    private int mLaunchFlags;
    private Rect mLaunchBounds;
    private ActivityRecord mNotTop;
    private boolean mDoResume;
    private int mStartFlags;
    private ActivityRecord mSourceRecord;
    private TaskRecord mInTask;
    private boolean mAddingToTask;
    private TaskRecord mReuseTask;
    private ActivityInfo mNewTaskInfo;
    private Intent mNewTaskIntent;
    private ActivityStack mSourceStack;
    private ActivityStack mTargetStack;
    private boolean mMovedOtherTask;
    private boolean mMovedToFront;
    private boolean mNoAnimation;
    private boolean mKeepCurTransition;
    private boolean mAvoidMoveToFront;
    private boolean mPowerHintSent;
    private IVoiceInteractionSession mVoiceSession;
    private IVoiceInteractor mVoiceInteractor;

    private void reset() {
        this.mStartActivity = null;
        this.mIntent = null;
        this.mCallingUid = -1;
        this.mOptions = null;
        this.mLaunchSingleTop = false;
        this.mLaunchSingleInstance = false;
        this.mLaunchSingleTask = false;
        this.mLaunchTaskBehind = false;
        this.mLaunchFlags = 0;
        this.mLaunchBounds = null;
        this.mNotTop = null;
        this.mDoResume = false;
        this.mStartFlags = 0;
        this.mSourceRecord = null;
        this.mInTask = null;
        this.mAddingToTask = false;
        this.mReuseTask = null;
        this.mNewTaskInfo = null;
        this.mNewTaskIntent = null;
        this.mSourceStack = null;
        this.mTargetStack = null;
        this.mMovedOtherTask = false;
        this.mMovedToFront = false;
        this.mNoAnimation = false;
        this.mKeepCurTransition = false;
        this.mAvoidMoveToFront = false;
        this.mVoiceSession = null;
        this.mVoiceInteractor = null;
    }

    ActivityStarter(ActivityManagerService service, ActivityStackSupervisor supervisor) {
        this.mService = service;
        this.mSupervisor = supervisor;
        this.mInterceptor = new ActivityStartInterceptor(this.mService, this.mSupervisor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int startActivityLocked(IApplicationThread caller, Intent intent, Intent ephemeralIntent, String resolvedType, ActivityInfo aInfo, ResolveInfo rInfo, IVoiceInteractionSession voiceSession, IVoiceInteractor voiceInteractor, IBinder resultTo, String resultWho, int requestCode, int callingPid, int callingUid, String callingPackage, int realCallingPid, int realCallingUid, int startFlags, ActivityOptions options, boolean ignoreTargetSecurity, boolean componentSpecified, ActivityRecord[] outActivity, ActivityStackSupervisor.ActivityContainer container, TaskRecord inTask) {
        ActivityStack resultStack;
        int launchFlags;
        int userId;
        int err = 0;
        ProcessRecord callerApp = null;
        if (caller != null) {
            callerApp = this.mService.getRecordForAppLocked(caller);
            if (callerApp != null) {
                callingPid = callerApp.pid;
                callingUid = callerApp.info.uid;
            } else {
                Slog.w("ActivityManager", "Unable to find app for caller " + caller + " (pid=" + callingPid + ") when starting: " + intent.toString());
                err = -4;
            }
        }
        int n = userId = aInfo != null ? UserHandle.getUserId(aInfo.applicationInfo.uid) : 0;
        if (err == 0) {
            Slog.i("ActivityManager", "START u" + userId + " {" + intent.toShortString(true, true, true, false) + "} from uid " + callingUid + " on display " + (container == null ? (this.mSupervisor.mFocusedStack == null ? 0 : this.mSupervisor.mFocusedStack.mDisplayId) : (container.mActivityDisplay == null ? 0 : container.mActivityDisplay.mDisplayId)));
        }
        ActivityRecord sourceRecord = null;
        ActivityRecord resultRecord = null;
        if (resultTo != null && (sourceRecord = this.mSupervisor.isInAnyStackLocked(resultTo)) != null && requestCode >= 0 && !sourceRecord.finishing) {
            resultRecord = sourceRecord;
        }
        if (((launchFlags = intent.getFlags()) & 0x2000000) != 0 && sourceRecord != null) {
            if (requestCode >= 0) {
                ActivityOptions.abort(options);
                return -3;
            }
            resultRecord = sourceRecord.resultTo;
            if (resultRecord != null && !resultRecord.isInStackLocked()) {
                resultRecord = null;
            }
            resultWho = sourceRecord.resultWho;
            requestCode = sourceRecord.requestCode;
            sourceRecord.resultTo = null;
            if (resultRecord != null) {
                resultRecord.removeResultsLocked(sourceRecord, resultWho, requestCode);
            }
            if (sourceRecord.launchedFromUid == callingUid) {
                callingPackage = sourceRecord.launchedFromPackage;
            }
        }
        if (err == 0 && intent.getComponent() == null) {
            err = -1;
        }
        if (err == 0 && aInfo == null) {
            err = -2;
        }
        if (err == 0 && sourceRecord != null && sourceRecord.task.voiceSession != null && (launchFlags & 0x10000000) == 0 && sourceRecord.info.applicationInfo.uid != aInfo.applicationInfo.uid) {
            try {
                intent.addCategory("android.intent.category.VOICE");
                if (!AppGlobals.getPackageManager().activitySupportsIntent(intent.getComponent(), intent, resolvedType)) {
                    Slog.w("ActivityManager", "Activity being started in current voice task does not support voice: " + intent);
                    err = -7;
                }
            }
            catch (RemoteException e) {
                Slog.w("ActivityManager", "Failure checking voice capabilities", e);
                err = -7;
            }
        }
        if (err == 0 && voiceSession != null) {
            try {
                if (!AppGlobals.getPackageManager().activitySupportsIntent(intent.getComponent(), intent, resolvedType)) {
                    Slog.w("ActivityManager", "Activity being started in new voice task does not support: " + intent);
                    err = -7;
                }
            }
            catch (RemoteException e) {
                Slog.w("ActivityManager", "Failure checking voice capabilities", e);
                err = -7;
            }
        }
        ActivityStack activityStack = resultStack = resultRecord == null ? null : resultRecord.task.stack;
        if (err != 0) {
            if (resultRecord != null) {
                resultStack.sendActivityResultLocked(-1, resultRecord, resultWho, requestCode, 0, null);
            }
            ActivityOptions.abort(options);
            return err;
        }
        boolean abort = !this.mSupervisor.checkStartAnyActivityPermission(intent, aInfo, resultWho, requestCode, callingPid, callingUid, callingPackage, ignoreTargetSecurity, callerApp, resultRecord, resultStack, options);
        abort |= !this.mService.mIntentFirewall.checkStartActivity(intent, callingUid, callingPid, resolvedType, aInfo.applicationInfo);
        if (this.mService.mController != null) {
            try {
                Intent watchIntent = intent.cloneFilter();
                abort |= !this.mService.mController.activityStarting(watchIntent, aInfo.applicationInfo.packageName);
            }
            catch (RemoteException e) {
                this.mService.mController = null;
            }
        }
        this.mInterceptor.setStates(userId, realCallingPid, realCallingUid, startFlags, callingPackage);
        this.mInterceptor.intercept(intent, rInfo, aInfo, resolvedType, inTask, callingPid, callingUid, options);
        intent = this.mInterceptor.mIntent;
        rInfo = this.mInterceptor.mRInfo;
        aInfo = this.mInterceptor.mAInfo;
        resolvedType = this.mInterceptor.mResolvedType;
        inTask = this.mInterceptor.mInTask;
        callingPid = this.mInterceptor.mCallingPid;
        callingUid = this.mInterceptor.mCallingUid;
        options = this.mInterceptor.mActivityOptions;
        if (abort) {
            if (resultRecord != null) {
                resultStack.sendActivityResultLocked(-1, resultRecord, resultWho, requestCode, 0, null);
            }
            ActivityOptions.abort(options);
            return 0;
        }
        if (Build.PERMISSIONS_REVIEW_REQUIRED && aInfo != null && this.mService.getPackageManagerInternalLocked().isPermissionsReviewRequired(aInfo.packageName, userId)) {
            IIntentSender target = this.mService.getIntentSenderLocked(2, callingPackage, callingUid, userId, null, null, 0, new Intent[]{intent}, new String[]{resolvedType}, 0x50000000, null);
            int flags = intent.getFlags();
            Intent newIntent = new Intent("android.intent.action.REVIEW_PERMISSIONS");
            newIntent.setFlags(flags | 0x800000);
            newIntent.putExtra("android.intent.extra.PACKAGE_NAME", aInfo.packageName);
            newIntent.putExtra("android.intent.extra.INTENT", new IntentSender(target));
            if (resultRecord != null) {
                newIntent.putExtra("android.intent.extra.RESULT_NEEDED", true);
            }
            intent = newIntent;
            resolvedType = null;
            callingUid = realCallingUid;
            callingPid = realCallingPid;
            rInfo = this.mSupervisor.resolveIntent(intent, resolvedType, userId);
            aInfo = this.mSupervisor.resolveActivity(intent, rInfo, startFlags, null);
        }
        if (rInfo != null && rInfo.ephemeralResolveInfo != null) {
            IIntentSender failureTarget = this.mService.getIntentSenderLocked(2, callingPackage, Binder.getCallingUid(), userId, null, null, 0, new Intent[]{intent}, new String[]{resolvedType}, 0x54000000, null);
            ephemeralIntent.setPackage(rInfo.ephemeralResolveInfo.getPackageName());
            IIntentSender ephemeralTarget = this.mService.getIntentSenderLocked(2, callingPackage, Binder.getCallingUid(), userId, null, null, 0, new Intent[]{ephemeralIntent}, new String[]{resolvedType}, 0x54000000, null);
            int flags = intent.getFlags();
            intent = new Intent();
            intent.setFlags(flags | 0x10000000 | 0x800000);
            intent.putExtra("android.intent.extra.PACKAGE_NAME", rInfo.ephemeralResolveInfo.getPackageName());
            intent.putExtra("android.intent.extra.EPHEMERAL_FAILURE", new IntentSender(failureTarget));
            intent.putExtra("android.intent.extra.EPHEMERAL_SUCCESS", new IntentSender(ephemeralTarget));
            resolvedType = null;
            callingUid = realCallingUid;
            callingPid = realCallingPid;
            rInfo = rInfo.ephemeralInstaller;
            aInfo = this.mSupervisor.resolveActivity(intent, rInfo, startFlags, null);
        }
        ActivityRecord r = new ActivityRecord(this.mService, callerApp, callingUid, callingPackage, intent, resolvedType, aInfo, this.mService.mConfiguration, resultRecord, resultWho, requestCode, componentSpecified, voiceSession != null, this.mSupervisor, container, options, sourceRecord);
        if (outActivity != null) {
            outActivity[0] = r;
        }
        if (r.appTimeTracker == null && sourceRecord != null) {
            r.appTimeTracker = sourceRecord.appTimeTracker;
        }
        ActivityStack stack = this.mSupervisor.mFocusedStack;
        if (!(voiceSession != null || stack.mResumedActivity != null && stack.mResumedActivity.info.applicationInfo.uid == callingUid || this.mService.checkAppSwitchAllowedLocked(callingPid, callingUid, realCallingPid, realCallingUid, "Activity start"))) {
            ActivityStackSupervisor.PendingActivityLaunch pal = new ActivityStackSupervisor.PendingActivityLaunch(r, sourceRecord, startFlags, stack, callerApp);
            this.mPendingActivityLaunches.add(pal);
            ActivityOptions.abort(options);
            return 4;
        }
        if (this.mService.mDidAppSwitch) {
            this.mService.mAppSwitchesAllowedTime = 0L;
        } else {
            this.mService.mDidAppSwitch = true;
        }
        this.doPendingActivityLaunchesLocked(false);
        try {
            this.mService.mWindowManager.deferSurfaceLayout();
            err = this.startActivityUnchecked(r, sourceRecord, voiceSession, voiceInteractor, startFlags, true, options, inTask);
        }
        finally {
            this.mService.mWindowManager.continueSurfaceLayout();
        }
        this.postStartActivityUncheckedProcessing(r, err, stack.mStackId, this.mSourceRecord, this.mTargetStack);
        return err;
    }

    void postStartActivityUncheckedProcessing(ActivityRecord r, int result, int prevFocusedStackId, ActivityRecord sourceRecord, ActivityStack targetStack) {
        boolean noDisplayActivityOverHome;
        if (result < 0) {
            this.mSupervisor.notifyActivityDrawnForKeyguard();
            return;
        }
        if (result == 2 && !this.mSupervisor.mWaitingActivityLaunched.isEmpty()) {
            this.mSupervisor.reportTaskToFrontNoLaunch(this.mStartActivity);
        }
        int startedActivityStackId = -1;
        if (r.task != null && r.task.stack != null) {
            startedActivityStackId = r.task.stack.mStackId;
        } else if (this.mTargetStack != null) {
            startedActivityStackId = targetStack.mStackId;
        }
        boolean bl = noDisplayActivityOverHome = sourceRecord != null && sourceRecord.noDisplay && sourceRecord.task.getTaskToReturnTo() == 1;
        if (startedActivityStackId == 3 && (prevFocusedStackId == 0 || noDisplayActivityOverHome)) {
            ActivityRecord topActivityHomeStack;
            ActivityStack homeStack = this.mSupervisor.getStack(0);
            ActivityRecord activityRecord = topActivityHomeStack = homeStack != null ? homeStack.topRunningActivityLocked() : null;
            if (topActivityHomeStack == null || topActivityHomeStack.mActivityType != 2) {
                this.mWindowManager.showRecentApps(true);
                return;
            }
        }
        if (startedActivityStackId == 4 && (result == 2 || result == 3)) {
            this.mService.notifyPinnedActivityRestartAttemptLocked();
            return;
        }
    }

    void startHomeActivityLocked(Intent intent, ActivityInfo aInfo, String reason) {
        this.mSupervisor.moveHomeStackTaskToTop(1, reason);
        this.startActivityLocked(null, intent, null, null, aInfo, null, null, null, null, null, 0, 0, 0, null, 0, 0, 0, null, false, false, null, null, null);
        if (this.mSupervisor.inResumeTopActivity) {
            this.mSupervisor.scheduleResumeTopActivities();
        }
    }

    void showConfirmDeviceCredential(int userId) {
        ActivityStack fullscreenStack = this.mSupervisor.getStack(1);
        ActivityStack freeformStack = this.mSupervisor.getStack(2);
        ActivityStack targetStack = fullscreenStack != null && fullscreenStack.getStackVisibilityLocked(null) != 0 ? fullscreenStack : (freeformStack != null && freeformStack.getStackVisibilityLocked(null) != 0 ? freeformStack : this.mSupervisor.getStack(0));
        if (targetStack == null) {
            return;
        }
        KeyguardManager km = (KeyguardManager)this.mService.mContext.getSystemService("keyguard");
        Intent credential = km.createConfirmDeviceCredentialIntent(null, null, userId);
        if (credential == null) {
            return;
        }
        ActivityRecord activityRecord = targetStack.topRunningActivityLocked();
        if (activityRecord != null) {
            IIntentSender target = this.mService.getIntentSenderLocked(2, activityRecord.launchedFromPackage, activityRecord.launchedFromUid, activityRecord.userId, null, null, 0, new Intent[]{activityRecord.intent}, new String[]{activityRecord.resolvedType}, 0x54000000, null);
            credential.putExtra("android.intent.extra.INTENT", new IntentSender(target));
            this.startConfirmCredentialIntent(credential);
        }
    }

    void startConfirmCredentialIntent(Intent intent) {
        intent.addFlags(276840448);
        ActivityOptions options = ActivityOptions.makeBasic();
        options.setLaunchTaskId(this.mSupervisor.getHomeActivity().task.taskId);
        this.mService.mContext.startActivityAsUser(intent, options.toBundle(), UserHandle.CURRENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int startActivityMayWait(IApplicationThread caller, int callingUid, String callingPackage, Intent intent, String resolvedType, IVoiceInteractionSession voiceSession, IVoiceInteractor voiceInteractor, IBinder resultTo, String resultWho, int requestCode, int startFlags, ProfilerInfo profilerInfo, IActivityManager.WaitResult outResult, Configuration config, Bundle bOptions, boolean ignoreTargetSecurity, int userId, IActivityContainer iContainer, TaskRecord inTask) {
        UserInfo userInfo;
        if (intent != null && intent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        this.mSupervisor.mActivityMetricsLogger.notifyActivityLaunching();
        boolean componentSpecified = intent.getComponent() != null;
        Intent ephemeralIntent = new Intent(intent);
        intent = new Intent(intent);
        ResolveInfo rInfo = this.mSupervisor.resolveIntent(intent, resolvedType, userId);
        if (rInfo == null && (userInfo = this.mSupervisor.getUserInfo(userId)) != null && userInfo.isManagedProfile()) {
            UserManager userManager = UserManager.get(this.mService.mContext);
            boolean profileLockedAndParentUnlockingOrUnlocked = false;
            long token = Binder.clearCallingIdentity();
            try {
                UserInfo parent = userManager.getProfileParent(userId);
                profileLockedAndParentUnlockingOrUnlocked = parent != null && userManager.isUserUnlockingOrUnlocked(parent.id) && !userManager.isUserUnlockingOrUnlocked(userId);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            if (profileLockedAndParentUnlockingOrUnlocked) {
                rInfo = this.mSupervisor.resolveIntent(intent, resolvedType, userId, 786432);
            }
        }
        ActivityInfo aInfo = this.mSupervisor.resolveActivity(intent, rInfo, startFlags, profilerInfo);
        ActivityOptions options = ActivityOptions.fromBundle(bOptions);
        ActivityStackSupervisor.ActivityContainer container = (ActivityStackSupervisor.ActivityContainer)iContainer;
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            ProcessRecord heavy;
            int callingPid;
            if (container != null && container.mParentActivity != null && container.mParentActivity.state != ActivityStack.ActivityState.RESUMED) {
                return -6;
            }
            int realCallingPid = Binder.getCallingPid();
            int realCallingUid = Binder.getCallingUid();
            if (callingUid >= 0) {
                callingPid = -1;
            } else if (caller == null) {
                callingPid = realCallingPid;
                callingUid = realCallingUid;
            } else {
                callingUid = -1;
                callingPid = -1;
            }
            ActivityStack stack = container == null || container.mStack.isOnHomeDisplay() ? this.mSupervisor.mFocusedStack : container.mStack;
            stack.mConfigWillChange = config != null && this.mService.mConfiguration.diff(config) != 0;
            long origId = Binder.clearCallingIdentity();
            if (aInfo != null && (aInfo.applicationInfo.privateFlags & 2) != 0 && aInfo.processName.equals(aInfo.applicationInfo.packageName) && (heavy = this.mService.mHeavyWeightProcess) != null && (heavy.info.uid != aInfo.applicationInfo.uid || !heavy.processName.equals(aInfo.processName))) {
                int appCallingUid = callingUid;
                if (caller != null) {
                    ProcessRecord callerApp = this.mService.getRecordForAppLocked(caller);
                    if (callerApp != null) {
                        appCallingUid = callerApp.info.uid;
                    } else {
                        Slog.w("ActivityManager", "Unable to find app for caller " + caller + " (pid=" + callingPid + ") when starting: " + intent.toString());
                        ActivityOptions.abort(options);
                        return -4;
                    }
                }
                IIntentSender target = this.mService.getIntentSenderLocked(2, "android", appCallingUid, userId, null, null, 0, new Intent[]{intent}, new String[]{resolvedType}, 0x50000000, null);
                Intent newIntent = new Intent();
                if (requestCode >= 0) {
                    newIntent.putExtra("has_result", true);
                }
                newIntent.putExtra("intent", new IntentSender(target));
                if (heavy.activities.size() > 0) {
                    ActivityRecord hist = heavy.activities.get(0);
                    newIntent.putExtra("cur_app", hist.packageName);
                    newIntent.putExtra("cur_task", hist.task.taskId);
                }
                newIntent.putExtra("new_app", aInfo.packageName);
                newIntent.setFlags(intent.getFlags());
                newIntent.setClassName("android", HeavyWeightSwitcherActivity.class.getName());
                intent = newIntent;
                resolvedType = null;
                caller = null;
                callingUid = Binder.getCallingUid();
                callingPid = Binder.getCallingPid();
                componentSpecified = true;
                rInfo = this.mSupervisor.resolveIntent(intent, null, userId);
                ActivityInfo activityInfo = aInfo = rInfo != null ? rInfo.activityInfo : null;
                if (aInfo != null) {
                    aInfo = this.mService.getActivityInfoForUser(aInfo, userId);
                }
            }
            ActivityRecord[] outRecord = new ActivityRecord[1];
            int res = this.startActivityLocked(caller, intent, ephemeralIntent, resolvedType, aInfo, rInfo, voiceSession, voiceInteractor, resultTo, resultWho, requestCode, callingPid, callingUid, callingPackage, realCallingPid, realCallingUid, startFlags, options, ignoreTargetSecurity, componentSpecified, outRecord, container, inTask);
            Binder.restoreCallingIdentity(origId);
            if (stack.mConfigWillChange) {
                this.mService.enforceCallingPermission("android.permission.CHANGE_CONFIGURATION", "updateConfiguration()");
                stack.mConfigWillChange = false;
                this.mService.updateConfigurationLocked(config, null, false);
            }
            if (outResult != null) {
                outResult.result = res;
                if (res == 0) {
                    this.mSupervisor.mWaitingActivityLaunched.add(outResult);
                    do {
                        try {
                            this.mService.wait();
                        }
                        catch (InterruptedException target) {
                            // empty catch block
                        }
                    } while (outResult.result != 2 && !outResult.timeout && outResult.who == null);
                    if (outResult.result == 2) {
                        res = 2;
                    }
                }
                if (res == 2) {
                    ActivityRecord r = stack.topRunningActivityLocked();
                    if (r.nowVisible && r.state == ActivityStack.ActivityState.RESUMED) {
                        outResult.timeout = false;
                        outResult.who = new ComponentName(r.info.packageName, r.info.name);
                        outResult.totalTime = 0L;
                        outResult.thisTime = 0L;
                    } else {
                        outResult.thisTime = SystemClock.uptimeMillis();
                        this.mSupervisor.mWaitingActivityVisible.add(outResult);
                        do {
                            try {
                                this.mService.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (!outResult.timeout && outResult.who == null);
                    }
                }
            }
            ActivityRecord launchedActivity = this.mReusedActivity != null ? this.mReusedActivity : outRecord[0];
            this.mSupervisor.mActivityMetricsLogger.notifyActivityLaunched(res, launchedActivity);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int startActivities(IApplicationThread caller, int callingUid, String callingPackage, Intent[] intents, String[] resolvedTypes, IBinder resultTo, Bundle bOptions, int userId) {
        int callingPid;
        if (intents == null) {
            throw new NullPointerException("intents is null");
        }
        if (resolvedTypes == null) {
            throw new NullPointerException("resolvedTypes is null");
        }
        if (intents.length != resolvedTypes.length) {
            throw new IllegalArgumentException("intents are length different than resolvedTypes");
        }
        int realCallingPid = Binder.getCallingPid();
        int realCallingUid = Binder.getCallingUid();
        if (callingUid >= 0) {
            callingPid = -1;
        } else if (caller == null) {
            callingPid = realCallingPid;
            callingUid = realCallingUid;
        } else {
            callingUid = -1;
            callingPid = -1;
        }
        long origId = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this.mService;
            synchronized (activityManagerService) {
                ActivityRecord[] outActivity = new ActivityRecord[1];
                for (int i = 0; i < intents.length; ++i) {
                    Intent intent = intents[i];
                    if (intent == null) continue;
                    if (intent != null && intent.hasFileDescriptors()) {
                        throw new IllegalArgumentException("File descriptors passed in Intent");
                    }
                    boolean componentSpecified = intent.getComponent() != null;
                    intent = new Intent(intent);
                    ActivityInfo aInfo = this.mSupervisor.resolveActivity(intent, resolvedTypes[i], 0, null, userId);
                    if ((aInfo = this.mService.getActivityInfoForUser(aInfo, userId)) != null && (aInfo.applicationInfo.privateFlags & 2) != 0) {
                        throw new IllegalArgumentException("FLAG_CANT_SAVE_STATE not supported here");
                    }
                    ActivityOptions options = ActivityOptions.fromBundle(i == intents.length - 1 ? bOptions : null);
                    int res = this.startActivityLocked(caller, intent, null, resolvedTypes[i], aInfo, null, null, null, resultTo, null, -1, callingPid, callingUid, callingPackage, realCallingPid, realCallingUid, 0, options, false, componentSpecified, outActivity, null, null);
                    if (res < 0) {
                        int n = res;
                        return n;
                    }
                    resultTo = outActivity[0] != null ? outActivity[0].appToken : null;
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
        {
            return 0;
        }
    }

    void sendPowerHintForLaunchStartIfNeeded(boolean forceSend) {
        ActivityRecord curTop;
        ActivityStack focusStack = this.mSupervisor.getFocusedStack();
        ActivityRecord activityRecord = curTop = focusStack == null ? null : focusStack.topRunningNonDelayedActivityLocked(this.mNotTop);
        if ((forceSend || !this.mPowerHintSent && curTop != null && curTop.task != null && this.mStartActivity != null && curTop.task != this.mStartActivity.task) && this.mService.mLocalPowerManager != null) {
            this.mService.mLocalPowerManager.powerHint(8, 1);
            this.mPowerHintSent = true;
        }
    }

    void sendPowerHintForLaunchEndIfNeeded() {
        if (this.mPowerHintSent && this.mService.mLocalPowerManager != null) {
            this.mService.mLocalPowerManager.powerHint(8, 0);
            this.mPowerHintSent = false;
        }
    }

    private int startActivityUnchecked(ActivityRecord r, ActivityRecord sourceRecord, IVoiceInteractionSession voiceSession, IVoiceInteractor voiceInteractor, int startFlags, boolean doResume, ActivityOptions options, TaskRecord inTask) {
        int result;
        TaskRecord taskToAffiliate;
        boolean dontStart;
        int preferredLaunchStackId;
        this.setInitialState(r, options, inTask, doResume, startFlags, sourceRecord, voiceSession, voiceInteractor);
        this.computeLaunchingTaskFlags();
        this.computeSourceStack();
        this.mIntent.setFlags(this.mLaunchFlags);
        this.mReusedActivity = this.getReusableIntentActivity();
        int n = preferredLaunchStackId = this.mOptions != null ? this.mOptions.getLaunchStackId() : -1;
        if (this.mReusedActivity != null) {
            ActivityRecord top;
            if (this.mSupervisor.isLockTaskModeViolation(this.mReusedActivity.task, (this.mLaunchFlags & 0x10008000) == 0x10008000)) {
                this.mSupervisor.showLockTaskToast();
                Slog.e("ActivityManager", "startActivityUnchecked: Attempt to violate Lock Task Mode");
                return 5;
            }
            if (this.mStartActivity.task == null) {
                this.mStartActivity.task = this.mReusedActivity.task;
            }
            if (this.mReusedActivity.task.intent == null) {
                this.mReusedActivity.task.setIntent(this.mStartActivity);
            }
            if (((this.mLaunchFlags & 0x4000000) != 0 || this.mLaunchSingleInstance || this.mLaunchSingleTask) && (top = this.mReusedActivity.task.performClearTaskForReuseLocked(this.mStartActivity, this.mLaunchFlags)) != null) {
                if (top.frontOfTask) {
                    top.task.setIntent(this.mStartActivity);
                }
                ActivityStack.logStartActivity(30003, this.mStartActivity, top.task);
                top.deliverNewIntentLocked(this.mCallingUid, this.mStartActivity.intent, this.mStartActivity.launchedFromPackage);
            }
            this.sendPowerHintForLaunchStartIfNeeded(false);
            this.mReusedActivity = this.setTargetStackAndMoveToFrontIfNeeded(this.mReusedActivity);
            if ((this.mStartFlags & 1) != 0) {
                this.resumeTargetStackIfNeeded();
                return 1;
            }
            this.setTaskFromIntentActivity(this.mReusedActivity);
            if (!this.mAddingToTask && this.mReuseTask == null) {
                this.resumeTargetStackIfNeeded();
                return 2;
            }
        }
        if (this.mStartActivity.packageName == null) {
            if (this.mStartActivity.resultTo != null && this.mStartActivity.resultTo.task.stack != null) {
                this.mStartActivity.resultTo.task.stack.sendActivityResultLocked(-1, this.mStartActivity.resultTo, this.mStartActivity.resultWho, this.mStartActivity.requestCode, 0, null);
            }
            ActivityOptions.abort(this.mOptions);
            return -2;
        }
        ActivityStack topStack = this.mSupervisor.mFocusedStack;
        ActivityRecord top = topStack.topRunningNonDelayedActivityLocked(this.mNotTop);
        boolean bl = dontStart = top != null && this.mStartActivity.resultTo == null && top.realActivity.equals(this.mStartActivity.realActivity) && top.userId == this.mStartActivity.userId && top.app != null && top.app.thread != null && ((this.mLaunchFlags & 0x20000000) != 0 || this.mLaunchSingleTop || this.mLaunchSingleTask);
        if (dontStart) {
            ActivityStack.logStartActivity(30003, top, top.task);
            topStack.mLastPausedActivity = null;
            if (this.mDoResume) {
                this.mSupervisor.resumeFocusedStackTopActivityLocked();
            }
            ActivityOptions.abort(this.mOptions);
            if ((this.mStartFlags & 1) != 0) {
                return 1;
            }
            top.deliverNewIntentLocked(this.mCallingUid, this.mStartActivity.intent, this.mStartActivity.launchedFromPackage);
            this.mSupervisor.handleNonResizableTaskIfNeeded(top.task, preferredLaunchStackId, topStack.mStackId);
            return 3;
        }
        boolean newTask = false;
        TaskRecord taskRecord = taskToAffiliate = this.mLaunchTaskBehind && this.mSourceRecord != null ? this.mSourceRecord.task : null;
        if (this.mStartActivity.resultTo == null && this.mInTask == null && !this.mAddingToTask && (this.mLaunchFlags & 0x10000000) != 0) {
            newTask = true;
            this.setTaskFromReuseOrCreateNewTask(taskToAffiliate);
            if (this.mSupervisor.isLockTaskModeViolation(this.mStartActivity.task)) {
                Slog.e("ActivityManager", "Attempted Lock Task Mode violation mStartActivity=" + this.mStartActivity);
                return 5;
            }
            if (!this.mMovedOtherTask) {
                this.updateTaskReturnToType(this.mStartActivity.task, this.mLaunchFlags, preferredLaunchStackId != -1 ? this.mTargetStack : topStack);
            }
        } else if (this.mSourceRecord != null) {
            if (this.mSupervisor.isLockTaskModeViolation(this.mSourceRecord.task)) {
                Slog.e("ActivityManager", "Attempted Lock Task Mode violation mStartActivity=" + this.mStartActivity);
                return 5;
            }
            result = this.setTaskFromSourceRecord();
            if (result != 0) {
                return result;
            }
        } else if (this.mInTask != null) {
            if (this.mSupervisor.isLockTaskModeViolation(this.mInTask)) {
                Slog.e("ActivityManager", "Attempted Lock Task Mode violation mStartActivity=" + this.mStartActivity);
                return 5;
            }
            result = this.setTaskFromInTask();
            if (result != 0) {
                return result;
            }
        } else {
            this.setTaskToCurrentTopOrCreateNewTask();
        }
        this.mService.grantUriPermissionFromIntentLocked(this.mCallingUid, this.mStartActivity.packageName, this.mIntent, this.mStartActivity.getUriPermissionsLocked(), this.mStartActivity.userId);
        if (this.mSourceRecord != null && this.mSourceRecord.isRecentsActivity()) {
            this.mStartActivity.task.setTaskToReturnTo(2);
        }
        if (newTask) {
            EventLog.writeEvent(30004, this.mStartActivity.userId, this.mStartActivity.task.taskId);
        }
        ActivityStack.logStartActivity(30005, this.mStartActivity, this.mStartActivity.task);
        this.mTargetStack.mLastPausedActivity = null;
        this.sendPowerHintForLaunchStartIfNeeded(false);
        this.mTargetStack.startActivityLocked(this.mStartActivity, newTask, this.mKeepCurTransition, this.mOptions);
        if (this.mDoResume) {
            if (!this.mLaunchTaskBehind) {
                this.mService.setFocusedActivityLocked(this.mStartActivity, "startedActivity");
            }
            ActivityRecord topTaskActivity = this.mStartActivity.task.topRunningActivityLocked();
            if (!this.mTargetStack.isFocusable() || topTaskActivity != null && topTaskActivity.mTaskOverlay && this.mStartActivity != topTaskActivity) {
                this.mTargetStack.ensureActivitiesVisibleLocked(null, 0, false);
                this.mWindowManager.executeAppTransition();
            } else {
                this.mSupervisor.resumeFocusedStackTopActivityLocked(this.mTargetStack, this.mStartActivity, this.mOptions);
            }
        } else {
            this.mTargetStack.addRecentActivityLocked(this.mStartActivity);
        }
        this.mSupervisor.updateUserStackLocked(this.mStartActivity.userId, this.mTargetStack);
        this.mSupervisor.handleNonResizableTaskIfNeeded(this.mStartActivity.task, preferredLaunchStackId, this.mTargetStack.mStackId);
        return 0;
    }

    private void setInitialState(ActivityRecord r, ActivityOptions options, TaskRecord inTask, boolean doResume, int startFlags, ActivityRecord sourceRecord, IVoiceInteractionSession voiceSession, IVoiceInteractor voiceInteractor) {
        this.reset();
        this.mStartActivity = r;
        this.mIntent = r.intent;
        this.mOptions = options;
        this.mCallingUid = r.launchedFromUid;
        this.mSourceRecord = sourceRecord;
        this.mVoiceSession = voiceSession;
        this.mVoiceInteractor = voiceInteractor;
        this.mLaunchBounds = this.getOverrideBounds(r, options, inTask);
        this.mLaunchSingleTop = r.launchMode == 1;
        this.mLaunchSingleInstance = r.launchMode == 3;
        this.mLaunchSingleTask = r.launchMode == 2;
        this.mLaunchFlags = this.adjustLaunchFlagsToDocumentMode(r, this.mLaunchSingleInstance, this.mLaunchSingleTask, this.mIntent.getFlags());
        this.mLaunchTaskBehind = r.mLaunchTaskBehind && !this.mLaunchSingleTask && !this.mLaunchSingleInstance && (this.mLaunchFlags & 0x80000) != 0;
        this.sendNewTaskResultRequestIfNeeded();
        if ((this.mLaunchFlags & 0x80000) != 0 && r.resultTo == null) {
            this.mLaunchFlags |= 0x10000000;
        }
        if ((this.mLaunchFlags & 0x10000000) != 0 && (this.mLaunchTaskBehind || r.info.documentLaunchMode == 2)) {
            this.mLaunchFlags |= 0x8000000;
        }
        this.mSupervisor.mUserLeaving = (this.mLaunchFlags & 0x40000) == 0;
        this.mDoResume = doResume;
        if (!doResume || !this.mSupervisor.okToShowLocked(r)) {
            r.delayedResume = true;
            this.mDoResume = false;
        }
        if (this.mOptions != null && this.mOptions.getLaunchTaskId() != -1 && this.mOptions.getTaskOverlay()) {
            ActivityRecord top;
            r.mTaskOverlay = true;
            TaskRecord task = this.mSupervisor.anyTaskForIdLocked(this.mOptions.getLaunchTaskId());
            ActivityRecord activityRecord = top = task != null ? task.getTopActivity() : null;
            if (top != null && !top.visible) {
                this.mDoResume = false;
                this.mAvoidMoveToFront = true;
            }
        }
        this.mNotTop = (this.mLaunchFlags & 0x1000000) != 0 ? r : null;
        this.mInTask = inTask;
        if (inTask != null && !inTask.inRecents) {
            Slog.w("ActivityManager", "Starting activity in task not in recents: " + inTask);
            this.mInTask = null;
        }
        this.mStartFlags = startFlags;
        if ((startFlags & 1) != 0) {
            ActivityRecord checkedCaller = sourceRecord;
            if (checkedCaller == null) {
                checkedCaller = this.mSupervisor.mFocusedStack.topRunningNonDelayedActivityLocked(this.mNotTop);
            }
            if (!checkedCaller.realActivity.equals(r.realActivity)) {
                this.mStartFlags &= 0xFFFFFFFE;
            }
        }
        this.mNoAnimation = (this.mLaunchFlags & 0x10000) != 0;
    }

    private void sendNewTaskResultRequestIfNeeded() {
        if (this.mStartActivity.resultTo != null && (this.mLaunchFlags & 0x10000000) != 0 && this.mStartActivity.resultTo.task.stack != null) {
            Slog.w("ActivityManager", "Activity is launching as a new task, so cancelling activity result.");
            this.mStartActivity.resultTo.task.stack.sendActivityResultLocked(-1, this.mStartActivity.resultTo, this.mStartActivity.resultWho, this.mStartActivity.requestCode, 0, null);
            this.mStartActivity.resultTo = null;
        }
    }

    private void computeLaunchingTaskFlags() {
        if (this.mSourceRecord == null && this.mInTask != null && this.mInTask.stack != null) {
            Intent baseIntent = this.mInTask.getBaseIntent();
            ActivityRecord root = this.mInTask.getRootActivity();
            if (baseIntent == null) {
                ActivityOptions.abort(this.mOptions);
                throw new IllegalArgumentException("Launching into task without base intent: " + this.mInTask);
            }
            if (this.mLaunchSingleInstance || this.mLaunchSingleTask) {
                if (!baseIntent.getComponent().equals(this.mStartActivity.intent.getComponent())) {
                    ActivityOptions.abort(this.mOptions);
                    throw new IllegalArgumentException("Trying to launch singleInstance/Task " + this.mStartActivity + " into different task " + this.mInTask);
                }
                if (root != null) {
                    ActivityOptions.abort(this.mOptions);
                    throw new IllegalArgumentException("Caller with mInTask " + this.mInTask + " has root " + root + " but target is singleInstance/Task");
                }
            }
            if (root == null) {
                int flagsOfInterest = 403185664;
                this.mLaunchFlags = this.mLaunchFlags & 0xE7F7DFFF | baseIntent.getFlags() & 0x18082000;
                this.mIntent.setFlags(this.mLaunchFlags);
                this.mInTask.setIntent(this.mStartActivity);
                this.mAddingToTask = true;
            } else {
                this.mAddingToTask = (this.mLaunchFlags & 0x10000000) == 0;
            }
            this.mReuseTask = this.mInTask;
        } else {
            this.mInTask = null;
            if ((this.mStartActivity.isResolverActivity() || this.mStartActivity.noDisplay) && this.mSourceRecord != null && this.mSourceRecord.isFreeform()) {
                this.mAddingToTask = true;
            }
        }
        if (this.mInTask == null) {
            if (this.mSourceRecord == null) {
                if ((this.mLaunchFlags & 0x10000000) == 0 && this.mInTask == null) {
                    Slog.w("ActivityManager", "startActivity called from non-Activity context; forcing Intent.FLAG_ACTIVITY_NEW_TASK for: " + this.mIntent);
                    this.mLaunchFlags |= 0x10000000;
                }
            } else if (this.mSourceRecord.launchMode == 3) {
                this.mLaunchFlags |= 0x10000000;
            } else if (this.mLaunchSingleInstance || this.mLaunchSingleTask) {
                this.mLaunchFlags |= 0x10000000;
            }
        }
    }

    private void computeSourceStack() {
        if (this.mSourceRecord == null) {
            this.mSourceStack = null;
            return;
        }
        if (!this.mSourceRecord.finishing) {
            this.mSourceStack = this.mSourceRecord.task.stack;
            return;
        }
        if ((this.mLaunchFlags & 0x10000000) == 0) {
            Slog.w("ActivityManager", "startActivity called from finishing " + this.mSourceRecord + "; forcing " + "Intent.FLAG_ACTIVITY_NEW_TASK for: " + this.mIntent);
            this.mLaunchFlags |= 0x10000000;
            this.mNewTaskInfo = this.mSourceRecord.info;
            this.mNewTaskIntent = this.mSourceRecord.task.intent;
        }
        this.mSourceRecord = null;
        this.mSourceStack = null;
    }

    private ActivityRecord getReusableIntentActivity() {
        boolean putIntoExistingTask = (this.mLaunchFlags & 0x10000000) != 0 && (this.mLaunchFlags & 0x8000000) == 0 || this.mLaunchSingleInstance || this.mLaunchSingleTask;
        putIntoExistingTask &= this.mInTask == null && this.mStartActivity.resultTo == null;
        ActivityRecord intentActivity = null;
        if (this.mOptions != null && this.mOptions.getLaunchTaskId() != -1) {
            TaskRecord task = this.mSupervisor.anyTaskForIdLocked(this.mOptions.getLaunchTaskId());
            intentActivity = task != null ? task.getTopActivity() : null;
        } else if (putIntoExistingTask) {
            intentActivity = this.mLaunchSingleInstance ? this.mSupervisor.findActivityLocked(this.mIntent, this.mStartActivity.info, false) : ((this.mLaunchFlags & 0x1000) != 0 ? this.mSupervisor.findActivityLocked(this.mIntent, this.mStartActivity.info, !this.mLaunchSingleTask) : this.mSupervisor.findTaskLocked(this.mStartActivity));
        }
        return intentActivity;
    }

    private ActivityRecord setTargetStackAndMoveToFrontIfNeeded(ActivityRecord intentActivity) {
        ActivityRecord curTop;
        this.mTargetStack = intentActivity.task.stack;
        this.mTargetStack.mLastPausedActivity = null;
        ActivityStack focusStack = this.mSupervisor.getFocusedStack();
        ActivityRecord activityRecord = curTop = focusStack == null ? null : focusStack.topRunningNonDelayedActivityLocked(this.mNotTop);
        if (!(curTop == null || curTop.task == intentActivity.task && curTop.task == focusStack.topTask() || this.mAvoidMoveToFront)) {
            this.mStartActivity.intent.addFlags(0x400000);
            if (this.mSourceRecord == null || this.mSourceStack.topActivity() != null && this.mSourceStack.topActivity().task == this.mSourceRecord.task) {
                boolean willClearTask;
                if (this.mLaunchTaskBehind && this.mSourceRecord != null) {
                    intentActivity.setTaskToAffiliateWith(this.mSourceRecord.task);
                }
                this.mMovedOtherTask = true;
                boolean bl = willClearTask = (this.mLaunchFlags & 0x10008000) == 0x10008000;
                if (!willClearTask) {
                    ActivityStack launchStack = this.getLaunchStack(this.mStartActivity, this.mLaunchFlags, this.mStartActivity.task, this.mOptions);
                    if (launchStack == null || launchStack == this.mTargetStack) {
                        this.mTargetStack.moveTaskToFrontLocked(intentActivity.task, this.mNoAnimation, this.mOptions, this.mStartActivity.appTimeTracker, "bringingFoundTaskToFront");
                        this.mMovedToFront = true;
                    } else if (launchStack.mStackId == 3 || launchStack.mStackId == 1) {
                        if ((this.mLaunchFlags & 0x1000) != 0) {
                            this.mSupervisor.moveTaskToStackLocked(intentActivity.task.taskId, launchStack.mStackId, true, true, "launchToSide", true);
                        } else {
                            this.mTargetStack.moveTaskToFrontLocked(intentActivity.task, this.mNoAnimation, this.mOptions, this.mStartActivity.appTimeTracker, "bringToFrontInsteadOfAdjacentLaunch");
                        }
                        this.mMovedToFront = true;
                    }
                    this.mOptions = null;
                }
                this.updateTaskReturnToType(intentActivity.task, this.mLaunchFlags, focusStack);
            }
        }
        if (!this.mMovedToFront && this.mDoResume) {
            this.mTargetStack.moveToFront("intentActivityFound");
        }
        this.mSupervisor.handleNonResizableTaskIfNeeded(intentActivity.task, -1, this.mTargetStack.mStackId);
        if ((this.mLaunchFlags & 0x200000) != 0) {
            return this.mTargetStack.resetTaskIfNeededLocked(intentActivity, this.mStartActivity);
        }
        return intentActivity;
    }

    private void updateTaskReturnToType(TaskRecord task, int launchFlags, ActivityStack focusedStack) {
        if ((launchFlags & 0x10004000) == 0x10004000) {
            task.setTaskToReturnTo(1);
            return;
        }
        if (focusedStack == null || focusedStack.mStackId == 0) {
            task.setTaskToReturnTo(1);
            return;
        }
        task.setTaskToReturnTo(0);
    }

    private void setTaskFromIntentActivity(ActivityRecord intentActivity) {
        if ((this.mLaunchFlags & 0x10008000) == 0x10008000) {
            this.mReuseTask = intentActivity.task;
            this.mReuseTask.performClearTaskLocked();
            this.mReuseTask.setIntent(this.mStartActivity);
            this.mMovedOtherTask = true;
        } else if ((this.mLaunchFlags & 0x4000000) != 0 || this.mLaunchSingleInstance || this.mLaunchSingleTask) {
            ActivityRecord top = intentActivity.task.performClearTaskLocked(this.mStartActivity, this.mLaunchFlags);
            if (top == null) {
                this.mAddingToTask = true;
                this.mSourceRecord = intentActivity;
                TaskRecord task = this.mSourceRecord.task;
                if (task != null && task.stack == null) {
                    this.mTargetStack = this.computeStackFocus(this.mSourceRecord, false, null, this.mLaunchFlags, this.mOptions);
                    this.mTargetStack.addTask(task, !this.mLaunchTaskBehind, "startActivityUnchecked");
                }
            }
        } else if (this.mStartActivity.realActivity.equals(intentActivity.task.realActivity)) {
            if (((this.mLaunchFlags & 0x20000000) != 0 || this.mLaunchSingleTop) && intentActivity.realActivity.equals(this.mStartActivity.realActivity)) {
                ActivityStack.logStartActivity(30003, this.mStartActivity, intentActivity.task);
                if (intentActivity.frontOfTask) {
                    intentActivity.task.setIntent(this.mStartActivity);
                }
                intentActivity.deliverNewIntentLocked(this.mCallingUid, this.mStartActivity.intent, this.mStartActivity.launchedFromPackage);
            } else if (!intentActivity.task.isSameIntentFilter(this.mStartActivity)) {
                this.mAddingToTask = true;
                this.mSourceRecord = intentActivity;
            }
        } else if ((this.mLaunchFlags & 0x200000) == 0) {
            this.mAddingToTask = true;
            this.mSourceRecord = intentActivity;
        } else if (!intentActivity.task.rootWasReset) {
            intentActivity.task.setIntent(this.mStartActivity);
        }
    }

    private void resumeTargetStackIfNeeded() {
        if (this.mDoResume) {
            this.mSupervisor.resumeFocusedStackTopActivityLocked(this.mTargetStack, null, this.mOptions);
            if (!this.mMovedToFront) {
                this.mSupervisor.notifyActivityDrawnForKeyguard();
            }
        } else {
            ActivityOptions.abort(this.mOptions);
        }
        this.mSupervisor.updateUserStackLocked(this.mStartActivity.userId, this.mTargetStack);
    }

    private void setTaskFromReuseOrCreateNewTask(TaskRecord taskToAffiliate) {
        this.mTargetStack = this.computeStackFocus(this.mStartActivity, true, this.mLaunchBounds, this.mLaunchFlags, this.mOptions);
        if (this.mReuseTask == null) {
            TaskRecord task = this.mTargetStack.createTaskRecord(this.mSupervisor.getNextTaskIdForUserLocked(this.mStartActivity.userId), this.mNewTaskInfo != null ? this.mNewTaskInfo : this.mStartActivity.info, this.mNewTaskIntent != null ? this.mNewTaskIntent : this.mIntent, this.mVoiceSession, this.mVoiceInteractor, !this.mLaunchTaskBehind);
            this.mStartActivity.setTask(task, taskToAffiliate);
            if (this.mLaunchBounds != null) {
                int stackId = this.mTargetStack.mStackId;
                if (ActivityManager.StackId.resizeStackWithLaunchBounds(stackId)) {
                    this.mService.resizeStack(stackId, this.mLaunchBounds, true, false, true, -1);
                } else {
                    this.mStartActivity.task.updateOverrideConfiguration(this.mLaunchBounds);
                }
            }
        } else {
            this.mStartActivity.setTask(this.mReuseTask, taskToAffiliate);
        }
    }

    private int setTaskFromSourceRecord() {
        ActivityRecord top;
        TaskRecord topTask;
        boolean moveStackAllowed;
        TaskRecord sourceTask = this.mSourceRecord.task;
        boolean bl = moveStackAllowed = sourceTask.stack.topTask() != sourceTask;
        if (moveStackAllowed) {
            this.mTargetStack = this.getLaunchStack(this.mStartActivity, this.mLaunchFlags, this.mStartActivity.task, this.mOptions);
        }
        if (this.mTargetStack == null) {
            this.mTargetStack = sourceTask.stack;
        } else if (this.mTargetStack != sourceTask.stack) {
            this.mSupervisor.moveTaskToStackLocked(sourceTask.taskId, this.mTargetStack.mStackId, true, true, "launchToSide", false);
        }
        if (this.mDoResume) {
            this.mTargetStack.moveToFront("sourceStackToFront");
        }
        if ((topTask = this.mTargetStack.topTask()) != sourceTask && !this.mAvoidMoveToFront) {
            this.mTargetStack.moveTaskToFrontLocked(sourceTask, this.mNoAnimation, this.mOptions, this.mStartActivity.appTimeTracker, "sourceTaskToFront");
        }
        if (!this.mAddingToTask && (this.mLaunchFlags & 0x4000000) != 0) {
            ActivityRecord top2 = sourceTask.performClearTaskLocked(this.mStartActivity, this.mLaunchFlags);
            this.mKeepCurTransition = true;
            if (top2 != null) {
                ActivityStack.logStartActivity(30003, this.mStartActivity, top2.task);
                top2.deliverNewIntentLocked(this.mCallingUid, this.mStartActivity.intent, this.mStartActivity.launchedFromPackage);
                this.mTargetStack.mLastPausedActivity = null;
                if (this.mDoResume) {
                    this.mSupervisor.resumeFocusedStackTopActivityLocked();
                }
                ActivityOptions.abort(this.mOptions);
                return 3;
            }
        } else if (!this.mAddingToTask && (this.mLaunchFlags & 0x20000) != 0 && (top = sourceTask.findActivityInHistoryLocked(this.mStartActivity)) != null) {
            TaskRecord task = top.task;
            task.moveActivityToFrontLocked(top);
            top.updateOptionsLocked(this.mOptions);
            ActivityStack.logStartActivity(30003, this.mStartActivity, task);
            top.deliverNewIntentLocked(this.mCallingUid, this.mStartActivity.intent, this.mStartActivity.launchedFromPackage);
            this.mTargetStack.mLastPausedActivity = null;
            if (this.mDoResume) {
                this.mSupervisor.resumeFocusedStackTopActivityLocked();
            }
            return 3;
        }
        this.mStartActivity.setTask(sourceTask, null);
        return 0;
    }

    private int setTaskFromInTask() {
        if (this.mLaunchBounds != null) {
            this.mInTask.updateOverrideConfiguration(this.mLaunchBounds);
            int stackId = this.mInTask.getLaunchStackId();
            if (stackId != this.mInTask.stack.mStackId) {
                ActivityStack stack = this.mSupervisor.moveTaskToStackUncheckedLocked(this.mInTask, stackId, true, false, "inTaskToFront");
                stackId = stack.mStackId;
            }
            if (ActivityManager.StackId.resizeStackWithLaunchBounds(stackId)) {
                this.mService.resizeStack(stackId, this.mLaunchBounds, true, false, true, -1);
            }
        }
        this.mTargetStack = this.mInTask.stack;
        this.mTargetStack.moveTaskToFrontLocked(this.mInTask, this.mNoAnimation, this.mOptions, this.mStartActivity.appTimeTracker, "inTaskToFront");
        ActivityRecord top = this.mInTask.getTopActivity();
        if (top != null && top.realActivity.equals(this.mStartActivity.realActivity) && top.userId == this.mStartActivity.userId && ((this.mLaunchFlags & 0x20000000) != 0 || this.mLaunchSingleTop || this.mLaunchSingleTask)) {
            ActivityStack.logStartActivity(30003, top, top.task);
            if ((this.mStartFlags & 1) != 0) {
                return 1;
            }
            top.deliverNewIntentLocked(this.mCallingUid, this.mStartActivity.intent, this.mStartActivity.launchedFromPackage);
            return 3;
        }
        if (!this.mAddingToTask) {
            ActivityOptions.abort(this.mOptions);
            return 2;
        }
        this.mStartActivity.setTask(this.mInTask, null);
        return 0;
    }

    private void setTaskToCurrentTopOrCreateNewTask() {
        ActivityRecord prev;
        this.mTargetStack = this.computeStackFocus(this.mStartActivity, false, null, this.mLaunchFlags, this.mOptions);
        if (this.mDoResume) {
            this.mTargetStack.moveToFront("addingToTopTask");
        }
        TaskRecord task = (prev = this.mTargetStack.topActivity()) != null ? prev.task : this.mTargetStack.createTaskRecord(this.mSupervisor.getNextTaskIdForUserLocked(this.mStartActivity.userId), this.mStartActivity.info, this.mIntent, null, null, true);
        this.mStartActivity.setTask(task, null);
        this.mWindowManager.moveTaskToTop(this.mStartActivity.task.taskId);
    }

    private int adjustLaunchFlagsToDocumentMode(ActivityRecord r, boolean launchSingleInstance, boolean launchSingleTask, int launchFlags) {
        if ((launchFlags & 0x80000) != 0 && (launchSingleInstance || launchSingleTask)) {
            Slog.i("ActivityManager", "Ignoring FLAG_ACTIVITY_NEW_DOCUMENT, launchMode is \"singleInstance\" or \"singleTask\"");
            launchFlags &= 0xF7F7FFFF;
        } else {
            switch (r.info.documentLaunchMode) {
                case 0: {
                    break;
                }
                case 1: {
                    launchFlags |= 0x80000;
                    break;
                }
                case 2: {
                    launchFlags |= 0x80000;
                    break;
                }
                case 3: {
                    launchFlags &= 0xF7FFFFFF;
                }
            }
        }
        return launchFlags;
    }

    final void doPendingActivityLaunchesLocked(boolean doResume) {
        while (!this.mPendingActivityLaunches.isEmpty()) {
            ActivityStackSupervisor.PendingActivityLaunch pal = this.mPendingActivityLaunches.remove(0);
            boolean resume = doResume && this.mPendingActivityLaunches.isEmpty();
            try {
                int result = this.startActivityUnchecked(pal.r, pal.sourceRecord, null, null, pal.startFlags, resume, null, null);
                this.postStartActivityUncheckedProcessing(pal.r, result, this.mSupervisor.mFocusedStack.mStackId, this.mSourceRecord, this.mTargetStack);
            }
            catch (Exception e) {
                Slog.e("ActivityManager", "Exception during pending activity launch pal=" + pal, e);
                pal.sendErrorResult(e.getMessage());
            }
        }
    }

    private ActivityStack computeStackFocus(ActivityRecord r, boolean newTask, Rect bounds, int launchFlags, ActivityOptions aOptions) {
        boolean canUseFocusedStack;
        TaskRecord task = r.task;
        if (!(r.isApplicationActivity() || task != null && task.isApplicationTask())) {
            return this.mSupervisor.mHomeStack;
        }
        ActivityStack stack = this.getLaunchStack(r, launchFlags, task, aOptions);
        if (stack != null) {
            return stack;
        }
        if (task != null && task.stack != null) {
            stack = task.stack;
            if (!stack.isOnHomeDisplay() || this.mSupervisor.mFocusedStack != stack) {
                // empty if block
            }
            return stack;
        }
        ActivityStackSupervisor.ActivityContainer container = r.mInitialActivityContainer;
        if (container != null) {
            r.mInitialActivityContainer = null;
            return container.mStack;
        }
        int focusedStackId = this.mSupervisor.mFocusedStack.mStackId;
        boolean bl = canUseFocusedStack = focusedStackId == 1 || focusedStackId == 3 && r.canGoInDockedStack() || focusedStackId == 2 && r.isResizeableOrForced();
        if (canUseFocusedStack && (!newTask || this.mSupervisor.mFocusedStack.mActivityContainer.isEligibleForNewTasks())) {
            return this.mSupervisor.mFocusedStack;
        }
        ArrayList<ActivityStack> homeDisplayStacks = this.mSupervisor.mHomeStack.mStacks;
        for (int stackNdx = homeDisplayStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            stack = homeDisplayStacks.get(stackNdx);
            if (ActivityManager.StackId.isStaticStack(stack.mStackId)) continue;
            return stack;
        }
        int stackId = task != null ? task.getLaunchStackId() : (bounds != null ? 2 : 1);
        stack = this.mSupervisor.getStack(stackId, true, true);
        return stack;
    }

    private ActivityStack getLaunchStack(ActivityRecord r, int launchFlags, TaskRecord task, ActivityOptions aOptions) {
        ActivityStack parentStack;
        int launchStackId;
        if (this.mReuseTask != null) {
            return this.mReuseTask.stack;
        }
        int n = launchStackId = aOptions != null ? aOptions.getLaunchStackId() : -1;
        if (this.isValidLaunchStackId(launchStackId, r)) {
            return this.mSupervisor.getStack(launchStackId, true, true);
        }
        if (launchStackId == 3) {
            return this.mSupervisor.getStack(1, true, true);
        }
        if ((launchFlags & 0x1000) == 0) {
            return null;
        }
        ActivityStack activityStack = task != null ? task.stack : (parentStack = r.mInitialActivityContainer != null ? r.mInitialActivityContainer.mStack : this.mSupervisor.mFocusedStack);
        if (parentStack != this.mSupervisor.mFocusedStack) {
            return parentStack;
        }
        if (this.mSupervisor.mFocusedStack != null && task == this.mSupervisor.mFocusedStack.topTask()) {
            return this.mSupervisor.mFocusedStack;
        }
        if (parentStack != null && parentStack.mStackId == 3) {
            return this.mSupervisor.getStack(1, true, true);
        }
        ActivityStack dockedStack = this.mSupervisor.getStack(3);
        if (dockedStack != null && dockedStack.getStackVisibilityLocked(r) == 0) {
            return null;
        }
        return dockedStack;
    }

    private boolean isValidLaunchStackId(int stackId, ActivityRecord r) {
        boolean supportsPip;
        if (stackId == -1 || stackId == 0 || !ActivityManager.StackId.isStaticStack(stackId)) {
            return false;
        }
        if (!(stackId == 1 || this.mService.mSupportsMultiWindow && r.isResizeableOrForced())) {
            return false;
        }
        if (stackId == 3 && r.canGoInDockedStack()) {
            return true;
        }
        if (stackId == 2 && !this.mService.mSupportsFreeformWindowManagement) {
            return false;
        }
        boolean bl = supportsPip = this.mService.mSupportsPictureInPicture && (r.supportsPictureInPicture() || this.mService.mForceResizableActivities);
        return stackId != 4 || supportsPip;
    }

    Rect getOverrideBounds(ActivityRecord r, ActivityOptions options, TaskRecord inTask) {
        Rect newBounds = null;
        if (options != null && (r.isResizeable() || inTask != null && inTask.isResizeable()) && this.mSupervisor.canUseActivityOptionsLaunchBounds(options, options.getLaunchStackId())) {
            newBounds = TaskRecord.validateBounds(options.getLaunchBounds());
        }
        return newBounds;
    }

    void setWindowManager(WindowManagerService wm) {
        this.mWindowManager = wm;
    }

    void removePendingActivityLaunchesLocked(ActivityStack stack) {
        for (int palNdx = this.mPendingActivityLaunches.size() - 1; palNdx >= 0; --palNdx) {
            ActivityStackSupervisor.PendingActivityLaunch pal = this.mPendingActivityLaunches.get(palNdx);
            if (pal.stack != stack) continue;
            this.mPendingActivityLaunches.remove(palNdx);
        }
    }
}

