/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.Dialog;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.Switch;
import com.android.server.am.ActivityManagerService;

public final class CompatModeDialog
extends Dialog {
    final ActivityManagerService mService;
    final ApplicationInfo mAppInfo;
    final Switch mCompatEnabled;
    final CheckBox mAlwaysShow;
    final View mHint;

    public CompatModeDialog(ActivityManagerService service, Context context, ApplicationInfo appInfo) {
        super(context, 16973936);
        this.setCancelable(true);
        this.setCanceledOnTouchOutside(true);
        this.getWindow().requestFeature(1);
        this.getWindow().setType(2002);
        this.getWindow().setGravity(81);
        this.mService = service;
        this.mAppInfo = appInfo;
        this.setContentView(17367090);
        this.mCompatEnabled = (Switch)this.findViewById(16909111);
        this.mCompatEnabled.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                ActivityManagerService activityManagerService = CompatModeDialog.this.mService;
                synchronized (activityManagerService) {
                    CompatModeDialog.this.mService.mCompatModePackages.setPackageScreenCompatModeLocked(CompatModeDialog.this.mAppInfo.packageName, CompatModeDialog.this.mCompatEnabled.isChecked() ? 1 : 0);
                    CompatModeDialog.this.updateControls();
                }
            }
        });
        this.mAlwaysShow = (CheckBox)this.findViewById(16909112);
        this.mAlwaysShow.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                ActivityManagerService activityManagerService = CompatModeDialog.this.mService;
                synchronized (activityManagerService) {
                    CompatModeDialog.this.mService.mCompatModePackages.setPackageAskCompatModeLocked(CompatModeDialog.this.mAppInfo.packageName, CompatModeDialog.this.mAlwaysShow.isChecked());
                    CompatModeDialog.this.updateControls();
                }
            }
        });
        this.mHint = this.findViewById(16909113);
        this.updateControls();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateControls() {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            int mode = this.mService.mCompatModePackages.computeCompatModeLocked(this.mAppInfo);
            this.mCompatEnabled.setChecked(mode == 1);
            boolean ask = this.mService.mCompatModePackages.getPackageAskCompatModeLocked(this.mAppInfo.packageName);
            this.mAlwaysShow.setChecked(ask);
            this.mHint.setVisibility(ask ? 4 : 0);
        }
    }
}

