/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.clipboard;

import android.app.ActivityManagerNative;
import android.app.AppGlobals;
import android.app.AppOpsManager;
import android.app.IActivityManager;
import android.content.BroadcastReceiver;
import android.content.ClipData;
import android.content.ClipDescription;
import android.content.ContentProvider;
import android.content.Context;
import android.content.IClipboard;
import android.content.IOnPrimaryClipChangedListener;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.IBinder;
import android.os.IUserManager;
import android.os.Parcel;
import android.os.Process;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.util.Slog;
import android.util.SparseArray;
import java.util.HashSet;
import java.util.List;

public class ClipboardService
extends IClipboard.Stub {
    private static final String TAG = "ClipboardService";
    private final Context mContext;
    private final IActivityManager mAm;
    private final IUserManager mUm;
    private final PackageManager mPm;
    private final AppOpsManager mAppOps;
    private final IBinder mPermissionOwner;
    private SparseArray<PerUserClipboard> mClipboards = new SparseArray();

    public ClipboardService(Context context) {
        this.mContext = context;
        this.mAm = ActivityManagerNative.getDefault();
        this.mPm = context.getPackageManager();
        this.mUm = (IUserManager)((Object)ServiceManager.getService("user"));
        this.mAppOps = (AppOpsManager)context.getSystemService("appops");
        IBinder permOwner = null;
        try {
            permOwner = this.mAm.newUriPermissionOwner("clipboard");
        }
        catch (RemoteException e) {
            Slog.w("clipboard", "AM dead", e);
        }
        this.mPermissionOwner = permOwner;
        IntentFilter userFilter = new IntentFilter();
        userFilter.addAction("android.intent.action.USER_REMOVED");
        this.mContext.registerReceiver(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if ("android.intent.action.USER_REMOVED".equals(action)) {
                    ClipboardService.this.removeClipboard(intent.getIntExtra("android.intent.extra.user_handle", 0));
                }
            }
        }, userFilter);
    }

    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        try {
            return super.onTransact(code, data, reply, flags);
        }
        catch (RuntimeException e) {
            if (!(e instanceof SecurityException)) {
                Slog.wtf("clipboard", "Exception: ", e);
            }
            throw e;
        }
    }

    private PerUserClipboard getClipboard() {
        return this.getClipboard(UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PerUserClipboard getClipboard(int userId) {
        SparseArray<PerUserClipboard> sparseArray = this.mClipboards;
        synchronized (sparseArray) {
            PerUserClipboard puc = this.mClipboards.get(userId);
            if (puc == null) {
                puc = new PerUserClipboard(userId);
                this.mClipboards.put(userId, puc);
            }
            return puc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeClipboard(int userId) {
        SparseArray<PerUserClipboard> sparseArray = this.mClipboards;
        synchronized (sparseArray) {
            this.mClipboards.remove(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPrimaryClip(ClipData clip, String callingPackage) {
        ClipboardService clipboardService = this;
        synchronized (clipboardService) {
            int size;
            if (clip != null && clip.getItemCount() <= 0) {
                throw new IllegalArgumentException("No items");
            }
            int callingUid = Binder.getCallingUid();
            if (this.mAppOps.noteOp(30, callingUid, callingPackage) != 0) {
                return;
            }
            this.checkDataOwnerLocked(clip, callingUid);
            int userId = UserHandle.getUserId(callingUid);
            PerUserClipboard clipboard = this.getClipboard(userId);
            this.revokeUris(clipboard);
            this.setPrimaryClipInternal(clipboard, clip);
            List<UserInfo> related = this.getRelatedProfiles(userId);
            if (related != null && (size = related.size()) > 1) {
                boolean canCopy = false;
                try {
                    canCopy = !this.mUm.getUserRestrictions(userId).getBoolean("no_cross_profile_copy_paste");
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "Remote Exception calling UserManager: " + e);
                }
                if (!canCopy) {
                    clip = null;
                } else {
                    clip = new ClipData(clip);
                    for (int i = clip.getItemCount() - 1; i >= 0; --i) {
                        clip.setItemAt(i, new ClipData.Item(clip.getItemAt(i)));
                    }
                    clip.fixUrisLight(userId);
                }
                for (int i = 0; i < size; ++i) {
                    int id2 = related.get((int)i).id;
                    if (id2 == userId) continue;
                    this.setPrimaryClipInternal(this.getClipboard(id2), clip);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<UserInfo> getRelatedProfiles(int userId) {
        List<UserInfo> related;
        long origId = Binder.clearCallingIdentity();
        try {
            related = this.mUm.getProfiles(userId, true);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Remote Exception calling UserManager: " + e);
            List<UserInfo> list = null;
            return list;
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
        return related;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPrimaryClipInternal(PerUserClipboard clipboard, ClipData clip) {
        clipboard.activePermissionOwners.clear();
        if (clip == null && clipboard.primaryClip == null) {
            return;
        }
        clipboard.primaryClip = clip;
        long ident = Binder.clearCallingIdentity();
        int n = clipboard.primaryClipListeners.beginBroadcast();
        try {
            for (int i = 0; i < n; ++i) {
                try {
                    ListenerInfo li = (ListenerInfo)clipboard.primaryClipListeners.getBroadcastCookie(i);
                    if (this.mAppOps.checkOpNoThrow(29, li.mUid, li.mPackageName) != 0) continue;
                    clipboard.primaryClipListeners.getBroadcastItem(i).dispatchPrimaryClipChanged();
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        finally {
            clipboard.primaryClipListeners.finishBroadcast();
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClipData getPrimaryClip(String pkg) {
        ClipboardService clipboardService = this;
        synchronized (clipboardService) {
            if (this.mAppOps.noteOp(29, Binder.getCallingUid(), pkg) != 0) {
                return null;
            }
            this.addActiveOwnerLocked(Binder.getCallingUid(), pkg);
            return this.getClipboard().primaryClip;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClipDescription getPrimaryClipDescription(String callingPackage) {
        ClipboardService clipboardService = this;
        synchronized (clipboardService) {
            if (this.mAppOps.checkOp(29, Binder.getCallingUid(), callingPackage) != 0) {
                return null;
            }
            PerUserClipboard clipboard = this.getClipboard();
            return clipboard.primaryClip != null ? clipboard.primaryClip.getDescription() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPrimaryClip(String callingPackage) {
        ClipboardService clipboardService = this;
        synchronized (clipboardService) {
            if (this.mAppOps.checkOp(29, Binder.getCallingUid(), callingPackage) != 0) {
                return false;
            }
            return this.getClipboard().primaryClip != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPrimaryClipChangedListener(IOnPrimaryClipChangedListener listener, String callingPackage) {
        ClipboardService clipboardService = this;
        synchronized (clipboardService) {
            this.getClipboard().primaryClipListeners.register(listener, new ListenerInfo(Binder.getCallingUid(), callingPackage));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePrimaryClipChangedListener(IOnPrimaryClipChangedListener listener) {
        ClipboardService clipboardService = this;
        synchronized (clipboardService) {
            this.getClipboard().primaryClipListeners.unregister(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasClipboardText(String callingPackage) {
        ClipboardService clipboardService = this;
        synchronized (clipboardService) {
            if (this.mAppOps.checkOp(29, Binder.getCallingUid(), callingPackage) != 0) {
                return false;
            }
            PerUserClipboard clipboard = this.getClipboard();
            if (clipboard.primaryClip != null) {
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                CharSequence text = clipboard.primaryClip.getItemAt(0).getText();
                return text != null && text.length() > 0;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkUriOwnerLocked(Uri uri, int uid) {
        if (!"content".equals(uri.getScheme())) {
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.mAm.checkGrantUriPermission(uid, null, ContentProvider.getUriWithoutUserId(uri), 1, ContentProvider.getUserIdFromUri(uri, UserHandle.getUserId(uid)));
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private final void checkItemOwnerLocked(ClipData.Item item, int uid) {
        Intent intent;
        if (item.getUri() != null) {
            this.checkUriOwnerLocked(item.getUri(), uid);
        }
        if ((intent = item.getIntent()) != null && intent.getData() != null) {
            this.checkUriOwnerLocked(intent.getData(), uid);
        }
    }

    private final void checkDataOwnerLocked(ClipData data, int uid) {
        int N = data.getItemCount();
        for (int i = 0; i < N; ++i) {
            this.checkItemOwnerLocked(data.getItemAt(i), uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void grantUriLocked(Uri uri, String pkg, int userId) {
        long ident = Binder.clearCallingIdentity();
        try {
            int sourceUserId = ContentProvider.getUserIdFromUri(uri, userId);
            uri = ContentProvider.getUriWithoutUserId(uri);
            this.mAm.grantUriPermissionFromOwner(this.mPermissionOwner, Process.myUid(), pkg, uri, 1, sourceUserId, userId);
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private final void grantItemLocked(ClipData.Item item, String pkg, int userId) {
        Intent intent;
        if (item.getUri() != null) {
            this.grantUriLocked(item.getUri(), pkg, userId);
        }
        if ((intent = item.getIntent()) != null && intent.getData() != null) {
            this.grantUriLocked(intent.getData(), pkg, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addActiveOwnerLocked(int uid, String pkg) {
        IPackageManager pm = AppGlobals.getPackageManager();
        int targetUserHandle = UserHandle.getCallingUserId();
        long oldIdentity = Binder.clearCallingIdentity();
        try {
            PackageInfo pi = pm.getPackageInfo(pkg, 0, targetUserHandle);
            if (pi == null) {
                throw new IllegalArgumentException("Unknown package " + pkg);
            }
            if (!UserHandle.isSameApp(pi.applicationInfo.uid, uid)) {
                throw new SecurityException("Calling uid " + uid + " does not own package " + pkg);
            }
        }
        catch (RemoteException pi) {
        }
        finally {
            Binder.restoreCallingIdentity(oldIdentity);
        }
        PerUserClipboard clipboard = this.getClipboard();
        if (clipboard.primaryClip != null && !clipboard.activePermissionOwners.contains(pkg)) {
            int N = clipboard.primaryClip.getItemCount();
            for (int i = 0; i < N; ++i) {
                this.grantItemLocked(clipboard.primaryClip.getItemAt(i), pkg, UserHandle.getUserId(uid));
            }
            clipboard.activePermissionOwners.add(pkg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void revokeUriLocked(Uri uri) {
        int userId = ContentProvider.getUserIdFromUri(uri, UserHandle.getUserId(Binder.getCallingUid()));
        long ident = Binder.clearCallingIdentity();
        try {
            uri = ContentProvider.getUriWithoutUserId(uri);
            this.mAm.revokeUriPermissionFromOwner(this.mPermissionOwner, uri, 3, userId);
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private final void revokeItemLocked(ClipData.Item item) {
        Intent intent;
        if (item.getUri() != null) {
            this.revokeUriLocked(item.getUri());
        }
        if ((intent = item.getIntent()) != null && intent.getData() != null) {
            this.revokeUriLocked(intent.getData());
        }
    }

    private final void revokeUris(PerUserClipboard clipboard) {
        if (clipboard.primaryClip == null) {
            return;
        }
        int N = clipboard.primaryClip.getItemCount();
        for (int i = 0; i < N; ++i) {
            this.revokeItemLocked(clipboard.primaryClip.getItemAt(i));
        }
    }

    private class PerUserClipboard {
        final int userId;
        final RemoteCallbackList<IOnPrimaryClipChangedListener> primaryClipListeners = new RemoteCallbackList();
        ClipData primaryClip;
        final HashSet<String> activePermissionOwners = new HashSet();

        PerUserClipboard(int userId) {
            this.userId = userId;
        }
    }

    private class ListenerInfo {
        final int mUid;
        final String mPackageName;

        ListenerInfo(int uid, String packageName) {
            this.mUid = uid;
            this.mPackageName = packageName;
        }
    }
}

