/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkRequest;
import android.net.metrics.DnsEvent;
import android.net.metrics.IDnsEventListener;
import android.net.metrics.IpConnectivityLog;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.IndentingPrintWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.SortedMap;
import java.util.TreeMap;

public class DnsEventListenerService
extends IDnsEventListener.Stub {
    public static final String SERVICE_NAME = "dns_listener";
    private static final String TAG = DnsEventListenerService.class.getSimpleName();
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final int MAX_LOOKUPS_PER_DNS_EVENT = 100;
    @GuardedBy(value="this")
    private final SortedMap<Integer, DnsEventBatch> mEventBatches = new TreeMap<Integer, DnsEventBatch>();
    private final ConnectivityManager mCm;
    private final IpConnectivityLog mMetricsLog;
    private final ConnectivityManager.NetworkCallback mNetworkCallback = new ConnectivityManager.NetworkCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLost(Network network) {
            DnsEventListenerService dnsEventListenerService = DnsEventListenerService.this;
            synchronized (dnsEventListenerService) {
                DnsEventBatch batch = (DnsEventBatch)DnsEventListenerService.this.mEventBatches.remove(network.netId);
                if (batch != null) {
                    batch.logAndClear();
                }
            }
        }
    };

    public DnsEventListenerService(Context context) {
        this(context.getSystemService(ConnectivityManager.class), new IpConnectivityLog());
    }

    public DnsEventListenerService(ConnectivityManager cm, IpConnectivityLog log) {
        this.mCm = cm;
        this.mMetricsLog = log;
        NetworkRequest request = new NetworkRequest.Builder().clearCapabilities().build();
        this.mCm.registerNetworkCallback(request, this.mNetworkCallback);
    }

    @Override
    public synchronized void onDnsEvent(int netId, int eventType, int returnCode, int latencyMs) {
        DnsEventListenerService.maybeVerboseLog(String.format("onDnsEvent(%d, %d, %d, %d)", netId, eventType, returnCode, latencyMs));
        DnsEventBatch batch = (DnsEventBatch)this.mEventBatches.get(netId);
        if (batch == null) {
            batch = new DnsEventBatch(netId);
            this.mEventBatches.put(netId, batch);
        }
        batch.addResult((byte)eventType, (byte)returnCode, latencyMs);
    }

    public synchronized void dump(PrintWriter writer) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
        pw.println(TAG + ":");
        pw.increaseIndent();
        for (DnsEventBatch batch : this.mEventBatches.values()) {
            pw.println(batch.toString());
        }
        pw.decreaseIndent();
    }

    private static void maybeLog(String s) {
        Log.d(TAG, s);
    }

    private static void maybeVerboseLog(String s) {
    }

    private class DnsEventBatch {
        private final int mNetId;
        private final byte[] mEventTypes = new byte[100];
        private final byte[] mReturnCodes = new byte[100];
        private final int[] mLatenciesMs = new int[100];
        private int mEventCount;

        public DnsEventBatch(int netId) {
            this.mNetId = netId;
        }

        public void addResult(byte eventType, byte returnCode, int latencyMs) {
            this.mEventTypes[this.mEventCount] = eventType;
            this.mReturnCodes[this.mEventCount] = returnCode;
            this.mLatenciesMs[this.mEventCount] = latencyMs;
            ++this.mEventCount;
            if (this.mEventCount == 100) {
                this.logAndClear();
            }
        }

        public void logAndClear() {
            if (this.mEventCount == 0) {
                return;
            }
            byte[] eventTypes = Arrays.copyOf(this.mEventTypes, this.mEventCount);
            byte[] returnCodes = Arrays.copyOf(this.mReturnCodes, this.mEventCount);
            int[] latenciesMs = Arrays.copyOf(this.mLatenciesMs, this.mEventCount);
            DnsEventListenerService.this.mMetricsLog.log(new DnsEvent(this.mNetId, eventTypes, returnCodes, latenciesMs));
            DnsEventListenerService.maybeLog(String.format("Logging %d results for netId %d", this.mEventCount, this.mNetId));
            this.mEventCount = 0;
        }

        public String toString() {
            return String.format("%s %d %d", this.getClass().getSimpleName(), this.mNetId, this.mEventCount);
        }
    }
}

