/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.app.PendingIntent;
import android.content.Context;
import android.net.ConnectivityMetricsEvent;
import android.net.IConnectivityMetricsLogger;
import android.os.Binder;
import android.os.Parcel;
import android.text.format.DateUtils;
import android.util.Log;
import com.android.server.SystemService;
import com.android.server.connectivity.DnsEventListenerService;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;

public class MetricsLoggerService
extends SystemService {
    private static String TAG = "ConnectivityMetricsLoggerService";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private final int EVENTS_NOTIFICATION_THRESHOLD = 300;
    private final int MAX_NUMBER_OF_EVENTS = 1000;
    private final int THROTTLING_MAX_NUMBER_OF_MESSAGES_PER_COMPONENT = 1000;
    private final long THROTTLING_TIME_INTERVAL_MILLIS = 3600000L;
    private int mEventCounter = 0;
    private long mLastEventReference = 0L;
    private final int[] mThrottlingCounters = new int[5];
    private long mThrottlingIntervalBoundaryMillis;
    private final ArrayDeque<ConnectivityMetricsEvent> mEvents = new ArrayDeque();
    private DnsEventListenerService mDnsListener;
    final MetricsLoggerImpl mBinder = new MetricsLoggerImpl();

    public MetricsLoggerService(Context context) {
        super(context);
    }

    @Override
    public void onStart() {
        this.resetThrottlingCounters(System.currentTimeMillis());
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase == 500) {
            Log.d(TAG, "onBootPhase: PHASE_SYSTEM_SERVICES_READY");
            this.publishBinderService("connectivity_metrics_logger", this.mBinder);
            this.mDnsListener = new DnsEventListenerService(this.getContext());
            this.publishBinderService("dns_listener", this.mDnsListener);
        }
    }

    private void enforceConnectivityInternalPermission() {
        this.getContext().enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", "MetricsLoggerService");
    }

    private void enforceDumpPermission() {
        this.getContext().enforceCallingOrSelfPermission("android.permission.DUMP", "MetricsLoggerService");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetThrottlingCounters(long currentTimeMillis) {
        int[] nArray = this.mThrottlingCounters;
        synchronized (this.mThrottlingCounters) {
            for (int i = 0; i < this.mThrottlingCounters.length; ++i) {
                this.mThrottlingCounters[i] = 0;
            }
            this.mThrottlingIntervalBoundaryMillis = currentTimeMillis + 3600000L;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    private void addEvent(ConnectivityMetricsEvent e) {
        while (this.mEvents.size() >= 1000) {
            this.mEvents.removeFirst();
        }
        this.mEvents.addLast(e);
    }

    final class MetricsLoggerImpl
    extends IConnectivityMetricsLogger.Stub {
        private final ArrayList<PendingIntent> mPendingIntents = new ArrayList();

        MetricsLoggerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (MetricsLoggerService.this.getContext().checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
                pw.println("Permission Denial: can't dump ConnectivityMetricsLoggerService from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
                return;
            }
            boolean dumpSerializedSize = false;
            boolean dumpEvents = false;
            boolean dumpDebugInfo = false;
            Object object = args;
            int n = ((String[])object).length;
            block18: for (int i = 0; i < n; ++i) {
                String arg;
                switch (arg = object[i]) {
                    case "--debug": {
                        dumpDebugInfo = true;
                        continue block18;
                    }
                    case "--events": {
                        dumpEvents = true;
                        continue block18;
                    }
                    case "--size": {
                        dumpSerializedSize = true;
                        continue block18;
                    }
                    case "--all": {
                        dumpDebugInfo = true;
                        dumpEvents = true;
                        dumpSerializedSize = true;
                        continue block18;
                    }
                }
            }
            object = MetricsLoggerService.this.mEvents;
            // MONITORENTER : object
            pw.println("Number of events: " + MetricsLoggerService.this.mEvents.size());
            pw.println("Counter: " + MetricsLoggerService.this.mEventCounter);
            if (MetricsLoggerService.this.mEvents.size() > 0) {
                pw.println("Time span: " + DateUtils.formatElapsedTime((System.currentTimeMillis() - ((ConnectivityMetricsEvent)((MetricsLoggerService)MetricsLoggerService.this).mEvents.peekFirst()).timestamp) / 1000L));
            }
            if (dumpSerializedSize) {
                Parcel p = Parcel.obtain();
                for (ConnectivityMetricsEvent e : MetricsLoggerService.this.mEvents) {
                    p.writeParcelable(e, 0);
                }
                pw.println("Serialized data size: " + p.dataSize());
                p.recycle();
            }
            if (dumpEvents) {
                pw.println();
                pw.println("Events:");
                for (ConnectivityMetricsEvent e : MetricsLoggerService.this.mEvents) {
                    pw.println(e.toString());
                }
            }
            // MONITOREXIT : object
            if (dumpDebugInfo) {
                int[] nArray = MetricsLoggerService.this.mThrottlingCounters;
                object = nArray;
                // MONITORENTER : nArray
                pw.println();
                for (int i = 0; i < 5; ++i) {
                    if (MetricsLoggerService.this.mThrottlingCounters[i] <= 0) continue;
                    pw.println("Throttling Counter #" + i + ": " + MetricsLoggerService.this.mThrottlingCounters[i]);
                }
                pw.println("Throttling Time Remaining: " + DateUtils.formatElapsedTime((MetricsLoggerService.this.mThrottlingIntervalBoundaryMillis - System.currentTimeMillis()) / 1000L));
                // MONITOREXIT : object
            }
            object = this.mPendingIntents;
            // MONITORENTER : object
            if (!this.mPendingIntents.isEmpty()) {
                pw.println();
                pw.println("Pending intents:");
                for (PendingIntent pi : this.mPendingIntents) {
                    pw.println(pi.toString());
                }
            }
            // MONITOREXIT : object
            pw.println();
            if (MetricsLoggerService.this.mDnsListener == null) return;
            MetricsLoggerService.this.mDnsListener.dump(pw);
        }

        @Override
        public long logEvent(ConnectivityMetricsEvent event) {
            ConnectivityMetricsEvent[] events = new ConnectivityMetricsEvent[]{event};
            return this.logEvents(events);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long logEvents(ConnectivityMetricsEvent[] events) {
            MetricsLoggerService.this.enforceConnectivityInternalPermission();
            if (events == null || events.length == 0) {
                Log.wtf(TAG, "No events passed to logEvents()");
                return -1L;
            }
            int componentTag = events[0].componentTag;
            if (componentTag < 0 || componentTag >= 5) {
                Log.wtf(TAG, "Unexpected tag: " + componentTag);
                return -1L;
            }
            int[] nArray = MetricsLoggerService.this.mThrottlingCounters;
            synchronized (nArray) {
                long currentTimeMillis = System.currentTimeMillis();
                if (currentTimeMillis > MetricsLoggerService.this.mThrottlingIntervalBoundaryMillis) {
                    MetricsLoggerService.this.resetThrottlingCounters(currentTimeMillis);
                }
                int[] nArray2 = MetricsLoggerService.this.mThrottlingCounters;
                int n = componentTag;
                nArray2[n] = nArray2[n] + events.length;
                if (MetricsLoggerService.this.mThrottlingCounters[componentTag] > 1000) {
                    Log.w(TAG, "Too many events from #" + componentTag + ". Block until " + MetricsLoggerService.this.mThrottlingIntervalBoundaryMillis);
                    return MetricsLoggerService.this.mThrottlingIntervalBoundaryMillis;
                }
            }
            boolean sendPendingIntents = false;
            AbstractCollection abstractCollection = MetricsLoggerService.this.mEvents;
            synchronized (abstractCollection) {
                for (ConnectivityMetricsEvent e : events) {
                    if (e.componentTag != componentTag) {
                        Log.wtf(TAG, "Unexpected tag: " + e.componentTag);
                        return -1L;
                    }
                    MetricsLoggerService.this.addEvent(e);
                }
                MetricsLoggerService.this.mLastEventReference = MetricsLoggerService.this.mLastEventReference + (long)events.length;
                MetricsLoggerService.this.mEventCounter = MetricsLoggerService.this.mEventCounter + events.length;
                if (MetricsLoggerService.this.mEventCounter >= 300) {
                    MetricsLoggerService.this.mEventCounter = 0;
                    sendPendingIntents = true;
                }
            }
            if (sendPendingIntents) {
                abstractCollection = this.mPendingIntents;
                synchronized (abstractCollection) {
                    for (PendingIntent pi : this.mPendingIntents) {
                        try {
                            pi.send(MetricsLoggerService.this.getContext(), 0, null, null, null);
                        }
                        catch (PendingIntent.CanceledException e) {
                            Log.e(TAG, "Pending intent canceled: " + pi);
                            this.mPendingIntents.remove(pi);
                        }
                    }
                }
            }
            return 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ConnectivityMetricsEvent[] getEvents(ConnectivityMetricsEvent.Reference reference) {
            ConnectivityMetricsEvent[] result;
            MetricsLoggerService.this.enforceDumpPermission();
            long ref = reference.getValue();
            ArrayDeque arrayDeque = MetricsLoggerService.this.mEvents;
            synchronized (arrayDeque) {
                if (ref > MetricsLoggerService.this.mLastEventReference) {
                    Log.e(TAG, "Invalid reference");
                    reference.setValue(MetricsLoggerService.this.mLastEventReference);
                    return null;
                }
                if (ref < MetricsLoggerService.this.mLastEventReference - (long)MetricsLoggerService.this.mEvents.size()) {
                    ref = MetricsLoggerService.this.mLastEventReference - (long)MetricsLoggerService.this.mEvents.size();
                }
                int numEventsToSkip = MetricsLoggerService.this.mEvents.size() - (int)(MetricsLoggerService.this.mLastEventReference - ref);
                result = new ConnectivityMetricsEvent[MetricsLoggerService.this.mEvents.size() - numEventsToSkip];
                int i = 0;
                for (ConnectivityMetricsEvent e : MetricsLoggerService.this.mEvents) {
                    if (numEventsToSkip > 0) {
                        --numEventsToSkip;
                        continue;
                    }
                    result[i++] = e;
                }
                reference.setValue(MetricsLoggerService.this.mLastEventReference);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean register(PendingIntent newEventsIntent) {
            MetricsLoggerService.this.enforceDumpPermission();
            ArrayList<PendingIntent> arrayList = this.mPendingIntents;
            synchronized (arrayList) {
                if (this.mPendingIntents.remove(newEventsIntent)) {
                    Log.w(TAG, "Replacing registered pending intent");
                }
                this.mPendingIntents.add(newEventsIntent);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unregister(PendingIntent newEventsIntent) {
            MetricsLoggerService.this.enforceDumpPermission();
            ArrayList<PendingIntent> arrayList = this.mPendingIntents;
            synchronized (arrayList) {
                if (!this.mPendingIntents.remove(newEventsIntent)) {
                    Log.e(TAG, "Pending intent is not registered");
                }
            }
        }
    }
}

