/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.UserHandle;
import android.telephony.TelephonyManager;
import android.util.Slog;
import android.widget.Toast;
import com.android.server.connectivity.NetworkAgentInfo;

public class NetworkNotificationManager {
    private static final String NOTIFICATION_ID = "Connectivity.Notification";
    private static final String TAG = NetworkNotificationManager.class.getSimpleName();
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private final Context mContext;
    private final TelephonyManager mTelephonyManager;
    private final NotificationManager mNotificationManager;

    public NetworkNotificationManager(Context c, TelephonyManager t, NotificationManager n) {
        this.mContext = c;
        this.mTelephonyManager = t;
        this.mNotificationManager = n;
    }

    private static int getFirstTransportType(NetworkAgentInfo nai) {
        for (int i = 0; i < 64; ++i) {
            if (!nai.networkCapabilities.hasTransport(i)) continue;
            return i;
        }
        return -1;
    }

    private static String getTransportName(int transportType) {
        Resources r = Resources.getSystem();
        String[] networkTypes = r.getStringArray(17236054);
        try {
            return networkTypes[transportType];
        }
        catch (IndexOutOfBoundsException e) {
            return r.getString(17040351);
        }
    }

    private static int getIcon(int transportType) {
        return transportType == 1 ? 17303250 : 17303246;
    }

    public void showNotification(int id2, NotificationType notifyType, NetworkAgentInfo nai, NetworkAgentInfo switchToNai, PendingIntent intent, boolean highPriority) {
        String details;
        String title;
        String extraInfo;
        int transportType;
        if (nai != null) {
            transportType = NetworkNotificationManager.getFirstTransportType(nai);
            extraInfo = nai.networkInfo.getExtraInfo();
            if (!nai.networkCapabilities.hasCapability(12)) {
                return;
            }
        } else {
            transportType = 0;
            extraInfo = null;
        }
        Slog.d(TAG, "showNotification " + (Object)((Object)notifyType) + " transportType=" + NetworkNotificationManager.getTransportName(transportType) + " extraInfo=" + extraInfo + " highPriority=" + highPriority);
        Resources r = Resources.getSystem();
        int icon = NetworkNotificationManager.getIcon(transportType);
        if (notifyType == NotificationType.NO_INTERNET && transportType == 1) {
            title = r.getString(17040346, 0);
            details = r.getString(17040347);
        } else if (notifyType == NotificationType.LOST_INTERNET && transportType == 1) {
            title = r.getString(17040346, 0);
            details = r.getString(17040347);
        } else if (notifyType == NotificationType.SIGN_IN) {
            switch (transportType) {
                case 1: {
                    title = r.getString(17040343, 0);
                    details = r.getString(17040345, extraInfo);
                    break;
                }
                case 0: {
                    title = r.getString(17040344, 0);
                    details = this.mTelephonyManager.getNetworkOperatorName();
                    break;
                }
                default: {
                    title = r.getString(17040344, 0);
                    details = r.getString(17040345, extraInfo);
                    break;
                }
            }
        } else if (notifyType == NotificationType.NETWORK_SWITCH) {
            String fromTransport = NetworkNotificationManager.getTransportName(transportType);
            String toTransport = NetworkNotificationManager.getTransportName(NetworkNotificationManager.getFirstTransportType(switchToNai));
            title = r.getString(17040348, toTransport);
            details = r.getString(17040349, toTransport, fromTransport);
        } else {
            Slog.wtf(TAG, "Unknown notification type " + (Object)((Object)notifyType) + "on network transport " + NetworkNotificationManager.getTransportName(transportType));
            return;
        }
        Notification.Builder builder = new Notification.Builder(this.mContext).setWhen(System.currentTimeMillis()).setShowWhen(notifyType == NotificationType.NETWORK_SWITCH).setSmallIcon(icon).setAutoCancel(true).setTicker(title).setColor(this.mContext.getColor(17170523)).setContentTitle(title).setContentIntent(intent).setLocalOnly(true).setPriority(highPriority ? 1 : 0).setDefaults(highPriority ? -1 : 0).setOnlyAlertOnce(true);
        if (notifyType == NotificationType.NETWORK_SWITCH) {
            builder.setStyle(new Notification.BigTextStyle().bigText(details));
        } else {
            builder.setContentText(details);
        }
        Notification notification = builder.build();
        try {
            this.mNotificationManager.notifyAsUser(NOTIFICATION_ID, id2, notification, UserHandle.ALL);
        }
        catch (NullPointerException npe) {
            Slog.d(TAG, "setNotificationVisible: visible notificationManager npe=" + npe);
        }
    }

    public void clearNotification(int id2) {
        Slog.d(TAG, "clearNotification id=" + id2);
        try {
            this.mNotificationManager.cancelAsUser(NOTIFICATION_ID, id2, UserHandle.ALL);
        }
        catch (NullPointerException npe) {
            Slog.d(TAG, "setNotificationVisible: cancel notificationManager npe=" + npe);
        }
    }

    public void setProvNotificationVisible(boolean visible, int id2, String action) {
        if (visible) {
            Intent intent = new Intent(action);
            PendingIntent pendingIntent = PendingIntent.getBroadcast(this.mContext, 0, intent, 0);
            this.showNotification(id2, NotificationType.SIGN_IN, null, null, pendingIntent, false);
        } else {
            this.clearNotification(id2);
        }
    }

    public void showToast(NetworkAgentInfo fromNai, NetworkAgentInfo toNai) {
        String fromTransport = NetworkNotificationManager.getTransportName(NetworkNotificationManager.getFirstTransportType(fromNai));
        String toTransport = NetworkNotificationManager.getTransportName(NetworkNotificationManager.getFirstTransportType(toNai));
        String text = this.mContext.getResources().getString(17040350, fromTransport, toTransport);
        Toast.makeText(this.mContext, text, 1).show();
    }

    public static enum NotificationType {
        SIGN_IN,
        NO_INTERNET,
        LOST_INTERNET,
        NETWORK_SWITCH;

    }
}

