/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity.tethering;

import android.net.IpPrefix;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkState;
import android.net.RouteInfo;
import com.android.server.connectivity.tethering.TetherInterfaceStateMachine;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class IPv6TetheringCoordinator {
    private static final String TAG = IPv6TetheringCoordinator.class.getSimpleName();
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    private final ArrayList<TetherInterfaceStateMachine> mNotifyList;
    private final LinkedList<TetherInterfaceStateMachine> mActiveDownstreams;
    private NetworkState mUpstreamNetworkState;

    public IPv6TetheringCoordinator(ArrayList<TetherInterfaceStateMachine> notifyList) {
        this.mNotifyList = notifyList;
        this.mActiveDownstreams = new LinkedList();
    }

    public void addActiveDownstream(TetherInterfaceStateMachine downstream) {
        if (this.mActiveDownstreams.indexOf(downstream) == -1) {
            this.mActiveDownstreams.offer(downstream);
            this.updateIPv6TetheringInterfaces();
        }
    }

    public void removeActiveDownstream(TetherInterfaceStateMachine downstream) {
        IPv6TetheringCoordinator.stopIPv6TetheringOn(downstream);
        if (this.mActiveDownstreams.remove(downstream)) {
            this.updateIPv6TetheringInterfaces();
        }
    }

    public void updateUpstreamNetworkState(NetworkState ns) {
        if (!IPv6TetheringCoordinator.canTetherIPv6(ns)) {
            this.stopIPv6TetheringOnAllInterfaces();
            this.setUpstreamNetworkState(null);
            return;
        }
        if (this.mUpstreamNetworkState != null && !ns.network.equals(this.mUpstreamNetworkState.network)) {
            this.stopIPv6TetheringOnAllInterfaces();
        }
        this.setUpstreamNetworkState(ns);
        this.updateIPv6TetheringInterfaces();
    }

    private void stopIPv6TetheringOnAllInterfaces() {
        for (TetherInterfaceStateMachine sm : this.mNotifyList) {
            IPv6TetheringCoordinator.stopIPv6TetheringOn(sm);
        }
    }

    private void setUpstreamNetworkState(NetworkState ns) {
        this.mUpstreamNetworkState = ns == null ? null : new NetworkState(null, new LinkProperties(ns.linkProperties), new NetworkCapabilities(ns.networkCapabilities), new Network(ns.network), null, null);
    }

    private void updateIPv6TetheringInterfaces() {
        block0: {
            Iterator<TetherInterfaceStateMachine> iterator = this.mNotifyList.iterator();
            if (!iterator.hasNext()) break block0;
            TetherInterfaceStateMachine sm = iterator.next();
            LinkProperties lp = this.getInterfaceIPv6LinkProperties(sm);
            sm.sendMessage(327793, 0, 0, lp);
        }
    }

    private LinkProperties getInterfaceIPv6LinkProperties(TetherInterfaceStateMachine sm) {
        LinkProperties lp;
        if (this.mUpstreamNetworkState == null) {
            return null;
        }
        if (sm.interfaceType() == 2) {
            return null;
        }
        TetherInterfaceStateMachine currentActive = this.mActiveDownstreams.peek();
        if (currentActive != null && currentActive == sm && (lp = IPv6TetheringCoordinator.getIPv6OnlyLinkProperties(this.mUpstreamNetworkState.linkProperties)).hasIPv6DefaultRoute() && lp.hasGlobalIPv6Address()) {
            return lp;
        }
        return null;
    }

    private static boolean canTetherIPv6(NetworkState ns) {
        boolean canTether = ns != null && ns.network != null && ns.linkProperties != null && ns.networkCapabilities != null && ns.linkProperties.isProvisioned() && ns.linkProperties.hasIPv6DefaultRoute() && ns.linkProperties.hasGlobalIPv6Address() && ns.networkCapabilities.hasTransport(0);
        RouteInfo v4default = null;
        RouteInfo v6default = null;
        if (canTether) {
            for (RouteInfo r : ns.linkProperties.getAllRoutes()) {
                if (r.isIPv4Default()) {
                    v4default = r;
                } else if (r.isIPv6Default()) {
                    v6default = r;
                }
                if (v4default == null || v6default == null) continue;
                break;
            }
        }
        boolean supportedConfiguration = v4default != null && v6default != null && v4default.getInterface() != null && v4default.getInterface().equals(v6default.getInterface());
        boolean outcome = canTether && supportedConfiguration;
        return outcome;
    }

    private static LinkProperties getIPv6OnlyLinkProperties(LinkProperties lp) {
        LinkProperties v6only = new LinkProperties();
        if (lp == null) {
            return v6only;
        }
        v6only.setInterfaceName(lp.getInterfaceName());
        v6only.setMtu(lp.getMtu());
        for (LinkAddress linkAddr : lp.getLinkAddresses()) {
            if (!linkAddr.isGlobalPreferred() || linkAddr.getPrefixLength() != 64) continue;
            v6only.addLinkAddress(linkAddr);
        }
        for (RouteInfo routeInfo : lp.getRoutes()) {
            IpPrefix destination = routeInfo.getDestination();
            if (!(destination.getAddress() instanceof Inet6Address) || destination.getPrefixLength() > 64) continue;
            v6only.addRoute(routeInfo);
        }
        for (InetAddress dnsServer : lp.getDnsServers()) {
            if (!IPv6TetheringCoordinator.isIPv6GlobalAddress(dnsServer)) continue;
            v6only.addDnsServer(dnsServer);
        }
        v6only.setDomains(lp.getDomains());
        return v6only;
    }

    private static boolean isIPv6GlobalAddress(InetAddress ip) {
        return ip instanceof Inet6Address && !ip.isAnyLocalAddress() && !ip.isLoopbackAddress() && !ip.isLinkLocalAddress() && !ip.isSiteLocalAddress() && !ip.isMulticastAddress();
    }

    private static String toDebugString(NetworkState ns) {
        if (ns == null) {
            return "NetworkState{null}";
        }
        return String.format("NetworkState{%s, %s, %s}", ns.network, ns.networkCapabilities, ns.linkProperties);
    }

    private static void stopIPv6TetheringOn(TetherInterfaceStateMachine sm) {
        sm.sendMessage(327793, 0, 0, null);
    }
}

