/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity.tethering;

import android.net.INetd;
import android.net.IpPrefix;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.RouteInfo;
import android.net.ip.RouterAdvertisementDaemon;
import android.os.INetworkManagementService;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.util.Log;
import android.util.Slog;
import java.net.Inet6Address;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;

class IPv6TetheringInterfaceServices {
    private static final String TAG = IPv6TetheringInterfaceServices.class.getSimpleName();
    private static final IpPrefix LINK_LOCAL_PREFIX = new IpPrefix("fe80::/64");
    private static final int RFC7421_IP_PREFIX_LENGTH = 64;
    private final String mIfName;
    private final INetworkManagementService mNMService;
    private NetworkInterface mNetworkInterface;
    private byte[] mHwAddr;
    private LinkProperties mLastIPv6LinkProperties;
    private RouterAdvertisementDaemon mRaDaemon;
    private RouterAdvertisementDaemon.RaParams mLastRaParams;

    IPv6TetheringInterfaceServices(String ifname, INetworkManagementService nms) {
        this.mIfName = ifname;
        this.mNMService = nms;
    }

    public boolean start() {
        try {
            this.mNetworkInterface = NetworkInterface.getByName(this.mIfName);
        }
        catch (SocketException e) {
            Log.e(TAG, "Failed to find NetworkInterface for " + this.mIfName, e);
            this.stop();
            return false;
        }
        try {
            this.mHwAddr = this.mNetworkInterface.getHardwareAddress();
        }
        catch (SocketException e) {
            Log.e(TAG, "Failed to find hardware address for " + this.mIfName, e);
            this.stop();
            return false;
        }
        int ifindex = this.mNetworkInterface.getIndex();
        this.mRaDaemon = new RouterAdvertisementDaemon(this.mIfName, ifindex, this.mHwAddr);
        if (!this.mRaDaemon.start()) {
            this.stop();
            return false;
        }
        return true;
    }

    public void stop() {
        this.mNetworkInterface = null;
        this.mHwAddr = null;
        this.setRaParams(null);
        if (this.mRaDaemon != null) {
            this.mRaDaemon.stop();
            this.mRaDaemon = null;
        }
    }

    public void updateUpstreamIPv6LinkProperties(LinkProperties v6only) {
        if (this.mRaDaemon == null) {
            return;
        }
        if (Objects.equals(this.mLastIPv6LinkProperties, v6only)) {
            return;
        }
        RouterAdvertisementDaemon.RaParams params = null;
        if (v6only != null) {
            params = new RouterAdvertisementDaemon.RaParams();
            params.mtu = v6only.getMtu();
            params.hasDefaultRoute = v6only.hasIPv6DefaultRoute();
            for (LinkAddress linkAddr : v6only.getLinkAddresses()) {
                if (linkAddr.getPrefixLength() != 64) continue;
                IpPrefix prefix = new IpPrefix(linkAddr.getAddress(), linkAddr.getPrefixLength());
                params.prefixes.add(prefix);
                Inet6Address dnsServer = IPv6TetheringInterfaceServices.getLocalDnsIpFor(prefix);
                if (dnsServer == null) continue;
                params.dnses.add(dnsServer);
            }
        }
        this.setRaParams(params);
        this.mLastIPv6LinkProperties = v6only;
    }

    private void configureLocalRoutes(HashSet<IpPrefix> deprecatedPrefixes, HashSet<IpPrefix> newPrefixes) {
        if (!deprecatedPrefixes.isEmpty()) {
            ArrayList<RouteInfo> toBeRemoved = this.getLocalRoutesFor(deprecatedPrefixes);
            try {
                int removalFailures = this.mNMService.removeRoutesFromLocalNetwork(toBeRemoved);
                if (removalFailures > 0) {
                    Log.e(TAG, String.format("Failed to remove %d IPv6 routes from local table.", removalFailures));
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to remove IPv6 routes from local table: ", e);
            }
        }
        if (newPrefixes != null && !newPrefixes.isEmpty()) {
            HashSet addedPrefixes = (HashSet)newPrefixes.clone();
            if (this.mLastRaParams != null) {
                addedPrefixes.removeAll(this.mLastRaParams.prefixes);
            }
            if (this.mLastRaParams == null || this.mLastRaParams.prefixes.isEmpty()) {
                addedPrefixes.add(LINK_LOCAL_PREFIX);
            }
            if (!addedPrefixes.isEmpty()) {
                ArrayList<RouteInfo> toBeAdded = this.getLocalRoutesFor(addedPrefixes);
                try {
                    this.mNMService.addInterfaceToLocalNetwork(this.mIfName, toBeAdded);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Failed to add IPv6 routes to local table: ", e);
                }
            }
        }
    }

    private void configureLocalDns(HashSet<Inet6Address> deprecatedDnses, HashSet<Inet6Address> newDnses) {
        block13: {
            INetd netd = this.getNetdServiceOrNull();
            if (netd == null) {
                if (newDnses != null) {
                    newDnses.clear();
                }
                Log.e(TAG, "No netd service instance available; not setting local IPv6 addresses");
                return;
            }
            if (!deprecatedDnses.isEmpty()) {
                for (Inet6Address dns : deprecatedDnses) {
                    String dnsString = dns.getHostAddress();
                    try {
                        netd.interfaceDelAddress(this.mIfName, dnsString, 64);
                    }
                    catch (RemoteException | ServiceSpecificException e) {
                        Log.e(TAG, "Failed to remove local dns IP: " + dnsString, e);
                    }
                }
            }
            if (newDnses != null && !newDnses.isEmpty()) {
                HashSet addedDnses = (HashSet)newDnses.clone();
                if (this.mLastRaParams != null) {
                    addedDnses.removeAll(this.mLastRaParams.dnses);
                }
                for (Inet6Address dns : addedDnses) {
                    String dnsString = dns.getHostAddress();
                    try {
                        netd.interfaceAddAddress(this.mIfName, dnsString, 64);
                    }
                    catch (RemoteException | ServiceSpecificException e) {
                        Log.e(TAG, "Failed to add local dns IP: " + dnsString, e);
                        newDnses.remove(dns);
                    }
                }
            }
            try {
                netd.tetherApplyDnsInterfaces();
            }
            catch (RemoteException | ServiceSpecificException e) {
                Log.e(TAG, "Failed to update local DNS caching server");
                if (newDnses == null) break block13;
                newDnses.clear();
            }
        }
    }

    private void setRaParams(RouterAdvertisementDaemon.RaParams newParams) {
        if (this.mRaDaemon != null) {
            RouterAdvertisementDaemon.RaParams deprecatedParams = RouterAdvertisementDaemon.RaParams.getDeprecatedRaParams(this.mLastRaParams, newParams);
            this.configureLocalRoutes(deprecatedParams.prefixes, newParams != null ? newParams.prefixes : null);
            this.configureLocalDns(deprecatedParams.dnses, newParams != null ? newParams.dnses : null);
            this.mRaDaemon.buildNewRa(deprecatedParams, newParams);
        }
        this.mLastRaParams = newParams;
    }

    private ArrayList<RouteInfo> getLocalRoutesFor(HashSet<IpPrefix> prefixes) {
        ArrayList<RouteInfo> localRoutes = new ArrayList<RouteInfo>();
        for (IpPrefix ipp : prefixes) {
            localRoutes.add(new RouteInfo(ipp, null, this.mIfName));
        }
        return localRoutes;
    }

    private INetd getNetdServiceOrNull() {
        if (this.mNMService != null) {
            try {
                return this.mNMService.getNetdService();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Inet6Address getLocalDnsIpFor(IpPrefix localPrefix) {
        byte[] dnsBytes = localPrefix.getRawAddress();
        dnsBytes[dnsBytes.length - 1] = 1;
        try {
            return Inet6Address.getByAddress(null, dnsBytes, 0);
        }
        catch (UnknownHostException e) {
            Slog.wtf(TAG, "Failed to construct Inet6Address from: " + localPrefix);
            return null;
        }
    }
}

