/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import android.hardware.hdmi.IHdmiControlCallback;
import android.os.RemoteException;
import android.util.Slog;
import com.android.server.hdmi.HdmiCecFeatureAction;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiCecMessageBuilder;
import java.util.ArrayList;
import java.util.List;

final class DevicePowerStatusAction
extends HdmiCecFeatureAction {
    private static final String TAG = "DevicePowerStatusAction";
    private static final int STATE_WAITING_FOR_REPORT_POWER_STATUS = 1;
    private final int mTargetAddress;
    private final List<IHdmiControlCallback> mCallbacks = new ArrayList<IHdmiControlCallback>();

    static DevicePowerStatusAction create(HdmiCecLocalDevice source, int targetAddress, IHdmiControlCallback callback) {
        if (source == null || callback == null) {
            Slog.e(TAG, "Wrong arguments");
            return null;
        }
        return new DevicePowerStatusAction(source, targetAddress, callback);
    }

    private DevicePowerStatusAction(HdmiCecLocalDevice localDevice, int targetAddress, IHdmiControlCallback callback) {
        super(localDevice);
        this.mTargetAddress = targetAddress;
        this.addCallback(callback);
    }

    @Override
    boolean start() {
        this.queryDevicePowerStatus();
        this.mState = 1;
        this.addTimer(this.mState, 2000);
        return true;
    }

    private void queryDevicePowerStatus() {
        this.sendCommand(HdmiCecMessageBuilder.buildGiveDevicePowerStatus(this.getSourceAddress(), this.mTargetAddress));
    }

    @Override
    boolean processCommand(HdmiCecMessage cmd) {
        if (this.mState != 1 || this.mTargetAddress != cmd.getSource()) {
            return false;
        }
        if (cmd.getOpcode() == 144) {
            byte status = cmd.getParams()[0];
            this.invokeCallback(status);
            this.finish();
            return true;
        }
        return false;
    }

    @Override
    void handleTimerEvent(int state) {
        if (this.mState != state) {
            return;
        }
        if (state == 1) {
            this.invokeCallback(-1);
            this.finish();
        }
    }

    public void addCallback(IHdmiControlCallback callback) {
        this.mCallbacks.add(callback);
    }

    private void invokeCallback(int result) {
        try {
            for (IHdmiControlCallback callback : this.mCallbacks) {
                callback.onComplete(result);
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Callback failed:" + e);
        }
    }
}

