/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import android.hardware.hdmi.IHdmiControlCallback;
import android.os.RemoteException;
import android.util.Slog;
import com.android.server.hdmi.HdmiCecFeatureAction;
import com.android.server.hdmi.HdmiCecKeycode;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiCecMessageBuilder;
import com.android.server.hdmi.HdmiControlService;

final class SystemAudioStatusAction
extends HdmiCecFeatureAction {
    private static final String TAG = "SystemAudioStatusAction";
    private static final int STATE_WAIT_FOR_REPORT_AUDIO_STATUS = 1;
    private final int mAvrAddress;
    private final IHdmiControlCallback mCallback;

    SystemAudioStatusAction(HdmiCecLocalDevice source, int avrAddress, IHdmiControlCallback callback) {
        super(source);
        this.mAvrAddress = avrAddress;
        this.mCallback = callback;
    }

    @Override
    boolean start() {
        this.mState = 1;
        this.addTimer(this.mState, 2000);
        this.sendGiveAudioStatus();
        return true;
    }

    private void sendGiveAudioStatus() {
        this.sendCommand(HdmiCecMessageBuilder.buildGiveAudioStatus(this.getSourceAddress(), this.mAvrAddress), new HdmiControlService.SendMessageCallback(){

            @Override
            public void onSendCompleted(int error) {
                if (error != 0) {
                    SystemAudioStatusAction.this.handleSendGiveAudioStatusFailure();
                }
            }
        });
    }

    private void handleSendGiveAudioStatusFailure() {
        this.tv().setAudioStatus(false, -1);
        this.sendUserControlPressedAndReleased(this.mAvrAddress, HdmiCecKeycode.getMuteKey(!this.tv().isSystemAudioActivated()));
        this.finishWithCallback(0);
    }

    @Override
    boolean processCommand(HdmiCecMessage cmd) {
        if (this.mState != 1 || this.mAvrAddress != cmd.getSource()) {
            return false;
        }
        switch (cmd.getOpcode()) {
            case 122: {
                this.handleReportAudioStatus(cmd);
                return true;
            }
        }
        return false;
    }

    private void handleReportAudioStatus(HdmiCecMessage cmd) {
        byte[] params = cmd.getParams();
        boolean mute = (params[0] & 0x80) == 128;
        int volume = params[0] & 0x7F;
        this.tv().setAudioStatus(mute, volume);
        if (!(this.tv().isSystemAudioActivated() ^ mute)) {
            this.sendUserControlPressedAndReleased(this.mAvrAddress, 67);
        }
        this.finishWithCallback(0);
    }

    private void finishWithCallback(int returnCode) {
        if (this.mCallback != null) {
            try {
                this.mCallback.onComplete(returnCode);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to invoke callback.", e);
            }
        }
        this.finish();
    }

    @Override
    void handleTimerEvent(int state) {
        if (this.mState != state) {
            return;
        }
        this.handleSendGiveAudioStatusFailure();
    }
}

