/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.media;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.content.Context;
import android.content.Intent;
import android.media.IMediaResourceMonitor;
import android.os.Binder;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.Log;
import android.util.Slog;
import com.android.server.SystemService;

public class MediaResourceMonitorService
extends SystemService {
    private static final String TAG = "MediaResourceMonitor";
    private static final boolean DEBUG = Log.isLoggable("MediaResourceMonitor", 3);
    private static final String SERVICE_NAME = "media_resource_monitor";
    private final MediaResourceMonitorImpl mMediaResourceMonitorImpl = new MediaResourceMonitorImpl();

    public MediaResourceMonitorService(Context context) {
        super(context);
    }

    @Override
    public void onStart() {
        this.publishBinderService(SERVICE_NAME, this.mMediaResourceMonitorImpl);
    }

    class MediaResourceMonitorImpl
    extends IMediaResourceMonitor.Stub {
        MediaResourceMonitorImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyResourceGranted(int pid, int type) throws RemoteException {
            if (DEBUG) {
                Slog.d(MediaResourceMonitorService.TAG, "notifyResourceGranted(pid=" + pid + ", type=" + type + ")");
            }
            long identity = Binder.clearCallingIdentity();
            try {
                String[] pkgNames = this.getPackageNamesFromPid(pid);
                if (pkgNames == null) {
                    return;
                }
                UserManager manager = (UserManager)MediaResourceMonitorService.this.getContext().getSystemService("user");
                int[] userIds = manager.getEnabledProfileIds(ActivityManager.getCurrentUser());
                if (userIds == null || userIds.length == 0) {
                    return;
                }
                Intent intent = new Intent("android.intent.action.MEDIA_RESOURCE_GRANTED");
                intent.putExtra("android.intent.extra.PACKAGES", pkgNames);
                intent.putExtra("android.intent.extra.MEDIA_RESOURCE_TYPE", type);
                for (int userId : userIds) {
                    MediaResourceMonitorService.this.getContext().sendBroadcastAsUser(intent, UserHandle.of(userId), "android.permission.RECEIVE_MEDIA_RESOURCE_USAGE");
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        private String[] getPackageNamesFromPid(int pid) {
            try {
                for (ActivityManager.RunningAppProcessInfo proc : ActivityManagerNative.getDefault().getRunningAppProcesses()) {
                    if (proc.pid != pid) continue;
                    return proc.pkgList;
                }
            }
            catch (RemoteException e) {
                Slog.w(MediaResourceMonitorService.TAG, "ActivityManager.getRunningAppProcesses() failed");
            }
            return null;
        }
    }
}

