/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.media;

import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.app.PendingIntent;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.ContentObserver;
import android.media.AudioManagerInternal;
import android.media.AudioSystem;
import android.media.IAudioService;
import android.media.IRemoteVolumeController;
import android.media.session.IActiveSessionsListener;
import android.media.session.ISession;
import android.media.session.ISessionCallback;
import android.media.session.ISessionManager;
import android.media.session.MediaSession;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.view.KeyEvent;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.Watchdog;
import com.android.server.media.MediaSessionRecord;
import com.android.server.media.MediaSessionStack;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MediaSessionService
extends SystemService
implements Watchdog.Monitor {
    private static final String TAG = "MediaSessionService";
    private static final boolean DEBUG = Log.isLoggable("MediaSessionService", 3);
    private static final int WAKELOCK_TIMEOUT = 5000;
    final IBinder mICallback = new Binder();
    private final SessionManagerImpl mSessionManagerImpl;
    private final MediaSessionStack mPriorityStack;
    private final ArrayList<MediaSessionRecord> mAllSessions = new ArrayList();
    private final SparseArray<UserRecord> mUserRecords = new SparseArray();
    private final ArrayList<SessionsListenerRecord> mSessionsListeners = new ArrayList();
    private final Object mLock = new Object();
    private final MessageHandler mHandler = new MessageHandler();
    private final PowerManager.WakeLock mMediaEventWakeLock;
    private KeyguardManager mKeyguardManager;
    private IAudioService mAudioService;
    private AudioManagerInternal mAudioManagerInternal;
    private ContentResolver mContentResolver;
    private SettingsObserver mSettingsObserver;
    private final List<Integer> mCurrentUserIdList = new ArrayList<Integer>();
    private IRemoteVolumeController mRvc;

    public MediaSessionService(Context context) {
        super(context);
        this.mSessionManagerImpl = new SessionManagerImpl();
        this.mPriorityStack = new MediaSessionStack();
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mMediaEventWakeLock = pm.newWakeLock(1, "handleMediaEvent");
    }

    @Override
    public void onStart() {
        this.publishBinderService("media_session", this.mSessionManagerImpl);
        Watchdog.getInstance().addMonitor(this);
        this.mKeyguardManager = (KeyguardManager)this.getContext().getSystemService("keyguard");
        this.mAudioService = this.getAudioService();
        this.mAudioManagerInternal = LocalServices.getService(AudioManagerInternal.class);
        this.mContentResolver = this.getContext().getContentResolver();
        this.mSettingsObserver = new SettingsObserver();
        this.mSettingsObserver.observe();
        this.updateUser();
    }

    private IAudioService getAudioService() {
        IBinder b = ServiceManager.getService("audio");
        return IAudioService.Stub.asInterface(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSession(MediaSessionRecord record) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mAllSessions.contains(record)) {
                Log.d(TAG, "Unknown session updated. Ignoring.");
                return;
            }
            this.mPriorityStack.onSessionStateChange(record);
        }
        this.mHandler.post(1, record.getUserId(), 0);
    }

    public void notifyRemoteVolumeChanged(int flags, MediaSessionRecord session) {
        if (this.mRvc == null) {
            return;
        }
        try {
            this.mRvc.remoteVolumeChanged(session.getControllerBinder(), flags);
        }
        catch (Exception e) {
            Log.wtf(TAG, "Error sending volume change to system UI.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSessionPlaystateChange(MediaSessionRecord record, int oldState, int newState) {
        boolean updateSessions = false;
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mAllSessions.contains(record)) {
                Log.d(TAG, "Unknown session changed playback state. Ignoring.");
                return;
            }
            updateSessions = this.mPriorityStack.onPlaystateChange(record, oldState, newState);
        }
        if (updateSessions) {
            this.mHandler.post(1, record.getUserId(), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSessionPlaybackTypeChanged(MediaSessionRecord record) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mAllSessions.contains(record)) {
                Log.d(TAG, "Unknown session changed playback type. Ignoring.");
                return;
            }
            this.pushRemoteVolumeUpdateLocked(record.getUserId());
        }
    }

    @Override
    public void onStartUser(int userId) {
        if (DEBUG) {
            Log.d(TAG, "onStartUser: " + userId);
        }
        this.updateUser();
    }

    @Override
    public void onSwitchUser(int userId) {
        if (DEBUG) {
            Log.d(TAG, "onSwitchUser: " + userId);
        }
        this.updateUser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStopUser(int userId) {
        if (DEBUG) {
            Log.d(TAG, "onStopUser: " + userId);
        }
        Object object = this.mLock;
        synchronized (object) {
            UserRecord user = this.mUserRecords.get(userId);
            if (user != null) {
                this.destroyUserLocked(user);
            }
            this.updateUser();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitor() {
        Object object = this.mLock;
        synchronized (object) {
        }
    }

    protected void enforcePhoneStatePermission(int pid, int uid) {
        if (this.getContext().checkPermission("android.permission.MODIFY_PHONE_STATE", pid, uid) != 0) {
            throw new SecurityException("Must hold the MODIFY_PHONE_STATE permission.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sessionDied(MediaSessionRecord session) {
        Object object = this.mLock;
        synchronized (object) {
            this.destroySessionLocked(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroySession(MediaSessionRecord session) {
        Object object = this.mLock;
        synchronized (object) {
            this.destroySessionLocked(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUser() {
        Object object = this.mLock;
        synchronized (object) {
            UserManager manager = (UserManager)this.getContext().getSystemService("user");
            int currentUser = ActivityManager.getCurrentUser();
            int[] userIds = manager.getProfileIdsWithDisabled(currentUser);
            this.mCurrentUserIdList.clear();
            if (userIds != null && userIds.length > 0) {
                for (int userId : userIds) {
                    this.mCurrentUserIdList.add(userId);
                }
            } else {
                Log.w(TAG, "Failed to get enabled profiles.");
                this.mCurrentUserIdList.add(currentUser);
            }
            Object object2 = this.mCurrentUserIdList.iterator();
            while (object2.hasNext()) {
                int userId = (Integer)object2.next();
                if (this.mUserRecords.get(userId) != null) continue;
                this.mUserRecords.put(userId, new UserRecord(this.getContext(), userId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActiveSessionListeners() {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = this.mSessionsListeners.size() - 1; i >= 0; --i) {
                SessionsListenerRecord listener = this.mSessionsListeners.get(i);
                try {
                    this.enforceMediaPermissions(listener.mComponentName, listener.mPid, listener.mUid, listener.mUserId);
                    continue;
                }
                catch (SecurityException e) {
                    Log.i(TAG, "ActiveSessionsListener " + listener.mComponentName + " is no longer authorized. Disconnecting.");
                    this.mSessionsListeners.remove(i);
                    try {
                        listener.mListener.onActiveSessionsChanged(new ArrayList<MediaSession.Token>());
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void destroyUserLocked(UserRecord user) {
        user.destroyLocked();
        this.mUserRecords.remove(user.mUserId);
    }

    private void destroySessionLocked(MediaSessionRecord session) {
        int userId;
        UserRecord user;
        if (DEBUG) {
            Log.d(TAG, "Destroying session : " + session.toString());
        }
        if ((user = this.mUserRecords.get(userId = session.getUserId())) != null) {
            user.removeSessionLocked(session);
        }
        this.mPriorityStack.removeSession(session);
        this.mAllSessions.remove(session);
        try {
            session.getCallback().asBinder().unlinkToDeath(session, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        session.onDestroy();
        this.mHandler.post(1, session.getUserId(), 0);
    }

    private void enforcePackageName(String packageName, int uid) {
        if (TextUtils.isEmpty(packageName)) {
            throw new IllegalArgumentException("packageName may not be empty");
        }
        String[] packages = this.getContext().getPackageManager().getPackagesForUid(uid);
        int packageCount = packages.length;
        for (int i = 0; i < packageCount; ++i) {
            if (!packageName.equals(packages[i])) continue;
            return;
        }
        throw new IllegalArgumentException("packageName is not owned by the calling process");
    }

    private void enforceMediaPermissions(ComponentName compName, int pid, int uid, int resolvedUserId) {
        if (this.isCurrentVolumeController(uid)) {
            return;
        }
        if (this.getContext().checkPermission("android.permission.MEDIA_CONTENT_CONTROL", pid, uid) != 0 && !this.isEnabledNotificationListener(compName, UserHandle.getUserId(uid), resolvedUserId)) {
            throw new SecurityException("Missing permission to control media.");
        }
    }

    private boolean isCurrentVolumeController(int uid) {
        int vcuid;
        return this.mAudioManagerInternal != null && (vcuid = this.mAudioManagerInternal.getVolumeControllerUid()) > 0 && uid == vcuid;
    }

    private void enforceSystemUiPermission(String action, int pid, int uid) {
        if (this.isCurrentVolumeController(uid)) {
            return;
        }
        if (this.getContext().checkPermission("android.permission.STATUS_BAR_SERVICE", pid, uid) != 0) {
            throw new SecurityException("Only system ui may " + action);
        }
    }

    private boolean isEnabledNotificationListener(ComponentName compName, int userId, int forUserId) {
        if (userId != forUserId) {
            return false;
        }
        if (DEBUG) {
            Log.d(TAG, "Checking if enabled notification listener " + compName);
        }
        if (compName != null) {
            String enabledNotifListeners = Settings.Secure.getStringForUser(this.mContentResolver, "enabled_notification_listeners", userId);
            if (enabledNotifListeners != null) {
                String[] components = enabledNotifListeners.split(":");
                for (int i = 0; i < components.length; ++i) {
                    ComponentName component = ComponentName.unflattenFromString(components[i]);
                    if (component == null || !compName.equals(component)) continue;
                    if (DEBUG) {
                        Log.d(TAG, "ok to get sessions: " + component + " is authorized notification listener");
                    }
                    return true;
                }
            }
            if (DEBUG) {
                Log.d(TAG, "not ok to get sessions, " + compName + " is not in list of ENABLED_NOTIFICATION_LISTENERS for user " + userId);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaSessionRecord createSessionInternal(int callerPid, int callerUid, int userId, String callerPackageName, ISessionCallback cb, String tag) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            return this.createSessionLocked(callerPid, callerUid, userId, callerPackageName, cb, tag);
        }
    }

    private MediaSessionRecord createSessionLocked(int callerPid, int callerUid, int userId, String callerPackageName, ISessionCallback cb, String tag) {
        UserRecord user = this.mUserRecords.get(userId);
        if (user == null) {
            Log.wtf(TAG, "Request from invalid user: " + userId);
            throw new RuntimeException("Session request from invalid user.");
        }
        MediaSessionRecord session = new MediaSessionRecord(callerPid, callerUid, userId, callerPackageName, cb, tag, this, this.mHandler);
        try {
            cb.asBinder().linkToDeath(session, 0);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Media Session owner died prematurely.", e);
        }
        this.mAllSessions.add(session);
        this.mPriorityStack.addSession(session, this.mCurrentUserIdList.contains(userId));
        user.addSessionLocked(session);
        this.mHandler.post(1, userId, 0);
        if (DEBUG) {
            Log.d(TAG, "Created session for package " + callerPackageName + " with tag " + tag);
        }
        return session;
    }

    private int findIndexOfSessionsListenerLocked(IActiveSessionsListener listener) {
        for (int i = this.mSessionsListeners.size() - 1; i >= 0; --i) {
            if (this.mSessionsListeners.get(i).mListener.asBinder() != listener.asBinder()) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushSessionsChanged(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            int i;
            ArrayList<MediaSessionRecord> records = this.mPriorityStack.getActiveSessions(userId);
            int size = records.size();
            if (size > 0 && ((MediaSessionRecord)records.get(0)).isPlaybackActive(false)) {
                this.rememberMediaButtonReceiverLocked((MediaSessionRecord)records.get(0));
            }
            ArrayList<MediaSession.Token> tokens = new ArrayList<MediaSession.Token>();
            for (i = 0; i < size; ++i) {
                tokens.add(new MediaSession.Token(((MediaSessionRecord)records.get(i)).getControllerBinder()));
            }
            this.pushRemoteVolumeUpdateLocked(userId);
            for (i = this.mSessionsListeners.size() - 1; i >= 0; --i) {
                SessionsListenerRecord record = this.mSessionsListeners.get(i);
                if (record.mUserId != -1 && record.mUserId != userId) continue;
                try {
                    record.mListener.onActiveSessionsChanged(tokens);
                    continue;
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Dead ActiveSessionsListener in pushSessionsChanged, removing", e);
                    this.mSessionsListeners.remove(i);
                }
            }
        }
    }

    private void pushRemoteVolumeUpdateLocked(int userId) {
        if (this.mRvc != null) {
            try {
                MediaSessionRecord record = this.mPriorityStack.getDefaultRemoteSession(userId);
                this.mRvc.updateRemoteController(record == null ? null : record.getControllerBinder());
            }
            catch (RemoteException e) {
                Log.wtf(TAG, "Error sending default remote volume to sys ui.", e);
            }
        }
    }

    private void rememberMediaButtonReceiverLocked(MediaSessionRecord record) {
        PendingIntent receiver = record.getMediaButtonReceiver();
        UserRecord user = this.mUserRecords.get(record.getUserId());
        if (receiver != null && user != null) {
            user.mLastMediaButtonReceiver = receiver;
            ComponentName component = receiver.getIntent().getComponent();
            if (component != null && record.getPackageName().equals(component.getPackageName())) {
                Settings.Secure.putStringForUser(this.mContentResolver, "media_button_receiver", component.flattenToString(), record.getUserId());
            }
        }
    }

    final class MessageHandler
    extends Handler {
        private static final int MSG_SESSIONS_CHANGED = 1;

        MessageHandler() {
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    MediaSessionService.this.pushSessionsChanged(msg.arg1);
                }
            }
        }

        public void post(int what, int arg1, int arg2) {
            this.obtainMessage(what, arg1, arg2).sendToTarget();
        }
    }

    class SessionManagerImpl
    extends ISessionManager.Stub {
        private static final String EXTRA_WAKELOCK_ACQUIRED = "android.media.AudioService.WAKELOCK_ACQUIRED";
        private static final int WAKELOCK_RELEASE_ON_FINISHED = 1980;
        private boolean mVoiceButtonDown = false;
        private boolean mVoiceButtonHandled = false;
        private KeyEventWakeLockReceiver mKeyEventReceiver = new KeyEventWakeLockReceiver(MediaSessionService.access$2800(MediaSessionService.this));
        BroadcastReceiver mKeyEventDone = new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                if (intent == null) {
                    return;
                }
                Bundle extras = intent.getExtras();
                if (extras == null) {
                    return;
                }
                Object object = MediaSessionService.this.mLock;
                synchronized (object) {
                    if (extras.containsKey(SessionManagerImpl.EXTRA_WAKELOCK_ACQUIRED) && MediaSessionService.this.mMediaEventWakeLock.isHeld()) {
                        MediaSessionService.this.mMediaEventWakeLock.release();
                    }
                }
            }
        };

        SessionManagerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ISession createSession(String packageName, ISessionCallback cb, String tag, int userId) throws RemoteException {
            int pid = Binder.getCallingPid();
            int uid = Binder.getCallingUid();
            long token = Binder.clearCallingIdentity();
            try {
                MediaSessionService.this.enforcePackageName(packageName, uid);
                int resolvedUserId = ActivityManager.handleIncomingUser(pid, uid, userId, false, true, "createSession", packageName);
                if (cb == null) {
                    throw new IllegalArgumentException("Controller callback cannot be null");
                }
                ISession iSession = MediaSessionService.this.createSessionInternal(pid, uid, resolvedUserId, packageName, cb, tag).getSessionBinder();
                return iSession;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<IBinder> getSessions(ComponentName componentName, int userId) {
            int pid = Binder.getCallingPid();
            int uid = Binder.getCallingUid();
            long token = Binder.clearCallingIdentity();
            try {
                int resolvedUserId = this.verifySessionsRequest(componentName, userId, pid, uid);
                ArrayList<IBinder> binders = new ArrayList<IBinder>();
                ArrayList<IBinder> arrayList = MediaSessionService.this.mLock;
                synchronized (arrayList) {
                    ArrayList<MediaSessionRecord> records = MediaSessionService.this.mPriorityStack.getActiveSessions(resolvedUserId);
                    int size = records.size();
                    for (int i = 0; i < size; ++i) {
                        binders.add(records.get(i).getControllerBinder().asBinder());
                    }
                }
                arrayList = binders;
                return arrayList;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void addSessionsListener(IActiveSessionsListener listener, ComponentName componentName, int userId) throws RemoteException {
            int resolvedUserId;
            long token;
            int uid;
            int pid;
            block10: {
                pid = Binder.getCallingPid();
                uid = Binder.getCallingUid();
                token = Binder.clearCallingIdentity();
                resolvedUserId = this.verifySessionsRequest(componentName, userId, pid, uid);
                Object object = MediaSessionService.this.mLock;
                // MONITORENTER : object
                int index = MediaSessionService.this.findIndexOfSessionsListenerLocked(listener);
                if (index == -1) break block10;
                Log.w(MediaSessionService.TAG, "ActiveSessionsListener is already added, ignoring");
                // MONITOREXIT : object
                Binder.restoreCallingIdentity(token);
                return;
            }
            SessionsListenerRecord record = new SessionsListenerRecord(listener, componentName, resolvedUserId, pid, uid);
            try {
                listener.asBinder().linkToDeath(record, 0);
            }
            catch (RemoteException e) {
                Log.e(MediaSessionService.TAG, "ActiveSessionsListener is dead, ignoring it", e);
                // MONITOREXIT : object
                Binder.restoreCallingIdentity(token);
                return;
            }
            try {
                MediaSessionService.this.mSessionsListeners.add(record);
                // MONITOREXIT : object
                return;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeSessionsListener(IActiveSessionsListener listener) throws RemoteException {
            Object object = MediaSessionService.this.mLock;
            synchronized (object) {
                int index = MediaSessionService.this.findIndexOfSessionsListenerLocked(listener);
                if (index != -1) {
                    SessionsListenerRecord record = (SessionsListenerRecord)MediaSessionService.this.mSessionsListeners.remove(index);
                    try {
                        record.mListener.asBinder().unlinkToDeath(record, 0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatchMediaKeyEvent(KeyEvent keyEvent, boolean needWakeLock) {
            if (keyEvent == null || !KeyEvent.isMediaKey(keyEvent.getKeyCode())) {
                Log.w(MediaSessionService.TAG, "Attempted to dispatch null or non-media key event.");
                return;
            }
            int pid = Binder.getCallingPid();
            int uid = Binder.getCallingUid();
            long token = Binder.clearCallingIdentity();
            try {
                if (DEBUG) {
                    Log.d(MediaSessionService.TAG, "dispatchMediaKeyEvent, pid=" + pid + ", uid=" + uid + ", event=" + keyEvent);
                }
                if (!this.isUserSetupComplete()) {
                    Slog.i(MediaSessionService.TAG, "Not dispatching media key event because user setup is in progress.");
                    return;
                }
                if (this.isGlobalPriorityActive() && uid != 1000) {
                    Slog.i(MediaSessionService.TAG, "Only the system can dispatch media key event to the global priority session.");
                    return;
                }
                Object object = MediaSessionService.this.mLock;
                synchronized (object) {
                    boolean useNotPlayingSessions = true;
                    Iterator iterator = MediaSessionService.this.mCurrentUserIdList.iterator();
                    while (iterator.hasNext()) {
                        int userId = (Integer)iterator.next();
                        UserRecord ur = (UserRecord)MediaSessionService.this.mUserRecords.get(userId);
                        if (ur.mLastMediaButtonReceiver == null && ur.mRestoredMediaButtonReceiver == null) continue;
                        useNotPlayingSessions = false;
                        break;
                    }
                    if (DEBUG) {
                        Log.d(MediaSessionService.TAG, "dispatchMediaKeyEvent, useNotPlayingSessions=" + useNotPlayingSessions);
                    }
                    MediaSessionRecord session = MediaSessionService.this.mPriorityStack.getDefaultMediaButtonSession(MediaSessionService.this.mCurrentUserIdList, useNotPlayingSessions);
                    if (this.isVoiceKey(keyEvent.getKeyCode())) {
                        this.handleVoiceKeyEventLocked(keyEvent, needWakeLock, session);
                    } else {
                        this.dispatchMediaKeyEventLocked(keyEvent, needWakeLock, session);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatchAdjustVolume(int suggestedStream, int delta, int flags) {
            long token = Binder.clearCallingIdentity();
            try {
                Object object = MediaSessionService.this.mLock;
                synchronized (object) {
                    MediaSessionRecord session = MediaSessionService.this.mPriorityStack.getDefaultVolumeSession(MediaSessionService.this.mCurrentUserIdList);
                    this.dispatchAdjustVolumeLocked(suggestedStream, delta, flags, session);
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setRemoteVolumeController(IRemoteVolumeController rvc) {
            int pid = Binder.getCallingPid();
            int uid = Binder.getCallingUid();
            long token = Binder.clearCallingIdentity();
            try {
                MediaSessionService.this.enforceSystemUiPermission("listen for volume changes", pid, uid);
                MediaSessionService.this.mRvc = rvc;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        @Override
        public boolean isGlobalPriorityActive() {
            return MediaSessionService.this.mPriorityStack.isGlobalPriorityActive();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (MediaSessionService.this.getContext().checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
                pw.println("Permission Denial: can't dump MediaSessionService from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
                return;
            }
            pw.println("MEDIA SESSION SERVICE (dumpsys media_session)");
            pw.println();
            Object object = MediaSessionService.this.mLock;
            synchronized (object) {
                int i;
                pw.println(MediaSessionService.this.mSessionsListeners.size() + " sessions listeners.");
                int count = MediaSessionService.this.mAllSessions.size();
                pw.println(count + " Sessions:");
                for (i = 0; i < count; ++i) {
                    ((MediaSessionRecord)MediaSessionService.this.mAllSessions.get(i)).dump(pw, "");
                    pw.println();
                }
                MediaSessionService.this.mPriorityStack.dump(pw, "");
                pw.println("User Records:");
                count = MediaSessionService.this.mUserRecords.size();
                for (i = 0; i < count; ++i) {
                    UserRecord user = (UserRecord)MediaSessionService.this.mUserRecords.get(MediaSessionService.this.mUserRecords.keyAt(i));
                    user.dumpLocked(pw, "");
                }
            }
        }

        private int verifySessionsRequest(ComponentName componentName, int userId, int pid, int uid) {
            String packageName = null;
            if (componentName != null) {
                packageName = componentName.getPackageName();
                MediaSessionService.this.enforcePackageName(packageName, uid);
            }
            int resolvedUserId = ActivityManager.handleIncomingUser(pid, uid, userId, true, true, "getSessions", packageName);
            MediaSessionService.this.enforceMediaPermissions(componentName, pid, uid, resolvedUserId);
            return resolvedUserId;
        }

        private void dispatchAdjustVolumeLocked(int suggestedStream, int direction, int flags, MediaSessionRecord session) {
            if (DEBUG) {
                String description = session == null ? null : session.toString();
                Log.d(MediaSessionService.TAG, "Adjusting session " + description + " by " + direction + ". flags=" + flags + ", suggestedStream=" + suggestedStream);
            }
            boolean preferSuggestedStream = false;
            if (this.isValidLocalStreamType(suggestedStream) && AudioSystem.isStreamActive(suggestedStream, 0)) {
                preferSuggestedStream = true;
            }
            if (session == null || preferSuggestedStream) {
                if ((flags & 0x200) != 0 && !AudioSystem.isStreamActive(3, 0)) {
                    if (DEBUG) {
                        Log.d(MediaSessionService.TAG, "No active session to adjust, skipping media only volume event");
                    }
                    return;
                }
                try {
                    String packageName = MediaSessionService.this.getContext().getOpPackageName();
                    MediaSessionService.this.mAudioService.adjustSuggestedStreamVolume(direction, suggestedStream, flags, packageName, MediaSessionService.TAG);
                }
                catch (RemoteException e) {
                    Log.e(MediaSessionService.TAG, "Error adjusting default volume.", e);
                }
            } else {
                session.adjustVolume(direction, flags, MediaSessionService.this.getContext().getPackageName(), 1000, true);
            }
        }

        private void handleVoiceKeyEventLocked(KeyEvent keyEvent, boolean needWakeLock, MediaSessionRecord session) {
            boolean isLongPress;
            if (session != null && session.hasFlag(65536)) {
                this.dispatchMediaKeyEventLocked(keyEvent, needWakeLock, session);
                return;
            }
            int action = keyEvent.getAction();
            boolean bl = isLongPress = (keyEvent.getFlags() & 0x80) != 0;
            if (action == 0) {
                if (keyEvent.getRepeatCount() == 0) {
                    this.mVoiceButtonDown = true;
                    this.mVoiceButtonHandled = false;
                } else if (this.mVoiceButtonDown && !this.mVoiceButtonHandled && isLongPress) {
                    this.mVoiceButtonHandled = true;
                    this.startVoiceInput(needWakeLock);
                }
            } else if (action == 1 && this.mVoiceButtonDown) {
                this.mVoiceButtonDown = false;
                if (!this.mVoiceButtonHandled && !keyEvent.isCanceled()) {
                    KeyEvent downEvent = KeyEvent.changeAction(keyEvent, 0);
                    this.dispatchMediaKeyEventLocked(downEvent, needWakeLock, session);
                    this.dispatchMediaKeyEventLocked(keyEvent, needWakeLock, session);
                }
            }
        }

        private void dispatchMediaKeyEventLocked(KeyEvent keyEvent, boolean needWakeLock, MediaSessionRecord session) {
            if (session != null) {
                if (DEBUG) {
                    Log.d(MediaSessionService.TAG, "Sending media key to " + session.toString());
                }
                if (needWakeLock) {
                    this.mKeyEventReceiver.aquireWakeLockLocked();
                }
                session.sendMediaButton(keyEvent, needWakeLock ? this.mKeyEventReceiver.mLastTimeoutId : -1, this.mKeyEventReceiver, 1000, MediaSessionService.this.getContext().getPackageName());
            } else {
                Iterator iterator = MediaSessionService.this.mCurrentUserIdList.iterator();
                while (iterator.hasNext()) {
                    int userId = (Integer)iterator.next();
                    UserRecord user = (UserRecord)MediaSessionService.this.mUserRecords.get(userId);
                    if (user.mLastMediaButtonReceiver == null && user.mRestoredMediaButtonReceiver == null) continue;
                    if (DEBUG) {
                        Log.d(MediaSessionService.TAG, "Sending media key to last known PendingIntent " + user.mLastMediaButtonReceiver + " or restored Intent " + user.mRestoredMediaButtonReceiver);
                    }
                    if (needWakeLock) {
                        this.mKeyEventReceiver.aquireWakeLockLocked();
                    }
                    Intent mediaButtonIntent = new Intent("android.intent.action.MEDIA_BUTTON");
                    mediaButtonIntent.addFlags(0x10000000);
                    mediaButtonIntent.putExtra("android.intent.extra.KEY_EVENT", keyEvent);
                    try {
                        if (user.mLastMediaButtonReceiver != null) {
                            user.mLastMediaButtonReceiver.send(MediaSessionService.this.getContext(), needWakeLock ? this.mKeyEventReceiver.mLastTimeoutId : -1, mediaButtonIntent, this.mKeyEventReceiver, MediaSessionService.this.mHandler);
                        } else {
                            mediaButtonIntent.setComponent(user.mRestoredMediaButtonReceiver);
                            MediaSessionService.this.getContext().sendBroadcastAsUser(mediaButtonIntent, UserHandle.of(userId));
                        }
                    }
                    catch (PendingIntent.CanceledException e) {
                        Log.i(MediaSessionService.TAG, "Error sending key event to media button receiver " + user.mLastMediaButtonReceiver, e);
                    }
                    return;
                }
                if (DEBUG) {
                    Log.d(MediaSessionService.TAG, "Sending media key ordered broadcast");
                }
                if (needWakeLock) {
                    MediaSessionService.this.mMediaEventWakeLock.acquire();
                }
                Intent keyIntent = new Intent("android.intent.action.MEDIA_BUTTON", null);
                keyIntent.addFlags(0x10000000);
                keyIntent.putExtra("android.intent.extra.KEY_EVENT", keyEvent);
                if (needWakeLock) {
                    keyIntent.putExtra(EXTRA_WAKELOCK_ACQUIRED, 1980);
                }
                MediaSessionService.this.getContext().sendOrderedBroadcastAsUser(keyIntent, UserHandle.CURRENT, null, this.mKeyEventDone, MediaSessionService.this.mHandler, -1, null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startVoiceInput(boolean needWakeLock) {
            boolean isLocked;
            Intent voiceIntent = null;
            PowerManager pm = (PowerManager)MediaSessionService.this.getContext().getSystemService("power");
            boolean bl = isLocked = MediaSessionService.this.mKeyguardManager != null && MediaSessionService.this.mKeyguardManager.isKeyguardLocked();
            if (!isLocked && pm.isScreenOn()) {
                voiceIntent = new Intent("android.speech.action.WEB_SEARCH");
                Log.i(MediaSessionService.TAG, "voice-based interactions: about to use ACTION_WEB_SEARCH");
            } else {
                voiceIntent = new Intent("android.speech.action.VOICE_SEARCH_HANDS_FREE");
                voiceIntent.putExtra("android.speech.extras.EXTRA_SECURE", isLocked && MediaSessionService.this.mKeyguardManager.isKeyguardSecure());
                Log.i(MediaSessionService.TAG, "voice-based interactions: about to use ACTION_VOICE_SEARCH_HANDS_FREE");
            }
            if (needWakeLock) {
                MediaSessionService.this.mMediaEventWakeLock.acquire();
            }
            try {
                if (voiceIntent != null) {
                    voiceIntent.setFlags(0x10800000);
                    if (DEBUG) {
                        Log.d(MediaSessionService.TAG, "voiceIntent: " + voiceIntent);
                    }
                    MediaSessionService.this.getContext().startActivityAsUser(voiceIntent, UserHandle.CURRENT);
                }
            }
            catch (ActivityNotFoundException e) {
                Log.w(MediaSessionService.TAG, "No activity for search: " + e);
            }
            finally {
                if (needWakeLock) {
                    MediaSessionService.this.mMediaEventWakeLock.release();
                }
            }
        }

        private boolean isVoiceKey(int keyCode) {
            return keyCode == 79;
        }

        private boolean isUserSetupComplete() {
            return Settings.Secure.getIntForUser(MediaSessionService.this.getContext().getContentResolver(), "user_setup_complete", 0, -2) != 0;
        }

        private boolean isValidLocalStreamType(int streamType) {
            return streamType >= 0 && streamType <= 5;
        }

        class KeyEventWakeLockReceiver
        extends ResultReceiver
        implements Runnable,
        PendingIntent.OnFinished {
            private final Handler mHandler;
            private int mRefCount;
            private int mLastTimeoutId;

            public KeyEventWakeLockReceiver(Handler handler) {
                super(handler);
                this.mRefCount = 0;
                this.mLastTimeoutId = 0;
                this.mHandler = handler;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTimeout() {
                Object object = MediaSessionService.this.mLock;
                synchronized (object) {
                    if (this.mRefCount == 0) {
                        return;
                    }
                    ++this.mLastTimeoutId;
                    this.mRefCount = 0;
                    this.releaseWakeLockLocked();
                }
            }

            public void aquireWakeLockLocked() {
                if (this.mRefCount == 0) {
                    MediaSessionService.this.mMediaEventWakeLock.acquire();
                }
                ++this.mRefCount;
                this.mHandler.removeCallbacks(this);
                this.mHandler.postDelayed(this, 5000L);
            }

            @Override
            public void run() {
                this.onTimeout();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onReceiveResult(int resultCode, Bundle resultData) {
                if (resultCode < this.mLastTimeoutId) {
                    return;
                }
                Object object = MediaSessionService.this.mLock;
                synchronized (object) {
                    if (this.mRefCount > 0) {
                        --this.mRefCount;
                        if (this.mRefCount == 0) {
                            this.releaseWakeLockLocked();
                        }
                    }
                }
            }

            private void releaseWakeLockLocked() {
                MediaSessionService.this.mMediaEventWakeLock.release();
                this.mHandler.removeCallbacks(this);
            }

            @Override
            public void onSendFinished(PendingIntent pendingIntent, Intent intent, int resultCode, String resultData, Bundle resultExtras) {
                this.onReceiveResult(resultCode, null);
            }
        }
    }

    final class SettingsObserver
    extends ContentObserver {
        private final Uri mSecureSettingsUri;

        private SettingsObserver() {
            super(null);
            this.mSecureSettingsUri = Settings.Secure.getUriFor("enabled_notification_listeners");
        }

        private void observe() {
            MediaSessionService.this.mContentResolver.registerContentObserver(this.mSecureSettingsUri, false, this, -1);
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            MediaSessionService.this.updateActiveSessionListeners();
        }
    }

    final class SessionsListenerRecord
    implements IBinder.DeathRecipient {
        private final IActiveSessionsListener mListener;
        private final ComponentName mComponentName;
        private final int mUserId;
        private final int mPid;
        private final int mUid;

        public SessionsListenerRecord(IActiveSessionsListener listener, ComponentName componentName, int userId, int pid, int uid) {
            this.mListener = listener;
            this.mComponentName = componentName;
            this.mUserId = userId;
            this.mPid = pid;
            this.mUid = uid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = MediaSessionService.this.mLock;
            synchronized (object) {
                MediaSessionService.this.mSessionsListeners.remove(this);
            }
        }
    }

    final class UserRecord {
        private final int mUserId;
        private final ArrayList<MediaSessionRecord> mSessions = new ArrayList();
        private final Context mContext;
        private PendingIntent mLastMediaButtonReceiver;
        private ComponentName mRestoredMediaButtonReceiver;

        public UserRecord(Context context, int userId) {
            this.mContext = context;
            this.mUserId = userId;
            this.restoreMediaButtonReceiver();
        }

        public void destroyLocked() {
            for (int i = this.mSessions.size() - 1; i >= 0; --i) {
                MediaSessionRecord session = this.mSessions.get(i);
                MediaSessionService.this.destroySessionLocked(session);
            }
        }

        public ArrayList<MediaSessionRecord> getSessionsLocked() {
            return this.mSessions;
        }

        public void addSessionLocked(MediaSessionRecord session) {
            this.mSessions.add(session);
        }

        public void removeSessionLocked(MediaSessionRecord session) {
            this.mSessions.remove(session);
        }

        public void dumpLocked(PrintWriter pw, String prefix) {
            pw.println(prefix + "Record for user " + this.mUserId);
            String indent = prefix + "  ";
            pw.println(indent + "MediaButtonReceiver:" + this.mLastMediaButtonReceiver);
            pw.println(indent + "Restored ButtonReceiver:" + this.mRestoredMediaButtonReceiver);
            int size = this.mSessions.size();
            pw.println(indent + size + " Sessions:");
            for (int i = 0; i < size; ++i) {
                pw.println(indent + this.mSessions.get(i).toString());
            }
        }

        private void restoreMediaButtonReceiver() {
            String receiverName = Settings.Secure.getStringForUser(MediaSessionService.this.mContentResolver, "media_button_receiver", this.mUserId);
            if (!TextUtils.isEmpty(receiverName)) {
                ComponentName eventReceiver = ComponentName.unflattenFromString(receiverName);
                if (eventReceiver == null) {
                    return;
                }
                this.mRestoredMediaButtonReceiver = eventReceiver;
            }
        }
    }
}

