/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.media;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.media.session.MediaSession;
import android.os.RemoteException;
import com.android.server.media.MediaSessionRecord;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

class MediaSessionStack {
    private static final int[] ALWAYS_PRIORITY_STATES = new int[]{4, 5, 9, 10};
    private static final int[] TRANSITION_PRIORITY_STATES = new int[]{6, 8, 3};
    private final ArrayList<MediaSessionRecord> mSessions = new ArrayList();
    private MediaSessionRecord mGlobalPrioritySession;
    private MediaSessionRecord mLastInterestingRecord;
    private MediaSessionRecord mCachedButtonReceiver;
    private MediaSessionRecord mCachedDefault;
    private MediaSessionRecord mCachedVolumeDefault;
    private ArrayList<MediaSessionRecord> mCachedActiveList;
    private ArrayList<MediaSessionRecord> mCachedTransportControlList;

    MediaSessionStack() {
    }

    private static boolean isFromMostRecentApp(MediaSessionRecord record) {
        try {
            List<ActivityManager.RecentTaskInfo> tasks = ActivityManagerNative.getDefault().getRecentTasks(1, 15, record.getUserId()).getList();
            if (tasks != null && !tasks.isEmpty()) {
                ActivityManager.RecentTaskInfo recentTask = tasks.get(0);
                if (recentTask.userId == record.getUserId() && recentTask.baseIntent != null) {
                    return recentTask.baseIntent.getComponent().getPackageName().equals(record.getPackageName());
                }
            }
        }
        catch (RemoteException e) {
            return false;
        }
        return false;
    }

    public void addSession(MediaSessionRecord record, boolean fromForegroundUser) {
        this.mSessions.add(record);
        this.clearCache();
        if (fromForegroundUser && MediaSessionStack.isFromMostRecentApp(record)) {
            this.mLastInterestingRecord = record;
        }
    }

    public void removeSession(MediaSessionRecord record) {
        this.mSessions.remove(record);
        if (record == this.mGlobalPrioritySession) {
            this.mGlobalPrioritySession = null;
        }
        this.clearCache();
    }

    public boolean onPlaystateChange(MediaSessionRecord record, int oldState, int newState) {
        if (this.shouldUpdatePriority(oldState, newState)) {
            this.mSessions.remove(record);
            this.mSessions.add(0, record);
            this.clearCache();
            this.mLastInterestingRecord = record;
            return true;
        }
        if (!MediaSession.isActiveState(newState)) {
            this.mCachedVolumeDefault = null;
        }
        return false;
    }

    public void onSessionStateChange(MediaSessionRecord record) {
        if ((record.getFlags() & 0x10000L) != 0L) {
            this.mGlobalPrioritySession = record;
        }
        this.clearCache();
    }

    public ArrayList<MediaSessionRecord> getActiveSessions(int userId) {
        if (this.mCachedActiveList == null) {
            this.mCachedActiveList = this.getPriorityListLocked(true, 0, userId);
        }
        return this.mCachedActiveList;
    }

    public ArrayList<MediaSessionRecord> getTransportControlSessions(int userId) {
        if (this.mCachedTransportControlList == null) {
            this.mCachedTransportControlList = this.getPriorityListLocked(true, 2, userId);
        }
        return this.mCachedTransportControlList;
    }

    public MediaSessionRecord getDefaultSession(int userId) {
        if (this.mCachedDefault != null) {
            return this.mCachedDefault;
        }
        ArrayList<MediaSessionRecord> records = this.getPriorityListLocked(true, 0, userId);
        if (records.size() > 0) {
            return records.get(0);
        }
        return null;
    }

    public MediaSessionRecord getDefaultMediaButtonSession(List<Integer> userIdList, boolean includeNotPlaying) {
        if (this.mGlobalPrioritySession != null && this.mGlobalPrioritySession.isActive()) {
            return this.mGlobalPrioritySession;
        }
        if (this.mCachedButtonReceiver != null) {
            return this.mCachedButtonReceiver;
        }
        ArrayList<MediaSessionRecord> records = this.getPriorityListLocked(true, 1, userIdList);
        if (records.size() > 0) {
            MediaSessionRecord record = records.get(0);
            if (record.isPlaybackActive(false)) {
                this.mLastInterestingRecord = record;
                this.mCachedButtonReceiver = record;
            } else if (this.mLastInterestingRecord != null) {
                if (records.contains(this.mLastInterestingRecord)) {
                    this.mCachedButtonReceiver = this.mLastInterestingRecord;
                } else {
                    this.mLastInterestingRecord = null;
                }
            }
            if (includeNotPlaying && this.mCachedButtonReceiver == null) {
                this.mCachedButtonReceiver = record;
            }
        }
        return this.mCachedButtonReceiver;
    }

    public MediaSessionRecord getDefaultVolumeSession(List<Integer> userIdList) {
        if (this.mGlobalPrioritySession != null && this.mGlobalPrioritySession.isActive()) {
            return this.mGlobalPrioritySession;
        }
        if (this.mCachedVolumeDefault != null) {
            return this.mCachedVolumeDefault;
        }
        ArrayList<MediaSessionRecord> records = this.getPriorityListLocked(true, 0, userIdList);
        int size = records.size();
        for (int i = 0; i < size; ++i) {
            MediaSessionRecord record = records.get(i);
            if (!record.isPlaybackActive(false)) continue;
            this.mCachedVolumeDefault = record;
            return record;
        }
        return null;
    }

    public MediaSessionRecord getDefaultRemoteSession(int userId) {
        ArrayList<MediaSessionRecord> records = this.getPriorityListLocked(true, 0, userId);
        int size = records.size();
        for (int i = 0; i < size; ++i) {
            MediaSessionRecord record = records.get(i);
            if (record.getPlaybackType() != 2) continue;
            return record;
        }
        return null;
    }

    public boolean isGlobalPriorityActive() {
        return this.mGlobalPrioritySession == null ? false : this.mGlobalPrioritySession.isActive();
    }

    public void dump(PrintWriter pw, String prefix) {
        ArrayList<MediaSessionRecord> sortedSessions = this.getPriorityListLocked(false, 0, -1);
        int count = sortedSessions.size();
        pw.println(prefix + "Global priority session is " + this.mGlobalPrioritySession);
        pw.println(prefix + "Sessions Stack - have " + count + " sessions:");
        String indent = prefix + "  ";
        for (int i = 0; i < count; ++i) {
            MediaSessionRecord record = sortedSessions.get(i);
            record.dump(pw, indent);
            pw.println();
        }
    }

    private ArrayList<MediaSessionRecord> getPriorityListLocked(boolean activeOnly, int withFlags, int userId) {
        ArrayList<Integer> userIdList = new ArrayList<Integer>();
        userIdList.add(userId);
        return this.getPriorityListLocked(activeOnly, withFlags, userIdList);
    }

    private ArrayList<MediaSessionRecord> getPriorityListLocked(boolean activeOnly, int withFlags, List<Integer> userIdList) {
        ArrayList<MediaSessionRecord> result = new ArrayList<MediaSessionRecord>();
        int lastLocalIndex = 0;
        int lastActiveIndex = 0;
        int lastPublishedIndex = 0;
        boolean filterUser = !userIdList.contains(-1);
        int size = this.mSessions.size();
        for (int i = 0; i < size; ++i) {
            MediaSessionRecord session = this.mSessions.get(i);
            if (filterUser && !userIdList.contains(session.getUserId()) || (session.getFlags() & (long)withFlags) != (long)withFlags) continue;
            if (!session.isActive()) {
                if (activeOnly) continue;
                result.add(session);
                continue;
            }
            if (session.isSystemPriority()) {
                result.add(0, session);
                ++lastLocalIndex;
                ++lastActiveIndex;
                ++lastPublishedIndex;
                continue;
            }
            if (session.isPlaybackActive(true)) {
                result.add(lastLocalIndex, session);
                ++lastLocalIndex;
                ++lastActiveIndex;
                ++lastPublishedIndex;
                continue;
            }
            result.add(lastPublishedIndex, session);
            ++lastPublishedIndex;
        }
        return result;
    }

    private boolean shouldUpdatePriority(int oldState, int newState) {
        if (this.containsState(newState, ALWAYS_PRIORITY_STATES)) {
            return true;
        }
        return !this.containsState(oldState, TRANSITION_PRIORITY_STATES) && this.containsState(newState, TRANSITION_PRIORITY_STATES);
    }

    private boolean containsState(int state, int[] states) {
        for (int i = 0; i < states.length; ++i) {
            if (states[i] != state) continue;
            return true;
        }
        return false;
    }

    private void clearCache() {
        this.mCachedDefault = null;
        this.mCachedVolumeDefault = null;
        this.mCachedButtonReceiver = null;
        this.mCachedActiveList = null;
        this.mCachedTransportControlList = null;
    }
}

