/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.media;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Handler;
import android.os.UserHandle;
import android.util.Log;
import android.util.Slog;
import com.android.server.media.RemoteDisplayProviderProxy;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;

public final class RemoteDisplayProviderWatcher {
    private static final String TAG = "RemoteDisplayProvider";
    private static final boolean DEBUG = Log.isLoggable("RemoteDisplayProvider", 3);
    private final Context mContext;
    private final Callback mCallback;
    private final Handler mHandler;
    private final int mUserId;
    private final PackageManager mPackageManager;
    private final ArrayList<RemoteDisplayProviderProxy> mProviders = new ArrayList();
    private boolean mRunning;
    private final BroadcastReceiver mScanPackagesReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (DEBUG) {
                Slog.d(RemoteDisplayProviderWatcher.TAG, "Received package manager broadcast: " + intent);
            }
            RemoteDisplayProviderWatcher.this.scanPackages();
        }
    };
    private final Runnable mScanPackagesRunnable = new Runnable(){

        @Override
        public void run() {
            RemoteDisplayProviderWatcher.this.scanPackages();
        }
    };

    public RemoteDisplayProviderWatcher(Context context, Callback callback, Handler handler, int userId) {
        this.mContext = context;
        this.mCallback = callback;
        this.mHandler = handler;
        this.mUserId = userId;
        this.mPackageManager = context.getPackageManager();
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + "Watcher");
        pw.println(prefix + "  mUserId=" + this.mUserId);
        pw.println(prefix + "  mRunning=" + this.mRunning);
        pw.println(prefix + "  mProviders.size()=" + this.mProviders.size());
    }

    public void start() {
        if (!this.mRunning) {
            this.mRunning = true;
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.PACKAGE_ADDED");
            filter.addAction("android.intent.action.PACKAGE_REMOVED");
            filter.addAction("android.intent.action.PACKAGE_CHANGED");
            filter.addAction("android.intent.action.PACKAGE_REPLACED");
            filter.addAction("android.intent.action.PACKAGE_RESTARTED");
            filter.addDataScheme("package");
            this.mContext.registerReceiverAsUser(this.mScanPackagesReceiver, new UserHandle(this.mUserId), filter, null, this.mHandler);
            this.mHandler.post(this.mScanPackagesRunnable);
        }
    }

    public void stop() {
        if (this.mRunning) {
            this.mRunning = false;
            this.mContext.unregisterReceiver(this.mScanPackagesReceiver);
            this.mHandler.removeCallbacks(this.mScanPackagesRunnable);
            for (int i = this.mProviders.size() - 1; i >= 0; --i) {
                this.mProviders.get(i).stop();
            }
        }
    }

    private void scanPackages() {
        if (!this.mRunning) {
            return;
        }
        int targetIndex = 0;
        Intent intent = new Intent("com.android.media.remotedisplay.RemoteDisplayProvider");
        for (ResolveInfo resolveInfo : this.mPackageManager.queryIntentServicesAsUser(intent, 0, this.mUserId)) {
            RemoteDisplayProviderProxy provider;
            ServiceInfo serviceInfo = resolveInfo.serviceInfo;
            if (serviceInfo == null || !this.verifyServiceTrusted(serviceInfo)) continue;
            int sourceIndex = this.findProvider(serviceInfo.packageName, serviceInfo.name);
            if (sourceIndex < 0) {
                provider = new RemoteDisplayProviderProxy(this.mContext, new ComponentName(serviceInfo.packageName, serviceInfo.name), this.mUserId);
                provider.start();
                this.mProviders.add(targetIndex++, provider);
                this.mCallback.addProvider(provider);
                continue;
            }
            if (sourceIndex < targetIndex) continue;
            provider = this.mProviders.get(sourceIndex);
            provider.start();
            provider.rebindIfDisconnected();
            Collections.swap(this.mProviders, sourceIndex, targetIndex++);
        }
        if (targetIndex < this.mProviders.size()) {
            for (int i = this.mProviders.size() - 1; i >= targetIndex; --i) {
                RemoteDisplayProviderProxy provider = this.mProviders.get(i);
                this.mCallback.removeProvider(provider);
                this.mProviders.remove(provider);
                provider.stop();
            }
        }
    }

    private boolean verifyServiceTrusted(ServiceInfo serviceInfo) {
        if (serviceInfo.permission == null || !serviceInfo.permission.equals("android.permission.BIND_REMOTE_DISPLAY")) {
            Slog.w(TAG, "Ignoring remote display provider service because it did not require the BIND_REMOTE_DISPLAY permission in its manifest: " + serviceInfo.packageName + "/" + serviceInfo.name);
            return false;
        }
        if (!this.hasCaptureVideoPermission(serviceInfo.packageName)) {
            Slog.w(TAG, "Ignoring remote display provider service because it does not have the CAPTURE_VIDEO_OUTPUT or CAPTURE_SECURE_VIDEO_OUTPUT permission: " + serviceInfo.packageName + "/" + serviceInfo.name);
            return false;
        }
        return true;
    }

    private boolean hasCaptureVideoPermission(String packageName) {
        if (this.mPackageManager.checkPermission("android.permission.CAPTURE_VIDEO_OUTPUT", packageName) == 0) {
            return true;
        }
        return this.mPackageManager.checkPermission("android.permission.CAPTURE_SECURE_VIDEO_OUTPUT", packageName) == 0;
    }

    private int findProvider(String packageName, String className) {
        int count = this.mProviders.size();
        for (int i = 0; i < count; ++i) {
            RemoteDisplayProviderProxy provider = this.mProviders.get(i);
            if (!provider.hasComponentName(packageName, className)) continue;
            return i;
        }
        return -1;
    }

    public static interface Callback {
        public void addProvider(RemoteDisplayProviderProxy var1);

        public void removeProvider(RemoteDisplayProviderProxy var1);
    }
}

