/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net;

import android.annotation.IntDef;
import android.app.AppGlobals;
import android.app.AppOpsManager;
import android.app.IActivityManager;
import android.app.INotificationManager;
import android.app.IUidObserver;
import android.app.Notification;
import android.app.PendingIntent;
import android.app.usage.UsageStatsManagerInternal;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.IConnectivityManager;
import android.net.INetworkManagementEventObserver;
import android.net.INetworkPolicyListener;
import android.net.INetworkPolicyManager;
import android.net.INetworkStatsService;
import android.net.LinkProperties;
import android.net.NetworkIdentity;
import android.net.NetworkInfo;
import android.net.NetworkPolicy;
import android.net.NetworkPolicyManager;
import android.net.NetworkQuotaInfo;
import android.net.NetworkState;
import android.net.NetworkTemplate;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IDeviceIdleController;
import android.os.INetworkManagementService;
import android.os.Message;
import android.os.MessageQueue;
import android.os.PowerManagerInternal;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.format.Formatter;
import android.text.format.Time;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.DebugUtils;
import android.util.Log;
import android.util.NtpTrustedTime;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.TrustedTime;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.content.PackageMonitor;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.Preconditions;
import com.android.internal.util.XmlUtils;
import com.android.server.DeviceIdleController;
import com.android.server.EventLogTags;
import com.android.server.LocalServices;
import com.android.server.SystemConfig;
import com.android.server.net.BaseNetworkObserver;
import com.android.server.net.NetworkPolicyManagerInternal;
import com.android.server.net.NetworkPolicyManagerShellCommand;
import com.google.android.collect.Lists;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class NetworkPolicyManagerService
extends INetworkPolicyManager.Stub {
    static final String TAG = "NetworkPolicy";
    private static final boolean LOGD = false;
    private static final boolean LOGV = false;
    private static final int VERSION_INIT = 1;
    private static final int VERSION_ADDED_SNOOZE = 2;
    private static final int VERSION_ADDED_RESTRICT_BACKGROUND = 3;
    private static final int VERSION_ADDED_METERED = 4;
    private static final int VERSION_SPLIT_SNOOZE = 5;
    private static final int VERSION_ADDED_TIMEZONE = 6;
    private static final int VERSION_ADDED_INFERRED = 7;
    private static final int VERSION_SWITCH_APP_ID = 8;
    private static final int VERSION_ADDED_NETWORK_ID = 9;
    private static final int VERSION_SWITCH_UID = 10;
    private static final int VERSION_LATEST = 10;
    public static final int TYPE_WARNING = 1;
    public static final int TYPE_LIMIT = 2;
    public static final int TYPE_LIMIT_SNOOZED = 3;
    private static final String TAG_POLICY_LIST = "policy-list";
    private static final String TAG_NETWORK_POLICY = "network-policy";
    private static final String TAG_UID_POLICY = "uid-policy";
    private static final String TAG_APP_POLICY = "app-policy";
    private static final String TAG_WHITELIST = "whitelist";
    private static final String TAG_RESTRICT_BACKGROUND = "restrict-background";
    private static final String TAG_REVOKED_RESTRICT_BACKGROUND = "revoked-restrict-background";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_RESTRICT_BACKGROUND = "restrictBackground";
    private static final String ATTR_NETWORK_TEMPLATE = "networkTemplate";
    private static final String ATTR_SUBSCRIBER_ID = "subscriberId";
    private static final String ATTR_NETWORK_ID = "networkId";
    private static final String ATTR_CYCLE_DAY = "cycleDay";
    private static final String ATTR_CYCLE_TIMEZONE = "cycleTimezone";
    private static final String ATTR_WARNING_BYTES = "warningBytes";
    private static final String ATTR_LIMIT_BYTES = "limitBytes";
    private static final String ATTR_LAST_SNOOZE = "lastSnooze";
    private static final String ATTR_LAST_WARNING_SNOOZE = "lastWarningSnooze";
    private static final String ATTR_LAST_LIMIT_SNOOZE = "lastLimitSnooze";
    private static final String ATTR_METERED = "metered";
    private static final String ATTR_INFERRED = "inferred";
    private static final String ATTR_UID = "uid";
    private static final String ATTR_APP_ID = "appId";
    private static final String ATTR_POLICY = "policy";
    private static final String ACTION_ALLOW_BACKGROUND = "com.android.server.net.action.ALLOW_BACKGROUND";
    private static final String ACTION_SNOOZE_WARNING = "com.android.server.net.action.SNOOZE_WARNING";
    private static final long TIME_CACHE_MAX_AGE = 86400000L;
    private static final int MSG_RULES_CHANGED = 1;
    private static final int MSG_METERED_IFACES_CHANGED = 2;
    private static final int MSG_LIMIT_REACHED = 5;
    private static final int MSG_RESTRICT_BACKGROUND_CHANGED = 6;
    private static final int MSG_ADVISE_PERSIST_THRESHOLD = 7;
    private static final int MSG_RESTRICT_BACKGROUND_WHITELIST_CHANGED = 9;
    private static final int MSG_UPDATE_INTERFACE_QUOTA = 10;
    private static final int MSG_REMOVE_INTERFACE_QUOTA = 11;
    private static final int MSG_RESTRICT_BACKGROUND_BLACKLIST_CHANGED = 12;
    private final Context mContext;
    private final IActivityManager mActivityManager;
    private final INetworkStatsService mNetworkStats;
    private final INetworkManagementService mNetworkManager;
    private UsageStatsManagerInternal mUsageStats;
    private final TrustedTime mTime;
    private final UserManager mUserManager;
    private IConnectivityManager mConnManager;
    private INotificationManager mNotifManager;
    private PowerManagerInternal mPowerManagerInternal;
    private IDeviceIdleController mDeviceIdleController;
    final Object mUidRulesFirstLock = new Object();
    final Object mNetworkPoliciesSecondLock = new Object();
    @GuardedBy(value="allLocks")
    volatile boolean mSystemReady;
    @GuardedBy(value="mUidRulesFirstLock")
    volatile boolean mRestrictBackground;
    @GuardedBy(value="mUidRulesFirstLock")
    volatile boolean mRestrictPower;
    @GuardedBy(value="mUidRulesFirstLock")
    volatile boolean mDeviceIdleMode;
    private final boolean mSuppressDefaultPolicy;
    final ArrayMap<NetworkTemplate, NetworkPolicy> mNetworkPolicy = new ArrayMap();
    final ArrayMap<NetworkPolicy, String[]> mNetworkRules = new ArrayMap();
    @GuardedBy(value="mUidRulesFirstLock")
    final SparseIntArray mUidPolicy = new SparseIntArray();
    @GuardedBy(value="mUidRulesFirstLock")
    final SparseIntArray mUidRules = new SparseIntArray();
    @GuardedBy(value="mUidRulesFirstLock")
    final SparseIntArray mUidFirewallStandbyRules = new SparseIntArray();
    @GuardedBy(value="mUidRulesFirstLock")
    final SparseIntArray mUidFirewallDozableRules = new SparseIntArray();
    @GuardedBy(value="mUidRulesFirstLock")
    final SparseIntArray mUidFirewallPowerSaveRules = new SparseIntArray();
    @GuardedBy(value="mUidRulesFirstLock")
    final SparseBooleanArray mFirewallChainStates = new SparseBooleanArray();
    @GuardedBy(value="mUidRulesFirstLock")
    private final SparseBooleanArray mPowerSaveWhitelistExceptIdleAppIds = new SparseBooleanArray();
    @GuardedBy(value="mUidRulesFirstLock")
    private final SparseBooleanArray mPowerSaveWhitelistAppIds = new SparseBooleanArray();
    @GuardedBy(value="mUidRulesFirstLock")
    private final SparseBooleanArray mPowerSaveTempWhitelistAppIds = new SparseBooleanArray();
    @GuardedBy(value="mUidRulesFirstLock")
    private final SparseBooleanArray mRestrictBackgroundWhitelistUids = new SparseBooleanArray();
    @GuardedBy(value="mUidRulesFirstLock")
    private final SparseBooleanArray mDefaultRestrictBackgroundWhitelistUids = new SparseBooleanArray();
    @GuardedBy(value="mUidRulesFirstLock")
    private final SparseBooleanArray mRestrictBackgroundWhitelistRevokedUids = new SparseBooleanArray();
    @GuardedBy(value="mNetworkPoliciesSecondLock")
    private ArraySet<String> mMeteredIfaces = new ArraySet();
    @GuardedBy(value="mNetworkPoliciesSecondLock")
    private final ArraySet<NetworkTemplate> mOverLimitNotified = new ArraySet();
    @GuardedBy(value="mNetworkPoliciesSecondLock")
    private final ArraySet<String> mActiveNotifs = new ArraySet();
    @GuardedBy(value="mUidRulesFirstLock")
    final SparseIntArray mUidState = new SparseIntArray();
    private INetworkPolicyListener mConnectivityListener;
    private final RemoteCallbackList<INetworkPolicyListener> mListeners = new RemoteCallbackList();
    final Handler mHandler;
    @GuardedBy(value="allLocks")
    private final AtomicFile mPolicyFile;
    private final AppOpsManager mAppOps;
    private final MyPackageMonitor mPackageMonitor;
    private final IPackageManager mIPm;
    private final IUidObserver mUidObserver = new IUidObserver.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUidStateChanged(int uid, int procState) throws RemoteException {
            Object object = NetworkPolicyManagerService.this.mUidRulesFirstLock;
            synchronized (object) {
                NetworkPolicyManagerService.this.updateUidStateUL(uid, procState);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUidGone(int uid) throws RemoteException {
            Object object = NetworkPolicyManagerService.this.mUidRulesFirstLock;
            synchronized (object) {
                NetworkPolicyManagerService.this.removeUidStateUL(uid);
            }
        }

        @Override
        public void onUidActive(int uid) throws RemoteException {
        }

        @Override
        public void onUidIdle(int uid) throws RemoteException {
        }
    };
    private final BroadcastReceiver mPowerSaveWhitelistReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            Object object = NetworkPolicyManagerService.this.mUidRulesFirstLock;
            synchronized (object) {
                NetworkPolicyManagerService.this.updatePowerSaveWhitelistUL();
                NetworkPolicyManagerService.this.updateRulesForRestrictPowerUL();
            }
        }
    };
    private final Runnable mTempPowerSaveChangedCallback = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = NetworkPolicyManagerService.this.mUidRulesFirstLock;
            synchronized (object) {
                NetworkPolicyManagerService.this.updatePowerSaveTempWhitelistUL();
                NetworkPolicyManagerService.this.updateRulesForTempWhitelistChangeUL();
                NetworkPolicyManagerService.this.purgePowerSaveTempWhitelistUL();
            }
        }
    };
    private final BroadcastReceiver mPackageReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            int uid = intent.getIntExtra("android.intent.extra.UID", -1);
            if (uid == -1) {
                return;
            }
            if ("android.intent.action.PACKAGE_ADDED".equals(action)) {
                Object object = NetworkPolicyManagerService.this.mUidRulesFirstLock;
                synchronized (object) {
                    NetworkPolicyManagerService.this.updateRestrictionRulesForUidUL(uid);
                }
            }
        }
    };
    private final BroadcastReceiver mUidRemovedReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            int uid = intent.getIntExtra("android.intent.extra.UID", -1);
            if (uid == -1) {
                return;
            }
            Object object = NetworkPolicyManagerService.this.mUidRulesFirstLock;
            synchronized (object) {
                NetworkPolicyManagerService.this.mUidPolicy.delete(uid);
                NetworkPolicyManagerService.this.updateRestrictionRulesForUidUL(uid);
                Object object2 = NetworkPolicyManagerService.this.mNetworkPoliciesSecondLock;
                synchronized (object2) {
                    NetworkPolicyManagerService.this.writePolicyAL();
                }
            }
        }
    };
    private final BroadcastReceiver mUserReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            int userId = intent.getIntExtra("android.intent.extra.user_handle", -1);
            if (userId == -1) {
                return;
            }
            switch (action) {
                case "android.intent.action.USER_REMOVED": 
                case "android.intent.action.USER_ADDED": {
                    Object object = NetworkPolicyManagerService.this.mUidRulesFirstLock;
                    synchronized (object) {
                        NetworkPolicyManagerService.this.removeUserStateUL(userId, true);
                        if (action == "android.intent.action.USER_ADDED") {
                            NetworkPolicyManagerService.this.addDefaultRestrictBackgroundWhitelistUidsUL(userId);
                        }
                        Object object2 = NetworkPolicyManagerService.this.mNetworkPoliciesSecondLock;
                        synchronized (object2) {
                            NetworkPolicyManagerService.this.updateRulesForGlobalChangeAL(true);
                        }
                    }
                }
            }
        }
    };
    private final BroadcastReceiver mStatsReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            NetworkPolicyManagerService.this.maybeRefreshTrustedTime();
            Object object = NetworkPolicyManagerService.this.mNetworkPoliciesSecondLock;
            synchronized (object) {
                NetworkPolicyManagerService.this.updateNetworkEnabledNL();
                NetworkPolicyManagerService.this.updateNotificationsNL();
            }
        }
    };
    private final BroadcastReceiver mAllowReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            NetworkPolicyManagerService.this.setRestrictBackground(false);
        }
    };
    private final BroadcastReceiver mSnoozeWarningReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            NetworkTemplate template = (NetworkTemplate)intent.getParcelableExtra("android.net.NETWORK_TEMPLATE");
            NetworkPolicyManagerService.this.performSnooze(template, 1);
        }
    };
    private final BroadcastReceiver mWifiConfigReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            int reason = intent.getIntExtra("changeReason", 0);
            if (reason == 1) {
                WifiConfiguration config = (WifiConfiguration)intent.getParcelableExtra("wifiConfiguration");
                if (config.SSID != null) {
                    NetworkTemplate template = NetworkTemplate.buildTemplateWifi(config.SSID);
                    Object object = NetworkPolicyManagerService.this.mUidRulesFirstLock;
                    synchronized (object) {
                        Object object2 = NetworkPolicyManagerService.this.mNetworkPoliciesSecondLock;
                        synchronized (object2) {
                            if (NetworkPolicyManagerService.this.mNetworkPolicy.containsKey(template)) {
                                NetworkPolicyManagerService.this.mNetworkPolicy.remove(template);
                                NetworkPolicyManagerService.this.writePolicyAL();
                            }
                        }
                    }
                }
            }
        }
    };
    private final BroadcastReceiver mWifiStateReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            NetworkInfo netInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
            if (!netInfo.isConnected()) {
                return;
            }
            WifiInfo info = (WifiInfo)intent.getParcelableExtra("wifiInfo");
            boolean meteredHint = info.getMeteredHint();
            NetworkTemplate template = NetworkTemplate.buildTemplateWifi(info.getSSID());
            Object object = NetworkPolicyManagerService.this.mNetworkPoliciesSecondLock;
            synchronized (object) {
                NetworkPolicy policy = NetworkPolicyManagerService.this.mNetworkPolicy.get(template);
                if (policy == null && meteredHint) {
                    policy = NetworkPolicyManagerService.newWifiPolicy(template, meteredHint);
                    NetworkPolicyManagerService.this.addNetworkPolicyNL(policy);
                } else if (policy != null && policy.inferred) {
                    policy.metered = meteredHint;
                    NetworkPolicyManagerService.this.updateNetworkRulesNL();
                }
            }
        }
    };
    private final INetworkManagementEventObserver mAlertObserver = new BaseNetworkObserver(){

        @Override
        public void limitReached(String limitName, String iface) {
            NetworkPolicyManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", NetworkPolicyManagerService.TAG);
            if (!"globalAlert".equals(limitName)) {
                NetworkPolicyManagerService.this.mHandler.obtainMessage(5, iface).sendToTarget();
            }
        }
    };
    private BroadcastReceiver mConnReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            NetworkPolicyManagerService.this.maybeRefreshTrustedTime();
            Object object = NetworkPolicyManagerService.this.mNetworkPoliciesSecondLock;
            synchronized (object) {
                NetworkPolicyManagerService.this.ensureActiveMobilePolicyNL();
                NetworkPolicyManagerService.this.normalizePoliciesNL();
                NetworkPolicyManagerService.this.updateNetworkEnabledNL();
                NetworkPolicyManagerService.this.updateNetworkRulesNL();
                NetworkPolicyManagerService.this.updateNotificationsNL();
            }
        }
    };
    private static final int TYPE_RESTRICT_BACKGROUND = 1;
    private static final int TYPE_RESTRICT_POWER = 2;
    private Handler.Callback mHandlerCallback = new Handler.Callback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    int uid = msg.arg1;
                    int uidRules = msg.arg2;
                    NetworkPolicyManagerService.this.dispatchUidRulesChanged(NetworkPolicyManagerService.this.mConnectivityListener, uid, uidRules);
                    int length = NetworkPolicyManagerService.this.mListeners.beginBroadcast();
                    for (int i = 0; i < length; ++i) {
                        INetworkPolicyListener listener = (INetworkPolicyListener)NetworkPolicyManagerService.this.mListeners.getBroadcastItem(i);
                        NetworkPolicyManagerService.this.dispatchUidRulesChanged(listener, uid, uidRules);
                    }
                    NetworkPolicyManagerService.this.mListeners.finishBroadcast();
                    return true;
                }
                case 2: {
                    String[] meteredIfaces = (String[])msg.obj;
                    NetworkPolicyManagerService.this.dispatchMeteredIfacesChanged(NetworkPolicyManagerService.this.mConnectivityListener, meteredIfaces);
                    int length = NetworkPolicyManagerService.this.mListeners.beginBroadcast();
                    for (int i = 0; i < length; ++i) {
                        INetworkPolicyListener listener = (INetworkPolicyListener)NetworkPolicyManagerService.this.mListeners.getBroadcastItem(i);
                        NetworkPolicyManagerService.this.dispatchMeteredIfacesChanged(listener, meteredIfaces);
                    }
                    NetworkPolicyManagerService.this.mListeners.finishBroadcast();
                    return true;
                }
                case 5: {
                    String iface = (String)msg.obj;
                    NetworkPolicyManagerService.this.maybeRefreshTrustedTime();
                    Object length = NetworkPolicyManagerService.this.mNetworkPoliciesSecondLock;
                    synchronized (length) {
                        if (NetworkPolicyManagerService.this.mMeteredIfaces.contains(iface)) {
                            try {
                                NetworkPolicyManagerService.this.mNetworkStats.forceUpdate();
                            }
                            catch (RemoteException i) {
                                // empty catch block
                            }
                            NetworkPolicyManagerService.this.updateNetworkEnabledNL();
                            NetworkPolicyManagerService.this.updateNotificationsNL();
                        }
                    }
                    return true;
                }
                case 6: {
                    boolean restrictBackground = msg.arg1 != 0;
                    NetworkPolicyManagerService.this.dispatchRestrictBackgroundChanged(NetworkPolicyManagerService.this.mConnectivityListener, restrictBackground);
                    int length = NetworkPolicyManagerService.this.mListeners.beginBroadcast();
                    for (int i = 0; i < length; ++i) {
                        INetworkPolicyListener listener = (INetworkPolicyListener)NetworkPolicyManagerService.this.mListeners.getBroadcastItem(i);
                        NetworkPolicyManagerService.this.dispatchRestrictBackgroundChanged(listener, restrictBackground);
                    }
                    NetworkPolicyManagerService.this.mListeners.finishBroadcast();
                    Intent intent = new Intent("android.net.conn.RESTRICT_BACKGROUND_CHANGED");
                    intent.setFlags(0x40000000);
                    NetworkPolicyManagerService.this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
                    return true;
                }
                case 9: {
                    int uid = msg.arg1;
                    boolean changed = msg.arg2 == 1;
                    Boolean whitelisted = (Boolean)msg.obj;
                    if (whitelisted != null) {
                        boolean whitelistedBool = whitelisted;
                        NetworkPolicyManagerService.this.dispatchRestrictBackgroundWhitelistChanged(NetworkPolicyManagerService.this.mConnectivityListener, uid, whitelistedBool);
                        int length = NetworkPolicyManagerService.this.mListeners.beginBroadcast();
                        for (int i = 0; i < length; ++i) {
                            INetworkPolicyListener listener = (INetworkPolicyListener)NetworkPolicyManagerService.this.mListeners.getBroadcastItem(i);
                            NetworkPolicyManagerService.this.dispatchRestrictBackgroundWhitelistChanged(listener, uid, whitelistedBool);
                        }
                        NetworkPolicyManagerService.this.mListeners.finishBroadcast();
                    }
                    PackageManager pm = NetworkPolicyManagerService.this.mContext.getPackageManager();
                    String[] packages = pm.getPackagesForUid(uid);
                    if (changed && packages != null) {
                        int userId = UserHandle.getUserId(uid);
                        for (String packageName : packages) {
                            Intent intent = new Intent("android.net.conn.RESTRICT_BACKGROUND_CHANGED");
                            intent.setPackage(packageName);
                            intent.setFlags(0x40000000);
                            NetworkPolicyManagerService.this.mContext.sendBroadcastAsUser(intent, UserHandle.of(userId));
                        }
                    }
                    return true;
                }
                case 12: {
                    int uid = msg.arg1;
                    boolean blacklisted = msg.arg2 == 1;
                    NetworkPolicyManagerService.this.dispatchRestrictBackgroundBlacklistChanged(NetworkPolicyManagerService.this.mConnectivityListener, uid, blacklisted);
                    int length = NetworkPolicyManagerService.this.mListeners.beginBroadcast();
                    for (int i = 0; i < length; ++i) {
                        INetworkPolicyListener listener = (INetworkPolicyListener)NetworkPolicyManagerService.this.mListeners.getBroadcastItem(i);
                        NetworkPolicyManagerService.this.dispatchRestrictBackgroundBlacklistChanged(listener, uid, blacklisted);
                    }
                    NetworkPolicyManagerService.this.mListeners.finishBroadcast();
                    return true;
                }
                case 7: {
                    long lowestRule = (Long)msg.obj;
                    try {
                        long persistThreshold = lowestRule / 1000L;
                        NetworkPolicyManagerService.this.mNetworkStats.advisePersistThreshold(persistThreshold);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    return true;
                }
                case 10: {
                    NetworkPolicyManagerService.this.removeInterfaceQuota((String)msg.obj);
                    NetworkPolicyManagerService.this.setInterfaceQuota((String)msg.obj, (long)msg.arg1 << 32 | (long)msg.arg2 & 0xFFFFFFFFL);
                    return true;
                }
                case 11: {
                    NetworkPolicyManagerService.this.removeInterfaceQuota((String)msg.obj);
                    return true;
                }
            }
            return false;
        }
    };

    public NetworkPolicyManagerService(Context context, IActivityManager activityManager, INetworkStatsService networkStats, INetworkManagementService networkManagement) {
        this(context, activityManager, networkStats, networkManagement, NtpTrustedTime.getInstance(context), NetworkPolicyManagerService.getSystemDir(), false);
    }

    private static File getSystemDir() {
        return new File(Environment.getDataDirectory(), "system");
    }

    public NetworkPolicyManagerService(Context context, IActivityManager activityManager, INetworkStatsService networkStats, INetworkManagementService networkManagement, TrustedTime time, File systemDir, boolean suppressDefaultPolicy) {
        this.mContext = Preconditions.checkNotNull(context, "missing context");
        this.mActivityManager = Preconditions.checkNotNull(activityManager, "missing activityManager");
        this.mNetworkStats = Preconditions.checkNotNull(networkStats, "missing networkStats");
        this.mNetworkManager = Preconditions.checkNotNull(networkManagement, "missing networkManagement");
        this.mDeviceIdleController = IDeviceIdleController.Stub.asInterface(ServiceManager.getService("deviceidle"));
        this.mTime = Preconditions.checkNotNull(time, "missing TrustedTime");
        this.mUserManager = (UserManager)this.mContext.getSystemService("user");
        this.mIPm = AppGlobals.getPackageManager();
        HandlerThread thread = new HandlerThread(TAG);
        thread.start();
        this.mHandler = new Handler(thread.getLooper(), this.mHandlerCallback);
        this.mSuppressDefaultPolicy = suppressDefaultPolicy;
        this.mPolicyFile = new AtomicFile(new File(systemDir, "netpolicy.xml"));
        this.mAppOps = context.getSystemService(AppOpsManager.class);
        this.mPackageMonitor = new MyPackageMonitor();
        LocalServices.addService(NetworkPolicyManagerInternal.class, new NetworkPolicyManagerInternalImpl());
    }

    public void bindConnectivityManager(IConnectivityManager connManager) {
        this.mConnManager = Preconditions.checkNotNull(connManager, "missing IConnectivityManager");
    }

    public void bindNotificationManager(INotificationManager notifManager) {
        this.mNotifManager = Preconditions.checkNotNull(notifManager, "missing INotificationManager");
    }

    void updatePowerSaveWhitelistUL() {
        try {
            int[] whitelist = this.mDeviceIdleController.getAppIdWhitelistExceptIdle();
            this.mPowerSaveWhitelistExceptIdleAppIds.clear();
            if (whitelist != null) {
                for (int uid : whitelist) {
                    this.mPowerSaveWhitelistExceptIdleAppIds.put(uid, true);
                }
            }
            whitelist = this.mDeviceIdleController.getAppIdWhitelist();
            this.mPowerSaveWhitelistAppIds.clear();
            if (whitelist != null) {
                for (int uid : whitelist) {
                    this.mPowerSaveWhitelistAppIds.put(uid, true);
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    boolean addDefaultRestrictBackgroundWhitelistUidsUL() {
        List<UserInfo> users = this.mUserManager.getUsers();
        int numberUsers = users.size();
        boolean changed = false;
        for (int i = 0; i < numberUsers; ++i) {
            UserInfo user = users.get(i);
            changed = this.addDefaultRestrictBackgroundWhitelistUidsUL(user.id) || changed;
        }
        return changed;
    }

    private boolean addDefaultRestrictBackgroundWhitelistUidsUL(int userId) {
        SystemConfig sysConfig = SystemConfig.getInstance();
        PackageManager pm = this.mContext.getPackageManager();
        ArraySet<String> allowDataUsage = sysConfig.getAllowInDataUsageSave();
        boolean changed = false;
        for (int i = 0; i < allowDataUsage.size(); ++i) {
            ApplicationInfo app;
            String pkg = allowDataUsage.valueAt(i);
            try {
                app = pm.getApplicationInfoAsUser(pkg, 0x100000, userId);
            }
            catch (PackageManager.NameNotFoundException e) {
                Slog.wtf(TAG, "No ApplicationInfo for package " + pkg);
                continue;
            }
            if (!app.isPrivilegedApp()) {
                Slog.wtf(TAG, "pm.getApplicationInfoAsUser() returned non-privileged app: " + pkg);
                continue;
            }
            int uid = UserHandle.getUid(userId, app.uid);
            this.mDefaultRestrictBackgroundWhitelistUids.append(uid, true);
            if (this.mRestrictBackgroundWhitelistRevokedUids.get(uid)) continue;
            Slog.i(TAG, "adding default package " + pkg + " (uid " + uid + " for user " + userId + ") to restrict background whitelist");
            this.mRestrictBackgroundWhitelistUids.append(uid, true);
            changed = true;
        }
        return changed;
    }

    void updatePowerSaveTempWhitelistUL() {
        try {
            int N = this.mPowerSaveTempWhitelistAppIds.size();
            for (int i = 0; i < N; ++i) {
                this.mPowerSaveTempWhitelistAppIds.setValueAt(i, false);
            }
            int[] whitelist = this.mDeviceIdleController.getAppIdTempWhitelist();
            if (whitelist != null) {
                for (int uid : whitelist) {
                    this.mPowerSaveTempWhitelistAppIds.put(uid, true);
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    void purgePowerSaveTempWhitelistUL() {
        int N = this.mPowerSaveTempWhitelistAppIds.size();
        for (int i = N - 1; i >= 0; --i) {
            if (this.mPowerSaveTempWhitelistAppIds.valueAt(i)) continue;
            this.mPowerSaveTempWhitelistAppIds.removeAt(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady() {
        if (!this.isBandwidthControlEnabled()) {
            Slog.w(TAG, "bandwidth controls disabled, unable to enforce policy");
            return;
        }
        this.mUsageStats = LocalServices.getService(UsageStatsManagerInternal.class);
        this.mPackageMonitor.register(this.mContext, this.mHandler.getLooper(), UserHandle.ALL, true);
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            Object object2 = this.mNetworkPoliciesSecondLock;
            synchronized (object2) {
                this.updatePowerSaveWhitelistUL();
                this.mPowerManagerInternal = LocalServices.getService(PowerManagerInternal.class);
                this.mPowerManagerInternal.registerLowPowerModeObserver(new PowerManagerInternal.LowPowerModeListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onLowPowerModeChanged(boolean enabled) {
                        Object object = NetworkPolicyManagerService.this.mUidRulesFirstLock;
                        synchronized (object) {
                            if (NetworkPolicyManagerService.this.mRestrictPower != enabled) {
                                NetworkPolicyManagerService.this.mRestrictPower = enabled;
                                NetworkPolicyManagerService.this.updateRulesForRestrictPowerUL();
                            }
                        }
                    }
                });
                this.mRestrictPower = this.mPowerManagerInternal.getLowPowerModeEnabled();
                this.mSystemReady = true;
                this.readPolicyAL();
                if (this.addDefaultRestrictBackgroundWhitelistUidsUL()) {
                    this.writePolicyAL();
                }
                this.setRestrictBackgroundUL(this.mRestrictBackground);
                this.updateRulesForGlobalChangeAL(false);
                this.updateNotificationsNL();
            }
        }
        try {
            this.mActivityManager.registerUidObserver(this.mUidObserver, 3);
            this.mNetworkManager.registerObserver(this.mAlertObserver);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        IntentFilter whitelistFilter = new IntentFilter("android.os.action.POWER_SAVE_WHITELIST_CHANGED");
        this.mContext.registerReceiver(this.mPowerSaveWhitelistReceiver, whitelistFilter, null, this.mHandler);
        DeviceIdleController.LocalService deviceIdleService = LocalServices.getService(DeviceIdleController.LocalService.class);
        deviceIdleService.setNetworkPolicyTempWhitelistCallback(this.mTempPowerSaveChangedCallback);
        IntentFilter connFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        this.mContext.registerReceiver(this.mConnReceiver, connFilter, "android.permission.CONNECTIVITY_INTERNAL", this.mHandler);
        IntentFilter packageFilter = new IntentFilter();
        packageFilter.addAction("android.intent.action.PACKAGE_ADDED");
        packageFilter.addDataScheme("package");
        this.mContext.registerReceiver(this.mPackageReceiver, packageFilter, null, this.mHandler);
        this.mContext.registerReceiver(this.mUidRemovedReceiver, new IntentFilter("android.intent.action.UID_REMOVED"), null, this.mHandler);
        IntentFilter userFilter = new IntentFilter();
        userFilter.addAction("android.intent.action.USER_ADDED");
        userFilter.addAction("android.intent.action.USER_REMOVED");
        this.mContext.registerReceiver(this.mUserReceiver, userFilter, null, this.mHandler);
        IntentFilter statsFilter = new IntentFilter("com.android.server.action.NETWORK_STATS_UPDATED");
        this.mContext.registerReceiver(this.mStatsReceiver, statsFilter, "android.permission.READ_NETWORK_USAGE_HISTORY", this.mHandler);
        IntentFilter allowFilter = new IntentFilter(ACTION_ALLOW_BACKGROUND);
        this.mContext.registerReceiver(this.mAllowReceiver, allowFilter, "android.permission.MANAGE_NETWORK_POLICY", this.mHandler);
        IntentFilter snoozeWarningFilter = new IntentFilter(ACTION_SNOOZE_WARNING);
        this.mContext.registerReceiver(this.mSnoozeWarningReceiver, snoozeWarningFilter, "android.permission.MANAGE_NETWORK_POLICY", this.mHandler);
        IntentFilter wifiConfigFilter = new IntentFilter("android.net.wifi.CONFIGURED_NETWORKS_CHANGE");
        this.mContext.registerReceiver(this.mWifiConfigReceiver, wifiConfigFilter, null, this.mHandler);
        IntentFilter wifiStateFilter = new IntentFilter("android.net.wifi.STATE_CHANGE");
        this.mContext.registerReceiver(this.mWifiStateReceiver, wifiStateFilter, null, this.mHandler);
        this.mUsageStats.addAppIdleStateChangeListener(new AppIdleStateChangeListener());
    }

    static NetworkPolicy newWifiPolicy(NetworkTemplate template, boolean metered) {
        return new NetworkPolicy(template, -1, "UTC", -1L, -1L, -1L, -1L, metered, true);
    }

    void updateNotificationsNL() {
        int i;
        ArraySet<String> beforeNotifs = new ArraySet<String>(this.mActiveNotifs);
        this.mActiveNotifs.clear();
        long currentTime = this.currentTimeMillis();
        for (i = this.mNetworkPolicy.size() - 1; i >= 0; --i) {
            long end;
            NetworkPolicy policy = this.mNetworkPolicy.valueAt(i);
            if (!this.isTemplateRelevant(policy.template) || !policy.hasCycle()) continue;
            long start = NetworkPolicyManager.computeLastCycleBoundary(currentTime, policy);
            long totalBytes = this.getTotalBytes(policy.template, start, end = currentTime);
            if (policy.isOverLimit(totalBytes)) {
                if (policy.lastLimitSnooze >= start) {
                    this.enqueueNotification(policy, 3, totalBytes);
                    continue;
                }
                this.enqueueNotification(policy, 2, totalBytes);
                this.notifyOverLimitNL(policy.template);
                continue;
            }
            this.notifyUnderLimitNL(policy.template);
            if (!policy.isOverWarning(totalBytes) || policy.lastWarningSnooze >= start) continue;
            this.enqueueNotification(policy, 1, totalBytes);
        }
        for (i = beforeNotifs.size() - 1; i >= 0; --i) {
            String tag = beforeNotifs.valueAt(i);
            if (this.mActiveNotifs.contains(tag)) continue;
            this.cancelNotification(tag);
        }
    }

    private boolean isTemplateRelevant(NetworkTemplate template) {
        if (template.isMatchRuleMobile()) {
            int[] subIds;
            TelephonyManager tele = TelephonyManager.from(this.mContext);
            SubscriptionManager sub = SubscriptionManager.from(this.mContext);
            for (int subId : subIds = sub.getActiveSubscriptionIdList()) {
                String subscriberId = tele.getSubscriberId(subId);
                NetworkIdentity probeIdent = new NetworkIdentity(0, 0, subscriberId, null, false, true);
                if (!template.matches(probeIdent)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private void notifyOverLimitNL(NetworkTemplate template) {
        if (!this.mOverLimitNotified.contains(template)) {
            this.mContext.startActivity(NetworkPolicyManagerService.buildNetworkOverLimitIntent(template));
            this.mOverLimitNotified.add(template);
        }
    }

    private void notifyUnderLimitNL(NetworkTemplate template) {
        this.mOverLimitNotified.remove(template);
    }

    private String buildNotificationTag(NetworkPolicy policy, int type) {
        return "NetworkPolicy:" + policy.template.hashCode() + ":" + type;
    }

    private void enqueueNotification(NetworkPolicy policy, int type, long totalBytes) {
        String tag = this.buildNotificationTag(policy, type);
        Notification.Builder builder = new Notification.Builder(this.mContext);
        builder.setOnlyAlertOnce(true);
        builder.setWhen(0L);
        builder.setColor(this.mContext.getColor(17170523));
        Resources res = this.mContext.getResources();
        switch (type) {
            case 1: {
                CharSequence title = res.getText(17040589);
                String body = res.getString(17040590);
                builder.setSmallIcon(17301624);
                builder.setTicker(title);
                builder.setContentTitle(title);
                builder.setContentText(body);
                builder.setDefaults(-1);
                builder.setPriority(1);
                Intent snoozeIntent = NetworkPolicyManagerService.buildSnoozeWarningIntent(policy.template);
                builder.setDeleteIntent(PendingIntent.getBroadcast(this.mContext, 0, snoozeIntent, 0x8000000));
                Intent viewIntent = NetworkPolicyManagerService.buildViewDataUsageIntent(policy.template);
                builder.setContentIntent(PendingIntent.getActivity(this.mContext, 0, viewIntent, 0x8000000));
                break;
            }
            case 2: {
                CharSequence title;
                CharSequence body = res.getText(17040595);
                int icon = 17303242;
                switch (policy.template.getMatchRule()) {
                    case 2: {
                        title = res.getText(17040591);
                        break;
                    }
                    case 3: {
                        title = res.getText(17040592);
                        break;
                    }
                    case 1: {
                        title = res.getText(17040593);
                        break;
                    }
                    case 4: {
                        title = res.getText(17040594);
                        icon = 17301624;
                        break;
                    }
                    default: {
                        title = null;
                    }
                }
                builder.setOngoing(true);
                builder.setSmallIcon(icon);
                builder.setTicker(title);
                builder.setContentTitle(title);
                builder.setContentText(body);
                Intent intent = NetworkPolicyManagerService.buildNetworkOverLimitIntent(policy.template);
                builder.setContentIntent(PendingIntent.getActivity(this.mContext, 0, intent, 0x8000000));
                break;
            }
            case 3: {
                CharSequence title;
                long overBytes = totalBytes - policy.limitBytes;
                String body = res.getString(17040600, Formatter.formatFileSize(this.mContext, overBytes));
                switch (policy.template.getMatchRule()) {
                    case 2: {
                        title = res.getText(17040596);
                        break;
                    }
                    case 3: {
                        title = res.getText(17040597);
                        break;
                    }
                    case 1: {
                        title = res.getText(17040598);
                        break;
                    }
                    case 4: {
                        title = res.getText(17040599);
                        break;
                    }
                    default: {
                        title = null;
                    }
                }
                builder.setOngoing(true);
                builder.setSmallIcon(17301624);
                builder.setTicker(title);
                builder.setContentTitle(title);
                builder.setContentText(body);
                Intent intent = NetworkPolicyManagerService.buildViewDataUsageIntent(policy.template);
                builder.setContentIntent(PendingIntent.getActivity(this.mContext, 0, intent, 0x8000000));
                break;
            }
        }
        try {
            String packageName = this.mContext.getPackageName();
            int[] idReceived = new int[1];
            this.mNotifManager.enqueueNotificationWithTag(packageName, packageName, tag, 0, builder.getNotification(), idReceived, -1);
            this.mActiveNotifs.add(tag);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void cancelNotification(String tag) {
        try {
            String packageName = this.mContext.getPackageName();
            this.mNotifManager.cancelNotificationWithTag(packageName, tag, 0, -1);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    void updateNetworkEnabledNL() {
        long currentTime = this.currentTimeMillis();
        for (int i = this.mNetworkPolicy.size() - 1; i >= 0; --i) {
            long end;
            NetworkPolicy policy = this.mNetworkPolicy.valueAt(i);
            if (policy.limitBytes == -1L || !policy.hasCycle()) {
                this.setNetworkTemplateEnabled(policy.template, true);
                continue;
            }
            long start = NetworkPolicyManager.computeLastCycleBoundary(currentTime, policy);
            long totalBytes = this.getTotalBytes(policy.template, start, end = currentTime);
            boolean overLimitWithoutSnooze = policy.isOverLimit(totalBytes) && policy.lastLimitSnooze < start;
            boolean networkEnabled = !overLimitWithoutSnooze;
            this.setNetworkTemplateEnabled(policy.template, networkEnabled);
        }
    }

    private void setNetworkTemplateEnabled(NetworkTemplate template, boolean enabled) {
        if (template.getMatchRule() == 1) {
            int[] subIds;
            SubscriptionManager sm = SubscriptionManager.from(this.mContext);
            TelephonyManager tm = TelephonyManager.from(this.mContext);
            for (int subId : subIds = sm.getActiveSubscriptionIdList()) {
                String subscriberId = tm.getSubscriberId(subId);
                NetworkIdentity probeIdent = new NetworkIdentity(0, 0, subscriberId, null, false, true);
                if (!template.matches(probeIdent)) continue;
                tm.setPolicyDataEnabled(enabled, subId);
            }
        }
    }

    void updateNetworkRulesNL() {
        String iface;
        int i;
        Object ident;
        NetworkState[] states;
        try {
            states = this.mConnManager.getAllNetworkState();
        }
        catch (RemoteException e) {
            return;
        }
        ArrayList<Pair<String, Object>> connIdents = new ArrayList<Pair<String, Object>>(states.length);
        ArraySet connIfaces = new ArraySet(states.length);
        for (NetworkState state : states) {
            if (state.networkInfo == null || !state.networkInfo.isConnected()) continue;
            ident = NetworkIdentity.buildNetworkIdentity(this.mContext, state);
            String baseIface = state.linkProperties.getInterfaceName();
            if (baseIface != null) {
                connIdents.add(Pair.create(baseIface, ident));
            }
            List<LinkProperties> stackedLinks = state.linkProperties.getStackedLinks();
            for (LinkProperties stackedLink : stackedLinks) {
                String stackedIface = stackedLink.getInterfaceName();
                if (stackedIface == null) continue;
                connIdents.add(Pair.create(stackedIface, ident));
            }
        }
        this.mNetworkRules.clear();
        ArrayList ifaceList = Lists.newArrayList();
        for (int i2 = this.mNetworkPolicy.size() - 1; i2 >= 0; --i2) {
            NetworkPolicy policy = this.mNetworkPolicy.valueAt(i2);
            ifaceList.clear();
            for (int j = connIdents.size() - 1; j >= 0; --j) {
                ident = (Pair)connIdents.get(j);
                if (!policy.template.matches((NetworkIdentity)((Pair)ident).second)) continue;
                ifaceList.add(((Pair)ident).first);
            }
            if (ifaceList.size() <= 0) continue;
            String[] ifaces = ifaceList.toArray(new String[ifaceList.size()]);
            this.mNetworkRules.put(policy, ifaces);
        }
        long lowestRule = Long.MAX_VALUE;
        ArraySet<String> newMeteredIfaces = new ArraySet<String>(states.length);
        long currentTime = this.currentTimeMillis();
        for (i = this.mNetworkRules.size() - 1; i >= 0; --i) {
            boolean hasLimit;
            long totalBytes;
            long start;
            NetworkPolicy policy = this.mNetworkRules.keyAt(i);
            String[] ifaces = this.mNetworkRules.valueAt(i);
            if (policy.hasCycle()) {
                start = NetworkPolicyManager.computeLastCycleBoundary(currentTime, policy);
                totalBytes = this.getTotalBytes(policy.template, start, currentTime);
            } else {
                start = Long.MAX_VALUE;
                totalBytes = 0L;
            }
            boolean hasWarning = policy.warningBytes != -1L;
            boolean bl = hasLimit = policy.limitBytes != -1L;
            if (hasLimit || policy.metered) {
                long quotaBytes = !hasLimit ? Long.MAX_VALUE : (policy.lastLimitSnooze >= start ? Long.MAX_VALUE : Math.max(1L, policy.limitBytes - totalBytes));
                if (ifaces.length > 1) {
                    Slog.w(TAG, "shared quota unsupported; generating rule for each iface");
                }
                for (String iface2 : ifaces) {
                    this.mHandler.obtainMessage(10, (int)(quotaBytes >> 32), (int)(quotaBytes & 0xFFFFFFFFFFFFFFFFL), iface2).sendToTarget();
                    newMeteredIfaces.add(iface2);
                }
            }
            if (hasWarning && policy.warningBytes < lowestRule) {
                lowestRule = policy.warningBytes;
            }
            if (!hasLimit || policy.limitBytes >= lowestRule) continue;
            lowestRule = policy.limitBytes;
        }
        for (i = connIfaces.size() - 1; i >= 0; --i) {
            iface = (String)connIfaces.valueAt(i);
            this.mHandler.obtainMessage(10, Integer.MAX_VALUE, -1, iface).sendToTarget();
            newMeteredIfaces.add(iface);
        }
        this.mHandler.obtainMessage(7, lowestRule).sendToTarget();
        for (i = this.mMeteredIfaces.size() - 1; i >= 0; --i) {
            iface = this.mMeteredIfaces.valueAt(i);
            if (newMeteredIfaces.contains(iface)) continue;
            this.mHandler.obtainMessage(11, iface).sendToTarget();
        }
        this.mMeteredIfaces = newMeteredIfaces;
        String[] meteredIfaces = this.mMeteredIfaces.toArray(new String[this.mMeteredIfaces.size()]);
        this.mHandler.obtainMessage(2, meteredIfaces).sendToTarget();
    }

    private void ensureActiveMobilePolicyNL() {
        int[] subIds;
        if (this.mSuppressDefaultPolicy) {
            return;
        }
        TelephonyManager tele = TelephonyManager.from(this.mContext);
        SubscriptionManager sub = SubscriptionManager.from(this.mContext);
        for (int subId : subIds = sub.getActiveSubscriptionIdList()) {
            String subscriberId = tele.getSubscriberId(subId);
            this.ensureActiveMobilePolicyNL(subscriberId);
        }
    }

    private void ensureActiveMobilePolicyNL(String subscriberId) {
        NetworkIdentity probeIdent = new NetworkIdentity(0, 0, subscriberId, null, false, true);
        for (int i = this.mNetworkPolicy.size() - 1; i >= 0; --i) {
            NetworkTemplate template = this.mNetworkPolicy.keyAt(i);
            if (!template.matches(probeIdent)) continue;
            return;
        }
        Slog.i(TAG, "No policy for subscriber " + NetworkIdentity.scrubSubscriberId(subscriberId) + "; generating default policy");
        long warningBytes = (long)this.mContext.getResources().getInteger(17694853) * 0x100000L;
        Time time = new Time();
        time.setToNow();
        int cycleDay = time.monthDay;
        String cycleTimezone = time.timezone;
        NetworkTemplate template = NetworkTemplate.buildTemplateMobileAll(subscriberId);
        NetworkPolicy policy = new NetworkPolicy(template, cycleDay, cycleTimezone, warningBytes, -1L, -1L, -1L, true, true);
        this.addNetworkPolicyNL(policy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPolicyAL() {
        this.mNetworkPolicy.clear();
        this.mUidPolicy.clear();
        FileInputStream fis = null;
        try {
            int type;
            fis = this.mPolicyFile.openRead();
            XmlPullParser in = Xml.newPullParser();
            in.setInput(fis, StandardCharsets.UTF_8.name());
            int version = 1;
            boolean insideWhitelist = false;
            while ((type = in.next()) != 1) {
                String tag = in.getName();
                if (type == 2) {
                    int uid;
                    if (TAG_POLICY_LIST.equals(tag)) {
                        boolean oldValue = this.mRestrictBackground;
                        version = XmlUtils.readIntAttribute(in, ATTR_VERSION);
                        this.mRestrictBackground = version >= 3 ? XmlUtils.readBooleanAttribute(in, ATTR_RESTRICT_BACKGROUND) : false;
                        if (this.mRestrictBackground == oldValue) continue;
                        this.mHandler.obtainMessage(6, this.mRestrictBackground ? 1 : 0, 0).sendToTarget();
                        continue;
                    }
                    if (TAG_NETWORK_POLICY.equals(tag)) {
                        boolean metered;
                        int networkTemplate = XmlUtils.readIntAttribute(in, ATTR_NETWORK_TEMPLATE);
                        String subscriberId = in.getAttributeValue(null, ATTR_SUBSCRIBER_ID);
                        String networkId = version >= 9 ? in.getAttributeValue(null, ATTR_NETWORK_ID) : null;
                        int cycleDay = XmlUtils.readIntAttribute(in, ATTR_CYCLE_DAY);
                        String cycleTimezone = version >= 6 ? in.getAttributeValue(null, ATTR_CYCLE_TIMEZONE) : "UTC";
                        long warningBytes = XmlUtils.readLongAttribute(in, ATTR_WARNING_BYTES);
                        long limitBytes = XmlUtils.readLongAttribute(in, ATTR_LIMIT_BYTES);
                        long lastLimitSnooze = version >= 5 ? XmlUtils.readLongAttribute(in, ATTR_LAST_LIMIT_SNOOZE) : (version >= 2 ? XmlUtils.readLongAttribute(in, ATTR_LAST_SNOOZE) : -1L);
                        if (version >= 4) {
                            metered = XmlUtils.readBooleanAttribute(in, ATTR_METERED);
                        } else {
                            switch (networkTemplate) {
                                case 1: 
                                case 2: 
                                case 3: {
                                    metered = true;
                                    break;
                                }
                                default: {
                                    metered = false;
                                }
                            }
                        }
                        long lastWarningSnooze = version >= 5 ? XmlUtils.readLongAttribute(in, ATTR_LAST_WARNING_SNOOZE) : -1L;
                        boolean inferred = version >= 7 ? XmlUtils.readBooleanAttribute(in, ATTR_INFERRED) : false;
                        NetworkTemplate template = new NetworkTemplate(networkTemplate, subscriberId, networkId);
                        if (!template.isPersistable()) continue;
                        this.mNetworkPolicy.put(template, new NetworkPolicy(template, cycleDay, cycleTimezone, warningBytes, limitBytes, lastWarningSnooze, lastLimitSnooze, metered, inferred));
                        continue;
                    }
                    if (TAG_UID_POLICY.equals(tag)) {
                        uid = XmlUtils.readIntAttribute(in, ATTR_UID);
                        int policy = XmlUtils.readIntAttribute(in, ATTR_POLICY);
                        if (UserHandle.isApp(uid)) {
                            this.setUidPolicyUncheckedUL(uid, policy, false);
                            continue;
                        }
                        Slog.w(TAG, "unable to apply policy to UID " + uid + "; ignoring");
                        continue;
                    }
                    if (TAG_APP_POLICY.equals(tag)) {
                        int appId = XmlUtils.readIntAttribute(in, ATTR_APP_ID);
                        int policy = XmlUtils.readIntAttribute(in, ATTR_POLICY);
                        int uid2 = UserHandle.getUid(0, appId);
                        if (UserHandle.isApp(uid2)) {
                            this.setUidPolicyUncheckedUL(uid2, policy, false);
                            continue;
                        }
                        Slog.w(TAG, "unable to apply policy to UID " + uid2 + "; ignoring");
                        continue;
                    }
                    if (TAG_WHITELIST.equals(tag)) {
                        insideWhitelist = true;
                        continue;
                    }
                    if (TAG_RESTRICT_BACKGROUND.equals(tag) && insideWhitelist) {
                        uid = XmlUtils.readIntAttribute(in, ATTR_UID);
                        this.mRestrictBackgroundWhitelistUids.put(uid, true);
                        continue;
                    }
                    if (!TAG_REVOKED_RESTRICT_BACKGROUND.equals(tag) || !insideWhitelist) continue;
                    uid = XmlUtils.readIntAttribute(in, ATTR_UID);
                    this.mRestrictBackgroundWhitelistRevokedUids.put(uid, true);
                    continue;
                }
                if (type != 3 || !TAG_WHITELIST.equals(tag)) continue;
                insideWhitelist = false;
            }
        }
        catch (FileNotFoundException e) {
            this.upgradeLegacyBackgroundDataUL();
        }
        catch (IOException e) {
            Log.wtf(TAG, "problem reading network policy", e);
        }
        catch (XmlPullParserException e) {
            Log.wtf(TAG, "problem reading network policy", e);
        }
        finally {
            IoUtils.closeQuietly(fis);
        }
    }

    private void upgradeLegacyBackgroundDataUL() {
        boolean bl = this.mRestrictBackground = Settings.Secure.getInt(this.mContext.getContentResolver(), "background_data", 1) != 1;
        if (this.mRestrictBackground) {
            Intent broadcast = new Intent("android.net.conn.BACKGROUND_DATA_SETTING_CHANGED");
            this.mContext.sendBroadcastAsUser(broadcast, UserHandle.ALL);
        }
    }

    void writePolicyAL() {
        block8: {
            FileOutputStream fos = null;
            try {
                int i;
                int i2;
                fos = this.mPolicyFile.startWrite();
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(fos, StandardCharsets.UTF_8.name());
                out.startDocument(null, true);
                out.startTag(null, TAG_POLICY_LIST);
                XmlUtils.writeIntAttribute(out, ATTR_VERSION, 10);
                XmlUtils.writeBooleanAttribute(out, ATTR_RESTRICT_BACKGROUND, this.mRestrictBackground);
                for (i2 = 0; i2 < this.mNetworkPolicy.size(); ++i2) {
                    String networkId;
                    NetworkPolicy policy = this.mNetworkPolicy.valueAt(i2);
                    NetworkTemplate template = policy.template;
                    if (!template.isPersistable()) continue;
                    out.startTag(null, TAG_NETWORK_POLICY);
                    XmlUtils.writeIntAttribute(out, ATTR_NETWORK_TEMPLATE, template.getMatchRule());
                    String subscriberId = template.getSubscriberId();
                    if (subscriberId != null) {
                        out.attribute(null, ATTR_SUBSCRIBER_ID, subscriberId);
                    }
                    if ((networkId = template.getNetworkId()) != null) {
                        out.attribute(null, ATTR_NETWORK_ID, networkId);
                    }
                    XmlUtils.writeIntAttribute(out, ATTR_CYCLE_DAY, policy.cycleDay);
                    out.attribute(null, ATTR_CYCLE_TIMEZONE, policy.cycleTimezone);
                    XmlUtils.writeLongAttribute(out, ATTR_WARNING_BYTES, policy.warningBytes);
                    XmlUtils.writeLongAttribute(out, ATTR_LIMIT_BYTES, policy.limitBytes);
                    XmlUtils.writeLongAttribute(out, ATTR_LAST_WARNING_SNOOZE, policy.lastWarningSnooze);
                    XmlUtils.writeLongAttribute(out, ATTR_LAST_LIMIT_SNOOZE, policy.lastLimitSnooze);
                    XmlUtils.writeBooleanAttribute(out, ATTR_METERED, policy.metered);
                    XmlUtils.writeBooleanAttribute(out, ATTR_INFERRED, policy.inferred);
                    out.endTag(null, TAG_NETWORK_POLICY);
                }
                for (i2 = 0; i2 < this.mUidPolicy.size(); ++i2) {
                    int uid = this.mUidPolicy.keyAt(i2);
                    int policy = this.mUidPolicy.valueAt(i2);
                    if (policy == 0) continue;
                    out.startTag(null, TAG_UID_POLICY);
                    XmlUtils.writeIntAttribute(out, ATTR_UID, uid);
                    XmlUtils.writeIntAttribute(out, ATTR_POLICY, policy);
                    out.endTag(null, TAG_UID_POLICY);
                }
                out.endTag(null, TAG_POLICY_LIST);
                out.startTag(null, TAG_WHITELIST);
                int size = this.mRestrictBackgroundWhitelistUids.size();
                for (i = 0; i < size; ++i) {
                    int uid = this.mRestrictBackgroundWhitelistUids.keyAt(i);
                    out.startTag(null, TAG_RESTRICT_BACKGROUND);
                    XmlUtils.writeIntAttribute(out, ATTR_UID, uid);
                    out.endTag(null, TAG_RESTRICT_BACKGROUND);
                }
                size = this.mRestrictBackgroundWhitelistRevokedUids.size();
                for (i = 0; i < size; ++i) {
                    int uid = this.mRestrictBackgroundWhitelistRevokedUids.keyAt(i);
                    out.startTag(null, TAG_REVOKED_RESTRICT_BACKGROUND);
                    XmlUtils.writeIntAttribute(out, ATTR_UID, uid);
                    out.endTag(null, TAG_REVOKED_RESTRICT_BACKGROUND);
                }
                out.endTag(null, TAG_WHITELIST);
                out.endDocument();
                this.mPolicyFile.finishWrite(fos);
            }
            catch (IOException e) {
                if (fos == null) break block8;
                this.mPolicyFile.failWrite(fos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUidPolicy(int uid, int policy) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        if (!UserHandle.isApp(uid)) {
            throw new IllegalArgumentException("cannot apply policy to UID " + uid);
        }
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            long token = Binder.clearCallingIdentity();
            try {
                int oldPolicy = this.mUidPolicy.get(uid, 0);
                if (oldPolicy != policy) {
                    this.setUidPolicyUncheckedUL(uid, oldPolicy, policy, true);
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUidPolicy(int uid, int policy) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        if (!UserHandle.isApp(uid)) {
            throw new IllegalArgumentException("cannot apply policy to UID " + uid);
        }
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            int oldPolicy = this.mUidPolicy.get(uid, 0);
            if (oldPolicy != (policy |= oldPolicy)) {
                this.setUidPolicyUncheckedUL(uid, oldPolicy, policy, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUidPolicy(int uid, int policy) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        if (!UserHandle.isApp(uid)) {
            throw new IllegalArgumentException("cannot apply policy to UID " + uid);
        }
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            int oldPolicy = this.mUidPolicy.get(uid, 0);
            policy = oldPolicy & ~policy;
            if (oldPolicy != policy) {
                this.setUidPolicyUncheckedUL(uid, oldPolicy, policy, true);
            }
        }
    }

    private void setUidPolicyUncheckedUL(int uid, int oldPolicy, int policy, boolean persist) {
        boolean wasBlacklisted;
        this.setUidPolicyUncheckedUL(uid, policy, persist);
        boolean isBlacklisted = policy == 1;
        this.mHandler.obtainMessage(12, uid, isBlacklisted ? 1 : 0).sendToTarget();
        boolean bl = wasBlacklisted = oldPolicy == 1;
        if (oldPolicy == 0 && isBlacklisted || wasBlacklisted && policy == 0) {
            this.mHandler.obtainMessage(9, uid, 1, null).sendToTarget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUidPolicyUncheckedUL(int uid, int policy, boolean persist) {
        this.mUidPolicy.put(uid, policy);
        this.updateRulesForDataUsageRestrictionsUL(uid);
        if (persist) {
            Object object = this.mNetworkPoliciesSecondLock;
            synchronized (object) {
                this.writePolicyAL();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUidPolicy(int uid) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            return this.mUidPolicy.get(uid, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getUidsWithPolicy(int policy) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        int[] uids = new int[]{};
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            for (int i = 0; i < this.mUidPolicy.size(); ++i) {
                int uid = this.mUidPolicy.keyAt(i);
                int uidPolicy = this.mUidPolicy.valueAt(i);
                if (uidPolicy != policy) continue;
                uids = ArrayUtils.appendInt(uids, uid);
            }
        }
        return uids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeUserStateUL(int userId, boolean writePolicy) {
        int uid;
        int i;
        boolean changed = false;
        int[] wlUids = new int[]{};
        for (i = 0; i < this.mRestrictBackgroundWhitelistUids.size(); ++i) {
            uid = this.mRestrictBackgroundWhitelistUids.keyAt(i);
            if (UserHandle.getUserId(uid) != userId) continue;
            wlUids = ArrayUtils.appendInt(wlUids, uid);
        }
        if (wlUids.length > 0) {
            for (int uid2 : wlUids) {
                this.removeRestrictBackgroundWhitelistedUidUL(uid2, false, false);
            }
            changed = true;
        }
        for (i = this.mRestrictBackgroundWhitelistRevokedUids.size() - 1; i >= 0; --i) {
            uid = this.mRestrictBackgroundWhitelistRevokedUids.keyAt(i);
            if (UserHandle.getUserId(uid) != userId) continue;
            this.mRestrictBackgroundWhitelistRevokedUids.removeAt(i);
            changed = true;
        }
        int[] uids = new int[]{};
        for (int i2 = 0; i2 < this.mUidPolicy.size(); ++i2) {
            int uid3 = this.mUidPolicy.keyAt(i2);
            if (UserHandle.getUserId(uid3) != userId) continue;
            uids = ArrayUtils.appendInt(uids, uid3);
        }
        if (uids.length > 0) {
            for (int uid4 : uids) {
                this.mUidPolicy.delete(uid4);
            }
            changed = true;
        }
        Object object = this.mNetworkPoliciesSecondLock;
        synchronized (object) {
            this.updateRulesForGlobalChangeAL(true);
            if (writePolicy && changed) {
                this.writePolicyAL();
            }
        }
        return changed;
    }

    @Override
    public void setConnectivityListener(INetworkPolicyListener listener) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        if (this.mConnectivityListener != null) {
            throw new IllegalStateException("Connectivity listener already registered");
        }
        this.mConnectivityListener = listener;
    }

    @Override
    public void registerListener(INetworkPolicyListener listener) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        this.mListeners.register(listener);
    }

    @Override
    public void unregisterListener(INetworkPolicyListener listener) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        this.mListeners.unregister(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNetworkPolicies(NetworkPolicy[] policies) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        long token = Binder.clearCallingIdentity();
        try {
            this.maybeRefreshTrustedTime();
            Object object = this.mUidRulesFirstLock;
            synchronized (object) {
                Object object2 = this.mNetworkPoliciesSecondLock;
                synchronized (object2) {
                    this.normalizePoliciesNL(policies);
                    this.updateNetworkEnabledNL();
                    this.updateNetworkRulesNL();
                    this.updateNotificationsNL();
                    this.writePolicyAL();
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    void addNetworkPolicyNL(NetworkPolicy policy) {
        NetworkPolicy[] policies = this.getNetworkPolicies(this.mContext.getOpPackageName());
        policies = ArrayUtils.appendElement(NetworkPolicy.class, policies, policy);
        this.setNetworkPolicies(policies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkPolicy[] getNetworkPolicies(String callingPackage) {
        block6: {
            this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
            try {
                this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", TAG);
            }
            catch (SecurityException e) {
                this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PHONE_STATE", TAG);
                if (this.mAppOps.noteOp(51, Binder.getCallingUid(), callingPackage) == 0) break block6;
                return new NetworkPolicy[0];
            }
        }
        Object object = this.mNetworkPoliciesSecondLock;
        synchronized (object) {
            int size = this.mNetworkPolicy.size();
            NetworkPolicy[] policies = new NetworkPolicy[size];
            for (int i = 0; i < size; ++i) {
                policies[i] = this.mNetworkPolicy.valueAt(i);
            }
            return policies;
        }
    }

    private void normalizePoliciesNL() {
        this.normalizePoliciesNL(this.getNetworkPolicies(this.mContext.getOpPackageName()));
    }

    private void normalizePoliciesNL(NetworkPolicy[] policies) {
        TelephonyManager tele = TelephonyManager.from(this.mContext);
        String[] merged = tele.getMergedSubscriberIds();
        this.mNetworkPolicy.clear();
        for (NetworkPolicy policy : policies) {
            policy.template = NetworkTemplate.normalize(policy.template, merged);
            NetworkPolicy existing = this.mNetworkPolicy.get(policy.template);
            if (existing != null && existing.compareTo(policy) <= 0) continue;
            if (existing != null) {
                Slog.d(TAG, "Normalization replaced " + existing + " with " + policy);
            }
            this.mNetworkPolicy.put(policy.template, policy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void snoozeLimit(NetworkTemplate template) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        long token = Binder.clearCallingIdentity();
        try {
            this.performSnooze(template, 2);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performSnooze(NetworkTemplate template, int type) {
        this.maybeRefreshTrustedTime();
        long currentTime = this.currentTimeMillis();
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            Object object2 = this.mNetworkPoliciesSecondLock;
            synchronized (object2) {
                NetworkPolicy policy = this.mNetworkPolicy.get(template);
                if (policy == null) {
                    throw new IllegalArgumentException("unable to find policy for " + template);
                }
                switch (type) {
                    case 1: {
                        policy.lastWarningSnooze = currentTime;
                        break;
                    }
                    case 2: {
                        policy.lastLimitSnooze = currentTime;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unexpected type");
                    }
                }
                this.normalizePoliciesNL();
                this.updateNetworkEnabledNL();
                this.updateNetworkRulesNL();
                this.updateNotificationsNL();
                this.writePolicyAL();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTetheringChanged(String iface, boolean tethering) {
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            if (this.mRestrictBackground && tethering) {
                Log.d(TAG, "Tethering on (" + iface + "); disable Data Saver");
                this.setRestrictBackground(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRestrictBackground(boolean restrictBackground) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        long token = Binder.clearCallingIdentity();
        try {
            this.maybeRefreshTrustedTime();
            Object object = this.mUidRulesFirstLock;
            synchronized (object) {
                block8: {
                    if (restrictBackground != this.mRestrictBackground) break block8;
                    Slog.w(TAG, "setRestrictBackground: already " + restrictBackground);
                    return;
                }
                this.setRestrictBackgroundUL(restrictBackground);
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        this.mHandler.obtainMessage(6, restrictBackground ? 1 : 0, 0).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRestrictBackgroundUL(boolean restrictBackground) {
        Slog.d(TAG, "setRestrictBackgroundUL(): " + restrictBackground);
        boolean oldRestrictBackground = this.mRestrictBackground;
        this.mRestrictBackground = restrictBackground;
        this.updateRulesForAllAppsUL(1);
        try {
            if (!this.mNetworkManager.setDataSaverModeEnabled(this.mRestrictBackground)) {
                Slog.e(TAG, "Could not change Data Saver Mode on NMS to " + this.mRestrictBackground);
                this.mRestrictBackground = oldRestrictBackground;
                return;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        Object object = this.mNetworkPoliciesSecondLock;
        synchronized (object) {
            this.updateNotificationsNL();
            this.writePolicyAL();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRestrictBackgroundWhitelistedUid(int uid) {
        int changed;
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            boolean oldStatus = this.mRestrictBackgroundWhitelistUids.get(uid);
            if (oldStatus) {
                return;
            }
            boolean needFirewallRules = this.isUidValidForWhitelistRules(uid);
            Slog.i(TAG, "adding uid " + uid + " to restrict background whitelist");
            this.mRestrictBackgroundWhitelistUids.append(uid, true);
            if (this.mDefaultRestrictBackgroundWhitelistUids.get(uid) && this.mRestrictBackgroundWhitelistRevokedUids.get(uid)) {
                this.mRestrictBackgroundWhitelistRevokedUids.delete(uid);
            }
            if (needFirewallRules) {
                this.updateRulesForDataUsageRestrictionsUL(uid);
            }
            Object object2 = this.mNetworkPoliciesSecondLock;
            synchronized (object2) {
                this.writePolicyAL();
            }
            changed = this.mRestrictBackground && !oldStatus && needFirewallRules ? 1 : 0;
        }
        this.mHandler.obtainMessage(9, uid, changed, Boolean.TRUE).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRestrictBackgroundWhitelistedUid(int uid) {
        boolean changed;
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            changed = this.removeRestrictBackgroundWhitelistedUidUL(uid, false, true);
        }
        this.mHandler.obtainMessage(9, uid, changed ? 1 : 0, Boolean.FALSE).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeRestrictBackgroundWhitelistedUidUL(int uid, boolean uidDeleted, boolean updateNow) {
        boolean needFirewallRules;
        boolean oldStatus = this.mRestrictBackgroundWhitelistUids.get(uid);
        if (!oldStatus && !uidDeleted) {
            return false;
        }
        boolean bl = needFirewallRules = uidDeleted || this.isUidValidForWhitelistRules(uid);
        if (oldStatus) {
            Slog.i(TAG, "removing uid " + uid + " from restrict background whitelist");
            this.mRestrictBackgroundWhitelistUids.delete(uid);
        }
        if (this.mDefaultRestrictBackgroundWhitelistUids.get(uid) && !this.mRestrictBackgroundWhitelistRevokedUids.get(uid)) {
            this.mRestrictBackgroundWhitelistRevokedUids.append(uid, true);
        }
        if (needFirewallRules) {
            this.updateRulesForDataUsageRestrictionsUL(uid, uidDeleted);
        }
        if (updateNow) {
            Object object = this.mNetworkPoliciesSecondLock;
            synchronized (object) {
                this.writePolicyAL();
            }
        }
        return this.mRestrictBackground && needFirewallRules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getRestrictBackgroundWhitelistedUids() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            int size = this.mRestrictBackgroundWhitelistUids.size();
            int[] whitelist = new int[size];
            for (int i = 0; i < size; ++i) {
                whitelist[i] = this.mRestrictBackgroundWhitelistUids.keyAt(i);
            }
            return whitelist;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRestrictBackgroundByCaller() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
        int uid = Binder.getCallingUid();
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            int policy;
            long token = Binder.clearCallingIdentity();
            try {
                policy = this.getUidPolicy(uid);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            if (policy == 1) {
                return 3;
            }
            if (!this.mRestrictBackground) {
                return 1;
            }
            return this.mRestrictBackgroundWhitelistUids.get(uid) ? 2 : 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getRestrictBackground() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            return this.mRestrictBackground;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDeviceIdleMode(boolean enabled) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            if (this.mDeviceIdleMode != enabled) {
                this.mDeviceIdleMode = enabled;
                if (this.mSystemReady) {
                    this.updateRulesForRestrictPowerUL();
                }
                if (enabled) {
                    EventLogTags.writeDeviceIdleOnPhase("net");
                } else {
                    EventLogTags.writeDeviceIdleOffPhase("net");
                }
            }
        }
    }

    private NetworkPolicy findPolicyForNetworkNL(NetworkIdentity ident) {
        for (int i = this.mNetworkPolicy.size() - 1; i >= 0; --i) {
            NetworkPolicy policy = this.mNetworkPolicy.valueAt(i);
            if (!policy.template.matches(ident)) continue;
            return policy;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkQuotaInfo getNetworkQuotaInfo(NetworkState state) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
        long token = Binder.clearCallingIdentity();
        try {
            NetworkQuotaInfo networkQuotaInfo = this.getNetworkQuotaInfoUnchecked(state);
            return networkQuotaInfo;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkQuotaInfo getNetworkQuotaInfoUnchecked(NetworkState state) {
        NetworkPolicy policy;
        NetworkIdentity ident = NetworkIdentity.buildNetworkIdentity(this.mContext, state);
        Object object = this.mNetworkPoliciesSecondLock;
        synchronized (object) {
            policy = this.findPolicyForNetworkNL(ident);
        }
        if (policy == null || !policy.hasCycle()) {
            return null;
        }
        long currentTime = this.currentTimeMillis();
        long start = NetworkPolicyManager.computeLastCycleBoundary(currentTime, policy);
        long end = currentTime;
        long totalBytes = this.getTotalBytes(policy.template, start, end);
        long softLimitBytes = policy.warningBytes != -1L ? policy.warningBytes : -1L;
        long hardLimitBytes = policy.limitBytes != -1L ? policy.limitBytes : -1L;
        return new NetworkQuotaInfo(totalBytes, softLimitBytes, hardLimitBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNetworkMetered(NetworkState state) {
        NetworkPolicy policy;
        if (state.networkInfo == null) {
            return false;
        }
        NetworkIdentity ident = NetworkIdentity.buildNetworkIdentity(this.mContext, state);
        Object object = this.mNetworkPoliciesSecondLock;
        synchronized (object) {
            policy = this.findPolicyForNetworkNL(ident);
        }
        if (policy != null) {
            return policy.metered;
        }
        int type = state.networkInfo.getType();
        return ConnectivityManager.isNetworkTypeMobile(type) && ident.getMetered() || type == 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        IndentingPrintWriter fout = new IndentingPrintWriter((Writer)writer, "  ");
        ArraySet<String> argSet = new ArraySet<String>(args.length);
        for (String arg : args) {
            argSet.add(arg);
        }
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            Object object2 = this.mNetworkPoliciesSecondLock;
            synchronized (object2) {
                int uid;
                int i;
                int i2;
                if (argSet.contains("--unsnooze")) {
                    for (int i3 = this.mNetworkPolicy.size() - 1; i3 >= 0; --i3) {
                        this.mNetworkPolicy.valueAt(i3).clearSnooze();
                    }
                    this.normalizePoliciesNL();
                    this.updateNetworkEnabledNL();
                    this.updateNetworkRulesNL();
                    this.updateNotificationsNL();
                    this.writePolicyAL();
                    fout.println("Cleared snooze timestamps");
                    return;
                }
                fout.print("System ready: ");
                fout.println(this.mSystemReady);
                fout.print("Restrict background: ");
                fout.println(this.mRestrictBackground);
                fout.print("Restrict power: ");
                fout.println(this.mRestrictPower);
                fout.print("Device idle: ");
                fout.println(this.mDeviceIdleMode);
                fout.println("Network policies:");
                fout.increaseIndent();
                for (int i3 = 0; i3 < this.mNetworkPolicy.size(); ++i3) {
                    fout.println(this.mNetworkPolicy.valueAt(i3).toString());
                }
                fout.decreaseIndent();
                fout.print("Metered ifaces: ");
                fout.println(String.valueOf(this.mMeteredIfaces));
                fout.println("Policy for UIDs:");
                fout.increaseIndent();
                int size = this.mUidPolicy.size();
                for (int i22 = 0; i22 < size; ++i22) {
                    int uid2 = this.mUidPolicy.keyAt(i22);
                    int policy = this.mUidPolicy.valueAt(i22);
                    fout.print("UID=");
                    fout.print(uid2);
                    fout.print(" policy=");
                    fout.print(DebugUtils.flagsToString(NetworkPolicyManager.class, "POLICY_", policy));
                    fout.println();
                }
                fout.decreaseIndent();
                size = this.mPowerSaveWhitelistExceptIdleAppIds.size();
                if (size > 0) {
                    fout.println("Power save whitelist (except idle) app ids:");
                    fout.increaseIndent();
                    for (i2 = 0; i2 < size; ++i2) {
                        fout.print("UID=");
                        fout.print(this.mPowerSaveWhitelistExceptIdleAppIds.keyAt(i2));
                        fout.print(": ");
                        fout.print(this.mPowerSaveWhitelistExceptIdleAppIds.valueAt(i2));
                        fout.println();
                    }
                    fout.decreaseIndent();
                }
                if ((size = this.mPowerSaveWhitelistAppIds.size()) > 0) {
                    fout.println("Power save whitelist app ids:");
                    fout.increaseIndent();
                    for (i2 = 0; i2 < size; ++i2) {
                        fout.print("UID=");
                        fout.print(this.mPowerSaveWhitelistAppIds.keyAt(i2));
                        fout.print(": ");
                        fout.print(this.mPowerSaveWhitelistAppIds.valueAt(i2));
                        fout.println();
                    }
                    fout.decreaseIndent();
                }
                if ((size = this.mRestrictBackgroundWhitelistUids.size()) > 0) {
                    fout.println("Restrict background whitelist uids:");
                    fout.increaseIndent();
                    for (i2 = 0; i2 < size; ++i2) {
                        fout.print("UID=");
                        fout.print(this.mRestrictBackgroundWhitelistUids.keyAt(i2));
                        fout.println();
                    }
                    fout.decreaseIndent();
                }
                if ((size = this.mDefaultRestrictBackgroundWhitelistUids.size()) > 0) {
                    fout.println("Default restrict background whitelist uids:");
                    fout.increaseIndent();
                    for (i2 = 0; i2 < size; ++i2) {
                        fout.print("UID=");
                        fout.print(this.mDefaultRestrictBackgroundWhitelistUids.keyAt(i2));
                        fout.println();
                    }
                    fout.decreaseIndent();
                }
                if ((size = this.mRestrictBackgroundWhitelistRevokedUids.size()) > 0) {
                    fout.println("Default restrict background whitelist uids revoked by users:");
                    fout.increaseIndent();
                    for (i2 = 0; i2 < size; ++i2) {
                        fout.print("UID=");
                        fout.print(this.mRestrictBackgroundWhitelistRevokedUids.keyAt(i2));
                        fout.println();
                    }
                    fout.decreaseIndent();
                }
                SparseBooleanArray knownUids = new SparseBooleanArray();
                NetworkPolicyManagerService.collectKeys(this.mUidState, knownUids);
                NetworkPolicyManagerService.collectKeys(this.mUidRules, knownUids);
                fout.println("Status for all known UIDs:");
                fout.increaseIndent();
                size = knownUids.size();
                for (i = 0; i < size; ++i) {
                    uid = knownUids.keyAt(i);
                    fout.print("UID=");
                    fout.print(uid);
                    int state = this.mUidState.get(uid, 16);
                    fout.print(" state=");
                    fout.print(state);
                    if (state <= 2) {
                        fout.print(" (fg)");
                    } else {
                        fout.print(state <= 4 ? " (fg svc)" : " (bg)");
                    }
                    int uidRules = this.mUidRules.get(uid, 0);
                    fout.print(" rules=");
                    fout.print(NetworkPolicyManager.uidRulesToString(uidRules));
                    fout.println();
                }
                fout.decreaseIndent();
                fout.println("Status for just UIDs with rules:");
                fout.increaseIndent();
                size = this.mUidRules.size();
                for (i = 0; i < size; ++i) {
                    uid = this.mUidRules.keyAt(i);
                    fout.print("UID=");
                    fout.print(uid);
                    int uidRules = this.mUidRules.get(uid, 0);
                    fout.print(" rules=");
                    fout.print(NetworkPolicyManager.uidRulesToString(uidRules));
                    fout.println();
                }
                fout.decreaseIndent();
            }
        }
    }

    @Override
    public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ResultReceiver resultReceiver) throws RemoteException {
        new NetworkPolicyManagerShellCommand(this.mContext, this).exec(this, in, out, err, args, resultReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUidForeground(int uid) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            return this.isUidForegroundUL(uid);
        }
    }

    private boolean isUidForegroundUL(int uid) {
        return this.isUidStateForegroundUL(this.mUidState.get(uid, 16));
    }

    private boolean isUidForegroundOnRestrictBackgroundUL(int uid) {
        int procState = this.mUidState.get(uid, 16);
        return NetworkPolicyManagerService.isProcStateAllowedWhileOnRestrictBackground(procState);
    }

    private boolean isUidForegroundOnRestrictPowerUL(int uid) {
        int procState = this.mUidState.get(uid, 16);
        return NetworkPolicyManagerService.isProcStateAllowedWhileIdleOrPowerSaveMode(procState);
    }

    private boolean isUidStateForegroundUL(int state) {
        return state <= 2;
    }

    private void updateUidStateUL(int uid, int uidState) {
        int oldUidState = this.mUidState.get(uid, 16);
        if (oldUidState != uidState) {
            this.mUidState.put(uid, uidState);
            this.updateRestrictBackgroundRulesOnUidStatusChangedUL(uid, oldUidState, uidState);
            if (NetworkPolicyManagerService.isProcStateAllowedWhileIdleOrPowerSaveMode(oldUidState) != NetworkPolicyManagerService.isProcStateAllowedWhileIdleOrPowerSaveMode(uidState)) {
                if (this.isUidIdle(uid)) {
                    this.updateRuleForAppIdleUL(uid);
                }
                if (this.mDeviceIdleMode) {
                    this.updateRuleForDeviceIdleUL(uid);
                }
                if (this.mRestrictPower) {
                    this.updateRuleForRestrictPowerUL(uid);
                }
                this.updateRulesForPowerRestrictionsUL(uid);
            }
            this.updateNetworkStats(uid, this.isUidStateForegroundUL(uidState));
        }
    }

    private void removeUidStateUL(int uid) {
        int index = this.mUidState.indexOfKey(uid);
        if (index >= 0) {
            int oldUidState = this.mUidState.valueAt(index);
            this.mUidState.removeAt(index);
            if (oldUidState != 16) {
                this.updateRestrictBackgroundRulesOnUidStatusChangedUL(uid, oldUidState, 16);
                if (this.mDeviceIdleMode) {
                    this.updateRuleForDeviceIdleUL(uid);
                }
                if (this.mRestrictPower) {
                    this.updateRuleForRestrictPowerUL(uid);
                }
                this.updateRulesForPowerRestrictionsUL(uid);
                this.updateNetworkStats(uid, false);
            }
        }
    }

    private void updateNetworkStats(int uid, boolean uidForeground) {
        try {
            this.mNetworkStats.setUidForeground(uid, uidForeground);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void updateRestrictBackgroundRulesOnUidStatusChangedUL(int uid, int oldUidState, int newUidState) {
        boolean newForeground;
        boolean oldForeground = NetworkPolicyManagerService.isProcStateAllowedWhileOnRestrictBackground(oldUidState);
        if (oldForeground != (newForeground = NetworkPolicyManagerService.isProcStateAllowedWhileOnRestrictBackground(newUidState))) {
            this.updateRulesForDataUsageRestrictionsUL(uid);
        }
    }

    static boolean isProcStateAllowedWhileIdleOrPowerSaveMode(int procState) {
        return procState <= 4;
    }

    static boolean isProcStateAllowedWhileOnRestrictBackground(int procState) {
        return procState <= 4;
    }

    void updateRulesForPowerSaveUL() {
        this.updateRulesForWhitelistedPowerSaveUL(this.mRestrictPower, 3, this.mUidFirewallPowerSaveRules);
    }

    void updateRuleForRestrictPowerUL(int uid) {
        this.updateRulesForWhitelistedPowerSaveUL(uid, this.mRestrictPower, 3);
    }

    void updateRulesForDeviceIdleUL() {
        this.updateRulesForWhitelistedPowerSaveUL(this.mDeviceIdleMode, 1, this.mUidFirewallDozableRules);
    }

    void updateRuleForDeviceIdleUL(int uid) {
        this.updateRulesForWhitelistedPowerSaveUL(uid, this.mDeviceIdleMode, 1);
    }

    private void updateRulesForWhitelistedPowerSaveUL(boolean enabled, int chain, SparseIntArray rules) {
        if (enabled) {
            SparseIntArray uidRules = rules;
            uidRules.clear();
            List<UserInfo> users = this.mUserManager.getUsers();
            for (int ui = users.size() - 1; ui >= 0; --ui) {
                int uid;
                int appId;
                int i;
                UserInfo user = users.get(ui);
                for (i = this.mPowerSaveTempWhitelistAppIds.size() - 1; i >= 0; --i) {
                    if (!this.mPowerSaveTempWhitelistAppIds.valueAt(i)) continue;
                    appId = this.mPowerSaveTempWhitelistAppIds.keyAt(i);
                    uid = UserHandle.getUid(user.id, appId);
                    uidRules.put(uid, 1);
                }
                for (i = this.mPowerSaveWhitelistAppIds.size() - 1; i >= 0; --i) {
                    appId = this.mPowerSaveWhitelistAppIds.keyAt(i);
                    uid = UserHandle.getUid(user.id, appId);
                    uidRules.put(uid, 1);
                }
            }
            for (int i = this.mUidState.size() - 1; i >= 0; --i) {
                if (!NetworkPolicyManagerService.isProcStateAllowedWhileIdleOrPowerSaveMode(this.mUidState.valueAt(i))) continue;
                uidRules.put(this.mUidState.keyAt(i), 1);
            }
            this.setUidFirewallRules(chain, uidRules);
        }
        this.enableFirewallChainUL(chain, enabled);
    }

    private boolean isWhitelistedBatterySaverUL(int uid) {
        int appId = UserHandle.getAppId(uid);
        return this.mPowerSaveTempWhitelistAppIds.get(appId) || this.mPowerSaveWhitelistAppIds.get(appId);
    }

    private void updateRulesForWhitelistedPowerSaveUL(int uid, boolean enabled, int chain) {
        if (enabled) {
            if (this.isWhitelistedBatterySaverUL(uid) || NetworkPolicyManagerService.isProcStateAllowedWhileIdleOrPowerSaveMode(this.mUidState.get(uid))) {
                this.setUidFirewallRule(chain, uid, 1);
            } else {
                this.setUidFirewallRule(chain, uid, 0);
            }
        }
    }

    void updateRulesForAppIdleUL() {
        SparseIntArray uidRules = this.mUidFirewallStandbyRules;
        uidRules.clear();
        List<UserInfo> users = this.mUserManager.getUsers();
        for (int ui = users.size() - 1; ui >= 0; --ui) {
            int[] idleUids;
            UserInfo user = users.get(ui);
            for (int uid : idleUids = this.mUsageStats.getIdleUidsForUser(user.id)) {
                if (this.mPowerSaveTempWhitelistAppIds.get(UserHandle.getAppId(uid), false) || !this.hasInternetPermissions(uid)) continue;
                uidRules.put(uid, 2);
            }
        }
        this.setUidFirewallRules(2, uidRules);
    }

    void updateRuleForAppIdleUL(int uid) {
        if (!this.isUidValidForBlacklistRules(uid)) {
            return;
        }
        int appId = UserHandle.getAppId(uid);
        if (!this.mPowerSaveTempWhitelistAppIds.get(appId) && this.isUidIdle(uid) && !this.isUidForegroundOnRestrictPowerUL(uid)) {
            this.setUidFirewallRule(2, uid, 2);
        } else {
            this.setUidFirewallRule(2, uid, 0);
        }
    }

    void updateRulesForAppIdleParoleUL() {
        boolean enableChain = !this.mUsageStats.isAppIdleParoleOn();
        this.enableFirewallChainUL(2, enableChain);
    }

    private void updateRulesForGlobalChangeAL(boolean restrictedNetworksChanged) {
        this.updateRulesForRestrictPowerUL();
        this.updateRulesForRestrictBackgroundUL();
        if (restrictedNetworksChanged) {
            this.normalizePoliciesNL();
            this.updateNetworkRulesNL();
        }
    }

    private void updateRulesForRestrictPowerUL() {
        this.updateRulesForDeviceIdleUL();
        this.updateRulesForAppIdleUL();
        this.updateRulesForPowerSaveUL();
        this.updateRulesForAllAppsUL(2);
    }

    private void updateRulesForRestrictBackgroundUL() {
        this.updateRulesForAllAppsUL(1);
    }

    private void updateRulesForAllAppsUL(int type) {
        PackageManager pm = this.mContext.getPackageManager();
        List<UserInfo> users = this.mUserManager.getUsers();
        List<ApplicationInfo> apps = pm.getInstalledApplications(795136);
        int usersSize = users.size();
        int appsSize = apps.size();
        for (int i = 0; i < usersSize; ++i) {
            UserInfo user = users.get(i);
            block5: for (int j = 0; j < appsSize; ++j) {
                ApplicationInfo app = apps.get(j);
                int uid = UserHandle.getUid(user.id, app.uid);
                switch (type) {
                    case 1: {
                        this.updateRulesForDataUsageRestrictionsUL(uid);
                        continue block5;
                    }
                    case 2: {
                        this.updateRulesForPowerRestrictionsUL(uid);
                        continue block5;
                    }
                    default: {
                        Slog.w(TAG, "Invalid type for updateRulesForAllApps: " + type);
                    }
                }
            }
        }
    }

    private void updateRulesForTempWhitelistChangeUL() {
        List<UserInfo> users = this.mUserManager.getUsers();
        for (int i = 0; i < users.size(); ++i) {
            UserInfo user = users.get(i);
            for (int j = this.mPowerSaveTempWhitelistAppIds.size() - 1; j >= 0; --j) {
                int appId = this.mPowerSaveTempWhitelistAppIds.keyAt(j);
                int uid = UserHandle.getUid(user.id, appId);
                this.updateRuleForAppIdleUL(uid);
                this.updateRuleForDeviceIdleUL(uid);
                this.updateRuleForRestrictPowerUL(uid);
                this.updateRulesForPowerRestrictionsUL(uid);
            }
        }
    }

    private boolean isUidValidForBlacklistRules(int uid) {
        return uid == 1013 || uid == 1019 || UserHandle.isApp(uid) && this.hasInternetPermissions(uid);
    }

    private boolean isUidValidForWhitelistRules(int uid) {
        return UserHandle.isApp(uid) && this.hasInternetPermissions(uid);
    }

    private boolean isUidIdle(int uid) {
        String[] packages = this.mContext.getPackageManager().getPackagesForUid(uid);
        int userId = UserHandle.getUserId(uid);
        if (!ArrayUtils.isEmpty(packages)) {
            for (String packageName : packages) {
                if (this.mUsageStats.isAppIdle(packageName, uid, userId)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean hasInternetPermissions(int uid) {
        try {
            if (this.mIPm.checkUidPermission("android.permission.INTERNET", uid) != 0) {
                return false;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return true;
    }

    private void updateRestrictionRulesForUidUL(int uid) {
        this.updateRuleForDeviceIdleUL(uid);
        this.updateRuleForAppIdleUL(uid);
        this.updateRuleForRestrictPowerUL(uid);
        this.updateRulesForPowerRestrictionsUL(uid);
        this.updateRulesForDataUsageRestrictionsUL(uid);
    }

    private void updateRulesForDataUsageRestrictionsUL(int uid) {
        this.updateRulesForDataUsageRestrictionsUL(uid, false);
    }

    private void updateRulesForDataUsageRestrictionsUL(int uid, boolean uidDeleted) {
        if (!uidDeleted && !this.isUidValidForWhitelistRules(uid)) {
            return;
        }
        int uidPolicy = this.mUidPolicy.get(uid, 0);
        int oldUidRules = this.mUidRules.get(uid, 0);
        boolean isForeground = this.isUidForegroundOnRestrictBackgroundUL(uid);
        boolean isBlacklisted = (uidPolicy & 1) != 0;
        boolean isWhitelisted = this.mRestrictBackgroundWhitelistUids.get(uid);
        int oldRule = oldUidRules & 0xF;
        int newRule = 0;
        if (isForeground) {
            if (isBlacklisted || this.mRestrictBackground && !isWhitelisted) {
                newRule = 2;
            } else if (isWhitelisted) {
                newRule = 1;
            }
        } else if (isBlacklisted) {
            newRule = 4;
        } else if (this.mRestrictBackground && isWhitelisted) {
            newRule = 1;
        }
        int newUidRules = newRule | oldUidRules & 0xF0;
        if (newUidRules == 0) {
            this.mUidRules.delete(uid);
        } else {
            this.mUidRules.put(uid, newUidRules);
        }
        if (newRule != oldRule) {
            if ((newRule & 2) != 0) {
                this.setMeteredNetworkWhitelist(uid, true);
                if (isBlacklisted) {
                    this.setMeteredNetworkBlacklist(uid, false);
                }
            } else if ((oldRule & 2) != 0) {
                if (!isWhitelisted) {
                    this.setMeteredNetworkWhitelist(uid, false);
                }
                if (isBlacklisted) {
                    this.setMeteredNetworkBlacklist(uid, true);
                }
            } else if ((newRule & 4) != 0 || (oldRule & 4) != 0) {
                this.setMeteredNetworkBlacklist(uid, isBlacklisted);
                if ((oldRule & 4) != 0 && isWhitelisted) {
                    this.setMeteredNetworkWhitelist(uid, isWhitelisted);
                }
            } else if ((newRule & 1) != 0 || (oldRule & 1) != 0) {
                this.setMeteredNetworkWhitelist(uid, isWhitelisted);
            } else {
                Log.wtf(TAG, "Unexpected change of metered UID state for " + uid + ": foreground=" + isForeground + ", whitelisted=" + isWhitelisted + ", blacklisted=" + isBlacklisted + ", newRule=" + NetworkPolicyManager.uidRulesToString(newUidRules) + ", oldRule=" + NetworkPolicyManager.uidRulesToString(oldUidRules));
            }
            this.mHandler.obtainMessage(1, uid, newUidRules).sendToTarget();
        }
    }

    private void updateRulesForPowerRestrictionsUL(int uid) {
        int newUidRules;
        if (!this.isUidValidForBlacklistRules(uid)) {
            return;
        }
        boolean isIdle = this.isUidIdle(uid);
        boolean restrictMode = isIdle || this.mRestrictPower || this.mDeviceIdleMode;
        int oldUidRules = this.mUidRules.get(uid, 0);
        boolean isForeground = this.isUidForegroundOnRestrictPowerUL(uid);
        boolean isWhitelisted = this.isWhitelistedBatterySaverUL(uid);
        int oldRule = oldUidRules & 0xF0;
        int newRule = 0;
        if (isForeground) {
            if (restrictMode) {
                newRule = 32;
            }
        } else if (restrictMode) {
            int n = newRule = isWhitelisted ? 32 : 64;
        }
        if ((newUidRules = oldUidRules & 0xF | newRule) == 0) {
            this.mUidRules.delete(uid);
        } else {
            this.mUidRules.put(uid, newUidRules);
        }
        if (newRule != oldRule) {
            if (newRule != 0 && (newRule & 0x20) == 0 && (newRule & 0x40) == 0) {
                Log.wtf(TAG, "Unexpected change of non-metered UID state for " + uid + ": foreground=" + isForeground + ", whitelisted=" + isWhitelisted + ", newRule=" + NetworkPolicyManager.uidRulesToString(newUidRules) + ", oldRule=" + NetworkPolicyManager.uidRulesToString(oldUidRules));
            }
            this.mHandler.obtainMessage(1, uid, newUidRules).sendToTarget();
        }
    }

    private void dispatchUidRulesChanged(INetworkPolicyListener listener, int uid, int uidRules) {
        if (listener != null) {
            try {
                listener.onUidRulesChanged(uid, uidRules);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private void dispatchMeteredIfacesChanged(INetworkPolicyListener listener, String[] meteredIfaces) {
        if (listener != null) {
            try {
                listener.onMeteredIfacesChanged(meteredIfaces);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private void dispatchRestrictBackgroundChanged(INetworkPolicyListener listener, boolean restrictBackground) {
        if (listener != null) {
            try {
                listener.onRestrictBackgroundChanged(restrictBackground);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private void dispatchRestrictBackgroundWhitelistChanged(INetworkPolicyListener listener, int uid, boolean whitelisted) {
        if (listener != null) {
            try {
                listener.onRestrictBackgroundWhitelistChanged(uid, whitelisted);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private void dispatchRestrictBackgroundBlacklistChanged(INetworkPolicyListener listener, int uid, boolean blacklisted) {
        if (listener != null) {
            try {
                listener.onRestrictBackgroundBlacklistChanged(uid, blacklisted);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private void setInterfaceQuota(String iface, long quotaBytes) {
        try {
            this.mNetworkManager.setInterfaceQuota(iface, quotaBytes);
        }
        catch (IllegalStateException e) {
            Log.wtf(TAG, "problem setting interface quota", e);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void removeInterfaceQuota(String iface) {
        try {
            this.mNetworkManager.removeInterfaceQuota(iface);
        }
        catch (IllegalStateException e) {
            Log.wtf(TAG, "problem removing interface quota", e);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void setMeteredNetworkBlacklist(int uid, boolean enable) {
        try {
            this.mNetworkManager.setUidMeteredNetworkBlacklist(uid, enable);
        }
        catch (IllegalStateException e) {
            Log.wtf(TAG, "problem setting blacklist (" + enable + ") rules for " + uid, e);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void setMeteredNetworkWhitelist(int uid, boolean enable) {
        try {
            this.mNetworkManager.setUidMeteredNetworkWhitelist(uid, enable);
        }
        catch (IllegalStateException e) {
            Log.wtf(TAG, "problem setting whitelist (" + enable + ") rules for " + uid, e);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void setUidFirewallRules(int chain, SparseIntArray uidRules) {
        try {
            int size = uidRules.size();
            int[] uids = new int[size];
            int[] rules = new int[size];
            for (int index = size - 1; index >= 0; --index) {
                uids[index] = uidRules.keyAt(index);
                rules[index] = uidRules.valueAt(index);
            }
            this.mNetworkManager.setFirewallUidRules(chain, uids, rules);
        }
        catch (IllegalStateException e) {
            Log.wtf(TAG, "problem setting firewall uid rules", e);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void setUidFirewallRule(int chain, int uid, int rule) {
        if (chain == 1) {
            this.mUidFirewallDozableRules.put(uid, rule);
        } else if (chain == 2) {
            this.mUidFirewallStandbyRules.put(uid, rule);
        } else if (chain == 3) {
            this.mUidFirewallPowerSaveRules.put(uid, rule);
        }
        try {
            this.mNetworkManager.setFirewallUidRule(chain, uid, rule);
        }
        catch (IllegalStateException e) {
            Log.wtf(TAG, "problem setting firewall uid rules", e);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void enableFirewallChainUL(int chain, boolean enable) {
        if (this.mFirewallChainStates.indexOfKey(chain) >= 0 && this.mFirewallChainStates.get(chain) == enable) {
            return;
        }
        this.mFirewallChainStates.put(chain, enable);
        try {
            this.mNetworkManager.setFirewallChainEnabled(chain, enable);
        }
        catch (IllegalStateException e) {
            Log.wtf(TAG, "problem enable firewall chain", e);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private long getTotalBytes(NetworkTemplate template, long start, long end) {
        try {
            return this.mNetworkStats.getNetworkTotalBytes(template, start, end);
        }
        catch (RuntimeException e) {
            Slog.w(TAG, "problem reading network stats: " + e);
            return 0L;
        }
        catch (RemoteException e) {
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBandwidthControlEnabled() {
        long token = Binder.clearCallingIdentity();
        try {
            boolean bl = this.mNetworkManager.isBandwidthControlEnabled();
            return bl;
        }
        catch (RemoteException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    void maybeRefreshTrustedTime() {
        if (this.mTime.getCacheAge() > 86400000L) {
            this.mTime.forceRefresh();
        }
    }

    private long currentTimeMillis() {
        return this.mTime.hasCache() ? this.mTime.currentTimeMillis() : System.currentTimeMillis();
    }

    private static Intent buildAllowBackgroundDataIntent() {
        return new Intent(ACTION_ALLOW_BACKGROUND);
    }

    private static Intent buildSnoozeWarningIntent(NetworkTemplate template) {
        Intent intent = new Intent(ACTION_SNOOZE_WARNING);
        intent.putExtra("android.net.NETWORK_TEMPLATE", template);
        return intent;
    }

    private static Intent buildNetworkOverLimitIntent(NetworkTemplate template) {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.android.systemui", "com.android.systemui.net.NetworkOverLimitActivity"));
        intent.addFlags(0x10000000);
        intent.putExtra("android.net.NETWORK_TEMPLATE", template);
        return intent;
    }

    private static Intent buildViewDataUsageIntent(NetworkTemplate template) {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.android.settings", "com.android.settings.Settings$DataUsageSummaryActivity"));
        intent.addFlags(0x10000000);
        intent.putExtra("android.net.NETWORK_TEMPLATE", template);
        return intent;
    }

    public void addIdleHandler(MessageQueue.IdleHandler handler) {
        this.mHandler.getLooper().getQueue().addIdleHandler(handler);
    }

    private static void collectKeys(SparseIntArray source, SparseBooleanArray target) {
        int size = source.size();
        for (int i = 0; i < size; ++i) {
            target.put(source.keyAt(i), true);
        }
    }

    @Override
    public void factoryReset(String subscriber) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        if (this.mUserManager.hasUserRestriction("no_network_reset")) {
            return;
        }
        NetworkPolicy[] policies = this.getNetworkPolicies(this.mContext.getOpPackageName());
        NetworkTemplate template = NetworkTemplate.buildTemplateMobileAll(subscriber);
        for (NetworkPolicy policy : policies) {
            if (!policy.template.equals(template)) continue;
            policy.limitBytes = -1L;
            policy.inferred = false;
            policy.clearSnooze();
        }
        this.setNetworkPolicies(policies);
        this.setRestrictBackground(false);
        if (!this.mUserManager.hasUserRestriction("no_control_apps")) {
            for (int uid : this.getUidsWithPolicy(1)) {
                this.setUidPolicy(uid, 0);
            }
        }
    }

    private class NetworkPolicyManagerInternalImpl
    extends NetworkPolicyManagerInternal {
        private NetworkPolicyManagerInternalImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resetUserState(int userId) {
            Object object = NetworkPolicyManagerService.this.mUidRulesFirstLock;
            synchronized (object) {
                boolean changed = NetworkPolicyManagerService.this.removeUserStateUL(userId, false);
                boolean bl = changed = NetworkPolicyManagerService.this.addDefaultRestrictBackgroundWhitelistUidsUL(userId) || changed;
                if (changed) {
                    Object object2 = NetworkPolicyManagerService.this.mNetworkPoliciesSecondLock;
                    synchronized (object2) {
                        NetworkPolicyManagerService.this.writePolicyAL();
                    }
                }
            }
        }
    }

    private class MyPackageMonitor
    extends PackageMonitor {
        private MyPackageMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackageRemoved(String packageName, int uid) {
            Object object = NetworkPolicyManagerService.this.mUidRulesFirstLock;
            synchronized (object) {
                NetworkPolicyManagerService.this.removeRestrictBackgroundWhitelistedUidUL(uid, true, true);
                NetworkPolicyManagerService.this.updateRestrictionRulesForUidUL(uid);
            }
        }
    }

    private class AppIdleStateChangeListener
    extends UsageStatsManagerInternal.AppIdleStateChangeListener {
        private AppIdleStateChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAppIdleStateChanged(String packageName, int userId, boolean idle) {
            try {
                int uid = NetworkPolicyManagerService.this.mContext.getPackageManager().getPackageUidAsUser(packageName, 8192, userId);
                Object object = NetworkPolicyManagerService.this.mUidRulesFirstLock;
                synchronized (object) {
                    NetworkPolicyManagerService.this.updateRuleForAppIdleUL(uid);
                    NetworkPolicyManagerService.this.updateRulesForPowerRestrictionsUL(uid);
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onParoleStateChanged(boolean isParoleOn) {
            Object object = NetworkPolicyManagerService.this.mUidRulesFirstLock;
            synchronized (object) {
                NetworkPolicyManagerService.this.updateRulesForAppIdleParoleUL();
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(flag=false, value={1L, 2L})
    public static @interface RestrictType {
    }
}

