/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import com.android.server.notification.NotificationRecord;
import java.util.Comparator;

public class NotificationComparator
implements Comparator<NotificationRecord> {
    @Override
    public int compare(NotificationRecord left, NotificationRecord right) {
        float rightPeople;
        int rightPackagePriority;
        int rightImportance;
        int leftImportance = left.getImportance();
        if (leftImportance != (rightImportance = right.getImportance())) {
            return -1 * Integer.compare(leftImportance, rightImportance);
        }
        int leftPackagePriority = left.getPackagePriority();
        if (leftPackagePriority != (rightPackagePriority = right.getPackagePriority())) {
            return -1 * Integer.compare(leftPackagePriority, rightPackagePriority);
        }
        int leftPriority = left.sbn.getNotification().priority;
        int rightPriority = right.sbn.getNotification().priority;
        if (leftPriority != rightPriority) {
            return -1 * Integer.compare(leftPriority, rightPriority);
        }
        float leftPeople = left.getContactAffinity();
        if (leftPeople != (rightPeople = right.getContactAffinity())) {
            return -1 * Float.compare(leftPeople, rightPeople);
        }
        return -1 * Long.compare(left.getRankingTimeMs(), right.getRankingTimeMs());
    }
}

