/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.ActivityManagerNative;
import android.app.AppGlobals;
import android.app.AppOpsManager;
import android.app.AutomaticZenRule;
import android.app.IActivityManager;
import android.app.INotificationManager;
import android.app.ITransientNotification;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.backup.BackupManager;
import android.app.usage.UsageStatsManagerInternal;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.media.AudioManagerInternal;
import android.media.AudioSystem;
import android.media.IRingtonePlayer;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.Vibrator;
import android.provider.Settings;
import android.service.notification.Adjustment;
import android.service.notification.Condition;
import android.service.notification.IConditionProvider;
import android.service.notification.INotificationListener;
import android.service.notification.IStatusBarNotificationHolder;
import android.service.notification.NotificationRankingUpdate;
import android.service.notification.StatusBarNotification;
import android.service.notification.ZenModeConfig;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.Xml;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import com.android.internal.statusbar.NotificationVisibility;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.Preconditions;
import com.android.server.DeviceIdleController;
import com.android.server.EventLogTags;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.lights.Light;
import com.android.server.lights.LightsManager;
import com.android.server.notification.ConditionProviders;
import com.android.server.notification.ManagedServices;
import com.android.server.notification.NotificationDelegate;
import com.android.server.notification.NotificationManagerInternal;
import com.android.server.notification.NotificationRecord;
import com.android.server.notification.NotificationUsageStats;
import com.android.server.notification.RankingHandler;
import com.android.server.notification.RankingHelper;
import com.android.server.notification.RankingReconsideration;
import com.android.server.notification.ValidateNotificationPeople;
import com.android.server.notification.ZenLog;
import com.android.server.notification.ZenModeHelper;
import com.android.server.statusbar.StatusBarManagerInternal;
import com.android.server.vr.VrManagerInternal;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import libcore.io.IoUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class NotificationManagerService
extends SystemService {
    static final String TAG = "NotificationService";
    static final boolean DBG = Log.isLoggable("NotificationService", 3);
    public static final boolean ENABLE_CHILD_NOTIFICATIONS = SystemProperties.getBoolean("debug.child_notifs", true);
    static final int MAX_PACKAGE_NOTIFICATIONS = 50;
    static final float DEFAULT_MAX_NOTIFICATION_ENQUEUE_RATE = 10.0f;
    static final int MESSAGE_TIMEOUT = 2;
    static final int MESSAGE_SAVE_POLICY_FILE = 3;
    static final int MESSAGE_SEND_RANKING_UPDATE = 4;
    static final int MESSAGE_LISTENER_HINTS_CHANGED = 5;
    static final int MESSAGE_LISTENER_NOTIFICATION_FILTER_CHANGED = 6;
    private static final int MESSAGE_RECONSIDER_RANKING = 1000;
    private static final int MESSAGE_RANKING_SORT = 1001;
    static final int LONG_DELAY = 3500;
    static final int SHORT_DELAY = 2000;
    static final long[] DEFAULT_VIBRATE_PATTERN = new long[]{0L, 250L, 250L, 250L};
    static final int VIBRATE_PATTERN_MAXLEN = 17;
    static final int DEFAULT_STREAM_TYPE = 5;
    static final boolean ENABLE_BLOCKED_NOTIFICATIONS = true;
    static final boolean ENABLE_BLOCKED_TOASTS = true;
    static final int MATCHES_CALL_FILTER_CONTACTS_TIMEOUT_MS = 3000;
    static final float MATCHES_CALL_FILTER_TIMEOUT_AFFINITY = 1.0f;
    private static final int EVENTLOG_ENQUEUE_STATUS_NEW = 0;
    private static final int EVENTLOG_ENQUEUE_STATUS_UPDATE = 1;
    private static final int EVENTLOG_ENQUEUE_STATUS_IGNORED = 2;
    private static final long MIN_PACKAGE_OVERRATE_LOG_INTERVAL = 5000L;
    private String mRankerServicePackageName;
    private IActivityManager mAm;
    AudioManager mAudioManager;
    AudioManagerInternal mAudioManagerInternal;
    StatusBarManagerInternal mStatusBar;
    Vibrator mVibrator;
    private VrManagerInternal mVrManagerInternal;
    final IBinder mForegroundToken = new Binder();
    private Handler mHandler;
    private final HandlerThread mRankingThread = new HandlerThread("ranker", 10);
    private Light mNotificationLight;
    Light mAttentionLight;
    private int mDefaultNotificationColor;
    private int mDefaultNotificationLedOn;
    private int mDefaultNotificationLedOff;
    private long[] mDefaultVibrationPattern;
    private long[] mFallbackVibrationPattern;
    private boolean mUseAttentionLight;
    boolean mSystemReady;
    private boolean mDisableNotificationEffects;
    private int mCallState;
    private String mSoundNotificationKey;
    private String mVibrateNotificationKey;
    private final SparseArray<ArraySet<ManagedServices.ManagedServiceInfo>> mListenersDisablingEffects = new SparseArray();
    private List<ComponentName> mEffectsSuppressors = new ArrayList<ComponentName>();
    private int mListenerHints;
    private int mInterruptionFilter = 0;
    private boolean mScreenOn = true;
    private boolean mInCall = false;
    private boolean mNotificationPulseEnabled;
    final ArrayList<NotificationRecord> mNotificationList = new ArrayList();
    final ArrayMap<String, NotificationRecord> mNotificationsByKey = new ArrayMap();
    final ArrayMap<Integer, ArrayMap<String, String>> mAutobundledSummaries = new ArrayMap();
    final ArrayList<ToastRecord> mToastQueue = new ArrayList();
    final ArrayMap<String, NotificationRecord> mSummaryByGroupKey = new ArrayMap();
    final PolicyAccess mPolicyAccess = new PolicyAccess();
    ArrayList<String> mLights = new ArrayList();
    private AppOpsManager mAppOps;
    private UsageStatsManagerInternal mAppUsageStats;
    private Archive mArchive;
    private AtomicFile mPolicyFile;
    private static final int DB_VERSION = 1;
    private static final String TAG_NOTIFICATION_POLICY = "notification-policy";
    private static final String ATTR_VERSION = "version";
    private RankingHelper mRankingHelper;
    private final ManagedServices.UserProfiles mUserProfiles = new ManagedServices.UserProfiles();
    private NotificationListeners mListeners;
    private NotificationRankers mRankerServices;
    private ConditionProviders mConditionProviders;
    private NotificationUsageStats mUsageStats;
    private static final int MY_UID = Process.myUid();
    private static final int MY_PID = Process.myPid();
    private RankingHandler mRankingHandler;
    private long mLastOverRateLogTime;
    private float mMaxPackageEnqueueRate = 10.0f;
    private String mSystemNotificationSound;
    private final NotificationDelegate mNotificationDelegate = new NotificationDelegate(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSetDisabled(int status) {
            ArrayList<NotificationRecord> arrayList = NotificationManagerService.this.mNotificationList;
            synchronized (arrayList) {
                NotificationManagerService.this.mDisableNotificationEffects = (status & 0x40000) != 0;
                if (NotificationManagerService.this.disableNotificationEffects(null) != null) {
                    long identity = Binder.clearCallingIdentity();
                    try {
                        IRingtonePlayer player = NotificationManagerService.this.mAudioManager.getRingtonePlayer();
                        if (player != null) {
                            player.stopAsync();
                        }
                    }
                    catch (RemoteException remoteException) {
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                    identity = Binder.clearCallingIdentity();
                    try {
                        NotificationManagerService.this.mVibrator.cancel();
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onClearAll(int callingUid, int callingPid, int userId) {
            ArrayList<NotificationRecord> arrayList = NotificationManagerService.this.mNotificationList;
            synchronized (arrayList) {
                NotificationManagerService.this.cancelAllLocked(callingUid, callingPid, userId, 3, null, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNotificationClick(int callingUid, int callingPid, String key) {
            ArrayList<NotificationRecord> arrayList = NotificationManagerService.this.mNotificationList;
            synchronized (arrayList) {
                NotificationRecord r = NotificationManagerService.this.mNotificationsByKey.get(key);
                if (r == null) {
                    Log.w(NotificationManagerService.TAG, "No notification with key: " + key);
                    return;
                }
                long now = System.currentTimeMillis();
                EventLogTags.writeNotificationClicked(key, r.getLifespanMs(now), r.getFreshnessMs(now), r.getExposureMs(now));
                StatusBarNotification sbn = r.sbn;
                NotificationManagerService.this.cancelNotification(callingUid, callingPid, sbn.getPackageName(), sbn.getTag(), sbn.getId(), 16, 64, false, r.getUserId(), 1, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNotificationActionClick(int callingUid, int callingPid, String key, int actionIndex) {
            ArrayList<NotificationRecord> arrayList = NotificationManagerService.this.mNotificationList;
            synchronized (arrayList) {
                NotificationRecord r = NotificationManagerService.this.mNotificationsByKey.get(key);
                if (r == null) {
                    Log.w(NotificationManagerService.TAG, "No notification with key: " + key);
                    return;
                }
                long now = System.currentTimeMillis();
                EventLogTags.writeNotificationActionClicked(key, actionIndex, r.getLifespanMs(now), r.getFreshnessMs(now), r.getExposureMs(now));
            }
        }

        @Override
        public void onNotificationClear(int callingUid, int callingPid, String pkg, String tag, int id2, int userId) {
            NotificationManagerService.this.cancelNotification(callingUid, callingPid, pkg, tag, id2, 0, 66, true, userId, 2, null);
        }

        @Override
        public void onPanelRevealed(boolean clearEffects, int items) {
            EventLogTags.writeNotificationPanelRevealed(items);
            if (clearEffects) {
                this.clearEffects();
            }
        }

        @Override
        public void onPanelHidden() {
            EventLogTags.writeNotificationPanelHidden();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearEffects() {
            ArrayList<NotificationRecord> arrayList = NotificationManagerService.this.mNotificationList;
            synchronized (arrayList) {
                if (DBG) {
                    Slog.d(NotificationManagerService.TAG, "clearEffects");
                }
                NotificationManagerService.this.clearSoundLocked();
                NotificationManagerService.this.clearVibrateLocked();
                NotificationManagerService.this.clearLightsLocked();
            }
        }

        @Override
        public void onNotificationError(int callingUid, int callingPid, String pkg, String tag, int id2, int uid, int initialPid, String message, int userId) {
            Slog.d(NotificationManagerService.TAG, "onNotification error pkg=" + pkg + " tag=" + tag + " id=" + id2 + "; will crashApplication(uid=" + uid + ", pid=" + initialPid + ")");
            NotificationManagerService.this.cancelNotification(callingUid, callingPid, pkg, tag, id2, 0, 0, false, userId, 4, null);
            long ident = Binder.clearCallingIdentity();
            try {
                ActivityManagerNative.getDefault().crashApplication(uid, initialPid, pkg, "Bad notification posted from package " + pkg + ": " + message);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            Binder.restoreCallingIdentity(ident);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNotificationVisibilityChanged(NotificationVisibility[] newlyVisibleKeys, NotificationVisibility[] noLongerVisibleKeys) {
            ArrayList<NotificationRecord> arrayList = NotificationManagerService.this.mNotificationList;
            synchronized (arrayList) {
                NotificationRecord r;
                for (NotificationVisibility nv : newlyVisibleKeys) {
                    r = NotificationManagerService.this.mNotificationsByKey.get(nv.key);
                    if (r == null) continue;
                    r.setVisibility(true, nv.rank);
                    nv.recycle();
                }
                for (NotificationVisibility nv : noLongerVisibleKeys) {
                    r = NotificationManagerService.this.mNotificationsByKey.get(nv.key);
                    if (r == null) continue;
                    r.setVisibility(false, nv.rank);
                    nv.recycle();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNotificationExpansionChanged(String key, boolean userAction, boolean expanded) {
            ArrayList<NotificationRecord> arrayList = NotificationManagerService.this.mNotificationList;
            synchronized (arrayList) {
                NotificationRecord r = NotificationManagerService.this.mNotificationsByKey.get(key);
                if (r != null) {
                    r.stats.onExpansionChanged(userAction, expanded);
                    long now = System.currentTimeMillis();
                    EventLogTags.writeNotificationExpansion(key, userAction ? 1 : 0, expanded ? 1 : 0, r.getLifespanMs(now), r.getFreshnessMs(now), r.getExposureMs(now));
                }
            }
        }
    };
    private final BroadcastReceiver mPackageIntentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action == null) {
                return;
            }
            boolean queryRestart = false;
            boolean queryRemove = false;
            boolean packageChanged = false;
            boolean cancelNotifications = true;
            int reason = 5;
            if (action.equals("android.intent.action.PACKAGE_ADDED") || (queryRemove = action.equals("android.intent.action.PACKAGE_REMOVED")) || action.equals("android.intent.action.PACKAGE_RESTARTED") || (packageChanged = action.equals("android.intent.action.PACKAGE_CHANGED")) || (queryRestart = action.equals("android.intent.action.QUERY_PACKAGE_RESTART")) || action.equals("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE") || action.equals("android.intent.action.PACKAGES_SUSPENDED")) {
                boolean removingPackage;
                int changeUserId = intent.getIntExtra("android.intent.extra.user_handle", -1);
                String[] pkgList = null;
                boolean bl = removingPackage = queryRemove && !intent.getBooleanExtra("android.intent.extra.REPLACING", false);
                if (DBG) {
                    Slog.i(NotificationManagerService.TAG, "action=" + action + " removing=" + removingPackage);
                }
                if (action.equals("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE")) {
                    pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                } else if (action.equals("android.intent.action.PACKAGES_SUSPENDED")) {
                    pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                    reason = 14;
                } else if (queryRestart) {
                    pkgList = intent.getStringArrayExtra("android.intent.extra.PACKAGES");
                } else {
                    Uri uri = intent.getData();
                    if (uri == null) {
                        return;
                    }
                    String pkgName = uri.getSchemeSpecificPart();
                    if (pkgName == null) {
                        return;
                    }
                    if (packageChanged) {
                        try {
                            IPackageManager pm = AppGlobals.getPackageManager();
                            int enabled = pm.getApplicationEnabledSetting(pkgName, changeUserId != -1 ? changeUserId : 0);
                            if (enabled == 1 || enabled == 0) {
                                cancelNotifications = false;
                            }
                        }
                        catch (IllegalArgumentException e) {
                            if (DBG) {
                                Slog.i(NotificationManagerService.TAG, "Exception trying to look up app enabled setting", e);
                            }
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    pkgList = new String[]{pkgName};
                }
                if (pkgList != null && pkgList.length > 0) {
                    for (String pkgName : pkgList) {
                        if (!cancelNotifications) continue;
                        NotificationManagerService.this.cancelAllNotificationsInt(MY_UID, MY_PID, pkgName, 0, 0, !queryRestart, changeUserId, reason, null);
                    }
                }
                NotificationManagerService.this.mListeners.onPackagesChanged(removingPackage, pkgList);
                NotificationManagerService.this.mRankerServices.onPackagesChanged(removingPackage, pkgList);
                NotificationManagerService.this.mConditionProviders.onPackagesChanged(removingPackage, pkgList);
                NotificationManagerService.this.mRankingHelper.onPackagesChanged(removingPackage, pkgList);
            }
        }
    };
    private final BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.intent.action.SCREEN_ON")) {
                NotificationManagerService.this.mScreenOn = true;
                NotificationManagerService.this.updateNotificationPulse();
            } else if (action.equals("android.intent.action.SCREEN_OFF")) {
                NotificationManagerService.this.mScreenOn = false;
                NotificationManagerService.this.updateNotificationPulse();
            } else if (action.equals("android.intent.action.PHONE_STATE")) {
                NotificationManagerService.this.mInCall = TelephonyManager.EXTRA_STATE_OFFHOOK.equals(intent.getStringExtra("state"));
                NotificationManagerService.this.updateNotificationPulse();
            } else if (action.equals("android.intent.action.USER_STOPPED")) {
                int userHandle = intent.getIntExtra("android.intent.extra.user_handle", -1);
                if (userHandle >= 0) {
                    NotificationManagerService.this.cancelAllNotificationsInt(MY_UID, MY_PID, null, 0, 0, true, userHandle, 6, null);
                }
            } else if (action.equals("android.intent.action.MANAGED_PROFILE_UNAVAILABLE")) {
                int userHandle = intent.getIntExtra("android.intent.extra.user_handle", -1);
                if (userHandle >= 0) {
                    NotificationManagerService.this.cancelAllNotificationsInt(MY_UID, MY_PID, null, 0, 0, true, userHandle, 15, null);
                }
            } else if (action.equals("android.intent.action.USER_PRESENT")) {
                NotificationManagerService.this.mNotificationLight.turnOff();
                if (NotificationManagerService.this.mStatusBar != null) {
                    NotificationManagerService.this.mStatusBar.notificationLightOff();
                }
            } else if (action.equals("android.intent.action.USER_SWITCHED")) {
                int user = intent.getIntExtra("android.intent.extra.user_handle", -10000);
                NotificationManagerService.this.mSettingsObserver.update(null);
                NotificationManagerService.this.mUserProfiles.updateCache(context);
                NotificationManagerService.this.mConditionProviders.onUserSwitched(user);
                NotificationManagerService.this.mListeners.onUserSwitched(user);
                NotificationManagerService.this.mRankerServices.onUserSwitched(user);
                NotificationManagerService.this.mZenModeHelper.onUserSwitched(user);
            } else if (action.equals("android.intent.action.USER_ADDED")) {
                NotificationManagerService.this.mUserProfiles.updateCache(context);
            } else if (action.equals("android.intent.action.USER_REMOVED")) {
                int user = intent.getIntExtra("android.intent.extra.user_handle", -10000);
                NotificationManagerService.this.mZenModeHelper.onUserRemoved(user);
            } else if (action.equals("android.intent.action.USER_UNLOCKED")) {
                int user = intent.getIntExtra("android.intent.extra.user_handle", -10000);
                NotificationManagerService.this.mConditionProviders.onUserUnlocked(user);
                NotificationManagerService.this.mListeners.onUserUnlocked(user);
                NotificationManagerService.this.mRankerServices.onUserUnlocked(user);
                NotificationManagerService.this.mZenModeHelper.onUserUnlocked(user);
            }
        }
    };
    private SettingsObserver mSettingsObserver;
    private ZenModeHelper mZenModeHelper;
    private final Runnable mBuzzBeepBlinked = new Runnable(){

        @Override
        public void run() {
            if (NotificationManagerService.this.mStatusBar != null) {
                NotificationManagerService.this.mStatusBar.buzzBeepBlinked();
            }
        }
    };
    private final IBinder mService = new INotificationManager.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enqueueToast(String pkg, ITransientNotification callback, int duration) {
            if (DBG) {
                Slog.i(NotificationManagerService.TAG, "enqueueToast pkg=" + pkg + " callback=" + callback + " duration=" + duration);
            }
            if (pkg == null || callback == null) {
                Slog.e(NotificationManagerService.TAG, "Not doing toast. pkg=" + pkg + " callback=" + callback);
                return;
            }
            boolean isSystemToast = NotificationManagerService.isCallerSystem() || "android".equals(pkg);
            boolean isPackageSuspended = NotificationManagerService.this.isPackageSuspendedForUser(pkg, Binder.getCallingUid());
            if (!(NotificationManagerService.this.noteNotificationOp(pkg, Binder.getCallingUid()) && !isPackageSuspended || isSystemToast)) {
                Slog.e(NotificationManagerService.TAG, "Suppressing toast from package " + pkg + (isPackageSuspended ? " due to package suspended by administrator." : " by user request."));
                return;
            }
            ArrayList<ToastRecord> arrayList = NotificationManagerService.this.mToastQueue;
            synchronized (arrayList) {
                int callingPid = Binder.getCallingPid();
                long callingId = Binder.clearCallingIdentity();
                try {
                    int index = NotificationManagerService.this.indexOfToastLocked(pkg, callback);
                    if (index >= 0) {
                        ToastRecord record = NotificationManagerService.this.mToastQueue.get(index);
                        record.update(duration);
                    } else {
                        if (!isSystemToast) {
                            int count = 0;
                            int N = NotificationManagerService.this.mToastQueue.size();
                            for (int i = 0; i < N; ++i) {
                                ToastRecord r = NotificationManagerService.this.mToastQueue.get(i);
                                if (!r.pkg.equals(pkg) || ++count < 50) continue;
                                Slog.e(NotificationManagerService.TAG, "Package has already posted " + count + " toasts. Not showing more. Package=" + pkg);
                                return;
                            }
                        }
                        ToastRecord record = new ToastRecord(callingPid, pkg, callback, duration);
                        NotificationManagerService.this.mToastQueue.add(record);
                        index = NotificationManagerService.this.mToastQueue.size() - 1;
                        NotificationManagerService.this.keepProcessAliveLocked(callingPid);
                    }
                    if (index == 0) {
                        NotificationManagerService.this.showNextToastLocked();
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(callingId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelToast(String pkg, ITransientNotification callback) {
            Slog.i(NotificationManagerService.TAG, "cancelToast pkg=" + pkg + " callback=" + callback);
            if (pkg == null || callback == null) {
                Slog.e(NotificationManagerService.TAG, "Not cancelling notification. pkg=" + pkg + " callback=" + callback);
                return;
            }
            ArrayList<ToastRecord> arrayList = NotificationManagerService.this.mToastQueue;
            synchronized (arrayList) {
                long callingId = Binder.clearCallingIdentity();
                try {
                    int index = NotificationManagerService.this.indexOfToastLocked(pkg, callback);
                    if (index >= 0) {
                        NotificationManagerService.this.cancelToastLocked(index);
                    } else {
                        Slog.w(NotificationManagerService.TAG, "Toast already cancelled. pkg=" + pkg + " callback=" + callback);
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(callingId);
                }
            }
        }

        @Override
        public void enqueueNotificationWithTag(String pkg, String opPkg, String tag, int id2, Notification notification, int[] idOut, int userId) throws RemoteException {
            NotificationManagerService.this.enqueueNotificationInternal(pkg, opPkg, Binder.getCallingUid(), Binder.getCallingPid(), tag, id2, notification, idOut, userId);
        }

        @Override
        public void cancelNotificationWithTag(String pkg, String tag, int id2, int userId) {
            NotificationManagerService.checkCallerIsSystemOrSameApp(pkg);
            userId = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, true, false, "cancelNotificationWithTag", pkg);
            NotificationManagerService.this.cancelNotification(Binder.getCallingUid(), Binder.getCallingPid(), pkg, tag, id2, 0, (Binder.getCallingUid() == 1000 ? 0 : 64) | (Binder.getCallingUid() == 1000 ? 0 : 1024), false, userId, 8, null);
        }

        @Override
        public void cancelAllNotifications(String pkg, int userId) {
            NotificationManagerService.checkCallerIsSystemOrSameApp(pkg);
            userId = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, true, false, "cancelAllNotifications", pkg);
            NotificationManagerService.this.cancelAllNotificationsInt(Binder.getCallingUid(), Binder.getCallingPid(), pkg, 0, 64, true, userId, 9, null);
        }

        @Override
        public void setNotificationsEnabledForPackage(String pkg, int uid, boolean enabled) {
            NotificationManagerService.checkCallerIsSystem();
            NotificationManagerService.this.setNotificationsEnabledForPackageImpl(pkg, uid, enabled);
            NotificationManagerService.this.mRankingHelper.setEnabled(pkg, uid, enabled);
            NotificationManagerService.this.savePolicyFile();
        }

        @Override
        public boolean areNotificationsEnabled(String pkg) {
            return this.areNotificationsEnabledForPackage(pkg, Binder.getCallingUid());
        }

        @Override
        public boolean areNotificationsEnabledForPackage(String pkg, int uid) {
            NotificationManagerService.checkCallerIsSystemOrSameApp(pkg);
            return NotificationManagerService.this.mAppOps.checkOpNoThrow(11, uid, pkg) == 0 && !NotificationManagerService.this.isPackageSuspendedForUser(pkg, uid);
        }

        @Override
        public void setPriority(String pkg, int uid, int priority) {
            NotificationManagerService.checkCallerIsSystem();
            NotificationManagerService.this.mRankingHelper.setPriority(pkg, uid, priority);
            NotificationManagerService.this.savePolicyFile();
        }

        @Override
        public int getPriority(String pkg, int uid) {
            NotificationManagerService.checkCallerIsSystem();
            return NotificationManagerService.this.mRankingHelper.getPriority(pkg, uid);
        }

        @Override
        public void setVisibilityOverride(String pkg, int uid, int visibility) {
            NotificationManagerService.checkCallerIsSystem();
            NotificationManagerService.this.mRankingHelper.setVisibilityOverride(pkg, uid, visibility);
            NotificationManagerService.this.savePolicyFile();
        }

        @Override
        public int getVisibilityOverride(String pkg, int uid) {
            NotificationManagerService.checkCallerIsSystem();
            return NotificationManagerService.this.mRankingHelper.getVisibilityOverride(pkg, uid);
        }

        @Override
        public void setImportance(String pkg, int uid, int importance) {
            this.enforceSystemOrSystemUI("Caller not system or systemui");
            NotificationManagerService.this.setNotificationsEnabledForPackageImpl(pkg, uid, importance != 0);
            NotificationManagerService.this.mRankingHelper.setImportance(pkg, uid, importance);
            NotificationManagerService.this.savePolicyFile();
        }

        @Override
        public int getPackageImportance(String pkg) {
            NotificationManagerService.checkCallerIsSystemOrSameApp(pkg);
            return NotificationManagerService.this.mRankingHelper.getImportance(pkg, Binder.getCallingUid());
        }

        @Override
        public int getImportance(String pkg, int uid) {
            this.enforceSystemOrSystemUI("Caller not system or systemui");
            return NotificationManagerService.this.mRankingHelper.getImportance(pkg, uid);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StatusBarNotification[] getActiveNotifications(String callingPkg) {
            NotificationManagerService.this.getContext().enforceCallingOrSelfPermission("android.permission.ACCESS_NOTIFICATIONS", "NotificationManagerService.getActiveNotifications");
            StatusBarNotification[] tmp = null;
            int uid = Binder.getCallingUid();
            if (NotificationManagerService.this.mAppOps.noteOpNoThrow(25, uid, callingPkg) == 0) {
                ArrayList<NotificationRecord> arrayList = NotificationManagerService.this.mNotificationList;
                synchronized (arrayList) {
                    tmp = new StatusBarNotification[NotificationManagerService.this.mNotificationList.size()];
                    int N = NotificationManagerService.this.mNotificationList.size();
                    for (int i = 0; i < N; ++i) {
                        tmp[i] = NotificationManagerService.this.mNotificationList.get((int)i).sbn;
                    }
                }
            }
            return tmp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParceledListSlice<StatusBarNotification> getAppActiveNotifications(String pkg, int incomingUserId) {
            NotificationManagerService.checkCallerIsSystemOrSameApp(pkg);
            int userId = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), incomingUserId, true, false, "getAppActiveNotifications", pkg);
            ArrayList<StatusBarNotification> list = new ArrayList<StatusBarNotification>(NotificationManagerService.this.mNotificationList.size());
            ArrayList<NotificationRecord> arrayList = NotificationManagerService.this.mNotificationList;
            synchronized (arrayList) {
                int N = NotificationManagerService.this.mNotificationList.size();
                for (int i = 0; i < N; ++i) {
                    StatusBarNotification sbn = NotificationManagerService.this.mNotificationList.get((int)i).sbn;
                    if (!sbn.getPackageName().equals(pkg) || sbn.getUserId() != userId || (sbn.getNotification().flags & 0x400) != 0) continue;
                    StatusBarNotification sbnOut = new StatusBarNotification(sbn.getPackageName(), sbn.getOpPkg(), sbn.getId(), sbn.getTag(), sbn.getUid(), sbn.getInitialPid(), 0, sbn.getNotification().clone(), sbn.getUser(), sbn.getPostTime());
                    list.add(sbnOut);
                }
            }
            return new ParceledListSlice<StatusBarNotification>(list);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StatusBarNotification[] getHistoricalNotifications(String callingPkg, int count) {
            NotificationManagerService.this.getContext().enforceCallingOrSelfPermission("android.permission.ACCESS_NOTIFICATIONS", "NotificationManagerService.getHistoricalNotifications");
            StatusBarNotification[] tmp = null;
            int uid = Binder.getCallingUid();
            if (NotificationManagerService.this.mAppOps.noteOpNoThrow(25, uid, callingPkg) == 0) {
                Archive archive = NotificationManagerService.this.mArchive;
                synchronized (archive) {
                    tmp = NotificationManagerService.this.mArchive.getArray(count);
                }
            }
            return tmp;
        }

        @Override
        public void registerListener(INotificationListener listener, ComponentName component, int userid) {
            this.enforceSystemOrSystemUI("INotificationManager.registerListener");
            NotificationManagerService.this.mListeners.registerService(listener, component, userid);
        }

        @Override
        public void unregisterListener(INotificationListener token, int userid) {
            NotificationManagerService.this.mListeners.unregisterService(token, userid);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelNotificationsFromListener(INotificationListener token, String[] keys) {
            int callingUid = Binder.getCallingUid();
            int callingPid = Binder.getCallingPid();
            long identity = Binder.clearCallingIdentity();
            try {
                ArrayList<NotificationRecord> arrayList = NotificationManagerService.this.mNotificationList;
                synchronized (arrayList) {
                    ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
                    if (keys != null) {
                        int N = keys.length;
                        for (int i = 0; i < N; ++i) {
                            NotificationRecord r = NotificationManagerService.this.mNotificationsByKey.get(keys[i]);
                            if (r == null) continue;
                            int userId = r.sbn.getUserId();
                            if (userId != info.userid && userId != -1 && !NotificationManagerService.this.mUserProfiles.isCurrentProfile(userId)) {
                                throw new SecurityException("Disallowed call from listener: " + info.service);
                            }
                            this.cancelNotificationFromListenerLocked(info, callingUid, callingPid, r.sbn.getPackageName(), r.sbn.getTag(), r.sbn.getId(), userId);
                        }
                    } else {
                        NotificationManagerService.this.cancelAllLocked(callingUid, callingPid, info.userid, 11, info, info.supportsProfiles());
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void requestBindListener(ComponentName component) {
            NotificationManagerService.checkCallerIsSystemOrSameApp(component.getPackageName());
            long identity = Binder.clearCallingIdentity();
            try {
                ManagedServices manager = NotificationManagerService.this.mRankerServices.isComponentEnabledForCurrentProfiles(component) ? NotificationManagerService.this.mRankerServices : NotificationManagerService.this.mListeners;
                manager.setComponentState(component, true);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void requestUnbindListener(INotificationListener token) {
            long identity = Binder.clearCallingIdentity();
            try {
                ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
                info.getOwner().setComponentState(info.component, false);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setNotificationsShownFromListener(INotificationListener token, String[] keys) {
            long identity = Binder.clearCallingIdentity();
            try {
                ArrayList<NotificationRecord> arrayList = NotificationManagerService.this.mNotificationList;
                synchronized (arrayList) {
                    ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
                    if (keys != null) {
                        int N = keys.length;
                        for (int i = 0; i < N; ++i) {
                            NotificationRecord r = NotificationManagerService.this.mNotificationsByKey.get(keys[i]);
                            if (r == null) continue;
                            int userId = r.sbn.getUserId();
                            if (userId != info.userid && userId != -1 && !NotificationManagerService.this.mUserProfiles.isCurrentProfile(userId)) {
                                throw new SecurityException("Disallowed call from listener: " + info.service);
                            }
                            if (r.isSeen()) continue;
                            if (DBG) {
                                Slog.d(NotificationManagerService.TAG, "Marking notification as seen " + keys[i]);
                            }
                            NotificationManagerService.this.mAppUsageStats.reportEvent(r.sbn.getPackageName(), userId == -1 ? 0 : userId, 7);
                            r.setSeen();
                        }
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        private void cancelNotificationFromListenerLocked(ManagedServices.ManagedServiceInfo info, int callingUid, int callingPid, String pkg, String tag, int id2, int userId) {
            NotificationManagerService.this.cancelNotification(callingUid, callingPid, pkg, tag, id2, 0, 66, true, userId, 10, info);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelNotificationFromListener(INotificationListener token, String pkg, String tag, int id2) {
            int callingUid = Binder.getCallingUid();
            int callingPid = Binder.getCallingPid();
            long identity = Binder.clearCallingIdentity();
            try {
                ArrayList<NotificationRecord> arrayList = NotificationManagerService.this.mNotificationList;
                synchronized (arrayList) {
                    ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
                    if (info.supportsProfiles()) {
                        Log.e(NotificationManagerService.TAG, "Ignoring deprecated cancelNotification(pkg, tag, id) from " + info.component + " use cancelNotification(key) instead.");
                    } else {
                        this.cancelNotificationFromListenerLocked(info, callingUid, callingPid, pkg, tag, id2, info.userid);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParceledListSlice<StatusBarNotification> getActiveNotificationsFromListener(INotificationListener token, String[] keys, int trim) {
            ArrayList<NotificationRecord> arrayList = NotificationManagerService.this.mNotificationList;
            synchronized (arrayList) {
                ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
                boolean getKeys = keys != null;
                int N = getKeys ? keys.length : NotificationManagerService.this.mNotificationList.size();
                ArrayList<StatusBarNotification> list = new ArrayList<StatusBarNotification>(N);
                for (int i = 0; i < N; ++i) {
                    StatusBarNotification sbn;
                    NotificationRecord r;
                    NotificationRecord notificationRecord = r = getKeys ? NotificationManagerService.this.mNotificationsByKey.get(keys[i]) : NotificationManagerService.this.mNotificationList.get(i);
                    if (r == null || !NotificationManagerService.this.isVisibleToListener(sbn = r.sbn, info)) continue;
                    StatusBarNotification sbnToSend = trim == 0 ? sbn : sbn.cloneLight();
                    list.add(sbnToSend);
                }
                return new ParceledListSlice<StatusBarNotification>(list);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void requestHintsFromListener(INotificationListener token, int hints) {
            long identity = Binder.clearCallingIdentity();
            try {
                ArrayList<NotificationRecord> arrayList = NotificationManagerService.this.mNotificationList;
                synchronized (arrayList) {
                    boolean disableEffects;
                    ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
                    int disableEffectsMask = 7;
                    boolean bl = disableEffects = (hints & 7) != 0;
                    if (disableEffects) {
                        NotificationManagerService.this.addDisabledHints(info, hints);
                    } else {
                        NotificationManagerService.this.removeDisabledHints(info, hints);
                    }
                    NotificationManagerService.this.updateListenerHintsLocked();
                    NotificationManagerService.this.updateEffectsSuppressorLocked();
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getHintsFromListener(INotificationListener token) {
            ArrayList<NotificationRecord> arrayList = NotificationManagerService.this.mNotificationList;
            synchronized (arrayList) {
                return NotificationManagerService.this.mListenerHints;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void requestInterruptionFilterFromListener(INotificationListener token, int interruptionFilter) throws RemoteException {
            long identity = Binder.clearCallingIdentity();
            try {
                ArrayList<NotificationRecord> arrayList = NotificationManagerService.this.mNotificationList;
                synchronized (arrayList) {
                    ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
                    NotificationManagerService.this.mZenModeHelper.requestFromListener(info.component, interruptionFilter);
                    NotificationManagerService.this.updateInterruptionFilterLocked();
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getInterruptionFilterFromListener(INotificationListener token) throws RemoteException {
            Light light = NotificationManagerService.this.mNotificationLight;
            synchronized (light) {
                return NotificationManagerService.this.mInterruptionFilter;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setOnNotificationPostedTrimFromListener(INotificationListener token, int trim) throws RemoteException {
            ArrayList<NotificationRecord> arrayList = NotificationManagerService.this.mNotificationList;
            synchronized (arrayList) {
                ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
                if (info == null) {
                    return;
                }
                NotificationManagerService.this.mListeners.setOnNotificationPostedTrimLocked(info, trim);
            }
        }

        @Override
        public int getZenMode() {
            return NotificationManagerService.this.mZenModeHelper.getZenMode();
        }

        @Override
        public ZenModeConfig getZenModeConfig() {
            this.enforceSystemOrSystemUIOrVolume("INotificationManager.getZenModeConfig");
            return NotificationManagerService.this.mZenModeHelper.getConfig();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setZenMode(int mode, Uri conditionId, String reason) throws RemoteException {
            this.enforceSystemOrSystemUIOrVolume("INotificationManager.setZenMode");
            long identity = Binder.clearCallingIdentity();
            try {
                NotificationManagerService.this.mZenModeHelper.setManualZenMode(mode, conditionId, null, reason);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        @Override
        public List<ZenModeConfig.ZenRule> getZenRules() throws RemoteException {
            this.enforcePolicyAccess(Binder.getCallingUid(), "getAutomaticZenRules");
            return NotificationManagerService.this.mZenModeHelper.getZenRules();
        }

        @Override
        public AutomaticZenRule getAutomaticZenRule(String id2) throws RemoteException {
            Preconditions.checkNotNull(id2, "Id is null");
            this.enforcePolicyAccess(Binder.getCallingUid(), "getAutomaticZenRule");
            return NotificationManagerService.this.mZenModeHelper.getAutomaticZenRule(id2);
        }

        @Override
        public String addAutomaticZenRule(AutomaticZenRule automaticZenRule) throws RemoteException {
            Preconditions.checkNotNull(automaticZenRule, "automaticZenRule is null");
            Preconditions.checkNotNull(automaticZenRule.getName(), "Name is null");
            Preconditions.checkNotNull(automaticZenRule.getOwner(), "Owner is null");
            Preconditions.checkNotNull(automaticZenRule.getConditionId(), "ConditionId is null");
            this.enforcePolicyAccess(Binder.getCallingUid(), "addAutomaticZenRule");
            return NotificationManagerService.this.mZenModeHelper.addAutomaticZenRule(automaticZenRule, "addAutomaticZenRule");
        }

        @Override
        public boolean updateAutomaticZenRule(String id2, AutomaticZenRule automaticZenRule) throws RemoteException {
            Preconditions.checkNotNull(automaticZenRule, "automaticZenRule is null");
            Preconditions.checkNotNull(automaticZenRule.getName(), "Name is null");
            Preconditions.checkNotNull(automaticZenRule.getOwner(), "Owner is null");
            Preconditions.checkNotNull(automaticZenRule.getConditionId(), "ConditionId is null");
            this.enforcePolicyAccess(Binder.getCallingUid(), "updateAutomaticZenRule");
            return NotificationManagerService.this.mZenModeHelper.updateAutomaticZenRule(id2, automaticZenRule, "updateAutomaticZenRule");
        }

        @Override
        public boolean removeAutomaticZenRule(String id2) throws RemoteException {
            Preconditions.checkNotNull(id2, "Id is null");
            this.enforcePolicyAccess(Binder.getCallingUid(), "removeAutomaticZenRule");
            return NotificationManagerService.this.mZenModeHelper.removeAutomaticZenRule(id2, "removeAutomaticZenRule");
        }

        @Override
        public boolean removeAutomaticZenRules(String packageName) throws RemoteException {
            Preconditions.checkNotNull(packageName, "Package name is null");
            this.enforceSystemOrSystemUI("removeAutomaticZenRules");
            return NotificationManagerService.this.mZenModeHelper.removeAutomaticZenRules(packageName, "removeAutomaticZenRules");
        }

        @Override
        public int getRuleInstanceCount(ComponentName owner) throws RemoteException {
            Preconditions.checkNotNull(owner, "Owner is null");
            this.enforceSystemOrSystemUI("getRuleInstanceCount");
            return NotificationManagerService.this.mZenModeHelper.getCurrentInstanceCount(owner);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setInterruptionFilter(String pkg, int filter) throws RemoteException {
            this.enforcePolicyAccess(pkg, "setInterruptionFilter");
            int zen = NotificationManager.zenModeFromInterruptionFilter(filter, -1);
            if (zen == -1) {
                throw new IllegalArgumentException("Invalid filter: " + filter);
            }
            long identity = Binder.clearCallingIdentity();
            try {
                NotificationManagerService.this.mZenModeHelper.setManualZenMode(zen, null, pkg, "setInterruptionFilter");
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        @Override
        public void notifyConditions(final String pkg, IConditionProvider provider, final Condition[] conditions) {
            final ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mConditionProviders.checkServiceToken(provider);
            NotificationManagerService.checkCallerIsSystemOrSameApp(pkg);
            NotificationManagerService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    NotificationManagerService.this.mConditionProviders.notifyConditions(pkg, info, conditions);
                }
            });
        }

        private void enforceSystemOrSystemUIOrVolume(String message) {
            int vcuid;
            if (NotificationManagerService.this.mAudioManagerInternal != null && (vcuid = NotificationManagerService.this.mAudioManagerInternal.getVolumeControllerUid()) > 0 && Binder.getCallingUid() == vcuid) {
                return;
            }
            this.enforceSystemOrSystemUI(message);
        }

        private void enforceSystemOrSystemUI(String message) {
            if (NotificationManagerService.isCallerSystem()) {
                return;
            }
            NotificationManagerService.this.getContext().enforceCallingPermission("android.permission.STATUS_BAR_SERVICE", message);
        }

        private void enforceSystemOrSystemUIOrSamePackage(String pkg, String message) {
            try {
                NotificationManagerService.checkCallerIsSystemOrSameApp(pkg);
            }
            catch (SecurityException e) {
                NotificationManagerService.this.getContext().enforceCallingPermission("android.permission.STATUS_BAR_SERVICE", message);
            }
        }

        private void enforcePolicyAccess(int uid, String method) {
            if (0 == NotificationManagerService.this.getContext().checkCallingPermission("android.permission.MANAGE_NOTIFICATIONS")) {
                return;
            }
            boolean accessAllowed = false;
            String[] packages = NotificationManagerService.this.getContext().getPackageManager().getPackagesForUid(uid);
            int packageCount = packages.length;
            for (int i = 0; i < packageCount; ++i) {
                if (!this.checkPolicyAccess(packages[i])) continue;
                accessAllowed = true;
            }
            if (!accessAllowed) {
                Slog.w(NotificationManagerService.TAG, "Notification policy access denied calling " + method);
                throw new SecurityException("Notification policy access denied");
            }
        }

        private void enforcePolicyAccess(String pkg, String method) {
            if (0 == NotificationManagerService.this.getContext().checkCallingPermission("android.permission.MANAGE_NOTIFICATIONS")) {
                return;
            }
            NotificationManagerService.checkCallerIsSameApp(pkg);
            if (!this.checkPolicyAccess(pkg)) {
                Slog.w(NotificationManagerService.TAG, "Notification policy access denied calling " + method);
                throw new SecurityException("Notification policy access denied");
            }
        }

        private boolean checkPackagePolicyAccess(String pkg) {
            return NotificationManagerService.this.mPolicyAccess.isPackageGranted(pkg);
        }

        private boolean checkPolicyAccess(String pkg) {
            try {
                int uid = NotificationManagerService.this.getContext().getPackageManager().getPackageUidAsUser(pkg, UserHandle.getCallingUserId());
                if (0 == ActivityManager.checkComponentPermission("android.permission.MANAGE_NOTIFICATIONS", uid, -1, true)) {
                    return true;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                return false;
            }
            return this.checkPackagePolicyAccess(pkg) || NotificationManagerService.this.mListeners.isComponentEnabledForPackage(pkg);
        }

        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (NotificationManagerService.this.getContext().checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
                pw.println("Permission Denial: can't dump NotificationManager from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
                return;
            }
            DumpFilter filter = DumpFilter.parseFromArguments(args);
            if (filter != null && filter.stats) {
                NotificationManagerService.this.dumpJson(pw, filter);
            } else {
                NotificationManagerService.this.dumpImpl(pw, filter);
            }
        }

        @Override
        public ComponentName getEffectsSuppressor() {
            this.enforceSystemOrSystemUIOrVolume("INotificationManager.getEffectsSuppressor");
            return !NotificationManagerService.this.mEffectsSuppressors.isEmpty() ? (ComponentName)NotificationManagerService.this.mEffectsSuppressors.get(0) : null;
        }

        @Override
        public boolean matchesCallFilter(Bundle extras) {
            this.enforceSystemOrSystemUI("INotificationManager.matchesCallFilter");
            return NotificationManagerService.this.mZenModeHelper.matchesCallFilter(Binder.getCallingUserHandle(), extras, NotificationManagerService.this.mRankingHelper.findExtractor(ValidateNotificationPeople.class), 3000, 1.0f);
        }

        @Override
        public boolean isSystemConditionProviderEnabled(String path) {
            this.enforceSystemOrSystemUIOrVolume("INotificationManager.isSystemConditionProviderEnabled");
            return NotificationManagerService.this.mConditionProviders.isSystemProviderEnabled(path);
        }

        @Override
        public byte[] getBackupPayload(int user) {
            if (DBG) {
                Slog.d(NotificationManagerService.TAG, "getBackupPayload u=" + user);
            }
            if (user != 0) {
                Slog.w(NotificationManagerService.TAG, "getBackupPayload: cannot backup policy for user " + user);
                return null;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                NotificationManagerService.this.writePolicyXml(baos, true);
                return baos.toByteArray();
            }
            catch (IOException e) {
                Slog.w(NotificationManagerService.TAG, "getBackupPayload: error writing payload for user " + user, e);
                return null;
            }
        }

        @Override
        public void applyRestore(byte[] payload, int user) {
            if (DBG) {
                Slog.d(NotificationManagerService.TAG, "applyRestore u=" + user + " payload=" + (payload != null ? new String(payload, StandardCharsets.UTF_8) : null));
            }
            if (payload == null) {
                Slog.w(NotificationManagerService.TAG, "applyRestore: no payload to restore for user " + user);
                return;
            }
            if (user != 0) {
                Slog.w(NotificationManagerService.TAG, "applyRestore: cannot restore policy for user " + user);
                return;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(payload);
            try {
                NotificationManagerService.this.readPolicyXml(bais, true);
                NotificationManagerService.this.savePolicyFile();
            }
            catch (IOException | NumberFormatException | XmlPullParserException e) {
                Slog.w(NotificationManagerService.TAG, "applyRestore: error reading payload", e);
            }
        }

        @Override
        public boolean isNotificationPolicyAccessGranted(String pkg) {
            return this.checkPolicyAccess(pkg);
        }

        @Override
        public boolean isNotificationPolicyAccessGrantedForPackage(String pkg) {
            this.enforceSystemOrSystemUIOrSamePackage(pkg, "request policy access status for another package");
            return this.checkPolicyAccess(pkg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String[] getPackagesRequestingNotificationPolicyAccess() throws RemoteException {
            this.enforceSystemOrSystemUI("request policy access packages");
            long identity = Binder.clearCallingIdentity();
            try {
                String[] stringArray = NotificationManagerService.this.mPolicyAccess.getRequestingPackages();
                return stringArray;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setNotificationPolicyAccessGranted(String pkg, boolean granted) throws RemoteException {
            this.enforceSystemOrSystemUI("grant notification policy access");
            long identity = Binder.clearCallingIdentity();
            try {
                ArrayList<NotificationRecord> arrayList = NotificationManagerService.this.mNotificationList;
                synchronized (arrayList) {
                    NotificationManagerService.this.mPolicyAccess.put(pkg, granted);
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NotificationManager.Policy getNotificationPolicy(String pkg) {
            this.enforcePolicyAccess(pkg, "getNotificationPolicy");
            long identity = Binder.clearCallingIdentity();
            try {
                NotificationManager.Policy policy = NotificationManagerService.this.mZenModeHelper.getNotificationPolicy();
                return policy;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setNotificationPolicy(String pkg, NotificationManager.Policy policy) {
            this.enforcePolicyAccess(pkg, "setNotificationPolicy");
            long identity = Binder.clearCallingIdentity();
            try {
                NotificationManagerService.this.mZenModeHelper.setNotificationPolicy(policy);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void applyAdjustmentFromRankerService(INotificationListener token, Adjustment adjustment) throws RemoteException {
            long identity = Binder.clearCallingIdentity();
            try {
                ArrayList<NotificationRecord> arrayList = NotificationManagerService.this.mNotificationList;
                synchronized (arrayList) {
                    NotificationManagerService.this.mRankerServices.checkServiceTokenLocked(token);
                    NotificationManagerService.this.applyAdjustmentLocked(adjustment);
                }
                NotificationManagerService.this.maybeAddAutobundleSummary(adjustment);
                NotificationManagerService.this.mRankingHandler.requestSort();
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void applyAdjustmentsFromRankerService(INotificationListener token, List<Adjustment> adjustments) throws RemoteException {
            long identity = Binder.clearCallingIdentity();
            try {
                ArrayList<NotificationRecord> arrayList = NotificationManagerService.this.mNotificationList;
                synchronized (arrayList) {
                    NotificationManagerService.this.mRankerServices.checkServiceTokenLocked(token);
                    for (Adjustment adjustment : adjustments) {
                        NotificationManagerService.this.applyAdjustmentLocked(adjustment);
                    }
                }
                for (Adjustment adjustment : adjustments) {
                    NotificationManagerService.this.maybeAddAutobundleSummary(adjustment);
                }
                NotificationManagerService.this.mRankingHandler.requestSort();
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    };
    private final NotificationManagerInternal mInternalService = new NotificationManagerInternal(){

        @Override
        public void enqueueNotification(String pkg, String opPkg, int callingUid, int callingPid, String tag, int id2, Notification notification, int[] idReceived, int userId) {
            NotificationManagerService.this.enqueueNotificationInternal(pkg, opPkg, callingUid, callingPid, tag, id2, notification, idReceived, userId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeForegroundServiceFlagFromNotification(String pkg, int notificationId, int userId) {
            NotificationManagerService.checkCallerIsSystem();
            ArrayList<NotificationRecord> arrayList = NotificationManagerService.this.mNotificationList;
            synchronized (arrayList) {
                int i = NotificationManagerService.this.indexOfNotificationLocked(pkg, null, notificationId, userId);
                if (i < 0) {
                    Log.d(NotificationManagerService.TAG, "stripForegroundServiceFlag: Could not find notification with pkg=" + pkg + " / id=" + notificationId + " / userId=" + userId);
                    return;
                }
                NotificationRecord r = NotificationManagerService.this.mNotificationList.get(i);
                StatusBarNotification sbn = r.sbn;
                sbn.getNotification().flags = r.mOriginalFlags & 0xFFFFFFBF;
                NotificationManagerService.this.mRankingHelper.sort(NotificationManagerService.this.mNotificationList);
                NotificationManagerService.this.mListeners.notifyPostedLocked(sbn, sbn);
            }
        }
    };

    private void readPolicyXml(InputStream stream, boolean forRestore) throws XmlPullParserException, NumberFormatException, IOException {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(stream, StandardCharsets.UTF_8.name());
        while (parser.next() != 1) {
            this.mZenModeHelper.readXml(parser, forRestore);
            this.mRankingHelper.readXml(parser, forRestore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPolicyFile() {
        if (DBG) {
            Slog.d(TAG, "loadPolicyFile");
        }
        AtomicFile atomicFile = this.mPolicyFile;
        synchronized (atomicFile) {
            FileInputStream infile = null;
            try {
                infile = this.mPolicyFile.openRead();
                this.readPolicyXml(infile, false);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException e) {
                Log.wtf(TAG, "Unable to read notification policy", e);
            }
            catch (NumberFormatException e) {
                Log.wtf(TAG, "Unable to parse notification policy", e);
            }
            catch (XmlPullParserException e) {
                Log.wtf(TAG, "Unable to parse notification policy", e);
            }
            finally {
                IoUtils.closeQuietly(infile);
            }
        }
    }

    public void savePolicyFile() {
        this.mHandler.removeMessages(3);
        this.mHandler.sendEmptyMessage(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSavePolicyFile() {
        if (DBG) {
            Slog.d(TAG, "handleSavePolicyFile");
        }
        AtomicFile atomicFile = this.mPolicyFile;
        synchronized (atomicFile) {
            FileOutputStream stream;
            try {
                stream = this.mPolicyFile.startWrite();
            }
            catch (IOException e) {
                Slog.w(TAG, "Failed to save policy file", e);
                return;
            }
            try {
                this.writePolicyXml(stream, false);
                this.mPolicyFile.finishWrite(stream);
            }
            catch (IOException e) {
                Slog.w(TAG, "Failed to save policy file, restoring backup", e);
                this.mPolicyFile.failWrite(stream);
            }
        }
        BackupManager.dataChanged(this.getContext().getPackageName());
    }

    private void writePolicyXml(OutputStream stream, boolean forBackup) throws IOException {
        FastXmlSerializer out = new FastXmlSerializer();
        out.setOutput(stream, StandardCharsets.UTF_8.name());
        out.startDocument(null, true);
        out.startTag(null, TAG_NOTIFICATION_POLICY);
        out.attribute(null, ATTR_VERSION, Integer.toString(1));
        this.mZenModeHelper.writeXml(out, forBackup);
        this.mRankingHelper.writeXml(out, forBackup);
        out.endTag(null, TAG_NOTIFICATION_POLICY);
        out.endDocument();
    }

    private boolean noteNotificationOp(String pkg, int uid) {
        if (this.mAppOps.noteOpNoThrow(11, uid, pkg) != 0) {
            Slog.v(TAG, "notifications are disabled by AppOps for " + pkg);
            return false;
        }
        return true;
    }

    private boolean checkNotificationOp(String pkg, int uid) {
        return this.mAppOps.checkOp(11, uid, pkg) == 0 && !this.isPackageSuspendedForUser(pkg, uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSoundLocked() {
        this.mSoundNotificationKey = null;
        long identity = Binder.clearCallingIdentity();
        try {
            IRingtonePlayer player = this.mAudioManager.getRingtonePlayer();
            if (player != null) {
                player.stopAsync();
            }
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private void clearVibrateLocked() {
        this.mVibrateNotificationKey = null;
        long identity = Binder.clearCallingIdentity();
        try {
            this.mVibrator.cancel();
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private void clearLightsLocked() {
        this.mLights.clear();
        this.updateLightsLocked();
    }

    static long[] getLongArray(Resources r, int resid, int maxlen, long[] def) {
        int[] ar = r.getIntArray(resid);
        if (ar == null) {
            return def;
        }
        int len = ar.length > maxlen ? maxlen : ar.length;
        long[] out = new long[len];
        for (int i = 0; i < len; ++i) {
            out[i] = ar[i];
        }
        return out;
    }

    public NotificationManagerService(Context context) {
        super(context);
    }

    void setAudioManager(AudioManager audioMananger) {
        this.mAudioManager = audioMananger;
    }

    void setVibrator(Vibrator vibrator) {
        this.mVibrator = vibrator;
    }

    void setSystemReady(boolean systemReady) {
        this.mSystemReady = systemReady;
    }

    void setHandler(Handler handler) {
        this.mHandler = handler;
    }

    void setSystemNotificationSound(String systemNotificationSound) {
        this.mSystemNotificationSound = systemNotificationSound;
    }

    @Override
    public void onStart() {
        String[] extractorNames;
        Resources resources = this.getContext().getResources();
        this.mMaxPackageEnqueueRate = Settings.Global.getFloat(this.getContext().getContentResolver(), "max_notification_enqueue_rate", 10.0f);
        this.mAm = ActivityManagerNative.getDefault();
        this.mAppOps = (AppOpsManager)this.getContext().getSystemService("appops");
        this.mVibrator = (Vibrator)this.getContext().getSystemService("vibrator");
        this.mAppUsageStats = LocalServices.getService(UsageStatsManagerInternal.class);
        this.mRankerServicePackageName = this.getContext().getPackageManager().getServicesSystemSharedLibraryPackageName();
        this.mHandler = new WorkerHandler();
        this.mRankingThread.start();
        try {
            extractorNames = resources.getStringArray(17236025);
        }
        catch (Resources.NotFoundException e) {
            extractorNames = new String[]{};
        }
        this.mUsageStats = new NotificationUsageStats(this.getContext());
        this.mRankingHandler = new RankingHandlerWorker(this.mRankingThread.getLooper());
        this.mRankingHelper = new RankingHelper(this.getContext(), this.mRankingHandler, this.mUsageStats, extractorNames);
        this.mConditionProviders = new ConditionProviders(this.getContext(), this.mHandler, this.mUserProfiles);
        this.mZenModeHelper = new ZenModeHelper(this.getContext(), this.mHandler.getLooper(), this.mConditionProviders);
        this.mZenModeHelper.addCallback(new ZenModeHelper.Callback(){

            @Override
            public void onConfigChanged() {
                NotificationManagerService.this.savePolicyFile();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void onZenModeChanged() {
                NotificationManagerService.this.sendRegisteredOnlyBroadcast("android.app.action.INTERRUPTION_FILTER_CHANGED");
                NotificationManagerService.this.getContext().sendBroadcastAsUser(new Intent("android.app.action.INTERRUPTION_FILTER_CHANGED_INTERNAL").addFlags(0x4000000), UserHandle.ALL, "android.permission.MANAGE_NOTIFICATIONS");
                ArrayList<NotificationRecord> arrayList = NotificationManagerService.this.mNotificationList;
                synchronized (arrayList) {
                    NotificationManagerService.this.updateInterruptionFilterLocked();
                }
            }

            @Override
            void onPolicyChanged() {
                NotificationManagerService.this.sendRegisteredOnlyBroadcast("android.app.action.NOTIFICATION_POLICY_CHANGED");
            }
        });
        File systemDir = new File(Environment.getDataDirectory(), "system");
        this.mPolicyFile = new AtomicFile(new File(systemDir, "notification_policy.xml"));
        this.syncBlockDb();
        this.mListeners = new NotificationListeners();
        this.mRankerServices = new NotificationRankers();
        this.mRankerServices.registerRanker();
        this.mStatusBar = this.getLocalService(StatusBarManagerInternal.class);
        if (this.mStatusBar != null) {
            this.mStatusBar.setNotificationDelegate(this.mNotificationDelegate);
        }
        LightsManager lights = this.getLocalService(LightsManager.class);
        this.mNotificationLight = lights.getLight(4);
        this.mAttentionLight = lights.getLight(5);
        this.mDefaultNotificationColor = resources.getColor(17170696);
        this.mDefaultNotificationLedOn = resources.getInteger(17694808);
        this.mDefaultNotificationLedOff = resources.getInteger(17694809);
        this.mDefaultVibrationPattern = NotificationManagerService.getLongArray(resources, 17236021, 17, DEFAULT_VIBRATE_PATTERN);
        this.mFallbackVibrationPattern = NotificationManagerService.getLongArray(resources, 17236022, 17, DEFAULT_VIBRATE_PATTERN);
        this.mUseAttentionLight = resources.getBoolean(17956901);
        if (0 == Settings.Global.getInt(this.getContext().getContentResolver(), "device_provisioned", 0)) {
            this.mDisableNotificationEffects = true;
        }
        this.mZenModeHelper.initZenMode();
        this.mInterruptionFilter = this.mZenModeHelper.getZenModeListenerInterruptionFilter();
        this.mUserProfiles.updateCache(this.getContext());
        this.listenForCallState();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.PHONE_STATE");
        filter.addAction("android.intent.action.USER_PRESENT");
        filter.addAction("android.intent.action.USER_STOPPED");
        filter.addAction("android.intent.action.USER_SWITCHED");
        filter.addAction("android.intent.action.USER_ADDED");
        filter.addAction("android.intent.action.USER_REMOVED");
        filter.addAction("android.intent.action.USER_UNLOCKED");
        filter.addAction("android.intent.action.MANAGED_PROFILE_UNAVAILABLE");
        this.getContext().registerReceiver(this.mIntentReceiver, filter);
        IntentFilter pkgFilter = new IntentFilter();
        pkgFilter.addAction("android.intent.action.PACKAGE_ADDED");
        pkgFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        pkgFilter.addAction("android.intent.action.PACKAGE_CHANGED");
        pkgFilter.addAction("android.intent.action.PACKAGE_RESTARTED");
        pkgFilter.addAction("android.intent.action.QUERY_PACKAGE_RESTART");
        pkgFilter.addDataScheme("package");
        this.getContext().registerReceiverAsUser(this.mPackageIntentReceiver, UserHandle.ALL, pkgFilter, null, null);
        IntentFilter suspendedPkgFilter = new IntentFilter();
        suspendedPkgFilter.addAction("android.intent.action.PACKAGES_SUSPENDED");
        this.getContext().registerReceiverAsUser(this.mPackageIntentReceiver, UserHandle.ALL, suspendedPkgFilter, null, null);
        IntentFilter sdFilter = new IntentFilter("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
        this.getContext().registerReceiverAsUser(this.mPackageIntentReceiver, UserHandle.ALL, sdFilter, null, null);
        this.mSettingsObserver = new SettingsObserver(this.mHandler);
        this.mArchive = new Archive(resources.getInteger(17694815));
        this.publishBinderService("notification", this.mService);
        this.publishLocalService(NotificationManagerInternal.class, this.mInternalService);
    }

    private void sendRegisteredOnlyBroadcast(String action) {
        this.getContext().sendBroadcastAsUser(new Intent(action).addFlags(0x40000000), UserHandle.ALL, null);
    }

    private void syncBlockDb() {
        this.loadPolicyFile();
        Map<Integer, String> packageBans = this.mRankingHelper.getPackageBans();
        for (Map.Entry<Integer, String> entry : packageBans.entrySet()) {
            int uid = entry.getKey();
            String packageName = entry.getValue();
            this.setNotificationsEnabledForPackageImpl(packageName, uid, false);
        }
        packageBans.clear();
        for (UserInfo userInfo : UserManager.get(this.getContext()).getUsers()) {
            int userId = userInfo.getUserHandle().getIdentifier();
            PackageManager packageManager = this.getContext().getPackageManager();
            List<PackageInfo> packages = packageManager.getInstalledPackagesAsUser(0, userId);
            int packageCount = packages.size();
            for (int p = 0; p < packageCount; ++p) {
                String packageName = packages.get((int)p).packageName;
                try {
                    int uid = packageManager.getPackageUidAsUser(packageName, userId);
                    if (this.checkNotificationOp(packageName, uid)) continue;
                    packageBans.put(uid, packageName);
                    continue;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
        }
        for (Map.Entry entry : packageBans.entrySet()) {
            this.mRankingHelper.setImportance((String)entry.getValue(), (Integer)entry.getKey(), 0);
        }
        this.savePolicyFile();
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase == 500) {
            this.mSystemReady = true;
            this.mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
            this.mAudioManagerInternal = this.getLocalService(AudioManagerInternal.class);
            this.mVrManagerInternal = this.getLocalService(VrManagerInternal.class);
            this.mZenModeHelper.onSystemReady();
        } else if (phase == 600) {
            this.mSettingsObserver.observe();
            this.mListeners.onBootPhaseAppsCanStart();
            this.mRankerServices.onBootPhaseAppsCanStart();
            this.mConditionProviders.onBootPhaseAppsCanStart();
        }
    }

    void setNotificationsEnabledForPackageImpl(String pkg, int uid, boolean enabled) {
        Slog.v(TAG, (enabled ? "en" : "dis") + "abling notifications for " + pkg);
        this.mAppOps.setMode(11, uid, pkg, enabled ? 0 : 1);
        if (!enabled) {
            this.cancelAllNotificationsInt(MY_UID, MY_PID, pkg, 0, 0, true, UserHandle.getUserId(uid), 7, null);
        }
    }

    private void updateListenerHintsLocked() {
        int hints = this.calculateHints();
        if (hints == this.mListenerHints) {
            return;
        }
        ZenLog.traceListenerHintsChanged(this.mListenerHints, hints, this.mEffectsSuppressors.size());
        this.mListenerHints = hints;
        this.scheduleListenerHintsChanged(hints);
    }

    private void updateEffectsSuppressorLocked() {
        long updatedSuppressedEffects = this.calculateSuppressedEffects();
        if (updatedSuppressedEffects == this.mZenModeHelper.getSuppressedEffects()) {
            return;
        }
        ArrayList<ComponentName> suppressors = this.getSuppressors();
        ZenLog.traceEffectsSuppressorChanged(this.mEffectsSuppressors, suppressors, updatedSuppressedEffects);
        this.mEffectsSuppressors = suppressors;
        this.mZenModeHelper.setSuppressedEffects(updatedSuppressedEffects);
        this.sendRegisteredOnlyBroadcast("android.os.action.ACTION_EFFECTS_SUPPRESSOR_CHANGED");
    }

    private ArrayList<ComponentName> getSuppressors() {
        ArrayList<ComponentName> names = new ArrayList<ComponentName>();
        for (int i = this.mListenersDisablingEffects.size() - 1; i >= 0; --i) {
            ArraySet<ManagedServices.ManagedServiceInfo> serviceInfoList = this.mListenersDisablingEffects.valueAt(i);
            for (ManagedServices.ManagedServiceInfo info : serviceInfoList) {
                names.add(info.component);
            }
        }
        return names;
    }

    private boolean removeDisabledHints(ManagedServices.ManagedServiceInfo info) {
        return this.removeDisabledHints(info, 0);
    }

    private boolean removeDisabledHints(ManagedServices.ManagedServiceInfo info, int hints) {
        boolean removed = false;
        for (int i = this.mListenersDisablingEffects.size() - 1; i >= 0; --i) {
            int hint = this.mListenersDisablingEffects.keyAt(i);
            ArraySet<ManagedServices.ManagedServiceInfo> listeners = this.mListenersDisablingEffects.valueAt(i);
            if (hints != 0 && (hint & hints) != hint) continue;
            removed = removed || listeners.remove(info);
        }
        return removed;
    }

    private void addDisabledHints(ManagedServices.ManagedServiceInfo info, int hints) {
        if ((hints & 1) != 0) {
            this.addDisabledHint(info, 1);
        }
        if ((hints & 2) != 0) {
            this.addDisabledHint(info, 2);
        }
        if ((hints & 4) != 0) {
            this.addDisabledHint(info, 4);
        }
    }

    private void addDisabledHint(ManagedServices.ManagedServiceInfo info, int hint) {
        if (this.mListenersDisablingEffects.indexOfKey(hint) < 0) {
            this.mListenersDisablingEffects.put(hint, new ArraySet());
        }
        ArraySet<ManagedServices.ManagedServiceInfo> hintListeners = this.mListenersDisablingEffects.get(hint);
        hintListeners.add(info);
    }

    private int calculateHints() {
        int hints = 0;
        for (int i = this.mListenersDisablingEffects.size() - 1; i >= 0; --i) {
            int hint = this.mListenersDisablingEffects.keyAt(i);
            ArraySet<ManagedServices.ManagedServiceInfo> serviceInfoList = this.mListenersDisablingEffects.valueAt(i);
            if (serviceInfoList.isEmpty()) continue;
            hints |= hint;
        }
        return hints;
    }

    private long calculateSuppressedEffects() {
        int hints = this.calculateHints();
        long suppressedEffects = 0L;
        if ((hints & 1) != 0) {
            suppressedEffects |= 3L;
        }
        if ((hints & 2) != 0) {
            suppressedEffects |= 1L;
        }
        if ((hints & 4) != 0) {
            suppressedEffects |= 2L;
        }
        return suppressedEffects;
    }

    private void updateInterruptionFilterLocked() {
        int interruptionFilter = this.mZenModeHelper.getZenModeListenerInterruptionFilter();
        if (interruptionFilter == this.mInterruptionFilter) {
            return;
        }
        this.mInterruptionFilter = interruptionFilter;
        this.scheduleInterruptionFilterChanged(interruptionFilter);
    }

    private void applyAdjustmentLocked(Adjustment adjustment) {
        this.maybeClearAutobundleSummaryLocked(adjustment);
        NotificationRecord n = this.mNotificationsByKey.get(adjustment.getKey());
        if (n == null) {
            return;
        }
        if (adjustment.getImportance() != 0) {
            n.setImportance(adjustment.getImportance(), adjustment.getExplanation());
        }
        if (adjustment.getSignals() != null) {
            Bundle.setDefusable(adjustment.getSignals(), true);
            String autoGroupKey = adjustment.getSignals().getString("group_key_override", null);
            if (autoGroupKey == null) {
                EventLogTags.writeNotificationUnautogrouped(adjustment.getKey());
            } else {
                EventLogTags.writeNotificationAutogrouped(adjustment.getKey());
            }
            n.sbn.setOverrideGroupKey(autoGroupKey);
        }
    }

    private void maybeClearAutobundleSummaryLocked(Adjustment adjustment) {
        if (adjustment.getSignals() != null) {
            NotificationRecord removed;
            ArrayMap<String, String> summaries;
            Bundle.setDefusable(adjustment.getSignals(), true);
            if (adjustment.getSignals().containsKey("autogroup_needed") && !adjustment.getSignals().getBoolean("autogroup_needed", false) && (summaries = this.mAutobundledSummaries.get(adjustment.getUser())) != null && summaries.containsKey(adjustment.getPackage()) && (removed = this.mNotificationsByKey.get(summaries.remove(adjustment.getPackage()))) != null) {
                this.mNotificationList.remove(removed);
                this.cancelNotificationLocked(removed, false, 16);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeAddAutobundleSummary(Adjustment adjustment) {
        if (adjustment.getSignals() != null) {
            Bundle.setDefusable(adjustment.getSignals(), true);
            if (adjustment.getSignals().getBoolean("autogroup_needed", false)) {
                String newAutoBundleKey = adjustment.getSignals().getString("group_key_override", null);
                int userId = -1;
                NotificationRecord summaryRecord = null;
                ArrayList<NotificationRecord> arrayList = this.mNotificationList;
                synchronized (arrayList) {
                    NotificationRecord notificationRecord = this.mNotificationsByKey.get(adjustment.getKey());
                    if (notificationRecord == null) {
                        return;
                    }
                    StatusBarNotification adjustedSbn = notificationRecord.sbn;
                    userId = adjustedSbn.getUser().getIdentifier();
                    ArrayMap<String, String> summaries = this.mAutobundledSummaries.get(userId);
                    if (summaries == null) {
                        summaries = new ArrayMap();
                    }
                    this.mAutobundledSummaries.put(userId, summaries);
                    if (!summaries.containsKey(adjustment.getPackage()) && newAutoBundleKey != null) {
                        ApplicationInfo appInfo = (ApplicationInfo)adjustedSbn.getNotification().extras.getParcelable("android.appInfo");
                        Bundle extras = new Bundle();
                        extras.putParcelable("android.appInfo", appInfo);
                        Notification summaryNotification = new Notification.Builder(this.getContext()).setSmallIcon(adjustedSbn.getNotification().getSmallIcon()).setGroupSummary(true).setGroup(newAutoBundleKey).setFlag(1024, true).setFlag(512, true).setColor(adjustedSbn.getNotification().color).setLocalOnly(true).build();
                        summaryNotification.extras.putAll(extras);
                        Intent appIntent = this.getContext().getPackageManager().getLaunchIntentForPackage(adjustment.getPackage());
                        if (appIntent != null) {
                            summaryNotification.contentIntent = PendingIntent.getActivityAsUser(this.getContext(), 0, appIntent, 0, null, UserHandle.of(userId));
                        }
                        StatusBarNotification summarySbn = new StatusBarNotification(adjustedSbn.getPackageName(), adjustedSbn.getOpPkg(), Integer.MAX_VALUE, "group_key_override", adjustedSbn.getUid(), adjustedSbn.getInitialPid(), summaryNotification, adjustedSbn.getUser(), newAutoBundleKey, System.currentTimeMillis());
                        summaryRecord = new NotificationRecord(this.getContext(), summarySbn);
                        summaries.put(adjustment.getPackage(), summarySbn.getKey());
                    }
                }
                if (summaryRecord != null) {
                    this.mHandler.post(new EnqueueNotificationRunnable(userId, summaryRecord));
                }
            }
        }
    }

    private String disableNotificationEffects(NotificationRecord record) {
        if (this.mDisableNotificationEffects) {
            return "booleanState";
        }
        if ((this.mListenerHints & 1) != 0) {
            return "listenerHints";
        }
        if (this.mCallState != 0 && !this.mZenModeHelper.isCall(record)) {
            return "callState";
        }
        return null;
    }

    private void dumpJson(PrintWriter pw, DumpFilter filter) {
        JSONObject dump = new JSONObject();
        try {
            dump.put("service", "Notification Manager");
            dump.put("bans", this.mRankingHelper.dumpBansJson(filter));
            dump.put("ranking", this.mRankingHelper.dumpJson(filter));
            dump.put("stats", this.mUsageStats.dumpJson(filter));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        pw.println(dump);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpImpl(PrintWriter pw, DumpFilter filter) {
        int i;
        int N;
        ArrayList<Object> arrayList;
        boolean zenOnly;
        pw.print("Current Notification Manager state");
        if (filter.filtered) {
            pw.print(" (filtered to ");
            pw.print(filter);
            pw.print(")");
        }
        pw.println(':');
        boolean bl = zenOnly = filter.filtered && filter.zen;
        if (!zenOnly) {
            arrayList = this.mToastQueue;
            synchronized (arrayList) {
                N = this.mToastQueue.size();
                if (N > 0) {
                    pw.println("  Toast Queue:");
                    for (i = 0; i < N; ++i) {
                        this.mToastQueue.get(i).dump(pw, "    ", filter);
                    }
                    pw.println("  ");
                }
            }
        }
        arrayList = this.mNotificationList;
        synchronized (arrayList) {
            if (!zenOnly) {
                N = this.mNotificationList.size();
                if (N > 0) {
                    pw.println("  Notification List:");
                    for (i = 0; i < N; ++i) {
                        NotificationRecord nr = this.mNotificationList.get(i);
                        if (filter.filtered && !filter.matches(nr.sbn)) continue;
                        nr.dump(pw, "    ", this.getContext(), filter.redact);
                    }
                    pw.println("  ");
                }
                if (!filter.filtered) {
                    N = this.mLights.size();
                    if (N > 0) {
                        pw.println("  Lights List:");
                        for (i = 0; i < N; ++i) {
                            if (i == N - 1) {
                                pw.print("  > ");
                            } else {
                                pw.print("    ");
                            }
                            pw.println(this.mLights.get(i));
                        }
                        pw.println("  ");
                    }
                    pw.println("  mUseAttentionLight=" + this.mUseAttentionLight);
                    pw.println("  mNotificationPulseEnabled=" + this.mNotificationPulseEnabled);
                    pw.println("  mSoundNotificationKey=" + this.mSoundNotificationKey);
                    pw.println("  mVibrateNotificationKey=" + this.mVibrateNotificationKey);
                    pw.println("  mDisableNotificationEffects=" + this.mDisableNotificationEffects);
                    pw.println("  mCallState=" + NotificationManagerService.callStateToString(this.mCallState));
                    pw.println("  mSystemReady=" + this.mSystemReady);
                    pw.println("  mMaxPackageEnqueueRate=" + this.mMaxPackageEnqueueRate);
                }
                pw.println("  mArchive=" + this.mArchive.toString());
                Iterator<StatusBarNotification> iter = this.mArchive.descendingIterator();
                int i2 = 0;
                while (iter.hasNext()) {
                    StatusBarNotification sbn = iter.next();
                    if (filter != null && !filter.matches(sbn)) continue;
                    pw.println("    " + sbn);
                    if (++i2 < 5) continue;
                    if (!iter.hasNext()) break;
                    pw.println("    ...");
                    break;
                }
            }
            if (!zenOnly) {
                pw.println("\n  Usage Stats:");
                this.mUsageStats.dump(pw, "    ", filter);
            }
            if (!filter.filtered || zenOnly) {
                pw.println("\n  Zen Mode:");
                pw.print("    mInterruptionFilter=");
                pw.println(this.mInterruptionFilter);
                this.mZenModeHelper.dump(pw, "    ");
                pw.println("\n  Zen Log:");
                ZenLog.dump(pw, "    ");
            }
            if (!zenOnly) {
                pw.println("\n  Ranking Config:");
                this.mRankingHelper.dump(pw, "    ", filter);
                pw.println("\n  Notification listeners:");
                this.mListeners.dump(pw, filter);
                pw.print("    mListenerHints: ");
                pw.println(this.mListenerHints);
                pw.print("    mListenersDisablingEffects: (");
                N = this.mListenersDisablingEffects.size();
                for (int i3 = 0; i3 < N; ++i3) {
                    int hint = this.mListenersDisablingEffects.keyAt(i3);
                    if (i3 > 0) {
                        pw.print(';');
                    }
                    pw.print("hint[" + hint + "]:");
                    ArraySet<ManagedServices.ManagedServiceInfo> listeners = this.mListenersDisablingEffects.valueAt(i3);
                    int listenerSize = listeners.size();
                    for (int j = 0; j < listenerSize; ++j) {
                        if (i3 > 0) {
                            pw.print(',');
                        }
                        ManagedServices.ManagedServiceInfo listener = listeners.valueAt(i3);
                        pw.print(listener.component);
                    }
                }
                pw.println(')');
                pw.println("\n  mRankerServicePackageName: " + this.mRankerServicePackageName);
                pw.println("\n  Notification ranker services:");
                this.mRankerServices.dump(pw, filter);
            }
            pw.println("\n  Policy access:");
            pw.print("    mPolicyAccess: ");
            pw.println(this.mPolicyAccess);
            pw.println("\n  Condition providers:");
            this.mConditionProviders.dump(pw, filter);
            pw.println("\n  Group summaries:");
            for (Map.Entry<String, NotificationRecord> entry : this.mSummaryByGroupKey.entrySet()) {
                NotificationRecord r = entry.getValue();
                pw.println("    " + entry.getKey() + " -> " + r.getKey());
                if (this.mNotificationsByKey.get(r.getKey()) == r) continue;
                pw.println("!!!!!!LEAK: Record not found in mNotificationsByKey.");
                r.dump(pw, "      ", this.getContext(), filter.redact);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueueNotificationInternal(String pkg, String opPkg, int callingUid, int callingPid, String tag, int id2, Notification notification, int[] idOut, int incomingUserId) {
        int intentCount;
        if (DBG) {
            Slog.v(TAG, "enqueueNotificationInternal: pkg=" + pkg + " id=" + id2 + " notification=" + notification);
        }
        NotificationManagerService.checkCallerIsSystemOrSameApp(pkg);
        boolean isSystemNotification = NotificationManagerService.isUidSystem(callingUid) || "android".equals(pkg);
        boolean isNotificationFromListener = this.mListeners.isListenerPackage(pkg);
        int userId = ActivityManager.handleIncomingUser(callingPid, callingUid, incomingUserId, true, false, "enqueueNotification", pkg);
        UserHandle user = new UserHandle(userId);
        try {
            ApplicationInfo ai = this.getContext().getPackageManager().getApplicationInfoAsUser(pkg, 0x10000000, userId == -1 ? 0 : userId);
            Notification.addFieldsFromContext(ai, userId, notification);
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.e(TAG, "Cannot create a context for sending app", e);
            return;
        }
        this.mUsageStats.registerEnqueuedByApp(pkg);
        if (pkg == null || notification == null) {
            throw new IllegalArgumentException("null not allowed: pkg=" + pkg + " id=" + id2 + " notification=" + notification);
        }
        StatusBarNotification n = new StatusBarNotification(pkg, opPkg, id2, tag, callingUid, callingPid, 0, notification, user);
        if (!isSystemNotification && !isNotificationFromListener) {
            ArrayList<NotificationRecord> arrayList = this.mNotificationList;
            synchronized (arrayList) {
                float appEnqueueRate;
                if (this.mNotificationsByKey.get(n.getKey()) != null && (appEnqueueRate = this.mUsageStats.getAppEnqueueRate(pkg)) > this.mMaxPackageEnqueueRate) {
                    this.mUsageStats.registerOverRateQuota(pkg);
                    long now = SystemClock.elapsedRealtime();
                    if (now - this.mLastOverRateLogTime > 5000L) {
                        Slog.e(TAG, "Package enqueue rate is " + appEnqueueRate + ". Shedding events. package=" + pkg);
                        this.mLastOverRateLogTime = now;
                    }
                    return;
                }
                int count = 0;
                int N = this.mNotificationList.size();
                for (int i = 0; i < N; ++i) {
                    NotificationRecord r = this.mNotificationList.get(i);
                    if (!r.sbn.getPackageName().equals(pkg) || r.sbn.getUserId() != userId) continue;
                    if (r.sbn.getId() == id2 && TextUtils.equals(r.sbn.getTag(), tag)) break;
                    if (++count < 50) continue;
                    this.mUsageStats.registerOverCountQuota(pkg);
                    Slog.e(TAG, "Package has already posted " + count + " notifications.  Not showing more.  package=" + pkg);
                    return;
                }
            }
        }
        if (notification.allPendingIntents != null && (intentCount = notification.allPendingIntents.size()) > 0) {
            ActivityManagerInternal am = LocalServices.getService(ActivityManagerInternal.class);
            long duration = LocalServices.getService(DeviceIdleController.LocalService.class).getNotificationWhitelistDuration();
            for (int i = 0; i < intentCount; ++i) {
                PendingIntent pendingIntent = notification.allPendingIntents.valueAt(i);
                if (pendingIntent == null) continue;
                am.setPendingIntentWhitelistDuration(pendingIntent.getTarget(), duration);
            }
        }
        notification.priority = NotificationManagerService.clamp(notification.priority, -2, 2);
        NotificationRecord r = new NotificationRecord(this.getContext(), n);
        this.mHandler.post(new EnqueueNotificationRunnable(userId, r));
        idOut[0] = id2;
    }

    private void handleGroupedNotificationLocked(NotificationRecord r, NotificationRecord old, int callingUid, int callingPid) {
        NotificationRecord removedSummary;
        boolean oldIsSummary;
        StatusBarNotification sbn = r.sbn;
        Notification n = sbn.getNotification();
        if (n.isGroupSummary() && !sbn.isAppGroup()) {
            n.flags &= 0xFFFFFDFF;
        }
        String group = sbn.getGroupKey();
        boolean isSummary = n.isGroupSummary();
        Notification oldN = old != null ? old.sbn.getNotification() : null;
        String oldGroup = old != null ? old.sbn.getGroupKey() : null;
        boolean bl = oldIsSummary = old != null && oldN.isGroupSummary();
        if (oldIsSummary && (removedSummary = this.mSummaryByGroupKey.remove(oldGroup)) != old) {
            String removedKey = removedSummary != null ? removedSummary.getKey() : "<null>";
            Slog.w(TAG, "Removed summary didn't match old notification: old=" + old.getKey() + ", removed=" + removedKey);
        }
        if (isSummary) {
            this.mSummaryByGroupKey.put(group, r);
        }
        if (!(!oldIsSummary || isSummary && oldGroup.equals(group))) {
            this.cancelGroupChildrenLocked(old, callingUid, callingPid, null, 12, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void buzzBeepBlinkLocked(NotificationRecord record) {
        int currentUser;
        boolean canInterrupt;
        boolean buzz = false;
        boolean beep = false;
        boolean blink = false;
        Notification notification = record.sbn.getNotification();
        String key = record.getKey();
        boolean aboveThreshold = record.getImportance() >= 3;
        boolean bl = canInterrupt = aboveThreshold && !record.isIntercepted();
        if (DBG || record.isIntercepted()) {
            Slog.v(TAG, "pkg=" + record.sbn.getPackageName() + " canInterrupt=" + canInterrupt + " intercept=" + record.isIntercepted());
        }
        long token = Binder.clearCallingIdentity();
        try {
            currentUser = ActivityManager.getCurrentUser();
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        String disableEffects = this.disableNotificationEffects(record);
        if (disableEffects != null) {
            ZenLog.traceDisableEffects(record, disableEffects);
        }
        boolean wasBeep = key != null && key.equals(this.mSoundNotificationKey);
        boolean wasBuzz = key != null && key.equals(this.mVibrateNotificationKey);
        boolean hasValidVibrate = false;
        boolean hasValidSound = false;
        if (disableEffects == null && (record.getUserId() == -1 || record.getUserId() == currentUser || this.mUserProfiles.isCurrentProfile(record.getUserId())) && canInterrupt && this.mSystemReady && this.mAudioManager != null) {
            if (DBG) {
                Slog.v(TAG, "Interrupting!");
            }
            boolean useDefaultSound = (notification.defaults & 1) != 0 || Settings.System.DEFAULT_NOTIFICATION_URI.equals(notification.sound);
            Uri soundUri = null;
            if (useDefaultSound) {
                soundUri = Settings.System.DEFAULT_NOTIFICATION_URI;
                hasValidSound = this.mSystemNotificationSound != null;
            } else if (notification.sound != null) {
                soundUri = notification.sound;
                hasValidSound = soundUri != null;
            }
            boolean hasCustomVibrate = notification.vibrate != null;
            boolean convertSoundToVibration = !hasCustomVibrate && hasValidSound && this.mAudioManager.getRingerModeInternal() == 1;
            boolean useDefaultVibrate = (notification.defaults & 2) != 0;
            boolean bl2 = hasValidVibrate = useDefaultVibrate || convertSoundToVibration || hasCustomVibrate;
            if (!record.isUpdate || (notification.flags & 8) == 0) {
                this.sendAccessibilityEvent(notification, record.sbn.getPackageName());
                if (hasValidSound) {
                    boolean looping = (notification.flags & 4) != 0;
                    AudioAttributes audioAttributes = NotificationManagerService.audioAttributesForNotification(notification);
                    this.mSoundNotificationKey = key;
                    if (this.mAudioManager.getStreamVolume(AudioAttributes.toLegacyStreamType(audioAttributes)) != 0 && !this.mAudioManager.isAudioFocusExclusive()) {
                        long identity = Binder.clearCallingIdentity();
                        try {
                            IRingtonePlayer player = this.mAudioManager.getRingtonePlayer();
                            if (player != null) {
                                if (DBG) {
                                    Slog.v(TAG, "Playing sound " + soundUri + " with attributes " + audioAttributes);
                                }
                                player.playAsync(soundUri, record.sbn.getUser(), looping, audioAttributes);
                                beep = true;
                            }
                        }
                        catch (RemoteException remoteException) {
                        }
                        finally {
                            Binder.restoreCallingIdentity(identity);
                        }
                    }
                }
                if (hasValidVibrate && this.mAudioManager.getRingerModeInternal() != 0) {
                    this.mVibrateNotificationKey = key;
                    if (useDefaultVibrate || convertSoundToVibration) {
                        long identity = Binder.clearCallingIdentity();
                        try {
                            this.mVibrator.vibrate(record.sbn.getUid(), record.sbn.getOpPkg(), useDefaultVibrate ? this.mDefaultVibrationPattern : this.mFallbackVibrationPattern, (notification.flags & 4) != 0 ? 0 : -1, NotificationManagerService.audioAttributesForNotification(notification));
                            buzz = true;
                        }
                        finally {
                            Binder.restoreCallingIdentity(identity);
                        }
                    } else if (notification.vibrate.length > 1) {
                        this.mVibrator.vibrate(record.sbn.getUid(), record.sbn.getOpPkg(), notification.vibrate, (notification.flags & 4) != 0 ? 0 : -1, NotificationManagerService.audioAttributesForNotification(notification));
                        buzz = true;
                    }
                }
            }
        }
        if (wasBeep && !hasValidSound) {
            this.clearSoundLocked();
        }
        if (wasBuzz && !hasValidVibrate) {
            this.clearVibrateLocked();
        }
        boolean wasShowLights = this.mLights.remove(key);
        if ((notification.flags & 1) != 0 && aboveThreshold && (record.getSuppressedVisualEffects() & 1) == 0) {
            this.mLights.add(key);
            this.updateLightsLocked();
            if (this.mUseAttentionLight) {
                this.mAttentionLight.pulse();
            }
            blink = true;
        } else if (wasShowLights) {
            this.updateLightsLocked();
        }
        if (buzz || beep || blink) {
            if ((record.getSuppressedVisualEffects() & 1) != 0) {
                if (DBG) {
                    Slog.v(TAG, "Suppressed SystemUI from triggering screen on");
                }
            } else {
                EventLogTags.writeNotificationAlert(key, buzz ? 1 : 0, beep ? 1 : 0, blink ? 1 : 0);
                this.mHandler.post(this.mBuzzBeepBlinked);
            }
        }
    }

    private static AudioAttributes audioAttributesForNotification(Notification n) {
        if (n.audioAttributes != null && !Notification.AUDIO_ATTRIBUTES_DEFAULT.equals(n.audioAttributes)) {
            return n.audioAttributes;
        }
        if (n.audioStreamType >= 0 && n.audioStreamType < AudioSystem.getNumStreamTypes()) {
            return new AudioAttributes.Builder().setInternalLegacyStreamType(n.audioStreamType).build();
        }
        if (n.audioStreamType == -1) {
            return Notification.AUDIO_ATTRIBUTES_DEFAULT;
        }
        Log.w(TAG, String.format("Invalid stream type: %d", n.audioStreamType));
        return Notification.AUDIO_ATTRIBUTES_DEFAULT;
    }

    void showNextToastLocked() {
        ToastRecord record = this.mToastQueue.get(0);
        while (record != null) {
            if (DBG) {
                Slog.d(TAG, "Show pkg=" + record.pkg + " callback=" + record.callback);
            }
            try {
                record.callback.show();
                this.scheduleTimeoutLocked(record);
                return;
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Object died trying to show notification " + record.callback + " in package " + record.pkg);
                int index = this.mToastQueue.indexOf(record);
                if (index >= 0) {
                    this.mToastQueue.remove(index);
                }
                this.keepProcessAliveLocked(record.pid);
                if (this.mToastQueue.size() > 0) {
                    record = this.mToastQueue.get(0);
                    continue;
                }
                record = null;
            }
        }
    }

    void cancelToastLocked(int index) {
        ToastRecord record = this.mToastQueue.get(index);
        try {
            record.callback.hide();
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Object died trying to hide notification " + record.callback + " in package " + record.pkg);
        }
        this.mToastQueue.remove(index);
        this.keepProcessAliveLocked(record.pid);
        if (this.mToastQueue.size() > 0) {
            this.showNextToastLocked();
        }
    }

    private void scheduleTimeoutLocked(ToastRecord r) {
        this.mHandler.removeCallbacksAndMessages(r);
        Message m = Message.obtain(this.mHandler, 2, r);
        long delay = r.duration == 1 ? 3500L : 2000L;
        this.mHandler.sendMessageDelayed(m, delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTimeout(ToastRecord record) {
        if (DBG) {
            Slog.d(TAG, "Timeout pkg=" + record.pkg + " callback=" + record.callback);
        }
        ArrayList<ToastRecord> arrayList = this.mToastQueue;
        synchronized (arrayList) {
            int index = this.indexOfToastLocked(record.pkg, record.callback);
            if (index >= 0) {
                this.cancelToastLocked(index);
            }
        }
    }

    int indexOfToastLocked(String pkg, ITransientNotification callback) {
        IBinder cbak = callback.asBinder();
        ArrayList<ToastRecord> list = this.mToastQueue;
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            ToastRecord r = list.get(i);
            if (!r.pkg.equals(pkg) || r.callback.asBinder() != cbak) continue;
            return i;
        }
        return -1;
    }

    void keepProcessAliveLocked(int pid) {
        int toastCount = 0;
        ArrayList<ToastRecord> list = this.mToastQueue;
        int N = list.size();
        for (int i = 0; i < N; ++i) {
            ToastRecord r = list.get(i);
            if (r.pid != pid) continue;
            ++toastCount;
        }
        try {
            this.mAm.setProcessForeground(this.mForegroundToken, pid, toastCount > 0);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRankingReconsideration(Message message) {
        boolean changed;
        if (!(message.obj instanceof RankingReconsideration)) {
            return;
        }
        RankingReconsideration recon = (RankingReconsideration)message.obj;
        recon.run();
        ArrayList<NotificationRecord> arrayList = this.mNotificationList;
        synchronized (arrayList) {
            NotificationRecord record = this.mNotificationsByKey.get(recon.getKey());
            if (record == null) {
                return;
            }
            int indexBefore = this.findNotificationRecordIndexLocked(record);
            boolean interceptBefore = record.isIntercepted();
            int visibilityBefore = record.getPackageVisibilityOverride();
            recon.applyChangesLocked(record);
            this.applyZenModeLocked(record);
            this.mRankingHelper.sort(this.mNotificationList);
            int indexAfter = this.findNotificationRecordIndexLocked(record);
            boolean interceptAfter = record.isIntercepted();
            int visibilityAfter = record.getPackageVisibilityOverride();
            boolean bl = changed = indexBefore != indexAfter || interceptBefore != interceptAfter || visibilityBefore != visibilityAfter;
            if (interceptBefore && !interceptAfter) {
                this.buzzBeepBlinkLocked(record);
            }
        }
        if (changed) {
            this.scheduleSendRankingUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRankingSort() {
        ArrayList<NotificationRecord> arrayList = this.mNotificationList;
        synchronized (arrayList) {
            NotificationRecord r;
            int i;
            int N = this.mNotificationList.size();
            ArrayList<String> orderBefore = new ArrayList<String>(N);
            ArrayList<String> groupOverrideBefore = new ArrayList<String>(N);
            int[] visibilities = new int[N];
            int[] importances = new int[N];
            for (i = 0; i < N; ++i) {
                r = this.mNotificationList.get(i);
                orderBefore.add(r.getKey());
                groupOverrideBefore.add(r.sbn.getGroupKey());
                visibilities[i] = r.getPackageVisibilityOverride();
                importances[i] = r.getImportance();
                this.mRankingHelper.extractSignals(r);
            }
            this.mRankingHelper.sort(this.mNotificationList);
            for (i = 0; i < N; ++i) {
                r = this.mNotificationList.get(i);
                if (((String)orderBefore.get(i)).equals(r.getKey()) && visibilities[i] == r.getPackageVisibilityOverride() && importances[i] == r.getImportance() && ((String)groupOverrideBefore.get(i)).equals(r.sbn.getGroupKey())) continue;
                this.scheduleSendRankingUpdate();
                return;
            }
        }
    }

    private void recordCallerLocked(NotificationRecord record) {
        if (this.mZenModeHelper.isCall(record)) {
            this.mZenModeHelper.recordCaller(record);
        }
    }

    private void applyZenModeLocked(NotificationRecord record) {
        record.setIntercepted(this.mZenModeHelper.shouldIntercept(record));
        if (record.isIntercepted()) {
            int suppressed = (this.mZenModeHelper.shouldSuppressWhenScreenOff() ? 1 : 0) | (this.mZenModeHelper.shouldSuppressWhenScreenOn() ? 2 : 0);
            record.setSuppressedVisualEffects(suppressed);
        }
    }

    private int findNotificationRecordIndexLocked(NotificationRecord target) {
        return this.mRankingHelper.indexOf(this.mNotificationList, target);
    }

    private void scheduleSendRankingUpdate() {
        if (!this.mHandler.hasMessages(4)) {
            Message m = Message.obtain(this.mHandler, 4);
            this.mHandler.sendMessage(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSendRankingUpdate() {
        ArrayList<NotificationRecord> arrayList = this.mNotificationList;
        synchronized (arrayList) {
            this.mListeners.notifyRankingUpdateLocked();
        }
    }

    private void scheduleListenerHintsChanged(int state) {
        this.mHandler.removeMessages(5);
        this.mHandler.obtainMessage(5, state, 0).sendToTarget();
    }

    private void scheduleInterruptionFilterChanged(int listenerInterruptionFilter) {
        this.mHandler.removeMessages(6);
        this.mHandler.obtainMessage(6, listenerInterruptionFilter, 0).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleListenerHintsChanged(int hints) {
        ArrayList<NotificationRecord> arrayList = this.mNotificationList;
        synchronized (arrayList) {
            this.mListeners.notifyListenerHintsChangedLocked(hints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleListenerInterruptionFilterChanged(int interruptionFilter) {
        ArrayList<NotificationRecord> arrayList = this.mNotificationList;
        synchronized (arrayList) {
            this.mListeners.notifyInterruptionFilterChanged(interruptionFilter);
        }
    }

    static int clamp(int x, int low, int high) {
        return x < low ? low : (x > high ? high : x);
    }

    void sendAccessibilityEvent(Notification notification, CharSequence packageName) {
        AccessibilityManager manager = AccessibilityManager.getInstance(this.getContext());
        if (!manager.isEnabled()) {
            return;
        }
        AccessibilityEvent event = AccessibilityEvent.obtain(64);
        event.setPackageName(packageName);
        event.setClassName(Notification.class.getName());
        event.setParcelableData(notification);
        CharSequence tickerText = notification.tickerText;
        if (!TextUtils.isEmpty(tickerText)) {
            event.getText().add(tickerText);
        }
        manager.sendAccessibilityEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelNotificationLocked(NotificationRecord r, boolean sendDelete, int reason) {
        ArrayMap<String, String> summaries;
        long identity;
        String canceledKey;
        this.recordCallerLocked(r);
        if (sendDelete && r.getNotification().deleteIntent != null) {
            try {
                r.getNotification().deleteIntent.send();
            }
            catch (PendingIntent.CanceledException ex) {
                Slog.w(TAG, "canceled PendingIntent for " + r.sbn.getPackageName(), ex);
            }
        }
        if (r.getNotification().getSmallIcon() != null) {
            r.isCanceled = true;
            this.mListeners.notifyRemovedLocked(r.sbn);
        }
        if ((canceledKey = r.getKey()).equals(this.mSoundNotificationKey)) {
            this.mSoundNotificationKey = null;
            identity = Binder.clearCallingIdentity();
            try {
                IRingtonePlayer player = this.mAudioManager.getRingtonePlayer();
                if (player != null) {
                    player.stopAsync();
                }
            }
            catch (RemoteException player) {
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
        if (canceledKey.equals(this.mVibrateNotificationKey)) {
            this.mVibrateNotificationKey = null;
            identity = Binder.clearCallingIdentity();
            try {
                this.mVibrator.cancel();
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
        this.mLights.remove(canceledKey);
        switch (reason) {
            case 2: 
            case 3: 
            case 10: 
            case 11: {
                this.mUsageStats.registerDismissedByUser(r);
                break;
            }
            case 8: 
            case 9: {
                this.mUsageStats.registerRemovedByApp(r);
            }
        }
        this.mNotificationsByKey.remove(r.sbn.getKey());
        String groupKey = r.getGroupKey();
        NotificationRecord groupSummary = this.mSummaryByGroupKey.get(groupKey);
        if (groupSummary != null && groupSummary.getKey().equals(r.getKey())) {
            this.mSummaryByGroupKey.remove(groupKey);
        }
        if ((summaries = this.mAutobundledSummaries.get(r.sbn.getUserId())) != null && r.sbn.getKey().equals(summaries.get(r.sbn.getPackageName()))) {
            summaries.remove(r.sbn.getPackageName());
        }
        this.mArchive.record(r.sbn);
        long now = System.currentTimeMillis();
        EventLogTags.writeNotificationCanceled(canceledKey, reason, r.getLifespanMs(now), r.getFreshnessMs(now), r.getExposureMs(now));
    }

    void cancelNotification(final int callingUid, final int callingPid, final String pkg, final String tag, final int id2, final int mustHaveFlags, final int mustNotHaveFlags, final boolean sendDelete, final int userId, final int reason, final ManagedServices.ManagedServiceInfo listener) {
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String listenerName;
                String string2 = listenerName = listener == null ? null : listener.component.toShortString();
                if (DBG) {
                    EventLogTags.writeNotificationCancel(callingUid, callingPid, pkg, id2, tag, userId, mustHaveFlags, mustNotHaveFlags, reason, listenerName);
                }
                ArrayList<NotificationRecord> arrayList = NotificationManagerService.this.mNotificationList;
                synchronized (arrayList) {
                    int index = NotificationManagerService.this.indexOfNotificationLocked(pkg, tag, id2, userId);
                    if (index >= 0) {
                        NotificationRecord r = NotificationManagerService.this.mNotificationList.get(index);
                        if (reason == 1) {
                            NotificationManagerService.this.mUsageStats.registerClickedByUser(r);
                        }
                        if ((r.getNotification().flags & mustHaveFlags) != mustHaveFlags) {
                            return;
                        }
                        if ((r.getNotification().flags & mustNotHaveFlags) != 0) {
                            return;
                        }
                        NotificationManagerService.this.mNotificationList.remove(index);
                        NotificationManagerService.this.cancelNotificationLocked(r, sendDelete, reason);
                        NotificationManagerService.this.cancelGroupChildrenLocked(r, callingUid, callingPid, listenerName, 12, sendDelete);
                        NotificationManagerService.this.updateLightsLocked();
                    }
                }
            }
        });
    }

    private boolean notificationMatchesUserId(NotificationRecord r, int userId) {
        return userId == -1 || r.getUserId() == -1 || r.getUserId() == userId;
    }

    private boolean notificationMatchesCurrentProfiles(NotificationRecord r, int userId) {
        return this.notificationMatchesUserId(r, userId) || this.mUserProfiles.isCurrentProfile(r.getUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cancelAllNotificationsInt(int callingUid, int callingPid, String pkg, int mustHaveFlags, int mustNotHaveFlags, boolean doit, int userId, int reason, ManagedServices.ManagedServiceInfo listener) {
        String listenerName = listener == null ? null : listener.component.toShortString();
        EventLogTags.writeNotificationCancelAll(callingUid, callingPid, pkg, userId, mustHaveFlags, mustNotHaveFlags, reason, listenerName);
        ArrayList<NotificationRecord> arrayList = this.mNotificationList;
        synchronized (arrayList) {
            int N = this.mNotificationList.size();
            ArrayList<NotificationRecord> canceledNotifications = null;
            for (int i = N - 1; i >= 0; --i) {
                NotificationRecord r = this.mNotificationList.get(i);
                if (!this.notificationMatchesUserId(r, userId) || r.getUserId() == -1 && pkg == null || (r.getFlags() & mustHaveFlags) != mustHaveFlags || (r.getFlags() & mustNotHaveFlags) != 0 || pkg != null && !r.sbn.getPackageName().equals(pkg)) continue;
                if (canceledNotifications == null) {
                    canceledNotifications = new ArrayList<NotificationRecord>();
                }
                canceledNotifications.add(r);
                if (!doit) {
                    return true;
                }
                this.mNotificationList.remove(i);
                this.cancelNotificationLocked(r, false, reason);
            }
            if (doit && canceledNotifications != null) {
                int M = canceledNotifications.size();
                for (int i = 0; i < M; ++i) {
                    this.cancelGroupChildrenLocked((NotificationRecord)canceledNotifications.get(i), callingUid, callingPid, listenerName, 12, false);
                }
            }
            if (canceledNotifications != null) {
                this.updateLightsLocked();
            }
            return canceledNotifications != null;
        }
    }

    void cancelAllLocked(int callingUid, int callingPid, int userId, int reason, ManagedServices.ManagedServiceInfo listener, boolean includeCurrentProfiles) {
        String listenerName = listener == null ? null : listener.component.toShortString();
        EventLogTags.writeNotificationCancelAll(callingUid, callingPid, null, userId, 0, 0, reason, listenerName);
        ArrayList<NotificationRecord> canceledNotifications = null;
        int N = this.mNotificationList.size();
        for (int i = N - 1; i >= 0; --i) {
            NotificationRecord r = this.mNotificationList.get(i);
            if ((!includeCurrentProfiles ? !this.notificationMatchesUserId(r, userId) : !this.notificationMatchesCurrentProfiles(r, userId)) || (r.getFlags() & 0x22) != 0) continue;
            this.mNotificationList.remove(i);
            this.cancelNotificationLocked(r, true, reason);
            if (canceledNotifications == null) {
                canceledNotifications = new ArrayList<NotificationRecord>();
            }
            canceledNotifications.add(r);
        }
        int M = canceledNotifications != null ? canceledNotifications.size() : 0;
        for (int i = 0; i < M; ++i) {
            this.cancelGroupChildrenLocked((NotificationRecord)canceledNotifications.get(i), callingUid, callingPid, listenerName, 12, false);
        }
        this.updateLightsLocked();
    }

    private void cancelGroupChildrenLocked(NotificationRecord r, int callingUid, int callingPid, String listenerName, int reason, boolean sendDelete) {
        Notification n = r.getNotification();
        if (!n.isGroupSummary()) {
            return;
        }
        String pkg = r.sbn.getPackageName();
        int userId = r.getUserId();
        if (pkg == null) {
            if (DBG) {
                Log.e(TAG, "No package for group summary: " + r.getKey());
            }
            return;
        }
        int N = this.mNotificationList.size();
        for (int i = N - 1; i >= 0; --i) {
            NotificationRecord childR = this.mNotificationList.get(i);
            StatusBarNotification childSbn = childR.sbn;
            if (!childSbn.isGroup() || childSbn.getNotification().isGroupSummary() || !childR.getGroupKey().equals(r.getGroupKey())) continue;
            EventLogTags.writeNotificationCancel(callingUid, callingPid, pkg, childSbn.getId(), childSbn.getTag(), userId, 0, 0, reason, listenerName);
            this.mNotificationList.remove(i);
            this.cancelNotificationLocked(childR, sendDelete, reason);
        }
    }

    void updateLightsLocked() {
        NotificationRecord ledNotification = null;
        while (ledNotification == null && !this.mLights.isEmpty()) {
            String owner = this.mLights.get(this.mLights.size() - 1);
            ledNotification = this.mNotificationsByKey.get(owner);
            if (ledNotification != null) continue;
            Slog.wtfStack(TAG, "LED Notification does not exist: " + owner);
            this.mLights.remove(owner);
        }
        if (ledNotification == null || this.mInCall || this.mScreenOn) {
            this.mNotificationLight.turnOff();
            if (this.mStatusBar != null) {
                this.mStatusBar.notificationLightOff();
            }
        } else {
            Notification ledno = ledNotification.sbn.getNotification();
            int ledARGB = ledno.ledARGB;
            int ledOnMS = ledno.ledOnMS;
            int ledOffMS = ledno.ledOffMS;
            if ((ledno.defaults & 4) != 0) {
                ledARGB = this.mDefaultNotificationColor;
                ledOnMS = this.mDefaultNotificationLedOn;
                ledOffMS = this.mDefaultNotificationLedOff;
            }
            if (this.mNotificationPulseEnabled) {
                this.mNotificationLight.setFlashing(ledARGB, 1, ledOnMS, ledOffMS);
            }
            if (this.mStatusBar != null) {
                this.mStatusBar.notificationLightPulse(ledARGB, ledOnMS, ledOffMS);
            }
        }
    }

    int indexOfNotificationLocked(String pkg, String tag, int id2, int userId) {
        ArrayList<NotificationRecord> list = this.mNotificationList;
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            NotificationRecord r = list.get(i);
            if (!this.notificationMatchesUserId(r, userId) || r.sbn.getId() != id2 || !TextUtils.equals(r.sbn.getTag(), tag) || !r.sbn.getPackageName().equals(pkg)) continue;
            return i;
        }
        return -1;
    }

    int indexOfNotificationLocked(String key) {
        int N = this.mNotificationList.size();
        for (int i = 0; i < N; ++i) {
            if (!key.equals(this.mNotificationList.get(i).getKey())) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNotificationPulse() {
        ArrayList<NotificationRecord> arrayList = this.mNotificationList;
        synchronized (arrayList) {
            this.updateLightsLocked();
        }
    }

    private static boolean isUidSystem(int uid) {
        int appid = UserHandle.getAppId(uid);
        return appid == 1000 || appid == 1001 || uid == 0;
    }

    private static boolean isCallerSystem() {
        return NotificationManagerService.isUidSystem(Binder.getCallingUid());
    }

    private static void checkCallerIsSystem() {
        if (NotificationManagerService.isCallerSystem()) {
            return;
        }
        throw new SecurityException("Disallowed call for uid " + Binder.getCallingUid());
    }

    private static void checkCallerIsSystemOrSameApp(String pkg) {
        if (NotificationManagerService.isCallerSystem()) {
            return;
        }
        NotificationManagerService.checkCallerIsSameApp(pkg);
    }

    private static void checkCallerIsSameApp(String pkg) {
        int uid = Binder.getCallingUid();
        try {
            ApplicationInfo ai = AppGlobals.getPackageManager().getApplicationInfo(pkg, 0, UserHandle.getCallingUserId());
            if (ai == null) {
                throw new SecurityException("Unknown package " + pkg);
            }
            if (!UserHandle.isSameApp(ai.uid, uid)) {
                throw new SecurityException("Calling uid " + uid + " gave package" + pkg + " which is owned by uid " + ai.uid);
            }
        }
        catch (RemoteException re) {
            throw new SecurityException("Unknown package " + pkg + "\n" + re);
        }
    }

    private static String callStateToString(int state) {
        switch (state) {
            case 0: {
                return "CALL_STATE_IDLE";
            }
            case 1: {
                return "CALL_STATE_RINGING";
            }
            case 2: {
                return "CALL_STATE_OFFHOOK";
            }
        }
        return "CALL_STATE_UNKNOWN_" + state;
    }

    private void listenForCallState() {
        TelephonyManager.from(this.getContext()).listen(new PhoneStateListener(){

            @Override
            public void onCallStateChanged(int state, String incomingNumber) {
                if (NotificationManagerService.this.mCallState == state) {
                    return;
                }
                if (DBG) {
                    Slog.d(NotificationManagerService.TAG, "Call state changed: " + NotificationManagerService.callStateToString(state));
                }
                NotificationManagerService.this.mCallState = state;
            }
        }, 32);
    }

    private NotificationRankingUpdate makeRankingUpdateLocked(ManagedServices.ManagedServiceInfo info) {
        int N = this.mNotificationList.size();
        ArrayList<String> keys = new ArrayList<String>(N);
        ArrayList<String> interceptedKeys = new ArrayList<String>(N);
        ArrayList<Integer> importance = new ArrayList<Integer>(N);
        Bundle overrideGroupKeys = new Bundle();
        Bundle visibilityOverrides = new Bundle();
        Bundle suppressedVisualEffects = new Bundle();
        Bundle explanation = new Bundle();
        for (int i = 0; i < N; ++i) {
            NotificationRecord record = this.mNotificationList.get(i);
            if (!this.isVisibleToListener(record.sbn, info)) continue;
            String key = record.sbn.getKey();
            keys.add(key);
            importance.add(record.getImportance());
            if (record.getImportanceExplanation() != null) {
                explanation.putCharSequence(key, record.getImportanceExplanation());
            }
            if (record.isIntercepted()) {
                interceptedKeys.add(key);
            }
            suppressedVisualEffects.putInt(key, record.getSuppressedVisualEffects());
            if (record.getPackageVisibilityOverride() != -1000) {
                visibilityOverrides.putInt(key, record.getPackageVisibilityOverride());
            }
            overrideGroupKeys.putString(key, record.sbn.getOverrideGroupKey());
        }
        int M = keys.size();
        String[] keysAr = keys.toArray(new String[M]);
        String[] interceptedKeysAr = interceptedKeys.toArray(new String[interceptedKeys.size()]);
        int[] importanceAr = new int[M];
        for (int i = 0; i < M; ++i) {
            importanceAr[i] = (Integer)importance.get(i);
        }
        return new NotificationRankingUpdate(keysAr, interceptedKeysAr, visibilityOverrides, suppressedVisualEffects, importanceAr, explanation, overrideGroupKeys);
    }

    private boolean isVisibleToListener(StatusBarNotification sbn, ManagedServices.ManagedServiceInfo listener) {
        return listener.enabledAndUserMatches(sbn.getUserId());
    }

    private boolean isPackageSuspendedForUser(String pkg, int uid) {
        int userId = UserHandle.getUserId(uid);
        try {
            return AppGlobals.getPackageManager().isPackageSuspendedForUser(pkg, userId);
        }
        catch (RemoteException re) {
            throw new SecurityException("Could not talk to package manager service");
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    private final class PolicyAccess {
        private static final String SEPARATOR = ":";
        private final String[] PERM = new String[]{"android.permission.ACCESS_NOTIFICATION_POLICY"};

        private PolicyAccess() {
        }

        public boolean isPackageGranted(String pkg) {
            return pkg != null && this.getGrantedPackages().contains(pkg);
        }

        public void put(String pkg, boolean granted) {
            if (pkg == null) {
                return;
            }
            ArraySet<String> pkgs = this.getGrantedPackages();
            boolean changed = granted ? pkgs.add(pkg) : pkgs.remove(pkg);
            if (!changed) {
                return;
            }
            String setting = TextUtils.join((CharSequence)SEPARATOR, pkgs);
            int currentUser = ActivityManager.getCurrentUser();
            Settings.Secure.putStringForUser(NotificationManagerService.this.getContext().getContentResolver(), "enabled_notification_policy_access_packages", setting, currentUser);
            NotificationManagerService.this.getContext().sendBroadcastAsUser(new Intent("android.app.action.NOTIFICATION_POLICY_ACCESS_GRANTED_CHANGED").setPackage(pkg).addFlags(0x40000000), new UserHandle(currentUser), null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ArraySet<String> getGrantedPackages() {
            ArraySet<String> pkgs = new ArraySet<String>();
            long identity = Binder.clearCallingIdentity();
            try {
                String setting = Settings.Secure.getStringForUser(NotificationManagerService.this.getContext().getContentResolver(), "enabled_notification_policy_access_packages", ActivityManager.getCurrentUser());
                if (setting != null) {
                    String[] tokens = setting.split(SEPARATOR);
                    for (int i = 0; i < tokens.length; ++i) {
                        String token = tokens[i];
                        if (token != null) {
                            token = token.trim();
                        }
                        if (TextUtils.isEmpty(token)) continue;
                        pkgs.add(token);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
            return pkgs;
        }

        public String[] getRequestingPackages() throws RemoteException {
            ParceledListSlice list = AppGlobals.getPackageManager().getPackagesHoldingPermissions(this.PERM, 0, ActivityManager.getCurrentUser());
            List pkgs = list.getList();
            if (pkgs == null || pkgs.isEmpty()) {
                return new String[0];
            }
            int N = pkgs.size();
            String[] rt = new String[N];
            for (int i = 0; i < N; ++i) {
                rt[i] = ((PackageInfo)pkgs.get((int)i)).packageName;
            }
            return rt;
        }
    }

    private static final class StatusBarNotificationHolder
    extends IStatusBarNotificationHolder.Stub {
        private StatusBarNotification mValue;

        public StatusBarNotificationHolder(StatusBarNotification value) {
            this.mValue = value;
        }

        @Override
        public StatusBarNotification get() {
            StatusBarNotification value = this.mValue;
            this.mValue = null;
            return value;
        }
    }

    public static final class DumpFilter {
        public boolean filtered = false;
        public String pkgFilter;
        public boolean zen;
        public long since;
        public boolean stats;
        public boolean redact = true;

        public static DumpFilter parseFromArguments(String[] args) {
            DumpFilter filter = new DumpFilter();
            for (int ai = 0; ai < args.length; ++ai) {
                String a = args[ai];
                if ("--noredact".equals(a) || "--reveal".equals(a)) {
                    filter.redact = false;
                    continue;
                }
                if ("p".equals(a) || "pkg".equals(a) || "--package".equals(a)) {
                    if (ai >= args.length - 1) continue;
                    filter.pkgFilter = args[++ai].trim().toLowerCase();
                    if (filter.pkgFilter.isEmpty()) {
                        filter.pkgFilter = null;
                        continue;
                    }
                    filter.filtered = true;
                    continue;
                }
                if ("--zen".equals(a) || "zen".equals(a)) {
                    filter.filtered = true;
                    filter.zen = true;
                    continue;
                }
                if (!"--stats".equals(a)) continue;
                filter.stats = true;
                filter.since = ai < args.length - 1 ? Long.valueOf(args[++ai]) : 0L;
            }
            return filter;
        }

        public boolean matches(StatusBarNotification sbn) {
            if (!this.filtered) {
                return true;
            }
            return this.zen ? true : sbn != null && (this.matches(sbn.getPackageName()) || this.matches(sbn.getOpPkg()));
        }

        public boolean matches(ComponentName component) {
            if (!this.filtered) {
                return true;
            }
            return this.zen ? true : component != null && this.matches(component.getPackageName());
        }

        public boolean matches(String pkg) {
            if (!this.filtered) {
                return true;
            }
            return this.zen ? true : pkg != null && pkg.toLowerCase().contains(this.pkgFilter);
        }

        public String toString() {
            return this.stats ? "stats" : (this.zen ? "zen" : '\'' + this.pkgFilter + '\'');
        }
    }

    public class NotificationListeners
    extends ManagedServices {
        private final ArraySet<ManagedServices.ManagedServiceInfo> mLightTrimListeners;

        public NotificationListeners() {
            super(NotificationManagerService.this.getContext(), NotificationManagerService.this.mHandler, NotificationManagerService.this.mNotificationList, NotificationManagerService.this.mUserProfiles);
            this.mLightTrimListeners = new ArraySet();
        }

        @Override
        protected ManagedServices.Config getConfig() {
            ManagedServices.Config c = new ManagedServices.Config();
            c.caption = "notification listener";
            c.serviceInterface = "android.service.notification.NotificationListenerService";
            c.secureSettingName = "enabled_notification_listeners";
            c.bindPermission = "android.permission.BIND_NOTIFICATION_LISTENER_SERVICE";
            c.settingsAction = "android.settings.ACTION_NOTIFICATION_LISTENER_SETTINGS";
            c.clientLabel = 17040498;
            return c;
        }

        @Override
        protected IInterface asInterface(IBinder binder) {
            return INotificationListener.Stub.asInterface(binder);
        }

        @Override
        protected boolean checkType(IInterface service) {
            return service instanceof INotificationListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceAdded(ManagedServices.ManagedServiceInfo info) {
            NotificationRankingUpdate update;
            INotificationListener listener = (INotificationListener)info.service;
            ArrayList<NotificationRecord> arrayList = NotificationManagerService.this.mNotificationList;
            synchronized (arrayList) {
                update = NotificationManagerService.this.makeRankingUpdateLocked(info);
            }
            try {
                listener.onListenerConnected(update);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        @Override
        protected void onServiceRemovedLocked(ManagedServices.ManagedServiceInfo removed) {
            if (NotificationManagerService.this.removeDisabledHints(removed)) {
                NotificationManagerService.this.updateListenerHintsLocked();
                NotificationManagerService.this.updateEffectsSuppressorLocked();
            }
            this.mLightTrimListeners.remove(removed);
        }

        public void setOnNotificationPostedTrimLocked(ManagedServices.ManagedServiceInfo info, int trim) {
            if (trim == 1) {
                this.mLightTrimListeners.add(info);
            } else {
                this.mLightTrimListeners.remove(info);
            }
        }

        public int getOnNotificationPostedTrim(ManagedServices.ManagedServiceInfo info) {
            return this.mLightTrimListeners.contains(info) ? 1 : 0;
        }

        public void notifyPostedLocked(StatusBarNotification sbn, StatusBarNotification oldSbn) {
            TrimCache trimCache = new TrimCache(sbn);
            for (final ManagedServices.ManagedServiceInfo info : this.mServices) {
                boolean oldSbnVisible;
                boolean sbnVisible = NotificationManagerService.this.isVisibleToListener(sbn, info);
                boolean bl = oldSbnVisible = oldSbn != null ? NotificationManagerService.this.isVisibleToListener(oldSbn, info) : false;
                if (!oldSbnVisible && !sbnVisible) continue;
                final NotificationRankingUpdate update = NotificationManagerService.this.makeRankingUpdateLocked(info);
                if (oldSbnVisible && !sbnVisible) {
                    final StatusBarNotification oldSbnLightClone = oldSbn.cloneLight();
                    NotificationManagerService.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            NotificationListeners.this.notifyRemoved(info, oldSbnLightClone, update);
                        }
                    });
                    continue;
                }
                final StatusBarNotification sbnToPost = trimCache.ForListener(info);
                NotificationManagerService.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        NotificationListeners.this.notifyPosted(info, sbnToPost, update);
                    }
                });
            }
        }

        public void notifyRemovedLocked(StatusBarNotification sbn) {
            final StatusBarNotification sbnLight = sbn.cloneLight();
            for (final ManagedServices.ManagedServiceInfo info : this.mServices) {
                if (!NotificationManagerService.this.isVisibleToListener(sbn, info)) continue;
                final NotificationRankingUpdate update = NotificationManagerService.this.makeRankingUpdateLocked(info);
                NotificationManagerService.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        NotificationListeners.this.notifyRemoved(info, sbnLight, update);
                    }
                });
            }
        }

        public void notifyRankingUpdateLocked() {
            for (final ManagedServices.ManagedServiceInfo serviceInfo : this.mServices) {
                if (!serviceInfo.isEnabledForCurrentProfiles()) continue;
                final NotificationRankingUpdate update = NotificationManagerService.this.makeRankingUpdateLocked(serviceInfo);
                NotificationManagerService.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        NotificationListeners.this.notifyRankingUpdate(serviceInfo, update);
                    }
                });
            }
        }

        public void notifyListenerHintsChangedLocked(final int hints) {
            for (final ManagedServices.ManagedServiceInfo serviceInfo : this.mServices) {
                if (!serviceInfo.isEnabledForCurrentProfiles()) continue;
                NotificationManagerService.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        NotificationListeners.this.notifyListenerHintsChanged(serviceInfo, hints);
                    }
                });
            }
        }

        public void notifyInterruptionFilterChanged(final int interruptionFilter) {
            for (final ManagedServices.ManagedServiceInfo serviceInfo : this.mServices) {
                if (!serviceInfo.isEnabledForCurrentProfiles()) continue;
                NotificationManagerService.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        NotificationListeners.this.notifyInterruptionFilterChanged(serviceInfo, interruptionFilter);
                    }
                });
            }
        }

        private void notifyPosted(ManagedServices.ManagedServiceInfo info, StatusBarNotification sbn, NotificationRankingUpdate rankingUpdate) {
            INotificationListener listener = (INotificationListener)info.service;
            StatusBarNotificationHolder sbnHolder = new StatusBarNotificationHolder(sbn);
            try {
                listener.onNotificationPosted(sbnHolder, rankingUpdate);
            }
            catch (RemoteException ex) {
                Log.e(this.TAG, "unable to notify listener (posted): " + listener, ex);
            }
        }

        private void notifyRemoved(ManagedServices.ManagedServiceInfo info, StatusBarNotification sbn, NotificationRankingUpdate rankingUpdate) {
            if (!info.enabledAndUserMatches(sbn.getUserId())) {
                return;
            }
            INotificationListener listener = (INotificationListener)info.service;
            StatusBarNotificationHolder sbnHolder = new StatusBarNotificationHolder(sbn);
            try {
                listener.onNotificationRemoved(sbnHolder, rankingUpdate);
            }
            catch (RemoteException ex) {
                Log.e(this.TAG, "unable to notify listener (removed): " + listener, ex);
            }
        }

        private void notifyRankingUpdate(ManagedServices.ManagedServiceInfo info, NotificationRankingUpdate rankingUpdate) {
            INotificationListener listener = (INotificationListener)info.service;
            try {
                listener.onNotificationRankingUpdate(rankingUpdate);
            }
            catch (RemoteException ex) {
                Log.e(this.TAG, "unable to notify listener (ranking update): " + listener, ex);
            }
        }

        private void notifyListenerHintsChanged(ManagedServices.ManagedServiceInfo info, int hints) {
            INotificationListener listener = (INotificationListener)info.service;
            try {
                listener.onListenerHintsChanged(hints);
            }
            catch (RemoteException ex) {
                Log.e(this.TAG, "unable to notify listener (listener hints): " + listener, ex);
            }
        }

        private void notifyInterruptionFilterChanged(ManagedServices.ManagedServiceInfo info, int interruptionFilter) {
            INotificationListener listener = (INotificationListener)info.service;
            try {
                listener.onInterruptionFilterChanged(interruptionFilter);
            }
            catch (RemoteException ex) {
                Log.e(this.TAG, "unable to notify listener (interruption filter): " + listener, ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isListenerPackage(String packageName) {
            if (packageName == null) {
                return false;
            }
            ArrayList<NotificationRecord> arrayList = NotificationManagerService.this.mNotificationList;
            synchronized (arrayList) {
                for (ManagedServices.ManagedServiceInfo serviceInfo : this.mServices) {
                    if (!packageName.equals(serviceInfo.component.getPackageName())) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public class NotificationRankers
    extends ManagedServices {
        public NotificationRankers() {
            super(NotificationManagerService.this.getContext(), NotificationManagerService.this.mHandler, NotificationManagerService.this.mNotificationList, NotificationManagerService.this.mUserProfiles);
        }

        @Override
        protected ManagedServices.Config getConfig() {
            ManagedServices.Config c = new ManagedServices.Config();
            c.caption = "notification ranker service";
            c.serviceInterface = "android.service.notification.NotificationRankerService";
            c.secureSettingName = null;
            c.bindPermission = "android.permission.BIND_NOTIFICATION_RANKER_SERVICE";
            c.settingsAction = "android.settings.MANAGE_DEFAULT_APPS_SETTINGS";
            c.clientLabel = 17040501;
            return c;
        }

        @Override
        protected IInterface asInterface(IBinder binder) {
            return INotificationListener.Stub.asInterface(binder);
        }

        @Override
        protected boolean checkType(IInterface service) {
            return service instanceof INotificationListener;
        }

        @Override
        protected void onServiceAdded(ManagedServices.ManagedServiceInfo info) {
            NotificationManagerService.this.mListeners.registerGuestService(info);
        }

        @Override
        protected void onServiceRemovedLocked(ManagedServices.ManagedServiceInfo removed) {
            NotificationManagerService.this.mListeners.unregisterService(removed.service, removed.userid);
        }

        public void onNotificationEnqueued(NotificationRecord r) {
            StatusBarNotification sbn = r.sbn;
            TrimCache trimCache = new TrimCache(sbn);
            for (final ManagedServices.ManagedServiceInfo info : this.mServices) {
                boolean sbnVisible = NotificationManagerService.this.isVisibleToListener(sbn, info);
                if (!sbnVisible) continue;
                final int importance = r.getImportance();
                final boolean fromUser = r.isImportanceFromUser();
                final StatusBarNotification sbnToPost = trimCache.ForListener(info);
                NotificationManagerService.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        NotificationRankers.this.notifyEnqueued(info, sbnToPost, importance, fromUser);
                    }
                });
            }
        }

        private void notifyEnqueued(ManagedServices.ManagedServiceInfo info, StatusBarNotification sbn, int importance, boolean fromUser) {
            INotificationListener ranker = (INotificationListener)info.service;
            StatusBarNotificationHolder sbnHolder = new StatusBarNotificationHolder(sbn);
            try {
                ranker.onNotificationEnqueued(sbnHolder, importance, fromUser);
            }
            catch (RemoteException ex) {
                Log.e(this.TAG, "unable to notify ranker (enqueued): " + ranker, ex);
            }
        }

        public boolean isEnabled() {
            return !this.mServices.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUserSwitched(int user) {
            ArrayList<NotificationRecord> arrayList = NotificationManagerService.this.mNotificationList;
            synchronized (arrayList) {
                int i = this.mServices.size() - 1;
                while (i-- > 0) {
                    ManagedServices.ManagedServiceInfo info = (ManagedServices.ManagedServiceInfo)this.mServices.get(i);
                    this.unregisterService(info.service, info.userid);
                }
            }
            this.registerRanker();
        }

        @Override
        public void onPackagesChanged(boolean removingPackage, String[] pkgList) {
            if (this.DEBUG) {
                Slog.d(this.TAG, "onPackagesChanged removingPackage=" + removingPackage + " pkgList=" + (pkgList == null ? null : Arrays.asList(pkgList)));
            }
            if (NotificationManagerService.this.mRankerServicePackageName == null) {
                return;
            }
            if (pkgList != null && pkgList.length > 0 && !removingPackage) {
                for (String pkgName : pkgList) {
                    if (!NotificationManagerService.this.mRankerServicePackageName.equals(pkgName)) continue;
                    this.registerRanker();
                }
            }
        }

        protected void registerRanker() {
            if (NotificationManagerService.this.mRankerServicePackageName == null) {
                Slog.w(this.TAG, "could not start ranker service: no package specified!");
                return;
            }
            Set<ComponentName> rankerComponents = this.queryPackageForServices(NotificationManagerService.this.mRankerServicePackageName, 0);
            Iterator<ComponentName> iterator = rankerComponents.iterator();
            if (iterator.hasNext()) {
                ComponentName rankerComponent = iterator.next();
                if (iterator.hasNext()) {
                    Slog.e(this.TAG, "found multiple ranker services:" + rankerComponents);
                } else {
                    this.registerSystemService(rankerComponent, 0);
                }
            } else {
                Slog.w(this.TAG, "could not start ranker service: none found");
            }
        }
    }

    private class TrimCache {
        StatusBarNotification heavy;
        StatusBarNotification sbnClone;
        StatusBarNotification sbnCloneLight;

        TrimCache(StatusBarNotification sbn) {
            this.heavy = sbn;
        }

        StatusBarNotification ForListener(ManagedServices.ManagedServiceInfo info) {
            if (NotificationManagerService.this.mListeners.getOnNotificationPostedTrim(info) == 1) {
                if (this.sbnCloneLight == null) {
                    this.sbnCloneLight = this.heavy.cloneLight();
                }
                return this.sbnCloneLight;
            }
            if (this.sbnClone == null) {
                this.sbnClone = this.heavy.clone();
            }
            return this.sbnClone;
        }
    }

    private final class RankingHandlerWorker
    extends Handler
    implements RankingHandler {
        public RankingHandlerWorker(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1000: {
                    NotificationManagerService.this.handleRankingReconsideration(msg);
                    break;
                }
                case 1001: {
                    NotificationManagerService.this.handleRankingSort();
                }
            }
        }

        @Override
        public void requestSort() {
            this.removeMessages(1001);
            this.sendEmptyMessage(1001);
        }

        @Override
        public void requestReconsideration(RankingReconsideration recon) {
            Message m = Message.obtain(this, 1000, recon);
            long delay = recon.getDelay(TimeUnit.MILLISECONDS);
            this.sendMessageDelayed(m, delay);
        }
    }

    private final class WorkerHandler
    extends Handler {
        private WorkerHandler() {
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    NotificationManagerService.this.handleTimeout((ToastRecord)msg.obj);
                    break;
                }
                case 3: {
                    NotificationManagerService.this.handleSavePolicyFile();
                    break;
                }
                case 4: {
                    NotificationManagerService.this.handleSendRankingUpdate();
                    break;
                }
                case 5: {
                    NotificationManagerService.this.handleListenerHintsChanged(msg.arg1);
                    break;
                }
                case 6: {
                    NotificationManagerService.this.handleListenerInterruptionFilterChanged(msg.arg1);
                }
            }
        }
    }

    private class EnqueueNotificationRunnable
    implements Runnable {
        private final NotificationRecord r;
        private final int userId;

        EnqueueNotificationRunnable(int userId, NotificationRecord r) {
            this.userId = userId;
            this.r = r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<NotificationRecord> arrayList = NotificationManagerService.this.mNotificationList;
            synchronized (arrayList) {
                int index;
                NotificationRecord old;
                StatusBarNotification n = this.r.sbn;
                if (DBG) {
                    Slog.d(NotificationManagerService.TAG, "EnqueueNotificationRunnable.run for: " + n.getKey());
                }
                if ((old = NotificationManagerService.this.mNotificationsByKey.get(n.getKey())) != null) {
                    this.r.copyRankingInformation(old);
                }
                int callingUid = n.getUid();
                int callingPid = n.getInitialPid();
                Notification notification = n.getNotification();
                String pkg = n.getPackageName();
                int id2 = n.getId();
                String tag = n.getTag();
                boolean isSystemNotification = NotificationManagerService.isUidSystem(callingUid) || "android".equals(pkg);
                NotificationManagerService.this.handleGroupedNotificationLocked(this.r, old, callingUid, callingPid);
                if (!pkg.equals("com.android.providers.downloads") || Log.isLoggable("DownloadManager", 2)) {
                    int enqueueStatus = 0;
                    if (old != null) {
                        enqueueStatus = 1;
                    }
                    EventLogTags.writeNotificationEnqueue(callingUid, callingPid, pkg, id2, tag, this.userId, notification.toString(), enqueueStatus);
                }
                NotificationManagerService.this.mRankingHelper.extractSignals(this.r);
                boolean isPackageSuspended = NotificationManagerService.this.isPackageSuspendedForUser(pkg, callingUid);
                if (!(this.r.getImportance() != 0 && NotificationManagerService.this.noteNotificationOp(pkg, callingUid) && !isPackageSuspended || isSystemNotification)) {
                    if (isPackageSuspended) {
                        Slog.e(NotificationManagerService.TAG, "Suppressing notification from package due to package suspended by administrator.");
                        NotificationManagerService.this.mUsageStats.registerSuspendedByAdmin(this.r);
                    } else {
                        Slog.e(NotificationManagerService.TAG, "Suppressing notification from package by user request.");
                        NotificationManagerService.this.mUsageStats.registerBlocked(this.r);
                    }
                    return;
                }
                if (NotificationManagerService.this.mRankerServices.isEnabled()) {
                    NotificationManagerService.this.mRankerServices.onNotificationEnqueued(this.r);
                }
                if ((index = NotificationManagerService.this.indexOfNotificationLocked(n.getKey())) < 0) {
                    NotificationManagerService.this.mNotificationList.add(this.r);
                    NotificationManagerService.this.mUsageStats.registerPostedByApp(this.r);
                } else {
                    old = NotificationManagerService.this.mNotificationList.get(index);
                    NotificationManagerService.this.mNotificationList.set(index, this.r);
                    NotificationManagerService.this.mUsageStats.registerUpdatedByApp(this.r, old);
                    notification.flags |= old.getNotification().flags & 0x40;
                    this.r.isUpdate = true;
                }
                NotificationManagerService.this.mNotificationsByKey.put(n.getKey(), this.r);
                if ((notification.flags & 0x40) != 0) {
                    notification.flags |= 0x22;
                }
                NotificationManagerService.this.applyZenModeLocked(this.r);
                NotificationManagerService.this.mRankingHelper.sort(NotificationManagerService.this.mNotificationList);
                if (notification.getSmallIcon() != null) {
                    StatusBarNotification oldSbn = old != null ? old.sbn : null;
                    NotificationManagerService.this.mListeners.notifyPostedLocked(n, oldSbn);
                } else {
                    Slog.e(NotificationManagerService.TAG, "Not posting notification without small icon: " + notification);
                    if (old != null && !old.isCanceled) {
                        NotificationManagerService.this.mListeners.notifyRemovedLocked(n);
                    }
                    Slog.e(NotificationManagerService.TAG, "WARNING: In a future release this will crash the app: " + n.getPackageName());
                }
                NotificationManagerService.this.buzzBeepBlinkLocked(this.r);
            }
        }
    }

    private final class SettingsObserver
    extends ContentObserver {
        private final Uri NOTIFICATION_LIGHT_PULSE_URI;
        private final Uri NOTIFICATION_SOUND_URI;
        private final Uri NOTIFICATION_RATE_LIMIT_URI;

        SettingsObserver(Handler handler) {
            super(handler);
            this.NOTIFICATION_LIGHT_PULSE_URI = Settings.System.getUriFor("notification_light_pulse");
            this.NOTIFICATION_SOUND_URI = Settings.System.getUriFor("notification_sound");
            this.NOTIFICATION_RATE_LIMIT_URI = Settings.Global.getUriFor("max_notification_enqueue_rate");
        }

        void observe() {
            ContentResolver resolver = NotificationManagerService.this.getContext().getContentResolver();
            resolver.registerContentObserver(this.NOTIFICATION_LIGHT_PULSE_URI, false, this, -1);
            resolver.registerContentObserver(this.NOTIFICATION_SOUND_URI, false, this, -1);
            resolver.registerContentObserver(this.NOTIFICATION_RATE_LIMIT_URI, false, this, -1);
            this.update(null);
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            this.update(uri);
        }

        public void update(Uri uri) {
            ContentResolver resolver = NotificationManagerService.this.getContext().getContentResolver();
            if (uri == null || this.NOTIFICATION_LIGHT_PULSE_URI.equals(uri)) {
                boolean pulseEnabled;
                boolean bl = pulseEnabled = Settings.System.getInt(resolver, "notification_light_pulse", 0) != 0;
                if (NotificationManagerService.this.mNotificationPulseEnabled != pulseEnabled) {
                    NotificationManagerService.this.mNotificationPulseEnabled = pulseEnabled;
                    NotificationManagerService.this.updateNotificationPulse();
                }
            }
            if (uri == null || this.NOTIFICATION_RATE_LIMIT_URI.equals(uri)) {
                NotificationManagerService.this.mMaxPackageEnqueueRate = Settings.Global.getFloat(resolver, "max_notification_enqueue_rate", NotificationManagerService.this.mMaxPackageEnqueueRate);
            }
            if (uri == null || this.NOTIFICATION_SOUND_URI.equals(uri)) {
                NotificationManagerService.this.mSystemNotificationSound = Settings.System.getString(resolver, "notification_sound");
            }
        }
    }

    private static final class ToastRecord {
        final int pid;
        final String pkg;
        final ITransientNotification callback;
        int duration;

        ToastRecord(int pid, String pkg, ITransientNotification callback, int duration) {
            this.pid = pid;
            this.pkg = pkg;
            this.callback = callback;
            this.duration = duration;
        }

        void update(int duration) {
            this.duration = duration;
        }

        void dump(PrintWriter pw, String prefix, DumpFilter filter) {
            if (filter != null && !filter.matches(this.pkg)) {
                return;
            }
            pw.println(prefix + this);
        }

        public final String toString() {
            return "ToastRecord{" + Integer.toHexString(System.identityHashCode(this)) + " pkg=" + this.pkg + " callback=" + this.callback + " duration=" + this.duration;
        }
    }

    private static class Archive {
        final int mBufferSize;
        final ArrayDeque<StatusBarNotification> mBuffer;

        public Archive(int size) {
            this.mBufferSize = size;
            this.mBuffer = new ArrayDeque(this.mBufferSize);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            int N = this.mBuffer.size();
            sb.append("Archive (");
            sb.append(N);
            sb.append(" notification");
            sb.append(N == 1 ? ")" : "s)");
            return sb.toString();
        }

        public void record(StatusBarNotification nr) {
            if (this.mBuffer.size() == this.mBufferSize) {
                this.mBuffer.removeFirst();
            }
            this.mBuffer.addLast(nr.cloneLight());
        }

        public Iterator<StatusBarNotification> descendingIterator() {
            return this.mBuffer.descendingIterator();
        }

        public StatusBarNotification[] getArray(int count) {
            if (count == 0) {
                count = this.mBufferSize;
            }
            StatusBarNotification[] a = new StatusBarNotification[Math.min(count, this.mBuffer.size())];
            Iterator<StatusBarNotification> iter = this.descendingIterator();
            int i = 0;
            while (iter.hasNext() && i < count) {
                a[i++] = iter.next();
            }
            return a;
        }
    }
}

