/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Binder;
import android.provider.Settings;
import android.service.notification.Condition;
import android.service.notification.IConditionProvider;
import android.service.notification.ZenModeConfig;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import com.android.server.notification.NotificationManagerService;
import com.android.server.notification.ScheduleCalendar;
import com.android.server.notification.SystemConditionProviderService;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.TimeZone;

public class ScheduleConditionProvider
extends SystemConditionProviderService {
    static final String TAG = "ConditionProviders.SCP";
    static final boolean DEBUG = true;
    public static final ComponentName COMPONENT = new ComponentName("android", ScheduleConditionProvider.class.getName());
    private static final String NOT_SHOWN = "...";
    private static final String SIMPLE_NAME = ScheduleConditionProvider.class.getSimpleName();
    private static final String ACTION_EVALUATE = SIMPLE_NAME + ".EVALUATE";
    private static final int REQUEST_CODE_EVALUATE = 1;
    private static final String EXTRA_TIME = "time";
    private static final String SEPARATOR = ";";
    private static final String SCP_SETTING = "snoozed_schedule_condition_provider";
    private final Context mContext = this;
    private final ArrayMap<Uri, ScheduleCalendar> mSubscriptions = new ArrayMap();
    private ArraySet<Uri> mSnoozed = new ArraySet();
    private AlarmManager mAlarmManager;
    private boolean mConnected;
    private boolean mRegistered;
    private long mNextAlarmTime;
    private BroadcastReceiver mReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (DEBUG) {
                Slog.d(ScheduleConditionProvider.TAG, "onReceive " + intent.getAction());
            }
            if ("android.intent.action.TIMEZONE_CHANGED".equals(intent.getAction())) {
                for (Uri conditionId : ScheduleConditionProvider.this.mSubscriptions.keySet()) {
                    ScheduleCalendar cal = (ScheduleCalendar)ScheduleConditionProvider.this.mSubscriptions.get(conditionId);
                    if (cal == null) continue;
                    cal.setTimeZone(Calendar.getInstance().getTimeZone());
                }
            }
            ScheduleConditionProvider.this.evaluateSubscriptions();
        }
    };

    public ScheduleConditionProvider() {
        if (DEBUG) {
            Slog.d(TAG, "new " + SIMPLE_NAME + "()");
        }
    }

    @Override
    public ComponentName getComponent() {
        return COMPONENT;
    }

    @Override
    public boolean isValidConditionId(Uri id2) {
        return ZenModeConfig.isValidScheduleConditionId(id2);
    }

    @Override
    public void dump(PrintWriter pw, NotificationManagerService.DumpFilter filter) {
        pw.print("    ");
        pw.print(SIMPLE_NAME);
        pw.println(":");
        pw.print("      mConnected=");
        pw.println(this.mConnected);
        pw.print("      mRegistered=");
        pw.println(this.mRegistered);
        pw.println("      mSubscriptions=");
        long now = System.currentTimeMillis();
        for (Uri conditionId : this.mSubscriptions.keySet()) {
            pw.print("        ");
            pw.print(this.meetsSchedule(this.mSubscriptions.get(conditionId), now) ? "* " : "  ");
            pw.println(conditionId);
            pw.print("            ");
            pw.println(this.mSubscriptions.get(conditionId).toString());
        }
        pw.println("      snoozed due to alarm: " + TextUtils.join((CharSequence)SEPARATOR, this.mSnoozed));
        ScheduleConditionProvider.dumpUpcomingTime(pw, "mNextAlarmTime", this.mNextAlarmTime, now);
    }

    @Override
    public void onConnected() {
        if (DEBUG) {
            Slog.d(TAG, "onConnected");
        }
        this.mConnected = true;
        this.readSnoozed();
    }

    @Override
    public void onBootComplete() {
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (DEBUG) {
            Slog.d(TAG, "onDestroy");
        }
        this.mConnected = false;
    }

    @Override
    public void onSubscribe(Uri conditionId) {
        if (DEBUG) {
            Slog.d(TAG, "onSubscribe " + conditionId);
        }
        if (!ZenModeConfig.isValidScheduleConditionId(conditionId)) {
            this.notifyCondition(conditionId, 0, "badCondition");
            return;
        }
        this.mSubscriptions.put(conditionId, ScheduleConditionProvider.toScheduleCalendar(conditionId));
        this.evaluateSubscriptions();
    }

    @Override
    public void onUnsubscribe(Uri conditionId) {
        if (DEBUG) {
            Slog.d(TAG, "onUnsubscribe " + conditionId);
        }
        this.mSubscriptions.remove(conditionId);
        this.removeSnoozed(conditionId);
        this.evaluateSubscriptions();
    }

    @Override
    public void attachBase(Context base) {
        this.attachBaseContext(base);
    }

    @Override
    public IConditionProvider asInterface() {
        return (IConditionProvider)((Object)this.onBind(null));
    }

    private void evaluateSubscriptions() {
        if (this.mAlarmManager == null) {
            this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        }
        this.setRegistered(!this.mSubscriptions.isEmpty());
        long now = System.currentTimeMillis();
        this.mNextAlarmTime = 0L;
        long nextUserAlarmTime = this.getNextAlarm();
        for (Uri conditionId : this.mSubscriptions.keySet()) {
            long nextChangeTime;
            ScheduleCalendar cal = this.mSubscriptions.get(conditionId);
            if (cal != null && cal.isInSchedule(now)) {
                if (this.conditionSnoozed(conditionId) || cal.shouldExitForAlarm(now)) {
                    this.notifyCondition(conditionId, 0, "alarmCanceled");
                    this.addSnoozed(conditionId);
                } else {
                    this.notifyCondition(conditionId, 1, "meetsSchedule");
                }
                cal.maybeSetNextAlarm(now, nextUserAlarmTime);
            } else {
                this.notifyCondition(conditionId, 0, "!meetsSchedule");
                this.removeSnoozed(conditionId);
                if (nextUserAlarmTime == 0L) {
                    cal.maybeSetNextAlarm(now, nextUserAlarmTime);
                }
            }
            if (cal == null || (nextChangeTime = cal.getNextChangeTime(now)) <= 0L || nextChangeTime <= now || this.mNextAlarmTime != 0L && nextChangeTime >= this.mNextAlarmTime) continue;
            this.mNextAlarmTime = nextChangeTime;
        }
        this.updateAlarm(now, this.mNextAlarmTime);
    }

    private void updateAlarm(long now, long time) {
        AlarmManager alarms = (AlarmManager)this.mContext.getSystemService("alarm");
        PendingIntent pendingIntent = PendingIntent.getBroadcast(this.mContext, 1, new Intent(ACTION_EVALUATE).addFlags(0x10000000).putExtra(EXTRA_TIME, time), 0x8000000);
        alarms.cancel(pendingIntent);
        if (time > now) {
            if (DEBUG) {
                Slog.d(TAG, String.format("Scheduling evaluate for %s, in %s, now=%s", ScheduleConditionProvider.ts(time), ScheduleConditionProvider.formatDuration(time - now), ScheduleConditionProvider.ts(now)));
            }
            alarms.setExact(0, time, pendingIntent);
        } else if (DEBUG) {
            Slog.d(TAG, "Not scheduling evaluate");
        }
    }

    public long getNextAlarm() {
        AlarmManager.AlarmClockInfo info = this.mAlarmManager.getNextAlarmClock(ActivityManager.getCurrentUser());
        return info != null ? info.getTriggerTime() : 0L;
    }

    private boolean meetsSchedule(ScheduleCalendar cal, long time) {
        return cal != null && cal.isInSchedule(time);
    }

    private static ScheduleCalendar toScheduleCalendar(Uri conditionId) {
        ZenModeConfig.ScheduleInfo schedule = ZenModeConfig.tryParseScheduleConditionId(conditionId);
        if (schedule == null || schedule.days == null || schedule.days.length == 0) {
            return null;
        }
        ScheduleCalendar sc = new ScheduleCalendar();
        sc.setSchedule(schedule);
        sc.setTimeZone(TimeZone.getDefault());
        return sc;
    }

    private void setRegistered(boolean registered) {
        if (this.mRegistered == registered) {
            return;
        }
        if (DEBUG) {
            Slog.d(TAG, "setRegistered " + registered);
        }
        this.mRegistered = registered;
        if (this.mRegistered) {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.TIME_SET");
            filter.addAction("android.intent.action.TIMEZONE_CHANGED");
            filter.addAction(ACTION_EVALUATE);
            filter.addAction("android.app.action.NEXT_ALARM_CLOCK_CHANGED");
            this.registerReceiver(this.mReceiver, filter);
        } else {
            this.unregisterReceiver(this.mReceiver);
        }
    }

    private void notifyCondition(Uri conditionId, int state, String reason) {
        if (DEBUG) {
            Slog.d(TAG, "notifyCondition " + conditionId + " " + Condition.stateToString(state) + " reason=" + reason);
        }
        this.notifyCondition(this.createCondition(conditionId, state));
    }

    private Condition createCondition(Uri id2, int state) {
        String summary = NOT_SHOWN;
        String line1 = NOT_SHOWN;
        String line2 = NOT_SHOWN;
        return new Condition(id2, NOT_SHOWN, NOT_SHOWN, NOT_SHOWN, 0, state, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean conditionSnoozed(Uri conditionId) {
        ArraySet<Uri> arraySet = this.mSnoozed;
        synchronized (arraySet) {
            return this.mSnoozed.contains(conditionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSnoozed(Uri conditionId) {
        ArraySet<Uri> arraySet = this.mSnoozed;
        synchronized (arraySet) {
            this.mSnoozed.add(conditionId);
            this.saveSnoozedLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSnoozed(Uri conditionId) {
        ArraySet<Uri> arraySet = this.mSnoozed;
        synchronized (arraySet) {
            this.mSnoozed.remove(conditionId);
            this.saveSnoozedLocked();
        }
    }

    public void saveSnoozedLocked() {
        String setting = TextUtils.join((CharSequence)SEPARATOR, this.mSnoozed);
        int currentUser = ActivityManager.getCurrentUser();
        Settings.Secure.putStringForUser(this.mContext.getContentResolver(), SCP_SETTING, setting, currentUser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readSnoozed() {
        ArraySet<Uri> arraySet = this.mSnoozed;
        synchronized (arraySet) {
            long identity = Binder.clearCallingIdentity();
            try {
                String setting = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), SCP_SETTING, ActivityManager.getCurrentUser());
                if (setting != null) {
                    String[] tokens = setting.split(SEPARATOR);
                    for (int i = 0; i < tokens.length; ++i) {
                        String token = tokens[i];
                        if (token != null) {
                            token = token.trim();
                        }
                        if (TextUtils.isEmpty(token)) continue;
                        this.mSnoozed.add(Uri.parse(token));
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }
}

