/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.content.ComponentName;
import android.net.Uri;
import android.service.notification.Condition;
import android.service.notification.IConditionProvider;
import android.service.notification.ZenModeConfig;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import com.android.server.notification.ConditionProviders;
import com.android.server.notification.CountdownConditionProvider;
import com.android.server.notification.EventConditionProvider;
import com.android.server.notification.ScheduleConditionProvider;
import com.android.server.notification.SystemConditionProviderService;
import com.android.server.notification.ZenModeHelper;
import java.io.PrintWriter;
import java.util.Objects;

public class ZenModeConditions
implements ConditionProviders.Callback {
    private static final String TAG = "ZenModeHelper";
    private static final boolean DEBUG = ZenModeHelper.DEBUG;
    private final ZenModeHelper mHelper;
    private final ConditionProviders mConditionProviders;
    private final ArrayMap<Uri, ComponentName> mSubscriptions = new ArrayMap();
    private boolean mFirstEvaluation = true;

    public ZenModeConditions(ZenModeHelper helper, ConditionProviders conditionProviders) {
        this.mHelper = helper;
        this.mConditionProviders = conditionProviders;
        if (this.mConditionProviders.isSystemProviderEnabled("countdown")) {
            this.mConditionProviders.addSystemProvider(new CountdownConditionProvider());
        }
        if (this.mConditionProviders.isSystemProviderEnabled("schedule")) {
            this.mConditionProviders.addSystemProvider(new ScheduleConditionProvider());
        }
        if (this.mConditionProviders.isSystemProviderEnabled("event")) {
            this.mConditionProviders.addSystemProvider(new EventConditionProvider());
        }
        this.mConditionProviders.setCallback(this);
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.print("mSubscriptions=");
        pw.println(this.mSubscriptions);
    }

    public void evaluateConfig(ZenModeConfig config, boolean processSubscriptions) {
        if (config == null) {
            return;
        }
        if (config.manualRule != null && config.manualRule.condition != null && !config.manualRule.isTrueOrUnknown()) {
            if (DEBUG) {
                Log.d(TAG, "evaluateConfig: clearing manual rule");
            }
            config.manualRule = null;
        }
        ArraySet<Uri> current = new ArraySet<Uri>();
        this.evaluateRule(config.manualRule, current, processSubscriptions);
        for (ZenModeConfig.ZenRule automaticRule : config.automaticRules.values()) {
            this.evaluateRule(automaticRule, current, processSubscriptions);
            this.updateSnoozing(automaticRule);
        }
        int N = this.mSubscriptions.size();
        for (int i = N - 1; i >= 0; --i) {
            Uri id2 = this.mSubscriptions.keyAt(i);
            ComponentName component = this.mSubscriptions.valueAt(i);
            if (!processSubscriptions || current.contains(id2)) continue;
            this.mConditionProviders.unsubscribeIfNecessary(component, id2);
            this.mSubscriptions.removeAt(i);
        }
        this.mFirstEvaluation = false;
    }

    @Override
    public void onBootComplete() {
    }

    @Override
    public void onUserSwitched() {
    }

    @Override
    public void onServiceAdded(ComponentName component) {
        if (DEBUG) {
            Log.d(TAG, "onServiceAdded " + component);
        }
        this.mHelper.setConfigAsync(this.mHelper.getConfig(), "zmc.onServiceAdded");
    }

    @Override
    public void onConditionChanged(Uri id2, Condition condition) {
        ZenModeConfig config;
        if (DEBUG) {
            Log.d(TAG, "onConditionChanged " + id2 + " " + condition);
        }
        if ((config = this.mHelper.getConfig()) == null) {
            return;
        }
        boolean updated = this.updateCondition(id2, condition, config.manualRule);
        for (ZenModeConfig.ZenRule automaticRule : config.automaticRules.values()) {
            updated |= this.updateCondition(id2, condition, automaticRule);
            updated |= this.updateSnoozing(automaticRule);
        }
        if (updated) {
            this.mHelper.setConfigAsync(config, "conditionChanged");
        }
    }

    private void evaluateRule(ZenModeConfig.ZenRule rule, ArraySet<Uri> current, boolean processSubscriptions) {
        if (rule == null || rule.conditionId == null) {
            return;
        }
        Uri id2 = rule.conditionId;
        boolean isSystemCondition = false;
        for (SystemConditionProviderService sp : this.mConditionProviders.getSystemProviders()) {
            if (!sp.isValidConditionId(id2)) continue;
            this.mConditionProviders.ensureRecordExists(sp.getComponent(), id2, sp.asInterface());
            rule.component = sp.getComponent();
            isSystemCondition = true;
        }
        if (!isSystemCondition) {
            IConditionProvider cp = this.mConditionProviders.findConditionProvider(rule.component);
            if (DEBUG) {
                Log.d(TAG, "Ensure external rule exists: " + (cp != null) + " for " + id2);
            }
            if (cp != null) {
                this.mConditionProviders.ensureRecordExists(rule.component, id2, cp);
            }
        }
        if (rule.component == null) {
            Log.w(TAG, "No component found for automatic rule: " + rule.conditionId);
            rule.enabled = false;
            return;
        }
        if (current != null) {
            current.add(id2);
        }
        if (processSubscriptions) {
            if (this.mConditionProviders.subscribeIfNecessary(rule.component, rule.conditionId)) {
                this.mSubscriptions.put(rule.conditionId, rule.component);
            } else {
                rule.condition = null;
                if (DEBUG) {
                    Log.d(TAG, "zmc failed to subscribe");
                }
            }
        }
        if (rule.condition == null) {
            rule.condition = this.mConditionProviders.findCondition(rule.component, rule.conditionId);
            if (rule.condition != null && DEBUG) {
                Log.d(TAG, "Found existing condition for: " + rule.conditionId);
            }
        }
    }

    private boolean isAutomaticActive(ComponentName component) {
        if (component == null) {
            return false;
        }
        ZenModeConfig config = this.mHelper.getConfig();
        if (config == null) {
            return false;
        }
        for (ZenModeConfig.ZenRule rule : config.automaticRules.values()) {
            if (!component.equals(rule.component) || !rule.isAutomaticActive()) continue;
            return true;
        }
        return false;
    }

    private boolean updateSnoozing(ZenModeConfig.ZenRule rule) {
        if (rule != null && rule.snoozing && (this.mFirstEvaluation || !rule.isTrueOrUnknown())) {
            rule.snoozing = false;
            if (DEBUG) {
                Log.d(TAG, "Snoozing reset for " + rule.conditionId);
            }
            return true;
        }
        return false;
    }

    private boolean updateCondition(Uri id2, Condition condition, ZenModeConfig.ZenRule rule) {
        if (id2 == null || rule == null || rule.conditionId == null) {
            return false;
        }
        if (!rule.conditionId.equals(id2)) {
            return false;
        }
        if (Objects.equals(condition, rule.condition)) {
            return false;
        }
        rule.condition = condition;
        return true;
    }
}

