/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.IEphemeralResolver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.EphemeralResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.TimedRemoteCaller;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;

final class EphemeralResolverConnection {
    private static final long BIND_SERVICE_TIMEOUT_MS = "eng".equals(Build.TYPE) ? 300L : 200L;
    private final Object mLock = new Object();
    private final GetEphemeralResolveInfoCaller mGetEphemeralResolveInfoCaller = new GetEphemeralResolveInfoCaller();
    private final ServiceConnection mServiceConnection = new MyServiceConnection();
    private final Context mContext;
    private final Intent mIntent;
    private IEphemeralResolver mRemoteInstance;

    public EphemeralResolverConnection(Context context, ComponentName componentName) {
        this.mContext = context;
        this.mIntent = new Intent().setComponent(componentName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<EphemeralResolveInfo> getEphemeralResolveInfoList(int[] hashPrefix, int prefixMask) {
        this.throwIfCalledOnMainThread();
        try {
            List<EphemeralResolveInfo> list = this.mGetEphemeralResolveInfoCaller.getEphemeralResolveInfoList(this.getRemoteInstanceLazy(), hashPrefix, prefixMask);
            return list;
        }
        catch (RemoteException remoteException) {
            Object object = this.mLock;
            synchronized (object) {
                this.mLock.notifyAll();
            }
        }
        catch (TimeoutException timeoutException) {
            Object object = this.mLock;
            synchronized (object) {
                this.mLock.notifyAll();
            }
        }
        finally {
            Object object = this.mLock;
            synchronized (object) {
                this.mLock.notifyAll();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(FileDescriptor fd, PrintWriter pw, String prefix) {
        Object object = this.mLock;
        synchronized (object) {
            pw.append(prefix).append("bound=").append(this.mRemoteInstance != null ? "true" : "false").println();
            pw.flush();
            try {
                this.getRemoteInstanceLazy().asBinder().dump(fd, new String[]{prefix});
            }
            catch (TimeoutException timeoutException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IEphemeralResolver getRemoteInstanceLazy() throws TimeoutException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mRemoteInstance != null) {
                return this.mRemoteInstance;
            }
            this.bindLocked();
            return this.mRemoteInstance;
        }
    }

    private void bindLocked() throws TimeoutException {
        if (this.mRemoteInstance != null) {
            return;
        }
        this.mContext.bindServiceAsUser(this.mIntent, this.mServiceConnection, 0x4000001, UserHandle.SYSTEM);
        long startMillis = SystemClock.uptimeMillis();
        while (this.mRemoteInstance == null) {
            long elapsedMillis = SystemClock.uptimeMillis() - startMillis;
            long remainingMillis = BIND_SERVICE_TIMEOUT_MS - elapsedMillis;
            if (remainingMillis <= 0L) {
                throw new TimeoutException("Didn't bind to resolver in time.");
            }
            try {
                this.mLock.wait(remainingMillis);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.mLock.notifyAll();
    }

    private void throwIfCalledOnMainThread() {
        if (Thread.currentThread() == this.mContext.getMainLooper().getThread()) {
            throw new RuntimeException("Cannot invoke on the main thread");
        }
    }

    private static final class GetEphemeralResolveInfoCaller
    extends TimedRemoteCaller<List<EphemeralResolveInfo>> {
        private final IRemoteCallback mCallback = new IRemoteCallback.Stub(){

            @Override
            public void sendResult(Bundle data) throws RemoteException {
                ArrayList resolveList = data.getParcelableArrayList("android.app.extra.RESOLVE_INFO");
                int sequence = data.getInt("android.app.extra.SEQUENCE", -1);
                this.onRemoteMethodResult(resolveList, sequence);
            }
        };

        public GetEphemeralResolveInfoCaller() {
            super(5000L);
        }

        public List<EphemeralResolveInfo> getEphemeralResolveInfoList(IEphemeralResolver target, int[] hashPrefix, int prefixMask) throws RemoteException, TimeoutException {
            int sequence = this.onBeforeRemoteCall();
            target.getEphemeralResolveInfoList(this.mCallback, hashPrefix, prefixMask, sequence);
            return (List)this.getResultTimed(sequence);
        }
    }

    private final class MyServiceConnection
    implements ServiceConnection {
        private MyServiceConnection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            Object object = EphemeralResolverConnection.this.mLock;
            synchronized (object) {
                EphemeralResolverConnection.this.mRemoteInstance = IEphemeralResolver.Stub.asInterface(service);
                EphemeralResolverConnection.this.mLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceDisconnected(ComponentName name) {
            Object object = EphemeralResolverConnection.this.mLock;
            synchronized (object) {
                EphemeralResolverConnection.this.mRemoteInstance = null;
            }
        }
    }
}

