/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.ActivityManagerInternal;
import android.app.AppGlobals;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ILauncherApps;
import android.content.pm.IOnAppsChangedListener;
import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.content.pm.ResolveInfo;
import android.content.pm.ShortcutInfo;
import android.content.pm.ShortcutServiceInternal;
import android.content.pm.UserInfo;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IInterface;
import android.os.ParcelFileDescriptor;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.Log;
import android.util.Slog;
import com.android.internal.content.PackageMonitor;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.Preconditions;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import java.util.ArrayList;
import java.util.List;

public class LauncherAppsService
extends SystemService {
    private final LauncherAppsImpl mLauncherAppsImpl;

    public LauncherAppsService(Context context) {
        super(context);
        this.mLauncherAppsImpl = new LauncherAppsImpl(context);
    }

    @Override
    public void onStart() {
        this.publishBinderService("launcherapps", this.mLauncherAppsImpl);
    }

    static class LauncherAppsImpl
    extends ILauncherApps.Stub {
        private static final boolean DEBUG = false;
        private static final String TAG = "LauncherAppsService";
        private final Context mContext;
        private final PackageManager mPm;
        private final UserManager mUm;
        private final ActivityManagerInternal mActivityManagerInternal;
        private final ShortcutServiceInternal mShortcutServiceInternal;
        private final PackageCallbackList<IOnAppsChangedListener> mListeners = new PackageCallbackList();
        private final MyPackageMonitor mPackageMonitor = new MyPackageMonitor();
        private final Handler mCallbackHandler;

        public LauncherAppsImpl(Context context) {
            this.mContext = context;
            this.mPm = this.mContext.getPackageManager();
            this.mUm = (UserManager)this.mContext.getSystemService("user");
            this.mActivityManagerInternal = Preconditions.checkNotNull(LocalServices.getService(ActivityManagerInternal.class));
            this.mShortcutServiceInternal = Preconditions.checkNotNull(LocalServices.getService(ShortcutServiceInternal.class));
            this.mShortcutServiceInternal.addListener(this.mPackageMonitor);
            this.mCallbackHandler = BackgroundThread.getHandler();
        }

        int injectBinderCallingUid() {
            return LauncherAppsImpl.getCallingUid();
        }

        final int injectCallingUserId() {
            return UserHandle.getUserId(this.injectBinderCallingUid());
        }

        long injectClearCallingIdentity() {
            return Binder.clearCallingIdentity();
        }

        void injectRestoreCallingIdentity(long token) {
            Binder.restoreCallingIdentity(token);
        }

        private int getCallingUserId() {
            return UserHandle.getUserId(this.injectBinderCallingUid());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addOnAppsChangedListener(String callingPackage, IOnAppsChangedListener listener) throws RemoteException {
            this.verifyCallingPackage(callingPackage);
            PackageCallbackList<IOnAppsChangedListener> packageCallbackList = this.mListeners;
            synchronized (packageCallbackList) {
                if (this.mListeners.getRegisteredCallbackCount() == 0) {
                    this.startWatchingPackageBroadcasts();
                }
                this.mListeners.unregister(listener);
                this.mListeners.register(listener, new BroadcastCookie(UserHandle.of(this.getCallingUserId()), callingPackage));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeOnAppsChangedListener(IOnAppsChangedListener listener) throws RemoteException {
            PackageCallbackList<IOnAppsChangedListener> packageCallbackList = this.mListeners;
            synchronized (packageCallbackList) {
                this.mListeners.unregister(listener);
                if (this.mListeners.getRegisteredCallbackCount() == 0) {
                    this.stopWatchingPackageBroadcasts();
                }
            }
        }

        private void startWatchingPackageBroadcasts() {
            this.mPackageMonitor.register(this.mContext, UserHandle.ALL, true, this.mCallbackHandler);
        }

        private void stopWatchingPackageBroadcasts() {
            this.mPackageMonitor.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void checkCallbackCount() {
            PackageCallbackList<IOnAppsChangedListener> packageCallbackList = this.mListeners;
            synchronized (packageCallbackList) {
                if (this.mListeners.getRegisteredCallbackCount() == 0) {
                    this.stopWatchingPackageBroadcasts();
                }
            }
        }

        private void ensureInUserProfiles(UserHandle userToCheck, String message) {
            this.ensureInUserProfiles(userToCheck.getIdentifier(), message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ensureInUserProfiles(int targetUserId, String message) {
            int callingUserId = this.injectCallingUserId();
            if (targetUserId == callingUserId) {
                return;
            }
            long ident = this.injectClearCallingIdentity();
            try {
                UserInfo callingUserInfo = this.mUm.getUserInfo(callingUserId);
                UserInfo targetUserInfo = this.mUm.getUserInfo(targetUserId);
                if (targetUserInfo == null || targetUserInfo.profileGroupId == -10000 || targetUserInfo.profileGroupId != callingUserInfo.profileGroupId) {
                    throw new SecurityException(message);
                }
            }
            finally {
                this.injectRestoreCallingIdentity(ident);
            }
        }

        void verifyCallingPackage(String callingPackage) {
            int packageUid = -1;
            try {
                packageUid = this.mPm.getPackageUidAsUser(callingPackage, 794624, UserHandle.getUserId(LauncherAppsImpl.getCallingUid()));
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e(TAG, "Package not found: " + callingPackage);
            }
            if (packageUid != Binder.getCallingUid()) {
                throw new SecurityException("Calling package name mismatch");
            }
        }

        private boolean isUserEnabled(UserHandle user) {
            return this.isUserEnabled(user.getIdentifier());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isUserEnabled(int userId) {
            long ident = this.injectClearCallingIdentity();
            try {
                UserInfo targetUserInfo = this.mUm.getUserInfo(userId);
                boolean bl = targetUserInfo != null && targetUserInfo.isEnabled();
                return bl;
            }
            finally {
                this.injectRestoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParceledListSlice<ResolveInfo> getLauncherActivities(String packageName, UserHandle user) throws RemoteException {
            this.ensureInUserProfiles(user, "Cannot retrieve activities for unrelated profile " + user);
            if (!this.isUserEnabled(user)) {
                return null;
            }
            Intent mainIntent = new Intent("android.intent.action.MAIN", null);
            mainIntent.addCategory("android.intent.category.LAUNCHER");
            mainIntent.setPackage(packageName);
            long ident = Binder.clearCallingIdentity();
            try {
                List<ResolveInfo> apps = this.mPm.queryIntentActivitiesAsUser(mainIntent, 786432, user.getIdentifier());
                ParceledListSlice<ResolveInfo> parceledListSlice = new ParceledListSlice<ResolveInfo>(apps);
                return parceledListSlice;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ActivityInfo resolveActivity(ComponentName component, UserHandle user) throws RemoteException {
            this.ensureInUserProfiles(user, "Cannot resolve activity for unrelated profile " + user);
            if (!this.isUserEnabled(user)) {
                return null;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                IPackageManager pm = AppGlobals.getPackageManager();
                ActivityInfo activityInfo = pm.getActivityInfo(component, 786432, user.getIdentifier());
                return activityInfo;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isPackageEnabled(String packageName, UserHandle user) throws RemoteException {
            this.ensureInUserProfiles(user, "Cannot check package for unrelated profile " + user);
            if (!this.isUserEnabled(user)) {
                return false;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                IPackageManager pm = AppGlobals.getPackageManager();
                PackageInfo info = pm.getPackageInfo(packageName, 786432, user.getIdentifier());
                boolean bl = info != null && info.applicationInfo.enabled;
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ApplicationInfo getApplicationInfo(String packageName, int flags, UserHandle user) throws RemoteException {
            this.ensureInUserProfiles(user, "Cannot check package for unrelated profile " + user);
            if (!this.isUserEnabled(user)) {
                return null;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                ApplicationInfo info;
                IPackageManager pm = AppGlobals.getPackageManager();
                ApplicationInfo applicationInfo = info = pm.getApplicationInfo(packageName, flags, user.getIdentifier());
                return applicationInfo;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        private void ensureShortcutPermission(String callingPackage, UserHandle user) {
            this.ensureShortcutPermission(callingPackage, user.getIdentifier());
        }

        private void ensureShortcutPermission(String callingPackage, int userId) {
            this.verifyCallingPackage(callingPackage);
            this.ensureInUserProfiles(userId, "Cannot start activity for unrelated profile " + userId);
            if (!this.mShortcutServiceInternal.hasShortcutHostPermission(this.getCallingUserId(), callingPackage)) {
                throw new SecurityException("Caller can't access shortcut information");
            }
        }

        @Override
        public ParceledListSlice getShortcuts(String callingPackage, long changedSince, String packageName, List shortcutIds, ComponentName componentName, int flags, UserHandle user) {
            this.ensureShortcutPermission(callingPackage, user);
            if (!this.isUserEnabled(user)) {
                return new ParceledListSlice(new ArrayList(0));
            }
            if (shortcutIds != null && packageName == null) {
                throw new IllegalArgumentException("To query by shortcut ID, package name must also be set");
            }
            return new ParceledListSlice<ShortcutInfo>(this.mShortcutServiceInternal.getShortcuts(this.getCallingUserId(), callingPackage, changedSince, packageName, shortcutIds, componentName, flags, user.getIdentifier()));
        }

        @Override
        public void pinShortcuts(String callingPackage, String packageName, List<String> ids, UserHandle user) {
            this.ensureShortcutPermission(callingPackage, user);
            if (!this.isUserEnabled(user)) {
                throw new IllegalStateException("Cannot pin shortcuts for disabled profile " + user);
            }
            this.mShortcutServiceInternal.pinShortcuts(this.getCallingUserId(), callingPackage, packageName, ids, user.getIdentifier());
        }

        @Override
        public int getShortcutIconResId(String callingPackage, String packageName, String id2, int userId) {
            this.ensureShortcutPermission(callingPackage, userId);
            if (!this.isUserEnabled(userId)) {
                return 0;
            }
            return this.mShortcutServiceInternal.getShortcutIconResId(this.getCallingUserId(), callingPackage, packageName, id2, userId);
        }

        @Override
        public ParcelFileDescriptor getShortcutIconFd(String callingPackage, String packageName, String id2, int userId) {
            this.ensureShortcutPermission(callingPackage, userId);
            if (!this.isUserEnabled(userId)) {
                return null;
            }
            return this.mShortcutServiceInternal.getShortcutIconFd(this.getCallingUserId(), callingPackage, packageName, id2, userId);
        }

        @Override
        public boolean hasShortcutHostPermission(String callingPackage) {
            this.verifyCallingPackage(callingPackage);
            return this.mShortcutServiceInternal.hasShortcutHostPermission(this.getCallingUserId(), callingPackage);
        }

        @Override
        public boolean startShortcut(String callingPackage, String packageName, String shortcutId, Rect sourceBounds, Bundle startActivityOptions, int userId) {
            Intent[] intents;
            this.verifyCallingPackage(callingPackage);
            this.ensureInUserProfiles(userId, "Cannot start activity for unrelated profile " + userId);
            if (!this.isUserEnabled(userId)) {
                throw new IllegalStateException("Cannot start a shortcut for disabled profile " + userId);
            }
            if (!this.mShortcutServiceInternal.isPinnedByCaller(this.getCallingUserId(), callingPackage, packageName, shortcutId, userId)) {
                this.ensureShortcutPermission(callingPackage, userId);
            }
            if ((intents = this.mShortcutServiceInternal.createShortcutIntents(this.getCallingUserId(), callingPackage, packageName, shortcutId, userId)) == null || intents.length == 0) {
                return false;
            }
            intents[0].addFlags(0x10000000);
            intents[0].setSourceBounds(sourceBounds);
            return this.startShortcutIntentsAsPublisher(intents, packageName, startActivityOptions, userId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean startShortcutIntentsAsPublisher(Intent[] intents, String publisherPackage, Bundle startActivityOptions, int userId) {
            long ident = this.injectClearCallingIdentity();
            try {
                int code = this.mActivityManagerInternal.startActivitiesAsPackage(publisherPackage, userId, intents, startActivityOptions);
                if (code >= 0) {
                    boolean bl = true;
                    return bl;
                }
                Log.e(TAG, "Couldn't start activity, code=" + code);
                boolean bl = code >= 0;
                return bl;
            }
            catch (SecurityException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.injectRestoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isActivityEnabled(ComponentName component, UserHandle user) throws RemoteException {
            this.ensureInUserProfiles(user, "Cannot check component for unrelated profile " + user);
            if (!this.isUserEnabled(user)) {
                return false;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                IPackageManager pm = AppGlobals.getPackageManager();
                ActivityInfo info = pm.getActivityInfo(component, 786432, user.getIdentifier());
                boolean bl = info != null;
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        @Override
        public void startActivityAsUser(ComponentName component, Rect sourceBounds, Bundle opts, UserHandle user) throws RemoteException {
            this.ensureInUserProfiles(user, "Cannot start activity for unrelated profile " + user);
            if (!this.isUserEnabled(user)) {
                throw new IllegalStateException("Cannot start activity for disabled profile " + user);
            }
            Intent launchIntent = new Intent("android.intent.action.MAIN");
            launchIntent.addCategory("android.intent.category.LAUNCHER");
            launchIntent.setSourceBounds(sourceBounds);
            launchIntent.addFlags(0x10200000);
            launchIntent.setPackage(component.getPackageName());
            long ident = Binder.clearCallingIdentity();
            try {
                IPackageManager pm = AppGlobals.getPackageManager();
                ActivityInfo info = pm.getActivityInfo(component, 786432, user.getIdentifier());
                if (!info.exported) {
                    throw new SecurityException("Cannot launch non-exported components " + component);
                }
                List<ResolveInfo> apps = this.mPm.queryIntentActivitiesAsUser(launchIntent, 786432, user.getIdentifier());
                int size = apps.size();
                for (int i = 0; i < size; ++i) {
                    ActivityInfo activityInfo = apps.get((int)i).activityInfo;
                    if (!activityInfo.packageName.equals(component.getPackageName()) || !activityInfo.name.equals(component.getClassName())) continue;
                    launchIntent.setComponent(component);
                    this.mContext.startActivityAsUser(launchIntent, opts, user);
                    return;
                }
                throw new SecurityException("Attempt to launch activity without  category Intent.CATEGORY_LAUNCHER " + component);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void showAppDetailsAsUser(ComponentName component, Rect sourceBounds, Bundle opts, UserHandle user) throws RemoteException {
            this.ensureInUserProfiles(user, "Cannot show app details for unrelated profile " + user);
            if (!this.isUserEnabled(user)) {
                throw new IllegalStateException("Cannot show app details for disabled profile " + user);
            }
            long ident = Binder.clearCallingIdentity();
            try {
                String packageName = component.getPackageName();
                Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.fromParts("package", packageName, null));
                intent.setFlags(0x10008000);
                intent.setSourceBounds(sourceBounds);
                this.mContext.startActivityAsUser(intent, opts, user);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isEnabledProfileOf(UserHandle user, UserHandle listeningUser, String debugMsg) {
            if (user.getIdentifier() == listeningUser.getIdentifier()) {
                return true;
            }
            long ident = this.injectClearCallingIdentity();
            try {
                UserInfo userInfo = this.mUm.getUserInfo(user.getIdentifier());
                UserInfo listeningUserInfo = this.mUm.getUserInfo(listeningUser.getIdentifier());
                if (userInfo == null || listeningUserInfo == null || userInfo.profileGroupId == -10000 || userInfo.profileGroupId != listeningUserInfo.profileGroupId || !userInfo.isEnabled()) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.injectRestoreCallingIdentity(ident);
            }
        }

        void postToPackageMonitorHandler(Runnable r) {
            this.mCallbackHandler.post(r);
        }

        class PackageCallbackList<T extends IInterface>
        extends RemoteCallbackList<T> {
            PackageCallbackList() {
            }

            @Override
            public void onCallbackDied(T callback, Object cookie) {
                LauncherAppsImpl.this.checkCallbackCount();
            }
        }

        private class MyPackageMonitor
        extends PackageMonitor
        implements ShortcutServiceInternal.ShortcutChangeListener {
            private MyPackageMonitor() {
            }

            @Override
            public void onPackageAdded(String packageName, int uid) {
                UserHandle user = new UserHandle(this.getChangingUserId());
                int n = LauncherAppsImpl.this.mListeners.beginBroadcast();
                for (int i = 0; i < n; ++i) {
                    IOnAppsChangedListener listener = (IOnAppsChangedListener)LauncherAppsImpl.this.mListeners.getBroadcastItem(i);
                    BroadcastCookie cookie = (BroadcastCookie)LauncherAppsImpl.this.mListeners.getBroadcastCookie(i);
                    if (!LauncherAppsImpl.this.isEnabledProfileOf(user, cookie.user, "onPackageAdded")) continue;
                    try {
                        listener.onPackageAdded(user, packageName);
                        continue;
                    }
                    catch (RemoteException re) {
                        Slog.d(LauncherAppsImpl.TAG, "Callback failed ", re);
                    }
                }
                LauncherAppsImpl.this.mListeners.finishBroadcast();
                super.onPackageAdded(packageName, uid);
            }

            @Override
            public void onPackageRemoved(String packageName, int uid) {
                UserHandle user = new UserHandle(this.getChangingUserId());
                int n = LauncherAppsImpl.this.mListeners.beginBroadcast();
                for (int i = 0; i < n; ++i) {
                    IOnAppsChangedListener listener = (IOnAppsChangedListener)LauncherAppsImpl.this.mListeners.getBroadcastItem(i);
                    BroadcastCookie cookie = (BroadcastCookie)LauncherAppsImpl.this.mListeners.getBroadcastCookie(i);
                    if (!LauncherAppsImpl.this.isEnabledProfileOf(user, cookie.user, "onPackageRemoved")) continue;
                    try {
                        listener.onPackageRemoved(user, packageName);
                        continue;
                    }
                    catch (RemoteException re) {
                        Slog.d(LauncherAppsImpl.TAG, "Callback failed ", re);
                    }
                }
                LauncherAppsImpl.this.mListeners.finishBroadcast();
                super.onPackageRemoved(packageName, uid);
            }

            @Override
            public void onPackageModified(String packageName) {
                UserHandle user = new UserHandle(this.getChangingUserId());
                int n = LauncherAppsImpl.this.mListeners.beginBroadcast();
                for (int i = 0; i < n; ++i) {
                    IOnAppsChangedListener listener = (IOnAppsChangedListener)LauncherAppsImpl.this.mListeners.getBroadcastItem(i);
                    BroadcastCookie cookie = (BroadcastCookie)LauncherAppsImpl.this.mListeners.getBroadcastCookie(i);
                    if (!LauncherAppsImpl.this.isEnabledProfileOf(user, cookie.user, "onPackageModified")) continue;
                    try {
                        listener.onPackageChanged(user, packageName);
                        continue;
                    }
                    catch (RemoteException re) {
                        Slog.d(LauncherAppsImpl.TAG, "Callback failed ", re);
                    }
                }
                LauncherAppsImpl.this.mListeners.finishBroadcast();
                super.onPackageModified(packageName);
            }

            @Override
            public void onPackagesAvailable(String[] packages) {
                UserHandle user = new UserHandle(this.getChangingUserId());
                int n = LauncherAppsImpl.this.mListeners.beginBroadcast();
                for (int i = 0; i < n; ++i) {
                    IOnAppsChangedListener listener = (IOnAppsChangedListener)LauncherAppsImpl.this.mListeners.getBroadcastItem(i);
                    BroadcastCookie cookie = (BroadcastCookie)LauncherAppsImpl.this.mListeners.getBroadcastCookie(i);
                    if (!LauncherAppsImpl.this.isEnabledProfileOf(user, cookie.user, "onPackagesAvailable")) continue;
                    try {
                        listener.onPackagesAvailable(user, packages, this.isReplacing());
                        continue;
                    }
                    catch (RemoteException re) {
                        Slog.d(LauncherAppsImpl.TAG, "Callback failed ", re);
                    }
                }
                LauncherAppsImpl.this.mListeners.finishBroadcast();
                super.onPackagesAvailable(packages);
            }

            @Override
            public void onPackagesUnavailable(String[] packages) {
                UserHandle user = new UserHandle(this.getChangingUserId());
                int n = LauncherAppsImpl.this.mListeners.beginBroadcast();
                for (int i = 0; i < n; ++i) {
                    IOnAppsChangedListener listener = (IOnAppsChangedListener)LauncherAppsImpl.this.mListeners.getBroadcastItem(i);
                    BroadcastCookie cookie = (BroadcastCookie)LauncherAppsImpl.this.mListeners.getBroadcastCookie(i);
                    if (!LauncherAppsImpl.this.isEnabledProfileOf(user, cookie.user, "onPackagesUnavailable")) continue;
                    try {
                        listener.onPackagesUnavailable(user, packages, this.isReplacing());
                        continue;
                    }
                    catch (RemoteException re) {
                        Slog.d(LauncherAppsImpl.TAG, "Callback failed ", re);
                    }
                }
                LauncherAppsImpl.this.mListeners.finishBroadcast();
                super.onPackagesUnavailable(packages);
            }

            @Override
            public void onPackagesSuspended(String[] packages) {
                UserHandle user = new UserHandle(this.getChangingUserId());
                int n = LauncherAppsImpl.this.mListeners.beginBroadcast();
                for (int i = 0; i < n; ++i) {
                    IOnAppsChangedListener listener = (IOnAppsChangedListener)LauncherAppsImpl.this.mListeners.getBroadcastItem(i);
                    BroadcastCookie cookie = (BroadcastCookie)LauncherAppsImpl.this.mListeners.getBroadcastCookie(i);
                    if (!LauncherAppsImpl.this.isEnabledProfileOf(user, cookie.user, "onPackagesSuspended")) continue;
                    try {
                        listener.onPackagesSuspended(user, packages);
                        continue;
                    }
                    catch (RemoteException re) {
                        Slog.d(LauncherAppsImpl.TAG, "Callback failed ", re);
                    }
                }
                LauncherAppsImpl.this.mListeners.finishBroadcast();
                super.onPackagesSuspended(packages);
            }

            @Override
            public void onPackagesUnsuspended(String[] packages) {
                UserHandle user = new UserHandle(this.getChangingUserId());
                int n = LauncherAppsImpl.this.mListeners.beginBroadcast();
                for (int i = 0; i < n; ++i) {
                    IOnAppsChangedListener listener = (IOnAppsChangedListener)LauncherAppsImpl.this.mListeners.getBroadcastItem(i);
                    BroadcastCookie cookie = (BroadcastCookie)LauncherAppsImpl.this.mListeners.getBroadcastCookie(i);
                    if (!LauncherAppsImpl.this.isEnabledProfileOf(user, cookie.user, "onPackagesUnsuspended")) continue;
                    try {
                        listener.onPackagesUnsuspended(user, packages);
                        continue;
                    }
                    catch (RemoteException re) {
                        Slog.d(LauncherAppsImpl.TAG, "Callback failed ", re);
                    }
                }
                LauncherAppsImpl.this.mListeners.finishBroadcast();
                super.onPackagesUnsuspended(packages);
            }

            @Override
            public void onShortcutChanged(String packageName, int userId) {
                LauncherAppsImpl.this.postToPackageMonitorHandler(() -> this.onShortcutChangedInner(packageName, userId));
            }

            private void onShortcutChangedInner(String packageName, int userId) {
                try {
                    UserHandle user = UserHandle.of(userId);
                    int n = LauncherAppsImpl.this.mListeners.beginBroadcast();
                    for (int i = 0; i < n; ++i) {
                        IOnAppsChangedListener listener = (IOnAppsChangedListener)LauncherAppsImpl.this.mListeners.getBroadcastItem(i);
                        BroadcastCookie cookie = (BroadcastCookie)LauncherAppsImpl.this.mListeners.getBroadcastCookie(i);
                        if (!LauncherAppsImpl.this.isEnabledProfileOf(user, cookie.user, "onShortcutChanged")) continue;
                        int launcherUserId = cookie.user.getIdentifier();
                        if (!LauncherAppsImpl.this.mShortcutServiceInternal.hasShortcutHostPermission(launcherUserId, cookie.packageName)) continue;
                        List<ShortcutInfo> list = LauncherAppsImpl.this.mShortcutServiceInternal.getShortcuts(launcherUserId, cookie.packageName, 0L, packageName, null, null, 15, userId);
                        try {
                            listener.onShortcutChanged(user, packageName, new ParceledListSlice<ShortcutInfo>(list));
                            continue;
                        }
                        catch (RemoteException re) {
                            Slog.d(LauncherAppsImpl.TAG, "Callback failed ", re);
                        }
                    }
                    LauncherAppsImpl.this.mListeners.finishBroadcast();
                }
                catch (RuntimeException e) {
                    Log.w(LauncherAppsImpl.TAG, e.getMessage(), e);
                }
            }
        }
    }

    static class BroadcastCookie {
        public final UserHandle user;
        public final String packageName;

        BroadcastCookie(UserHandle userHandle, String packageName) {
            this.user = userHandle;
            this.packageName = packageName;
        }
    }
}

