/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.Context;
import android.content.pm.IOtaDexopt;
import android.content.pm.PackageParser;
import android.os.Environment;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.storage.StorageManager;
import android.util.Log;
import android.util.Slog;
import com.android.internal.os.InstallerConnection;
import com.android.server.pm.Installer;
import com.android.server.pm.InstructionSets;
import com.android.server.pm.OtaDexoptShellCommand;
import com.android.server.pm.PackageDexOptimizer;
import com.android.server.pm.PackageManagerService;
import com.android.server.pm.PackageManagerServiceCompilerMapping;
import com.android.server.pm.PackageManagerServiceUtils;
import java.io.File;
import java.io.FileDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class OtaDexoptService
extends IOtaDexopt.Stub {
    private static final String TAG = "OTADexopt";
    private static final boolean DEBUG_DEXOPT = true;
    private static final String[] NO_LIBRARIES = new String[]{"&"};
    private final Context mContext;
    private final PackageManagerService mPackageManagerService;
    private List<String> mDexoptCommands;
    private int completeSize;

    public OtaDexoptService(Context context, PackageManagerService packageManagerService) {
        this.mContext = context;
        this.mPackageManagerService = packageManagerService;
        this.moveAbArtifacts(packageManagerService.mInstaller);
    }

    public static OtaDexoptService main(Context context, PackageManagerService packageManagerService) {
        OtaDexoptService ota = new OtaDexoptService(context, packageManagerService);
        ServiceManager.addService("otadexopt", ota);
        return ota;
    }

    @Override
    public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ResultReceiver resultReceiver) throws RemoteException {
        new OtaDexoptShellCommand(this).exec(this, in, out, err, args, resultReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void prepare() throws RemoteException {
        ArrayList<PackageParser.Package> others;
        List<PackageParser.Package> important;
        if (this.mDexoptCommands != null) {
            throw new IllegalStateException("already called prepare()");
        }
        Iterator iterator = this.mPackageManagerService.mPackages;
        synchronized (iterator) {
            important = PackageManagerServiceUtils.getPackagesForDexopt(this.mPackageManagerService.mPackages.values(), this.mPackageManagerService);
            others = new ArrayList<PackageParser.Package>(this.mPackageManagerService.mPackages.values());
            others.removeAll(important);
            this.mDexoptCommands = new ArrayList<String>(3 * this.mPackageManagerService.mPackages.size() / 2);
        }
        for (PackageParser.Package p : important) {
            int compilationReason = p.coreApp ? 8 : 4;
            this.mDexoptCommands.addAll(this.generatePackageDexopts(p, compilationReason));
        }
        for (PackageParser.Package p : others) {
            if (p.coreApp) {
                throw new IllegalStateException("Found a core app that's not important");
            }
            this.mDexoptCommands.addAll(this.generatePackageDexopts(p, 0));
        }
        this.completeSize = this.mDexoptCommands.size();
    }

    @Override
    public synchronized void cleanup() throws RemoteException {
        Log.i(TAG, "Cleaning up OTA Dexopt state.");
        this.mDexoptCommands = null;
    }

    @Override
    public synchronized boolean isDone() throws RemoteException {
        if (this.mDexoptCommands == null) {
            throw new IllegalStateException("done() called before prepare()");
        }
        return this.mDexoptCommands.isEmpty();
    }

    @Override
    public synchronized float getProgress() throws RemoteException {
        if (this.completeSize == 0) {
            return 1.0f;
        }
        int commandsLeft = this.mDexoptCommands.size();
        return (float)(this.completeSize - commandsLeft) / (float)this.completeSize;
    }

    @Override
    public synchronized String nextDexoptCommand() throws RemoteException {
        if (this.mDexoptCommands == null) {
            throw new IllegalStateException("dexoptNextPackage() called before prepare()");
        }
        if (this.mDexoptCommands.isEmpty()) {
            return "(all done)";
        }
        String next = this.mDexoptCommands.remove(0);
        if (this.IsFreeSpaceAvailable()) {
            return next;
        }
        this.mDexoptCommands.clear();
        return "(no free space)";
    }

    private boolean IsFreeSpaceAvailable() {
        File dataDir = Environment.getDataDirectory();
        long lowThreshold = StorageManager.from(this.mContext).getStorageLowBytes(dataDir);
        if (lowThreshold == 0L) {
            throw new IllegalStateException("Invalid low memory threshold");
        }
        long usableSpace = dataDir.getUsableSpace();
        return usableSpace >= lowThreshold;
    }

    private synchronized List<String> generatePackageDexopts(PackageParser.Package pkg, int compilationReason) {
        RecordingInstallerConnection collectingConnection = new RecordingInstallerConnection();
        Installer collectingInstaller = new Installer(this.mContext, collectingConnection);
        OTADexoptPackageDexOptimizer optimizer = new OTADexoptPackageDexOptimizer(collectingInstaller, this.mPackageManagerService.mInstallLock, this.mContext);
        String[] libraryDependencies = pkg.usesLibraryFiles;
        if (pkg.isSystemApp()) {
            libraryDependencies = NO_LIBRARIES;
        }
        optimizer.performDexOpt(pkg, libraryDependencies, null, false, PackageManagerServiceCompilerMapping.getCompilerFilterForReason(compilationReason), null);
        return collectingConnection.commands;
    }

    @Override
    public synchronized void dexoptNextPackage() throws RemoteException {
        throw new UnsupportedOperationException();
    }

    private void moveAbArtifacts(Installer installer) {
        if (this.mDexoptCommands != null) {
            throw new IllegalStateException("Should not be ota-dexopting when trying to move.");
        }
        Collection<PackageParser.Package> pkgs = this.mPackageManagerService.getPackages();
        for (PackageParser.Package pkg : pkgs) {
            String[] dexCodeInstructionSets;
            if (pkg == null || !PackageDexOptimizer.canOptimizePackage(pkg)) continue;
            if (pkg.codePath == null) {
                Slog.w(TAG, "Package " + pkg + " can be optimized but has null codePath");
                continue;
            }
            if (pkg.codePath.startsWith("/system") || pkg.codePath.startsWith("/vendor")) continue;
            String[] instructionSets = InstructionSets.getAppDexInstructionSets(pkg.applicationInfo);
            List<String> paths = pkg.getAllCodePathsExcludingResourceOnly();
            for (String dexCodeInstructionSet : dexCodeInstructionSets = InstructionSets.getDexCodeInstructionSets(instructionSets)) {
                for (String path : paths) {
                    String oatDir = PackageDexOptimizer.getOatDir(new File(pkg.codePath)).getAbsolutePath();
                    try {
                        installer.moveAb(path, dexCodeInstructionSet, oatDir);
                    }
                    catch (InstallerConnection.InstallerException installerException) {}
                }
            }
        }
    }

    private static class RecordingInstallerConnection
    extends InstallerConnection {
        public List<String> commands = new ArrayList<String>(1);

        private RecordingInstallerConnection() {
        }

        @Override
        public void setWarnIfHeld(Object warnIfHeld) {
            throw new IllegalStateException("Should not reach here");
        }

        @Override
        public synchronized String transact(String cmd) {
            this.commands.add(cmd);
            return "0";
        }

        @Override
        public boolean mergeProfiles(int uid, String pkgName) throws InstallerConnection.InstallerException {
            throw new IllegalStateException("Should not reach here");
        }

        @Override
        public boolean dumpProfiles(String gid, String packageName, String codePaths) throws InstallerConnection.InstallerException {
            throw new IllegalStateException("Should not reach here");
        }

        @Override
        public void disconnect() {
            throw new IllegalStateException("Should not reach here");
        }

        @Override
        public void waitForConnection() {
            throw new IllegalStateException("Should not reach here");
        }
    }

    private static class OTADexoptPackageDexOptimizer
    extends PackageDexOptimizer.ForcedUpdatePackageDexOptimizer {
        public OTADexoptPackageDexOptimizer(Installer installer, Object installLock, Context context) {
            super(installer, installLock, context, "*otadexopt*");
        }

        @Override
        protected int adjustDexoptFlags(int dexoptFlags) {
            return dexoptFlags | 0x40;
        }
    }
}

