/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.Context;
import android.content.pm.PackageParser;
import android.os.Environment;
import android.os.PowerManager;
import android.os.UserHandle;
import android.os.WorkSource;
import android.util.Log;
import android.util.Slog;
import com.android.internal.os.InstallerConnection;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.pm.CompilerStats;
import com.android.server.pm.Installer;
import com.android.server.pm.InstructionSets;
import com.android.server.pm.PackageManagerServiceCompilerMapping;
import com.android.server.pm.PackageManagerServiceUtils;
import com.android.server.pm.UserManagerService;
import dalvik.system.DexFile;
import java.io.File;
import java.io.IOException;
import java.util.List;

class PackageDexOptimizer {
    private static final String TAG = "PackageManager.DexOptimizer";
    static final String OAT_DIR_NAME = "oat";
    static final int DEX_OPT_SKIPPED = 0;
    static final int DEX_OPT_PERFORMED = 1;
    static final int DEX_OPT_FAILED = -1;
    private final Installer mInstaller;
    private final Object mInstallLock;
    private final PowerManager.WakeLock mDexoptWakeLock;
    private volatile boolean mSystemReady;

    PackageDexOptimizer(Installer installer, Object installLock, Context context, String wakeLockTag) {
        this.mInstaller = installer;
        this.mInstallLock = installLock;
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        this.mDexoptWakeLock = powerManager.newWakeLock(1, wakeLockTag);
    }

    protected PackageDexOptimizer(PackageDexOptimizer from) {
        this.mInstaller = from.mInstaller;
        this.mInstallLock = from.mInstallLock;
        this.mDexoptWakeLock = from.mDexoptWakeLock;
        this.mSystemReady = from.mSystemReady;
    }

    static boolean canOptimizePackage(PackageParser.Package pkg) {
        return (pkg.applicationInfo.flags & 4) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int performDexOpt(PackageParser.Package pkg, String[] sharedLibraries, String[] instructionSets, boolean checkProfiles, String targetCompilationFilter, CompilerStats.PackageStats packageStats) {
        Object object = this.mInstallLock;
        synchronized (object) {
            int n;
            block8: {
                boolean useLock = this.mSystemReady;
                if (useLock) {
                    this.mDexoptWakeLock.setWorkSource(new WorkSource(pkg.applicationInfo.uid));
                    this.mDexoptWakeLock.acquire();
                }
                try {
                    n = this.performDexOptLI(pkg, sharedLibraries, instructionSets, checkProfiles, targetCompilationFilter, packageStats);
                    if (!useLock) break block8;
                    this.mDexoptWakeLock.release();
                }
                catch (Throwable throwable) {
                    if (useLock) {
                        this.mDexoptWakeLock.release();
                    }
                    throw throwable;
                }
            }
            return n;
        }
    }

    protected int adjustDexoptNeeded(int dexoptNeeded) {
        return dexoptNeeded;
    }

    protected int adjustDexoptFlags(int dexoptFlags) {
        return dexoptFlags;
    }

    void dumpDexoptState(IndentingPrintWriter pw, PackageParser.Package pkg) {
        String[] instructionSets = InstructionSets.getAppDexInstructionSets(pkg.applicationInfo);
        String[] dexCodeInstructionSets = InstructionSets.getDexCodeInstructionSets(instructionSets);
        List<String> paths = pkg.getAllCodePathsExcludingResourceOnly();
        for (String instructionSet : dexCodeInstructionSets) {
            pw.println("Instruction Set: " + instructionSet);
            pw.increaseIndent();
            for (String path : paths) {
                String status = null;
                try {
                    status = DexFile.getDexFileStatus(path, instructionSet);
                }
                catch (IOException ioe) {
                    status = "[Exception]: " + ioe.getMessage();
                }
                pw.println("path: " + path);
                pw.println("status: " + status);
            }
            pw.decreaseIndent();
        }
    }

    private int performDexOptLI(PackageParser.Package pkg, String[] sharedLibraries, String[] targetInstructionSets, boolean checkProfiles, String targetCompilerFilter, CompilerStats.PackageStats packageStats) {
        String[] dexCodeInstructionSets;
        String[] instructionSets;
        String[] stringArray = instructionSets = targetInstructionSets != null ? targetInstructionSets : InstructionSets.getAppDexInstructionSets(pkg.applicationInfo);
        if (!PackageDexOptimizer.canOptimizePackage(pkg)) {
            return 0;
        }
        List<String> paths = pkg.getAllCodePathsExcludingResourceOnly();
        int sharedGid = UserHandle.getSharedAppGid(pkg.applicationInfo.uid);
        boolean isProfileGuidedFilter = DexFile.isProfileGuidedCompilerFilter(targetCompilerFilter);
        if (isProfileGuidedFilter && PackageDexOptimizer.isUsedByOtherApps(pkg)) {
            checkProfiles = false;
            if (DexFile.isProfileGuidedCompilerFilter(targetCompilerFilter = PackageManagerServiceCompilerMapping.getNonProfileGuidedCompilerFilter(targetCompilerFilter))) {
                throw new IllegalStateException(targetCompilerFilter);
            }
            isProfileGuidedFilter = false;
        }
        boolean newProfile = false;
        if (checkProfiles && isProfileGuidedFilter) {
            try {
                newProfile = this.mInstaller.mergeProfiles(sharedGid, pkg.packageName);
            }
            catch (InstallerConnection.InstallerException e) {
                Slog.w(TAG, "Failed to merge profiles", e);
            }
        }
        boolean vmSafeMode = (pkg.applicationInfo.flags & 0x4000) != 0;
        boolean debuggable = (pkg.applicationInfo.flags & 2) != 0;
        boolean performedDexOpt = false;
        boolean successfulDexOpt = true;
        for (String dexCodeInstructionSet : dexCodeInstructionSets = InstructionSets.getDexCodeInstructionSets(instructionSets)) {
            block13: for (String path : paths) {
                String dexoptType;
                int dexoptNeeded;
                try {
                    dexoptNeeded = DexFile.getDexOptNeeded(path, dexCodeInstructionSet, targetCompilerFilter, newProfile);
                }
                catch (IOException ioe) {
                    Slog.w(TAG, "IOException reading apk: " + path, ioe);
                    return -1;
                }
                dexoptNeeded = this.adjustDexoptNeeded(dexoptNeeded);
                String oatDir = null;
                switch (dexoptNeeded) {
                    case 0: {
                        continue block13;
                    }
                    case 1: {
                        dexoptType = "dex2oat";
                        oatDir = this.createOatDirIfSupported(pkg, dexCodeInstructionSet);
                        break;
                    }
                    case 2: {
                        dexoptType = "patchoat";
                        break;
                    }
                    case 3: {
                        dexoptType = "self patchoat";
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid dexopt:" + dexoptNeeded);
                    }
                }
                String sharedLibrariesPath = null;
                if (sharedLibraries != null && sharedLibraries.length != 0) {
                    StringBuilder sb = new StringBuilder();
                    for (String lib : sharedLibraries) {
                        if (sb.length() != 0) {
                            sb.append(":");
                        }
                        sb.append(lib);
                    }
                    sharedLibrariesPath = sb.toString();
                }
                Log.i(TAG, "Running dexopt (" + dexoptType + ") on: " + path + " pkg=" + pkg.applicationInfo.packageName + " isa=" + dexCodeInstructionSet + " vmSafeMode=" + vmSafeMode + " debuggable=" + debuggable + " target-filter=" + targetCompilerFilter + " oatDir = " + oatDir + " sharedLibraries=" + sharedLibrariesPath);
                boolean isPublic = !pkg.isForwardLocked() && !isProfileGuidedFilter;
                int profileFlag = isProfileGuidedFilter ? 32 : 0;
                int dexFlags = this.adjustDexoptFlags((isPublic ? 2 : 0) | (vmSafeMode ? 4 : 0) | (debuggable ? 8 : 0) | profileFlag | 0x10);
                try {
                    long startTime = System.currentTimeMillis();
                    this.mInstaller.dexopt(path, sharedGid, pkg.packageName, dexCodeInstructionSet, dexoptNeeded, oatDir, dexFlags, targetCompilerFilter, pkg.volumeUuid, sharedLibrariesPath);
                    performedDexOpt = true;
                    if (packageStats == null) continue;
                    long endTime = System.currentTimeMillis();
                    packageStats.setCompileTime(path, (int)(endTime - startTime));
                }
                catch (InstallerConnection.InstallerException e) {
                    Slog.w(TAG, "Failed to dexopt", e);
                    successfulDexOpt = false;
                }
            }
        }
        if (successfulDexOpt) {
            return performedDexOpt ? 1 : 0;
        }
        return -1;
    }

    private String createOatDirIfSupported(PackageParser.Package pkg, String dexInstructionSet) {
        if (!pkg.canHaveOatDir()) {
            return null;
        }
        File codePath = new File(pkg.codePath);
        if (codePath.isDirectory()) {
            File oatDir = PackageDexOptimizer.getOatDir(codePath);
            try {
                this.mInstaller.createOatDir(oatDir.getAbsolutePath(), dexInstructionSet);
            }
            catch (InstallerConnection.InstallerException e) {
                Slog.w(TAG, "Failed to create oat dir", e);
                return null;
            }
            return oatDir.getAbsolutePath();
        }
        return null;
    }

    static File getOatDir(File codePath) {
        return new File(codePath, OAT_DIR_NAME);
    }

    void systemReady() {
        this.mSystemReady = true;
    }

    public static boolean isUsedByOtherApps(PackageParser.Package pkg) {
        if (pkg.isForwardLocked()) {
            return false;
        }
        for (String apkPath : pkg.getAllCodePathsExcludingResourceOnly()) {
            try {
                apkPath = PackageManagerServiceUtils.realpath(new File(apkPath));
            }
            catch (IOException e) {
                Slog.w(TAG, "Failed to get canonical path", e);
                continue;
            }
            String useMarker = apkPath.replace('/', '@');
            int[] currentUserIds = UserManagerService.getInstance().getUserIds();
            for (int i = 0; i < currentUserIds.length; ++i) {
                File profileDir = Environment.getDataProfilesDeForeignDexDirectory(currentUserIds[i]);
                File foreignUseMark = new File(profileDir, useMarker);
                if (!foreignUseMark.exists()) continue;
                return true;
            }
        }
        return false;
    }

    public static class ForcedUpdatePackageDexOptimizer
    extends PackageDexOptimizer {
        public ForcedUpdatePackageDexOptimizer(Installer installer, Object installLock, Context context, String wakeLockTag) {
            super(installer, installLock, context, wakeLockTag);
        }

        public ForcedUpdatePackageDexOptimizer(PackageDexOptimizer from) {
            super(from);
        }

        @Override
        protected int adjustDexoptNeeded(int dexoptNeeded) {
            return 1;
        }
    }
}

