/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.AppGlobals;
import android.content.Intent;
import android.content.pm.PackageParser;
import android.content.pm.ResolveInfo;
import android.os.RemoteException;
import android.system.ErrnoException;
import android.util.ArraySet;
import com.android.server.pm.PackageDexOptimizer;
import com.android.server.pm.PackageManagerService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import libcore.io.Libcore;

public class PackageManagerServiceUtils {
    private static final long SEVEN_DAYS_IN_MILLISECONDS = 604800000L;

    private static ArraySet<String> getPackageNamesForIntent(Intent intent, int userId) {
        List ris = null;
        try {
            ris = AppGlobals.getPackageManager().queryIntentReceivers(intent, null, 0, userId).getList();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        ArraySet<String> pkgNames = new ArraySet<String>();
        if (ris != null) {
            for (ResolveInfo ri : ris) {
                pkgNames.add(ri.activityInfo.packageName);
            }
        }
        return pkgNames;
    }

    private static void filterRecentlyUsedApps(Collection<PackageParser.Package> pkgs, long estimatedPreviousSystemUseTime, long dexOptLRUThresholdInMills) {
        int total = pkgs.size();
        int skipped = 0;
        Iterator<PackageParser.Package> i = pkgs.iterator();
        while (i.hasNext()) {
            PackageParser.Package pkg = i.next();
            long then = pkg.getLatestForegroundPackageUseTimeInMills();
            if (then >= estimatedPreviousSystemUseTime - dexOptLRUThresholdInMills) continue;
            i.remove();
            ++skipped;
        }
    }

    public static List<PackageParser.Package> getPackagesForDexopt(Collection<PackageParser.Package> packages, PackageManagerService packageManagerService) {
        PackageParser.Package lastUsed;
        long estimatedPreviousSystemUseTime;
        ArrayList<PackageParser.Package> remainingPkgs = new ArrayList<PackageParser.Package>(packages);
        LinkedList<PackageParser.Package> result = new LinkedList<PackageParser.Package>();
        for (PackageParser.Package pkg : remainingPkgs) {
            if (!pkg.coreApp) continue;
            result.add(pkg);
        }
        remainingPkgs.removeAll(result);
        Intent intent = new Intent("android.intent.action.PRE_BOOT_COMPLETED");
        ArraySet<String> pkgNames = PackageManagerServiceUtils.getPackageNamesForIntent(intent, 0);
        for (PackageParser.Package pkg : remainingPkgs) {
            if (!pkgNames.contains(pkg.packageName)) continue;
            result.add(pkg);
        }
        remainingPkgs.removeAll(result);
        for (PackageParser.Package pkg : remainingPkgs) {
            if (!PackageDexOptimizer.isUsedByOtherApps(pkg)) continue;
            result.add(pkg);
        }
        remainingPkgs.removeAll(result);
        if (!remainingPkgs.isEmpty() && packageManagerService.isHistoricalPackageUsageAvailable() && (estimatedPreviousSystemUseTime = (lastUsed = Collections.max(remainingPkgs, (pkg1, pkg2) -> Long.compare(pkg1.getLatestForegroundPackageUseTimeInMills(), pkg2.getLatestForegroundPackageUseTimeInMills()))).getLatestForegroundPackageUseTimeInMills()) != 0L) {
            PackageManagerServiceUtils.filterRecentlyUsedApps(remainingPkgs, estimatedPreviousSystemUseTime, 604800000L);
        }
        result.addAll(remainingPkgs);
        HashSet<PackageParser.Package> dependencies = new HashSet<PackageParser.Package>();
        for (PackageParser.Package p : result) {
            dependencies.addAll(packageManagerService.findSharedNonSystemLibraries(p));
        }
        if (!dependencies.isEmpty()) {
            dependencies.removeAll(result);
        }
        result.addAll(dependencies);
        return result;
    }

    public static String realpath(File path) throws IOException {
        try {
            return Libcore.os.realpath(path.getAbsolutePath());
        }
        catch (ErrnoException ee) {
            throw ee.rethrowAsIOException();
        }
    }
}

