/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.Context;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;

public class ProtectedPackages {
    @GuardedBy(value="this")
    private int mDeviceOwnerUserId;
    @GuardedBy(value="this")
    private String mDeviceOwnerPackage;
    @GuardedBy(value="this")
    private SparseArray<String> mProfileOwnerPackages;
    @GuardedBy(value="this")
    private final String mDeviceProvisioningPackage;
    private final Context mContext;

    public ProtectedPackages(Context context) {
        this.mContext = context;
        this.mDeviceProvisioningPackage = this.mContext.getResources().getString(17039475);
    }

    public synchronized void setDeviceAndProfileOwnerPackages(int deviceOwnerUserId, String deviceOwnerPackage, SparseArray<String> profileOwnerPackages) {
        this.mDeviceOwnerUserId = deviceOwnerUserId;
        this.mDeviceOwnerPackage = deviceOwnerUserId == -10000 ? null : deviceOwnerPackage;
        this.mProfileOwnerPackages = profileOwnerPackages == null ? null : profileOwnerPackages.clone();
    }

    private synchronized boolean hasDeviceOwnerOrProfileOwner(int userId, String packageName) {
        if (packageName == null) {
            return false;
        }
        if (this.mDeviceOwnerPackage != null && this.mDeviceOwnerUserId == userId && packageName.equals(this.mDeviceOwnerPackage)) {
            return true;
        }
        return this.mProfileOwnerPackages != null && packageName.equals(this.mProfileOwnerPackages.get(userId));
    }

    private synchronized boolean isProtectedPackage(String packageName) {
        return packageName != null && packageName.equals(this.mDeviceProvisioningPackage);
    }

    public boolean isPackageStateProtected(int userId, String packageName) {
        return this.hasDeviceOwnerOrProfileOwner(userId, packageName) || this.isProtectedPackage(packageName);
    }

    public boolean isPackageDataProtected(int userId, String packageName) {
        return this.hasDeviceOwnerOrProfileOwner(userId, packageName) || this.isProtectedPackage(packageName);
    }
}

