/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.pm.PackageParser;
import android.os.Environment;
import android.os.SystemProperties;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Slog;
import android.util.Xml;
import com.android.server.pm.Policy;
import com.android.server.pm.PolicyComparator;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class SELinuxMMAC {
    static final String TAG = "SELinuxMMAC";
    private static final boolean DEBUG_POLICY = false;
    private static final boolean DEBUG_POLICY_INSTALL = false;
    private static final boolean DEBUG_POLICY_ORDER = false;
    private static List<Policy> sPolicies = new ArrayList<Policy>();
    private static final String PROP_FORCE_RESTORECON = "sys.force_restorecon";
    private static final File VERSION_FILE = new File("/selinux_version");
    private static final File MAC_PERMISSIONS = new File(Environment.getRootDirectory(), "/etc/security/mac_permissions.xml");
    private static final File SEAPP_CONTEXTS = new File("/seapp_contexts");
    private static final byte[] SEAPP_CONTEXTS_HASH = SELinuxMMAC.returnHash(SEAPP_CONTEXTS);
    private static final String XATTR_SEAPP_HASH = "user.seapp_hash";
    private static final String PRIVILEGED_APP_STR = ":privapp";
    private static final String AUTOPLAY_APP_STR = ":autoplayapp";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean readInstallPolicy() {
        ArrayList<Policy> policies = new ArrayList<Policy>();
        FileReader policyFile = null;
        XmlPullParser parser = Xml.newPullParser();
        try {
            policyFile = new FileReader(MAC_PERMISSIONS);
            Slog.d(TAG, "Using policy file " + MAC_PERMISSIONS);
            parser.setInput(policyFile);
            parser.nextTag();
            parser.require(2, null, "policy");
            block15: while (parser.next() != 3) {
                if (parser.getEventType() != 2) continue;
                switch (parser.getName()) {
                    case "signer": {
                        policies.add(SELinuxMMAC.readSignerOrThrow(parser));
                        continue block15;
                    }
                }
                SELinuxMMAC.skip(parser);
            }
        }
        catch (IllegalArgumentException | IllegalStateException | XmlPullParserException ex) {
            StringBuilder sb = new StringBuilder("Exception @");
            sb.append(parser.getPositionDescription());
            sb.append(" while parsing ");
            sb.append(MAC_PERMISSIONS);
            sb.append(":");
            sb.append(ex);
            Slog.w(TAG, sb.toString());
            boolean bl = false;
            IoUtils.closeQuietly(policyFile);
            return bl;
        }
        catch (IOException ioe) {
            Slog.w(TAG, "Exception parsing " + MAC_PERMISSIONS, ioe);
            boolean bl = false;
            {
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(policyFile);
                    throw throwable;
                }
            }
            IoUtils.closeQuietly(policyFile);
            return bl;
        }
        IoUtils.closeQuietly(policyFile);
        PolicyComparator policySort = new PolicyComparator();
        Collections.sort(policies, policySort);
        if (policySort.foundDuplicate()) {
            Slog.w(TAG, "ERROR! Duplicate entries found parsing " + MAC_PERMISSIONS);
            return false;
        }
        List<Policy> list = sPolicies;
        synchronized (list) {
            sPolicies = policies;
        }
        return true;
    }

    private static Policy readSignerOrThrow(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, null, "signer");
        Policy.PolicyBuilder pb = new Policy.PolicyBuilder();
        String cert = parser.getAttributeValue(null, "signature");
        if (cert != null) {
            pb.addSignature(cert);
        }
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String tagName = parser.getName();
            if ("seinfo".equals(tagName)) {
                String seinfo = parser.getAttributeValue(null, "value");
                pb.setGlobalSeinfoOrThrow(seinfo);
                SELinuxMMAC.readSeinfo(parser);
                continue;
            }
            if ("package".equals(tagName)) {
                SELinuxMMAC.readPackageOrThrow(parser, pb);
                continue;
            }
            if ("cert".equals(tagName)) {
                String sig = parser.getAttributeValue(null, "signature");
                pb.addSignature(sig);
                SELinuxMMAC.readCert(parser);
                continue;
            }
            SELinuxMMAC.skip(parser);
        }
        return pb.build();
    }

    private static void readPackageOrThrow(XmlPullParser parser, Policy.PolicyBuilder pb) throws IOException, XmlPullParserException {
        parser.require(2, null, "package");
        String pkgName = parser.getAttributeValue(null, "name");
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String tagName = parser.getName();
            if ("seinfo".equals(tagName)) {
                String seinfo = parser.getAttributeValue(null, "value");
                pb.addInnerPackageMapOrThrow(pkgName, seinfo);
                SELinuxMMAC.readSeinfo(parser);
                continue;
            }
            SELinuxMMAC.skip(parser);
        }
    }

    private static void readCert(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, null, "cert");
        parser.nextTag();
    }

    private static void readSeinfo(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, null, "seinfo");
        parser.nextTag();
    }

    private static void skip(XmlPullParser p) throws IOException, XmlPullParserException {
        if (p.getEventType() != 2) {
            throw new IllegalStateException();
        }
        int depth = 1;
        while (depth != 0) {
            switch (p.next()) {
                case 3: {
                    --depth;
                    break;
                }
                case 2: {
                    ++depth;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assignSeinfoValue(PackageParser.Package pkg) {
        List<Policy> list = sPolicies;
        synchronized (list) {
            for (Policy policy : sPolicies) {
                String seinfo = policy.getMatchedSeinfo(pkg);
                if (seinfo == null) continue;
                pkg.applicationInfo.seinfo = seinfo;
                break;
            }
        }
        if (pkg.applicationInfo.isAutoPlayApp()) {
            pkg.applicationInfo.seinfo = pkg.applicationInfo.seinfo + AUTOPLAY_APP_STR;
        }
        if (pkg.applicationInfo.isPrivilegedApp()) {
            pkg.applicationInfo.seinfo = pkg.applicationInfo.seinfo + PRIVILEGED_APP_STR;
        }
    }

    public static boolean isRestoreconNeeded(File file) {
        block4: {
            if (SystemProperties.getBoolean(PROP_FORCE_RESTORECON, false)) {
                return true;
            }
            try {
                byte[] buf = new byte[20];
                int len = Os.getxattr(file.getAbsolutePath(), XATTR_SEAPP_HASH, buf);
                if (len == 20 && Arrays.equals(SEAPP_CONTEXTS_HASH, buf)) {
                    return false;
                }
            }
            catch (ErrnoException e) {
                if (e.errno == OsConstants.ENODATA) break block4;
                Slog.e(TAG, "Failed to read seapp hash for " + file, e);
            }
        }
        return true;
    }

    public static void setRestoreconDone(File file) {
        try {
            Os.setxattr(file.getAbsolutePath(), XATTR_SEAPP_HASH, SEAPP_CONTEXTS_HASH, 0);
        }
        catch (ErrnoException e) {
            Slog.e(TAG, "Failed to persist seapp hash in " + file, e);
        }
    }

    private static byte[] returnHash(File file) {
        try {
            byte[] contents = IoUtils.readFileAsByteArray(file.getAbsolutePath());
            return MessageDigest.getInstance("SHA-1").digest(contents);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

