/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.ComponentName;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.IntentFilterVerificationInfo;
import android.content.pm.PackageCleanItem;
import android.content.pm.PackageManager;
import android.content.pm.PackageParser;
import android.content.pm.PackageUserState;
import android.content.pm.PermissionInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.content.pm.UserInfo;
import android.content.pm.VerifierDeviceIdentity;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.Message;
import android.os.PatternMatcher;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.storage.StorageManager;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.SparseLongArray;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.BackgroundThread;
import com.android.internal.os.InstallerConnection;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.JournaledFile;
import com.android.internal.util.XmlUtils;
import com.android.server.pm.BasePermission;
import com.android.server.pm.CrossProfileIntentFilter;
import com.android.server.pm.CrossProfileIntentResolver;
import com.android.server.pm.Installer;
import com.android.server.pm.KeySetManagerService;
import com.android.server.pm.PackageKeySetData;
import com.android.server.pm.PackageManagerService;
import com.android.server.pm.PackageSetting;
import com.android.server.pm.PackageSettingBase;
import com.android.server.pm.PackageSignatures;
import com.android.server.pm.PendingPackage;
import com.android.server.pm.PermissionsState;
import com.android.server.pm.PersistentPreferredActivity;
import com.android.server.pm.PersistentPreferredIntentResolver;
import com.android.server.pm.PreferredActivity;
import com.android.server.pm.PreferredIntentResolver;
import com.android.server.pm.SettingBase;
import com.android.server.pm.SharedUserSetting;
import com.android.server.pm.UserManagerService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

final class Settings {
    private static final String TAG = "PackageSettings";
    public static final int CURRENT_DATABASE_VERSION = 3;
    private static final boolean DEBUG_STOPPED = false;
    private static final boolean DEBUG_MU = false;
    private static final boolean DEBUG_KERNEL = false;
    private static final String RUNTIME_PERMISSIONS_FILE_NAME = "runtime-permissions.xml";
    private static final String TAG_READ_EXTERNAL_STORAGE = "read-external-storage";
    private static final String ATTR_ENFORCEMENT = "enforcement";
    private static final String TAG_ITEM = "item";
    private static final String TAG_DISABLED_COMPONENTS = "disabled-components";
    private static final String TAG_ENABLED_COMPONENTS = "enabled-components";
    private static final String TAG_PACKAGE_RESTRICTIONS = "package-restrictions";
    private static final String TAG_PACKAGE = "pkg";
    private static final String TAG_SHARED_USER = "shared-user";
    private static final String TAG_RUNTIME_PERMISSIONS = "runtime-permissions";
    private static final String TAG_PERMISSIONS = "perms";
    private static final String TAG_CHILD_PACKAGE = "child-package";
    private static final String TAG_PERSISTENT_PREFERRED_ACTIVITIES = "persistent-preferred-activities";
    static final String TAG_CROSS_PROFILE_INTENT_FILTERS = "crossProfile-intent-filters";
    private static final String TAG_DOMAIN_VERIFICATION = "domain-verification";
    private static final String TAG_DEFAULT_APPS = "default-apps";
    private static final String TAG_ALL_INTENT_FILTER_VERIFICATION = "all-intent-filter-verifications";
    private static final String TAG_DEFAULT_BROWSER = "default-browser";
    private static final String TAG_DEFAULT_DIALER = "default-dialer";
    private static final String TAG_VERSION = "version";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_USER = "user";
    private static final String ATTR_CODE = "code";
    private static final String ATTR_GRANTED = "granted";
    private static final String ATTR_FLAGS = "flags";
    private static final String ATTR_CE_DATA_INODE = "ceDataInode";
    private static final String ATTR_INSTALLED = "inst";
    private static final String ATTR_STOPPED = "stopped";
    private static final String ATTR_NOT_LAUNCHED = "nl";
    private static final String ATTR_BLOCKED = "blocked";
    private static final String ATTR_HIDDEN = "hidden";
    private static final String ATTR_SUSPENDED = "suspended";
    private static final String ATTR_BLOCK_UNINSTALL = "blockUninstall";
    private static final String ATTR_ENABLED = "enabled";
    private static final String ATTR_ENABLED_CALLER = "enabledCaller";
    private static final String ATTR_DOMAIN_VERIFICATON_STATE = "domainVerificationStatus";
    private static final String ATTR_APP_LINK_GENERATION = "app-link-generation";
    private static final String ATTR_PACKAGE_NAME = "packageName";
    private static final String ATTR_FINGERPRINT = "fingerprint";
    private static final String ATTR_VOLUME_UUID = "volumeUuid";
    private static final String ATTR_SDK_VERSION = "sdkVersion";
    private static final String ATTR_DATABASE_VERSION = "databaseVersion";
    private static final String ATTR_DONE = "done";
    private static final String TAG_RESTORED_RUNTIME_PERMISSIONS = "restored-perms";
    private static final String TAG_PERMISSION_ENTRY = "perm";
    private static final String ATTR_USER_SET = "set";
    private static final String ATTR_USER_FIXED = "fixed";
    private static final String ATTR_REVOKE_ON_UPGRADE = "rou";
    private static final int USER_RUNTIME_GRANT_MASK = 11;
    private final Object mLock;
    private final RuntimePermissionPersistence mRuntimePermissionsPersistence;
    private final File mSettingsFilename;
    private final File mBackupSettingsFilename;
    private final File mPackageListFilename;
    private final File mStoppedPackagesFilename;
    private final File mBackupStoppedPackagesFilename;
    private final File mKernelMappingFilename;
    final ArrayMap<String, PackageSetting> mPackages = new ArrayMap();
    final ArraySet<String> mInstallerPackages = new ArraySet();
    private final ArrayMap<String, Integer> mKernelMapping = new ArrayMap();
    private final ArrayMap<String, PackageSetting> mDisabledSysPackages = new ArrayMap();
    private final ArrayMap<String, IntentFilterVerificationInfo> mRestoredIntentFilterVerifications = new ArrayMap();
    private final SparseArray<ArrayMap<String, ArraySet<RestoredPermissionGrant>>> mRestoredUserGrants = new SparseArray();
    private static int mFirstAvailableUid = 0;
    private ArrayMap<String, VersionInfo> mVersion = new ArrayMap();
    Boolean mReadExternalStorageEnforced;
    private VerifierDeviceIdentity mVerifierDeviceIdentity;
    final SparseArray<PreferredIntentResolver> mPreferredActivities = new SparseArray();
    final SparseArray<PersistentPreferredIntentResolver> mPersistentPreferredActivities = new SparseArray();
    final SparseArray<CrossProfileIntentResolver> mCrossProfileIntentResolvers = new SparseArray();
    final ArrayMap<String, SharedUserSetting> mSharedUsers = new ArrayMap();
    private final ArrayList<Object> mUserIds = new ArrayList();
    private final SparseArray<Object> mOtherUserIds = new SparseArray();
    private final ArrayList<Signature> mPastSignatures = new ArrayList();
    private final ArrayMap<Long, Integer> mKeySetRefs = new ArrayMap();
    final ArrayMap<String, BasePermission> mPermissions = new ArrayMap();
    final ArrayMap<String, BasePermission> mPermissionTrees = new ArrayMap();
    final ArrayList<PackageCleanItem> mPackagesToBeCleaned = new ArrayList();
    final ArrayMap<String, String> mRenamedPackages = new ArrayMap();
    final SparseArray<String> mDefaultBrowserApp = new SparseArray();
    final SparseArray<String> mDefaultDialerApp = new SparseArray();
    final SparseIntArray mNextAppLinkGeneration = new SparseIntArray();
    final StringBuilder mReadMessages = new StringBuilder();
    private final ArrayList<PendingPackage> mPendingPackages = new ArrayList();
    private final File mSystemDir;
    public final KeySetManagerService mKeySetManagerService = new KeySetManagerService(this.mPackages);
    private static int PRE_M_APP_INFO_FLAG_HIDDEN = 0x8000000;
    private static int PRE_M_APP_INFO_FLAG_CANT_SAVE_STATE = 0x10000000;
    private static int PRE_M_APP_INFO_FLAG_FORWARD_LOCK = 0x20000000;
    private static int PRE_M_APP_INFO_FLAG_PRIVILEGED = 0x40000000;
    static final Object[] FLAG_DUMP_SPEC = new Object[]{1, "SYSTEM", 2, "DEBUGGABLE", 4, "HAS_CODE", 8, "PERSISTENT", 16, "FACTORY_TEST", 32, "ALLOW_TASK_REPARENTING", 64, "ALLOW_CLEAR_USER_DATA", 128, "UPDATED_SYSTEM_APP", 256, "TEST_ONLY", 16384, "VM_SAFE_MODE", 32768, "ALLOW_BACKUP", 65536, "KILL_AFTER_RESTORE", 131072, "RESTORE_ANY_VERSION", 262144, "EXTERNAL_STORAGE", 0x100000, "LARGE_HEAP"};
    static final Object[] PRIVATE_FLAG_DUMP_SPEC = new Object[]{1, "HIDDEN", 2, "CANT_SAVE_STATE", 4, "FORWARD_LOCK", 8, "PRIVILEGED", 16, "HAS_DOMAIN_URLS", 32, "DEFAULT_TO_DEVICE_PROTECTED_STORAGE", 64, "DIRECT_BOOT_AWARE", 128, "AUTOPLAY", 256, "PARTIALLY_DIRECT_BOOT_AWARE", 512, "EPHEMERAL", 1024, "REQUIRED_FOR_SYSTEM_USER", 2048, "RESIZEABLE_ACTIVITIES", 4096, "BACKUP_IN_FOREGROUND"};

    Settings(Object lock) {
        this(Environment.getDataDirectory(), lock);
    }

    Settings(File dataDir, Object lock) {
        this.mLock = lock;
        this.mRuntimePermissionsPersistence = new RuntimePermissionPersistence(this.mLock);
        this.mSystemDir = new File(dataDir, "system");
        this.mSystemDir.mkdirs();
        FileUtils.setPermissions(this.mSystemDir.toString(), 509, -1, -1);
        this.mSettingsFilename = new File(this.mSystemDir, "packages.xml");
        this.mBackupSettingsFilename = new File(this.mSystemDir, "packages-backup.xml");
        this.mPackageListFilename = new File(this.mSystemDir, "packages.list");
        FileUtils.setPermissions(this.mPackageListFilename, 416, 1000, 1032);
        File kernelDir = new File("/config/sdcardfs");
        this.mKernelMappingFilename = kernelDir.exists() ? kernelDir : null;
        this.mStoppedPackagesFilename = new File(this.mSystemDir, "packages-stopped.xml");
        this.mBackupStoppedPackagesFilename = new File(this.mSystemDir, "packages-stopped-backup.xml");
    }

    PackageSetting getPackageLPw(PackageParser.Package pkg, PackageSetting origPackage, String realName, SharedUserSetting sharedUser, File codePath, File resourcePath, String legacyNativeLibraryPathString, String primaryCpuAbi, String secondaryCpuAbi, int pkgFlags, int pkgPrivateFlags, UserHandle user, boolean add) {
        String name = pkg.packageName;
        String parentPackageName = pkg.parentPackage != null ? pkg.parentPackage.packageName : null;
        ArrayList<String> childPackageNames = null;
        if (pkg.childPackages != null) {
            int childCount = pkg.childPackages.size();
            childPackageNames = new ArrayList<String>(childCount);
            for (int i = 0; i < childCount; ++i) {
                String childPackageName = pkg.childPackages.get((int)i).packageName;
                childPackageNames.add(childPackageName);
            }
        }
        PackageSetting p = this.getPackageLPw(name, origPackage, realName, sharedUser, codePath, resourcePath, legacyNativeLibraryPathString, primaryCpuAbi, secondaryCpuAbi, pkg.mVersionCode, pkgFlags, pkgPrivateFlags, user, add, true, parentPackageName, childPackageNames);
        return p;
    }

    PackageSetting peekPackageLPr(String name) {
        return this.mPackages.get(name);
    }

    void setInstallStatus(String pkgName, int status) {
        PackageSetting p = this.mPackages.get(pkgName);
        if (p != null && p.getInstallStatus() != status) {
            p.setInstallStatus(status);
        }
    }

    void applyPendingPermissionGrantsLPw(String packageName, int userId) {
        ArrayMap<String, ArraySet<RestoredPermissionGrant>> grantsByPackage = this.mRestoredUserGrants.get(userId);
        if (grantsByPackage == null || grantsByPackage.size() == 0) {
            return;
        }
        ArraySet<RestoredPermissionGrant> grants = grantsByPackage.get(packageName);
        if (grants == null || grants.size() == 0) {
            return;
        }
        PackageSetting ps = this.mPackages.get(packageName);
        if (ps == null) {
            Slog.e(TAG, "Can't find supposedly installed package " + packageName);
            return;
        }
        PermissionsState perms = ps.getPermissionsState();
        for (RestoredPermissionGrant grant : grants) {
            BasePermission bp = this.mPermissions.get(grant.permissionName);
            if (bp == null) continue;
            if (grant.granted) {
                perms.grantRuntimePermission(bp, userId);
            }
            perms.updatePermissionFlags(bp, userId, 11, grant.grantBits);
        }
        grantsByPackage.remove(packageName);
        if (grantsByPackage.size() < 1) {
            this.mRestoredUserGrants.remove(userId);
        }
        this.writeRuntimePermissionsForUserLPr(userId, false);
    }

    void setInstallerPackageName(String pkgName, String installerPkgName) {
        PackageSetting p = this.mPackages.get(pkgName);
        if (p != null) {
            p.setInstallerPackageName(installerPkgName);
            if (installerPkgName != null) {
                this.mInstallerPackages.add(installerPkgName);
            }
        }
    }

    SharedUserSetting getSharedUserLPw(String name, int pkgFlags, int pkgPrivateFlags, boolean create) {
        SharedUserSetting s = this.mSharedUsers.get(name);
        if (s == null) {
            if (!create) {
                return null;
            }
            s = new SharedUserSetting(name, pkgFlags, pkgPrivateFlags);
            s.userId = this.newUserIdLPw(s);
            Log.i("PackageManager", "New shared user " + name + ": id=" + s.userId);
            if (s.userId >= 0) {
                this.mSharedUsers.put(name, s);
            }
        }
        return s;
    }

    Collection<SharedUserSetting> getAllSharedUsersLPw() {
        return this.mSharedUsers.values();
    }

    boolean disableSystemPackageLPw(String name, boolean replaced) {
        PackageSetting p = this.mPackages.get(name);
        if (p == null) {
            Log.w("PackageManager", "Package " + name + " is not an installed package");
            return false;
        }
        PackageSetting dp = this.mDisabledSysPackages.get(name);
        if (dp == null && p.pkg != null && p.pkg.isSystemApp() && !p.pkg.isUpdatedSystemApp()) {
            if (p.pkg != null && p.pkg.applicationInfo != null) {
                p.pkg.applicationInfo.flags |= 0x80;
            }
            this.mDisabledSysPackages.put(name, p);
            if (replaced) {
                PackageSetting newp = new PackageSetting(p);
                this.replacePackageLPw(name, newp);
            }
            return true;
        }
        return false;
    }

    PackageSetting enableSystemPackageLPw(String name) {
        PackageSetting p = this.mDisabledSysPackages.get(name);
        if (p == null) {
            Log.w("PackageManager", "Package " + name + " is not disabled");
            return null;
        }
        if (p.pkg != null && p.pkg.applicationInfo != null) {
            p.pkg.applicationInfo.flags &= 0xFFFFFF7F;
        }
        PackageSetting ret = this.addPackageLPw(name, p.realName, p.codePath, p.resourcePath, p.legacyNativeLibraryPathString, p.primaryCpuAbiString, p.secondaryCpuAbiString, p.cpuAbiOverrideString, p.appId, p.versionCode, p.pkgFlags, p.pkgPrivateFlags, p.parentPackageName, p.childPackageNames);
        this.mDisabledSysPackages.remove(name);
        return ret;
    }

    boolean isDisabledSystemPackageLPr(String name) {
        return this.mDisabledSysPackages.containsKey(name);
    }

    void removeDisabledSystemPackageLPw(String name) {
        this.mDisabledSysPackages.remove(name);
    }

    PackageSetting addPackageLPw(String name, String realName, File codePath, File resourcePath, String legacyNativeLibraryPathString, String primaryCpuAbiString, String secondaryCpuAbiString, String cpuAbiOverrideString, int uid, int vc, int pkgFlags, int pkgPrivateFlags, String parentPackageName, List<String> childPackageNames) {
        PackageSetting p = this.mPackages.get(name);
        if (p != null) {
            if (p.appId == uid) {
                return p;
            }
            PackageManagerService.reportSettingsProblem(6, "Adding duplicate package, keeping first: " + name);
            return null;
        }
        p = new PackageSetting(name, realName, codePath, resourcePath, legacyNativeLibraryPathString, primaryCpuAbiString, secondaryCpuAbiString, cpuAbiOverrideString, vc, pkgFlags, pkgPrivateFlags, parentPackageName, childPackageNames);
        p.appId = uid;
        if (this.addUserIdLPw(uid, p, name)) {
            this.mPackages.put(name, p);
            return p;
        }
        return null;
    }

    SharedUserSetting addSharedUserLPw(String name, int uid, int pkgFlags, int pkgPrivateFlags) {
        SharedUserSetting s = this.mSharedUsers.get(name);
        if (s != null) {
            if (s.userId == uid) {
                return s;
            }
            PackageManagerService.reportSettingsProblem(6, "Adding duplicate shared user, keeping first: " + name);
            return null;
        }
        s = new SharedUserSetting(name, pkgFlags, pkgPrivateFlags);
        s.userId = uid;
        if (this.addUserIdLPw(uid, s, name)) {
            this.mSharedUsers.put(name, s);
            return s;
        }
        return null;
    }

    void pruneSharedUsersLPw() {
        ArrayList<String> removeStage = new ArrayList<String>();
        for (Map.Entry<String, SharedUserSetting> entry : this.mSharedUsers.entrySet()) {
            SharedUserSetting sus = entry.getValue();
            if (sus == null) {
                removeStage.add(entry.getKey());
                continue;
            }
            Iterator<PackageSetting> iter = sus.packages.iterator();
            while (iter.hasNext()) {
                PackageSetting ps = iter.next();
                if (this.mPackages.get(ps.name) != null) continue;
                iter.remove();
            }
            if (sus.packages.size() != 0) continue;
            removeStage.add(entry.getKey());
        }
        for (int i = 0; i < removeStage.size(); ++i) {
            this.mSharedUsers.remove(removeStage.get(i));
        }
    }

    void transferPermissionsLPw(String origPkg, String newPkg) {
        for (int i = 0; i < 2; ++i) {
            ArrayMap<String, BasePermission> permissions = i == 0 ? this.mPermissionTrees : this.mPermissions;
            for (BasePermission bp : permissions.values()) {
                if (!origPkg.equals(bp.sourcePackage)) continue;
                bp.sourcePackage = newPkg;
                bp.packageSetting = null;
                bp.perm = null;
                if (bp.pendingInfo != null) {
                    bp.pendingInfo.packageName = newPkg;
                }
                bp.uid = 0;
                bp.setGids(null, false);
            }
        }
    }

    private PackageSetting getPackageLPw(String name, PackageSetting origPackage, String realName, SharedUserSetting sharedUser, File codePath, File resourcePath, String legacyNativeLibraryPathString, String primaryCpuAbiString, String secondaryCpuAbiString, int vc, int pkgFlags, int pkgPrivateFlags, UserHandle installUser, boolean add, boolean allowInstall, String parentPackage, List<String> childPackageNames) {
        List<UserInfo> users;
        PackageSetting p = this.mPackages.get(name);
        UserManagerService userManager = UserManagerService.getInstance();
        if (p != null) {
            p.primaryCpuAbiString = primaryCpuAbiString;
            p.secondaryCpuAbiString = secondaryCpuAbiString;
            if (childPackageNames != null) {
                p.childPackageNames = new ArrayList<String>(childPackageNames);
            }
            if (!p.codePath.equals(codePath)) {
                if ((p.pkgFlags & 1) != 0) {
                    Slog.w("PackageManager", "Trying to update system app code path from " + p.codePathString + " to " + codePath.toString());
                } else {
                    List<UserInfo> allUserInfos;
                    Slog.i("PackageManager", "Package " + name + " codePath changed from " + p.codePath + " to " + codePath + "; Retaining data and using new");
                    if ((pkgFlags & 1) != 0 && this.getDisabledSystemPkgLPr(name) == null && (allUserInfos = this.getAllUsers()) != null) {
                        for (UserInfo userInfo : allUserInfos) {
                            p.setInstalled(true, userInfo.id);
                        }
                    }
                    p.legacyNativeLibraryPathString = legacyNativeLibraryPathString;
                }
            }
            if (p.sharedUser != sharedUser) {
                PackageManagerService.reportSettingsProblem(5, "Package " + name + " shared user changed from " + (p.sharedUser != null ? p.sharedUser.name : "<nothing>") + " to " + (sharedUser != null ? sharedUser.name : "<nothing>") + "; replacing with new");
                p = null;
            } else {
                p.pkgFlags |= pkgFlags & 1;
                p.pkgPrivateFlags |= pkgPrivateFlags & 8;
            }
        }
        if (p == null) {
            if (origPackage != null) {
                p = new PackageSetting(origPackage.name, name, codePath, resourcePath, legacyNativeLibraryPathString, primaryCpuAbiString, secondaryCpuAbiString, null, vc, pkgFlags, pkgPrivateFlags, parentPackage, childPackageNames);
                PackageSignatures s = p.signatures;
                p.copyFrom(origPackage);
                p.signatures = s;
                p.sharedUser = origPackage.sharedUser;
                p.appId = origPackage.appId;
                p.origPackage = origPackage;
                p.getPermissionsState().copyFrom(origPackage.getPermissionsState());
                this.mRenamedPackages.put(name, origPackage.name);
                name = origPackage.name;
                p.setTimeStamp(codePath.lastModified());
            } else {
                p = new PackageSetting(name, realName, codePath, resourcePath, legacyNativeLibraryPathString, primaryCpuAbiString, secondaryCpuAbiString, null, vc, pkgFlags, pkgPrivateFlags, parentPackage, childPackageNames);
                p.setTimeStamp(codePath.lastModified());
                p.sharedUser = sharedUser;
                if ((pkgFlags & 1) == 0) {
                    int installUserId;
                    users = this.getAllUsers();
                    int n = installUserId = installUser != null ? installUser.getIdentifier() : 0;
                    if (users != null && allowInstall) {
                        for (UserInfo user : users) {
                            boolean installed = installUser == null || installUserId == -1 && !this.isAdbInstallDisallowed(userManager, user.id) || installUserId == user.id;
                            p.setUserState(user.id, 0L, 0, installed, true, true, false, false, null, null, null, false, 0, 0);
                            this.writePackageRestrictionsLPr(user.id);
                        }
                    }
                }
                if (sharedUser != null) {
                    p.appId = sharedUser.userId;
                } else {
                    PackageSetting dis = this.mDisabledSysPackages.get(name);
                    if (dis != null) {
                        if (dis.signatures.mSignatures != null) {
                            p.signatures.mSignatures = (Signature[])dis.signatures.mSignatures.clone();
                        }
                        p.appId = dis.appId;
                        p.getPermissionsState().copyFrom(dis.getPermissionsState());
                        List<UserInfo> users2 = this.getAllUsers();
                        if (users2 != null) {
                            for (UserInfo user : users2) {
                                int userId = user.id;
                                p.setDisabledComponentsCopy(dis.getDisabledComponents(userId), userId);
                                p.setEnabledComponentsCopy(dis.getEnabledComponents(userId), userId);
                            }
                        }
                        this.addUserIdLPw(p.appId, p, name);
                    } else {
                        p.appId = this.newUserIdLPw(p);
                    }
                }
            }
            if (p.appId < 0) {
                PackageManagerService.reportSettingsProblem(5, "Package " + name + " could not be assigned a valid uid");
                return null;
            }
            if (add) {
                this.addPackageSettingLPw(p, name, sharedUser);
            }
        } else if (installUser != null && allowInstall && (users = this.getAllUsers()) != null) {
            for (UserInfo userInfo : users) {
                boolean installed;
                if ((installUser.getIdentifier() != -1 || this.isAdbInstallDisallowed(userManager, userInfo.id)) && installUser.getIdentifier() != userInfo.id || (installed = p.getInstalled(userInfo.id))) continue;
                p.setInstalled(true, userInfo.id);
                this.writePackageRestrictionsLPr(userInfo.id);
            }
        }
        return p;
    }

    boolean isAdbInstallDisallowed(UserManagerService userManager, int userId) {
        return userManager.hasUserRestriction("no_debugging_features", userId);
    }

    void insertPackageSettingLPw(PackageSetting p, PackageParser.Package pkg) {
        p.pkg = pkg;
        String volumeUuid = pkg.applicationInfo.volumeUuid;
        String codePath = pkg.applicationInfo.getCodePath();
        String resourcePath = pkg.applicationInfo.getResourcePath();
        String legacyNativeLibraryPath = pkg.applicationInfo.nativeLibraryRootDir;
        if (!Objects.equals(volumeUuid, p.volumeUuid)) {
            Slog.w("PackageManager", "Volume for " + p.pkg.packageName + " changing from " + p.volumeUuid + " to " + volumeUuid);
            p.volumeUuid = volumeUuid;
        }
        if (!Objects.equals(codePath, p.codePathString)) {
            Slog.w("PackageManager", "Code path for " + p.pkg.packageName + " changing from " + p.codePathString + " to " + codePath);
            p.codePath = new File(codePath);
            p.codePathString = codePath;
        }
        if (!Objects.equals(resourcePath, p.resourcePathString)) {
            Slog.w("PackageManager", "Resource path for " + p.pkg.packageName + " changing from " + p.resourcePathString + " to " + resourcePath);
            p.resourcePath = new File(resourcePath);
            p.resourcePathString = resourcePath;
        }
        if (!Objects.equals(legacyNativeLibraryPath, p.legacyNativeLibraryPathString)) {
            p.legacyNativeLibraryPathString = legacyNativeLibraryPath;
        }
        p.primaryCpuAbiString = pkg.applicationInfo.primaryCpuAbi;
        p.secondaryCpuAbiString = pkg.applicationInfo.secondaryCpuAbi;
        p.cpuAbiOverrideString = pkg.cpuAbiOverride;
        if (pkg.mVersionCode != p.versionCode) {
            p.versionCode = pkg.mVersionCode;
        }
        if (p.signatures.mSignatures == null) {
            p.signatures.assignSignatures(pkg.mSignatures);
        }
        if (pkg.applicationInfo.flags != p.pkgFlags) {
            p.pkgFlags = pkg.applicationInfo.flags;
        }
        if (p.sharedUser != null && p.sharedUser.signatures.mSignatures == null) {
            p.sharedUser.signatures.assignSignatures(pkg.mSignatures);
        }
        this.addPackageSettingLPw(p, pkg.packageName, p.sharedUser);
    }

    private void addPackageSettingLPw(PackageSetting p, String name, SharedUserSetting sharedUser) {
        IntentFilterVerificationInfo ivi;
        this.mPackages.put(name, p);
        if (sharedUser != null) {
            if (p.sharedUser != null && p.sharedUser != sharedUser) {
                PackageManagerService.reportSettingsProblem(6, "Package " + p.name + " was user " + p.sharedUser + " but is now " + sharedUser + "; I am not changing its files so it will probably fail!");
                p.sharedUser.removePackage(p);
            } else if (p.appId != sharedUser.userId) {
                PackageManagerService.reportSettingsProblem(6, "Package " + p.name + " was user id " + p.appId + " but is now user " + sharedUser + " with id " + sharedUser.userId + "; I am not changing its files so it will probably fail!");
            }
            sharedUser.addPackage(p);
            p.sharedUser = sharedUser;
            p.appId = sharedUser.userId;
        }
        Object userIdPs = this.getUserIdLPr(p.appId);
        if (sharedUser == null) {
            if (userIdPs != null && userIdPs != p) {
                this.replaceUserIdLPw(p.appId, p);
            }
        } else if (userIdPs != null && userIdPs != sharedUser) {
            this.replaceUserIdLPw(p.appId, sharedUser);
        }
        if ((ivi = this.mRestoredIntentFilterVerifications.get(name)) != null) {
            this.mRestoredIntentFilterVerifications.remove(name);
            p.setIntentFilterVerificationInfo(ivi);
        }
    }

    int updateSharedUserPermsLPw(PackageSetting deletedPs, int userId) {
        if (deletedPs == null || deletedPs.pkg == null) {
            Slog.i("PackageManager", "Trying to update info for null package. Just ignoring");
            return -10000;
        }
        if (deletedPs.sharedUser == null) {
            return -10000;
        }
        SharedUserSetting sus = deletedPs.sharedUser;
        for (String eachPerm : deletedPs.pkg.requestedPermissions) {
            BasePermission bp = this.mPermissions.get(eachPerm);
            if (bp == null) continue;
            boolean used = false;
            for (PackageSetting pkg : sus.packages) {
                if (pkg.pkg == null || pkg.pkg.packageName.equals(deletedPs.pkg.packageName) || !pkg.pkg.requestedPermissions.contains(eachPerm)) continue;
                used = true;
                break;
            }
            if (used) continue;
            PermissionsState permissionsState = sus.getPermissionsState();
            PackageSetting disabledPs = this.getDisabledSystemPkgLPr(deletedPs.pkg.packageName);
            if (disabledPs != null) {
                boolean reqByDisabledSysPkg = false;
                for (String permission2 : disabledPs.pkg.requestedPermissions) {
                    if (!permission2.equals(eachPerm)) continue;
                    reqByDisabledSysPkg = true;
                    break;
                }
                if (reqByDisabledSysPkg) continue;
            }
            permissionsState.updatePermissionFlags(bp, userId, 255, 0);
            if (permissionsState.revokeInstallPermission(bp) == 1) {
                return -1;
            }
            if (permissionsState.revokeRuntimePermission(bp, userId) != 1) continue;
            return userId;
        }
        return -10000;
    }

    int removePackageLPw(String name) {
        PackageSetting p = this.mPackages.get(name);
        if (p != null) {
            this.mPackages.remove(name);
            this.removeInstallerPackageStatus(name);
            if (p.sharedUser != null) {
                p.sharedUser.removePackage(p);
                if (p.sharedUser.packages.size() == 0) {
                    this.mSharedUsers.remove(p.sharedUser.name);
                    this.removeUserIdLPw(p.sharedUser.userId);
                    return p.sharedUser.userId;
                }
            } else {
                this.removeUserIdLPw(p.appId);
                return p.appId;
            }
        }
        return -1;
    }

    private void removeInstallerPackageStatus(String packageName) {
        if (!this.mInstallerPackages.contains(packageName)) {
            return;
        }
        for (int i = 0; i < this.mPackages.size(); ++i) {
            PackageSetting ps = this.mPackages.valueAt(i);
            String installerPackageName = ps.getInstallerPackageName();
            if (installerPackageName == null || !installerPackageName.equals(packageName)) continue;
            ps.setInstallerPackageName(null);
            ps.isOrphaned = true;
        }
        this.mInstallerPackages.remove(packageName);
    }

    private void replacePackageLPw(String name, PackageSetting newp) {
        PackageSetting p = this.mPackages.get(name);
        if (p != null) {
            if (p.sharedUser != null) {
                p.sharedUser.removePackage(p);
                p.sharedUser.addPackage(newp);
            } else {
                this.replaceUserIdLPw(p.appId, newp);
            }
        }
        this.mPackages.put(name, newp);
    }

    private boolean addUserIdLPw(int uid, Object obj, Object name) {
        if (uid > 19999) {
            return false;
        }
        if (uid >= 10000) {
            int index = uid - 10000;
            for (int N = this.mUserIds.size(); index >= N; ++N) {
                this.mUserIds.add(null);
            }
            if (this.mUserIds.get(index) != null) {
                PackageManagerService.reportSettingsProblem(6, "Adding duplicate user id: " + uid + " name=" + name);
                return false;
            }
            this.mUserIds.set(index, obj);
        } else {
            if (this.mOtherUserIds.get(uid) != null) {
                PackageManagerService.reportSettingsProblem(6, "Adding duplicate shared id: " + uid + " name=" + name);
                return false;
            }
            this.mOtherUserIds.put(uid, obj);
        }
        return true;
    }

    public Object getUserIdLPr(int uid) {
        if (uid >= 10000) {
            int index = uid - 10000;
            int N = this.mUserIds.size();
            return index < N ? this.mUserIds.get(index) : null;
        }
        return this.mOtherUserIds.get(uid);
    }

    private void removeUserIdLPw(int uid) {
        if (uid >= 10000) {
            int index = uid - 10000;
            int N = this.mUserIds.size();
            if (index < N) {
                this.mUserIds.set(index, null);
            }
        } else {
            this.mOtherUserIds.remove(uid);
        }
        this.setFirstAvailableUid(uid + 1);
    }

    private void replaceUserIdLPw(int uid, Object obj) {
        if (uid >= 10000) {
            int index = uid - 10000;
            int N = this.mUserIds.size();
            if (index < N) {
                this.mUserIds.set(index, obj);
            }
        } else {
            this.mOtherUserIds.put(uid, obj);
        }
    }

    PreferredIntentResolver editPreferredActivitiesLPw(int userId) {
        PreferredIntentResolver pir = this.mPreferredActivities.get(userId);
        if (pir == null) {
            pir = new PreferredIntentResolver();
            this.mPreferredActivities.put(userId, pir);
        }
        return pir;
    }

    PersistentPreferredIntentResolver editPersistentPreferredActivitiesLPw(int userId) {
        PersistentPreferredIntentResolver ppir = this.mPersistentPreferredActivities.get(userId);
        if (ppir == null) {
            ppir = new PersistentPreferredIntentResolver();
            this.mPersistentPreferredActivities.put(userId, ppir);
        }
        return ppir;
    }

    CrossProfileIntentResolver editCrossProfileIntentResolverLPw(int userId) {
        CrossProfileIntentResolver cpir = this.mCrossProfileIntentResolvers.get(userId);
        if (cpir == null) {
            cpir = new CrossProfileIntentResolver();
            this.mCrossProfileIntentResolvers.put(userId, cpir);
        }
        return cpir;
    }

    IntentFilterVerificationInfo getIntentFilterVerificationLPr(String packageName) {
        PackageSetting ps = this.mPackages.get(packageName);
        if (ps == null) {
            return null;
        }
        return ps.getIntentFilterVerificationInfo();
    }

    IntentFilterVerificationInfo createIntentFilterVerificationIfNeededLPw(String packageName, ArrayList<String> domains) {
        PackageSetting ps = this.mPackages.get(packageName);
        if (ps == null) {
            return null;
        }
        IntentFilterVerificationInfo ivi = ps.getIntentFilterVerificationInfo();
        if (ivi == null) {
            ivi = new IntentFilterVerificationInfo(packageName, domains);
            ps.setIntentFilterVerificationInfo(ivi);
        } else {
            ivi.setDomains(domains);
        }
        return ivi;
    }

    int getIntentFilterVerificationStatusLPr(String packageName, int userId) {
        PackageSetting ps = this.mPackages.get(packageName);
        if (ps == null) {
            return 0;
        }
        return (int)(ps.getDomainVerificationStatusForUser(userId) >> 32);
    }

    boolean updateIntentFilterVerificationStatusLPw(String packageName, int status, int userId) {
        int alwaysGeneration;
        PackageSetting current = this.mPackages.get(packageName);
        if (current == null) {
            return false;
        }
        if (status == 2) {
            alwaysGeneration = this.mNextAppLinkGeneration.get(userId) + 1;
            this.mNextAppLinkGeneration.put(userId, alwaysGeneration);
        } else {
            alwaysGeneration = 0;
        }
        current.setDomainVerificationStatusForUser(status, alwaysGeneration, userId);
        return true;
    }

    List<IntentFilterVerificationInfo> getIntentFilterVerificationsLPr(String packageName) {
        if (packageName == null) {
            return Collections.emptyList();
        }
        ArrayList<IntentFilterVerificationInfo> result = new ArrayList<IntentFilterVerificationInfo>();
        for (PackageSetting ps : this.mPackages.values()) {
            IntentFilterVerificationInfo ivi = ps.getIntentFilterVerificationInfo();
            if (ivi == null || TextUtils.isEmpty(ivi.getPackageName()) || !ivi.getPackageName().equalsIgnoreCase(packageName)) continue;
            result.add(ivi);
        }
        return result;
    }

    boolean removeIntentFilterVerificationLPw(String packageName, int userId) {
        PackageSetting ps = this.mPackages.get(packageName);
        if (ps == null) {
            return false;
        }
        ps.clearDomainVerificationStatusForUser(userId);
        return true;
    }

    boolean removeIntentFilterVerificationLPw(String packageName, int[] userIds) {
        boolean result = false;
        for (int userId : userIds) {
            result |= this.removeIntentFilterVerificationLPw(packageName, userId);
        }
        return result;
    }

    boolean setDefaultBrowserPackageNameLPw(String packageName, int userId) {
        if (userId == -1) {
            return false;
        }
        this.mDefaultBrowserApp.put(userId, packageName);
        this.writePackageRestrictionsLPr(userId);
        return true;
    }

    String getDefaultBrowserPackageNameLPw(int userId) {
        return userId == -1 ? null : this.mDefaultBrowserApp.get(userId);
    }

    boolean setDefaultDialerPackageNameLPw(String packageName, int userId) {
        if (userId == -1) {
            return false;
        }
        this.mDefaultDialerApp.put(userId, packageName);
        this.writePackageRestrictionsLPr(userId);
        return true;
    }

    String getDefaultDialerPackageNameLPw(int userId) {
        return userId == -1 ? null : this.mDefaultDialerApp.get(userId);
    }

    private File getUserPackagesStateFile(int userId) {
        File userDir = new File(new File(this.mSystemDir, "users"), Integer.toString(userId));
        return new File(userDir, "package-restrictions.xml");
    }

    private File getUserRuntimePermissionsFile(int userId) {
        File userDir = new File(new File(this.mSystemDir, "users"), Integer.toString(userId));
        return new File(userDir, RUNTIME_PERMISSIONS_FILE_NAME);
    }

    private File getUserPackagesStateBackupFile(int userId) {
        return new File(Environment.getUserSystemDirectory(userId), "package-restrictions-backup.xml");
    }

    void writeAllUsersPackageRestrictionsLPr() {
        List<UserInfo> users = this.getAllUsers();
        if (users == null) {
            return;
        }
        for (UserInfo user : users) {
            this.writePackageRestrictionsLPr(user.id);
        }
    }

    void writeAllRuntimePermissionsLPr() {
        for (int userId : UserManagerService.getInstance().getUserIds()) {
            this.mRuntimePermissionsPersistence.writePermissionsForUserAsyncLPr(userId);
        }
    }

    boolean areDefaultRuntimePermissionsGrantedLPr(int userId) {
        return this.mRuntimePermissionsPersistence.areDefaultRuntimPermissionsGrantedLPr(userId);
    }

    void onDefaultRuntimePermissionsGrantedLPr(int userId) {
        this.mRuntimePermissionsPersistence.onDefaultRuntimePermissionsGrantedLPr(userId);
    }

    public VersionInfo findOrCreateVersion(String volumeUuid) {
        VersionInfo ver = this.mVersion.get(volumeUuid);
        if (ver == null) {
            ver = new VersionInfo();
            ver.forceCurrent();
            this.mVersion.put(volumeUuid, ver);
        }
        return ver;
    }

    public VersionInfo getInternalVersion() {
        return this.mVersion.get(StorageManager.UUID_PRIVATE_INTERNAL);
    }

    public VersionInfo getExternalVersion() {
        return this.mVersion.get("primary_physical");
    }

    public void onVolumeForgotten(String fsUuid) {
        this.mVersion.remove(fsUuid);
    }

    void readPreferredActivitiesLPw(XmlPullParser parser, int userId) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals(TAG_ITEM)) {
                PreferredActivity pa = new PreferredActivity(parser);
                if (pa.mPref.getParseError() == null) {
                    this.editPreferredActivitiesLPw(userId).addFilter(pa);
                    continue;
                }
                PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <preferred-activity> " + pa.mPref.getParseError() + " at " + parser.getPositionDescription());
                continue;
            }
            PackageManagerService.reportSettingsProblem(5, "Unknown element under <preferred-activities>: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
    }

    private void readPersistentPreferredActivitiesLPw(XmlPullParser parser, int userId) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals(TAG_ITEM)) {
                PersistentPreferredActivity ppa = new PersistentPreferredActivity(parser);
                this.editPersistentPreferredActivitiesLPw(userId).addFilter(ppa);
                continue;
            }
            PackageManagerService.reportSettingsProblem(5, "Unknown element under <persistent-preferred-activities>: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
    }

    private void readCrossProfileIntentFiltersLPw(XmlPullParser parser, int userId) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals(TAG_ITEM)) {
                CrossProfileIntentFilter cpif = new CrossProfileIntentFilter(parser);
                this.editCrossProfileIntentResolverLPw(userId).addFilter(cpif);
                continue;
            }
            String msg = "Unknown element under crossProfile-intent-filters: " + tagName;
            PackageManagerService.reportSettingsProblem(5, msg);
            XmlUtils.skipCurrentTag(parser);
        }
    }

    private void readDomainVerificationLPw(XmlPullParser parser, PackageSettingBase packageSetting) throws XmlPullParserException, IOException {
        IntentFilterVerificationInfo ivi = new IntentFilterVerificationInfo(parser);
        packageSetting.setIntentFilterVerificationInfo(ivi);
        Log.d(TAG, "Read domain verification for package: " + ivi.getPackageName());
    }

    private void readRestoredIntentFilterVerifications(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals(TAG_DOMAIN_VERIFICATION)) {
                IntentFilterVerificationInfo ivi = new IntentFilterVerificationInfo(parser);
                this.mRestoredIntentFilterVerifications.put(ivi.getPackageName(), ivi);
                continue;
            }
            Slog.w(TAG, "Unknown element: " + tagName);
            XmlUtils.skipCurrentTag(parser);
        }
    }

    void readDefaultAppsLPw(XmlPullParser parser, int userId) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            String packageName;
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals(TAG_DEFAULT_BROWSER)) {
                packageName = parser.getAttributeValue(null, ATTR_PACKAGE_NAME);
                this.mDefaultBrowserApp.put(userId, packageName);
                continue;
            }
            if (tagName.equals(TAG_DEFAULT_DIALER)) {
                packageName = parser.getAttributeValue(null, ATTR_PACKAGE_NAME);
                this.mDefaultDialerApp.put(userId, packageName);
                continue;
            }
            String msg = "Unknown element under default-apps: " + parser.getName();
            PackageManagerService.reportSettingsProblem(5, msg);
            XmlUtils.skipCurrentTag(parser);
        }
    }

    void readPackageRestrictionsLPr(int userId) {
        FileInputStream str = null;
        File userPackagesStateFile = this.getUserPackagesStateFile(userId);
        File backupFile = this.getUserPackagesStateBackupFile(userId);
        if (backupFile.exists()) {
            try {
                str = new FileInputStream(backupFile);
                this.mReadMessages.append("Reading from backup stopped packages file\n");
                PackageManagerService.reportSettingsProblem(4, "Need to read from backup stopped packages file");
                if (userPackagesStateFile.exists()) {
                    Slog.w("PackageManager", "Cleaning up stopped packages file " + userPackagesStateFile);
                    userPackagesStateFile.delete();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            int type;
            if (str == null) {
                if (!userPackagesStateFile.exists()) {
                    this.mReadMessages.append("No stopped packages file found\n");
                    PackageManagerService.reportSettingsProblem(4, "No stopped packages file; assuming all started");
                    for (PackageSetting pkg : this.mPackages.values()) {
                        pkg.setUserState(userId, 0L, 0, true, false, false, false, false, null, null, null, false, 0, 0);
                    }
                    return;
                }
                str = new FileInputStream(userPackagesStateFile);
            }
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(str, StandardCharsets.UTF_8.name());
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                this.mReadMessages.append("No start tag found in package restrictions file\n");
                PackageManagerService.reportSettingsProblem(5, "No start tag found in package manager stopped packages");
                return;
            }
            int maxAppLinkGeneration = 0;
            int outerDepth = parser.getDepth();
            PackageSetting ps = null;
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                String tagName = parser.getName();
                if (tagName.equals(TAG_PACKAGE)) {
                    String name = parser.getAttributeValue(null, ATTR_NAME);
                    ps = this.mPackages.get(name);
                    if (ps == null) {
                        Slog.w("PackageManager", "No package known for stopped package " + name);
                        XmlUtils.skipCurrentTag(parser);
                        continue;
                    }
                    long ceDataInode = XmlUtils.readLongAttribute(parser, ATTR_CE_DATA_INODE, 0L);
                    boolean installed = XmlUtils.readBooleanAttribute(parser, ATTR_INSTALLED, true);
                    boolean stopped = XmlUtils.readBooleanAttribute(parser, ATTR_STOPPED, false);
                    boolean notLaunched = XmlUtils.readBooleanAttribute(parser, ATTR_NOT_LAUNCHED, false);
                    String blockedStr = parser.getAttributeValue(null, ATTR_BLOCKED);
                    boolean hidden = blockedStr == null ? false : Boolean.parseBoolean(blockedStr);
                    String hiddenStr = parser.getAttributeValue(null, ATTR_HIDDEN);
                    hidden = hiddenStr == null ? hidden : Boolean.parseBoolean(hiddenStr);
                    boolean suspended = XmlUtils.readBooleanAttribute(parser, ATTR_SUSPENDED, false);
                    boolean blockUninstall = XmlUtils.readBooleanAttribute(parser, ATTR_BLOCK_UNINSTALL, false);
                    int enabled = XmlUtils.readIntAttribute(parser, ATTR_ENABLED, 0);
                    String enabledCaller = parser.getAttributeValue(null, ATTR_ENABLED_CALLER);
                    int verifState = XmlUtils.readIntAttribute(parser, ATTR_DOMAIN_VERIFICATON_STATE, 0);
                    int linkGeneration = XmlUtils.readIntAttribute(parser, ATTR_APP_LINK_GENERATION, 0);
                    if (linkGeneration > maxAppLinkGeneration) {
                        maxAppLinkGeneration = linkGeneration;
                    }
                    ArraySet<String> enabledComponents = null;
                    ArraySet<String> disabledComponents = null;
                    int packageDepth = parser.getDepth();
                    while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > packageDepth)) {
                        if (type == 3 || type == 4) continue;
                        tagName = parser.getName();
                        if (tagName.equals(TAG_ENABLED_COMPONENTS)) {
                            enabledComponents = this.readComponentsLPr(parser);
                            continue;
                        }
                        if (!tagName.equals(TAG_DISABLED_COMPONENTS)) continue;
                        disabledComponents = this.readComponentsLPr(parser);
                    }
                    ps.setUserState(userId, ceDataInode, enabled, installed, stopped, notLaunched, hidden, suspended, enabledCaller, enabledComponents, disabledComponents, blockUninstall, verifState, linkGeneration);
                    continue;
                }
                if (tagName.equals("preferred-activities")) {
                    this.readPreferredActivitiesLPw(parser, userId);
                    continue;
                }
                if (tagName.equals(TAG_PERSISTENT_PREFERRED_ACTIVITIES)) {
                    this.readPersistentPreferredActivitiesLPw(parser, userId);
                    continue;
                }
                if (tagName.equals(TAG_CROSS_PROFILE_INTENT_FILTERS)) {
                    this.readCrossProfileIntentFiltersLPw(parser, userId);
                    continue;
                }
                if (tagName.equals(TAG_DEFAULT_APPS)) {
                    this.readDefaultAppsLPw(parser, userId);
                    continue;
                }
                Slog.w("PackageManager", "Unknown element under <stopped-packages>: " + parser.getName());
                XmlUtils.skipCurrentTag(parser);
            }
            str.close();
            this.mNextAppLinkGeneration.put(userId, maxAppLinkGeneration + 1);
        }
        catch (XmlPullParserException e) {
            this.mReadMessages.append("Error reading: " + e.toString());
            PackageManagerService.reportSettingsProblem(6, "Error reading stopped packages: " + e);
            Slog.wtf("PackageManager", "Error reading package manager stopped packages", e);
        }
        catch (IOException e) {
            this.mReadMessages.append("Error reading: " + e.toString());
            PackageManagerService.reportSettingsProblem(6, "Error reading settings: " + e);
            Slog.wtf("PackageManager", "Error reading package manager stopped packages", e);
        }
    }

    private ArraySet<String> readComponentsLPr(XmlPullParser parser) throws IOException, XmlPullParserException {
        int type;
        ArraySet<String> components = null;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            String componentName;
            String tagName;
            if (type == 3 || type == 4 || !(tagName = parser.getName()).equals(TAG_ITEM) || (componentName = parser.getAttributeValue(null, ATTR_NAME)) == null) continue;
            if (components == null) {
                components = new ArraySet<String>();
            }
            components.add(componentName);
        }
        return components;
    }

    void writePreferredActivitiesLPr(XmlSerializer serializer, int userId, boolean full) throws IllegalArgumentException, IllegalStateException, IOException {
        serializer.startTag(null, "preferred-activities");
        PreferredIntentResolver pir = this.mPreferredActivities.get(userId);
        if (pir != null) {
            for (PreferredActivity pa : pir.filterSet()) {
                serializer.startTag(null, TAG_ITEM);
                pa.writeToXml(serializer, full);
                serializer.endTag(null, TAG_ITEM);
            }
        }
        serializer.endTag(null, "preferred-activities");
    }

    void writePersistentPreferredActivitiesLPr(XmlSerializer serializer, int userId) throws IllegalArgumentException, IllegalStateException, IOException {
        serializer.startTag(null, TAG_PERSISTENT_PREFERRED_ACTIVITIES);
        PersistentPreferredIntentResolver ppir = this.mPersistentPreferredActivities.get(userId);
        if (ppir != null) {
            for (PersistentPreferredActivity ppa : ppir.filterSet()) {
                serializer.startTag(null, TAG_ITEM);
                ppa.writeToXml(serializer);
                serializer.endTag(null, TAG_ITEM);
            }
        }
        serializer.endTag(null, TAG_PERSISTENT_PREFERRED_ACTIVITIES);
    }

    void writeCrossProfileIntentFiltersLPr(XmlSerializer serializer, int userId) throws IllegalArgumentException, IllegalStateException, IOException {
        serializer.startTag(null, TAG_CROSS_PROFILE_INTENT_FILTERS);
        CrossProfileIntentResolver cpir = this.mCrossProfileIntentResolvers.get(userId);
        if (cpir != null) {
            for (CrossProfileIntentFilter cpif : cpir.filterSet()) {
                serializer.startTag(null, TAG_ITEM);
                cpif.writeToXml(serializer);
                serializer.endTag(null, TAG_ITEM);
            }
        }
        serializer.endTag(null, TAG_CROSS_PROFILE_INTENT_FILTERS);
    }

    void writeDomainVerificationsLPr(XmlSerializer serializer, IntentFilterVerificationInfo verificationInfo) throws IllegalArgumentException, IllegalStateException, IOException {
        if (verificationInfo != null && verificationInfo.getPackageName() != null) {
            serializer.startTag(null, TAG_DOMAIN_VERIFICATION);
            verificationInfo.writeToXml(serializer);
            serializer.endTag(null, TAG_DOMAIN_VERIFICATION);
        }
    }

    void writeAllDomainVerificationsLPr(XmlSerializer serializer, int userId) throws IllegalArgumentException, IllegalStateException, IOException {
        serializer.startTag(null, TAG_ALL_INTENT_FILTER_VERIFICATION);
        int N = this.mPackages.size();
        for (int i = 0; i < N; ++i) {
            PackageSetting ps = this.mPackages.valueAt(i);
            IntentFilterVerificationInfo ivi = ps.getIntentFilterVerificationInfo();
            if (ivi == null) continue;
            this.writeDomainVerificationsLPr(serializer, ivi);
        }
        serializer.endTag(null, TAG_ALL_INTENT_FILTER_VERIFICATION);
    }

    void readAllDomainVerificationsLPr(XmlPullParser parser, int userId) throws XmlPullParserException, IOException {
        int type;
        this.mRestoredIntentFilterVerifications.clear();
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals(TAG_DOMAIN_VERIFICATION)) {
                IntentFilterVerificationInfo ivi = new IntentFilterVerificationInfo(parser);
                String pkgName = ivi.getPackageName();
                PackageSetting ps = this.mPackages.get(pkgName);
                if (ps != null) {
                    ps.setIntentFilterVerificationInfo(ivi);
                    continue;
                }
                this.mRestoredIntentFilterVerifications.put(pkgName, ivi);
                continue;
            }
            PackageManagerService.reportSettingsProblem(5, "Unknown element under <all-intent-filter-verification>: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
    }

    public void processRestoredPermissionGrantLPr(String pkgName, String permission2, boolean isGranted, int restoredFlagSet, int userId) throws IOException, XmlPullParserException {
        this.mRuntimePermissionsPersistence.rememberRestoredUserGrantLPr(pkgName, permission2, isGranted, restoredFlagSet, userId);
    }

    void writeDefaultAppsLPr(XmlSerializer serializer, int userId) throws IllegalArgumentException, IllegalStateException, IOException {
        String defaultDialer;
        serializer.startTag(null, TAG_DEFAULT_APPS);
        String defaultBrowser = this.mDefaultBrowserApp.get(userId);
        if (!TextUtils.isEmpty(defaultBrowser)) {
            serializer.startTag(null, TAG_DEFAULT_BROWSER);
            serializer.attribute(null, ATTR_PACKAGE_NAME, defaultBrowser);
            serializer.endTag(null, TAG_DEFAULT_BROWSER);
        }
        if (!TextUtils.isEmpty(defaultDialer = this.mDefaultDialerApp.get(userId))) {
            serializer.startTag(null, TAG_DEFAULT_DIALER);
            serializer.attribute(null, ATTR_PACKAGE_NAME, defaultDialer);
            serializer.endTag(null, TAG_DEFAULT_DIALER);
        }
        serializer.endTag(null, TAG_DEFAULT_APPS);
    }

    void writePackageRestrictionsLPr(int userId) {
        File userPackagesStateFile = this.getUserPackagesStateFile(userId);
        File backupFile = this.getUserPackagesStateBackupFile(userId);
        new File(userPackagesStateFile.getParent()).mkdirs();
        if (userPackagesStateFile.exists()) {
            if (!backupFile.exists()) {
                if (!userPackagesStateFile.renameTo(backupFile)) {
                    Slog.wtf("PackageManager", "Unable to backup user packages state file, current changes will be lost at reboot");
                    return;
                }
            } else {
                userPackagesStateFile.delete();
                Slog.w("PackageManager", "Preserving older stopped packages backup");
            }
        }
        try {
            FileOutputStream fstr = new FileOutputStream(userPackagesStateFile);
            BufferedOutputStream str = new BufferedOutputStream(fstr);
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput(str, StandardCharsets.UTF_8.name());
            serializer.startDocument(null, true);
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            serializer.startTag(null, TAG_PACKAGE_RESTRICTIONS);
            for (PackageSetting pkg : this.mPackages.values()) {
                PackageUserState ustate = pkg.readUserState(userId);
                serializer.startTag(null, TAG_PACKAGE);
                serializer.attribute(null, ATTR_NAME, pkg.name);
                if (ustate.ceDataInode != 0L) {
                    XmlUtils.writeLongAttribute(serializer, ATTR_CE_DATA_INODE, ustate.ceDataInode);
                }
                if (!ustate.installed) {
                    serializer.attribute(null, ATTR_INSTALLED, "false");
                }
                if (ustate.stopped) {
                    serializer.attribute(null, ATTR_STOPPED, "true");
                }
                if (ustate.notLaunched) {
                    serializer.attribute(null, ATTR_NOT_LAUNCHED, "true");
                }
                if (ustate.hidden) {
                    serializer.attribute(null, ATTR_HIDDEN, "true");
                }
                if (ustate.suspended) {
                    serializer.attribute(null, ATTR_SUSPENDED, "true");
                }
                if (ustate.blockUninstall) {
                    serializer.attribute(null, ATTR_BLOCK_UNINSTALL, "true");
                }
                if (ustate.enabled != 0) {
                    serializer.attribute(null, ATTR_ENABLED, Integer.toString(ustate.enabled));
                    if (ustate.lastDisableAppCaller != null) {
                        serializer.attribute(null, ATTR_ENABLED_CALLER, ustate.lastDisableAppCaller);
                    }
                }
                if (ustate.domainVerificationStatus != 0) {
                    XmlUtils.writeIntAttribute(serializer, ATTR_DOMAIN_VERIFICATON_STATE, ustate.domainVerificationStatus);
                }
                if (ustate.appLinkGeneration != 0) {
                    XmlUtils.writeIntAttribute(serializer, ATTR_APP_LINK_GENERATION, ustate.appLinkGeneration);
                }
                if (!ArrayUtils.isEmpty(ustate.enabledComponents)) {
                    serializer.startTag(null, TAG_ENABLED_COMPONENTS);
                    for (String name : ustate.enabledComponents) {
                        serializer.startTag(null, TAG_ITEM);
                        serializer.attribute(null, ATTR_NAME, name);
                        serializer.endTag(null, TAG_ITEM);
                    }
                    serializer.endTag(null, TAG_ENABLED_COMPONENTS);
                }
                if (!ArrayUtils.isEmpty(ustate.disabledComponents)) {
                    serializer.startTag(null, TAG_DISABLED_COMPONENTS);
                    for (String name : ustate.disabledComponents) {
                        serializer.startTag(null, TAG_ITEM);
                        serializer.attribute(null, ATTR_NAME, name);
                        serializer.endTag(null, TAG_ITEM);
                    }
                    serializer.endTag(null, TAG_DISABLED_COMPONENTS);
                }
                serializer.endTag(null, TAG_PACKAGE);
            }
            this.writePreferredActivitiesLPr(serializer, userId, true);
            this.writePersistentPreferredActivitiesLPr(serializer, userId);
            this.writeCrossProfileIntentFiltersLPr(serializer, userId);
            this.writeDefaultAppsLPr(serializer, userId);
            serializer.endTag(null, TAG_PACKAGE_RESTRICTIONS);
            serializer.endDocument();
            str.flush();
            FileUtils.sync(fstr);
            str.close();
            backupFile.delete();
            FileUtils.setPermissions(userPackagesStateFile.toString(), 432, -1, -1);
            return;
        }
        catch (IOException e) {
            Slog.wtf("PackageManager", "Unable to write package manager user packages state,  current changes will be lost at reboot", e);
            if (userPackagesStateFile.exists() && !userPackagesStateFile.delete()) {
                Log.i("PackageManager", "Failed to clean up mangled file: " + this.mStoppedPackagesFilename);
            }
            return;
        }
    }

    void readInstallPermissionsLPr(XmlPullParser parser, PermissionsState permissionsState) throws IOException, XmlPullParserException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals(TAG_ITEM)) {
                int flags;
                String name = parser.getAttributeValue(null, ATTR_NAME);
                BasePermission bp = this.mPermissions.get(name);
                if (bp == null) {
                    Slog.w("PackageManager", "Unknown permission: " + name);
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                String grantedStr = parser.getAttributeValue(null, ATTR_GRANTED);
                boolean granted = grantedStr == null || Boolean.parseBoolean(grantedStr);
                String flagsStr = parser.getAttributeValue(null, ATTR_FLAGS);
                int n = flags = flagsStr != null ? Integer.parseInt(flagsStr, 16) : 0;
                if (granted) {
                    if (permissionsState.grantInstallPermission(bp) == -1) {
                        Slog.w("PackageManager", "Permission already added: " + name);
                        XmlUtils.skipCurrentTag(parser);
                        continue;
                    }
                    permissionsState.updatePermissionFlags(bp, -1, 255, flags);
                    continue;
                }
                if (permissionsState.revokeInstallPermission(bp) == -1) {
                    Slog.w("PackageManager", "Permission already added: " + name);
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                permissionsState.updatePermissionFlags(bp, -1, 255, flags);
                continue;
            }
            Slog.w("PackageManager", "Unknown element under <permissions>: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
    }

    void writePermissionsLPr(XmlSerializer serializer, List<PermissionsState.PermissionState> permissionStates) throws IOException {
        if (permissionStates.isEmpty()) {
            return;
        }
        serializer.startTag(null, TAG_PERMISSIONS);
        for (PermissionsState.PermissionState permissionState : permissionStates) {
            serializer.startTag(null, TAG_ITEM);
            serializer.attribute(null, ATTR_NAME, permissionState.getName());
            serializer.attribute(null, ATTR_GRANTED, String.valueOf(permissionState.isGranted()));
            serializer.attribute(null, ATTR_FLAGS, Integer.toHexString(permissionState.getFlags()));
            serializer.endTag(null, TAG_ITEM);
        }
        serializer.endTag(null, TAG_PERMISSIONS);
    }

    void writeChildPackagesLPw(XmlSerializer serializer, List<String> childPackageNames) throws IOException {
        if (childPackageNames == null) {
            return;
        }
        int childCount = childPackageNames.size();
        for (int i = 0; i < childCount; ++i) {
            String childPackageName = childPackageNames.get(i);
            serializer.startTag(null, TAG_CHILD_PACKAGE);
            serializer.attribute(null, ATTR_NAME, childPackageName);
            serializer.endTag(null, TAG_CHILD_PACKAGE);
        }
    }

    void readStoppedLPw() {
        FileInputStream str = null;
        if (this.mBackupStoppedPackagesFilename.exists()) {
            try {
                str = new FileInputStream(this.mBackupStoppedPackagesFilename);
                this.mReadMessages.append("Reading from backup stopped packages file\n");
                PackageManagerService.reportSettingsProblem(4, "Need to read from backup stopped packages file");
                if (this.mSettingsFilename.exists()) {
                    Slog.w("PackageManager", "Cleaning up stopped packages file " + this.mStoppedPackagesFilename);
                    this.mStoppedPackagesFilename.delete();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            int type;
            if (str == null) {
                if (!this.mStoppedPackagesFilename.exists()) {
                    this.mReadMessages.append("No stopped packages file found\n");
                    PackageManagerService.reportSettingsProblem(4, "No stopped packages file file; assuming all started");
                    for (PackageSetting pkg : this.mPackages.values()) {
                        pkg.setStopped(false, 0);
                        pkg.setNotLaunched(false, 0);
                    }
                    return;
                }
                str = new FileInputStream(this.mStoppedPackagesFilename);
            }
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(str, null);
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                this.mReadMessages.append("No start tag found in stopped packages file\n");
                PackageManagerService.reportSettingsProblem(5, "No start tag found in package manager stopped packages");
                return;
            }
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                String tagName = parser.getName();
                if (tagName.equals(TAG_PACKAGE)) {
                    String name = parser.getAttributeValue(null, ATTR_NAME);
                    PackageSetting ps = this.mPackages.get(name);
                    if (ps != null) {
                        ps.setStopped(true, 0);
                        if ("1".equals(parser.getAttributeValue(null, ATTR_NOT_LAUNCHED))) {
                            ps.setNotLaunched(true, 0);
                        }
                    } else {
                        Slog.w("PackageManager", "No package known for stopped package " + name);
                    }
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                Slog.w("PackageManager", "Unknown element under <stopped-packages>: " + parser.getName());
                XmlUtils.skipCurrentTag(parser);
            }
            str.close();
        }
        catch (XmlPullParserException e) {
            this.mReadMessages.append("Error reading: " + e.toString());
            PackageManagerService.reportSettingsProblem(6, "Error reading stopped packages: " + e);
            Slog.wtf("PackageManager", "Error reading package manager stopped packages", e);
        }
        catch (IOException e) {
            this.mReadMessages.append("Error reading: " + e.toString());
            PackageManagerService.reportSettingsProblem(6, "Error reading settings: " + e);
            Slog.wtf("PackageManager", "Error reading package manager stopped packages", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    void writeLPr() {
        if (this.mSettingsFilename.exists()) {
            if (!this.mBackupSettingsFilename.exists()) {
                if (!this.mSettingsFilename.renameTo(this.mBackupSettingsFilename)) {
                    Slog.wtf("PackageManager", "Unable to backup package manager settings,  current changes will be lost at reboot");
                    return;
                }
            } else {
                this.mSettingsFilename.delete();
                Slog.w("PackageManager", "Preserving older settings backup");
            }
        }
        this.mPastSignatures.clear();
        try {
            int numIVIs;
            FileOutputStream fstr = new FileOutputStream(this.mSettingsFilename);
            BufferedOutputStream str = new BufferedOutputStream(fstr);
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput(str, StandardCharsets.UTF_8.name());
            serializer.startDocument(null, true);
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            serializer.startTag(null, "packages");
            for (int i = 0; i < this.mVersion.size(); ++i) {
                String string2 = this.mVersion.keyAt(i);
                VersionInfo ver = this.mVersion.valueAt(i);
                serializer.startTag(null, TAG_VERSION);
                XmlUtils.writeStringAttribute(serializer, ATTR_VOLUME_UUID, string2);
                XmlUtils.writeIntAttribute(serializer, ATTR_SDK_VERSION, ver.sdkVersion);
                XmlUtils.writeIntAttribute(serializer, ATTR_DATABASE_VERSION, ver.databaseVersion);
                XmlUtils.writeStringAttribute(serializer, ATTR_FINGERPRINT, ver.fingerprint);
                serializer.endTag(null, TAG_VERSION);
            }
            if (this.mVerifierDeviceIdentity != null) {
                serializer.startTag(null, "verifier");
                serializer.attribute(null, "device", this.mVerifierDeviceIdentity.toString());
                serializer.endTag(null, "verifier");
            }
            if (this.mReadExternalStorageEnforced != null) {
                serializer.startTag(null, TAG_READ_EXTERNAL_STORAGE);
                serializer.attribute(null, ATTR_ENFORCEMENT, this.mReadExternalStorageEnforced != false ? "1" : "0");
                serializer.endTag(null, TAG_READ_EXTERNAL_STORAGE);
            }
            serializer.startTag(null, "permission-trees");
            for (BasePermission basePermission : this.mPermissionTrees.values()) {
                this.writePermissionLPr(serializer, basePermission);
            }
            serializer.endTag(null, "permission-trees");
            serializer.startTag(null, "permissions");
            for (BasePermission basePermission : this.mPermissions.values()) {
                this.writePermissionLPr(serializer, basePermission);
            }
            serializer.endTag(null, "permissions");
            for (PackageSetting packageSetting : this.mPackages.values()) {
                this.writePackageLPr(serializer, packageSetting);
            }
            for (PackageSetting packageSetting : this.mDisabledSysPackages.values()) {
                this.writeDisabledSysPackageLPr(serializer, packageSetting);
            }
            for (SharedUserSetting sharedUserSetting : this.mSharedUsers.values()) {
                serializer.startTag(null, TAG_SHARED_USER);
                serializer.attribute(null, ATTR_NAME, sharedUserSetting.name);
                serializer.attribute(null, "userId", Integer.toString(sharedUserSetting.userId));
                sharedUserSetting.signatures.writeXml(serializer, "sigs", this.mPastSignatures);
                this.writePermissionsLPr(serializer, sharedUserSetting.getPermissionsState().getInstallPermissionStates());
                serializer.endTag(null, TAG_SHARED_USER);
            }
            if (this.mPackagesToBeCleaned.size() > 0) {
                for (PackageCleanItem packageCleanItem : this.mPackagesToBeCleaned) {
                    String userStr = Integer.toString(packageCleanItem.userId);
                    serializer.startTag(null, "cleaning-package");
                    serializer.attribute(null, ATTR_NAME, packageCleanItem.packageName);
                    serializer.attribute(null, ATTR_CODE, packageCleanItem.andCode ? "true" : "false");
                    serializer.attribute(null, ATTR_USER, userStr);
                    serializer.endTag(null, "cleaning-package");
                }
            }
            if (this.mRenamedPackages.size() > 0) {
                for (Map.Entry entry : this.mRenamedPackages.entrySet()) {
                    serializer.startTag(null, "renamed-package");
                    serializer.attribute(null, "new", (String)entry.getKey());
                    serializer.attribute(null, "old", (String)entry.getValue());
                    serializer.endTag(null, "renamed-package");
                }
            }
            if ((numIVIs = this.mRestoredIntentFilterVerifications.size()) > 0) {
                void var5_25;
                serializer.startTag(null, "restored-ivi");
                boolean bl = false;
                while (var5_25 < numIVIs) {
                    IntentFilterVerificationInfo ivi = this.mRestoredIntentFilterVerifications.valueAt((int)var5_25);
                    this.writeDomainVerificationsLPr(serializer, ivi);
                    ++var5_25;
                }
                serializer.endTag(null, "restored-ivi");
            }
            this.mKeySetManagerService.writeKeySetManagerServiceLPr(serializer);
            serializer.endTag(null, "packages");
            serializer.endDocument();
            str.flush();
            FileUtils.sync(fstr);
            str.close();
            this.mBackupSettingsFilename.delete();
            FileUtils.setPermissions(this.mSettingsFilename.toString(), 432, -1, -1);
            this.writeKernelMappingLPr();
            this.writePackageListLPr();
            this.writeAllUsersPackageRestrictionsLPr();
            this.writeAllRuntimePermissionsLPr();
            return;
        }
        catch (XmlPullParserException e) {
            Slog.wtf("PackageManager", "Unable to write package manager settings, current changes will be lost at reboot", e);
        }
        catch (IOException e) {
            Slog.wtf("PackageManager", "Unable to write package manager settings, current changes will be lost at reboot", e);
        }
        if (this.mSettingsFilename.exists() && !this.mSettingsFilename.delete()) {
            Slog.wtf("PackageManager", "Failed to clean up mangled file: " + this.mSettingsFilename);
        }
    }

    void writeKernelMappingLPr() {
        if (this.mKernelMappingFilename == null) {
            return;
        }
        String[] known = this.mKernelMappingFilename.list();
        ArraySet<String> knownSet = new ArraySet<String>(known.length);
        for (String name : known) {
            knownSet.add(name);
        }
        for (PackageSetting ps : this.mPackages.values()) {
            knownSet.remove(ps.name);
            this.writeKernelMappingLPr(ps);
        }
        for (int i = 0; i < knownSet.size(); ++i) {
            String name = (String)knownSet.valueAt(i);
            this.mKernelMapping.remove(name);
            new File(this.mKernelMappingFilename, name).delete();
        }
    }

    void writeKernelMappingLPr(PackageSetting ps) {
        if (this.mKernelMappingFilename == null) {
            return;
        }
        Integer cur = this.mKernelMapping.get(ps.name);
        if (cur != null && cur == ps.appId) {
            return;
        }
        File dir = new File(this.mKernelMappingFilename, ps.name);
        dir.mkdir();
        File file = new File(dir, "appid");
        try {
            FileUtils.stringToFile(file, Integer.toString(ps.appId));
            this.mKernelMapping.put(ps.name, ps.appId);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void writePackageListLPr() {
        this.writePackageListLPr(-1);
    }

    void writePackageListLPr(int creatingUserId) {
        List<UserInfo> users = UserManagerService.getInstance().getUsers(true);
        int[] userIds = new int[users.size()];
        for (int i = 0; i < userIds.length; ++i) {
            userIds[i] = users.get((int)i).id;
        }
        if (creatingUserId != -1) {
            userIds = ArrayUtils.appendInt(userIds, creatingUserId);
        }
        File tempFile = new File(this.mPackageListFilename.getAbsolutePath() + ".tmp");
        JournaledFile journal = new JournaledFile(this.mPackageListFilename, tempFile);
        File writeTarget = journal.chooseForWrite();
        BufferedWriter writer = null;
        try {
            FileOutputStream fstr = new FileOutputStream(writeTarget);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fstr, Charset.defaultCharset()));
            FileUtils.setPermissions(fstr.getFD(), 416, 1000, 1032);
            StringBuilder sb = new StringBuilder();
            for (PackageSetting pkg : this.mPackages.values()) {
                if (pkg.pkg == null || pkg.pkg.applicationInfo == null || pkg.pkg.applicationInfo.dataDir == null) {
                    if ("android".equals(pkg.name)) continue;
                    Slog.w(TAG, "Skipping " + pkg + " due to missing metadata");
                    continue;
                }
                ApplicationInfo ai = pkg.pkg.applicationInfo;
                String dataPath = ai.dataDir;
                boolean isDebug = (ai.flags & 2) != 0;
                int[] gids = pkg.getPermissionsState().computeGids(userIds);
                if (dataPath.indexOf(32) >= 0) continue;
                sb.setLength(0);
                sb.append(ai.packageName);
                sb.append(" ");
                sb.append(ai.uid);
                sb.append(isDebug ? " 1 " : " 0 ");
                sb.append(dataPath);
                sb.append(" ");
                sb.append(ai.seinfo);
                sb.append(" ");
                if (gids != null && gids.length > 0) {
                    sb.append(gids[0]);
                    for (int i = 1; i < gids.length; ++i) {
                        sb.append(",");
                        sb.append(gids[i]);
                    }
                } else {
                    sb.append("none");
                }
                sb.append("\n");
                writer.append(sb);
            }
            writer.flush();
            FileUtils.sync(fstr);
            writer.close();
            journal.commit();
        }
        catch (Exception e) {
            Slog.wtf(TAG, "Failed to write packages.list", e);
            IoUtils.closeQuietly(writer);
            journal.rollback();
        }
    }

    void writeDisabledSysPackageLPr(XmlSerializer serializer, PackageSetting pkg) throws IOException {
        serializer.startTag(null, "updated-package");
        serializer.attribute(null, ATTR_NAME, pkg.name);
        if (pkg.realName != null) {
            serializer.attribute(null, "realName", pkg.realName);
        }
        serializer.attribute(null, "codePath", pkg.codePathString);
        serializer.attribute(null, "ft", Long.toHexString(pkg.timeStamp));
        serializer.attribute(null, "it", Long.toHexString(pkg.firstInstallTime));
        serializer.attribute(null, "ut", Long.toHexString(pkg.lastUpdateTime));
        serializer.attribute(null, TAG_VERSION, String.valueOf(pkg.versionCode));
        if (!pkg.resourcePathString.equals(pkg.codePathString)) {
            serializer.attribute(null, "resourcePath", pkg.resourcePathString);
        }
        if (pkg.legacyNativeLibraryPathString != null) {
            serializer.attribute(null, "nativeLibraryPath", pkg.legacyNativeLibraryPathString);
        }
        if (pkg.primaryCpuAbiString != null) {
            serializer.attribute(null, "primaryCpuAbi", pkg.primaryCpuAbiString);
        }
        if (pkg.secondaryCpuAbiString != null) {
            serializer.attribute(null, "secondaryCpuAbi", pkg.secondaryCpuAbiString);
        }
        if (pkg.cpuAbiOverrideString != null) {
            serializer.attribute(null, "cpuAbiOverride", pkg.cpuAbiOverrideString);
        }
        if (pkg.sharedUser == null) {
            serializer.attribute(null, "userId", Integer.toString(pkg.appId));
        } else {
            serializer.attribute(null, "sharedUserId", Integer.toString(pkg.appId));
        }
        if (pkg.parentPackageName != null) {
            serializer.attribute(null, "parentPackageName", pkg.parentPackageName);
        }
        this.writeChildPackagesLPw(serializer, pkg.childPackageNames);
        if (pkg.sharedUser == null) {
            this.writePermissionsLPr(serializer, pkg.getPermissionsState().getInstallPermissionStates());
        }
        serializer.endTag(null, "updated-package");
    }

    void writePackageLPr(XmlSerializer serializer, PackageSetting pkg) throws IOException {
        serializer.startTag(null, "package");
        serializer.attribute(null, ATTR_NAME, pkg.name);
        if (pkg.realName != null) {
            serializer.attribute(null, "realName", pkg.realName);
        }
        serializer.attribute(null, "codePath", pkg.codePathString);
        if (!pkg.resourcePathString.equals(pkg.codePathString)) {
            serializer.attribute(null, "resourcePath", pkg.resourcePathString);
        }
        if (pkg.legacyNativeLibraryPathString != null) {
            serializer.attribute(null, "nativeLibraryPath", pkg.legacyNativeLibraryPathString);
        }
        if (pkg.primaryCpuAbiString != null) {
            serializer.attribute(null, "primaryCpuAbi", pkg.primaryCpuAbiString);
        }
        if (pkg.secondaryCpuAbiString != null) {
            serializer.attribute(null, "secondaryCpuAbi", pkg.secondaryCpuAbiString);
        }
        if (pkg.cpuAbiOverrideString != null) {
            serializer.attribute(null, "cpuAbiOverride", pkg.cpuAbiOverrideString);
        }
        serializer.attribute(null, "publicFlags", Integer.toString(pkg.pkgFlags));
        serializer.attribute(null, "privateFlags", Integer.toString(pkg.pkgPrivateFlags));
        serializer.attribute(null, "ft", Long.toHexString(pkg.timeStamp));
        serializer.attribute(null, "it", Long.toHexString(pkg.firstInstallTime));
        serializer.attribute(null, "ut", Long.toHexString(pkg.lastUpdateTime));
        serializer.attribute(null, TAG_VERSION, String.valueOf(pkg.versionCode));
        if (pkg.sharedUser == null) {
            serializer.attribute(null, "userId", Integer.toString(pkg.appId));
        } else {
            serializer.attribute(null, "sharedUserId", Integer.toString(pkg.appId));
        }
        if (pkg.uidError) {
            serializer.attribute(null, "uidError", "true");
        }
        if (pkg.installStatus == 0) {
            serializer.attribute(null, "installStatus", "false");
        }
        if (pkg.installerPackageName != null) {
            serializer.attribute(null, "installer", pkg.installerPackageName);
        }
        if (pkg.isOrphaned) {
            serializer.attribute(null, "isOrphaned", "true");
        }
        if (pkg.volumeUuid != null) {
            serializer.attribute(null, ATTR_VOLUME_UUID, pkg.volumeUuid);
        }
        if (pkg.parentPackageName != null) {
            serializer.attribute(null, "parentPackageName", pkg.parentPackageName);
        }
        this.writeChildPackagesLPw(serializer, pkg.childPackageNames);
        pkg.signatures.writeXml(serializer, "sigs", this.mPastSignatures);
        this.writePermissionsLPr(serializer, pkg.getPermissionsState().getInstallPermissionStates());
        this.writeSigningKeySetLPr(serializer, pkg.keySetData);
        this.writeUpgradeKeySetsLPr(serializer, pkg.keySetData);
        this.writeKeySetAliasesLPr(serializer, pkg.keySetData);
        this.writeDomainVerificationsLPr(serializer, pkg.verificationInfo);
        serializer.endTag(null, "package");
    }

    void writeSigningKeySetLPr(XmlSerializer serializer, PackageKeySetData data) throws IOException {
        serializer.startTag(null, "proper-signing-keyset");
        serializer.attribute(null, "identifier", Long.toString(data.getProperSigningKeySet()));
        serializer.endTag(null, "proper-signing-keyset");
    }

    void writeUpgradeKeySetsLPr(XmlSerializer serializer, PackageKeySetData data) throws IOException {
        long properSigning = data.getProperSigningKeySet();
        if (data.isUsingUpgradeKeySets()) {
            for (long id2 : data.getUpgradeKeySets()) {
                serializer.startTag(null, "upgrade-keyset");
                serializer.attribute(null, "identifier", Long.toString(id2));
                serializer.endTag(null, "upgrade-keyset");
            }
        }
    }

    void writeKeySetAliasesLPr(XmlSerializer serializer, PackageKeySetData data) throws IOException {
        for (Map.Entry<String, Long> e : data.getAliases().entrySet()) {
            serializer.startTag(null, "defined-keyset");
            serializer.attribute(null, "alias", e.getKey());
            serializer.attribute(null, "identifier", Long.toString(e.getValue()));
            serializer.endTag(null, "defined-keyset");
        }
    }

    void writePermissionLPr(XmlSerializer serializer, BasePermission bp) throws XmlPullParserException, IOException {
        if (bp.sourcePackage != null) {
            serializer.startTag(null, TAG_ITEM);
            serializer.attribute(null, ATTR_NAME, bp.name);
            serializer.attribute(null, "package", bp.sourcePackage);
            if (bp.protectionLevel != 0) {
                serializer.attribute(null, "protection", Integer.toString(bp.protectionLevel));
            }
            if (bp.type == 2) {
                PermissionInfo pi;
                PermissionInfo permissionInfo = pi = bp.perm != null ? bp.perm.info : bp.pendingInfo;
                if (pi != null) {
                    serializer.attribute(null, "type", "dynamic");
                    if (pi.icon != 0) {
                        serializer.attribute(null, "icon", Integer.toString(pi.icon));
                    }
                    if (pi.nonLocalizedLabel != null) {
                        serializer.attribute(null, "label", pi.nonLocalizedLabel.toString());
                    }
                }
            }
            serializer.endTag(null, TAG_ITEM);
        }
    }

    ArrayList<PackageSetting> getListOfIncompleteInstallPackagesLPr() {
        ArraySet<String> kList = new ArraySet<String>(this.mPackages.keySet());
        Iterator<String> its = kList.iterator();
        ArrayList<PackageSetting> ret = new ArrayList<PackageSetting>();
        while (its.hasNext()) {
            String key = its.next();
            PackageSetting ps = this.mPackages.get(key);
            if (ps.getInstallStatus() != 0) continue;
            ret.add(ps);
        }
        return ret;
    }

    void addPackageToCleanLPw(PackageCleanItem pkg) {
        if (!this.mPackagesToBeCleaned.contains(pkg)) {
            this.mPackagesToBeCleaned.add(pkg);
        }
    }

    boolean readLPw(List<UserInfo> users) {
        FileInputStream str = null;
        if (this.mBackupSettingsFilename.exists()) {
            try {
                str = new FileInputStream(this.mBackupSettingsFilename);
                this.mReadMessages.append("Reading from backup settings file\n");
                PackageManagerService.reportSettingsProblem(4, "Need to read from backup settings file");
                if (this.mSettingsFilename.exists()) {
                    Slog.w("PackageManager", "Cleaning up settings file " + this.mSettingsFilename);
                    this.mSettingsFilename.delete();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.mPendingPackages.clear();
        this.mPastSignatures.clear();
        this.mKeySetRefs.clear();
        this.mInstallerPackages.clear();
        try {
            int type;
            if (str == null) {
                if (!this.mSettingsFilename.exists()) {
                    this.mReadMessages.append("No settings file found\n");
                    PackageManagerService.reportSettingsProblem(4, "No settings file; creating initial state");
                    this.findOrCreateVersion(StorageManager.UUID_PRIVATE_INTERNAL);
                    this.findOrCreateVersion("primary_physical");
                    return false;
                }
                str = new FileInputStream(this.mSettingsFilename);
            }
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(str, StandardCharsets.UTF_8.name());
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                this.mReadMessages.append("No start tag found in settings file\n");
                PackageManagerService.reportSettingsProblem(5, "No start tag found in package manager settings");
                Slog.wtf("PackageManager", "No start tag found in package manager settings");
                return false;
            }
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                VersionInfo external;
                VersionInfo internal;
                if (type == 3 || type == 4) continue;
                String tagName = parser.getName();
                if (tagName.equals("package")) {
                    this.readPackageLPw(parser);
                    continue;
                }
                if (tagName.equals("permissions")) {
                    this.readPermissionsLPw(this.mPermissions, parser);
                    continue;
                }
                if (tagName.equals("permission-trees")) {
                    this.readPermissionsLPw(this.mPermissionTrees, parser);
                    continue;
                }
                if (tagName.equals(TAG_SHARED_USER)) {
                    this.readSharedUserLPw(parser);
                    continue;
                }
                if (tagName.equals("preferred-packages")) continue;
                if (tagName.equals("preferred-activities")) {
                    this.readPreferredActivitiesLPw(parser, 0);
                    continue;
                }
                if (tagName.equals(TAG_PERSISTENT_PREFERRED_ACTIVITIES)) {
                    this.readPersistentPreferredActivitiesLPw(parser, 0);
                    continue;
                }
                if (tagName.equals(TAG_CROSS_PROFILE_INTENT_FILTERS)) {
                    this.readCrossProfileIntentFiltersLPw(parser, 0);
                    continue;
                }
                if (tagName.equals(TAG_DEFAULT_BROWSER)) {
                    this.readDefaultAppsLPw(parser, 0);
                    continue;
                }
                if (tagName.equals("updated-package")) {
                    this.readDisabledSysPackageLPw(parser);
                    continue;
                }
                if (tagName.equals("cleaning-package")) {
                    String name = parser.getAttributeValue(null, ATTR_NAME);
                    String userStr = parser.getAttributeValue(null, ATTR_USER);
                    String codeStr = parser.getAttributeValue(null, ATTR_CODE);
                    if (name == null) continue;
                    int userId = 0;
                    boolean andCode = true;
                    try {
                        if (userStr != null) {
                            userId = Integer.parseInt(userStr);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (codeStr != null) {
                        andCode = Boolean.parseBoolean(codeStr);
                    }
                    this.addPackageToCleanLPw(new PackageCleanItem(userId, name, andCode));
                    continue;
                }
                if (tagName.equals("renamed-package")) {
                    String nname = parser.getAttributeValue(null, "new");
                    String oname = parser.getAttributeValue(null, "old");
                    if (nname == null || oname == null) continue;
                    this.mRenamedPackages.put(nname, oname);
                    continue;
                }
                if (tagName.equals("restored-ivi")) {
                    this.readRestoredIntentFilterVerifications(parser);
                    continue;
                }
                if (tagName.equals("last-platform-version")) {
                    internal = this.findOrCreateVersion(StorageManager.UUID_PRIVATE_INTERNAL);
                    external = this.findOrCreateVersion("primary_physical");
                    internal.sdkVersion = XmlUtils.readIntAttribute(parser, "internal", 0);
                    external.sdkVersion = XmlUtils.readIntAttribute(parser, "external", 0);
                    internal.fingerprint = external.fingerprint = XmlUtils.readStringAttribute(parser, ATTR_FINGERPRINT);
                    continue;
                }
                if (tagName.equals("database-version")) {
                    internal = this.findOrCreateVersion(StorageManager.UUID_PRIVATE_INTERNAL);
                    external = this.findOrCreateVersion("primary_physical");
                    internal.databaseVersion = XmlUtils.readIntAttribute(parser, "internal", 0);
                    external.databaseVersion = XmlUtils.readIntAttribute(parser, "external", 0);
                    continue;
                }
                if (tagName.equals("verifier")) {
                    String deviceIdentity = parser.getAttributeValue(null, "device");
                    try {
                        this.mVerifierDeviceIdentity = VerifierDeviceIdentity.parse(deviceIdentity);
                    }
                    catch (IllegalArgumentException e) {
                        Slog.w("PackageManager", "Discard invalid verifier device id: " + e.getMessage());
                    }
                    continue;
                }
                if (TAG_READ_EXTERNAL_STORAGE.equals(tagName)) {
                    String enforcement = parser.getAttributeValue(null, ATTR_ENFORCEMENT);
                    this.mReadExternalStorageEnforced = "1".equals(enforcement);
                    continue;
                }
                if (tagName.equals("keyset-settings")) {
                    this.mKeySetManagerService.readKeySetsLPw(parser, this.mKeySetRefs);
                    continue;
                }
                if (TAG_VERSION.equals(tagName)) {
                    String volumeUuid = XmlUtils.readStringAttribute(parser, ATTR_VOLUME_UUID);
                    VersionInfo ver = this.findOrCreateVersion(volumeUuid);
                    ver.sdkVersion = XmlUtils.readIntAttribute(parser, ATTR_SDK_VERSION);
                    ver.databaseVersion = XmlUtils.readIntAttribute(parser, ATTR_SDK_VERSION);
                    ver.fingerprint = XmlUtils.readStringAttribute(parser, ATTR_FINGERPRINT);
                    continue;
                }
                Slog.w("PackageManager", "Unknown element under <packages>: " + parser.getName());
                XmlUtils.skipCurrentTag(parser);
            }
            str.close();
        }
        catch (XmlPullParserException e) {
            this.mReadMessages.append("Error reading: " + e.toString());
            PackageManagerService.reportSettingsProblem(6, "Error reading settings: " + e);
            Slog.wtf("PackageManager", "Error reading package manager settings", e);
        }
        catch (IOException e) {
            this.mReadMessages.append("Error reading: " + e.toString());
            PackageManagerService.reportSettingsProblem(6, "Error reading settings: " + e);
            Slog.wtf("PackageManager", "Error reading package manager settings", e);
        }
        int N = this.mPendingPackages.size();
        for (int i = 0; i < N; ++i) {
            String msg;
            PendingPackage pp = this.mPendingPackages.get(i);
            Object idObj = this.getUserIdLPr(pp.sharedId);
            if (idObj != null && idObj instanceof SharedUserSetting) {
                PackageSetting p = this.getPackageLPw(pp.name, null, pp.realName, (SharedUserSetting)idObj, pp.codePath, pp.resourcePath, pp.legacyNativeLibraryPathString, pp.primaryCpuAbiString, pp.secondaryCpuAbiString, pp.versionCode, pp.pkgFlags, pp.pkgPrivateFlags, null, true, false, pp.parentPackageName, pp.childPackageNames);
                if (p == null) {
                    PackageManagerService.reportSettingsProblem(5, "Unable to create application package for " + pp.name);
                    continue;
                }
                p.copyFrom(pp);
                continue;
            }
            if (idObj != null) {
                msg = "Bad package setting: package " + pp.name + " has shared uid " + pp.sharedId + " that is not a shared uid\n";
                this.mReadMessages.append(msg);
                PackageManagerService.reportSettingsProblem(6, msg);
                continue;
            }
            msg = "Bad package setting: package " + pp.name + " has shared uid " + pp.sharedId + " that is not defined\n";
            this.mReadMessages.append(msg);
            PackageManagerService.reportSettingsProblem(6, msg);
        }
        this.mPendingPackages.clear();
        if (this.mBackupStoppedPackagesFilename.exists() || this.mStoppedPackagesFilename.exists()) {
            this.readStoppedLPw();
            this.mBackupStoppedPackagesFilename.delete();
            this.mStoppedPackagesFilename.delete();
            this.writePackageRestrictionsLPr(0);
        } else {
            for (UserInfo user : users) {
                this.readPackageRestrictionsLPr(user.id);
            }
        }
        for (UserInfo user : users) {
            this.mRuntimePermissionsPersistence.readStateForUserSyncLPr(user.id);
        }
        for (PackageSetting disabledPs : this.mDisabledSysPackages.values()) {
            Object id2 = this.getUserIdLPr(disabledPs.appId);
            if (id2 == null || !(id2 instanceof SharedUserSetting)) continue;
            disabledPs.sharedUser = (SharedUserSetting)id2;
        }
        this.mReadMessages.append("Read completed successfully: " + this.mPackages.size() + " packages, " + this.mSharedUsers.size() + " shared uids\n");
        this.writeKernelMappingLPr();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyDefaultPreferredAppsLPw(PackageManagerService service, int userId) {
        for (PackageSetting ps : this.mPackages.values()) {
            if ((ps.pkgFlags & 1) == 0 || ps.pkg == null || ps.pkg.preferredActivityFilters == null) continue;
            ArrayList<PackageParser.ActivityIntentInfo> intents = ps.pkg.preferredActivityFilters;
            for (int i = 0; i < intents.size(); ++i) {
                PackageParser.ActivityIntentInfo aii = intents.get(i);
                this.applyDefaultPreferredActivityLPw(service, aii, new ComponentName(ps.name, aii.activity.className), userId);
            }
        }
        File preferredDir = new File(Environment.getRootDirectory(), "etc/preferred-apps");
        if (!preferredDir.exists() || !preferredDir.isDirectory()) {
            return;
        }
        if (!preferredDir.canRead()) {
            Slog.w(TAG, "Directory " + preferredDir + " cannot be read");
            return;
        }
        for (File f : preferredDir.listFiles()) {
            if (!f.getPath().endsWith(".xml")) {
                Slog.i(TAG, "Non-xml file " + f + " in " + preferredDir + " directory, ignoring");
                continue;
            }
            if (!f.canRead()) {
                Slog.w(TAG, "Preferred apps file " + f + " cannot be read");
                continue;
            }
            InputStream str = null;
            try {
                int type;
                str = new BufferedInputStream(new FileInputStream(f));
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput(str, null);
                while ((type = parser.next()) != 2 && type != 1) {
                }
                if (type != 2) {
                    Slog.w(TAG, "Preferred apps file " + f + " does not have start tag");
                    continue;
                }
                if (!"preferred-activities".equals(parser.getName())) {
                    Slog.w(TAG, "Preferred apps file " + f + " does not start with 'preferred-activities'");
                    continue;
                }
                this.readDefaultPreferredActivitiesLPw(service, parser, userId);
            }
            catch (XmlPullParserException e) {
                Slog.w(TAG, "Error reading apps file " + f, e);
            }
            catch (IOException e) {
                Slog.w(TAG, "Error reading apps file " + f, e);
            }
            finally {
                if (str != null) {
                    try {
                        str.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    private void applyDefaultPreferredActivityLPw(PackageManagerService service, IntentFilter tmpPa, ComponentName cn, int userId) {
        Intent intent = new Intent();
        int flags = 786432;
        intent.setAction(tmpPa.getAction(0));
        for (int i = 0; i < tmpPa.countCategories(); ++i) {
            String cat = tmpPa.getCategory(i);
            if (cat.equals("android.intent.category.DEFAULT")) {
                flags |= 0x10000;
                continue;
            }
            intent.addCategory(cat);
        }
        boolean doNonData = true;
        boolean hasSchemes = false;
        for (int ischeme = 0; ischeme < tmpPa.countDataSchemes(); ++ischeme) {
            boolean doScheme = true;
            String scheme = tmpPa.getDataScheme(ischeme);
            if (scheme != null && !scheme.isEmpty()) {
                hasSchemes = true;
            }
            for (int issp = 0; issp < tmpPa.countDataSchemeSpecificParts(); ++issp) {
                Uri.Builder builder = new Uri.Builder();
                builder.scheme(scheme);
                PatternMatcher ssp = tmpPa.getDataSchemeSpecificPart(issp);
                builder.opaquePart(ssp.getPath());
                Intent finalIntent = new Intent(intent);
                finalIntent.setData(builder.build());
                this.applyDefaultPreferredActivityLPw(service, finalIntent, flags, cn, scheme, ssp, null, null, userId);
                doScheme = false;
            }
            for (int iauth = 0; iauth < tmpPa.countDataAuthorities(); ++iauth) {
                boolean doAuth = true;
                IntentFilter.AuthorityEntry auth = tmpPa.getDataAuthority(iauth);
                for (int ipath = 0; ipath < tmpPa.countDataPaths(); ++ipath) {
                    Uri.Builder builder = new Uri.Builder();
                    builder.scheme(scheme);
                    if (auth.getHost() != null) {
                        builder.authority(auth.getHost());
                    }
                    PatternMatcher path = tmpPa.getDataPath(ipath);
                    builder.path(path.getPath());
                    Intent finalIntent = new Intent(intent);
                    finalIntent.setData(builder.build());
                    this.applyDefaultPreferredActivityLPw(service, finalIntent, flags, cn, scheme, null, auth, path, userId);
                    doScheme = false;
                    doAuth = false;
                }
                if (!doAuth) continue;
                Uri.Builder builder = new Uri.Builder();
                builder.scheme(scheme);
                if (auth.getHost() != null) {
                    builder.authority(auth.getHost());
                }
                Intent finalIntent = new Intent(intent);
                finalIntent.setData(builder.build());
                this.applyDefaultPreferredActivityLPw(service, finalIntent, flags, cn, scheme, null, auth, null, userId);
                doScheme = false;
            }
            if (doScheme) {
                Uri.Builder builder = new Uri.Builder();
                builder.scheme(scheme);
                Intent finalIntent = new Intent(intent);
                finalIntent.setData(builder.build());
                this.applyDefaultPreferredActivityLPw(service, finalIntent, flags, cn, scheme, null, null, null, userId);
            }
            doNonData = false;
        }
        for (int idata = 0; idata < tmpPa.countDataTypes(); ++idata) {
            String mimeType = tmpPa.getDataType(idata);
            if (hasSchemes) {
                Uri.Builder builder = new Uri.Builder();
                for (int ischeme = 0; ischeme < tmpPa.countDataSchemes(); ++ischeme) {
                    String scheme = tmpPa.getDataScheme(ischeme);
                    if (scheme == null || scheme.isEmpty()) continue;
                    Intent finalIntent = new Intent(intent);
                    builder.scheme(scheme);
                    finalIntent.setDataAndType(builder.build(), mimeType);
                    this.applyDefaultPreferredActivityLPw(service, finalIntent, flags, cn, scheme, null, null, null, userId);
                }
            } else {
                Intent finalIntent = new Intent(intent);
                finalIntent.setType(mimeType);
                this.applyDefaultPreferredActivityLPw(service, finalIntent, flags, cn, null, null, null, null, userId);
            }
            doNonData = false;
        }
        if (doNonData) {
            this.applyDefaultPreferredActivityLPw(service, intent, flags, cn, null, null, null, null, userId);
        }
    }

    private void applyDefaultPreferredActivityLPw(PackageManagerService service, Intent intent, int flags, ComponentName cn, String scheme, PatternMatcher ssp, IntentFilter.AuthorityEntry auth, PatternMatcher path, int userId) {
        flags = service.updateFlagsForResolve(flags, userId, intent);
        List<ResolveInfo> ri = service.mActivities.queryIntent(intent, intent.getType(), flags, 0);
        int systemMatch = 0;
        int thirdPartyMatch = 0;
        if (ri != null && ri.size() > 1) {
            boolean haveAct = false;
            ComponentName haveNonSys = null;
            ComponentName[] set = new ComponentName[ri.size()];
            for (int i = 0; i < ri.size(); ++i) {
                ActivityInfo ai = ri.get((int)i).activityInfo;
                set[i] = new ComponentName(ai.packageName, ai.name);
                if ((ai.applicationInfo.flags & 1) == 0) {
                    if (ri.get((int)i).match < thirdPartyMatch) continue;
                    haveNonSys = set[i];
                    break;
                }
                if (!cn.getPackageName().equals(ai.packageName) || !cn.getClassName().equals(ai.name)) continue;
                haveAct = true;
                systemMatch = ri.get((int)i).match;
            }
            if (haveNonSys != null && thirdPartyMatch < systemMatch) {
                haveNonSys = null;
            }
            if (haveAct && haveNonSys == null) {
                IntentFilter filter = new IntentFilter();
                if (intent.getAction() != null) {
                    filter.addAction(intent.getAction());
                }
                if (intent.getCategories() != null) {
                    for (String cat : intent.getCategories()) {
                        filter.addCategory(cat);
                    }
                }
                if ((flags & 0x10000) != 0) {
                    filter.addCategory("android.intent.category.DEFAULT");
                }
                if (scheme != null) {
                    filter.addDataScheme(scheme);
                }
                if (ssp != null) {
                    filter.addDataSchemeSpecificPart(ssp.getPath(), ssp.getType());
                }
                if (auth != null) {
                    filter.addDataAuthority(auth);
                }
                if (path != null) {
                    filter.addDataPath(path);
                }
                if (intent.getType() != null) {
                    try {
                        filter.addDataType(intent.getType());
                    }
                    catch (IntentFilter.MalformedMimeTypeException ex) {
                        Slog.w(TAG, "Malformed mimetype " + intent.getType() + " for " + cn);
                    }
                }
                PreferredActivity pa = new PreferredActivity(filter, systemMatch, set, cn, true);
                this.editPreferredActivitiesLPw(userId).addFilter(pa);
            } else if (haveNonSys == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("No component ");
                sb.append(cn.flattenToShortString());
                sb.append(" found setting preferred ");
                sb.append(intent);
                sb.append("; possible matches are ");
                for (int i = 0; i < set.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(set[i].flattenToShortString());
                }
                Slog.w(TAG, sb.toString());
            } else {
                Slog.i(TAG, "Not setting preferred " + intent + "; found third party match " + haveNonSys.flattenToShortString());
            }
        } else {
            Slog.w(TAG, "No potential matches found for " + intent + " while setting preferred " + cn.flattenToShortString());
        }
    }

    private void readDefaultPreferredActivitiesLPw(PackageManagerService service, XmlPullParser parser, int userId) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals(TAG_ITEM)) {
                PreferredActivity tmpPa = new PreferredActivity(parser);
                if (tmpPa.mPref.getParseError() == null) {
                    this.applyDefaultPreferredActivityLPw(service, tmpPa, tmpPa.mPref.mComponent, userId);
                    continue;
                }
                PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <preferred-activity> " + tmpPa.mPref.getParseError() + " at " + parser.getPositionDescription());
                continue;
            }
            PackageManagerService.reportSettingsProblem(5, "Unknown element under <preferred-activities>: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
    }

    private int readInt(XmlPullParser parser, String ns, String name, int defValue) {
        String v = parser.getAttributeValue(ns, name);
        try {
            if (v == null) {
                return defValue;
            }
            return Integer.parseInt(v);
        }
        catch (NumberFormatException e) {
            PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: attribute " + name + " has bad integer value " + v + " at " + parser.getPositionDescription());
            return defValue;
        }
    }

    private void readPermissionsLPw(ArrayMap<String, BasePermission> out, XmlPullParser parser) throws IOException, XmlPullParserException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals(TAG_ITEM)) {
                String name = parser.getAttributeValue(null, ATTR_NAME);
                String sourcePackage = parser.getAttributeValue(null, "package");
                String ptype = parser.getAttributeValue(null, "type");
                if (name != null && sourcePackage != null) {
                    boolean dynamic = "dynamic".equals(ptype);
                    BasePermission bp = out.get(name);
                    if (bp == null || bp.type != 1) {
                        bp = new BasePermission(name.intern(), sourcePackage, dynamic ? 2 : 0);
                    }
                    bp.protectionLevel = this.readInt(parser, null, "protection", 0);
                    bp.protectionLevel = PermissionInfo.fixProtectionLevel(bp.protectionLevel);
                    if (dynamic) {
                        PermissionInfo pi = new PermissionInfo();
                        pi.packageName = sourcePackage.intern();
                        pi.name = name.intern();
                        pi.icon = this.readInt(parser, null, "icon", 0);
                        pi.nonLocalizedLabel = parser.getAttributeValue(null, "label");
                        pi.protectionLevel = bp.protectionLevel;
                        bp.pendingInfo = pi;
                    }
                    out.put(bp.name, bp);
                } else {
                    PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: permissions has no name at " + parser.getPositionDescription());
                }
            } else {
                PackageManagerService.reportSettingsProblem(5, "Unknown element reading permissions: " + parser.getName() + " at " + parser.getPositionDescription());
            }
            XmlUtils.skipCurrentTag(parser);
        }
    }

    private void readDisabledSysPackageLPw(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        String idStr;
        String name = parser.getAttributeValue(null, ATTR_NAME);
        String realName = parser.getAttributeValue(null, "realName");
        String codePathStr = parser.getAttributeValue(null, "codePath");
        String resourcePathStr = parser.getAttributeValue(null, "resourcePath");
        String legacyCpuAbiStr = parser.getAttributeValue(null, "requiredCpuAbi");
        String legacyNativeLibraryPathStr = parser.getAttributeValue(null, "nativeLibraryPath");
        String parentPackageName = parser.getAttributeValue(null, "parentPackageName");
        String primaryCpuAbiStr = parser.getAttributeValue(null, "primaryCpuAbi");
        String secondaryCpuAbiStr = parser.getAttributeValue(null, "secondaryCpuAbi");
        String cpuAbiOverrideStr = parser.getAttributeValue(null, "cpuAbiOverride");
        if (primaryCpuAbiStr == null && legacyCpuAbiStr != null) {
            primaryCpuAbiStr = legacyCpuAbiStr;
        }
        if (resourcePathStr == null) {
            resourcePathStr = codePathStr;
        }
        String version = parser.getAttributeValue(null, TAG_VERSION);
        int versionCode = 0;
        if (version != null) {
            try {
                versionCode = Integer.parseInt(version);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int pkgFlags = 0;
        int pkgPrivateFlags = 0;
        pkgFlags |= 1;
        File codePathFile = new File(codePathStr);
        if (PackageManagerService.locationIsPrivileged(codePathFile)) {
            pkgPrivateFlags |= 8;
        }
        PackageSetting ps = new PackageSetting(name, realName, codePathFile, new File(resourcePathStr), legacyNativeLibraryPathStr, primaryCpuAbiStr, secondaryCpuAbiStr, cpuAbiOverrideStr, versionCode, pkgFlags, pkgPrivateFlags, parentPackageName, null);
        String timeStampStr = parser.getAttributeValue(null, "ft");
        if (timeStampStr != null) {
            try {
                long timeStamp = Long.parseLong(timeStampStr, 16);
                ps.setTimeStamp(timeStamp);
            }
            catch (NumberFormatException timeStamp) {}
        } else {
            timeStampStr = parser.getAttributeValue(null, "ts");
            if (timeStampStr != null) {
                try {
                    long timeStamp = Long.parseLong(timeStampStr);
                    ps.setTimeStamp(timeStamp);
                }
                catch (NumberFormatException timeStamp) {
                    // empty catch block
                }
            }
        }
        if ((timeStampStr = parser.getAttributeValue(null, "it")) != null) {
            try {
                ps.firstInstallTime = Long.parseLong(timeStampStr, 16);
            }
            catch (NumberFormatException timeStamp) {
                // empty catch block
            }
        }
        if ((timeStampStr = parser.getAttributeValue(null, "ut")) != null) {
            try {
                ps.lastUpdateTime = Long.parseLong(timeStampStr, 16);
            }
            catch (NumberFormatException timeStamp) {
                // empty catch block
            }
        }
        int n = ps.appId = (idStr = parser.getAttributeValue(null, "userId")) != null ? Integer.parseInt(idStr) : 0;
        if (ps.appId <= 0) {
            String sharedIdStr = parser.getAttributeValue(null, "sharedUserId");
            ps.appId = sharedIdStr != null ? Integer.parseInt(sharedIdStr) : 0;
        }
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            if (parser.getName().equals(TAG_PERMISSIONS)) {
                this.readInstallPermissionsLPr(parser, ps.getPermissionsState());
                continue;
            }
            if (parser.getName().equals(TAG_CHILD_PACKAGE)) {
                String childPackageName = parser.getAttributeValue(null, ATTR_NAME);
                if (ps.childPackageNames == null) {
                    ps.childPackageNames = new ArrayList();
                }
                ps.childPackageNames.add(childPackageName);
                continue;
            }
            PackageManagerService.reportSettingsProblem(5, "Unknown element under <updated-package>: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
        this.mDisabledSysPackages.put(name, ps);
    }

    private void readPackageLPw(XmlPullParser parser) throws XmlPullParserException, IOException {
        String name = null;
        String realName = null;
        String idStr = null;
        String sharedIdStr = null;
        String codePathStr = null;
        String resourcePathStr = null;
        String legacyCpuAbiString = null;
        String legacyNativeLibraryPathStr = null;
        String primaryCpuAbiString = null;
        String secondaryCpuAbiString = null;
        String cpuAbiOverrideString = null;
        String systemStr = null;
        String installerPackageName = null;
        String isOrphaned = null;
        String volumeUuid = null;
        String uidError = null;
        int pkgFlags = 0;
        int pkgPrivateFlags = 0;
        long timeStamp = 0L;
        long firstInstallTime = 0L;
        long lastUpdateTime = 0L;
        PackageSettingBase packageSetting = null;
        String version = null;
        int versionCode = 0;
        try {
            int userId;
            String timeStampStr;
            name = parser.getAttributeValue(null, ATTR_NAME);
            realName = parser.getAttributeValue(null, "realName");
            idStr = parser.getAttributeValue(null, "userId");
            uidError = parser.getAttributeValue(null, "uidError");
            sharedIdStr = parser.getAttributeValue(null, "sharedUserId");
            codePathStr = parser.getAttributeValue(null, "codePath");
            resourcePathStr = parser.getAttributeValue(null, "resourcePath");
            legacyCpuAbiString = parser.getAttributeValue(null, "requiredCpuAbi");
            String parentPackageName = parser.getAttributeValue(null, "parentPackageName");
            legacyNativeLibraryPathStr = parser.getAttributeValue(null, "nativeLibraryPath");
            primaryCpuAbiString = parser.getAttributeValue(null, "primaryCpuAbi");
            secondaryCpuAbiString = parser.getAttributeValue(null, "secondaryCpuAbi");
            cpuAbiOverrideString = parser.getAttributeValue(null, "cpuAbiOverride");
            if (primaryCpuAbiString == null && legacyCpuAbiString != null) {
                primaryCpuAbiString = legacyCpuAbiString;
            }
            if ((version = parser.getAttributeValue(null, TAG_VERSION)) != null) {
                try {
                    versionCode = Integer.parseInt(version);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            installerPackageName = parser.getAttributeValue(null, "installer");
            isOrphaned = parser.getAttributeValue(null, "isOrphaned");
            volumeUuid = parser.getAttributeValue(null, ATTR_VOLUME_UUID);
            systemStr = parser.getAttributeValue(null, "publicFlags");
            if (systemStr != null) {
                try {
                    pkgFlags = Integer.parseInt(systemStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                systemStr = parser.getAttributeValue(null, "privateFlags");
                if (systemStr != null) {
                    try {
                        pkgPrivateFlags = Integer.parseInt(systemStr);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else {
                systemStr = parser.getAttributeValue(null, ATTR_FLAGS);
                if (systemStr != null) {
                    try {
                        pkgFlags = Integer.parseInt(systemStr);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if ((pkgFlags & PRE_M_APP_INFO_FLAG_HIDDEN) != 0) {
                        pkgPrivateFlags |= 1;
                    }
                    if ((pkgFlags & PRE_M_APP_INFO_FLAG_CANT_SAVE_STATE) != 0) {
                        pkgPrivateFlags |= 2;
                    }
                    if ((pkgFlags & PRE_M_APP_INFO_FLAG_FORWARD_LOCK) != 0) {
                        pkgPrivateFlags |= 4;
                    }
                    if ((pkgFlags & PRE_M_APP_INFO_FLAG_PRIVILEGED) != 0) {
                        pkgPrivateFlags |= 8;
                    }
                    pkgFlags &= ~(PRE_M_APP_INFO_FLAG_HIDDEN | PRE_M_APP_INFO_FLAG_CANT_SAVE_STATE | PRE_M_APP_INFO_FLAG_FORWARD_LOCK | PRE_M_APP_INFO_FLAG_PRIVILEGED);
                } else {
                    systemStr = parser.getAttributeValue(null, "system");
                    pkgFlags = systemStr != null ? (pkgFlags |= "true".equalsIgnoreCase(systemStr) ? 1 : 0) : (pkgFlags |= 1);
                }
            }
            if ((timeStampStr = parser.getAttributeValue(null, "ft")) != null) {
                try {
                    timeStamp = Long.parseLong(timeStampStr, 16);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                timeStampStr = parser.getAttributeValue(null, "ts");
                if (timeStampStr != null) {
                    try {
                        timeStamp = Long.parseLong(timeStampStr);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if ((timeStampStr = parser.getAttributeValue(null, "it")) != null) {
                try {
                    firstInstallTime = Long.parseLong(timeStampStr, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((timeStampStr = parser.getAttributeValue(null, "ut")) != null) {
                try {
                    lastUpdateTime = Long.parseLong(timeStampStr, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            int n = userId = idStr != null ? Integer.parseInt(idStr) : 0;
            if (resourcePathStr == null) {
                resourcePathStr = codePathStr;
            }
            if (realName != null) {
                realName = realName.intern();
            }
            if (name == null) {
                PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <package> has no name at " + parser.getPositionDescription());
            } else if (codePathStr == null) {
                PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <package> has no codePath at " + parser.getPositionDescription());
            } else if (userId > 0) {
                packageSetting = this.addPackageLPw(name.intern(), realName, new File(codePathStr), new File(resourcePathStr), legacyNativeLibraryPathStr, primaryCpuAbiString, secondaryCpuAbiString, cpuAbiOverrideString, userId, versionCode, pkgFlags, pkgPrivateFlags, parentPackageName, null);
                if (packageSetting == null) {
                    PackageManagerService.reportSettingsProblem(6, "Failure adding uid " + userId + " while parsing settings at " + parser.getPositionDescription());
                } else {
                    packageSetting.setTimeStamp(timeStamp);
                    packageSetting.firstInstallTime = firstInstallTime;
                    packageSetting.lastUpdateTime = lastUpdateTime;
                }
            } else if (sharedIdStr != null) {
                int n2 = userId = sharedIdStr != null ? Integer.parseInt(sharedIdStr) : 0;
                if (userId > 0) {
                    packageSetting = new PendingPackage(name.intern(), realName, new File(codePathStr), new File(resourcePathStr), legacyNativeLibraryPathStr, primaryCpuAbiString, secondaryCpuAbiString, cpuAbiOverrideString, userId, versionCode, pkgFlags, pkgPrivateFlags, parentPackageName, null);
                    packageSetting.setTimeStamp(timeStamp);
                    packageSetting.firstInstallTime = firstInstallTime;
                    packageSetting.lastUpdateTime = lastUpdateTime;
                    this.mPendingPackages.add((PendingPackage)packageSetting);
                } else {
                    PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: package " + name + " has bad sharedId " + sharedIdStr + " at " + parser.getPositionDescription());
                }
            } else {
                PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: package " + name + " has bad userId " + idStr + " at " + parser.getPositionDescription());
            }
        }
        catch (NumberFormatException e) {
            PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: package " + name + " has bad userId " + idStr + " at " + parser.getPositionDescription());
        }
        if (packageSetting != null) {
            int type;
            String installStatusStr;
            block74: {
                packageSetting.uidError = "true".equals(uidError);
                packageSetting.installerPackageName = installerPackageName;
                packageSetting.isOrphaned = "true".equals(isOrphaned);
                packageSetting.volumeUuid = volumeUuid;
                packageSetting.legacyNativeLibraryPathString = legacyNativeLibraryPathStr;
                packageSetting.primaryCpuAbiString = primaryCpuAbiString;
                packageSetting.secondaryCpuAbiString = secondaryCpuAbiString;
                String enabledStr = parser.getAttributeValue(null, ATTR_ENABLED);
                if (enabledStr != null) {
                    try {
                        packageSetting.setEnabled(Integer.parseInt(enabledStr), 0, null);
                    }
                    catch (NumberFormatException e) {
                        if (enabledStr.equalsIgnoreCase("true")) {
                            packageSetting.setEnabled(1, 0, null);
                            break block74;
                        }
                        if (enabledStr.equalsIgnoreCase("false")) {
                            packageSetting.setEnabled(2, 0, null);
                            break block74;
                        }
                        if (enabledStr.equalsIgnoreCase("default")) {
                            packageSetting.setEnabled(0, 0, null);
                            break block74;
                        }
                        PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: package " + name + " has bad enabled value: " + idStr + " at " + parser.getPositionDescription());
                    }
                } else {
                    packageSetting.setEnabled(0, 0, null);
                }
            }
            if (installerPackageName != null) {
                this.mInstallerPackages.add(installerPackageName);
            }
            if ((installStatusStr = parser.getAttributeValue(null, "installStatus")) != null) {
                packageSetting.installStatus = installStatusStr.equalsIgnoreCase("false") ? 0 : 1;
            }
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                String tagName = parser.getName();
                if (tagName.equals(TAG_DISABLED_COMPONENTS)) {
                    this.readDisabledComponentsLPw(packageSetting, parser, 0);
                    continue;
                }
                if (tagName.equals(TAG_ENABLED_COMPONENTS)) {
                    this.readEnabledComponentsLPw(packageSetting, parser, 0);
                    continue;
                }
                if (tagName.equals("sigs")) {
                    packageSetting.signatures.readXml(parser, this.mPastSignatures);
                    continue;
                }
                if (tagName.equals(TAG_PERMISSIONS)) {
                    this.readInstallPermissionsLPr(parser, packageSetting.getPermissionsState());
                    packageSetting.installPermissionsFixed = true;
                    continue;
                }
                if (tagName.equals("proper-signing-keyset")) {
                    long id2 = Long.parseLong(parser.getAttributeValue(null, "identifier"));
                    Integer refCt = this.mKeySetRefs.get(id2);
                    if (refCt != null) {
                        this.mKeySetRefs.put(id2, refCt + 1);
                    } else {
                        this.mKeySetRefs.put(id2, 1);
                    }
                    packageSetting.keySetData.setProperSigningKeySet(id2);
                    continue;
                }
                if (tagName.equals("signing-keyset")) continue;
                if (tagName.equals("upgrade-keyset")) {
                    long id3 = Long.parseLong(parser.getAttributeValue(null, "identifier"));
                    packageSetting.keySetData.addUpgradeKeySetById(id3);
                    continue;
                }
                if (tagName.equals("defined-keyset")) {
                    long id4 = Long.parseLong(parser.getAttributeValue(null, "identifier"));
                    String alias = parser.getAttributeValue(null, "alias");
                    Integer refCt = this.mKeySetRefs.get(id4);
                    if (refCt != null) {
                        this.mKeySetRefs.put(id4, refCt + 1);
                    } else {
                        this.mKeySetRefs.put(id4, 1);
                    }
                    packageSetting.keySetData.addDefinedKeySet(id4, alias);
                    continue;
                }
                if (tagName.equals(TAG_DOMAIN_VERIFICATION)) {
                    this.readDomainVerificationLPw(parser, packageSetting);
                    continue;
                }
                if (tagName.equals(TAG_CHILD_PACKAGE)) {
                    String childPackageName = parser.getAttributeValue(null, ATTR_NAME);
                    if (packageSetting.childPackageNames == null) {
                        packageSetting.childPackageNames = new ArrayList<String>();
                    }
                    packageSetting.childPackageNames.add(childPackageName);
                    continue;
                }
                PackageManagerService.reportSettingsProblem(5, "Unknown element under <package>: " + parser.getName());
                XmlUtils.skipCurrentTag(parser);
            }
        } else {
            XmlUtils.skipCurrentTag(parser);
        }
    }

    private void readDisabledComponentsLPw(PackageSettingBase packageSetting, XmlPullParser parser, int userId) throws IOException, XmlPullParserException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals(TAG_ITEM)) {
                String name = parser.getAttributeValue(null, ATTR_NAME);
                if (name != null) {
                    packageSetting.addDisabledComponent(name.intern(), userId);
                } else {
                    PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <disabled-components> has no name at " + parser.getPositionDescription());
                }
            } else {
                PackageManagerService.reportSettingsProblem(5, "Unknown element under <disabled-components>: " + parser.getName());
            }
            XmlUtils.skipCurrentTag(parser);
        }
    }

    private void readEnabledComponentsLPw(PackageSettingBase packageSetting, XmlPullParser parser, int userId) throws IOException, XmlPullParserException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals(TAG_ITEM)) {
                String name = parser.getAttributeValue(null, ATTR_NAME);
                if (name != null) {
                    packageSetting.addEnabledComponent(name.intern(), userId);
                } else {
                    PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <enabled-components> has no name at " + parser.getPositionDescription());
                }
            } else {
                PackageManagerService.reportSettingsProblem(5, "Unknown element under <enabled-components>: " + parser.getName());
            }
            XmlUtils.skipCurrentTag(parser);
        }
    }

    private void readSharedUserLPw(XmlPullParser parser) throws XmlPullParserException, IOException {
        String name = null;
        String idStr = null;
        int pkgFlags = 0;
        int pkgPrivateFlags = 0;
        SharedUserSetting su = null;
        try {
            int userId;
            name = parser.getAttributeValue(null, ATTR_NAME);
            idStr = parser.getAttributeValue(null, "userId");
            int n = userId = idStr != null ? Integer.parseInt(idStr) : 0;
            if ("true".equals(parser.getAttributeValue(null, "system"))) {
                pkgFlags |= 1;
            }
            if (name == null) {
                PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <shared-user> has no name at " + parser.getPositionDescription());
            } else if (userId == 0) {
                PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: shared-user " + name + " has bad userId " + idStr + " at " + parser.getPositionDescription());
            } else {
                su = this.addSharedUserLPw(name.intern(), userId, pkgFlags, pkgPrivateFlags);
                if (su == null) {
                    PackageManagerService.reportSettingsProblem(6, "Occurred while parsing settings at " + parser.getPositionDescription());
                }
            }
        }
        catch (NumberFormatException e) {
            PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: package " + name + " has bad userId " + idStr + " at " + parser.getPositionDescription());
        }
        if (su != null) {
            int type;
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                String tagName = parser.getName();
                if (tagName.equals("sigs")) {
                    su.signatures.readXml(parser, this.mPastSignatures);
                    continue;
                }
                if (tagName.equals(TAG_PERMISSIONS)) {
                    this.readInstallPermissionsLPr(parser, su.getPermissionsState());
                    continue;
                }
                PackageManagerService.reportSettingsProblem(5, "Unknown element under <shared-user>: " + parser.getName());
                XmlUtils.skipCurrentTag(parser);
            }
        } else {
            XmlUtils.skipCurrentTag(parser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createNewUserLI(PackageManagerService service, Installer installer, int userHandle) {
        int[] targetSdkVersions;
        String[] seinfos;
        int[] appIds;
        String[] names;
        String[] volumeUuids;
        int packagesCount;
        ArrayMap<String, PackageSetting> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Collection<PackageSetting> packages = this.mPackages.values();
            packagesCount = packages.size();
            volumeUuids = new String[packagesCount];
            names = new String[packagesCount];
            appIds = new int[packagesCount];
            seinfos = new String[packagesCount];
            targetSdkVersions = new int[packagesCount];
            Iterator<PackageSetting> packagesIterator = packages.iterator();
            for (int i = 0; i < packagesCount; ++i) {
                PackageSetting ps = packagesIterator.next();
                if (ps.pkg == null || ps.pkg.applicationInfo == null) continue;
                ps.setInstalled(ps.isSystem(), userHandle);
                volumeUuids[i] = ps.volumeUuid;
                names[i] = ps.name;
                appIds[i] = ps.appId;
                seinfos[i] = ps.pkg.applicationInfo.seinfo;
                targetSdkVersions[i] = ps.pkg.applicationInfo.targetSdkVersion;
            }
        }
        for (int i = 0; i < packagesCount; ++i) {
            if (names[i] == null) continue;
            int flags = 3;
            try {
                installer.createAppData(volumeUuids[i], names[i], userHandle, 3, appIds[i], seinfos[i], targetSdkVersions[i]);
                continue;
            }
            catch (InstallerConnection.InstallerException e) {
                Slog.w(TAG, "Failed to prepare app data", e);
            }
        }
        ArrayMap<String, PackageSetting> arrayMap2 = this.mPackages;
        synchronized (arrayMap2) {
            this.applyDefaultPreferredAppsLPw(service, userHandle);
        }
    }

    void removeUserLPw(int userId) {
        Set<Map.Entry<String, PackageSetting>> entries = this.mPackages.entrySet();
        for (Map.Entry<String, PackageSetting> entry : entries) {
            entry.getValue().removeUser(userId);
        }
        this.mPreferredActivities.remove(userId);
        File file = this.getUserPackagesStateFile(userId);
        file.delete();
        file = this.getUserPackagesStateBackupFile(userId);
        file.delete();
        this.removeCrossProfileIntentFiltersLPw(userId);
        this.mRuntimePermissionsPersistence.onUserRemovedLPw(userId);
        this.writePackageListLPr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCrossProfileIntentFiltersLPw(int userId) {
        SparseArray<CrossProfileIntentResolver> sparseArray = this.mCrossProfileIntentResolvers;
        synchronized (sparseArray) {
            if (this.mCrossProfileIntentResolvers.get(userId) != null) {
                this.mCrossProfileIntentResolvers.remove(userId);
                this.writePackageRestrictionsLPr(userId);
            }
            int count = this.mCrossProfileIntentResolvers.size();
            for (int i = 0; i < count; ++i) {
                int sourceUserId = this.mCrossProfileIntentResolvers.keyAt(i);
                CrossProfileIntentResolver cpir = this.mCrossProfileIntentResolvers.get(sourceUserId);
                boolean needsWriting = false;
                ArraySet cpifs = new ArraySet(cpir.filterSet());
                for (CrossProfileIntentFilter cpif : cpifs) {
                    if (cpif.getTargetUserId() != userId) continue;
                    needsWriting = true;
                    cpir.removeFilter(cpif);
                }
                if (!needsWriting) continue;
                this.writePackageRestrictionsLPr(sourceUserId);
            }
        }
    }

    private void setFirstAvailableUid(int uid) {
        if (uid > mFirstAvailableUid) {
            mFirstAvailableUid = uid;
        }
    }

    private int newUserIdLPw(Object obj) {
        int N = this.mUserIds.size();
        for (int i = mFirstAvailableUid; i < N; ++i) {
            if (this.mUserIds.get(i) != null) continue;
            this.mUserIds.set(i, obj);
            return 10000 + i;
        }
        if (N > 9999) {
            return -1;
        }
        this.mUserIds.add(obj);
        return 10000 + N;
    }

    public VerifierDeviceIdentity getVerifierDeviceIdentityLPw() {
        if (this.mVerifierDeviceIdentity == null) {
            this.mVerifierDeviceIdentity = VerifierDeviceIdentity.generate();
            this.writeLPr();
        }
        return this.mVerifierDeviceIdentity;
    }

    public boolean hasOtherDisabledSystemPkgWithChildLPr(String parentPackageName, String childPackageName) {
        int packageCount = this.mDisabledSysPackages.size();
        for (int i = 0; i < packageCount; ++i) {
            PackageSetting disabledPs = this.mDisabledSysPackages.valueAt(i);
            if (disabledPs.childPackageNames == null || disabledPs.childPackageNames.isEmpty() || disabledPs.name.equals(parentPackageName)) continue;
            int childCount = disabledPs.childPackageNames.size();
            for (int j = 0; j < childCount; ++j) {
                String currChildPackageName = (String)disabledPs.childPackageNames.get(j);
                if (!currChildPackageName.equals(childPackageName)) continue;
                return true;
            }
        }
        return false;
    }

    public PackageSetting getDisabledSystemPkgLPr(String name) {
        PackageSetting ps = this.mDisabledSysPackages.get(name);
        return ps;
    }

    private String compToString(ArraySet<String> cmp) {
        return cmp != null ? Arrays.toString(cmp.toArray()) : "[]";
    }

    boolean isEnabledAndMatchLPr(ComponentInfo componentInfo, int flags, int userId) {
        PackageSetting ps = this.mPackages.get(componentInfo.packageName);
        if (ps == null) {
            return false;
        }
        PackageUserState userState = ps.readUserState(userId);
        return userState.isMatch(componentInfo, flags);
    }

    String getInstallerPackageNameLPr(String packageName) {
        PackageSetting pkg = this.mPackages.get(packageName);
        if (pkg == null) {
            throw new IllegalArgumentException("Unknown package: " + packageName);
        }
        return pkg.installerPackageName;
    }

    boolean isOrphaned(String packageName) {
        PackageSetting pkg = this.mPackages.get(packageName);
        if (pkg == null) {
            throw new IllegalArgumentException("Unknown package: " + packageName);
        }
        return pkg.isOrphaned;
    }

    int getApplicationEnabledSettingLPr(String packageName, int userId) {
        PackageSetting pkg = this.mPackages.get(packageName);
        if (pkg == null) {
            throw new IllegalArgumentException("Unknown package: " + packageName);
        }
        return pkg.getEnabled(userId);
    }

    int getComponentEnabledSettingLPr(ComponentName componentName, int userId) {
        String packageName = componentName.getPackageName();
        PackageSetting pkg = this.mPackages.get(packageName);
        if (pkg == null) {
            throw new IllegalArgumentException("Unknown component: " + componentName);
        }
        String classNameStr = componentName.getClassName();
        return pkg.getCurrentEnabledStateLPr(classNameStr, userId);
    }

    boolean setPackageStoppedStateLPw(PackageManagerService pm, String packageName, boolean stopped, boolean allowedByPermission, int uid, int userId) {
        int appId = UserHandle.getAppId(uid);
        PackageSetting pkgSetting = this.mPackages.get(packageName);
        if (pkgSetting == null) {
            throw new IllegalArgumentException("Unknown package: " + packageName);
        }
        if (!allowedByPermission && appId != pkgSetting.appId) {
            throw new SecurityException("Permission Denial: attempt to change stopped state from pid=" + Binder.getCallingPid() + ", uid=" + uid + ", package uid=" + pkgSetting.appId);
        }
        if (pkgSetting.getStopped(userId) != stopped) {
            pkgSetting.setStopped(stopped, userId);
            if (pkgSetting.getNotLaunched(userId)) {
                if (pkgSetting.installerPackageName != null) {
                    pm.notifyFirstLaunch(pkgSetting.name, pkgSetting.installerPackageName, userId);
                }
                pkgSetting.setNotLaunched(false, userId);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<UserInfo> getAllUsers() {
        long id2 = Binder.clearCallingIdentity();
        try {
            List<UserInfo> list = UserManagerService.getInstance().getUsers(false);
            return list;
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            Binder.restoreCallingIdentity(id2);
        }
        return null;
    }

    List<PackageSetting> getVolumePackagesLPr(String volumeUuid) {
        ArrayList<PackageSetting> res = new ArrayList<PackageSetting>();
        for (int i = 0; i < this.mPackages.size(); ++i) {
            PackageSetting setting = this.mPackages.valueAt(i);
            if (!Objects.equals(volumeUuid, setting.volumeUuid)) continue;
            res.add(setting);
        }
        return res;
    }

    static void printFlags(PrintWriter pw, int val, Object[] spec) {
        pw.print("[ ");
        for (int i = 0; i < spec.length; i += 2) {
            int mask = (Integer)spec[i];
            if ((val & mask) == 0) continue;
            pw.print(spec[i + 1]);
            pw.print(" ");
        }
        pw.print("]");
    }

    void dumpVersionLPr(IndentingPrintWriter pw) {
        pw.increaseIndent();
        for (int i = 0; i < this.mVersion.size(); ++i) {
            String volumeUuid = this.mVersion.keyAt(i);
            VersionInfo ver = this.mVersion.valueAt(i);
            if (Objects.equals(StorageManager.UUID_PRIVATE_INTERNAL, volumeUuid)) {
                pw.println("Internal:");
            } else if (Objects.equals("primary_physical", volumeUuid)) {
                pw.println("External:");
            } else {
                pw.println("UUID " + volumeUuid + ":");
            }
            pw.increaseIndent();
            pw.printPair(ATTR_SDK_VERSION, ver.sdkVersion);
            pw.printPair(ATTR_DATABASE_VERSION, ver.databaseVersion);
            pw.println();
            pw.printPair(ATTR_FINGERPRINT, ver.fingerprint);
            pw.println();
            pw.decreaseIndent();
        }
        pw.decreaseIndent();
    }

    void dumpPackageLPr(PrintWriter pw, String prefix, String checkinTag, ArraySet<String> permissionNames, PackageSetting ps, SimpleDateFormat sdf, Date date, List<UserInfo> users, boolean dumpAll) {
        int i;
        if (checkinTag != null) {
            pw.print(checkinTag);
            pw.print(",");
            pw.print(ps.realName != null ? ps.realName : ps.name);
            pw.print(",");
            pw.print(ps.appId);
            pw.print(",");
            pw.print(ps.versionCode);
            pw.print(",");
            pw.print(ps.firstInstallTime);
            pw.print(",");
            pw.print(ps.lastUpdateTime);
            pw.print(",");
            pw.print(ps.installerPackageName != null ? ps.installerPackageName : "?");
            pw.println();
            if (ps.pkg != null) {
                pw.print(checkinTag);
                pw.print("-");
                pw.print("splt,");
                pw.print("base,");
                pw.println(ps.pkg.baseRevisionCode);
                if (ps.pkg.splitNames != null) {
                    for (int i2 = 0; i2 < ps.pkg.splitNames.length; ++i2) {
                        pw.print(checkinTag);
                        pw.print("-");
                        pw.print("splt,");
                        pw.print(ps.pkg.splitNames[i2]);
                        pw.print(",");
                        pw.println(ps.pkg.splitRevisionCodes[i2]);
                    }
                }
            }
            for (UserInfo user : users) {
                pw.print(checkinTag);
                pw.print("-");
                pw.print("usr");
                pw.print(",");
                pw.print(user.id);
                pw.print(",");
                pw.print(ps.getInstalled(user.id) ? "I" : "i");
                pw.print(ps.getHidden(user.id) ? "B" : "b");
                pw.print(ps.getSuspended(user.id) ? "SU" : "su");
                pw.print(ps.getStopped(user.id) ? "S" : "s");
                pw.print(ps.getNotLaunched(user.id) ? "l" : "L");
                pw.print(",");
                pw.print(ps.getEnabled(user.id));
                String lastDisabledAppCaller = ps.getLastDisabledAppCaller(user.id);
                pw.print(",");
                pw.print(lastDisabledAppCaller != null ? lastDisabledAppCaller : "?");
                pw.println();
            }
            return;
        }
        pw.print(prefix);
        pw.print("Package [");
        pw.print(ps.realName != null ? ps.realName : ps.name);
        pw.print("] (");
        pw.print(Integer.toHexString(System.identityHashCode(ps)));
        pw.println("):");
        if (ps.realName != null) {
            pw.print(prefix);
            pw.print("  compat name=");
            pw.println(ps.name);
        }
        pw.print(prefix);
        pw.print("  userId=");
        pw.println(ps.appId);
        if (ps.sharedUser != null) {
            pw.print(prefix);
            pw.print("  sharedUser=");
            pw.println(ps.sharedUser);
        }
        pw.print(prefix);
        pw.print("  pkg=");
        pw.println(ps.pkg);
        pw.print(prefix);
        pw.print("  codePath=");
        pw.println(ps.codePathString);
        if (permissionNames == null) {
            pw.print(prefix);
            pw.print("  resourcePath=");
            pw.println(ps.resourcePathString);
            pw.print(prefix);
            pw.print("  legacyNativeLibraryDir=");
            pw.println(ps.legacyNativeLibraryPathString);
            pw.print(prefix);
            pw.print("  primaryCpuAbi=");
            pw.println(ps.primaryCpuAbiString);
            pw.print(prefix);
            pw.print("  secondaryCpuAbi=");
            pw.println(ps.secondaryCpuAbiString);
        }
        pw.print(prefix);
        pw.print("  versionCode=");
        pw.print(ps.versionCode);
        if (ps.pkg != null) {
            pw.print(" minSdk=");
            pw.print(ps.pkg.applicationInfo.minSdkVersion);
            pw.print(" targetSdk=");
            pw.print(ps.pkg.applicationInfo.targetSdkVersion);
        }
        pw.println();
        if (ps.pkg != null) {
            if (ps.pkg.parentPackage != null) {
                PackageParser.Package parentPkg = ps.pkg.parentPackage;
                PackageSetting pps = this.mPackages.get(parentPkg.packageName);
                if (pps == null || !pps.codePathString.equals(parentPkg.codePath)) {
                    pps = this.mDisabledSysPackages.get(parentPkg.packageName);
                }
                if (pps != null) {
                    pw.print(prefix);
                    pw.print("  parentPackage=");
                    pw.println(pps.realName != null ? pps.realName : pps.name);
                }
            } else if (ps.pkg.childPackages != null) {
                pw.print(prefix);
                pw.print("  childPackages=[");
                int childCount = ps.pkg.childPackages.size();
                for (int i3 = 0; i3 < childCount; ++i3) {
                    PackageParser.Package childPkg = ps.pkg.childPackages.get(i3);
                    PackageSetting cps = this.mPackages.get(childPkg.packageName);
                    if (cps == null || !cps.codePathString.equals(childPkg.codePath)) {
                        cps = this.mDisabledSysPackages.get(childPkg.packageName);
                    }
                    if (cps == null) continue;
                    if (i3 > 0) {
                        pw.print(", ");
                    }
                    pw.print(cps.realName != null ? cps.realName : cps.name);
                }
                pw.println("]");
            }
            pw.print(prefix);
            pw.print("  versionName=");
            pw.println(ps.pkg.mVersionName);
            pw.print(prefix);
            pw.print("  splits=");
            Settings.dumpSplitNames(pw, ps.pkg);
            pw.println();
            int apkSigningVersion = PackageParser.getApkSigningVersion(ps.pkg);
            if (apkSigningVersion != 0) {
                pw.print(prefix);
                pw.print("  apkSigningVersion=");
                pw.println(apkSigningVersion);
            }
            pw.print(prefix);
            pw.print("  applicationInfo=");
            pw.println(ps.pkg.applicationInfo.toString());
            pw.print(prefix);
            pw.print("  flags=");
            Settings.printFlags(pw, ps.pkg.applicationInfo.flags, FLAG_DUMP_SPEC);
            pw.println();
            if (ps.pkg.applicationInfo.privateFlags != 0) {
                pw.print(prefix);
                pw.print("  privateFlags=");
                Settings.printFlags(pw, ps.pkg.applicationInfo.privateFlags, PRIVATE_FLAG_DUMP_SPEC);
                pw.println();
            }
            pw.print(prefix);
            pw.print("  dataDir=");
            pw.println(ps.pkg.applicationInfo.dataDir);
            pw.print(prefix);
            pw.print("  supportsScreens=[");
            boolean first = true;
            if ((ps.pkg.applicationInfo.flags & 0x200) != 0) {
                if (!first) {
                    pw.print(", ");
                }
                first = false;
                pw.print("small");
            }
            if ((ps.pkg.applicationInfo.flags & 0x400) != 0) {
                if (!first) {
                    pw.print(", ");
                }
                first = false;
                pw.print("medium");
            }
            if ((ps.pkg.applicationInfo.flags & 0x800) != 0) {
                if (!first) {
                    pw.print(", ");
                }
                first = false;
                pw.print("large");
            }
            if ((ps.pkg.applicationInfo.flags & 0x80000) != 0) {
                if (!first) {
                    pw.print(", ");
                }
                first = false;
                pw.print("xlarge");
            }
            if ((ps.pkg.applicationInfo.flags & 0x1000) != 0) {
                if (!first) {
                    pw.print(", ");
                }
                first = false;
                pw.print("resizeable");
            }
            if ((ps.pkg.applicationInfo.flags & 0x2000) != 0) {
                if (!first) {
                    pw.print(", ");
                }
                first = false;
                pw.print("anyDensity");
            }
            pw.println("]");
            if (ps.pkg.libraryNames != null && ps.pkg.libraryNames.size() > 0) {
                pw.print(prefix);
                pw.println("  libraries:");
                for (int i4 = 0; i4 < ps.pkg.libraryNames.size(); ++i4) {
                    pw.print(prefix);
                    pw.print("    ");
                    pw.println(ps.pkg.libraryNames.get(i4));
                }
            }
            if (ps.pkg.usesLibraries != null && ps.pkg.usesLibraries.size() > 0) {
                pw.print(prefix);
                pw.println("  usesLibraries:");
                for (int i5 = 0; i5 < ps.pkg.usesLibraries.size(); ++i5) {
                    pw.print(prefix);
                    pw.print("    ");
                    pw.println(ps.pkg.usesLibraries.get(i5));
                }
            }
            if (ps.pkg.usesOptionalLibraries != null && ps.pkg.usesOptionalLibraries.size() > 0) {
                pw.print(prefix);
                pw.println("  usesOptionalLibraries:");
                for (int i6 = 0; i6 < ps.pkg.usesOptionalLibraries.size(); ++i6) {
                    pw.print(prefix);
                    pw.print("    ");
                    pw.println(ps.pkg.usesOptionalLibraries.get(i6));
                }
            }
            if (ps.pkg.usesLibraryFiles != null && ps.pkg.usesLibraryFiles.length > 0) {
                pw.print(prefix);
                pw.println("  usesLibraryFiles:");
                for (int i7 = 0; i7 < ps.pkg.usesLibraryFiles.length; ++i7) {
                    pw.print(prefix);
                    pw.print("    ");
                    pw.println(ps.pkg.usesLibraryFiles[i7]);
                }
            }
        }
        pw.print(prefix);
        pw.print("  timeStamp=");
        date.setTime(ps.timeStamp);
        pw.println(sdf.format(date));
        pw.print(prefix);
        pw.print("  firstInstallTime=");
        date.setTime(ps.firstInstallTime);
        pw.println(sdf.format(date));
        pw.print(prefix);
        pw.print("  lastUpdateTime=");
        date.setTime(ps.lastUpdateTime);
        pw.println(sdf.format(date));
        if (ps.installerPackageName != null) {
            pw.print(prefix);
            pw.print("  installerPackageName=");
            pw.println(ps.installerPackageName);
        }
        if (ps.volumeUuid != null) {
            pw.print(prefix);
            pw.print("  volumeUuid=");
            pw.println(ps.volumeUuid);
        }
        pw.print(prefix);
        pw.print("  signatures=");
        pw.println(ps.signatures);
        pw.print(prefix);
        pw.print("  installPermissionsFixed=");
        pw.print(ps.installPermissionsFixed);
        pw.print(" installStatus=");
        pw.println(ps.installStatus);
        pw.print(prefix);
        pw.print("  pkgFlags=");
        Settings.printFlags(pw, ps.pkgFlags, FLAG_DUMP_SPEC);
        pw.println();
        if (ps.pkg != null && ps.pkg.permissions != null && ps.pkg.permissions.size() > 0) {
            ArrayList<PackageParser.Permission> perms = ps.pkg.permissions;
            pw.print(prefix);
            pw.println("  declared permissions:");
            for (i = 0; i < perms.size(); ++i) {
                PackageParser.Permission perm = perms.get(i);
                if (permissionNames != null && !permissionNames.contains(perm.info.name)) continue;
                pw.print(prefix);
                pw.print("    ");
                pw.print(perm.info.name);
                pw.print(": prot=");
                pw.print(PermissionInfo.protectionToString(perm.info.protectionLevel));
                if ((perm.info.flags & 1) != 0) {
                    pw.print(", COSTS_MONEY");
                }
                if ((perm.info.flags & 2) != 0) {
                    pw.print(", HIDDEN");
                }
                if ((perm.info.flags & 0x40000000) != 0) {
                    pw.print(", INSTALLED");
                }
                pw.println();
            }
        }
        if ((permissionNames != null || dumpAll) && ps.pkg != null && ps.pkg.requestedPermissions != null && ps.pkg.requestedPermissions.size() > 0) {
            ArrayList<String> perms = ps.pkg.requestedPermissions;
            pw.print(prefix);
            pw.println("  requested permissions:");
            for (i = 0; i < perms.size(); ++i) {
                String perm = perms.get(i);
                if (permissionNames != null && !permissionNames.contains(perm)) continue;
                pw.print(prefix);
                pw.print("    ");
                pw.println(perm);
            }
        }
        if (ps.sharedUser == null || permissionNames != null || dumpAll) {
            PermissionsState permissionsState = ps.getPermissionsState();
            this.dumpInstallPermissionsLPr(pw, prefix + "  ", permissionNames, permissionsState);
        }
        for (UserInfo user : users) {
            pw.print(prefix);
            pw.print("  User ");
            pw.print(user.id);
            pw.print(": ");
            pw.print("ceDataInode=");
            pw.print(ps.getCeDataInode(user.id));
            pw.print(" installed=");
            pw.print(ps.getInstalled(user.id));
            pw.print(" hidden=");
            pw.print(ps.getHidden(user.id));
            pw.print(" suspended=");
            pw.print(ps.getSuspended(user.id));
            pw.print(" stopped=");
            pw.print(ps.getStopped(user.id));
            pw.print(" notLaunched=");
            pw.print(ps.getNotLaunched(user.id));
            pw.print(" enabled=");
            pw.println(ps.getEnabled(user.id));
            String lastDisabledAppCaller = ps.getLastDisabledAppCaller(user.id);
            if (lastDisabledAppCaller != null) {
                pw.print(prefix);
                pw.print("    lastDisabledCaller: ");
                pw.println(lastDisabledAppCaller);
            }
            if (ps.sharedUser == null) {
                PermissionsState permissionsState = ps.getPermissionsState();
                this.dumpGidsLPr(pw, prefix + "    ", permissionsState.computeGids(user.id));
                this.dumpRuntimePermissionsLPr(pw, prefix + "    ", permissionNames, permissionsState.getRuntimePermissionStates(user.id), dumpAll);
            }
            if (permissionNames != null) continue;
            ArraySet<String> cmp = ps.getDisabledComponents(user.id);
            if (cmp != null && cmp.size() > 0) {
                pw.print(prefix);
                pw.println("    disabledComponents:");
                for (String s : cmp) {
                    pw.print(prefix);
                    pw.print("      ");
                    pw.println(s);
                }
            }
            if ((cmp = ps.getEnabledComponents(user.id)) == null || cmp.size() <= 0) continue;
            pw.print(prefix);
            pw.println("    enabledComponents:");
            for (String s : cmp) {
                pw.print(prefix);
                pw.print("      ");
                pw.println(s);
            }
        }
    }

    void dumpPackagesLPr(PrintWriter pw, String packageName, ArraySet<String> permissionNames, PackageManagerService.DumpState dumpState, boolean checkin) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        boolean printedSomething = false;
        List<UserInfo> users = this.getAllUsers();
        for (PackageSetting packageSetting : this.mPackages.values()) {
            if (packageName != null && !packageName.equals(packageSetting.realName) && !packageName.equals(packageSetting.name) || permissionNames != null && !packageSetting.getPermissionsState().hasRequestedPermission(permissionNames)) continue;
            if (!checkin && packageName != null) {
                dumpState.setSharedUser(packageSetting.sharedUser);
            }
            if (!checkin && !printedSomething) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                pw.println("Packages:");
                printedSomething = true;
            }
            this.dumpPackageLPr(pw, "  ", checkin ? TAG_PACKAGE : null, permissionNames, packageSetting, sdf, date, users, packageName != null);
        }
        printedSomething = false;
        if (this.mRenamedPackages.size() > 0 && permissionNames == null) {
            for (Map.Entry entry : this.mRenamedPackages.entrySet()) {
                if (packageName != null && !packageName.equals(entry.getKey()) && !packageName.equals(entry.getValue())) continue;
                if (!checkin) {
                    if (!printedSomething) {
                        if (dumpState.onTitlePrinted()) {
                            pw.println();
                        }
                        pw.println("Renamed packages:");
                        printedSomething = true;
                    }
                    pw.print("  ");
                } else {
                    pw.print("ren,");
                }
                pw.print((String)entry.getKey());
                pw.print(checkin ? " -> " : ",");
                pw.println((String)entry.getValue());
            }
        }
        printedSomething = false;
        if (this.mDisabledSysPackages.size() > 0 && permissionNames == null) {
            for (PackageSetting packageSetting : this.mDisabledSysPackages.values()) {
                if (packageName != null && !packageName.equals(packageSetting.realName) && !packageName.equals(packageSetting.name)) continue;
                if (!checkin && !printedSomething) {
                    if (dumpState.onTitlePrinted()) {
                        pw.println();
                    }
                    pw.println("Hidden system packages:");
                    printedSomething = true;
                }
                this.dumpPackageLPr(pw, "  ", checkin ? "dis" : null, permissionNames, packageSetting, sdf, date, users, packageName != null);
            }
        }
    }

    void dumpPermissionsLPr(PrintWriter pw, String packageName, ArraySet<String> permissionNames, PackageManagerService.DumpState dumpState) {
        boolean printedSomething = false;
        for (BasePermission p : this.mPermissions.values()) {
            if (packageName != null && !packageName.equals(p.sourcePackage) || permissionNames != null && !permissionNames.contains(p.name)) continue;
            if (!printedSomething) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                pw.println("Permissions:");
                printedSomething = true;
            }
            pw.print("  Permission [");
            pw.print(p.name);
            pw.print("] (");
            pw.print(Integer.toHexString(System.identityHashCode(p)));
            pw.println("):");
            pw.print("    sourcePackage=");
            pw.println(p.sourcePackage);
            pw.print("    uid=");
            pw.print(p.uid);
            pw.print(" gids=");
            pw.print(Arrays.toString(p.computeGids(0)));
            pw.print(" type=");
            pw.print(p.type);
            pw.print(" prot=");
            pw.println(PermissionInfo.protectionToString(p.protectionLevel));
            if (p.perm != null) {
                pw.print("    perm=");
                pw.println(p.perm);
                if ((p.perm.info.flags & 0x40000000) == 0 || (p.perm.info.flags & 2) != 0) {
                    pw.print("    flags=0x");
                    pw.println(Integer.toHexString(p.perm.info.flags));
                }
            }
            if (p.packageSetting != null) {
                pw.print("    packageSetting=");
                pw.println(p.packageSetting);
            }
            if (!"android.permission.READ_EXTERNAL_STORAGE".equals(p.name)) continue;
            pw.print("    enforced=");
            pw.println(this.mReadExternalStorageEnforced);
        }
    }

    void dumpSharedUsersLPr(PrintWriter pw, String packageName, ArraySet<String> permissionNames, PackageManagerService.DumpState dumpState, boolean checkin) {
        boolean printedSomething = false;
        for (SharedUserSetting su : this.mSharedUsers.values()) {
            if (packageName != null && su != dumpState.getSharedUser() || permissionNames != null && !su.getPermissionsState().hasRequestedPermission(permissionNames)) continue;
            if (!checkin) {
                if (!printedSomething) {
                    if (dumpState.onTitlePrinted()) {
                        pw.println();
                    }
                    pw.println("Shared users:");
                    printedSomething = true;
                }
                pw.print("  SharedUser [");
                pw.print(su.name);
                pw.print("] (");
                pw.print(Integer.toHexString(System.identityHashCode(su)));
                pw.println("):");
                String prefix = "    ";
                pw.print(prefix);
                pw.print("userId=");
                pw.println(su.userId);
                PermissionsState permissionsState = su.getPermissionsState();
                this.dumpInstallPermissionsLPr(pw, prefix, permissionNames, permissionsState);
                for (int userId : UserManagerService.getInstance().getUserIds()) {
                    int[] gids = permissionsState.computeGids(userId);
                    List<PermissionsState.PermissionState> permissions = permissionsState.getRuntimePermissionStates(userId);
                    if (ArrayUtils.isEmpty(gids) && permissions.isEmpty()) continue;
                    pw.print(prefix);
                    pw.print("User ");
                    pw.print(userId);
                    pw.println(": ");
                    this.dumpGidsLPr(pw, prefix + "  ", gids);
                    this.dumpRuntimePermissionsLPr(pw, prefix + "  ", permissionNames, permissions, packageName != null);
                }
                continue;
            }
            pw.print("suid,");
            pw.print(su.userId);
            pw.print(",");
            pw.println(su.name);
        }
    }

    void dumpReadMessagesLPr(PrintWriter pw, PackageManagerService.DumpState dumpState) {
        pw.println("Settings parse messages:");
        pw.print(this.mReadMessages.toString());
    }

    void dumpRestoredPermissionGrantsLPr(PrintWriter pw, PackageManagerService.DumpState dumpState) {
        if (this.mRestoredUserGrants.size() > 0) {
            pw.println();
            pw.println("Restored (pending) permission grants:");
            for (int userIndex = 0; userIndex < this.mRestoredUserGrants.size(); ++userIndex) {
                ArrayMap<String, ArraySet<RestoredPermissionGrant>> grantsByPackage = this.mRestoredUserGrants.valueAt(userIndex);
                if (grantsByPackage == null || grantsByPackage.size() <= 0) continue;
                int userId = this.mRestoredUserGrants.keyAt(userIndex);
                pw.print("  User ");
                pw.println(userId);
                for (int pkgIndex = 0; pkgIndex < grantsByPackage.size(); ++pkgIndex) {
                    ArraySet<RestoredPermissionGrant> grants = grantsByPackage.valueAt(pkgIndex);
                    if (grants == null || grants.size() <= 0) continue;
                    String pkgName = grantsByPackage.keyAt(pkgIndex);
                    pw.print("    ");
                    pw.print(pkgName);
                    pw.println(" :");
                    for (RestoredPermissionGrant g : grants) {
                        pw.print("      ");
                        pw.print(g.permissionName);
                        if (g.granted) {
                            pw.print(" GRANTED");
                        }
                        if ((g.grantBits & 1) != 0) {
                            pw.print(" user_set");
                        }
                        if ((g.grantBits & 2) != 0) {
                            pw.print(" user_fixed");
                        }
                        if ((g.grantBits & 8) != 0) {
                            pw.print(" revoke_on_upgrade");
                        }
                        pw.println();
                    }
                }
            }
            pw.println();
        }
    }

    private static void dumpSplitNames(PrintWriter pw, PackageParser.Package pkg) {
        if (pkg == null) {
            pw.print("unknown");
        } else {
            pw.print("[");
            pw.print("base");
            if (pkg.baseRevisionCode != 0) {
                pw.print(":");
                pw.print(pkg.baseRevisionCode);
            }
            if (pkg.splitNames != null) {
                for (int i = 0; i < pkg.splitNames.length; ++i) {
                    pw.print(", ");
                    pw.print(pkg.splitNames[i]);
                    if (pkg.splitRevisionCodes[i] == 0) continue;
                    pw.print(":");
                    pw.print(pkg.splitRevisionCodes[i]);
                }
            }
            pw.print("]");
        }
    }

    void dumpGidsLPr(PrintWriter pw, String prefix, int[] gids) {
        if (!ArrayUtils.isEmpty(gids)) {
            pw.print(prefix);
            pw.print("gids=");
            pw.println(PackageManagerService.arrayToString(gids));
        }
    }

    void dumpRuntimePermissionsLPr(PrintWriter pw, String prefix, ArraySet<String> permissionNames, List<PermissionsState.PermissionState> permissionStates, boolean dumpAll) {
        if (!permissionStates.isEmpty() || dumpAll) {
            pw.print(prefix);
            pw.println("runtime permissions:");
            for (PermissionsState.PermissionState permissionState : permissionStates) {
                if (permissionNames != null && !permissionNames.contains(permissionState.getName())) continue;
                pw.print(prefix);
                pw.print("  ");
                pw.print(permissionState.getName());
                pw.print(": granted=");
                pw.print(permissionState.isGranted());
                pw.println(Settings.permissionFlagsToString(", flags=", permissionState.getFlags()));
            }
        }
    }

    private static String permissionFlagsToString(String prefix, int flags) {
        StringBuilder flagsString = null;
        while (flags != 0) {
            if (flagsString == null) {
                flagsString = new StringBuilder();
                flagsString.append(prefix);
                flagsString.append("[ ");
            }
            int flag = 1 << Integer.numberOfTrailingZeros(flags);
            flags &= ~flag;
            flagsString.append(PackageManager.permissionFlagToString(flag));
            flagsString.append(' ');
        }
        if (flagsString != null) {
            flagsString.append(']');
            return flagsString.toString();
        }
        return "";
    }

    void dumpInstallPermissionsLPr(PrintWriter pw, String prefix, ArraySet<String> permissionNames, PermissionsState permissionsState) {
        List<PermissionsState.PermissionState> permissionStates = permissionsState.getInstallPermissionStates();
        if (!permissionStates.isEmpty()) {
            pw.print(prefix);
            pw.println("install permissions:");
            for (PermissionsState.PermissionState permissionState : permissionStates) {
                if (permissionNames != null && !permissionNames.contains(permissionState.getName())) continue;
                pw.print(prefix);
                pw.print("  ");
                pw.print(permissionState.getName());
                pw.print(": granted=");
                pw.print(permissionState.isGranted());
                pw.println(Settings.permissionFlagsToString(", flags=", permissionState.getFlags()));
            }
        }
    }

    public void writeRuntimePermissionsForUserLPr(int userId, boolean sync) {
        if (sync) {
            this.mRuntimePermissionsPersistence.writePermissionsForUserSyncLPr(userId);
        } else {
            this.mRuntimePermissionsPersistence.writePermissionsForUserAsyncLPr(userId);
        }
    }

    private final class RuntimePermissionPersistence {
        private static final long WRITE_PERMISSIONS_DELAY_MILLIS = 200L;
        private static final long MAX_WRITE_PERMISSIONS_DELAY_MILLIS = 2000L;
        private final Handler mHandler = new MyHandler();
        private final Object mLock;
        @GuardedBy(value="mLock")
        private final SparseBooleanArray mWriteScheduled = new SparseBooleanArray();
        @GuardedBy(value="mLock")
        private final SparseLongArray mLastNotWrittenMutationTimesMillis = new SparseLongArray();
        @GuardedBy(value="mLock")
        private final SparseArray<String> mFingerprints = new SparseArray();
        @GuardedBy(value="mLock")
        private final SparseBooleanArray mDefaultPermissionsGranted = new SparseBooleanArray();

        public RuntimePermissionPersistence(Object lock) {
            this.mLock = lock;
        }

        public boolean areDefaultRuntimPermissionsGrantedLPr(int userId) {
            return this.mDefaultPermissionsGranted.get(userId);
        }

        public void onDefaultRuntimePermissionsGrantedLPr(int userId) {
            this.mFingerprints.put(userId, Build.FINGERPRINT);
            this.writePermissionsForUserAsyncLPr(userId);
        }

        public void writePermissionsForUserSyncLPr(int userId) {
            this.mHandler.removeMessages(userId);
            this.writePermissionsSync(userId);
        }

        public void writePermissionsForUserAsyncLPr(int userId) {
            long currentTimeMillis = SystemClock.uptimeMillis();
            if (this.mWriteScheduled.get(userId)) {
                this.mHandler.removeMessages(userId);
                long lastNotWrittenMutationTimeMillis = this.mLastNotWrittenMutationTimesMillis.get(userId);
                long timeSinceLastNotWrittenMutationMillis = currentTimeMillis - lastNotWrittenMutationTimeMillis;
                if (timeSinceLastNotWrittenMutationMillis >= 2000L) {
                    this.mHandler.obtainMessage(userId).sendToTarget();
                    return;
                }
                long maxDelayMillis = Math.max(lastNotWrittenMutationTimeMillis + 2000L - currentTimeMillis, 0L);
                long writeDelayMillis = Math.min(200L, maxDelayMillis);
                Message message = this.mHandler.obtainMessage(userId);
                this.mHandler.sendMessageDelayed(message, writeDelayMillis);
            } else {
                this.mLastNotWrittenMutationTimesMillis.put(userId, currentTimeMillis);
                Message message = this.mHandler.obtainMessage(userId);
                this.mHandler.sendMessageDelayed(message, 200L);
                this.mWriteScheduled.put(userId, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writePermissionsSync(int userId) {
            AtomicFile destination = new AtomicFile(Settings.this.getUserRuntimePermissionsFile(userId));
            ArrayMap<String, List<PermissionsState.PermissionState>> permissionsForPackage = new ArrayMap<String, List<PermissionsState.PermissionState>>();
            ArrayMap<String, List<PermissionsState.PermissionState>> permissionsForSharedUser = new ArrayMap<String, List<PermissionsState.PermissionState>>();
            Object object = this.mLock;
            synchronized (object) {
                this.mWriteScheduled.delete(userId);
                int packageCount = Settings.this.mPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    PermissionsState permissionsState;
                    List<PermissionsState.PermissionState> permissionsStates;
                    String packageName = Settings.this.mPackages.keyAt(i);
                    PackageSetting packageSetting = Settings.this.mPackages.valueAt(i);
                    if (packageSetting.sharedUser != null || (permissionsStates = (permissionsState = packageSetting.getPermissionsState()).getRuntimePermissionStates(userId)).isEmpty()) continue;
                    permissionsForPackage.put(packageName, permissionsStates);
                }
                int sharedUserCount = Settings.this.mSharedUsers.size();
                for (int i = 0; i < sharedUserCount; ++i) {
                    String sharedUserName = Settings.this.mSharedUsers.keyAt(i);
                    SharedUserSetting sharedUser = Settings.this.mSharedUsers.valueAt(i);
                    PermissionsState permissionsState = sharedUser.getPermissionsState();
                    List<PermissionsState.PermissionState> permissionsStates = permissionsState.getRuntimePermissionStates(userId);
                    if (permissionsStates.isEmpty()) continue;
                    permissionsForSharedUser.put(sharedUserName, permissionsStates);
                }
            }
            FileOutputStream out = null;
            try {
                ArrayMap restoredGrants;
                out = destination.startWrite();
                XmlSerializer serializer = Xml.newSerializer();
                serializer.setOutput(out, StandardCharsets.UTF_8.name());
                serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
                serializer.startDocument(null, true);
                serializer.startTag(null, Settings.TAG_RUNTIME_PERMISSIONS);
                String fingerprint = this.mFingerprints.get(userId);
                if (fingerprint != null) {
                    serializer.attribute(null, Settings.ATTR_FINGERPRINT, fingerprint);
                }
                int packageCount = permissionsForPackage.size();
                for (int i = 0; i < packageCount; ++i) {
                    String packageName = (String)permissionsForPackage.keyAt(i);
                    List permissionStates = (List)permissionsForPackage.valueAt(i);
                    serializer.startTag(null, Settings.TAG_PACKAGE);
                    serializer.attribute(null, Settings.ATTR_NAME, packageName);
                    this.writePermissions(serializer, permissionStates);
                    serializer.endTag(null, Settings.TAG_PACKAGE);
                }
                int sharedUserCount = permissionsForSharedUser.size();
                for (int i = 0; i < sharedUserCount; ++i) {
                    String packageName = (String)permissionsForSharedUser.keyAt(i);
                    List permissionStates = (List)permissionsForSharedUser.valueAt(i);
                    serializer.startTag(null, Settings.TAG_SHARED_USER);
                    serializer.attribute(null, Settings.ATTR_NAME, packageName);
                    this.writePermissions(serializer, permissionStates);
                    serializer.endTag(null, Settings.TAG_SHARED_USER);
                }
                serializer.endTag(null, Settings.TAG_RUNTIME_PERMISSIONS);
                if (Settings.this.mRestoredUserGrants.get(userId) != null && (restoredGrants = (ArrayMap)Settings.this.mRestoredUserGrants.get(userId)) != null) {
                    int pkgCount = restoredGrants.size();
                    for (int i = 0; i < pkgCount; ++i) {
                        ArraySet pkgGrants = (ArraySet)restoredGrants.valueAt(i);
                        if (pkgGrants == null || pkgGrants.size() <= 0) continue;
                        String pkgName = (String)restoredGrants.keyAt(i);
                        serializer.startTag(null, Settings.TAG_RESTORED_RUNTIME_PERMISSIONS);
                        serializer.attribute(null, Settings.ATTR_PACKAGE_NAME, pkgName);
                        int N = pkgGrants.size();
                        for (int z = 0; z < N; ++z) {
                            RestoredPermissionGrant g = (RestoredPermissionGrant)pkgGrants.valueAt(z);
                            serializer.startTag(null, Settings.TAG_PERMISSION_ENTRY);
                            serializer.attribute(null, Settings.ATTR_NAME, g.permissionName);
                            if (g.granted) {
                                serializer.attribute(null, Settings.ATTR_GRANTED, "true");
                            }
                            if ((g.grantBits & 1) != 0) {
                                serializer.attribute(null, Settings.ATTR_USER_SET, "true");
                            }
                            if ((g.grantBits & 2) != 0) {
                                serializer.attribute(null, Settings.ATTR_USER_FIXED, "true");
                            }
                            if ((g.grantBits & 8) != 0) {
                                serializer.attribute(null, Settings.ATTR_REVOKE_ON_UPGRADE, "true");
                            }
                            serializer.endTag(null, Settings.TAG_PERMISSION_ENTRY);
                        }
                        serializer.endTag(null, Settings.TAG_RESTORED_RUNTIME_PERMISSIONS);
                    }
                }
                serializer.endDocument();
                destination.finishWrite(out);
                if (Build.FINGERPRINT.equals(fingerprint)) {
                    this.mDefaultPermissionsGranted.put(userId, true);
                }
            }
            catch (Throwable t) {
                Slog.wtf("PackageManager", "Failed to write settings, restoring backup", t);
                destination.failWrite(out);
            }
            finally {
                IoUtils.closeQuietly(out);
            }
        }

        private void onUserRemovedLPw(int userId) {
            this.mHandler.removeMessages(userId);
            for (SettingBase settingBase : Settings.this.mPackages.values()) {
                this.revokeRuntimePermissionsAndClearFlags(settingBase, userId);
            }
            for (SettingBase settingBase : Settings.this.mSharedUsers.values()) {
                this.revokeRuntimePermissionsAndClearFlags(settingBase, userId);
            }
            this.mDefaultPermissionsGranted.delete(userId);
            this.mFingerprints.remove(userId);
        }

        private void revokeRuntimePermissionsAndClearFlags(SettingBase sb, int userId) {
            PermissionsState permissionsState = sb.getPermissionsState();
            for (PermissionsState.PermissionState permissionState : permissionsState.getRuntimePermissionStates(userId)) {
                BasePermission bp = Settings.this.mPermissions.get(permissionState.getName());
                if (bp == null) continue;
                permissionsState.revokeRuntimePermission(bp, userId);
                permissionsState.updatePermissionFlags(bp, userId, 255, 0);
            }
        }

        public void deleteUserRuntimePermissionsFile(int userId) {
            Settings.this.getUserRuntimePermissionsFile(userId).delete();
        }

        public void readStateForUserSyncLPr(int userId) {
            FileInputStream in;
            File permissionsFile = Settings.this.getUserRuntimePermissionsFile(userId);
            if (!permissionsFile.exists()) {
                return;
            }
            try {
                in = new AtomicFile(permissionsFile).openRead();
            }
            catch (FileNotFoundException fnfe) {
                Slog.i("PackageManager", "No permissions state");
                return;
            }
            try {
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput(in, null);
                this.parseRuntimePermissionsLPr(parser, userId);
            }
            catch (IOException | XmlPullParserException e) {
                throw new IllegalStateException("Failed parsing permissions file: " + permissionsFile, e);
            }
            finally {
                IoUtils.closeQuietly(in);
            }
        }

        public void rememberRestoredUserGrantLPr(String pkgName, String permission2, boolean isGranted, int restoredFlagSet, int userId) {
            ArraySet<RestoredPermissionGrant> grants;
            ArrayMap grantsByPackage = (ArrayMap)Settings.this.mRestoredUserGrants.get(userId);
            if (grantsByPackage == null) {
                grantsByPackage = new ArrayMap();
                Settings.this.mRestoredUserGrants.put(userId, grantsByPackage);
            }
            if ((grants = (ArraySet<RestoredPermissionGrant>)grantsByPackage.get(pkgName)) == null) {
                grants = new ArraySet<RestoredPermissionGrant>();
                grantsByPackage.put(pkgName, grants);
            }
            RestoredPermissionGrant grant = new RestoredPermissionGrant(permission2, isGranted, restoredFlagSet);
            grants.add(grant);
        }

        private void parseRuntimePermissionsLPr(XmlPullParser parser, int userId) throws IOException, XmlPullParserException {
            int type;
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                switch (parser.getName()) {
                    case "runtime-permissions": {
                        String fingerprint = parser.getAttributeValue(null, Settings.ATTR_FINGERPRINT);
                        this.mFingerprints.put(userId, fingerprint);
                        boolean defaultsGranted = Build.FINGERPRINT.equals(fingerprint);
                        this.mDefaultPermissionsGranted.put(userId, defaultsGranted);
                        break;
                    }
                    case "pkg": {
                        String name = parser.getAttributeValue(null, Settings.ATTR_NAME);
                        PackageSetting ps = Settings.this.mPackages.get(name);
                        if (ps == null) {
                            Slog.w("PackageManager", "Unknown package:" + name);
                            XmlUtils.skipCurrentTag(parser);
                            break;
                        }
                        this.parsePermissionsLPr(parser, ps.getPermissionsState(), userId);
                        break;
                    }
                    case "shared-user": {
                        String name = parser.getAttributeValue(null, Settings.ATTR_NAME);
                        SharedUserSetting sus = Settings.this.mSharedUsers.get(name);
                        if (sus == null) {
                            Slog.w("PackageManager", "Unknown shared user:" + name);
                            XmlUtils.skipCurrentTag(parser);
                            break;
                        }
                        this.parsePermissionsLPr(parser, sus.getPermissionsState(), userId);
                        break;
                    }
                    case "restored-perms": {
                        String pkgName = parser.getAttributeValue(null, Settings.ATTR_PACKAGE_NAME);
                        this.parseRestoredRuntimePermissionsLPr(parser, pkgName, userId);
                    }
                }
            }
        }

        private void parseRestoredRuntimePermissionsLPr(XmlPullParser parser, String pkgName, int userId) throws IOException, XmlPullParserException {
            int type;
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                switch (parser.getName()) {
                    case "perm": {
                        String permName = parser.getAttributeValue(null, Settings.ATTR_NAME);
                        boolean isGranted = "true".equals(parser.getAttributeValue(null, Settings.ATTR_GRANTED));
                        int permBits = 0;
                        if ("true".equals(parser.getAttributeValue(null, Settings.ATTR_USER_SET))) {
                            permBits |= 1;
                        }
                        if ("true".equals(parser.getAttributeValue(null, Settings.ATTR_USER_FIXED))) {
                            permBits |= 2;
                        }
                        if ("true".equals(parser.getAttributeValue(null, Settings.ATTR_REVOKE_ON_UPGRADE))) {
                            permBits |= 8;
                        }
                        if (!isGranted && permBits == 0) break;
                        this.rememberRestoredUserGrantLPr(pkgName, permName, isGranted, permBits, userId);
                    }
                }
            }
        }

        private void parsePermissionsLPr(XmlPullParser parser, PermissionsState permissionsState, int userId) throws IOException, XmlPullParserException {
            int type;
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                switch (parser.getName()) {
                    case "item": {
                        int flags;
                        String name = parser.getAttributeValue(null, Settings.ATTR_NAME);
                        BasePermission bp = Settings.this.mPermissions.get(name);
                        if (bp == null) {
                            Slog.w("PackageManager", "Unknown permission:" + name);
                            XmlUtils.skipCurrentTag(parser);
                            break;
                        }
                        String grantedStr = parser.getAttributeValue(null, Settings.ATTR_GRANTED);
                        boolean granted = grantedStr == null || Boolean.parseBoolean(grantedStr);
                        String flagsStr = parser.getAttributeValue(null, Settings.ATTR_FLAGS);
                        int n = flags = flagsStr != null ? Integer.parseInt(flagsStr, 16) : 0;
                        if (granted) {
                            permissionsState.grantRuntimePermission(bp, userId);
                            permissionsState.updatePermissionFlags(bp, userId, 255, flags);
                            break;
                        }
                        permissionsState.updatePermissionFlags(bp, userId, 255, flags);
                    }
                }
            }
        }

        private void writePermissions(XmlSerializer serializer, List<PermissionsState.PermissionState> permissionStates) throws IOException {
            for (PermissionsState.PermissionState permissionState : permissionStates) {
                serializer.startTag(null, Settings.TAG_ITEM);
                serializer.attribute(null, Settings.ATTR_NAME, permissionState.getName());
                serializer.attribute(null, Settings.ATTR_GRANTED, String.valueOf(permissionState.isGranted()));
                serializer.attribute(null, Settings.ATTR_FLAGS, Integer.toHexString(permissionState.getFlags()));
                serializer.endTag(null, Settings.TAG_ITEM);
            }
        }

        private final class MyHandler
        extends Handler {
            public MyHandler() {
                super(BackgroundThread.getHandler().getLooper());
            }

            @Override
            public void handleMessage(Message message) {
                int userId = message.what;
                Runnable callback = (Runnable)message.obj;
                RuntimePermissionPersistence.this.writePermissionsSync(userId);
                if (callback != null) {
                    callback.run();
                }
            }
        }
    }

    public static class VersionInfo {
        int sdkVersion;
        int databaseVersion;
        String fingerprint;

        public void forceCurrent() {
            this.sdkVersion = Build.VERSION.SDK_INT;
            this.databaseVersion = 3;
            this.fingerprint = Build.FINGERPRINT;
        }
    }

    final class RestoredPermissionGrant {
        String permissionName;
        boolean granted;
        int grantBits;

        RestoredPermissionGrant(String name, boolean isGranted, int theGrantBits) {
            this.permissionName = name;
            this.granted = isGranted;
            this.grantBits = theGrantBits;
        }
    }

    public static class DatabaseVersion {
        public static final int FIRST_VERSION = 1;
        public static final int SIGNATURE_END_ENTITY = 2;
        public static final int SIGNATURE_MALFORMED_RECOVER = 3;
    }
}

