/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.ActivityManagerNative;
import android.app.AppGlobals;
import android.app.IActivityManager;
import android.app.IStopUserCallback;
import android.app.KeyguardManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IBinder;
import android.os.IUserManager;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.SELinux;
import android.os.ServiceManager;
import android.os.ShellCommand;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.UserManagerInternal;
import android.os.storage.StorageManager;
import android.provider.Settings;
import android.security.GateKeeper;
import android.service.gatekeeper.IGateKeeperService;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.text.TextUtils;
import android.util.AtomicFile;
import android.util.IntArray;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.TimeUtils;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.IAppOpsService;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.Preconditions;
import com.android.internal.util.XmlUtils;
import com.android.internal.widget.LockPatternUtils;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.pm.PackageManagerService;
import com.android.server.pm.UserRestrictionsUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import libcore.io.IoUtils;
import libcore.util.Objects;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class UserManagerService
extends IUserManager.Stub {
    private static final String LOG_TAG = "UserManagerService";
    static final boolean DBG = false;
    private static final boolean DBG_WITH_STACKTRACE = false;
    private static final String TAG_NAME = "name";
    private static final String TAG_ACCOUNT = "account";
    private static final String ATTR_FLAGS = "flags";
    private static final String ATTR_ICON_PATH = "icon";
    private static final String ATTR_ID = "id";
    private static final String ATTR_CREATION_TIME = "created";
    private static final String ATTR_LAST_LOGGED_IN_TIME = "lastLoggedIn";
    private static final String ATTR_LAST_LOGGED_IN_FINGERPRINT = "lastLoggedInFingerprint";
    private static final String ATTR_SERIAL_NO = "serialNumber";
    private static final String ATTR_NEXT_SERIAL_NO = "nextSerialNumber";
    private static final String ATTR_PARTIAL = "partial";
    private static final String ATTR_GUEST_TO_REMOVE = "guestToRemove";
    private static final String ATTR_USER_VERSION = "version";
    private static final String ATTR_PROFILE_GROUP_ID = "profileGroupId";
    private static final String ATTR_RESTRICTED_PROFILE_PARENT_ID = "restrictedProfileParentId";
    private static final String ATTR_SEED_ACCOUNT_NAME = "seedAccountName";
    private static final String ATTR_SEED_ACCOUNT_TYPE = "seedAccountType";
    private static final String TAG_GUEST_RESTRICTIONS = "guestRestrictions";
    private static final String TAG_USERS = "users";
    private static final String TAG_USER = "user";
    private static final String TAG_RESTRICTIONS = "restrictions";
    private static final String TAG_DEVICE_POLICY_RESTRICTIONS = "device_policy_restrictions";
    private static final String TAG_GLOBAL_RESTRICTION_OWNER_ID = "globalRestrictionOwnerUserId";
    private static final String TAG_ENTRY = "entry";
    private static final String TAG_VALUE = "value";
    private static final String TAG_SEED_ACCOUNT_OPTIONS = "seedAccountOptions";
    private static final String ATTR_KEY = "key";
    private static final String ATTR_VALUE_TYPE = "type";
    private static final String ATTR_MULTIPLE = "m";
    private static final String ATTR_TYPE_STRING_ARRAY = "sa";
    private static final String ATTR_TYPE_STRING = "s";
    private static final String ATTR_TYPE_BOOLEAN = "b";
    private static final String ATTR_TYPE_INTEGER = "i";
    private static final String ATTR_TYPE_BUNDLE = "B";
    private static final String ATTR_TYPE_BUNDLE_ARRAY = "BA";
    private static final String USER_INFO_DIR = "system" + File.separator + "users";
    private static final String USER_LIST_FILENAME = "userlist.xml";
    private static final String USER_PHOTO_FILENAME = "photo.png";
    private static final String USER_PHOTO_FILENAME_TMP = "photo.png.tmp";
    private static final String RESTRICTIONS_FILE_PREFIX = "res_";
    private static final String XML_SUFFIX = ".xml";
    private static final int ALLOWED_FLAGS_FOR_CREATE_USERS_PERMISSION = 300;
    private static final int MIN_USER_ID = 10;
    private static final int MAX_USER_ID = 21474;
    private static final int USER_VERSION = 6;
    private static final long EPOCH_PLUS_30_YEARS = 946080000000L;
    private static final int MAX_MANAGED_PROFILES = 1;
    static final int WRITE_USER_MSG = 1;
    static final int WRITE_USER_DELAY = 2000;
    private static final String XATTR_SERIAL = "user.serial";
    private static final String TRON_GUEST_CREATED = "users_guest_created";
    private static final String TRON_USER_CREATED = "users_user_created";
    private final Context mContext;
    private final PackageManagerService mPm;
    private final Object mPackagesLock;
    private final Object mUsersLock = new Object();
    private final Object mRestrictionsLock = new Object();
    private final Handler mHandler;
    private final File mUsersDir;
    private final File mUserListFile;
    private static final IBinder mUserRestriconToken = new Binder();
    @GuardedBy(value="mUsersLock")
    private final SparseArray<UserData> mUsers = new SparseArray();
    @GuardedBy(value="mRestrictionsLock")
    private final SparseArray<Bundle> mBaseUserRestrictions = new SparseArray();
    @GuardedBy(value="mRestrictionsLock")
    private final SparseArray<Bundle> mCachedEffectiveUserRestrictions = new SparseArray();
    @GuardedBy(value="mRestrictionsLock")
    private final SparseArray<Bundle> mAppliedUserRestrictions = new SparseArray();
    @GuardedBy(value="mRestrictionsLock")
    private Bundle mDevicePolicyGlobalUserRestrictions;
    @GuardedBy(value="mRestrictionsLock")
    private int mGlobalRestrictionOwnerUserId = -10000;
    @GuardedBy(value="mRestrictionsLock")
    private final SparseArray<Bundle> mDevicePolicyLocalUserRestrictions = new SparseArray();
    @GuardedBy(value="mGuestRestrictions")
    private final Bundle mGuestRestrictions = new Bundle();
    @GuardedBy(value="mUsersLock")
    private final SparseBooleanArray mRemovingUserIds = new SparseBooleanArray();
    @GuardedBy(value="mUsersLock")
    private int[] mUserIds;
    @GuardedBy(value="mPackagesLock")
    private int mNextSerialNumber;
    private int mUserVersion = 0;
    private IAppOpsService mAppOpsService;
    private final LocalService mLocalService;
    @GuardedBy(value="mUsersLock")
    private boolean mIsDeviceManaged;
    @GuardedBy(value="mUsersLock")
    private final SparseBooleanArray mIsUserManaged = new SparseBooleanArray();
    @GuardedBy(value="mUserRestrictionsListeners")
    private final ArrayList<UserManagerInternal.UserRestrictionsListener> mUserRestrictionsListeners = new ArrayList();
    private final LockPatternUtils mLockPatternUtils;
    private final String ACTION_DISABLE_QUIET_MODE_AFTER_UNLOCK = "com.android.server.pm.DISABLE_QUIET_MODE_AFTER_UNLOCK";
    private final BroadcastReceiver mDisableQuietModeCallback = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if ("com.android.server.pm.DISABLE_QUIET_MODE_AFTER_UNLOCK".equals(intent.getAction())) {
                IntentSender target = (IntentSender)intent.getParcelableExtra("android.intent.extra.INTENT");
                int userHandle = intent.getIntExtra("android.intent.extra.USER_ID", 0);
                UserManagerService.this.setQuietModeEnabled(userHandle, false);
                if (target != null) {
                    try {
                        UserManagerService.this.mContext.startIntentSender(target, null, 0, 0, 0);
                    }
                    catch (IntentSender.SendIntentException sendIntentException) {
                        // empty catch block
                    }
                }
            }
        }
    };
    @GuardedBy(value="mUsersLock")
    private boolean mForceEphemeralUsers;
    @GuardedBy(value="mUserStates")
    private final SparseIntArray mUserStates = new SparseIntArray();
    private static UserManagerService sInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserManagerService getInstance() {
        Class<UserManagerService> clazz = UserManagerService.class;
        synchronized (UserManagerService.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    UserManagerService(File dataDir) {
        this(null, null, new Object(), dataDir);
    }

    UserManagerService(Context context, PackageManagerService pm, Object packagesLock) {
        this(context, pm, packagesLock, Environment.getDataDirectory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserManagerService(Context context, PackageManagerService pm, Object packagesLock, File dataDir) {
        this.mContext = context;
        this.mPm = pm;
        this.mPackagesLock = packagesLock;
        this.mHandler = new MainHandler();
        Object object = this.mPackagesLock;
        synchronized (object) {
            this.mUsersDir = new File(dataDir, USER_INFO_DIR);
            this.mUsersDir.mkdirs();
            File userZeroDir = new File(this.mUsersDir, String.valueOf(0));
            userZeroDir.mkdirs();
            FileUtils.setPermissions(this.mUsersDir.toString(), 509, -1, -1);
            this.mUserListFile = new File(this.mUsersDir, USER_LIST_FILENAME);
            this.initDefaultGuestRestrictions();
            this.readUserListLP();
            sInstance = this;
        }
        this.mLocalService = new LocalService();
        LocalServices.addService(UserManagerInternal.class, this.mLocalService);
        this.mLockPatternUtils = new LockPatternUtils(this.mContext);
        this.mUserStates.put(0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void systemReady() {
        this.mAppOpsService = IAppOpsService.Stub.asInterface(ServiceManager.getService("appops"));
        Object object = this.mRestrictionsLock;
        synchronized (object) {
            this.applyUserRestrictionsLR(0);
        }
        UserInfo currentGuestUser = this.findCurrentGuestUser();
        if (currentGuestUser != null && !this.hasUserRestriction("no_config_wifi", currentGuestUser.id)) {
            this.setUserRestriction("no_config_wifi", true, currentGuestUser.id);
        }
        this.mContext.registerReceiver(this.mDisableQuietModeCallback, new IntentFilter("com.android.server.pm.DISABLE_QUIET_MODE_AFTER_UNLOCK"), null, this.mHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupPartialUsers() {
        ArrayList<UserInfo> partials = new ArrayList<UserInfo>();
        Object object = this.mUsersLock;
        synchronized (object) {
            int userSize = this.mUsers.size();
            for (int i = 0; i < userSize; ++i) {
                UserInfo ui = this.mUsers.valueAt((int)i).info;
                if (!ui.partial && !ui.guestToRemove && !ui.isEphemeral() || i == 0) continue;
                partials.add(ui);
                this.mRemovingUserIds.append(ui.id, true);
                ui.partial = true;
            }
        }
        int partialsSize = partials.size();
        for (int i = 0; i < partialsSize; ++i) {
            UserInfo ui = (UserInfo)partials.get(i);
            Slog.w(LOG_TAG, "Removing partially created user " + ui.id + " (name=" + ui.name + ")");
            this.removeUserState(ui.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUserAccount(int userId) {
        UserManagerService.checkManageUserAndAcrossUsersFullPermission("get user account");
        Object object = this.mUsersLock;
        synchronized (object) {
            return this.mUsers.get((int)userId).account;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserAccount(int userId, String accountName) {
        UserManagerService.checkManageUserAndAcrossUsersFullPermission("set user account");
        UserData userToUpdate = null;
        Object object = this.mPackagesLock;
        synchronized (object) {
            Object object2 = this.mUsersLock;
            synchronized (object2) {
                UserData userData = this.mUsers.get(userId);
                if (userData == null) {
                    Slog.e(LOG_TAG, "User not found for setting user account: u" + userId);
                    return;
                }
                String currentAccount = userData.account;
                if (!Objects.equal(currentAccount, accountName)) {
                    userData.account = accountName;
                    userToUpdate = userData;
                }
            }
            if (userToUpdate != null) {
                this.writeUserLP(userToUpdate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserInfo getPrimaryUser() {
        UserManagerService.checkManageUsersPermission("query users");
        Object object = this.mUsersLock;
        synchronized (object) {
            int userSize = this.mUsers.size();
            for (int i = 0; i < userSize; ++i) {
                UserInfo ui = this.mUsers.valueAt((int)i).info;
                if (!ui.isPrimary() || this.mRemovingUserIds.get(ui.id)) continue;
                return ui;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UserInfo> getUsers(boolean excludeDying) {
        UserManagerService.checkManageOrCreateUsersPermission("query users");
        Object object = this.mUsersLock;
        synchronized (object) {
            ArrayList<UserInfo> users = new ArrayList<UserInfo>(this.mUsers.size());
            int userSize = this.mUsers.size();
            for (int i = 0; i < userSize; ++i) {
                UserInfo ui = this.mUsers.valueAt((int)i).info;
                if (ui.partial || excludeDying && this.mRemovingUserIds.get(ui.id)) continue;
                users.add(this.userWithName(ui));
            }
            return users;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UserInfo> getProfiles(int userId, boolean enabledOnly) {
        boolean returnFullInfo = true;
        if (userId != UserHandle.getCallingUserId()) {
            UserManagerService.checkManageOrCreateUsersPermission("getting profiles related to user " + userId);
        } else {
            returnFullInfo = UserManagerService.hasManageUsersPermission();
        }
        long ident = Binder.clearCallingIdentity();
        try {
            Object object = this.mUsersLock;
            synchronized (object) {
                List<UserInfo> list = this.getProfilesLU(userId, enabledOnly, returnFullInfo);
                return list;
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getProfileIds(int userId, boolean enabledOnly) {
        if (userId != UserHandle.getCallingUserId()) {
            UserManagerService.checkManageUsersPermission("getting profiles related to user " + userId);
        }
        long ident = Binder.clearCallingIdentity();
        try {
            Object object = this.mUsersLock;
            synchronized (object) {
                int[] nArray = this.getProfileIdsLU(userId, enabledOnly).toArray();
                return nArray;
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private List<UserInfo> getProfilesLU(int userId, boolean enabledOnly, boolean fullInfo) {
        IntArray profileIds = this.getProfileIdsLU(userId, enabledOnly);
        ArrayList<UserInfo> users = new ArrayList<UserInfo>(profileIds.size());
        for (int i = 0; i < profileIds.size(); ++i) {
            int profileId = profileIds.get(i);
            UserInfo userInfo = this.mUsers.get((int)profileId).info;
            if (!fullInfo) {
                userInfo = new UserInfo(userInfo);
                userInfo.name = null;
                userInfo.iconPath = null;
            } else {
                userInfo = this.userWithName(userInfo);
            }
            users.add(userInfo);
        }
        return users;
    }

    private IntArray getProfileIdsLU(int userId, boolean enabledOnly) {
        UserInfo user = this.getUserInfoLU(userId);
        IntArray result = new IntArray(this.mUsers.size());
        if (user == null) {
            return result;
        }
        int userSize = this.mUsers.size();
        for (int i = 0; i < userSize; ++i) {
            UserInfo profile = this.mUsers.valueAt((int)i).info;
            if (!UserManagerService.isProfileOf(user, profile) || enabledOnly && !profile.isEnabled() || this.mRemovingUserIds.get(profile.id) || profile.partial) continue;
            result.add(profile.id);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCredentialOwnerProfile(int userHandle) {
        UserManagerService.checkManageUsersPermission("get the credential owner");
        if (!this.mLockPatternUtils.isSeparateProfileChallengeEnabled(userHandle)) {
            Object object = this.mUsersLock;
            synchronized (object) {
                UserInfo profileParent = this.getProfileParentLU(userHandle);
                if (profileParent != null) {
                    return profileParent.id;
                }
            }
        }
        return userHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSameProfileGroup(int userId, int otherUserId) {
        if (userId == otherUserId) {
            return true;
        }
        UserManagerService.checkManageUsersPermission("check if in the same profile group");
        Object object = this.mPackagesLock;
        synchronized (object) {
            return this.isSameProfileGroupLP(userId, otherUserId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSameProfileGroupLP(int userId, int otherUserId) {
        Object object = this.mUsersLock;
        synchronized (object) {
            UserInfo userInfo = this.getUserInfoLU(userId);
            if (userInfo == null || userInfo.profileGroupId == -10000) {
                return false;
            }
            UserInfo otherUserInfo = this.getUserInfoLU(otherUserId);
            if (otherUserInfo == null || otherUserInfo.profileGroupId == -10000) {
                return false;
            }
            return userInfo.profileGroupId == otherUserInfo.profileGroupId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserInfo getProfileParent(int userHandle) {
        UserManagerService.checkManageUsersPermission("get the profile parent");
        Object object = this.mUsersLock;
        synchronized (object) {
            return this.getProfileParentLU(userHandle);
        }
    }

    private UserInfo getProfileParentLU(int userHandle) {
        UserInfo profile = this.getUserInfoLU(userHandle);
        if (profile == null) {
            return null;
        }
        int parentUserId = profile.profileGroupId;
        if (parentUserId == -10000) {
            return null;
        }
        return this.getUserInfoLU(parentUserId);
    }

    private static boolean isProfileOf(UserInfo user, UserInfo profile) {
        return user.id == profile.id || user.profileGroupId != -10000 && user.profileGroupId == profile.profileGroupId;
    }

    private void broadcastProfileAvailabilityChanges(UserHandle profileHandle, UserHandle parentHandle, boolean inQuietMode) {
        Intent intent = new Intent();
        if (inQuietMode) {
            intent.setAction("android.intent.action.MANAGED_PROFILE_UNAVAILABLE");
        } else {
            intent.setAction("android.intent.action.MANAGED_PROFILE_AVAILABLE");
        }
        intent.putExtra("android.intent.extra.QUIET_MODE", inQuietMode);
        intent.putExtra("android.intent.extra.USER", profileHandle);
        intent.putExtra("android.intent.extra.user_handle", profileHandle.getIdentifier());
        intent.addFlags(0x40000000);
        this.mContext.sendBroadcastAsUser(intent, parentHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setQuietModeEnabled(int userHandle, boolean enableQuietMode) {
        UserInfo parent;
        UserInfo profile;
        UserManagerService.checkManageUsersPermission("silence profile");
        boolean changed = false;
        Object object = this.mPackagesLock;
        synchronized (object) {
            Object object2 = this.mUsersLock;
            synchronized (object2) {
                profile = this.getUserInfoLU(userHandle);
                parent = this.getProfileParentLU(userHandle);
            }
            if (profile == null || !profile.isManagedProfile()) {
                throw new IllegalArgumentException("User " + userHandle + " is not a profile");
            }
            if (profile.isQuietModeEnabled() != enableQuietMode) {
                profile.flags ^= 0x80;
                this.writeUserLP(this.getUserDataLU(profile.id));
                changed = true;
            }
        }
        if (changed) {
            long identity = Binder.clearCallingIdentity();
            try {
                if (enableQuietMode) {
                    ActivityManagerNative.getDefault().stopUser(userHandle, true, null);
                    LocalServices.getService(ActivityManagerInternal.class).killForegroundAppsForUser(userHandle);
                } else {
                    ActivityManagerNative.getDefault().startUserInBackground(userHandle);
                }
            }
            catch (RemoteException e) {
                Slog.e(LOG_TAG, "fail to start/stop user for quiet mode", e);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
            this.broadcastProfileAvailabilityChanges(profile.getUserHandle(), parent.getUserHandle(), enableQuietMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isQuietModeEnabled(int userHandle) {
        Object object = this.mPackagesLock;
        synchronized (object) {
            UserInfo info;
            Object object2 = this.mUsersLock;
            synchronized (object2) {
                info = this.getUserInfoLU(userHandle);
            }
            if (info == null || !info.isManagedProfile()) {
                return false;
            }
            return info.isQuietModeEnabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean trySetQuietModeDisabled(int userHandle, IntentSender target) {
        UserManagerService.checkManageUsersPermission("silence profile");
        if (StorageManager.isUserKeyUnlocked(userHandle) || !this.mLockPatternUtils.isSecure(userHandle)) {
            this.setQuietModeEnabled(userHandle, false);
            return true;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            KeyguardManager km = (KeyguardManager)this.mContext.getSystemService("keyguard");
            Intent unlockIntent = km.createConfirmDeviceCredentialIntent(null, null, userHandle);
            if (unlockIntent == null) {
                boolean bl = false;
                return bl;
            }
            Intent callBackIntent = new Intent("com.android.server.pm.DISABLE_QUIET_MODE_AFTER_UNLOCK");
            if (target != null) {
                callBackIntent.putExtra("android.intent.extra.INTENT", target);
            }
            callBackIntent.putExtra("android.intent.extra.USER_ID", userHandle);
            callBackIntent.setPackage(this.mContext.getPackageName());
            callBackIntent.addFlags(0x10000000);
            PendingIntent pendingIntent = PendingIntent.getBroadcast(this.mContext, 0, callBackIntent, 0x54000000);
            unlockIntent.putExtra("android.intent.extra.INTENT", pendingIntent.getIntentSender());
            unlockIntent.setFlags(0x10800000);
            this.mContext.startActivity(unlockIntent);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserEnabled(int userId) {
        UserManagerService.checkManageUsersPermission("enable user");
        Object object = this.mPackagesLock;
        synchronized (object) {
            UserInfo info;
            Object object2 = this.mUsersLock;
            synchronized (object2) {
                info = this.getUserInfoLU(userId);
            }
            if (info != null && !info.isEnabled()) {
                info.flags ^= 0x40;
                this.writeUserLP(this.getUserDataLU(info.id));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserInfo getUserInfo(int userId) {
        UserManagerService.checkManageOrCreateUsersPermission("query user");
        Object object = this.mUsersLock;
        synchronized (object) {
            return this.userWithName(this.getUserInfoLU(userId));
        }
    }

    private UserInfo userWithName(UserInfo orig) {
        if (orig != null && orig.name == null && orig.id == 0) {
            UserInfo withName = new UserInfo(orig);
            withName.name = this.getOwnerName();
            return withName;
        }
        return orig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isManagedProfile(int userId) {
        Object object;
        int callingUserId = UserHandle.getCallingUserId();
        if (callingUserId != userId && !UserManagerService.hasManageUsersPermission()) {
            object = this.mPackagesLock;
            synchronized (object) {
                if (!this.isSameProfileGroupLP(callingUserId, userId)) {
                    throw new SecurityException("You need MANAGE_USERS permission to: check if specified user a managed profile outside your profile group");
                }
            }
        }
        object = this.mUsersLock;
        synchronized (object) {
            UserInfo userInfo = this.getUserInfoLU(userId);
            return userInfo != null && userInfo.isManagedProfile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDemoUser(int userId) {
        int callingUserId = UserHandle.getCallingUserId();
        if (callingUserId != userId && !UserManagerService.hasManageUsersPermission()) {
            throw new SecurityException("You need MANAGE_USERS permission to query if u=" + userId + " is a demo user");
        }
        Object object = this.mUsersLock;
        synchronized (object) {
            UserInfo userInfo = this.getUserInfoLU(userId);
            return userInfo != null && userInfo.isDemo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRestricted() {
        Object object = this.mUsersLock;
        synchronized (object) {
            return this.getUserInfoLU(UserHandle.getCallingUserId()).isRestricted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canHaveRestrictedProfile(int userId) {
        UserManagerService.checkManageUsersPermission("canHaveRestrictedProfile");
        Object object = this.mUsersLock;
        synchronized (object) {
            UserInfo userInfo = this.getUserInfoLU(userId);
            if (userInfo == null || !userInfo.canHaveProfile()) {
                return false;
            }
            if (!userInfo.isAdmin()) {
                return false;
            }
            return !this.mIsDeviceManaged && !this.mIsUserManaged.get(userId);
        }
    }

    private UserInfo getUserInfoLU(int userId) {
        UserData userData = this.mUsers.get(userId);
        if (userData != null && userData.info.partial && !this.mRemovingUserIds.get(userId)) {
            Slog.w(LOG_TAG, "getUserInfo: unknown user #" + userId);
            return null;
        }
        return userData != null ? userData.info : null;
    }

    private UserData getUserDataLU(int userId) {
        UserData userData = this.mUsers.get(userId);
        if (userData != null && userData.info.partial && !this.mRemovingUserIds.get(userId)) {
            return null;
        }
        return userData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserInfo getUserInfoNoChecks(int userId) {
        Object object = this.mUsersLock;
        synchronized (object) {
            UserData userData = this.mUsers.get(userId);
            return userData != null ? userData.info : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserData getUserDataNoChecks(int userId) {
        Object object = this.mUsersLock;
        synchronized (object) {
            return this.mUsers.get(userId);
        }
    }

    public boolean exists(int userId) {
        return this.getUserInfoNoChecks(userId) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserName(int userId, String name) {
        UserManagerService.checkManageUsersPermission("rename users");
        boolean changed = false;
        Object object = this.mPackagesLock;
        synchronized (object) {
            UserData userData = this.getUserDataNoChecks(userId);
            if (userData == null || userData.info.partial) {
                Slog.w(LOG_TAG, "setUserName: unknown user #" + userId);
                return;
            }
            if (name != null && !name.equals(userData.info.name)) {
                userData.info.name = name;
                this.writeUserLP(userData);
                changed = true;
            }
        }
        if (changed) {
            this.sendUserInfoChangedBroadcast(userId);
        }
    }

    @Override
    public void setUserIcon(int userId, Bitmap bitmap) {
        UserManagerService.checkManageUsersPermission("update users");
        if (this.hasUserRestriction("no_set_user_icon", userId)) {
            Log.w(LOG_TAG, "Cannot set user icon. DISALLOW_SET_USER_ICON is enabled.");
            return;
        }
        this.mLocalService.setUserIcon(userId, bitmap);
    }

    private void sendUserInfoChangedBroadcast(int userId) {
        Intent changedIntent = new Intent("android.intent.action.USER_INFO_CHANGED");
        changedIntent.putExtra("android.intent.extra.user_handle", userId);
        changedIntent.addFlags(0x40000000);
        this.mContext.sendBroadcastAsUser(changedIntent, UserHandle.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParcelFileDescriptor getUserIcon(int targetUserId) {
        String iconPath;
        Object object = this.mPackagesLock;
        synchronized (object) {
            boolean sameGroup;
            UserInfo targetUserInfo = this.getUserInfoNoChecks(targetUserId);
            if (targetUserInfo == null || targetUserInfo.partial) {
                Slog.w(LOG_TAG, "getUserIcon: unknown user #" + targetUserId);
                return null;
            }
            int callingUserId = UserHandle.getCallingUserId();
            int callingGroupId = this.getUserInfoNoChecks((int)callingUserId).profileGroupId;
            int targetGroupId = targetUserInfo.profileGroupId;
            boolean bl = sameGroup = callingGroupId != -10000 && callingGroupId == targetGroupId;
            if (callingUserId != targetUserId && !sameGroup) {
                UserManagerService.checkManageUsersPermission("get the icon of a user who is not related");
            }
            if (targetUserInfo.iconPath == null) {
                return null;
            }
            iconPath = targetUserInfo.iconPath;
        }
        try {
            return ParcelFileDescriptor.open(new File(iconPath), 0x10000000);
        }
        catch (FileNotFoundException e) {
            Log.e(LOG_TAG, "Couldn't find icon file", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeInitialized(int userId) {
        UserData userData;
        UserManagerService.checkManageUsersPermission("makeInitialized");
        boolean scheduleWriteUser = false;
        Object object = this.mUsersLock;
        synchronized (object) {
            userData = this.mUsers.get(userId);
            if (userData == null || userData.info.partial) {
                Slog.w(LOG_TAG, "makeInitialized: unknown user #" + userId);
                return;
            }
            if ((userData.info.flags & 0x10) == 0) {
                userData.info.flags |= 0x10;
                scheduleWriteUser = true;
            }
        }
        if (scheduleWriteUser) {
            this.scheduleWriteUser(userData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDefaultGuestRestrictions() {
        Bundle bundle = this.mGuestRestrictions;
        synchronized (bundle) {
            if (this.mGuestRestrictions.isEmpty()) {
                this.mGuestRestrictions.putBoolean("no_config_wifi", true);
                this.mGuestRestrictions.putBoolean("no_install_unknown_sources", true);
                this.mGuestRestrictions.putBoolean("no_outgoing_calls", true);
                this.mGuestRestrictions.putBoolean("no_sms", true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle getDefaultGuestRestrictions() {
        UserManagerService.checkManageUsersPermission("getDefaultGuestRestrictions");
        Bundle bundle = this.mGuestRestrictions;
        synchronized (bundle) {
            return new Bundle(this.mGuestRestrictions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultGuestRestrictions(Bundle restrictions) {
        UserManagerService.checkManageUsersPermission("setDefaultGuestRestrictions");
        Object object = this.mGuestRestrictions;
        synchronized (object) {
            this.mGuestRestrictions.clear();
            this.mGuestRestrictions.putAll(restrictions);
        }
        object = this.mPackagesLock;
        synchronized (object) {
            this.writeUserListLP();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDevicePolicyUserRestrictionsInner(int userId, Bundle local, Bundle global) {
        boolean localChanged;
        Preconditions.checkNotNull(local);
        boolean globalChanged = false;
        Object object = this.mRestrictionsLock;
        synchronized (object) {
            if (global != null) {
                boolean bl = globalChanged = !UserRestrictionsUtils.areEqual(this.mDevicePolicyGlobalUserRestrictions, global);
                if (globalChanged) {
                    this.mDevicePolicyGlobalUserRestrictions = global;
                }
                this.mGlobalRestrictionOwnerUserId = userId;
            } else if (this.mGlobalRestrictionOwnerUserId == userId) {
                this.mGlobalRestrictionOwnerUserId = -10000;
            }
            Bundle prev = this.mDevicePolicyLocalUserRestrictions.get(userId);
            boolean bl = localChanged = !UserRestrictionsUtils.areEqual(prev, local);
            if (localChanged) {
                this.mDevicePolicyLocalUserRestrictions.put(userId, local);
            }
        }
        object = this.mPackagesLock;
        synchronized (object) {
            if (localChanged) {
                this.writeUserLP(this.getUserDataNoChecks(userId));
            }
            if (globalChanged) {
                this.writeUserListLP();
            }
        }
        object = this.mRestrictionsLock;
        synchronized (object) {
            if (globalChanged) {
                this.applyUserRestrictionsForAllUsersLR();
            } else if (localChanged) {
                this.applyUserRestrictionsLR(userId);
            }
        }
    }

    @GuardedBy(value="mRestrictionsLock")
    private Bundle computeEffectiveUserRestrictionsLR(int userId) {
        Bundle baseRestrictions = UserRestrictionsUtils.nonNull(this.mBaseUserRestrictions.get(userId));
        Bundle global = this.mDevicePolicyGlobalUserRestrictions;
        Bundle local = this.mDevicePolicyLocalUserRestrictions.get(userId);
        if (UserRestrictionsUtils.isEmpty(global) && UserRestrictionsUtils.isEmpty(local)) {
            return baseRestrictions;
        }
        Bundle effective = UserRestrictionsUtils.clone(baseRestrictions);
        UserRestrictionsUtils.merge(effective, global);
        UserRestrictionsUtils.merge(effective, local);
        return effective;
    }

    @GuardedBy(value="mRestrictionsLock")
    private void invalidateEffectiveUserRestrictionsLR(int userId) {
        this.mCachedEffectiveUserRestrictions.remove(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bundle getEffectiveUserRestrictions(int userId) {
        Object object = this.mRestrictionsLock;
        synchronized (object) {
            Bundle restrictions = this.mCachedEffectiveUserRestrictions.get(userId);
            if (restrictions == null) {
                restrictions = this.computeEffectiveUserRestrictionsLR(userId);
                this.mCachedEffectiveUserRestrictions.put(userId, restrictions);
            }
            return restrictions;
        }
    }

    @Override
    public boolean hasUserRestriction(String restrictionKey, int userId) {
        if (!UserRestrictionsUtils.isValidRestriction(restrictionKey)) {
            return false;
        }
        Bundle restrictions = this.getEffectiveUserRestrictions(userId);
        return restrictions != null && restrictions.getBoolean(restrictionKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUserRestrictionSource(String restrictionKey, int userId) {
        UserManagerService.checkManageUsersPermission("getUserRestrictionSource");
        int result = 0;
        if (!this.hasUserRestriction(restrictionKey, userId)) {
            return result;
        }
        if (this.hasBaseUserRestriction(restrictionKey, userId)) {
            result |= 1;
        }
        Object object = this.mRestrictionsLock;
        synchronized (object) {
            Bundle localRestrictions = this.mDevicePolicyLocalUserRestrictions.get(userId);
            if (!UserRestrictionsUtils.isEmpty(localRestrictions) && localRestrictions.getBoolean(restrictionKey)) {
                result = this.mGlobalRestrictionOwnerUserId == userId ? (result |= 2) : (result |= 4);
            }
            if (!UserRestrictionsUtils.isEmpty(this.mDevicePolicyGlobalUserRestrictions) && this.mDevicePolicyGlobalUserRestrictions.getBoolean(restrictionKey)) {
                result |= 2;
            }
        }
        return result;
    }

    @Override
    public Bundle getUserRestrictions(int userId) {
        return UserRestrictionsUtils.clone(this.getEffectiveUserRestrictions(userId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasBaseUserRestriction(String restrictionKey, int userId) {
        UserManagerService.checkManageUsersPermission("hasBaseUserRestriction");
        if (!UserRestrictionsUtils.isValidRestriction(restrictionKey)) {
            return false;
        }
        Object object = this.mRestrictionsLock;
        synchronized (object) {
            Bundle bundle = this.mBaseUserRestrictions.get(userId);
            return bundle != null && bundle.getBoolean(restrictionKey, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserRestriction(String key, boolean value, int userId) {
        UserManagerService.checkManageUsersPermission("setUserRestriction");
        if (!UserRestrictionsUtils.isValidRestriction(key)) {
            return;
        }
        Object object = this.mRestrictionsLock;
        synchronized (object) {
            Bundle newRestrictions = UserRestrictionsUtils.clone(this.mBaseUserRestrictions.get(userId));
            newRestrictions.putBoolean(key, value);
            this.updateUserRestrictionsInternalLR(newRestrictions, userId);
        }
    }

    @GuardedBy(value="mRestrictionsLock")
    private void updateUserRestrictionsInternalLR(Bundle newRestrictions, final int userId) {
        Bundle prevAppliedRestrictions = UserRestrictionsUtils.nonNull(this.mAppliedUserRestrictions.get(userId));
        if (newRestrictions != null) {
            Bundle prevBaseRestrictions = this.mBaseUserRestrictions.get(userId);
            Preconditions.checkState(prevBaseRestrictions != newRestrictions);
            Preconditions.checkState(this.mCachedEffectiveUserRestrictions.get(userId) != newRestrictions);
            if (!UserRestrictionsUtils.areEqual(prevBaseRestrictions, newRestrictions)) {
                this.mBaseUserRestrictions.put(userId, newRestrictions);
                this.scheduleWriteUser(this.getUserDataNoChecks(userId));
            }
        }
        final Bundle effective = this.computeEffectiveUserRestrictionsLR(userId);
        this.mCachedEffectiveUserRestrictions.put(userId, effective);
        if (this.mAppOpsService != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        UserManagerService.this.mAppOpsService.setUserRestrictions(effective, mUserRestriconToken, userId);
                    }
                    catch (RemoteException e) {
                        Log.w(UserManagerService.LOG_TAG, "Unable to notify AppOpsService of UserRestrictions");
                    }
                }
            });
        }
        this.propagateUserRestrictionsLR(userId, effective, prevAppliedRestrictions);
        this.mAppliedUserRestrictions.put(userId, new Bundle(effective));
    }

    private void propagateUserRestrictionsLR(final int userId, Bundle newRestrictions, Bundle prevRestrictions) {
        if (UserRestrictionsUtils.areEqual(newRestrictions, prevRestrictions)) {
            return;
        }
        final Bundle newRestrictionsFinal = new Bundle(newRestrictions);
        final Bundle prevRestrictionsFinal = new Bundle(prevRestrictions);
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                UserManagerInternal.UserRestrictionsListener[] listeners;
                UserRestrictionsUtils.applyUserRestrictions(UserManagerService.this.mContext, userId, newRestrictionsFinal, prevRestrictionsFinal);
                ArrayList arrayList = UserManagerService.this.mUserRestrictionsListeners;
                synchronized (arrayList) {
                    listeners = new UserManagerInternal.UserRestrictionsListener[UserManagerService.this.mUserRestrictionsListeners.size()];
                    UserManagerService.this.mUserRestrictionsListeners.toArray(listeners);
                }
                for (int i = 0; i < listeners.length; ++i) {
                    listeners[i].onUserRestrictionsChanged(userId, newRestrictionsFinal, prevRestrictionsFinal);
                }
            }
        });
    }

    void applyUserRestrictionsLR(int userId) {
        this.updateUserRestrictionsInternalLR(null, userId);
    }

    @GuardedBy(value="mRestrictionsLock")
    void applyUserRestrictionsForAllUsersLR() {
        this.mCachedEffectiveUserRestrictions.clear();
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int[] runningUsers;
                try {
                    runningUsers = ActivityManagerNative.getDefault().getRunningUserIds();
                }
                catch (RemoteException e) {
                    Log.w(UserManagerService.LOG_TAG, "Unable to access ActivityManagerNative");
                    return;
                }
                Object object = UserManagerService.this.mRestrictionsLock;
                synchronized (object) {
                    for (int i = 0; i < runningUsers.length; ++i) {
                        UserManagerService.this.applyUserRestrictionsLR(runningUsers[i]);
                    }
                }
            }
        };
        this.mHandler.post(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUserLimitReached() {
        int count;
        Object object = this.mUsersLock;
        synchronized (object) {
            count = this.getAliveUsersExcludingGuestsCountLU();
        }
        return count >= UserManager.getMaxSupportedUsers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canAddMoreManagedProfiles(int userId, boolean allowedToRemoveOne) {
        int profilesRemovedCount;
        UserManagerService.checkManageUsersPermission("check if more managed profiles can be added.");
        if (ActivityManager.isLowRamDeviceStatic()) {
            return false;
        }
        if (!this.mContext.getPackageManager().hasSystemFeature("android.software.managed_users")) {
            return false;
        }
        int managedProfilesCount = this.getProfiles(userId, true).size() - 1;
        int n = profilesRemovedCount = managedProfilesCount > 0 && allowedToRemoveOne ? 1 : 0;
        if (managedProfilesCount - profilesRemovedCount >= 1) {
            return false;
        }
        Object object = this.mUsersLock;
        synchronized (object) {
            UserInfo userInfo = this.getUserInfoLU(userId);
            if (!userInfo.canHaveProfile()) {
                return false;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl17 : MonitorExitStatement: MONITOREXIT : var5_5
            int usersCountAfterRemoving = this.getAliveUsersExcludingGuestsCountLU() - profilesRemovedCount;
            return usersCountAfterRemoving == 1 || usersCountAfterRemoving < UserManager.getMaxSupportedUsers();
        }
    }

    private int getAliveUsersExcludingGuestsCountLU() {
        int aliveUserCount = 0;
        int totalUserCount = this.mUsers.size();
        for (int i = 0; i < totalUserCount; ++i) {
            UserInfo user = this.mUsers.valueAt((int)i).info;
            if (this.mRemovingUserIds.get(user.id) || user.isGuest() || user.partial) continue;
            ++aliveUserCount;
        }
        return aliveUserCount;
    }

    private static final void checkManageUserAndAcrossUsersFullPermission(String message) {
        int uid = Binder.getCallingUid();
        if (uid != 1000 && uid != 0 && ActivityManager.checkComponentPermission("android.permission.MANAGE_USERS", uid, -1, true) != 0 && ActivityManager.checkComponentPermission("android.permission.INTERACT_ACROSS_USERS_FULL", uid, -1, true) != 0) {
            throw new SecurityException("You need MANAGE_USERS and INTERACT_ACROSS_USERS_FULL permission to: " + message);
        }
    }

    private static final void checkManageUsersPermission(String message) {
        if (!UserManagerService.hasManageUsersPermission()) {
            throw new SecurityException("You need MANAGE_USERS permission to: " + message);
        }
    }

    private static final void checkManageOrCreateUsersPermission(String message) {
        if (!UserManagerService.hasManageOrCreateUsersPermission()) {
            throw new SecurityException("You either need MANAGE_USERS or CREATE_USERS permission to: " + message);
        }
    }

    private static final void checkManageOrCreateUsersPermission(int creationFlags) {
        if ((creationFlags & 0xFFFFFED3) == 0) {
            if (!UserManagerService.hasManageOrCreateUsersPermission()) {
                throw new SecurityException("You either need MANAGE_USERS or CREATE_USERS permission to create an user with flags: " + creationFlags);
            }
        } else if (!UserManagerService.hasManageUsersPermission()) {
            throw new SecurityException("You need MANAGE_USERS permission to create an user  with flags: " + creationFlags);
        }
    }

    private static final boolean hasManageUsersPermission() {
        int callingUid = Binder.getCallingUid();
        return UserHandle.isSameApp(callingUid, 1000) || callingUid == 0 || ActivityManager.checkComponentPermission("android.permission.MANAGE_USERS", callingUid, -1, true) == 0;
    }

    private static final boolean hasManageOrCreateUsersPermission() {
        int callingUid = Binder.getCallingUid();
        return UserHandle.isSameApp(callingUid, 1000) || callingUid == 0 || ActivityManager.checkComponentPermission("android.permission.MANAGE_USERS", callingUid, -1, true) == 0 || ActivityManager.checkComponentPermission("android.permission.CREATE_USERS", callingUid, -1, true) == 0;
    }

    private static void checkSystemOrRoot(String message) {
        int uid = Binder.getCallingUid();
        if (!UserHandle.isSameApp(uid, 1000) && uid != 0) {
            throw new SecurityException("Only system may: " + message);
        }
    }

    private void writeBitmapLP(UserInfo info, Bitmap bitmap) {
        try {
            FileOutputStream os;
            File dir = new File(this.mUsersDir, Integer.toString(info.id));
            File file = new File(dir, USER_PHOTO_FILENAME);
            File tmp = new File(dir, USER_PHOTO_FILENAME_TMP);
            if (!dir.exists()) {
                dir.mkdir();
                FileUtils.setPermissions(dir.getPath(), 505, -1, -1);
            }
            if (bitmap.compress(Bitmap.CompressFormat.PNG, 100, os = new FileOutputStream(tmp)) && tmp.renameTo(file) && SELinux.restorecon(file)) {
                info.iconPath = file.getAbsolutePath();
            }
            try {
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            tmp.delete();
        }
        catch (FileNotFoundException e) {
            Slog.w(LOG_TAG, "Error setting photo for user ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getUserIds() {
        Object object = this.mUsersLock;
        synchronized (object) {
            return this.mUserIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readUserListLP() {
        if (!this.mUserListFile.exists()) {
            this.fallbackToSingleUserLP();
            return;
        }
        FileInputStream fis = null;
        AtomicFile userListFile = new AtomicFile(this.mUserListFile);
        try {
            int type;
            fis = userListFile.openRead();
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(fis, StandardCharsets.UTF_8.name());
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                Slog.e(LOG_TAG, "Unable to read user list");
                this.fallbackToSingleUserLP();
                return;
            }
            this.mNextSerialNumber = -1;
            if (parser.getName().equals(TAG_USERS)) {
                String versionNumber;
                String lastSerialNumber = parser.getAttributeValue(null, ATTR_NEXT_SERIAL_NO);
                if (lastSerialNumber != null) {
                    this.mNextSerialNumber = Integer.parseInt(lastSerialNumber);
                }
                if ((versionNumber = parser.getAttributeValue(null, ATTR_USER_VERSION)) != null) {
                    this.mUserVersion = Integer.parseInt(versionNumber);
                }
            }
            Bundle newDevicePolicyGlobalUserRestrictions = new Bundle();
            block16: while ((type = parser.next()) != 1) {
                String ownerUserId;
                Object id2;
                if (type != 2) continue;
                String name = parser.getName();
                if (name.equals(TAG_USER)) {
                    id2 = parser.getAttributeValue(null, ATTR_ID);
                    UserData userData = this.readUserLP(Integer.parseInt((String)id2));
                    if (userData == null) continue;
                    Object object = this.mUsersLock;
                    synchronized (object) {
                        this.mUsers.put(userData.info.id, userData);
                        if (this.mNextSerialNumber < 0 || this.mNextSerialNumber <= userData.info.id) {
                            this.mNextSerialNumber = userData.info.id + 1;
                        }
                        continue;
                    }
                }
                if (name.equals(TAG_GUEST_RESTRICTIONS)) {
                    while ((type = parser.next()) != 1 && type != 3) {
                        if (type != 2) continue;
                        if (parser.getName().equals(TAG_RESTRICTIONS)) {
                            id2 = this.mGuestRestrictions;
                            synchronized (id2) {
                                UserRestrictionsUtils.readRestrictions(parser, this.mGuestRestrictions);
                                continue block16;
                            }
                        }
                        if (!parser.getName().equals(TAG_DEVICE_POLICY_RESTRICTIONS)) continue block16;
                        UserRestrictionsUtils.readRestrictions(parser, newDevicePolicyGlobalUserRestrictions);
                        continue block16;
                    }
                    continue;
                }
                if (!name.equals(TAG_GLOBAL_RESTRICTION_OWNER_ID) || (ownerUserId = parser.getAttributeValue(null, ATTR_ID)) == null) continue;
                this.mGlobalRestrictionOwnerUserId = Integer.parseInt(ownerUserId);
            }
            Object object = this.mRestrictionsLock;
            synchronized (object) {
                this.mDevicePolicyGlobalUserRestrictions = newDevicePolicyGlobalUserRestrictions;
            }
            this.updateUserIds();
            this.upgradeIfNecessaryLP();
        }
        catch (IOException | XmlPullParserException e) {
            this.fallbackToSingleUserLP();
        }
        finally {
            IoUtils.closeQuietly(fis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeIfNecessaryLP() {
        UserData userData;
        int originalVersion = this.mUserVersion;
        int userVersion = this.mUserVersion;
        if (userVersion < 1) {
            userData = this.getUserDataNoChecks(0);
            if ("Primary".equals(userData.info.name)) {
                userData.info.name = this.mContext.getResources().getString(17040690);
                this.scheduleWriteUser(userData);
            }
            userVersion = 1;
        }
        if (userVersion < 2) {
            userData = this.getUserDataNoChecks(0);
            if ((userData.info.flags & 0x10) == 0) {
                userData.info.flags |= 0x10;
                this.scheduleWriteUser(userData);
            }
            userVersion = 2;
        }
        if (userVersion < 4) {
            userVersion = 4;
        }
        if (userVersion < 5) {
            this.initDefaultGuestRestrictions();
            userVersion = 5;
        }
        if (userVersion < 6) {
            boolean splitSystemUser = UserManager.isSplitSystemUser();
            Object object = this.mUsersLock;
            synchronized (object) {
                for (int i = 0; i < this.mUsers.size(); ++i) {
                    UserData userData2 = this.mUsers.valueAt(i);
                    if (splitSystemUser || !userData2.info.isRestricted() || userData2.info.restrictedProfileParentId != -10000) continue;
                    userData2.info.restrictedProfileParentId = 0;
                    this.scheduleWriteUser(userData2);
                }
            }
            userVersion = 6;
        }
        if (userVersion < 6) {
            Slog.w(LOG_TAG, "User version " + this.mUserVersion + " didn't upgrade as expected to " + 6);
        } else {
            this.mUserVersion = userVersion;
            if (originalVersion < this.mUserVersion) {
                this.writeUserListLP();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fallbackToSingleUserLP() {
        int flags = 16;
        if (!UserManager.isSplitSystemUser()) {
            flags |= 3;
        }
        UserInfo system = new UserInfo(0, null, null, flags);
        UserData userData = new UserData();
        userData.info = system;
        Object object = this.mUsersLock;
        synchronized (object) {
            this.mUsers.put(system.id, userData);
        }
        this.mNextSerialNumber = 10;
        this.mUserVersion = 6;
        Bundle restrictions = new Bundle();
        try {
            String[] defaultFirstUserRestrictions;
            for (String userRestriction : defaultFirstUserRestrictions = this.mContext.getResources().getStringArray(17236042)) {
                if (!UserRestrictionsUtils.isValidRestriction(userRestriction)) continue;
                restrictions.putBoolean(userRestriction, true);
            }
        }
        catch (Resources.NotFoundException e) {
            Log.e(LOG_TAG, "Couldn't find resource: config_defaultFirstUserRestrictions", e);
        }
        Object object2 = this.mRestrictionsLock;
        synchronized (object2) {
            this.mBaseUserRestrictions.append(0, restrictions);
        }
        this.updateUserIds();
        this.initDefaultGuestRestrictions();
        this.writeUserLP(userData);
        this.writeUserListLP();
    }

    private String getOwnerName() {
        return this.mContext.getResources().getString(17040690);
    }

    private void scheduleWriteUser(UserData UserData2) {
        if (!this.mHandler.hasMessages(1, UserData2)) {
            Message msg = this.mHandler.obtainMessage(1, UserData2);
            this.mHandler.sendMessageDelayed(msg, 2000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeUserLP(UserData userData) {
        FileOutputStream fos = null;
        AtomicFile userFile = new AtomicFile(new File(this.mUsersDir, userData.info.id + XML_SUFFIX));
        try {
            fos = userFile.startWrite();
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput(bos, StandardCharsets.UTF_8.name());
            serializer.startDocument(null, true);
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            UserInfo userInfo = userData.info;
            serializer.startTag(null, TAG_USER);
            serializer.attribute(null, ATTR_ID, Integer.toString(userInfo.id));
            serializer.attribute(null, ATTR_SERIAL_NO, Integer.toString(userInfo.serialNumber));
            serializer.attribute(null, ATTR_FLAGS, Integer.toString(userInfo.flags));
            serializer.attribute(null, ATTR_CREATION_TIME, Long.toString(userInfo.creationTime));
            serializer.attribute(null, ATTR_LAST_LOGGED_IN_TIME, Long.toString(userInfo.lastLoggedInTime));
            if (userInfo.lastLoggedInFingerprint != null) {
                serializer.attribute(null, ATTR_LAST_LOGGED_IN_FINGERPRINT, userInfo.lastLoggedInFingerprint);
            }
            if (userInfo.iconPath != null) {
                serializer.attribute(null, ATTR_ICON_PATH, userInfo.iconPath);
            }
            if (userInfo.partial) {
                serializer.attribute(null, ATTR_PARTIAL, "true");
            }
            if (userInfo.guestToRemove) {
                serializer.attribute(null, ATTR_GUEST_TO_REMOVE, "true");
            }
            if (userInfo.profileGroupId != -10000) {
                serializer.attribute(null, ATTR_PROFILE_GROUP_ID, Integer.toString(userInfo.profileGroupId));
            }
            if (userInfo.restrictedProfileParentId != -10000) {
                serializer.attribute(null, ATTR_RESTRICTED_PROFILE_PARENT_ID, Integer.toString(userInfo.restrictedProfileParentId));
            }
            if (userData.persistSeedData) {
                if (userData.seedAccountName != null) {
                    serializer.attribute(null, ATTR_SEED_ACCOUNT_NAME, userData.seedAccountName);
                }
                if (userData.seedAccountType != null) {
                    serializer.attribute(null, ATTR_SEED_ACCOUNT_TYPE, userData.seedAccountType);
                }
            }
            if (userInfo.name != null) {
                serializer.startTag(null, TAG_NAME);
                serializer.text(userInfo.name);
                serializer.endTag(null, TAG_NAME);
            }
            Object object = this.mRestrictionsLock;
            synchronized (object) {
                UserRestrictionsUtils.writeRestrictions(serializer, this.mBaseUserRestrictions.get(userInfo.id), TAG_RESTRICTIONS);
                UserRestrictionsUtils.writeRestrictions(serializer, this.mDevicePolicyLocalUserRestrictions.get(userInfo.id), TAG_DEVICE_POLICY_RESTRICTIONS);
            }
            if (userData.account != null) {
                serializer.startTag(null, TAG_ACCOUNT);
                serializer.text(userData.account);
                serializer.endTag(null, TAG_ACCOUNT);
            }
            if (userData.persistSeedData && userData.seedAccountOptions != null) {
                serializer.startTag(null, TAG_SEED_ACCOUNT_OPTIONS);
                userData.seedAccountOptions.saveToXml(serializer);
                serializer.endTag(null, TAG_SEED_ACCOUNT_OPTIONS);
            }
            serializer.endTag(null, TAG_USER);
            serializer.endDocument();
            userFile.finishWrite(fos);
        }
        catch (Exception ioe) {
            Slog.e(LOG_TAG, "Error writing user info " + userData.info.id, ioe);
            userFile.failWrite(fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeUserListLP() {
        FileOutputStream fos = null;
        AtomicFile userListFile = new AtomicFile(this.mUserListFile);
        try {
            int[] userIdsToWrite;
            fos = userListFile.startWrite();
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput(bos, StandardCharsets.UTF_8.name());
            serializer.startDocument(null, true);
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            serializer.startTag(null, TAG_USERS);
            serializer.attribute(null, ATTR_NEXT_SERIAL_NO, Integer.toString(this.mNextSerialNumber));
            serializer.attribute(null, ATTR_USER_VERSION, Integer.toString(this.mUserVersion));
            serializer.startTag(null, TAG_GUEST_RESTRICTIONS);
            Object object = this.mGuestRestrictions;
            synchronized (object) {
                UserRestrictionsUtils.writeRestrictions(serializer, this.mGuestRestrictions, TAG_RESTRICTIONS);
            }
            serializer.endTag(null, TAG_GUEST_RESTRICTIONS);
            object = this.mRestrictionsLock;
            synchronized (object) {
                UserRestrictionsUtils.writeRestrictions(serializer, this.mDevicePolicyGlobalUserRestrictions, TAG_DEVICE_POLICY_RESTRICTIONS);
            }
            serializer.startTag(null, TAG_GLOBAL_RESTRICTION_OWNER_ID);
            serializer.attribute(null, ATTR_ID, Integer.toString(this.mGlobalRestrictionOwnerUserId));
            serializer.endTag(null, TAG_GLOBAL_RESTRICTION_OWNER_ID);
            Object object2 = this.mUsersLock;
            synchronized (object2) {
                userIdsToWrite = new int[this.mUsers.size()];
                for (int i = 0; i < userIdsToWrite.length; ++i) {
                    UserInfo user = this.mUsers.valueAt((int)i).info;
                    userIdsToWrite[i] = user.id;
                }
            }
            for (Object id2 : (Object)userIdsToWrite) {
                serializer.startTag(null, TAG_USER);
                serializer.attribute(null, ATTR_ID, Integer.toString((int)id2));
                serializer.endTag(null, TAG_USER);
            }
            serializer.endTag(null, TAG_USERS);
            serializer.endDocument();
            userListFile.finishWrite(fos);
        }
        catch (Exception e) {
            userListFile.failWrite(fos);
            Slog.e(LOG_TAG, "Error writing user list");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UserData readUserLP(int id2) {
        int flags = 0;
        int serialNumber = id2;
        String name = null;
        String account = null;
        String iconPath = null;
        long creationTime = 0L;
        long lastLoggedInTime = 0L;
        String lastLoggedInFingerprint = null;
        int profileGroupId = -10000;
        int restrictedProfileParentId = -10000;
        boolean partial = false;
        boolean guestToRemove = false;
        boolean persistSeedData = false;
        String seedAccountName = null;
        String seedAccountType = null;
        PersistableBundle seedAccountOptions = null;
        Bundle baseRestrictions = new Bundle();
        Bundle localRestrictions = new Bundle();
        FileInputStream fis = null;
        try {
            int type;
            AtomicFile userFile = new AtomicFile(new File(this.mUsersDir, Integer.toString(id2) + XML_SUFFIX));
            fis = userFile.openRead();
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(fis, StandardCharsets.UTF_8.name());
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                Slog.e(LOG_TAG, "Unable to read user " + id2);
                UserData userData = null;
                return userData;
            }
            if (type == 2 && parser.getName().equals(TAG_USER)) {
                int storedId = this.readIntAttribute(parser, ATTR_ID, -1);
                if (storedId != id2) {
                    Slog.e(LOG_TAG, "User id does not match the file name");
                    UserData userData = null;
                    return userData;
                }
                serialNumber = this.readIntAttribute(parser, ATTR_SERIAL_NO, id2);
                flags = this.readIntAttribute(parser, ATTR_FLAGS, 0);
                iconPath = parser.getAttributeValue(null, ATTR_ICON_PATH);
                creationTime = this.readLongAttribute(parser, ATTR_CREATION_TIME, 0L);
                lastLoggedInTime = this.readLongAttribute(parser, ATTR_LAST_LOGGED_IN_TIME, 0L);
                lastLoggedInFingerprint = parser.getAttributeValue(null, ATTR_LAST_LOGGED_IN_FINGERPRINT);
                profileGroupId = this.readIntAttribute(parser, ATTR_PROFILE_GROUP_ID, -10000);
                restrictedProfileParentId = this.readIntAttribute(parser, ATTR_RESTRICTED_PROFILE_PARENT_ID, -10000);
                String valueString = parser.getAttributeValue(null, ATTR_PARTIAL);
                if ("true".equals(valueString)) {
                    partial = true;
                }
                if ("true".equals(valueString = parser.getAttributeValue(null, ATTR_GUEST_TO_REMOVE))) {
                    guestToRemove = true;
                }
                seedAccountName = parser.getAttributeValue(null, ATTR_SEED_ACCOUNT_NAME);
                seedAccountType = parser.getAttributeValue(null, ATTR_SEED_ACCOUNT_TYPE);
                if (seedAccountName != null || seedAccountType != null) {
                    persistSeedData = true;
                }
                int outerDepth = parser.getDepth();
                while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                    if (type == 3 || type == 4) continue;
                    String tag = parser.getName();
                    if (TAG_NAME.equals(tag)) {
                        type = parser.next();
                        if (type != 4) continue;
                        name = parser.getText();
                        continue;
                    }
                    if (TAG_RESTRICTIONS.equals(tag)) {
                        UserRestrictionsUtils.readRestrictions(parser, baseRestrictions);
                        continue;
                    }
                    if (TAG_DEVICE_POLICY_RESTRICTIONS.equals(tag)) {
                        UserRestrictionsUtils.readRestrictions(parser, localRestrictions);
                        continue;
                    }
                    if (TAG_ACCOUNT.equals(tag)) {
                        type = parser.next();
                        if (type != 4) continue;
                        account = parser.getText();
                        continue;
                    }
                    if (!TAG_SEED_ACCOUNT_OPTIONS.equals(tag)) continue;
                    seedAccountOptions = PersistableBundle.restoreFromXml(parser);
                    persistSeedData = true;
                }
            }
            UserInfo userInfo = new UserInfo(id2, name, iconPath, flags);
            userInfo.serialNumber = serialNumber;
            userInfo.creationTime = creationTime;
            userInfo.lastLoggedInTime = lastLoggedInTime;
            userInfo.lastLoggedInFingerprint = lastLoggedInFingerprint;
            userInfo.partial = partial;
            userInfo.guestToRemove = guestToRemove;
            userInfo.profileGroupId = profileGroupId;
            userInfo.restrictedProfileParentId = restrictedProfileParentId;
            UserData userData = new UserData();
            userData.info = userInfo;
            userData.account = account;
            userData.seedAccountName = seedAccountName;
            userData.seedAccountType = seedAccountType;
            userData.persistSeedData = persistSeedData;
            userData.seedAccountOptions = seedAccountOptions;
            Object object = this.mRestrictionsLock;
            synchronized (object) {
                this.mBaseUserRestrictions.put(id2, baseRestrictions);
                this.mDevicePolicyLocalUserRestrictions.put(id2, localRestrictions);
            }
            object = userData;
            return object;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (XmlPullParserException xmlPullParserException) {
            return null;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private int readIntAttribute(XmlPullParser parser, String attr2, int defaultValue) {
        String valueString = parser.getAttributeValue(null, attr2);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(valueString);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    private long readLongAttribute(XmlPullParser parser, String attr2, long defaultValue) {
        String valueString = parser.getAttributeValue(null, attr2);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(valueString);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanAppRestrictionsForPackage(String pkg, int userId) {
        Object object = this.mPackagesLock;
        synchronized (object) {
            File dir = Environment.getUserSystemDirectory(userId);
            File resFile = new File(dir, this.packageToRestrictionsFileName(pkg));
            if (resFile.exists()) {
                resFile.delete();
            }
        }
    }

    @Override
    public UserInfo createProfileForUser(String name, int flags, int userId) {
        UserManagerService.checkManageOrCreateUsersPermission(flags);
        return this.createUserInternal(name, flags, userId);
    }

    @Override
    public UserInfo createUser(String name, int flags) {
        UserManagerService.checkManageOrCreateUsersPermission(flags);
        return this.createUserInternal(name, flags, -10000);
    }

    private UserInfo createUserInternal(String name, int flags, int parentId) {
        if (this.hasUserRestriction("no_add_user", UserHandle.getCallingUserId())) {
            Log.w(LOG_TAG, "Cannot add user. DISALLOW_ADD_USER is enabled.");
            return null;
        }
        return this.createUserInternalUnchecked(name, flags, parentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private UserInfo createUserInternalUnchecked(String name, int flags, int parentId) {
        Object object;
        Object parent;
        long ident;
        boolean isDemo;
        boolean isRestricted;
        boolean isManagedProfile;
        boolean isGuest;
        block45: {
            if (ActivityManager.isLowRamDeviceStatic()) {
                return null;
            }
            isGuest = (flags & 4) != 0;
            isManagedProfile = (flags & 0x20) != 0;
            isRestricted = (flags & 8) != 0;
            isDemo = (flags & 0x200) != 0;
            ident = Binder.clearCallingIdentity();
            Object object2 = this.mPackagesLock;
            // MONITORENTER : object2
            parent = null;
            if (parentId == -10000) break block45;
            object = this.mUsersLock;
            // MONITORENTER : object
            parent = this.getUserDataLU(parentId);
            // MONITOREXIT : object
            if (parent != null) break block45;
            object = null;
            // MONITOREXIT : object2
            Binder.restoreCallingIdentity(ident);
            return object;
        }
        if (isManagedProfile && !this.canAddMoreManagedProfiles(parentId, false)) {
            Log.e(LOG_TAG, "Cannot add more managed profiles for user " + parentId);
            object = null;
            // MONITOREXIT : object2
            Binder.restoreCallingIdentity(ident);
            return object;
        }
        if (!isGuest && !isManagedProfile && !isDemo && this.isUserLimitReached()) {
            object = null;
            // MONITOREXIT : object2
            Binder.restoreCallingIdentity(ident);
            return object;
        }
        if (isGuest && this.findCurrentGuestUser() != null) {
            object = null;
            // MONITOREXIT : object2
            Binder.restoreCallingIdentity(ident);
            return object;
        }
        if (isRestricted && !UserManager.isSplitSystemUser() && parentId != 0) {
            Log.w(LOG_TAG, "Cannot add restricted profile - parent user must be owner");
            object = null;
            // MONITOREXIT : object2
            Binder.restoreCallingIdentity(ident);
            return object;
        }
        if (isRestricted && UserManager.isSplitSystemUser()) {
            if (parent == null) {
                Log.w(LOG_TAG, "Cannot add restricted profile - parent user must be specified");
                object = null;
                // MONITOREXIT : object2
                Binder.restoreCallingIdentity(ident);
                return object;
            }
            if (!((UserData)parent).info.canHaveProfile()) {
                Log.w(LOG_TAG, "Cannot add restricted profile - profiles cannot be created for the specified parent user id " + parentId);
                object = null;
                // MONITOREXIT : object2
                Binder.restoreCallingIdentity(ident);
                return object;
            }
        }
        if (!UserManager.isSplitSystemUser() && (flags & 0x100) != 0 && (flags & 0x200) == 0) {
            Log.e(LOG_TAG, "Ephemeral users are supported on split-system-user systems only.");
            object = null;
            // MONITOREXIT : object2
            Binder.restoreCallingIdentity(ident);
            return object;
        }
        try {
            if (UserManager.isSplitSystemUser() && !isGuest && !isManagedProfile && this.getPrimaryUser() == null) {
                flags |= 1;
                object = this.mUsersLock;
                // MONITORENTER : object
                if (!this.mIsDeviceManaged) {
                    flags |= 2;
                }
                // MONITOREXIT : object
            }
            int userId = this.getNextAvailableId();
            Environment.getUserSystemDirectory(userId).mkdirs();
            boolean ephemeralGuests2 = Resources.getSystem().getBoolean(17957035);
            Object object3 = this.mUsersLock;
            // MONITORENTER : object3
            if (isGuest && ephemeralGuests2 || this.mForceEphemeralUsers || parent != null && ((UserData)parent).info.isEphemeral()) {
                flags |= 0x100;
            }
            UserInfo userInfo = new UserInfo(userId, name, null, flags);
            userInfo.serialNumber = this.mNextSerialNumber++;
            long now = System.currentTimeMillis();
            userInfo.creationTime = now > 946080000000L ? now : 0L;
            userInfo.partial = true;
            userInfo.lastLoggedInFingerprint = Build.FINGERPRINT;
            UserData userData = new UserData();
            userData.info = userInfo;
            this.mUsers.put(userId, userData);
            // MONITOREXIT : object3
            this.writeUserLP(userData);
            this.writeUserListLP();
            if (parent != null) {
                if (isManagedProfile) {
                    if (((UserData)parent).info.profileGroupId == -10000) {
                        ((UserData)parent).info.profileGroupId = ((UserData)parent).info.id;
                        this.writeUserLP((UserData)parent);
                    }
                    userInfo.profileGroupId = ((UserData)parent).info.profileGroupId;
                } else if (isRestricted) {
                    if (((UserData)parent).info.restrictedProfileParentId == -10000) {
                        ((UserData)parent).info.restrictedProfileParentId = ((UserData)parent).info.id;
                        this.writeUserLP((UserData)parent);
                    }
                    userInfo.restrictedProfileParentId = ((UserData)parent).info.restrictedProfileParentId;
                }
            }
            // MONITOREXIT : object2
            StorageManager storage = this.mContext.getSystemService(StorageManager.class);
            storage.createUserKey(userId, userInfo.serialNumber, userInfo.isEphemeral());
            this.mPm.prepareUserData(userId, userInfo.serialNumber, 3);
            this.mPm.createNewUser(userId);
            userInfo.partial = false;
            parent = this.mPackagesLock;
            // MONITORENTER : parent
            this.writeUserLP(userData);
            // MONITOREXIT : parent
            this.updateUserIds();
            Bundle restrictions = new Bundle();
            if (isGuest) {
                Bundle ephemeralGuests2 = this.mGuestRestrictions;
                // MONITORENTER : ephemeralGuests2
                restrictions.putAll(this.mGuestRestrictions);
                // MONITOREXIT : ephemeralGuests2
            }
            Object ephemeralGuests2 = this.mRestrictionsLock;
            // MONITORENTER : ephemeralGuests2
            this.mBaseUserRestrictions.append(userId, restrictions);
            // MONITOREXIT : ephemeralGuests2
            this.mPm.onNewUserCreated(userId);
            Intent addedIntent = new Intent("android.intent.action.USER_ADDED");
            addedIntent.putExtra("android.intent.extra.user_handle", userId);
            this.mContext.sendBroadcastAsUser(addedIntent, UserHandle.ALL, "android.permission.MANAGE_USERS");
            MetricsLogger.count(this.mContext, isGuest ? TRON_GUEST_CREATED : TRON_USER_CREATED, 1);
            return userInfo;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserInfo createRestrictedProfile(String name, int parentUserId) {
        UserManagerService.checkManageOrCreateUsersPermission("setupRestrictedProfile");
        UserInfo user = this.createProfileForUser(name, 8, parentUserId);
        if (user == null) {
            return null;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            this.setUserRestriction("no_modify_accounts", true, user.id);
            Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "location_mode", 0, user.id);
            this.setUserRestriction("no_share_location", true, user.id);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserInfo findCurrentGuestUser() {
        Object object = this.mUsersLock;
        synchronized (object) {
            int size = this.mUsers.size();
            for (int i = 0; i < size; ++i) {
                UserInfo user = this.mUsers.valueAt((int)i).info;
                if (!user.isGuest() || user.guestToRemove || this.mRemovingUserIds.get(user.id)) continue;
                return user;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean markGuestForDeletion(int userHandle) {
        UserData userData;
        long ident;
        block13: {
            UserManagerService.checkManageUsersPermission("Only the system can remove users");
            if (this.getUserRestrictions(UserHandle.getCallingUserId()).getBoolean("no_remove_user", false)) {
                Log.w(LOG_TAG, "Cannot remove user. DISALLOW_REMOVE_USER is enabled.");
                return false;
            }
            ident = Binder.clearCallingIdentity();
            Object object = this.mPackagesLock;
            // MONITORENTER : object
            Object object2 = this.mUsersLock;
            // MONITORENTER : object2
            userData = this.mUsers.get(userHandle);
            if (userHandle != 0 && userData != null && !this.mRemovingUserIds.get(userHandle)) break block13;
            boolean bl = false;
            // MONITOREXIT : object2
            // MONITOREXIT : object
            Binder.restoreCallingIdentity(ident);
            return bl;
        }
        // MONITOREXIT : object2
        if (!userData.info.isGuest()) {
            boolean bl = false;
            // MONITOREXIT : object
            Binder.restoreCallingIdentity(ident);
            return bl;
        }
        try {
            userData.info.guestToRemove = true;
            userData.info.flags |= 0x40;
            this.writeUserLP(userData);
            // MONITOREXIT : object
            return true;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean removeUser(int userHandle) {
        UserManagerService.checkManageOrCreateUsersPermission("Only the system can remove users");
        if (this.getUserRestrictions(UserHandle.getCallingUserId()).getBoolean("no_remove_user", false)) {
            Log.w(LOG_TAG, "Cannot remove user. DISALLOW_REMOVE_USER is enabled.");
            return false;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            int res;
            int currentUser = ActivityManager.getCurrentUser();
            if (currentUser == userHandle) {
                Log.w(LOG_TAG, "Current user cannot be removed");
                boolean bl = false;
                return bl;
            }
            Object object = this.mPackagesLock;
            // MONITORENTER : object
            Object object2 = this.mUsersLock;
            // MONITORENTER : object2
            UserData userData = this.mUsers.get(userHandle);
            if (userHandle == 0 || userData == null || this.mRemovingUserIds.get(userHandle)) {
                boolean bl = false;
                // MONITOREXIT : object2
                // MONITOREXIT : object
                return bl;
            }
            this.mRemovingUserIds.put(userHandle, true);
            // MONITOREXIT : object2
            try {
                this.mAppOpsService.removeUser(userHandle);
            }
            catch (RemoteException e) {
                Log.w(LOG_TAG, "Unable to notify AppOpsService of removing user", e);
            }
            userData.info.partial = true;
            userData.info.flags |= 0x40;
            this.writeUserLP(userData);
            // MONITOREXIT : object
            if (userData.info.profileGroupId != -10000 && userData.info.isManagedProfile()) {
                this.sendProfileRemovedBroadcast(userData.info.profileGroupId, userData.info.id);
            }
            try {
                res = ActivityManagerNative.getDefault().stopUser(userHandle, true, new IStopUserCallback.Stub(){

                    @Override
                    public void userStopped(int userId) {
                        UserManagerService.this.finishRemoveUser(userId);
                    }

                    @Override
                    public void userStopAborted(int userId) {
                    }
                });
            }
            catch (RemoteException e) {
                boolean bl = false;
                Binder.restoreCallingIdentity(ident);
                return bl;
            }
            boolean bl = res == 0;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishRemoveUser(final int userHandle) {
        long ident = Binder.clearCallingIdentity();
        try {
            Intent addedIntent = new Intent("android.intent.action.USER_REMOVED");
            addedIntent.putExtra("android.intent.extra.user_handle", userHandle);
            this.mContext.sendOrderedBroadcastAsUser(addedIntent, UserHandle.ALL, "android.permission.MANAGE_USERS", new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    new Thread(){

                        @Override
                        public void run() {
                            LocalServices.getService(ActivityManagerInternal.class).onUserRemoved(userHandle);
                            UserManagerService.this.removeUserState(userHandle);
                        }
                    }.start();
                }
            }, null, -1, null, null);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUserState(int userHandle) {
        try {
            this.mContext.getSystemService(StorageManager.class).destroyUserKey(userHandle);
        }
        catch (IllegalStateException e) {
            Slog.i(LOG_TAG, "Destroying key for user " + userHandle + " failed, continuing anyway", e);
        }
        try {
            IGateKeeperService gk = GateKeeper.getService();
            if (gk != null) {
                gk.clearSecureUserId(userHandle);
            }
        }
        catch (Exception ex) {
            Slog.w(LOG_TAG, "unable to clear GK secure user id");
        }
        this.mPm.cleanUpUser(this, userHandle);
        this.mPm.destroyUserData(userHandle, 3);
        Object ex = this.mUsersLock;
        synchronized (ex) {
            this.mUsers.remove(userHandle);
            this.mIsUserManaged.delete(userHandle);
        }
        ex = this.mUserStates;
        synchronized (ex) {
            this.mUserStates.delete(userHandle);
        }
        ex = this.mRestrictionsLock;
        synchronized (ex) {
            this.mBaseUserRestrictions.remove(userHandle);
            this.mAppliedUserRestrictions.remove(userHandle);
            this.mCachedEffectiveUserRestrictions.remove(userHandle);
            this.mDevicePolicyLocalUserRestrictions.remove(userHandle);
        }
        ex = this.mPackagesLock;
        synchronized (ex) {
            this.writeUserListLP();
        }
        AtomicFile userFile = new AtomicFile(new File(this.mUsersDir, userHandle + XML_SUFFIX));
        userFile.delete();
        this.updateUserIds();
    }

    private void sendProfileRemovedBroadcast(int parentUserId, int removedUserId) {
        Intent managedProfileIntent = new Intent("android.intent.action.MANAGED_PROFILE_REMOVED");
        managedProfileIntent.addFlags(0x50000000);
        managedProfileIntent.putExtra("android.intent.extra.USER", new UserHandle(removedUserId));
        managedProfileIntent.putExtra("android.intent.extra.user_handle", removedUserId);
        this.mContext.sendBroadcastAsUser(managedProfileIntent, new UserHandle(parentUserId), null);
    }

    @Override
    public Bundle getApplicationRestrictions(String packageName) {
        return this.getApplicationRestrictionsForUser(packageName, UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle getApplicationRestrictionsForUser(String packageName, int userId) {
        if (UserHandle.getCallingUserId() != userId || !UserHandle.isSameApp(Binder.getCallingUid(), this.getUidForPackage(packageName))) {
            UserManagerService.checkSystemOrRoot("get application restrictions for other users/apps");
        }
        Object object = this.mPackagesLock;
        synchronized (object) {
            return this.readApplicationRestrictionsLP(packageName, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setApplicationRestrictions(String packageName, Bundle restrictions, int userId) {
        UserManagerService.checkSystemOrRoot("set application restrictions");
        if (restrictions != null) {
            restrictions.setDefusable(true);
        }
        Object object = this.mPackagesLock;
        synchronized (object) {
            if (restrictions == null || restrictions.isEmpty()) {
                this.cleanAppRestrictionsForPackage(packageName, userId);
            } else {
                this.writeApplicationRestrictionsLP(packageName, restrictions, userId);
            }
        }
        Intent changeIntent = new Intent("android.intent.action.APPLICATION_RESTRICTIONS_CHANGED");
        changeIntent.setPackage(packageName);
        changeIntent.addFlags(0x40000000);
        this.mContext.sendBroadcastAsUser(changeIntent, UserHandle.of(userId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUidForPackage(String packageName) {
        long ident = Binder.clearCallingIdentity();
        try {
            int n = this.mContext.getPackageManager().getApplicationInfo((String)packageName, (int)8192).uid;
            return n;
        }
        catch (PackageManager.NameNotFoundException nnfe) {
            int n = -1;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private Bundle readApplicationRestrictionsLP(String packageName, int userId) {
        AtomicFile restrictionsFile = new AtomicFile(new File(Environment.getUserSystemDirectory(userId), this.packageToRestrictionsFileName(packageName)));
        return UserManagerService.readApplicationRestrictionsLP(restrictionsFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Bundle readApplicationRestrictionsLP(AtomicFile restrictionsFile) {
        Bundle restrictions = new Bundle();
        ArrayList<String> values = new ArrayList<String>();
        if (!restrictionsFile.getBaseFile().exists()) {
            return restrictions;
        }
        FileInputStream fis = null;
        try {
            fis = restrictionsFile.openRead();
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(fis, StandardCharsets.UTF_8.name());
            XmlUtils.nextElement(parser);
            if (parser.getEventType() != 2) {
                Slog.e(LOG_TAG, "Unable to read restrictions file " + restrictionsFile.getBaseFile());
                Bundle bundle = restrictions;
                return bundle;
            }
            while (parser.next() != 1) {
                UserManagerService.readEntry(restrictions, values, parser);
            }
        }
        catch (IOException | XmlPullParserException e) {
            Log.w(LOG_TAG, "Error parsing " + restrictionsFile.getBaseFile(), e);
        }
        finally {
            IoUtils.closeQuietly(fis);
        }
        return restrictions;
    }

    private static void readEntry(Bundle restrictions, ArrayList<String> values, XmlPullParser parser) throws XmlPullParserException, IOException {
        int type = parser.getEventType();
        if (type == 2 && parser.getName().equals(TAG_ENTRY)) {
            String key = parser.getAttributeValue(null, ATTR_KEY);
            String valType = parser.getAttributeValue(null, ATTR_VALUE_TYPE);
            String multiple = parser.getAttributeValue(null, ATTR_MULTIPLE);
            if (multiple != null) {
                values.clear();
                int count = Integer.parseInt(multiple);
                while (count > 0 && (type = parser.next()) != 1) {
                    if (type != 2 || !parser.getName().equals(TAG_VALUE)) continue;
                    values.add(parser.nextText().trim());
                    --count;
                }
                String[] valueStrings = new String[values.size()];
                values.toArray(valueStrings);
                restrictions.putStringArray(key, valueStrings);
            } else if (ATTR_TYPE_BUNDLE.equals(valType)) {
                restrictions.putBundle(key, UserManagerService.readBundleEntry(parser, values));
            } else if (ATTR_TYPE_BUNDLE_ARRAY.equals(valType)) {
                int outerDepth = parser.getDepth();
                ArrayList<Bundle> bundleList = new ArrayList<Bundle>();
                while (XmlUtils.nextElementWithin(parser, outerDepth)) {
                    Bundle childBundle = UserManagerService.readBundleEntry(parser, values);
                    bundleList.add(childBundle);
                }
                restrictions.putParcelableArray(key, bundleList.toArray(new Bundle[bundleList.size()]));
            } else {
                String value = parser.nextText().trim();
                if (ATTR_TYPE_BOOLEAN.equals(valType)) {
                    restrictions.putBoolean(key, Boolean.parseBoolean(value));
                } else if (ATTR_TYPE_INTEGER.equals(valType)) {
                    restrictions.putInt(key, Integer.parseInt(value));
                } else {
                    restrictions.putString(key, value);
                }
            }
        }
    }

    private static Bundle readBundleEntry(XmlPullParser parser, ArrayList<String> values) throws IOException, XmlPullParserException {
        Bundle childBundle = new Bundle();
        int outerDepth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, outerDepth)) {
            UserManagerService.readEntry(childBundle, values, parser);
        }
        return childBundle;
    }

    private void writeApplicationRestrictionsLP(String packageName, Bundle restrictions, int userId) {
        AtomicFile restrictionsFile = new AtomicFile(new File(Environment.getUserSystemDirectory(userId), this.packageToRestrictionsFileName(packageName)));
        UserManagerService.writeApplicationRestrictionsLP(restrictions, restrictionsFile);
    }

    static void writeApplicationRestrictionsLP(Bundle restrictions, AtomicFile restrictionsFile) {
        FileOutputStream fos = null;
        try {
            fos = restrictionsFile.startWrite();
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput(bos, StandardCharsets.UTF_8.name());
            serializer.startDocument(null, true);
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            serializer.startTag(null, TAG_RESTRICTIONS);
            UserManagerService.writeBundle(restrictions, serializer);
            serializer.endTag(null, TAG_RESTRICTIONS);
            serializer.endDocument();
            restrictionsFile.finishWrite(fos);
        }
        catch (Exception e) {
            restrictionsFile.failWrite(fos);
            Slog.e(LOG_TAG, "Error writing application restrictions list", e);
        }
    }

    private static void writeBundle(Bundle restrictions, XmlSerializer serializer) throws IOException {
        for (String key : restrictions.keySet()) {
            Object value = restrictions.get(key);
            serializer.startTag(null, TAG_ENTRY);
            serializer.attribute(null, ATTR_KEY, key);
            if (value instanceof Boolean) {
                serializer.attribute(null, ATTR_VALUE_TYPE, ATTR_TYPE_BOOLEAN);
                serializer.text(value.toString());
            } else if (value instanceof Integer) {
                serializer.attribute(null, ATTR_VALUE_TYPE, ATTR_TYPE_INTEGER);
                serializer.text(value.toString());
            } else if (value == null || value instanceof String) {
                serializer.attribute(null, ATTR_VALUE_TYPE, ATTR_TYPE_STRING);
                serializer.text(value != null ? (String)value : "");
            } else if (value instanceof Bundle) {
                serializer.attribute(null, ATTR_VALUE_TYPE, ATTR_TYPE_BUNDLE);
                UserManagerService.writeBundle((Bundle)value, serializer);
            } else if (value instanceof Parcelable[]) {
                serializer.attribute(null, ATTR_VALUE_TYPE, ATTR_TYPE_BUNDLE_ARRAY);
                Parcelable[] array2 = (Parcelable[])value;
                for (Parcelable parcelable : array2) {
                    if (!(parcelable instanceof Bundle)) {
                        throw new IllegalArgumentException("bundle-array can only hold Bundles");
                    }
                    serializer.startTag(null, TAG_ENTRY);
                    serializer.attribute(null, ATTR_VALUE_TYPE, ATTR_TYPE_BUNDLE);
                    UserManagerService.writeBundle((Bundle)parcelable, serializer);
                    serializer.endTag(null, TAG_ENTRY);
                }
            } else {
                serializer.attribute(null, ATTR_VALUE_TYPE, ATTR_TYPE_STRING_ARRAY);
                String[] values = (String[])value;
                serializer.attribute(null, ATTR_MULTIPLE, Integer.toString(values.length));
                for (String choice : values) {
                    serializer.startTag(null, TAG_VALUE);
                    serializer.text((String)(choice != null ? choice : ""));
                    serializer.endTag(null, TAG_VALUE);
                }
            }
            serializer.endTag(null, TAG_ENTRY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUserSerialNumber(int userHandle) {
        Object object = this.mUsersLock;
        synchronized (object) {
            if (!this.exists(userHandle)) {
                return -1;
            }
            return this.getUserInfoLU((int)userHandle).serialNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUserHandle(int userSerialNumber) {
        Object object = this.mUsersLock;
        synchronized (object) {
            for (int userId : this.mUserIds) {
                UserInfo info = this.getUserInfoLU(userId);
                if (info == null || info.serialNumber != userSerialNumber) continue;
                return userId;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getUserCreationTime(int userHandle) {
        int callingUserId = UserHandle.getCallingUserId();
        UserInfo userInfo = null;
        Object object = this.mUsersLock;
        synchronized (object) {
            if (callingUserId == userHandle) {
                userInfo = this.getUserInfoLU(userHandle);
            } else {
                UserInfo parent = this.getProfileParentLU(userHandle);
                if (parent != null && parent.id == callingUserId) {
                    userInfo = this.getUserInfoLU(userHandle);
                }
            }
        }
        if (userInfo == null) {
            throw new SecurityException("userHandle can only be the calling user or a managed profile associated with this user");
        }
        return userInfo.creationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUserIds() {
        int num = 0;
        Object object = this.mUsersLock;
        synchronized (object) {
            int userSize = this.mUsers.size();
            for (int i = 0; i < userSize; ++i) {
                if (this.mUsers.valueAt((int)i).info.partial) continue;
                ++num;
            }
            int[] newUsers = new int[num];
            int n = 0;
            for (int i = 0; i < userSize; ++i) {
                if (this.mUsers.valueAt((int)i).info.partial) continue;
                newUsers[n++] = this.mUsers.keyAt(i);
            }
            this.mUserIds = newUsers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBeforeStartUser(int userId) {
        int userSerial = this.getUserSerialNumber(userId);
        this.mPm.prepareUserData(userId, userSerial, 1);
        this.mPm.reconcileAppsData(userId, 1);
        if (userId != 0) {
            Object object = this.mRestrictionsLock;
            synchronized (object) {
                this.applyUserRestrictionsLR(userId);
            }
        }
        this.maybeInitializeDemoMode(userId);
    }

    public void onBeforeUnlockUser(int userId) {
        int userSerial = this.getUserSerialNumber(userId);
        this.mPm.prepareUserData(userId, userSerial, 2);
        this.mPm.reconcileAppsData(userId, 2);
    }

    public void onUserLoggedIn(int userId) {
        UserData userData = this.getUserDataNoChecks(userId);
        if (userData == null || userData.info.partial) {
            Slog.w(LOG_TAG, "userForeground: unknown user #" + userId);
            return;
        }
        long now = System.currentTimeMillis();
        if (now > 946080000000L) {
            userData.info.lastLoggedInTime = now;
        }
        userData.info.lastLoggedInFingerprint = Build.FINGERPRINT;
        this.scheduleWriteUser(userData);
    }

    private void maybeInitializeDemoMode(int userId) {
        String demoLauncher;
        if (UserManager.isDeviceInDemoMode(this.mContext) && userId != 0 && !TextUtils.isEmpty(demoLauncher = this.mContext.getResources().getString(17039474))) {
            ComponentName componentToEnable = ComponentName.unflattenFromString(demoLauncher);
            String demoLauncherPkg = componentToEnable.getPackageName();
            try {
                IPackageManager iPm = AppGlobals.getPackageManager();
                iPm.setComponentEnabledSetting(componentToEnable, 1, 0, userId);
                iPm.setApplicationEnabledSetting(demoLauncherPkg, 1, 0, userId, null);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextAvailableId() {
        Object object = this.mUsersLock;
        synchronized (object) {
            for (int i = 10; i < 21474; ++i) {
                if (this.mUsers.indexOfKey(i) >= 0 || this.mRemovingUserIds.get(i)) continue;
                return i;
            }
        }
        throw new IllegalStateException("No user id available!");
    }

    private String packageToRestrictionsFileName(String packageName) {
        return RESTRICTIONS_FILE_PREFIX + packageName + XML_SUFFIX;
    }

    public static void enforceSerialNumber(File file, int serialNumber) throws IOException {
        if (StorageManager.isFileEncryptedEmulatedOnly()) {
            Slog.w(LOG_TAG, "Device is emulating FBE; assuming current serial number is valid");
            return;
        }
        int foundSerial = UserManagerService.getSerialNumber(file);
        Slog.v(LOG_TAG, "Found " + file + " with serial number " + foundSerial);
        if (foundSerial == -1) {
            Slog.d(LOG_TAG, "Serial number missing on " + file + "; assuming current is valid");
            try {
                UserManagerService.setSerialNumber(file, serialNumber);
            }
            catch (IOException e) {
                Slog.w(LOG_TAG, "Failed to set serial number on " + file, e);
            }
        } else if (foundSerial != serialNumber) {
            throw new IOException("Found serial number " + foundSerial + " doesn't match expected " + serialNumber);
        }
    }

    private static void setSerialNumber(File file, int serialNumber) throws IOException {
        try {
            byte[] buf = Integer.toString(serialNumber).getBytes(StandardCharsets.UTF_8);
            Os.setxattr(file.getAbsolutePath(), XATTR_SERIAL, buf, OsConstants.XATTR_CREATE);
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    private static int getSerialNumber(File file) throws IOException {
        try {
            byte[] buf = new byte[256];
            int len = Os.getxattr(file.getAbsolutePath(), XATTR_SERIAL, buf);
            String serial = new String(buf, 0, len);
            try {
                return Integer.parseInt(serial);
            }
            catch (NumberFormatException e) {
                throw new IOException("Bad serial number: " + serial);
            }
        }
        catch (ErrnoException e) {
            if (e.errno == OsConstants.ENODATA) {
                return -1;
            }
            throw e.rethrowAsIOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSeedAccountData(int userId, String accountName, String accountType, PersistableBundle accountOptions, boolean persist) {
        UserManagerService.checkManageUsersPermission("Require MANAGE_USERS permission to set user seed data");
        Object object = this.mPackagesLock;
        synchronized (object) {
            UserData userData;
            Object object2 = this.mUsersLock;
            synchronized (object2) {
                userData = this.getUserDataLU(userId);
                if (userData == null) {
                    Slog.e(LOG_TAG, "No such user for settings seed data u=" + userId);
                    return;
                }
                userData.seedAccountName = accountName;
                userData.seedAccountType = accountType;
                userData.seedAccountOptions = accountOptions;
                userData.persistSeedData = persist;
            }
            if (persist) {
                this.writeUserLP(userData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSeedAccountName() throws RemoteException {
        UserManagerService.checkManageUsersPermission("Cannot get seed account information");
        Object object = this.mUsersLock;
        synchronized (object) {
            UserData userData = this.getUserDataLU(UserHandle.getCallingUserId());
            return userData.seedAccountName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSeedAccountType() throws RemoteException {
        UserManagerService.checkManageUsersPermission("Cannot get seed account information");
        Object object = this.mUsersLock;
        synchronized (object) {
            UserData userData = this.getUserDataLU(UserHandle.getCallingUserId());
            return userData.seedAccountType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersistableBundle getSeedAccountOptions() throws RemoteException {
        UserManagerService.checkManageUsersPermission("Cannot get seed account information");
        Object object = this.mUsersLock;
        synchronized (object) {
            UserData userData = this.getUserDataLU(UserHandle.getCallingUserId());
            return userData.seedAccountOptions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearSeedAccountData() throws RemoteException {
        UserManagerService.checkManageUsersPermission("Cannot clear seed account information");
        Object object = this.mPackagesLock;
        synchronized (object) {
            UserData userData;
            Object object2 = this.mUsersLock;
            synchronized (object2) {
                userData = this.getUserDataLU(UserHandle.getCallingUserId());
                if (userData == null) {
                    return;
                }
                userData.clearSeedAccountData();
            }
            this.writeUserLP(userData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean someUserHasSeedAccount(String accountName, String accountType) throws RemoteException {
        UserManagerService.checkManageUsersPermission("Cannot check seed account information");
        Object object = this.mUsersLock;
        synchronized (object) {
            int userSize = this.mUsers.size();
            for (int i = 0; i < userSize; ++i) {
                UserData data = this.mUsers.valueAt(i);
                if (data.info.isInitialized() || data.seedAccountName == null || !data.seedAccountName.equals(accountName) || data.seedAccountType == null || !data.seedAccountType.equals(accountType)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ResultReceiver resultReceiver) {
        new Shell().exec(this, in, out, err, args, resultReceiver);
    }

    int onShellCommand(Shell shell, String cmd) {
        if (cmd == null) {
            return shell.handleDefaultCommands(cmd);
        }
        PrintWriter pw = shell.getOutPrintWriter();
        try {
            switch (cmd) {
                case "list": {
                    return this.runList(pw);
                }
            }
        }
        catch (RemoteException e) {
            pw.println("Remote exception: " + e);
        }
        return -1;
    }

    private int runList(PrintWriter pw) throws RemoteException {
        IActivityManager am = ActivityManagerNative.getDefault();
        List<UserInfo> users = this.getUsers(false);
        if (users == null) {
            pw.println("Error: couldn't get users");
            return 1;
        }
        pw.println("Users:");
        for (int i = 0; i < users.size(); ++i) {
            String running = am.isUserRunning(users.get((int)i).id, 0) ? " running" : "";
            pw.println("\t" + users.get(i).toString() + running);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump UserManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
            return;
        }
        long now = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        Object object = this.mPackagesLock;
        synchronized (object) {
            Object object2 = this.mUsersLock;
            synchronized (object2) {
                pw.println("Users:");
                for (int i = 0; i < this.mUsers.size(); ++i) {
                    UserData userData = this.mUsers.valueAt(i);
                    if (userData == null) continue;
                    UserInfo userInfo = userData.info;
                    int userId = userInfo.id;
                    pw.print("  ");
                    pw.print(userInfo);
                    pw.print(" serialNo=");
                    pw.print(userInfo.serialNumber);
                    if (this.mRemovingUserIds.get(userId)) {
                        pw.print(" <removing> ");
                    }
                    if (userInfo.partial) {
                        pw.print(" <partial>");
                    }
                    pw.println();
                    pw.print("    Created: ");
                    if (userInfo.creationTime == 0L) {
                        pw.println("<unknown>");
                    } else {
                        sb.setLength(0);
                        TimeUtils.formatDuration(now - userInfo.creationTime, sb);
                        sb.append(" ago");
                        pw.println(sb);
                    }
                    pw.print("    Last logged in: ");
                    if (userInfo.lastLoggedInTime == 0L) {
                        pw.println("<unknown>");
                    } else {
                        sb.setLength(0);
                        TimeUtils.formatDuration(now - userInfo.lastLoggedInTime, sb);
                        sb.append(" ago");
                        pw.println(sb);
                    }
                    pw.print("    Last logged in fingerprint: ");
                    pw.println(userInfo.lastLoggedInFingerprint);
                    pw.print("    Has profile owner: ");
                    pw.println(this.mIsUserManaged.get(userId));
                    pw.println("    Restrictions:");
                    Object object3 = this.mRestrictionsLock;
                    synchronized (object3) {
                        UserRestrictionsUtils.dumpRestrictions(pw, "      ", this.mBaseUserRestrictions.get(userInfo.id));
                        pw.println("    Device policy local restrictions:");
                        UserRestrictionsUtils.dumpRestrictions(pw, "      ", this.mDevicePolicyLocalUserRestrictions.get(userInfo.id));
                        pw.println("    Effective restrictions:");
                        UserRestrictionsUtils.dumpRestrictions(pw, "      ", this.mCachedEffectiveUserRestrictions.get(userInfo.id));
                    }
                    if (userData.account != null) {
                        pw.print("    Account name: " + userData.account);
                        pw.println();
                    }
                    if (userData.seedAccountName == null) continue;
                    pw.print("    Seed account name: " + userData.seedAccountName);
                    pw.println();
                    if (userData.seedAccountType != null) {
                        pw.print("         account type: " + userData.seedAccountType);
                        pw.println();
                    }
                    if (userData.seedAccountOptions == null) continue;
                    pw.print("         account options exist");
                    pw.println();
                }
            }
            pw.println();
            pw.println("  Device policy global restrictions:");
            object2 = this.mRestrictionsLock;
            synchronized (object2) {
                UserRestrictionsUtils.dumpRestrictions(pw, "    ", this.mDevicePolicyGlobalUserRestrictions);
            }
            pw.println();
            pw.println("  Global restrictions owner id:" + this.mGlobalRestrictionOwnerUserId);
            pw.println();
            pw.println("  Guest restrictions:");
            object2 = this.mGuestRestrictions;
            synchronized (object2) {
                UserRestrictionsUtils.dumpRestrictions(pw, "    ", this.mGuestRestrictions);
            }
            object2 = this.mUsersLock;
            synchronized (object2) {
                pw.println();
                pw.println("  Device managed: " + this.mIsDeviceManaged);
            }
            object2 = this.mUserStates;
            synchronized (object2) {
                pw.println("  Started users state: " + this.mUserStates);
            }
            pw.println();
            pw.println("  Max users: " + UserManager.getMaxSupportedUsers());
            pw.println("  Supports switchable users: " + UserManager.supportsMultipleUsers());
            pw.println("  All guests ephemeral: " + Resources.getSystem().getBoolean(17957035));
        }
    }

    boolean isInitialized(int userId) {
        return (this.getUserInfo((int)userId).flags & 0x10) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNonSystemUsers() {
        ArrayList<UserInfo> usersToRemove = new ArrayList<UserInfo>();
        Iterator iterator = this.mUsersLock;
        synchronized (iterator) {
            int userSize = this.mUsers.size();
            for (int i = 0; i < userSize; ++i) {
                UserInfo ui = this.mUsers.valueAt((int)i).info;
                if (ui.id == 0) continue;
                usersToRemove.add(ui);
            }
        }
        for (UserInfo ui : usersToRemove) {
            this.removeUser(ui.id);
        }
    }

    private static void debug(String message) {
        Log.d(LOG_TAG, message + "");
    }

    private class Shell
    extends ShellCommand {
        private Shell() {
        }

        @Override
        public int onCommand(String cmd) {
            return UserManagerService.this.onShellCommand(this, cmd);
        }

        @Override
        public void onHelp() {
            PrintWriter pw = this.getOutPrintWriter();
            pw.println("User manager (user) commands:");
            pw.println("  help");
            pw.println("    Print this help text.");
            pw.println("");
            pw.println("  list");
            pw.println("    Prints all users on the system.");
        }
    }

    private class LocalService
    extends UserManagerInternal {
        private LocalService() {
        }

        @Override
        public void setDevicePolicyUserRestrictions(int userId, Bundle localRestrictions, Bundle globalRestrictions) {
            UserManagerService.this.setDevicePolicyUserRestrictionsInner(userId, localRestrictions, globalRestrictions);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Bundle getBaseUserRestrictions(int userId) {
            Object object = UserManagerService.this.mRestrictionsLock;
            synchronized (object) {
                return (Bundle)UserManagerService.this.mBaseUserRestrictions.get(userId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setBaseUserRestrictionsByDpmsForMigration(int userId, Bundle baseRestrictions) {
            Object object = UserManagerService.this.mRestrictionsLock;
            synchronized (object) {
                UserManagerService.this.mBaseUserRestrictions.put(userId, new Bundle(baseRestrictions));
                UserManagerService.this.invalidateEffectiveUserRestrictionsLR(userId);
            }
            UserData userData = UserManagerService.this.getUserDataNoChecks(userId);
            Object object2 = UserManagerService.this.mPackagesLock;
            synchronized (object2) {
                if (userData != null) {
                    UserManagerService.this.writeUserLP(userData);
                } else {
                    Slog.w(UserManagerService.LOG_TAG, "UserInfo not found for " + userId);
                }
            }
        }

        @Override
        public boolean getUserRestriction(int userId, String key) {
            return UserManagerService.this.getUserRestrictions(userId).getBoolean(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addUserRestrictionsListener(UserManagerInternal.UserRestrictionsListener listener) {
            ArrayList arrayList = UserManagerService.this.mUserRestrictionsListeners;
            synchronized (arrayList) {
                UserManagerService.this.mUserRestrictionsListeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeUserRestrictionsListener(UserManagerInternal.UserRestrictionsListener listener) {
            ArrayList arrayList = UserManagerService.this.mUserRestrictionsListeners;
            synchronized (arrayList) {
                UserManagerService.this.mUserRestrictionsListeners.remove(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setDeviceManaged(boolean isManaged) {
            Object object = UserManagerService.this.mUsersLock;
            synchronized (object) {
                UserManagerService.this.mIsDeviceManaged = isManaged;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setUserManaged(int userId, boolean isManaged) {
            Object object = UserManagerService.this.mUsersLock;
            synchronized (object) {
                UserManagerService.this.mIsUserManaged.put(userId, isManaged);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setUserIcon(int userId, Bitmap bitmap) {
            long ident = Binder.clearCallingIdentity();
            try {
                Object object = UserManagerService.this.mPackagesLock;
                synchronized (object) {
                    UserData userData;
                    block8: {
                        userData = UserManagerService.this.getUserDataNoChecks(userId);
                        if (userData != null && !userData.info.partial) break block8;
                        Slog.w(UserManagerService.LOG_TAG, "setUserIcon: unknown user #" + userId);
                        return;
                    }
                    UserManagerService.this.writeBitmapLP(userData.info, bitmap);
                    UserManagerService.this.writeUserLP(userData);
                }
                UserManagerService.this.sendUserInfoChangedBroadcast(userId);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setForceEphemeralUsers(boolean forceEphemeralUsers) {
            Object object = UserManagerService.this.mUsersLock;
            synchronized (object) {
                UserManagerService.this.mForceEphemeralUsers = forceEphemeralUsers;
            }
        }

        @Override
        public void removeAllUsers() {
            if (0 == ActivityManager.getCurrentUser()) {
                UserManagerService.this.removeNonSystemUsers();
            } else {
                BroadcastReceiver userSwitchedReceiver = new BroadcastReceiver(){

                    @Override
                    public void onReceive(Context context, Intent intent) {
                        int userId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
                        if (userId != 0) {
                            return;
                        }
                        UserManagerService.this.mContext.unregisterReceiver(this);
                        UserManagerService.this.removeNonSystemUsers();
                    }
                };
                IntentFilter userSwitchedFilter = new IntentFilter();
                userSwitchedFilter.addAction("android.intent.action.USER_SWITCHED");
                UserManagerService.this.mContext.registerReceiver(userSwitchedReceiver, userSwitchedFilter, null, UserManagerService.this.mHandler);
                ActivityManager am = (ActivityManager)UserManagerService.this.mContext.getSystemService("activity");
                am.switchUser(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEphemeralUserStop(int userId) {
            Object object = UserManagerService.this.mUsersLock;
            synchronized (object) {
                UserInfo userInfo = UserManagerService.this.getUserInfoLU(userId);
                if (userInfo != null && userInfo.isEphemeral()) {
                    userInfo.flags |= 0x40;
                    if (userInfo.isGuest()) {
                        userInfo.guestToRemove = true;
                    }
                }
            }
        }

        @Override
        public UserInfo createUserEvenWhenDisallowed(String name, int flags) {
            UserInfo user = UserManagerService.this.createUserInternalUnchecked(name, flags, -10000);
            if (user != null && !user.isAdmin()) {
                UserManagerService.this.setUserRestriction("no_sms", true, user.id);
                UserManagerService.this.setUserRestriction("no_outgoing_calls", true, user.id);
            }
            return user;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isUserRunning(int userId) {
            SparseIntArray sparseIntArray = UserManagerService.this.mUserStates;
            synchronized (sparseIntArray) {
                return UserManagerService.this.mUserStates.get(userId, -1) >= 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setUserState(int userId, int userState) {
            SparseIntArray sparseIntArray = UserManagerService.this.mUserStates;
            synchronized (sparseIntArray) {
                UserManagerService.this.mUserStates.put(userId, userState);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeUserState(int userId) {
            SparseIntArray sparseIntArray = UserManagerService.this.mUserStates;
            synchronized (sparseIntArray) {
                UserManagerService.this.mUserStates.delete(userId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isUserUnlockingOrUnlocked(int userId) {
            SparseIntArray sparseIntArray = UserManagerService.this.mUserStates;
            synchronized (sparseIntArray) {
                int state = UserManagerService.this.mUserStates.get(userId, -1);
                return state == 2 || state == 3;
            }
        }
    }

    final class MainHandler
    extends Handler {
        MainHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.removeMessages(1, msg.obj);
                    Object object = UserManagerService.this.mPackagesLock;
                    synchronized (object) {
                        int userId = ((UserData)msg.obj).info.id;
                        UserData userData = UserManagerService.this.getUserDataNoChecks(userId);
                        if (userData != null) {
                            UserManagerService.this.writeUserLP(userData);
                        }
                        break;
                    }
                }
            }
        }
    }

    public static class LifeCycle
    extends SystemService {
        private UserManagerService mUms;

        public LifeCycle(Context context) {
            super(context);
        }

        @Override
        public void onStart() {
            this.mUms = UserManagerService.getInstance();
            this.publishBinderService(UserManagerService.TAG_USER, this.mUms);
        }

        @Override
        public void onBootPhase(int phase) {
            if (phase == 550) {
                this.mUms.cleanupPartialUsers();
            }
        }
    }

    private static class UserData {
        UserInfo info;
        String account;
        String seedAccountName;
        String seedAccountType;
        PersistableBundle seedAccountOptions;
        boolean persistSeedData;

        private UserData() {
        }

        void clearSeedAccountData() {
            this.seedAccountName = null;
            this.seedAccountType = null;
            this.seedAccountOptions = null;
            this.persistSeedData = false;
        }
    }
}

