/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.policy;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.WindowManagerPolicy;
import android.widget.OverScroller;

public class SystemGesturesPointerEventListener
implements WindowManagerPolicy.PointerEventListener {
    private static final String TAG = "SystemGestures";
    private static final boolean DEBUG = false;
    private static final long SWIPE_TIMEOUT_MS = 500L;
    private static final int MAX_TRACKED_POINTERS = 32;
    private static final int UNTRACKED_POINTER = -1;
    private static final int MAX_FLING_TIME_MILLIS = 5000;
    private static final int SWIPE_NONE = 0;
    private static final int SWIPE_FROM_TOP = 1;
    private static final int SWIPE_FROM_BOTTOM = 2;
    private static final int SWIPE_FROM_RIGHT = 3;
    private static final int SWIPE_FROM_LEFT = 4;
    private final Context mContext;
    private final int mSwipeStartThreshold;
    private final int mSwipeDistanceThreshold;
    private final Callbacks mCallbacks;
    private final int[] mDownPointerId = new int[32];
    private final float[] mDownX = new float[32];
    private final float[] mDownY = new float[32];
    private final long[] mDownTime = new long[32];
    private GestureDetector mGestureDetector;
    private OverScroller mOverscroller;
    int screenHeight;
    int screenWidth;
    private int mDownPointers;
    private boolean mSwipeFireable;
    private boolean mDebugFireable;
    private boolean mMouseHoveringAtEdge;
    private long mLastFlingTime;

    public SystemGesturesPointerEventListener(Context context, Callbacks callbacks) {
        this.mContext = context;
        this.mCallbacks = SystemGesturesPointerEventListener.checkNull("callbacks", callbacks);
        this.mSwipeDistanceThreshold = this.mSwipeStartThreshold = SystemGesturesPointerEventListener.checkNull("context", context).getResources().getDimensionPixelSize(17104919);
    }

    private static <T> T checkNull(String name, T arg) {
        if (arg == null) {
            throw new IllegalArgumentException(name + " must not be null");
        }
        return arg;
    }

    public void systemReady() {
        Handler h = new Handler(Looper.myLooper());
        this.mGestureDetector = new GestureDetector(this.mContext, new FlingGestureDetector(), h);
        this.mOverscroller = new OverScroller(this.mContext);
    }

    @Override
    public void onPointerEvent(MotionEvent event) {
        if (this.mGestureDetector != null && event.isTouchEvent()) {
            this.mGestureDetector.onTouchEvent(event);
        }
        switch (event.getActionMasked()) {
            case 0: {
                this.mSwipeFireable = true;
                this.mDebugFireable = true;
                this.mDownPointers = 0;
                this.captureDown(event, 0);
                if (this.mMouseHoveringAtEdge) {
                    this.mMouseHoveringAtEdge = false;
                    this.mCallbacks.onMouseLeaveFromEdge();
                }
                this.mCallbacks.onDown();
                break;
            }
            case 5: {
                this.captureDown(event, event.getActionIndex());
                if (!this.mDebugFireable) break;
                boolean bl = this.mDebugFireable = event.getPointerCount() < 5;
                if (this.mDebugFireable) break;
                this.mCallbacks.onDebug();
                break;
            }
            case 2: {
                if (!this.mSwipeFireable) break;
                int swipe = this.detectSwipe(event);
                boolean bl = this.mSwipeFireable = swipe == 0;
                if (swipe == 1) {
                    this.mCallbacks.onSwipeFromTop();
                    break;
                }
                if (swipe == 2) {
                    this.mCallbacks.onSwipeFromBottom();
                    break;
                }
                if (swipe == 3) {
                    this.mCallbacks.onSwipeFromRight();
                    break;
                }
                if (swipe != 4) break;
                this.mCallbacks.onSwipeFromLeft();
                break;
            }
            case 7: {
                if (!event.isFromSource(8194)) break;
                if (!this.mMouseHoveringAtEdge && event.getY() == 0.0f) {
                    this.mCallbacks.onMouseHoverAtTop();
                    this.mMouseHoveringAtEdge = true;
                    break;
                }
                if (!this.mMouseHoveringAtEdge && event.getY() >= (float)(this.screenHeight - 1)) {
                    this.mCallbacks.onMouseHoverAtBottom();
                    this.mMouseHoveringAtEdge = true;
                    break;
                }
                if (!this.mMouseHoveringAtEdge || !(event.getY() > 0.0f) || !(event.getY() < (float)(this.screenHeight - 1))) break;
                this.mCallbacks.onMouseLeaveFromEdge();
                this.mMouseHoveringAtEdge = false;
                break;
            }
            case 1: 
            case 3: {
                this.mSwipeFireable = false;
                this.mDebugFireable = false;
                this.mCallbacks.onUpOrCancel();
                break;
            }
        }
    }

    private void captureDown(MotionEvent event, int pointerIndex) {
        int pointerId = event.getPointerId(pointerIndex);
        int i = this.findIndex(pointerId);
        if (i != -1) {
            this.mDownX[i] = event.getX(pointerIndex);
            this.mDownY[i] = event.getY(pointerIndex);
            this.mDownTime[i] = event.getEventTime();
        }
    }

    private int findIndex(int pointerId) {
        for (int i = 0; i < this.mDownPointers; ++i) {
            if (this.mDownPointerId[i] != pointerId) continue;
            return i;
        }
        if (this.mDownPointers == 32 || pointerId == -1) {
            return -1;
        }
        this.mDownPointerId[this.mDownPointers++] = pointerId;
        return this.mDownPointers - 1;
    }

    private int detectSwipe(MotionEvent move) {
        int historySize = move.getHistorySize();
        int pointerCount = move.getPointerCount();
        for (int p = 0; p < pointerCount; ++p) {
            int pointerId = move.getPointerId(p);
            int i = this.findIndex(pointerId);
            if (i == -1) continue;
            for (int h = 0; h < historySize; ++h) {
                float y;
                float x;
                long time = move.getHistoricalEventTime(h);
                int swipe = this.detectSwipe(i, time, x = move.getHistoricalX(p, h), y = move.getHistoricalY(p, h));
                if (swipe == 0) continue;
                return swipe;
            }
            int swipe = this.detectSwipe(i, move.getEventTime(), move.getX(p), move.getY(p));
            if (swipe == 0) continue;
            return swipe;
        }
        return 0;
    }

    private int detectSwipe(int i, long time, float x, float y) {
        float fromX = this.mDownX[i];
        float fromY = this.mDownY[i];
        long elapsed = time - this.mDownTime[i];
        if (fromY <= (float)this.mSwipeStartThreshold && y > fromY + (float)this.mSwipeDistanceThreshold && elapsed < 500L) {
            return 1;
        }
        if (fromY >= (float)(this.screenHeight - this.mSwipeStartThreshold) && y < fromY - (float)this.mSwipeDistanceThreshold && elapsed < 500L) {
            return 2;
        }
        if (fromX >= (float)(this.screenWidth - this.mSwipeStartThreshold) && x < fromX - (float)this.mSwipeDistanceThreshold && elapsed < 500L) {
            return 3;
        }
        if (fromX <= (float)this.mSwipeStartThreshold && x > fromX + (float)this.mSwipeDistanceThreshold && elapsed < 500L) {
            return 4;
        }
        return 0;
    }

    static interface Callbacks {
        public void onSwipeFromTop();

        public void onSwipeFromBottom();

        public void onSwipeFromRight();

        public void onSwipeFromLeft();

        public void onFling(int var1);

        public void onDown();

        public void onUpOrCancel();

        public void onMouseHoverAtTop();

        public void onMouseHoverAtBottom();

        public void onMouseLeaveFromEdge();

        public void onDebug();
    }

    private final class FlingGestureDetector
    extends GestureDetector.SimpleOnGestureListener {
        private FlingGestureDetector() {
        }

        @Override
        public boolean onSingleTapUp(MotionEvent e) {
            if (!SystemGesturesPointerEventListener.this.mOverscroller.isFinished()) {
                SystemGesturesPointerEventListener.this.mOverscroller.forceFinished(true);
            }
            return true;
        }

        @Override
        public boolean onFling(MotionEvent down, MotionEvent up, float velocityX, float velocityY) {
            SystemGesturesPointerEventListener.this.mOverscroller.computeScrollOffset();
            long now = SystemClock.uptimeMillis();
            if (SystemGesturesPointerEventListener.this.mLastFlingTime != 0L && now > SystemGesturesPointerEventListener.this.mLastFlingTime + 5000L) {
                SystemGesturesPointerEventListener.this.mOverscroller.forceFinished(true);
            }
            SystemGesturesPointerEventListener.this.mOverscroller.fling(0, 0, (int)velocityX, (int)velocityY, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
            int duration = SystemGesturesPointerEventListener.this.mOverscroller.getDuration();
            if (duration > 5000) {
                duration = 5000;
            }
            SystemGesturesPointerEventListener.this.mLastFlingTime = now;
            SystemGesturesPointerEventListener.this.mCallbacks.onFling(duration);
            return true;
        }
    }
}

