/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.retaildemo;

import android.app.ActivityManagerInternal;
import android.app.ActivityManagerNative;
import android.app.AppGlobals;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.RetailDemoModeServiceInternal;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.content.res.Configuration;
import android.database.ContentObserver;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.CallLog;
import android.provider.Settings;
import android.util.KeyValueListParser;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.os.BackgroundThread;
import com.android.internal.widget.LockPatternUtils;
import com.android.server.LocalServices;
import com.android.server.ServiceThread;
import com.android.server.SystemService;
import com.android.server.am.ActivityManagerService;
import com.android.server.retaildemo.PreloadAppsInstaller;
import com.android.server.retaildemo.UserInactivityCountdownDialog;
import java.io.File;
import java.util.ArrayList;

public class RetailDemoModeService
extends SystemService {
    private static final boolean DEBUG = false;
    private static final String TAG = RetailDemoModeService.class.getSimpleName();
    private static final String DEMO_USER_NAME = "Demo";
    private static final String ACTION_RESET_DEMO = "com.android.server.retaildemo.ACTION_RESET_DEMO";
    private static final String SYSTEM_PROPERTY_RETAIL_DEMO_ENABLED = "sys.retaildemo.enabled";
    private static final int MSG_TURN_SCREEN_ON = 0;
    private static final int MSG_INACTIVITY_TIME_OUT = 1;
    private static final int MSG_START_NEW_SESSION = 2;
    private static final long SCREEN_WAKEUP_DELAY = 2500L;
    private static final long USER_INACTIVITY_TIMEOUT_MIN = 10000L;
    private static final long USER_INACTIVITY_TIMEOUT_DEFAULT = 90000L;
    private static final long WARNING_DIALOG_TIMEOUT_DEFAULT = 0L;
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final int[] VOLUME_STREAMS_TO_MUTE = new int[]{2, 3};
    private static final String DEMO_SESSION_COUNT = "retail_demo_session_count";
    private static final String DEMO_SESSION_DURATION = "retail_demo_session_duration";
    boolean mDeviceInDemoMode = false;
    int mCurrentUserId = 0;
    long mUserInactivityTimeout;
    long mWarningDialogTimeout;
    private ActivityManagerService mAms;
    private ActivityManagerInternal mAmi;
    private AudioManager mAudioManager;
    private NotificationManager mNm;
    private UserManager mUm;
    private PowerManager mPm;
    private PowerManager.WakeLock mWakeLock;
    Handler mHandler;
    private ServiceThread mHandlerThread;
    private PendingIntent mResetDemoPendingIntent;
    private CameraManager mCameraManager;
    private String[] mCameraIdsWithFlash;
    private Configuration mSystemUserConfiguration;
    private PreloadAppsInstaller mPreloadAppsInstaller;
    final Object mActivityLock = new Object();
    @GuardedBy(value="mActivityLock")
    boolean mUserUntouched;
    @GuardedBy(value="mActivityLock")
    long mFirstUserActivityTime;
    @GuardedBy(value="mActivityLock")
    long mLastUserActivityTime;
    private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (!RetailDemoModeService.this.mDeviceInDemoMode) {
                return;
            }
            switch (intent.getAction()) {
                case "android.intent.action.SCREEN_OFF": {
                    RetailDemoModeService.this.mHandler.removeMessages(0);
                    RetailDemoModeService.this.mHandler.sendEmptyMessageDelayed(0, 2500L);
                    break;
                }
                case "com.android.server.retaildemo.ACTION_RESET_DEMO": {
                    RetailDemoModeService.this.mHandler.sendEmptyMessage(2);
                }
            }
        }
    };
    private RetailDemoModeServiceInternal mLocalService = new RetailDemoModeServiceInternal(){
        private static final long USER_ACTIVITY_DEBOUNCE_TIME = 2000L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUserActivity() {
            if (!RetailDemoModeService.this.mDeviceInDemoMode) {
                return;
            }
            long timeOfActivity = SystemClock.uptimeMillis();
            Object object = RetailDemoModeService.this.mActivityLock;
            synchronized (object) {
                if (timeOfActivity < RetailDemoModeService.this.mLastUserActivityTime + 2000L) {
                    return;
                }
                RetailDemoModeService.this.mLastUserActivityTime = timeOfActivity;
                if (RetailDemoModeService.this.mUserUntouched && RetailDemoModeService.this.isDemoLauncherDisabled()) {
                    Slog.d(TAG, "retail_demo first touch");
                    RetailDemoModeService.this.mUserUntouched = false;
                    RetailDemoModeService.this.mFirstUserActivityTime = timeOfActivity;
                }
            }
            RetailDemoModeService.this.mHandler.removeMessages(1);
            RetailDemoModeService.this.mHandler.sendEmptyMessageDelayed(1, RetailDemoModeService.this.mUserInactivityTimeout);
        }
    };

    private void showInactivityCountdownDialog() {
        UserInactivityCountdownDialog dialog = new UserInactivityCountdownDialog(this.getContext(), this.mWarningDialogTimeout, 1000L);
        dialog.setNegativeButtonClickListener(null);
        dialog.setPositiveButtonClickListener(new DialogInterface.OnClickListener(){

            @Override
            public void onClick(DialogInterface dialog, int which) {
                RetailDemoModeService.this.mHandler.sendEmptyMessage(2);
            }
        });
        dialog.setOnCountDownExpiredListener(new UserInactivityCountdownDialog.OnCountDownExpiredListener(){

            @Override
            public void onCountDownExpired() {
                RetailDemoModeService.this.mHandler.sendEmptyMessage(2);
            }
        });
        dialog.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetailDemoModeService(Context context) {
        super(context);
        Object object = this.mActivityLock;
        synchronized (object) {
            this.mFirstUserActivityTime = this.mLastUserActivityTime = SystemClock.uptimeMillis();
        }
    }

    private Notification createResetNotification() {
        return new Notification.Builder(this.getContext()).setContentTitle(this.getContext().getString(17040884)).setContentText(this.getContext().getString(17040885)).setOngoing(true).setSmallIcon(17302868).setShowWhen(false).setVisibility(1).setContentIntent(this.getResetDemoPendingIntent()).setColor(this.getContext().getColor(17170523)).build();
    }

    private PendingIntent getResetDemoPendingIntent() {
        if (this.mResetDemoPendingIntent == null) {
            Intent intent = new Intent(ACTION_RESET_DEMO);
            this.mResetDemoPendingIntent = PendingIntent.getBroadcast(this.getContext(), 0, intent, 0);
        }
        return this.mResetDemoPendingIntent;
    }

    boolean isDemoLauncherDisabled() {
        IPackageManager pm = AppGlobals.getPackageManager();
        int enabledState = 0;
        String demoLauncherComponent = this.getContext().getResources().getString(17039474);
        try {
            enabledState = pm.getComponentEnabledSetting(ComponentName.unflattenFromString(demoLauncherComponent), this.mCurrentUserId);
        }
        catch (RemoteException exc) {
            Slog.e(TAG, "Unable to talk to Package Manager", exc);
        }
        return enabledState == 2;
    }

    private void setupDemoUser(UserInfo userInfo) {
        UserManager um = this.getUserManager();
        UserHandle user = UserHandle.of(userInfo.id);
        um.setUserRestriction("no_config_wifi", true, user);
        um.setUserRestriction("no_install_unknown_sources", true, user);
        um.setUserRestriction("no_config_mobile_networks", true, user);
        um.setUserRestriction("no_usb_file_transfer", true, user);
        um.setUserRestriction("no_modify_accounts", true, user);
        um.setUserRestriction("no_config_bluetooth", true, user);
        um.setUserRestriction("no_outgoing_calls", false, user);
        this.getUserManager().setUserRestriction("no_safe_boot", true, UserHandle.SYSTEM);
        Settings.Secure.putIntForUser(this.getContext().getContentResolver(), "skip_first_use_hints", 1, userInfo.id);
        Settings.Global.putInt(this.getContext().getContentResolver(), "package_verifier_enable", 0);
        this.grantRuntimePermissionToCamera(user);
        this.clearPrimaryCallLog();
    }

    private void grantRuntimePermissionToCamera(UserHandle user) {
        Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        PackageManager pm = this.getContext().getPackageManager();
        ResolveInfo handler = pm.resolveActivityAsUser(cameraIntent, 786432, user.getIdentifier());
        if (handler == null || handler.activityInfo == null) {
            return;
        }
        try {
            pm.grantRuntimePermission(handler.activityInfo.packageName, "android.permission.ACCESS_FINE_LOCATION", user);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void clearPrimaryCallLog() {
        ContentResolver resolver = this.getContext().getContentResolver();
        Uri uri = CallLog.Calls.CONTENT_URI;
        try {
            resolver.delete(uri, null, null);
        }
        catch (Exception e) {
            Slog.w(TAG, "Deleting call log failed: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logSessionDuration() {
        int sessionDuration;
        Object object = this.mActivityLock;
        synchronized (object) {
            sessionDuration = (int)((this.mLastUserActivityTime - this.mFirstUserActivityTime) / 1000L);
        }
        MetricsLogger.histogram(this.getContext(), DEMO_SESSION_DURATION, sessionDuration);
    }

    private ActivityManagerService getActivityManager() {
        if (this.mAms == null) {
            this.mAms = (ActivityManagerService)ActivityManagerNative.getDefault();
        }
        return this.mAms;
    }

    private UserManager getUserManager() {
        if (this.mUm == null) {
            this.mUm = this.getContext().getSystemService(UserManager.class);
        }
        return this.mUm;
    }

    private AudioManager getAudioManager() {
        if (this.mAudioManager == null) {
            this.mAudioManager = this.getContext().getSystemService(AudioManager.class);
        }
        return this.mAudioManager;
    }

    private boolean isDeviceProvisioned() {
        return Settings.Global.getInt(this.getContext().getContentResolver(), "device_provisioned", 0) != 0;
    }

    private boolean deletePreloadsFolderContents() {
        File dir = Environment.getDataPreloadsDirectory();
        Slog.i(TAG, "Deleting contents of " + dir);
        return FileUtils.deleteContents(dir);
    }

    private void registerBroadcastReceiver() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction(ACTION_RESET_DEMO);
        this.getContext().registerReceiver(this.mBroadcastReceiver, filter);
    }

    private String[] getCameraIdsWithFlash() {
        ArrayList<String> cameraIdsList = new ArrayList<String>();
        try {
            for (String cameraId : this.mCameraManager.getCameraIdList()) {
                CameraCharacteristics c = this.mCameraManager.getCameraCharacteristics(cameraId);
                if (!Boolean.TRUE.equals(c.get(CameraCharacteristics.FLASH_INFO_AVAILABLE))) continue;
                cameraIdsList.add(cameraId);
            }
        }
        catch (CameraAccessException e) {
            Slog.e(TAG, "Unable to access camera while getting camera id list", e);
        }
        return cameraIdsList.toArray(new String[cameraIdsList.size()]);
    }

    private void turnOffAllFlashLights() {
        for (String cameraId : this.mCameraIdsWithFlash) {
            try {
                this.mCameraManager.setTorchMode(cameraId, false);
            }
            catch (CameraAccessException e) {
                Slog.e(TAG, "Unable to access camera " + cameraId + " while turning off flash", e);
            }
        }
    }

    private void muteVolumeStreams() {
        for (int stream : VOLUME_STREAMS_TO_MUTE) {
            this.getAudioManager().setStreamVolume(stream, this.getAudioManager().getStreamMinVolume(stream), 0);
        }
    }

    private Configuration getSystemUsersConfiguration() {
        if (this.mSystemUserConfiguration == null) {
            this.mSystemUserConfiguration = new Configuration();
            Settings.System.getConfiguration(this.getContext().getContentResolver(), this.mSystemUserConfiguration);
        }
        return this.mSystemUserConfiguration;
    }

    private void putDeviceInDemoMode() {
        SystemProperties.set(SYSTEM_PROPERTY_RETAIL_DEMO_ENABLED, "1");
        this.mHandler.sendEmptyMessage(2);
    }

    @Override
    public void onStart() {
        this.mHandlerThread = new ServiceThread(TAG, -2, false);
        this.mHandlerThread.start();
        this.mHandler = new MainHandler(this.mHandlerThread.getLooper());
        this.publishLocalService(RetailDemoModeServiceInternal.class, this.mLocalService);
    }

    @Override
    public void onBootPhase(int bootPhase) {
        switch (bootPhase) {
            case 600: {
                this.mPreloadAppsInstaller = new PreloadAppsInstaller(this.getContext());
                this.mPm = (PowerManager)this.getContext().getSystemService("power");
                this.mAmi = LocalServices.getService(ActivityManagerInternal.class);
                this.mWakeLock = this.mPm.newWakeLock(0x1000001A, TAG);
                this.mNm = NotificationManager.from(this.getContext());
                this.mCameraManager = (CameraManager)this.getContext().getSystemService("camera");
                this.mCameraIdsWithFlash = this.getCameraIdsWithFlash();
                SettingsObserver settingsObserver = new SettingsObserver(this.mHandler);
                settingsObserver.register();
                settingsObserver.refreshTimeoutConstants();
                this.registerBroadcastReceiver();
                break;
            }
            case 1000: {
                if (!UserManager.isDeviceInDemoMode(this.getContext())) break;
                this.mDeviceInDemoMode = true;
                this.putDeviceInDemoMode();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSwitchUser(final int userId) {
        if (!this.mDeviceInDemoMode) {
            return;
        }
        UserInfo ui = this.getUserManager().getUserInfo(userId);
        if (!ui.isDemo()) {
            Slog.wtf(TAG, "Should not allow switch to non-demo user in demo mode");
            return;
        }
        if (!this.mWakeLock.isHeld()) {
            this.mWakeLock.acquire();
        }
        this.mCurrentUserId = userId;
        this.mAmi.updatePersistentConfigurationForUser(this.getSystemUsersConfiguration(), userId);
        this.turnOffAllFlashLights();
        this.muteVolumeStreams();
        LockPatternUtils lockPatternUtils = new LockPatternUtils(this.getContext());
        lockPatternUtils.setLockScreenDisabled(true, userId);
        this.mNm.notifyAsUser(TAG, 1, this.createResetNotification(), UserHandle.of(userId));
        Object object = this.mActivityLock;
        synchronized (object) {
            this.mUserUntouched = true;
        }
        MetricsLogger.count(this.getContext(), DEMO_SESSION_COUNT, 1);
        this.mHandler.removeMessages(1);
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                RetailDemoModeService.this.mPreloadAppsInstaller.installApps(userId);
            }
        });
    }

    private class SettingsObserver
    extends ContentObserver {
        private static final String KEY_USER_INACTIVITY_TIMEOUT = "user_inactivity_timeout_ms";
        private static final String KEY_WARNING_DIALOG_TIMEOUT = "warning_dialog_timeout_ms";
        private final Uri mDeviceDemoModeUri;
        private final Uri mDeviceProvisionedUri;
        private final Uri mRetailDemoConstantsUri;
        private final KeyValueListParser mParser;

        public SettingsObserver(Handler handler) {
            super(handler);
            this.mDeviceDemoModeUri = Settings.Global.getUriFor("device_demo_mode");
            this.mDeviceProvisionedUri = Settings.Global.getUriFor("device_provisioned");
            this.mRetailDemoConstantsUri = Settings.Global.getUriFor("retail_demo_mode_constants");
            this.mParser = new KeyValueListParser(',');
        }

        public void register() {
            ContentResolver cr = RetailDemoModeService.this.getContext().getContentResolver();
            cr.registerContentObserver(this.mDeviceDemoModeUri, false, this, 0);
            cr.registerContentObserver(this.mDeviceProvisionedUri, false, this, 0);
            cr.registerContentObserver(this.mRetailDemoConstantsUri, false, this, 0);
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            if (this.mRetailDemoConstantsUri.equals(uri)) {
                this.refreshTimeoutConstants();
                return;
            }
            if (this.mDeviceDemoModeUri.equals(uri)) {
                RetailDemoModeService.this.mDeviceInDemoMode = UserManager.isDeviceInDemoMode(RetailDemoModeService.this.getContext());
                if (RetailDemoModeService.this.mDeviceInDemoMode) {
                    RetailDemoModeService.this.putDeviceInDemoMode();
                } else {
                    SystemProperties.set(RetailDemoModeService.SYSTEM_PROPERTY_RETAIL_DEMO_ENABLED, "0");
                    if (RetailDemoModeService.this.mWakeLock.isHeld()) {
                        RetailDemoModeService.this.mWakeLock.release();
                    }
                }
            }
            if (!RetailDemoModeService.this.mDeviceInDemoMode && RetailDemoModeService.this.isDeviceProvisioned()) {
                BackgroundThread.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        if (!RetailDemoModeService.this.deletePreloadsFolderContents()) {
                            Slog.w(TAG, "Failed to delete preloads folder contents");
                        }
                    }
                });
            }
        }

        private void refreshTimeoutConstants() {
            try {
                this.mParser.setString(Settings.Global.getString(RetailDemoModeService.this.getContext().getContentResolver(), "retail_demo_mode_constants"));
            }
            catch (IllegalArgumentException exc) {
                Slog.e(TAG, "Invalid string passed to KeyValueListParser");
            }
            RetailDemoModeService.this.mWarningDialogTimeout = this.mParser.getLong(KEY_WARNING_DIALOG_TIMEOUT, 0L);
            RetailDemoModeService.this.mUserInactivityTimeout = this.mParser.getLong(KEY_USER_INACTIVITY_TIMEOUT, 90000L);
            RetailDemoModeService.this.mUserInactivityTimeout = Math.max(RetailDemoModeService.this.mUserInactivityTimeout, 10000L);
        }
    }

    final class MainHandler
    extends Handler {
        MainHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    if (RetailDemoModeService.this.mWakeLock.isHeld()) {
                        RetailDemoModeService.this.mWakeLock.release();
                    }
                    RetailDemoModeService.this.mWakeLock.acquire();
                    break;
                }
                case 1: {
                    if (!RetailDemoModeService.this.isDemoLauncherDisabled()) break;
                    Slog.i(TAG, "User inactivity timeout reached");
                    RetailDemoModeService.this.showInactivityCountdownDialog();
                    break;
                }
                case 2: {
                    UserInfo demoUser;
                    this.removeMessages(2);
                    this.removeMessages(1);
                    if (RetailDemoModeService.this.mCurrentUserId != 0) {
                        RetailDemoModeService.this.logSessionDuration();
                    }
                    if ((demoUser = RetailDemoModeService.this.getUserManager().createUser(RetailDemoModeService.DEMO_USER_NAME, 768)) == null) break;
                    RetailDemoModeService.this.setupDemoUser(demoUser);
                    RetailDemoModeService.this.getActivityManager().switchUser(demoUser.id);
                }
            }
        }
    }
}

