/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.retaildemo;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.CountDownTimer;
import android.view.WindowManager;
import android.widget.TextView;

public class UserInactivityCountdownDialog
extends AlertDialog {
    private OnCountDownExpiredListener mOnCountDownExpiredListener;
    private CountDownTimer mCountDownTimer;
    private long mCountDownDuration;
    private long mRefreshInterval;

    UserInactivityCountdownDialog(Context context, long duration, long refreshInterval) {
        super(context);
        this.mCountDownDuration = duration;
        this.mRefreshInterval = refreshInterval;
        this.getWindow().setType(2010);
        WindowManager.LayoutParams attrs = this.getWindow().getAttributes();
        attrs.privateFlags = 16;
        this.getWindow().setAttributes(attrs);
        this.setTitle(17040888);
        this.setMessage(this.getContext().getString(17040889, duration));
    }

    public void setOnCountDownExpiredListener(OnCountDownExpiredListener onCountDownExpiredListener) {
        this.mOnCountDownExpiredListener = onCountDownExpiredListener;
    }

    public void setPositiveButtonClickListener(DialogInterface.OnClickListener onClickListener) {
        this.setButton(-1, (CharSequence)this.getContext().getString(17040891), onClickListener);
    }

    public void setNegativeButtonClickListener(DialogInterface.OnClickListener onClickListener) {
        this.setButton(-2, (CharSequence)this.getContext().getString(17040890), onClickListener);
    }

    @Override
    public void show() {
        super.show();
        final TextView messageView = (TextView)this.findViewById(16908299);
        messageView.post(new Runnable(){

            @Override
            public void run() {
                UserInactivityCountdownDialog.this.mCountDownTimer = new CountDownTimer(UserInactivityCountdownDialog.this.mCountDownDuration, UserInactivityCountdownDialog.this.mRefreshInterval){

                    @Override
                    public void onTick(long millisUntilFinished) {
                        String msg = UserInactivityCountdownDialog.this.getContext().getString(17040889, millisUntilFinished / 1000L);
                        messageView.setText(msg);
                    }

                    @Override
                    public void onFinish() {
                        UserInactivityCountdownDialog.this.dismiss();
                        if (UserInactivityCountdownDialog.this.mOnCountDownExpiredListener != null) {
                            UserInactivityCountdownDialog.this.mOnCountDownExpiredListener.onCountDownExpired();
                        }
                    }
                }.start();
            }
        });
    }

    @Override
    public void onStop() {
        if (this.mCountDownTimer != null) {
            this.mCountDownTimer.cancel();
        }
    }

    static interface OnCountDownExpiredListener {
        public void onCountDownExpired();
    }
}

