/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.updates;

import android.content.Context;
import android.content.Intent;
import android.os.SystemProperties;
import android.system.ErrnoException;
import android.system.Os;
import android.util.Base64;
import android.util.Slog;
import com.android.server.updates.ConfigUpdateInstallReceiver;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import libcore.io.IoUtils;

public class SELinuxPolicyInstallReceiver
extends ConfigUpdateInstallReceiver {
    private static final String TAG = "SELinuxPolicyInstallReceiver";
    private static final String sepolicyPath = "sepolicy";
    private static final String fileContextsPath = "file_contexts.bin";
    private static final String propertyContextsPath = "property_contexts";
    private static final String seappContextsPath = "seapp_contexts";
    private static final String versionPath = "selinux_version";
    private static final String macPermissionsPath = "mac_permissions.xml";
    private static final String serviceContextsPath = "service_contexts";

    public SELinuxPolicyInstallReceiver() {
        super("/data/security/bundle", "sepolicy_bundle", "metadata/", "version");
    }

    private int readInt(BufferedInputStream reader) throws IOException {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            value = value << 8 | reader.read();
        }
        return value;
    }

    private int[] readChunkLengths(BufferedInputStream bundle) throws IOException {
        int[] chunks = new int[]{this.readInt(bundle), this.readInt(bundle), this.readInt(bundle), this.readInt(bundle), this.readInt(bundle), this.readInt(bundle), this.readInt(bundle)};
        return chunks;
    }

    private void installFile(File destination, BufferedInputStream stream, int length) throws IOException {
        byte[] chunk = new byte[length];
        stream.read(chunk, 0, length);
        this.writeUpdate(this.updateDir, destination, Base64.decode(chunk, 0));
    }

    private void deleteRecursive(File fileOrDirectory) {
        if (fileOrDirectory.isDirectory()) {
            for (File child : fileOrDirectory.listFiles()) {
                this.deleteRecursive(child);
            }
        }
        fileOrDirectory.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackBundle() throws IOException {
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(this.updateContent));
        File tmp = new File(this.updateDir.getParentFile(), "tmp");
        try {
            int[] chunkLengths = this.readChunkLengths(stream);
            this.deleteRecursive(tmp);
            tmp.mkdirs();
            this.installFile(new File(tmp, versionPath), stream, chunkLengths[0]);
            this.installFile(new File(tmp, macPermissionsPath), stream, chunkLengths[1]);
            this.installFile(new File(tmp, seappContextsPath), stream, chunkLengths[2]);
            this.installFile(new File(tmp, propertyContextsPath), stream, chunkLengths[3]);
            this.installFile(new File(tmp, fileContextsPath), stream, chunkLengths[4]);
            this.installFile(new File(tmp, sepolicyPath), stream, chunkLengths[5]);
            this.installFile(new File(tmp, serviceContextsPath), stream, chunkLengths[6]);
        }
        finally {
            IoUtils.closeQuietly(stream);
        }
    }

    private void applyUpdate() throws IOException, ErrnoException {
        block3: {
            Slog.i(TAG, "Applying SELinux policy");
            File backup = new File(this.updateDir.getParentFile(), "backup");
            File current = new File(this.updateDir.getParentFile(), "current");
            File tmp = new File(this.updateDir.getParentFile(), "tmp");
            if (current.exists()) {
                this.deleteRecursive(backup);
                Os.rename(current.getPath(), backup.getPath());
            }
            try {
                Os.rename(tmp.getPath(), current.getPath());
                SystemProperties.set("selinux.reload_policy", "1");
            }
            catch (ErrnoException e) {
                Slog.e(TAG, "Could not update selinux policy: ", e);
                if (!backup.exists()) break block3;
                Os.rename(backup.getPath(), current.getPath());
            }
        }
    }

    @Override
    protected void postInstall(Context context, Intent intent) {
        try {
            this.unpackBundle();
            this.applyUpdate();
        }
        catch (IllegalArgumentException e) {
            Slog.e(TAG, "SELinux policy update malformed: ", e);
        }
        catch (IOException e) {
            Slog.e(TAG, "Could not update selinux policy: ", e);
        }
        catch (ErrnoException e) {
            Slog.e(TAG, "Could not update selinux policy: ", e);
        }
    }
}

