/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb;

import android.content.Context;
import android.hardware.usb.UsbConfiguration;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.usb.UsbAlsaManager;
import com.android.server.usb.UsbSettingsManager;
import java.util.ArrayList;
import java.util.HashMap;

public class UsbHostManager {
    private static final String TAG = UsbHostManager.class.getSimpleName();
    private static final boolean DEBUG = false;
    private final HashMap<String, UsbDevice> mDevices = new HashMap();
    private final String[] mHostBlacklist;
    private final Context mContext;
    private final Object mLock = new Object();
    private UsbDevice mNewDevice;
    private UsbConfiguration mNewConfiguration;
    private UsbInterface mNewInterface;
    private ArrayList<UsbConfiguration> mNewConfigurations;
    private ArrayList<UsbInterface> mNewInterfaces;
    private ArrayList<UsbEndpoint> mNewEndpoints;
    private final UsbAlsaManager mUsbAlsaManager;
    @GuardedBy(value="mLock")
    private UsbSettingsManager mCurrentSettings;

    public UsbHostManager(Context context, UsbAlsaManager alsaManager) {
        this.mContext = context;
        this.mHostBlacklist = context.getResources().getStringArray(17235997);
        this.mUsbAlsaManager = alsaManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentSettings(UsbSettingsManager settings) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCurrentSettings = settings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UsbSettingsManager getCurrentSettings() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCurrentSettings;
        }
    }

    private boolean isBlackListed(String deviceName) {
        int count = this.mHostBlacklist.length;
        for (int i = 0; i < count; ++i) {
            if (!deviceName.startsWith(this.mHostBlacklist[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isBlackListed(int clazz, int subClass, int protocol) {
        if (clazz == 9) {
            return true;
        }
        return clazz == 3 && subClass == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean beginUsbDeviceAdded(String deviceName, int vendorID, int productID, int deviceClass, int deviceSubclass, int deviceProtocol, String manufacturerName, String productName, int version, String serialNumber) {
        if (this.isBlackListed(deviceName) || this.isBlackListed(deviceClass, deviceSubclass, deviceProtocol)) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDevices.get(deviceName) != null) {
                Slog.w(TAG, "device already on mDevices list: " + deviceName);
                return false;
            }
            if (this.mNewDevice != null) {
                Slog.e(TAG, "mNewDevice is not null in endUsbDeviceAdded");
                return false;
            }
            String versionString = Integer.toString(version >> 8) + "." + (version & 0xFF);
            this.mNewDevice = new UsbDevice(deviceName, vendorID, productID, deviceClass, deviceSubclass, deviceProtocol, manufacturerName, productName, versionString, serialNumber);
            this.mNewConfigurations = new ArrayList();
            this.mNewInterfaces = new ArrayList();
            this.mNewEndpoints = new ArrayList();
        }
        return true;
    }

    private void addUsbConfiguration(int id2, String name, int attributes, int maxPower) {
        if (this.mNewConfiguration != null) {
            this.mNewConfiguration.setInterfaces(this.mNewInterfaces.toArray(new UsbInterface[this.mNewInterfaces.size()]));
            this.mNewInterfaces.clear();
        }
        this.mNewConfiguration = new UsbConfiguration(id2, name, attributes, maxPower);
        this.mNewConfigurations.add(this.mNewConfiguration);
    }

    private void addUsbInterface(int id2, String name, int altSetting, int Class2, int subClass, int protocol) {
        if (this.mNewInterface != null) {
            this.mNewInterface.setEndpoints(this.mNewEndpoints.toArray(new UsbEndpoint[this.mNewEndpoints.size()]));
            this.mNewEndpoints.clear();
        }
        this.mNewInterface = new UsbInterface(id2, altSetting, name, Class2, subClass, protocol);
        this.mNewInterfaces.add(this.mNewInterface);
    }

    private void addUsbEndpoint(int address, int attributes, int maxPacketSize, int interval) {
        this.mNewEndpoints.add(new UsbEndpoint(address, attributes, maxPacketSize, interval));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endUsbDeviceAdded() {
        if (this.mNewInterface != null) {
            this.mNewInterface.setEndpoints(this.mNewEndpoints.toArray(new UsbEndpoint[this.mNewEndpoints.size()]));
        }
        if (this.mNewConfiguration != null) {
            this.mNewConfiguration.setInterfaces(this.mNewInterfaces.toArray(new UsbInterface[this.mNewInterfaces.size()]));
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mNewDevice != null) {
                this.mNewDevice.setConfigurations(this.mNewConfigurations.toArray(new UsbConfiguration[this.mNewConfigurations.size()]));
                this.mDevices.put(this.mNewDevice.getDeviceName(), this.mNewDevice);
                Slog.d(TAG, "Added device " + this.mNewDevice);
                this.getCurrentSettings().deviceAttached(this.mNewDevice);
                this.mUsbAlsaManager.usbDeviceAdded(this.mNewDevice);
            } else {
                Slog.e(TAG, "mNewDevice is null in endUsbDeviceAdded");
            }
            this.mNewDevice = null;
            this.mNewConfigurations = null;
            this.mNewInterfaces = null;
            this.mNewEndpoints = null;
            this.mNewConfiguration = null;
            this.mNewInterface = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void usbDeviceRemoved(String deviceName) {
        Object object = this.mLock;
        synchronized (object) {
            UsbDevice device = this.mDevices.remove(deviceName);
            if (device != null) {
                this.mUsbAlsaManager.usbDeviceRemoved(device);
                this.getCurrentSettings().deviceDetached(device);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady() {
        Object object = this.mLock;
        synchronized (object) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    UsbHostManager.this.monitorUsbHostBus();
                }
            };
            new Thread(null, runnable, "UsbService host thread").start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDeviceList(Bundle devices) {
        Object object = this.mLock;
        synchronized (object) {
            for (String name : this.mDevices.keySet()) {
                devices.putParcelable(name, this.mDevices.get(name));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParcelFileDescriptor openDevice(String deviceName) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isBlackListed(deviceName)) {
                throw new SecurityException("USB device is on a restricted bus");
            }
            UsbDevice device = this.mDevices.get(deviceName);
            if (device == null) {
                throw new IllegalArgumentException("device " + deviceName + " does not exist or is restricted");
            }
            this.getCurrentSettings().checkPermission(device);
            return this.nativeOpenDevice(deviceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(IndentingPrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            pw.println("USB Host State:");
            for (String name : this.mDevices.keySet()) {
                pw.println("  " + name + ": " + this.mDevices.get(name));
            }
        }
    }

    private native void monitorUsbHostBus();

    private native ParcelFileDescriptor nativeOpenDevice(String var1);
}

