/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb;

import android.content.Context;
import android.media.midi.MidiDeviceInfo;
import android.media.midi.MidiDeviceServer;
import android.media.midi.MidiDeviceStatus;
import android.media.midi.MidiManager;
import android.media.midi.MidiReceiver;
import android.os.Bundle;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructPollfd;
import android.util.Log;
import com.android.internal.midi.MidiEventScheduler;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import libcore.io.IoUtils;

public final class UsbMidiDevice
implements Closeable {
    private static final String TAG = "UsbMidiDevice";
    private final int mAlsaCard;
    private final int mAlsaDevice;
    private final int mSubdeviceCount;
    private final InputReceiverProxy[] mInputPortReceivers;
    private MidiDeviceServer mServer;
    private MidiEventScheduler[] mEventSchedulers;
    private static final int BUFFER_SIZE = 512;
    private FileDescriptor[] mFileDescriptors;
    private StructPollfd[] mPollFDs;
    private FileInputStream[] mInputStreams;
    private FileOutputStream[] mOutputStreams;
    private final Object mLock = new Object();
    private boolean mIsOpen;
    private int mPipeFD = -1;
    private final MidiDeviceServer.Callback mCallback = new MidiDeviceServer.Callback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDeviceStatusChanged(MidiDeviceServer server, MidiDeviceStatus status) {
            int i;
            MidiDeviceInfo deviceInfo = status.getDeviceInfo();
            int inputPorts = deviceInfo.getInputPortCount();
            int outputPorts = deviceInfo.getOutputPortCount();
            boolean hasOpenPorts = false;
            for (i = 0; i < inputPorts; ++i) {
                if (!status.isInputPortOpen(i)) continue;
                hasOpenPorts = true;
                break;
            }
            if (!hasOpenPorts) {
                for (i = 0; i < outputPorts; ++i) {
                    if (status.getOutputPortOpenCount(i) <= 0) continue;
                    hasOpenPorts = true;
                    break;
                }
            }
            Object object = UsbMidiDevice.this.mLock;
            synchronized (object) {
                if (hasOpenPorts && !UsbMidiDevice.this.mIsOpen) {
                    UsbMidiDevice.this.openLocked();
                } else if (!hasOpenPorts && UsbMidiDevice.this.mIsOpen) {
                    UsbMidiDevice.this.closeLocked();
                }
            }
        }

        @Override
        public void onClose() {
        }
    };

    public static UsbMidiDevice create(Context context, Bundle properties, int card, int device) {
        int subDeviceCount = UsbMidiDevice.nativeGetSubdeviceCount(card, device);
        if (subDeviceCount <= 0) {
            Log.e(TAG, "nativeGetSubdeviceCount failed");
            return null;
        }
        UsbMidiDevice midiDevice = new UsbMidiDevice(card, device, subDeviceCount);
        if (!midiDevice.register(context, properties)) {
            IoUtils.closeQuietly(midiDevice);
            Log.e(TAG, "createDeviceServer failed");
            return null;
        }
        return midiDevice;
    }

    private UsbMidiDevice(int card, int device, int subdeviceCount) {
        this.mAlsaCard = card;
        this.mAlsaDevice = device;
        this.mSubdeviceCount = subdeviceCount;
        int inputCount = subdeviceCount;
        this.mInputPortReceivers = new InputReceiverProxy[inputCount];
        for (int port = 0; port < inputCount; ++port) {
            this.mInputPortReceivers[port] = new InputReceiverProxy();
        }
    }

    private boolean openLocked() {
        int i;
        FileDescriptor[] fileDescriptors = this.nativeOpen(this.mAlsaCard, this.mAlsaDevice, this.mSubdeviceCount);
        if (fileDescriptors == null) {
            Log.e(TAG, "nativeOpen failed");
            return false;
        }
        this.mFileDescriptors = fileDescriptors;
        int inputCount = fileDescriptors.length;
        int outputCount = fileDescriptors.length - 1;
        this.mPollFDs = new StructPollfd[inputCount];
        this.mInputStreams = new FileInputStream[inputCount];
        for (i = 0; i < inputCount; ++i) {
            FileDescriptor fd = fileDescriptors[i];
            StructPollfd pollfd = new StructPollfd();
            pollfd.fd = fd;
            pollfd.events = (short)OsConstants.POLLIN;
            this.mPollFDs[i] = pollfd;
            this.mInputStreams[i] = new FileInputStream(fd);
        }
        this.mOutputStreams = new FileOutputStream[outputCount];
        this.mEventSchedulers = new MidiEventScheduler[outputCount];
        for (i = 0; i < outputCount; ++i) {
            MidiEventScheduler scheduler;
            this.mOutputStreams[i] = new FileOutputStream(fileDescriptors[i]);
            this.mEventSchedulers[i] = scheduler = new MidiEventScheduler();
            this.mInputPortReceivers[i].setReceiver(scheduler.getReceiver());
        }
        final MidiReceiver[] outputReceivers = this.mServer.getOutputPortReceivers();
        new Thread("UsbMidiDevice input thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                byte[] buffer = new byte[512];
                try {
                    while (true) {
                        long timestamp = System.nanoTime();
                        Object object = UsbMidiDevice.this.mLock;
                        synchronized (object) {
                            if (!UsbMidiDevice.this.mIsOpen) {
                                break;
                            }
                            for (int index = 0; index < UsbMidiDevice.this.mPollFDs.length; ++index) {
                                StructPollfd pfd = UsbMidiDevice.this.mPollFDs[index];
                                if ((pfd.revents & (OsConstants.POLLERR | OsConstants.POLLHUP)) != 0) break;
                                if ((pfd.revents & OsConstants.POLLIN) == 0) continue;
                                pfd.revents = 0;
                                if (index == UsbMidiDevice.this.mInputStreams.length - 1) break;
                                int count = UsbMidiDevice.this.mInputStreams[index].read(buffer);
                                outputReceivers[index].send(buffer, 0, count, timestamp);
                            }
                        }
                        Os.poll(UsbMidiDevice.this.mPollFDs, -1);
                    }
                }
                catch (IOException e) {
                    Log.d(UsbMidiDevice.TAG, "reader thread exiting");
                }
                catch (ErrnoException e) {
                    Log.d(UsbMidiDevice.TAG, "reader thread exiting");
                }
                Log.d(UsbMidiDevice.TAG, "input thread exit");
            }
        }.start();
        for (int port = 0; port < outputCount; ++port) {
            final MidiEventScheduler eventSchedulerF = this.mEventSchedulers[port];
            final FileOutputStream outputStreamF = this.mOutputStreams[port];
            final int portF = port;
            new Thread("UsbMidiDevice output thread " + port){

                @Override
                public void run() {
                    while (true) {
                        MidiEventScheduler.MidiEvent event;
                        try {
                            event = (MidiEventScheduler.MidiEvent)eventSchedulerF.waitNextEvent();
                        }
                        catch (InterruptedException e) {
                            continue;
                        }
                        if (event == null) break;
                        try {
                            outputStreamF.write(event.data, 0, event.count);
                        }
                        catch (IOException e) {
                            Log.e(UsbMidiDevice.TAG, "write failed for port " + portF);
                        }
                        eventSchedulerF.addEventToPool(event);
                    }
                    Log.d(UsbMidiDevice.TAG, "output thread exit");
                }
            }.start();
        }
        this.mIsOpen = true;
        return true;
    }

    private boolean register(Context context, Bundle properties) {
        MidiManager midiManager = (MidiManager)context.getSystemService("midi");
        if (midiManager == null) {
            Log.e(TAG, "No MidiManager in UsbMidiDevice.create()");
            return false;
        }
        this.mServer = midiManager.createDeviceServer(this.mInputPortReceivers, this.mSubdeviceCount, null, null, properties, 1, this.mCallback);
        return this.mServer != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsOpen) {
                this.closeLocked();
            }
        }
        if (this.mServer != null) {
            IoUtils.closeQuietly(this.mServer);
        }
    }

    private void closeLocked() {
        int i;
        for (i = 0; i < this.mEventSchedulers.length; ++i) {
            this.mInputPortReceivers[i].setReceiver(null);
            this.mEventSchedulers[i].close();
        }
        this.mEventSchedulers = null;
        for (i = 0; i < this.mInputStreams.length; ++i) {
            IoUtils.closeQuietly(this.mInputStreams[i]);
        }
        this.mInputStreams = null;
        for (i = 0; i < this.mOutputStreams.length; ++i) {
            IoUtils.closeQuietly(this.mOutputStreams[i]);
        }
        this.mOutputStreams = null;
        this.nativeClose(this.mFileDescriptors);
        this.mFileDescriptors = null;
        this.mIsOpen = false;
    }

    private static native int nativeGetSubdeviceCount(int var0, int var1);

    private native FileDescriptor[] nativeOpen(int var1, int var2, int var3);

    private native void nativeClose(FileDescriptor[] var1);

    private final class InputReceiverProxy
    extends MidiReceiver {
        private MidiReceiver mReceiver;

        private InputReceiverProxy() {
        }

        @Override
        public void onSend(byte[] msg, int offset, int count, long timestamp) throws IOException {
            MidiReceiver receiver = this.mReceiver;
            if (receiver != null) {
                receiver.send(msg, offset, count, timestamp);
            }
        }

        public void setReceiver(MidiReceiver receiver) {
            this.mReceiver = receiver;
        }

        @Override
        public void onFlush() throws IOException {
            MidiReceiver receiver = this.mReceiver;
            if (receiver != null) {
                receiver.flush();
            }
        }
    }
}

